/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.scheme.Confidence;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.IGDUnitClass;

public class IGDAge {
    private Double age;
    private int refUnitID;
    private int refPercent = 100;
    private Confidence confidence = Confidence.CONFIDENT;

    public IGDAge(int refUnitID, int refPercent, Double age, Confidence conf) {
        this.refUnitID = refUnitID;
        this.refPercent = refPercent;
        this.age = age;
        this.confidence = conf;
    }

    public IGDAge(Double age) {
        this.age = age;
    }

    IGDAge(IGDAge rhs) {
        this.age = rhs.age;
        this.refUnitID = rhs.refUnitID;
        this.refPercent = rhs.refPercent;
        this.confidence = rhs.confidence;
    }

    public Double getAge() {
        if (this.age != null && this.age < 0.0) assert (false);
        return this.age;
    }

    void setAge(Double age) {
        if (this.refUnitID > 0) assert (false);
        this.age = age;
    }

    void setRef(int unitID) {
        if (unitID < 0) {
            assert (false);
            unitID = 0;
        }
        if (this.refUnitID != unitID) {
            this.age = -1.0;
            this.refUnitID = unitID;
        }
    }

    void setPercent(int percent) {
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.refPercent = percent;
    }

    public int getPercent() {
        return this.refPercent;
    }

    public int getRefID() {
        return this.refUnitID;
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    public void calcAge(IGDScheme parentScheme, IGDScheme thisScheme) throws SQLException {
        if (this.refUnitID < 0) assert (false);
        if (this.refUnitID > 0) {
            assert (parentScheme.getIGDType() == 3 || parentScheme.getIGDType() == 10);
            IGDUnit unit = parentScheme.findUnit(this.refUnitID);
            if (unit == null && (unit = thisScheme.findUnit(this.refUnitID)) == null) {
                throw new IllegalStateException("IGDAge reference unit not in own or parent scheme");
            }
            this.calcAge(unit);
        }
    }

    public void calcAge(IGDUnitClass ref) {
        if (ref instanceof IGDUnitBase && ((IGDUnitBase)ref).getUnitID() != this.refUnitID) {
            throw new IllegalStateException();
        }
        this.age = ref.getUage();
        this.age = this.age == null ? Double.valueOf(0.0) : Double.valueOf(this.age + (ref.getLage() - ref.getUage()) * (this.refPercent > 0 ? (double)this.refPercent / 100.0 : 0.0));
    }

    public void calcAge(List<IGDUnitBase> scheme) {
        if (this.refUnitID < 0) assert (false);
        if (this.refUnitID > 0) {
            for (IGDUnitBase base : scheme) {
                if (base.getUnitID() != this.refUnitID) continue;
                this.calcAge(base);
                return;
            }
        }
    }

    public String getSQLInsert(String prefix) {
        return prefix + "unit_ref=" + String.valueOf(this.refUnitID > 0 ? Integer.valueOf(this.refUnitID) : "NULL") + "," + prefix + "unit_val=" + String.valueOf(this.refUnitID > 0 ? Integer.valueOf(this.refPercent) : "NULL") + "," + prefix + "age=" + this.age + "," + prefix + "conf=" + this.confidence.getDBint();
    }

    public static String sqlFieldString(String prefix) {
        return prefix + "unit_ref," + prefix + "unit_val," + prefix + "age," + prefix + "conf";
    }

    public String sqlValueString() {
        return String.valueOf(this.refUnitID > 0 ? Integer.valueOf(this.refUnitID) : "NULL") + "," + String.valueOf(this.refUnitID > 0 ? Integer.valueOf(this.refPercent) : "NULL") + "," + this.age + "," + this.confidence.getDBint();
    }

    static IGDAge parseRS(ResultSet rs, String prefix) throws SQLException {
        int refUnitID = rs.getInt(prefix + "unit_ref");
        int refPercent = rs.getInt(prefix + "unit_val");
        Double age = rs.getDouble(prefix + "age");
        if (rs.wasNull()) {
            age = null;
        }
        Confidence confidence = Confidence.getConfidence((int)rs.getInt(prefix + "conf"));
        return new IGDAge(refUnitID, refPercent, age, confidence);
    }

    public boolean nullEquals(Object o) {
        if (this.age == null) {
            if (o instanceof IGDAge) {
                IGDAge comp = (IGDAge)o;
                return comp.age == null;
            }
        } else if (o instanceof IGDAge) {
            IGDAge comp = (IGDAge)o;
            if (comp.age != null) {
                return this.equals(comp);
            }
            return false;
        }
        return false;
    }

    public boolean equals(Object o) {
        double age1;
        double d = age1 = this.age != null ? this.age : 0.0;
        if (o instanceof IGDAge) {
            IGDAge comp = (IGDAge)o;
            double age2 = comp.age != null ? comp.age : 0.0;
            return Math.abs(age1 - age2) < 1.0E-4 && this.refUnitID == comp.refUnitID && this.refPercent == comp.refPercent && this.confidence == comp.confidence;
        }
        return false;
    }
}

