/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import model3.LithInterval;
import model3.Lithology;
import model3.SBdb;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public abstract class LithBase
implements SbugsStatus,
SortEntry,
Comparable {
    private final SBdb sbdb;
    double topDepth;
    Lithology desc = null;
    Color status = UNKNOWN;

    public Color getStatus() {
        return this.status;
    }

    LithBase(SBdb SB2) {
        this.sbdb = SB2;
    }

    LithBase(SBdb db, LithBase rhs) {
        this.sbdb = db;
        this.desc = rhs.desc;
        this.topDepth = rhs.topDepth;
        this.status = rhs.status;
    }

    LithBase(LithBase rhs, SBdb SB2) throws SQLException, SBException {
        this.sbdb = SB2;
        this.topDepth = rhs.topDepth;
        this.desc = SB2.getLithdesc().getLithology(rhs.getLithCode());
        assert (this.desc != null);
        this.status = NOTSTORED;
    }

    public String statusString() {
        return this.toString();
    }

    public int compareTo(Object rhs) {
        return this.compareTo((LithBase)rhs);
    }

    public int compareTo(LithBase rhs) {
        if (rhs.getTopDepth() < this.topDepth) {
            return 1;
        }
        if (rhs.getTopDepth() > this.topDepth) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        if (this.desc != null) {
            return this.desc.getDescr();
        }
        return String.valueOf(this.getLithCode());
    }

    public Lithology getLithology() {
        return this.desc;
    }

    public void setLithology(Lithology lith) throws SBException, SQLException {
        if (this.getSbdb() != null && this.getSbdb().isConnected()) {
            throw new SBException("Attempt to set Lithology field");
        }
        this.desc = lith;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public void setTopDepth(double depth) throws SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set Lithology field");
        }
        this.topDepth = depth;
    }

    void store(int wellID) throws SQLException {
        this.store(this.sbdb, wellID);
    }

    abstract void store(SBdb var1, int var2) throws SQLException;

    abstract void writeDEX(FileWriter var1, String var2, char var3) throws IOException;

    abstract void writeXML(BufferedWriter var1, int var2, char var3) throws IOException;

    public abstract void delete(int var1, Statement var2) throws SQLException;

    public abstract void updateStatus(List<LithBase> var1, boolean var2);

    public static void check(List<LithBase> list, char units) throws SBException {
        for (LithBase base : list) {
            if (base.getLithology() == null) {
                throw new SBException("Lithology at depth : " + DepthUtils.convFromM((double)base.getTopDepth(), (char)units) + " is null");
            }
            for (LithBase comp : list) {
                if (base == comp || !(base instanceof LithInterval) || !(comp instanceof LithInterval)) continue;
                LithInterval int1 = (LithInterval)base;
                LithInterval int2 = (LithInterval)comp;
                int nzTD = (int)(int1.getTopDepth() * 1000.0);
                int nzBD = (int)(int1.getBaseDepth() * 1000.0);
                int cTD = (int)(int2.getTopDepth() * 1000.0);
                int cBD = (int)(int2.getBaseDepth() * 1000.0);
                try {
                    SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
                }
                catch (SBException ex) {
                    throw new SBException(DepthUtils.convFromM((double)int1.getTopDepth(), (char)units) + "-" + DepthUtils.convFromM((double)int1.getBaseDepth(), (char)units) + " " + ex.getMessage() + " " + String.valueOf(comp));
                }
            }
        }
    }

    LithBase(Builder builder) {
        this.sbdb = builder.sbdb;
        this.topDepth = builder.topDepth;
        this.desc = builder.desc;
        this.status = builder.status;
    }

    SBdb getSbdb() {
        return this.sbdb;
    }

    int getLithCode() {
        return this.desc != null ? this.desc.getLithID() : 0;
    }

    public static abstract class Builder {
        private final SBdb sbdb;
        private final double topDepth;
        private final Lithology desc;
        Color status = SbugsStatus.UNKNOWN;

        Builder(SBdb sbdb, double topDepth, Lithology desc) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to create LithBase builder will null sbdb");
            }
            this.sbdb = sbdb;
            if (topDepth < 0.0) {
                // empty if block
            }
            this.topDepth = topDepth;
            if (desc == null) {
                throw new IllegalArgumentException("Attempt to create LithBase builder will no Lithology");
            }
            this.desc = desc;
        }

        abstract LithBase build();

        double getTopDepth() {
            return this.topDepth;
        }

        Lithology getLithology() {
            return this.desc;
        }
    }
}

