/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import model3.SBRestrictable;
import model3.SBdb;
import org.jdom2.Element;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;

public class LogDef
implements Comparable,
SbugsLink {
    private final SBdb db;
    private String abr;
    private String title;
    private String units;
    private float minval;
    private float maxval;
    private boolean asLog = false;
    private Color backColour;
    private Color lineColour;
    private int penStyle;
    public static String[] penStyles = new String[]{"Solid", "Dotted", "Dashed"};
    public static final int PEN_SOLID = 0;
    public static final int PEN_DOTTED = 1;
    public static final int PEN_DASHED = 2;
    private int traceStyle;
    public static String[] traceStyles = new String[]{"Line", "Fill left", "Fill right", "Symbol", "Line and symbol"};
    public static final int TRACE_ST_LINE = 0;
    public static final int TRACE_ST_FILL_LEFT = 1;
    public static final int TRACE_ST_FILL_RIGHT = 2;
    public static final int TRACE_ST_SYMBOL = 3;
    public static final int TRACE_ST_SYMBOL_LINE = 4;
    private int symbol = 0;
    public static String[] symbols = new String[]{"triangle", "circle", "square", "diamond", "cross", "plus", "star", "tadpole"};
    public static final int SYMBOL_TRIANGLE = 0;
    public static final int SYMBOL_CIRCLE = 1;
    public static final int SYMBOL_SQUARE = 2;
    public static final int SYMBOL_DIAMOND = 3;
    public static final int SYMBOL_CROSS = 4;
    public static final int SYMBOL_PLUS = 5;
    public static final int SYMBOL_STAR = 6;
    public static final int SYMBOL_TADPOLE = 7;
    public static final int ABR_LEN = 10;
    float penWidth;
    boolean wrapTrace = true;
    private LogDef link;

    private LogDef(SBdb db) {
        this.db = db;
        this.lineColour = Color.BLACK;
        this.backColour = Color.WHITE;
    }

    public LogDef(LogDef logDef) {
        this.db = null;
        this.abr = logDef.abr;
        this.title = logDef.title;
        this.units = logDef.units;
        this.minval = logDef.minval;
        this.maxval = logDef.maxval;
        this.asLog = logDef.asLog;
        this.lineColour = logDef.lineColour;
        this.backColour = logDef.backColour;
        this.penStyle = logDef.penStyle;
        this.traceStyle = logDef.traceStyle;
        this.penWidth = logDef.penWidth;
        this.wrapTrace = logDef.wrapTrace;
        this.symbol = logDef.symbol;
    }

    LogDef(SBdb db, String abr, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) {
        this.db = db;
        this.abr = abr;
        this.title = title;
        this.units = units;
        this.minval = minval;
        this.maxval = maxval;
        this.asLog = asLog;
        this.backColour = backColour;
        this.lineColour = lineColour;
        this.penStyle = penStyle;
        this.traceStyle = traceStyle;
        this.penWidth = penWidth;
        this.wrapTrace = wrapTrace;
        this.symbol = symbol;
    }

    public String toString() {
        return this.getAbr();
    }

    public String getTitle() {
        return this.title;
    }

    void delete() throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String count = "SELECT count(abr) as nabr FROM " + this.db.DBTableName("LOG_CURVE") + " WHERE ucase(abr)=" + SB.DBString((String)this.getAbr().toUpperCase());
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(count));
            int nabr = 0;
            if (rs.next()) {
                nabr = rs.getInt("nabr");
            }
            if (nabr > 0) {
                throw new SBException("Cannot delete: header linked to " + nabr + " curves");
            }
            String sql = "DELETE FROM " + this.db.DBTableName("LOGDEF") + " WHERE abr=" + SB.DBString((String)this.getAbr());
            int count2 = stmt.executeUpdate(this.db.modQuery(sql));
            if (count2 != 1) {
                throw new SBException("Error deleting LogDef: " + this.getAbr() + " deletes " + count + " rows");
            }
        }
    }

    void store() throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "SELECT abr FROM " + this.db.DBTableName("LOGDEF") + " WHERE ucase(abr)=" + SB.DBString((String)this.getAbr().toUpperCase());
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                throw new SBException("Definition of: " + this.getAbr() + " already exists");
            }
            switch (this.traceStyle) {
                case 0: 
                case 1: 
                case 2: {
                    this.symbol = 0;
                    break;
                }
            }
            sql = "INSERT INTO " + this.db.DBTableName("LOGDEF") + " (abr,title,units,minval,maxval,asLog,backcolour,linecolour,penstyle,penwidth,wrap,tracestyle) VALUES (" + SB.DBString((String)this.getAbr()) + "," + SB.DBString((String)this.title) + "," + SB.DBString((String)this.getUnits()) + "," + this.getMinval() + "," + this.getMaxval() + "," + (this.isAsLog() ? "'Y'" : "'N'") + "," + ColourUtils.getSBIntFromColor((Color)this.getBackColour()) + "," + ColourUtils.getSBIntFromColor((Color)this.getLineColour()) + "," + this.getPenStyle() + "," + this.getPenWidth() + "," + (this.getWrapTrace() ? "'Y'" : "'N'") + "," + Integer.parseInt("" + this.traceStyle + this.symbol) + ")";
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    public static void load(SBdb sbdb, HashMap<String, LogDef> map) throws SQLException {
        String sql = "SELECT abr,title,units,minval,maxval,asLog,backcolour,linecolour,penstyle,penwidth,wrap,tracestyle FROM " + sbdb.DBTableName("LOGDEF") + " ORDER BY abr";
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            Object style;
            LogDef d = new LogDef(sbdb);
            d.setAbr(rs.getString("abr"));
            d.setTitle(rs.getString("title"));
            d.setUnits(rs.getString("units"));
            d.setMinval(rs.getFloat("minval"));
            d.setMaxval(rs.getFloat("maxval"));
            String strg = rs.getString("aslog");
            if (strg.length() > 0 && strg.charAt(0) == 'Y') {
                d.setAsLog(true);
            }
            d.setBackColour(ColourUtils.getSBColorFromInt((int)rs.getInt("backcolour")));
            d.setLineColour(ColourUtils.getSBColorFromInt((int)rs.getInt("linecolour")));
            d.setPenStyle(rs.getInt("penstyle"));
            float penwidth = rs.getFloat("penwidth");
            if (penwidth <= 0.0f) {
                penwidth = 0.1f;
            }
            d.setPenWidth(penwidth);
            String wrap = rs.getString("wrap");
            if (wrap == null || wrap.isEmpty()) {
                wrap = "Y";
            }
            if (wrap.length() > 0 && wrap.charAt(0) == 'Y') {
                d.setWrapTrace(true);
            }
            if ((style = "" + rs.getInt("tracestyle")) == null) {
                style = "0";
            }
            d.setTraceStyle(Integer.parseInt("" + ((String)style).charAt(0)));
            if (((String)style).length() > 1) {
                d.setSymbol(Integer.parseInt("" + ((String)style).charAt(1)));
            }
            map.put(d.getAbr(), d);
        }
    }

    void update(SBdb db, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        switch (traceStyle) {
            case 0: 
            case 1: 
            case 2: {
                symbol = 0;
                break;
            }
        }
        String sql = "UPDATE " + db.DBTableName("LOGDEF") + " SET title=" + SB.DBString((String)title) + ",units=" + SB.DBString((String)units) + ",minval=" + minval + ",maxval=" + maxval + ",aslog=" + (asLog ? "'Y'" : "'N'") + ",backcolour=" + ColourUtils.getSBIntFromColor((Color)backColour) + ",linecolour=" + ColourUtils.getSBIntFromColor((Color)lineColour) + ",penstyle=" + penStyle + ",tracestyle=" + Integer.parseInt("" + traceStyle + symbol) + ",penwidth=" + penWidth + ",wrap=" + (wrapTrace ? "'Y'" : "'N'") + " WHERE abr=" + SB.DBString((String)this.abr);
        try (Statement stmt = db.getDatabase().createStatement();){
            stmt.executeUpdate(db.modQuery(sql));
        }
        this.title = title;
        this.units = units;
        this.minval = minval;
        this.maxval = maxval;
        this.asLog = asLog;
        this.backColour = backColour;
        this.lineColour = lineColour;
        this.penStyle = penStyle;
        this.traceStyle = traceStyle;
        this.penWidth = penWidth;
        this.wrapTrace = wrapTrace;
        this.symbol = symbol;
    }

    public void update(String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) {
        this.title = title;
        this.units = units;
        this.minval = minval;
        this.maxval = maxval;
        this.asLog = asLog;
        this.backColour = backColour;
        this.lineColour = lineColour;
        this.penStyle = penStyle;
        this.traceStyle = traceStyle;
        this.penWidth = penWidth;
        this.wrapTrace = wrapTrace;
        this.symbol = symbol;
    }

    public void update(String title, String units) {
        this.title = title;
        this.units = units;
    }

    void updateCurveAbr(String oldAbr) throws SQLException {
        String sql = "UPDATE " + this.db.DBTableName("LOG_CURVE") + " SET abr=" + SB.DBString((String)this.abr) + " WHERE abr=" + SB.DBString((String)oldAbr);
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    public boolean hasCurves() throws SQLException {
        boolean curvesExist = false;
        String sql = "SELECT curve_id FROM " + this.db.DBTableName("LOG_CURVE") + " WHERE abr=" + SB.DBString((String)this.abr);
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                curvesExist = true;
            }
        }
        return curvesExist;
    }

    public int compareTo(Object o) {
        if (o instanceof LogDef) {
            LogDef l = (LogDef)o;
            return this.abr.compareTo(l.abr);
        }
        return 0;
    }

    public String getAbr() {
        return this.abr;
    }

    void setAbr(String abr) {
        this.abr = abr;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public String getUnits() {
        return this.units;
    }

    void setUnits(String units) {
        this.units = units;
    }

    public float getMinval() {
        return this.minval;
    }

    void setMinval(float minval) {
        this.minval = minval;
    }

    public float getMaxval() {
        return this.maxval;
    }

    void setMaxval(float maxval) {
        this.maxval = maxval;
    }

    public boolean isAsLog() {
        return this.asLog;
    }

    void setAsLog(boolean asLog) {
        this.asLog = asLog;
    }

    public Color getBackColour() {
        return this.backColour;
    }

    void setBackColour(Color backColour) {
        this.backColour = backColour;
    }

    public Color getLineColour() {
        return this.lineColour;
    }

    void setLineColour(Color lineColour) {
        this.lineColour = lineColour;
    }

    public float getPenWidth() {
        return this.penWidth;
    }

    public int getTraceStyle() {
        return this.traceStyle;
    }

    public int getPenStyle() {
        return this.penStyle;
    }

    public boolean getWrapTrace() {
        return this.wrapTrace;
    }

    void setPenStyle(int style) {
        this.penStyle = style;
    }

    void setTraceStyle(int style) {
        this.traceStyle = style;
    }

    void setWrapTrace(boolean wrap) {
        this.wrapTrace = wrap;
    }

    void setPenWidth(float width) {
        this.penWidth = width;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public void setSymbol(int symbol) {
        this.symbol = symbol;
    }

    public String getProperties() {
        Object string = new String();
        String[] props = new String[]{this.abr, this.title, this.units, "" + this.minval, "" + this.maxval, "" + (this.asLog ? 1 : 0), this.backColour.getRed() + "," + this.backColour.getGreen() + "," + this.backColour.getBlue(), this.lineColour.getRed() + "," + this.lineColour.getGreen() + "," + this.lineColour.getBlue(), "" + this.penStyle, "" + this.penWidth, "" + (this.wrapTrace ? 1 : 0), this.traceStyle + String.valueOf(this.traceStyle == 3 || this.traceStyle == 4 ? Integer.valueOf(this.symbol) : "")};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    public LogDef(String props) {
        this.db = null;
        String[] s = props.split("\\|");
        block14: for (int i = 0; i < props.length(); ++i) {
            switch (i) {
                case 0: {
                    this.abr = s[i];
                    continue block14;
                }
                case 1: {
                    this.title = s[i];
                    continue block14;
                }
                case 2: {
                    this.units = s[i];
                    continue block14;
                }
                case 3: {
                    this.minval = Float.parseFloat(s[i]);
                    continue block14;
                }
                case 4: {
                    this.maxval = Float.parseFloat(s[i]);
                    continue block14;
                }
                case 5: {
                    this.asLog = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 6: {
                    this.backColour = ColourUtils.getColour((String)s[i]);
                    continue block14;
                }
                case 7: {
                    this.lineColour = ColourUtils.getColour((String)s[i]);
                    continue block14;
                }
                case 8: {
                    this.penStyle = Integer.parseInt(s[i]);
                    continue block14;
                }
                case 9: {
                    this.penWidth = Float.parseFloat(s[i]);
                    continue block14;
                }
                case 10: {
                    this.wrapTrace = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 11: {
                    String style = s[i];
                    if (style == null) {
                        style = "0";
                    }
                    this.traceStyle = Integer.parseInt("" + style.charAt(0));
                    if (style.length() <= 1) continue block14;
                    this.symbol = Integer.parseInt("" + style.charAt(1));
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof LogDef)) {
            return false;
        }
        LogDef rhs = (LogDef)o;
        if (!this.title.equals(rhs.title) || !this.units.equals(rhs.units)) {
            return false;
        }
        if (this.minval != rhs.minval || this.maxval != rhs.maxval) {
            return false;
        }
        if (this.asLog != rhs.asLog) {
            return false;
        }
        if (!this.backColour.equals(rhs.backColour) || !this.lineColour.equals(rhs.lineColour)) {
            return false;
        }
        if (this.symbol != rhs.symbol) {
            return false;
        }
        return this.penStyle == rhs.penStyle && this.penWidth == rhs.penWidth && this.wrapTrace == rhs.wrapTrace && this.traceStyle == rhs.traceStyle;
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<WirelineLogHeader Key=\"" + this.abr + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<Title>" + SB.getXMLstring((String)this.title) + "</Title>\n");
        out.write(ind + "<Units>" + SB.getXMLstring((String)this.units) + "</Units>\n");
        out.write(ind + "<ScaleMinimum>" + this.minval + "</ScaleMinimum>\n");
        out.write(ind + "<ScaleMaximum>" + this.maxval + "</ScaleMaximum>\n");
        out.write(ind + "<LogScale>" + this.asLog + "</LogScale>\n");
        out.write(ind + "<LineColour>\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3 + 3));
        SB.writeXMLColour((Color)this.lineColour, (BufferedWriter)out, (String)ind2);
        out.write(ind + "</LineColour>\n");
        out.write(ind + "<BackgroundColour>\n");
        SB.writeXMLColour((Color)this.backColour, (BufferedWriter)out, (String)ind2);
        out.write(ind + "</BackgroundColour>\n");
        out.write(ind + "<PenStyle>" + this.penStyle + "</PenStyle>\n");
        out.write(ind + "<PenWidth>" + this.penWidth + "</PenWidth>\n");
        out.write(ind + "<Wrap>" + this.wrapTrace + "</Wrap>\n");
        out.write(ind + "<TraceStyle>" + this.traceStyle + this.symbol + "</TraceStyle>\n");
        out.write(ind1 + "</WirelineLogHeader>\n");
    }

    public static LogDef parseXML(SBdb db, Element el) {
        assert (!db.isConnected());
        LogDef logDef = new LogDef(db);
        logDef.abr = el.getAttributeValue("Key");
        logDef.title = el.getChildText("Title");
        logDef.units = el.getChildText("Units");
        logDef.minval = Float.parseFloat(el.getChildText("ScaleMinimum"));
        logDef.maxval = Float.parseFloat(el.getChildText("ScaleMaximum"));
        logDef.asLog = Boolean.valueOf(el.getChildText("LogScale"));
        logDef.lineColour = SB.parseColour((Element)el.getChild("LineColour").getChild("Colour"));
        logDef.backColour = SB.parseColour((Element)el.getChild("BackgroundColour").getChild("Colour"));
        logDef.penStyle = Integer.parseInt(el.getChildText("PenStyle"));
        logDef.penWidth = Float.parseFloat(el.getChildText("PenWidth"));
        logDef.wrapTrace = Boolean.valueOf(el.getChildText("Wrap"));
        String traceStyle = el.getChildText("TraceStyle");
        if (traceStyle.length() == 2) {
            logDef.traceStyle = Integer.parseInt("" + traceStyle.charAt(0));
            logDef.symbol = Integer.parseInt("" + traceStyle.charAt(1));
        }
        return logDef;
    }

    public LogDef getLink() {
        return this.link;
    }

    public void setLink(LogDef link) {
        this.link = link;
    }
}

