/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.wellinterp.LOCNode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.AccumulationRateInterval;
import model3.LOC;
import model3.LOCNodePair;
import model3.TVDList;
import model3.Well;
import model3.WellInterp;
import util.AgeFormat;
import util.DoubleRange;
import util.SBException;

public class ProjectAccumulationRateSummary {
    private static final Logger LOGGER = Logger.getLogger(ProjectAccumulationRateSummary.class.getName());
    private static double POINT_DEPTH_DELTA = 1.0E-4;

    public static List<AccumulationRateInterval> calculateAveragedNodes(List<Well> wells, int interpId, char depthUnits, AgeFormat format) {
        ArrayList<AccumulationRateInterval> intervals = new ArrayList<AccumulationRateInterval>();
        for (Well well : wells) {
            try {
                WellInterp wi;
                if (well.getInterp(interpId) == null || (wi = well.getInterp(interpId)).getLOC() == null) continue;
                LOC loc = wi.getLOC();
                List<LOCNodePair> pairs = ProjectAccumulationRateSummary.buildLOCNodePairList(loc);
                for (LOCNodePair pair : pairs) {
                    TVDList tvdList = well.getTVDlist(false);
                    if (!tvdList.getList().isEmpty()) {
                        tvdList = null;
                    }
                    double accRate = pair.getAccumRate(depthUnits, format, tvdList);
                    AccumulationRateInterval interval = new AccumulationRateInterval(new DoubleRange(pair.getTopDepth(), pair.getBaseDepth()), accRate, depthUnits, format);
                    intervals.add(interval);
                }
            }
            catch (SQLException | SBException e) {
                MessageFormat mf = new MessageFormat("Error getting interpretation {0} form well {1}.");
                LOGGER.log(Level.WARNING, mf.format(new Object[]{interpId, well}), e);
            }
        }
        ArrayList<Double> averagePoints = new ArrayList<Double>();
        for (AccumulationRateInterval i2 : intervals) {
            averagePoints.add(i2.getDepthRange().getMin());
            averagePoints.add(i2.getDepthRange().getMax());
        }
        averagePoints.sort(Double::compare);
        ArrayList<DoubleRange> arrayList = new ArrayList<DoubleRange>();
        Double lastValue = null;
        for (Double p : averagePoints) {
            if (lastValue == null) {
                lastValue = p;
                continue;
            }
            if (Math.abs(lastValue - p) < POINT_DEPTH_DELTA) continue;
            DoubleRange range = new DoubleRange(lastValue.doubleValue(), p.doubleValue());
            arrayList.add(range);
            lastValue = p;
        }
        ArrayList<AccumulationRateInterval> averageAccIntervals = new ArrayList<AccumulationRateInterval>();
        for (DoubleRange range : arrayList) {
            double[] array = intervals.stream().filter(i -> i.getDepthRange().isInRange(range.getMidPoint())).mapToDouble(AccumulationRateInterval::getAccumulationRate).toArray();
            double average = intervals.stream().filter(i -> i.getDepthRange().isInRange(range.getMidPoint())).mapToDouble(AccumulationRateInterval::getAccumulationRate).average().orElse(Double.NaN);
            AccumulationRateInterval interval = new AccumulationRateInterval(range, average, depthUnits, format);
            averageAccIntervals.add(interval);
        }
        return averageAccIntervals;
    }

    private static List<LOCNodePair> buildLOCNodePairList(LOC loc) {
        ArrayList<LOCNodePair> pairs = new ArrayList<LOCNodePair>();
        LOCNode lastNode = null;
        for (LOCNode thisNode : loc.getNodes()) {
            if (lastNode == null) {
                lastNode = thisNode;
                continue;
            }
            LOCNodePair band = new LOCNodePair(lastNode, thisNode);
            pairs.add(band);
            lastNode = thisNode;
        }
        return pairs;
    }
}

