/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.SystemPreferences;
import com.stratadata.model3.db.ConnectionFactory;
import com.stratadata.model3.db.ConnectionManager;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.ModelVersion;
import com.stratadata.model3.db.SBTables;
import com.stratadata.model3.event.DictionaryEvent;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.external.WebServiceDescriptionService;
import com.stratadata.model3.external.WebServices;
import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageLoaderDbImpl;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageRecordServiceDbImpl;
import com.stratadata.model3.image.ImageRecordServiceImpl;
import com.stratadata.model3.image.TaxonImageService;
import com.stratadata.model3.image.TaxonImageServiceDbImpl;
import com.stratadata.model3.image.TaxonImageServiceImpl;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.project.WellListRepository;
import com.stratadata.model3.scheme.StratigraphicUnit;
import com.stratadata.model3.scheme.StratigraphicUnitService;
import com.stratadata.model3.slidestore.SlideStoreService;
import com.stratadata.model3.slidestore.SlideStoreServiceDbImpl;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.WellGeoSort;
import com.stratadata.model3.well.WellHeader;
import com.stratadata.model3.well.WellRepository;
import com.stratadata.model3.well.analysis.AnalysisID;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.analysis.SpeciesTypeService;
import com.stratadata.model3.well.analysis.SpeciesTypeServiceDbImpl;
import com.stratadata.model3.well.analysis.SpeciesTypeServiceImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeInformationService;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeService;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceDbImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import com.stratadata.model3.ws.LicenseCustomer;
import com.stratadata.model3.ws.SBdm;
import com.stratadata.model3.ws.XmlWriter;
import com.stratadata.model3.ws.reader.XmlReader;
import com.stratadata.util.process.AbstractMultiStageProcess;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import model3.AgeCurve;
import model3.AnalystHeader;
import model3.Audit;
import model3.Biocom;
import model3.Category;
import model3.CoOccurrence;
import model3.Column;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.ConnectionProvider;
import model3.DataType;
import model3.EnvScheme;
import model3.EventDictionary;
import model3.Genus;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.Intcom;
import model3.InterpHdr;
import model3.Lastval;
import model3.LithTrnScheme;
import model3.Lithdesc;
import model3.Lithology;
import model3.LogDef;
import model3.NextControl;
import model3.Overlay;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SQPick;
import model3.Sample;
import model3.Smpdtl;
import model3.SynSch;
import model3.SynonymScheme;
import model3.TaxaMap;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WellManager;
import model3.WsWell;
import model3.exception.SuppressedSQLException;
import model3.project.Project;
import model3.project.WellList;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.ColourUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;
import util.SbugsLink;
import util.TextUtils;
import util.exception.SqlCache;

public class SBdb
extends SBObservable
implements SBdm,
Observer,
ConnectionProvider,
UserService,
StratigraphicUnitService {
    private static final Logger LOGGER = Logger.getLogger(SBdb.class.getName());
    private Map<Integer, Set<Integer>> versionsInProjectCache = null;
    private ConnectionManager connectionManager;
    public static final String version = "v3.0";
    public static final ModelVersion MODEL_VERSION = ModelVersion.V3_0_0;
    public long taxaMonitorInterval = 600000L;
    HashMap<Integer, String> sipmDicts = null;
    Userdef user = null;
    private boolean needsPassword = true;
    private LicenseCustomer licence = null;
    public static boolean preserveAudit = false;
    private boolean hasTVDplan = true;
    public static final char[] discArr = new char[]{'M', 'N', 'P', 'A'};
    public static final String[] discNounString = new String[]{"Micropalaeontology", "Nannopalaeontology", "Palynology", "Macropalaeontology"};
    public static final int MAXDIS = 4;
    boolean[] hasWeightSplits = new boolean[]{true, true, true, true};
    boolean[] hasFssSplits = new boolean[]{true, true, true, true};
    boolean hasWellsMaster = false;
    boolean hasCoresMaster = false;
    boolean hasCasdiam = true;
    boolean hasCasingMaster = false;
    boolean hasSmarkMaster = false;
    private boolean hasUserPassword = true;
    boolean hasWITSML = false;
    boolean hasWellPerm = false;
    boolean hasUserPerm = false;
    boolean hasSIPMdict = false;
    private NextControl nextControl;
    private boolean auditTrail = true;
    boolean hasSAMBA = false;
    boolean hideDepthRange = false;
    boolean allowMultipleEnvSchemes = false;
    boolean sbwlIsView = false;
    boolean storeImage = true;
    boolean allowCountryCase = false;
    boolean showArchivedSchemes = false;
    public static final int DTSAMPLES = 1;
    public static final int DTMICRO = 2;
    public static final int DTMICROBS = 3;
    public static final int DTNANNO = 4;
    public static final int DTNANNOBS = 5;
    public static final int DTPALY = 6;
    public static final int DTPALYBS = 7;
    public static final int DTMACRO = 8;
    public static final int DTMACROBS = 9;
    public static final int DTCHRONO = 10;
    public static final int DTBIOZONE = 11;
    public static final int DTLITHOSTRAT = 12;
    public static final int DTSEQUENCE = 13;
    public static final int DTSQPICK = 14;
    public static final int DTENV = 15;
    public static final int DTEVENTS = 16;
    public static final int DTQSLOC = 17;
    public static final int DTINTCOM = 18;
    public static final int DTCORES = 19;
    public static final int DTCASING = 20;
    public static final int DTLITHOLOGY = 21;
    public static final int DTSAMPLELITH = 22;
    public static final int DTLOGDATA = 23;
    public static final int DTMARKERS = 24;
    public static final int DTTVD = 25;
    public static final int DTTWT = 26;
    public static final int DTFAULTS = 27;
    public static final int DTWELLHDR = 28;
    public static final int DTSAMPLEAGE = 29;
    public static final String[] dTypeNames = new String[]{"Well/Outcrop", "Samples", "Micro", "Micro. comments", "Nanno", "Nanno. comments", "Paly", "Paly. comments", "Macro", "Macro. comments", "Chronostrat", "Biozone", "Lithostrat", "Sequences", "Sequence Picks", "Palaeoenv.", "Events", "Depth/Age Curves", "Interval Comments", "Cores", "Casing", "Interpreted Lithology", "Sample Lithology", "Log data", "Markers", "Deviation Survey", "TWT", "Disconformities", "Well Header", "Sample age"};
    public static final int NDTYPES = 27;
    public static final int NINTERPDTYPES = 9;
    List wellMasterFields = new ArrayList();
    Well currentWell = null;
    Lithdesc lithdesc = null;
    private final TaxaMap taxa;
    private final EventDictionary events;
    private final WellManager wells;
    private HashMap<Integer, Overlay> overlays = null;
    private HashMap<String, Color> miscColours = null;
    private final SpeciesTypeService speciesTypeService;
    private HashMap<String, LogDef> logDef;
    private TreeMap<Integer, TxGroupSet> sets = null;
    private HashMap<Integer, TxGroup> txGroups = null;
    private SynSch synSch;
    private TreeMap<Integer, Userdef> users = null;
    private HashMap<Integer, EnvScheme> envSchemes = null;
    private HashMap<Integer, InterpHdr> interpHdrs = null;
    private HashMap<Integer, IGDScheme> chronoSchemes = null;
    private HashMap<Integer, IGDScheme> lstratSchemes = null;
    private HashMap<Integer, IGDScheme> sequenceSchemes = null;
    private HashMap<Integer, IGDScheme> biozoneSchemes = null;
    private HashMap<Integer, IGDScheme> magnetoSchemes = null;
    private HashMap<Integer, CompositeStandard> compositeStandards = null;
    private List<Integer> chartScales = null;
    List<String> casingDiameters = null;
    private String imageFolder = null;
    private final ImageRecordService imageRecordService;
    private ImageLoader imageLoader = new ImageLoaderDbImpl(this);
    private final TaxonImageService taxonImageService;
    private AbundanceSchemeService abundanceSchemeService;
    LinkedList<Integer> userIDs = new LinkedList();
    public static final int CHART_SCALE_MIN = 1;
    public static final int CHART_SCALE_MAX = 100000;
    List<AgeCurve> ageCurves = null;
    LinkedList<LithTrnScheme> lithTrnSchemes;
    private static boolean EXPORT_SINGLE_USER = false;
    static String EXPORT_SINGLE_USER_ABR = null;
    private Color[] sequenceColours = null;
    private WebServices webServiceDescriptions;
    private final SlideStoreService slideStoreService;

    @Override
    public Connection getDatabase() {
        return this.connectionManager.getPersistentConnection();
    }

    public Connection getNewConnection() throws SQLException {
        return this.connectionManager.getNewConnection();
    }

    public String getTablePrefix() {
        return this.connectionManager.getTablePrefix();
    }

    public String getDatabasePref(String item) throws SQLException {
        String sql = "SELECT pref_value FROM " + this.DBTableName("pref_system") + " WHERE pref_key=" + SB.DBString((String)item);
        String result = "";
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next()) {
                result = rs.getString("pref_value");
            }
        }
        return result;
    }

    public Boolean getDatabasePrefBool(String item) throws SQLException {
        String sql = "SELECT pref_value FROM " + this.DBTableName("pref_system") + " WHERE pref_key=" + SB.DBString((String)item);
        Boolean result = null;
        try (Statement stmt = this.getDatabase().createStatement();){
            String strg;
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next() && (strg = rs.getString("pref_value")).length() > 0) {
                result = strg.toUpperCase(Locale.ENGLISH).charAt(0) != 'F';
            }
        }
        return result;
    }

    public void initSystemPreferences() throws SQLException {
        String sql = "SELECT pref_value, pref_key FROM " + this.DBTableName("pref_system");
        HashMap<String, String> prefs = new HashMap<String, String>();
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                prefs.put(key, value);
            }
        }
        SystemPreferences.init(prefs);
    }

    public void putDatabasePref(String item, boolean bool) throws SQLException {
        this.putDatabasePref(item, "" + bool);
    }

    public void putDatabasePref(String item, String pref) throws SQLException {
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.DBTableName("PREF_SYSTEM") + " WHERE pref_key='" + item + "'";
            stmt.executeUpdate(this.modQuery(sql));
            if (pref != null && pref.length() > 0) {
                sql = "INSERT INTO " + this.DBTableName("PREF_SYSTEM") + " ( pref_key, pref_value ) VALUES ('" + item + "','" + pref + "')";
                stmt.executeUpdate(this.modQuery(sql));
            }
        }
    }

    public String getDatabaseInfo() throws SQLException {
        Object info = "";
        String[] tables = new String[]{"WELLS", "PROJECT", "WELLIST", "SAMPLES", "SMPDTL", "TAXONOCC", "SBIMAGE", "INTERP", "LOC", "IGD", "IGD_Env", "Events", "BCMMNTS", "SQPICK", "INTCMMNTS", "FAULTS", "LOG_CURVE", "USERDEF", "SPECIES", "GENUS", "CATEGORY", "TXGROUP", "IGD_SCH", "CMPSTD", "ENV_SCH", "AGE_CURVE", "CHART", "CHTBLOCK", "CHTPANL", "CHARTCORR"};
        try (Statement stmt = this.getDatabase().createStatement();){
            for (String table : tables) {
                String sql = "SELECT COUNT(*) as result FROM " + this.DBTableName(table);
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    int j = rs.getInt("result");
                    info = (String)info + j + ",";
                }
            }
        }
        return info;
    }

    public String getDataModelRevision() {
        String revision = "3.0";
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "SELECT version, descr, modified FROM " + this.DBTableName("DBVERSION") + " ORDER BY modified DESC";
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next()) {
                revision = rs.getString("version");
                String descr = rs.getString("descr");
                LOGGER.log(Level.CONFIG, "Database descr: {0}", descr);
                Date date = new Date(rs.getTimestamp("modified").getTime());
                LOGGER.log(Level.CONFIG, "Database update date: {0}", SB.df.format(date));
            }
        }
        catch (SQLException sqle) {
            System.out.println("Error getting database revision: " + sqle.getMessage());
        }
        return revision;
    }

    public String getProjectInfo(int projID) throws SQLException {
        Object info = "";
        String[] tables = new String[]{"PROJECT", "TXGROUP", "GROUPSET", "CHART", "CHTBLOCK", "CHTPANL", "CHARTCORR"};
        try (Statement stmt = this.getDatabase().createStatement();){
            for (String table : tables) {
                String sql = "SELECT COUNT(*) as result FROM " + this.DBTableName(table) + " WHERE proj_id=" + projID;
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    int j = rs.getInt("result");
                    info = (String)info + j + ",";
                }
            }
        }
        return info;
    }

    public void setStoreImage(boolean bool) throws SQLException {
        this.putDatabasePref("IMAGEDB", bool);
        this.storeImage = bool;
    }

    public void refresh() throws SQLException, SBException {
        try (Connection conn = this.getNewConnection();){
            SBRestrictable notifier;
            LOGGER.log(Level.CONFIG, "Refreshing data with connection {0} on thread {1}.", new Object[]{conn, Thread.currentThread().getName()});
            ((AbundanceSchemeServiceDbImpl)this.abundanceSchemeService).refreshAbundanceSchemes();
            this.refreshEnvSchemes(conn);
            this.refreshIGDSchemes(conn);
            this.refreshEvents(conn);
            this.refreshCompositeStandards(conn);
            this.refreshTaxa(conn);
            if (this.txGroups != null && (notifier = TxGroup.refresh(this, this.txGroups, conn)) != null) {
                this.setChanged();
                this.notifyObservers((Object)notifier);
            }
            if (this.sets != null && (notifier = TxGroupSet.refresh(this, this.sets, conn)) != null) {
                this.setChanged();
                this.notifyObservers((Object)notifier);
            }
            if (this.overlays != null) {
                Overlay.refresh(this, conn, this.overlays);
            }
            this.refreshInterps(conn);
            this.wells.refreshProjects(conn);
            this.wells.refreshWellLists(conn);
            this.wells.refreshWells(conn);
            conn.commit();
        }
    }

    void refreshIntervals(IGDScheme scheme) throws SQLException, SBException {
        System.out.println("Refreshing linked intervals for scheme '" + String.valueOf(scheme) + "'");
        Iterator<Well> it = this.getWellIterator();
        try (Statement stmt = this.getDatabase().createStatement();){
            while (it.hasNext()) {
                Well well = it.next();
                well.getSamples();
                well.loadInterps();
                Iterator<WellInterp> interpIterator = well.getInterpIterator();
                while (interpIterator.hasNext()) {
                    WellInterp interp = interpIterator.next();
                    interp.refreshZones(stmt, scheme.getIGDType(), well, scheme.getSchID());
                }
            }
        }
    }

    void refreshEnvIntervals() throws SQLException, SBException {
        System.out.println("Refreshing linked envs");
        Iterator<Well> it = this.getWellIterator();
        try (Statement stmt = this.getDatabase().createStatement();){
            while (it.hasNext()) {
                Well well = it.next();
                well.getSamples();
                well.loadInterps();
                Iterator<WellInterp> interpIterator = well.getInterpIterator();
                while (interpIterator.hasNext()) {
                    WellInterp interp = interpIterator.next();
                    interp.refreshEnvs(stmt, well);
                }
            }
        }
    }

    public boolean storeImage() {
        return this.storeImage;
    }

    public void cleanTaxon(int specID, boolean convertCase, boolean clearCat, Boolean spSpp) {
        this.taxa.cleanTaxon(specID, convertCase, clearCat, spSpp);
    }

    public void updateSpecies(int specID, Taxon.Builder builder) throws SQLException, SBPermissionException {
        this.taxa.updateSpecies(specID, builder);
    }

    int getAddUserID(String abr) throws SQLException {
        return this.getAddUserID(abr, "");
    }

    int getAddUserID(String abr, String name) throws SQLException {
        int ID = this.getUserID(abr);
        if (ID == 0) {
            try {
                ID = this.users.lastKey() + 1;
            }
            catch (Exception e) {
                ID = 1;
            }
            Userdef u = new Userdef(this, ID, abr, name, "", Discipline.MICRO, Color.BLACK, "", 0, null);
            this.getUsers();
            this.users.put(ID, u);
        }
        return ID;
    }

    public User addUser(User user) {
        throw new UnsupportedOperationException("Not implemented yet - use workspace");
    }

    void setUser(Userdef defaultUser) throws SQLException {
        if (this.user == defaultUser) {
            return;
        }
        if (this.isConnected()) {
            return;
        }
        this.user = this.getUser(defaultUser.getAbr());
        if (this.user == null) {
            this.user = defaultUser;
            this.users.put(defaultUser.getUsrID(), this.user);
        }
    }

    public boolean hasEnvSchemeOccs(EnvScheme scheme) throws SQLException, SBException {
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iti = well.getInterpIterator();
            while (iti.hasNext()) {
                WellInterp wellInterp = iti.next();
                for (IGDIntervalEnv zone : wellInterp.getEnvs()) {
                    if (zone.getSchID() != scheme.getID()) continue;
                    return true;
                }
            }
            for (Sample sample : well.getSamples()) {
                for (Smpdtl dtl : sample.getSmpdtls()) {
                    if (dtl.getProximal() <= 0 || dtl.getHeader().getEnvSchID() != scheme.getID()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasGrpSetOccurrences(TxGroup group) {
        assert (this.txGroups.get(group.getID()) == group);
        for (TxGroupSet set : this.sets.values()) {
            if (!set.isGroupMember(group.getID())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDefaultAbnScheme() throws SQLException, SBException, SBPermissionException {
        int newSchID = this.getAbundanceSchemeService().getAllAbundanceSchemes().stream().map(AbundanceScheme::getAbnSchID).max(Integer::compareTo).orElse(0) + 1;
        AbundanceSchemeImpl scheme = new AbundanceSchemeImpl(newSchID);
        scheme.setName("Default");
        Iterator<Well> wit = this.getWellIterator();
        try {
            while (wit.hasNext()) {
                Well well = wit.next();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getSmpdtls()) {
                        Iterator<TaxonOcc> oit = smpdtl.getOccurIterator();
                        while (oit.hasNext()) {
                            TaxonOcc occ = oit.next();
                            if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0 || occ.getSubAbund().equals("+")) continue;
                            String subjAbund = occ.getSubAbund();
                            AnalystHeader header = smpdtl.getHeader();
                            if (header == null) {
                                throw new SBException("Analyst header null for Analysis: " + String.valueOf((Object)smpdtl));
                            }
                            if (header.getAbnSchID() != 0 && header.getAbnSchID() != newSchID) continue;
                            if (scheme.findEntryBySubjAbund(subjAbund).isEmpty()) {
                                if (!StringUtils.isAlpha((CharSequence)subjAbund)) {
                                    String newMessage = "Error creating class in Default Abundance Scheme using subjective abundance in occurrence: " + String.valueOf(occ) + " in sample: " + sample.toString() + ".\n";
                                    newMessage = newMessage + "You should edit your source file and try the import again.";
                                    throw new SBException(newMessage);
                                }
                                scheme.addEntry(new AbundanceScheme.AbundanceSchemeEntry("", subjAbund, 0, 0));
                                scheme.sortEntries();
                            }
                            header.setAbnScheme(newSchID);
                        }
                    }
                }
            }
        }
        finally {
            if (scheme.getEntryCount() > 0) {
                this.getAbundanceSchemeService().addAbundanceScheme((AbundanceScheme)scheme);
            }
        }
    }

    public InterpHdr fillInterp(InterpHdr hdr) {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to copy InterpHdr to connected workspace");
        }
        if (this.interpHdrs == null) {
            try {
                this.loadInterps();
            }
            catch (SQLException sql) {
                throw new IllegalStateException("Unexpected SQL Exception", sql);
            }
        }
        if (this.interpHdrs.get(hdr.getInterpID()) == null) {
            InterpHdr wsHdr = InterpHdr.copyToWorkspace(this, hdr);
            this.interpHdrs.put(wsHdr.getInterpID(), wsHdr);
        }
        return this.interpHdrs.get(hdr.getInterpID());
    }

    public InterpHdr addInterp(String descrip, Integer interpID) throws InvalidFieldException, SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        if (interpID != null && this.interpHdrs.get(interpID) != null) {
            return this.interpHdrs.get(interpID);
        }
        InterpHdr interp = new InterpHdr(this, descrip, interpID);
        this.interpHdrs.put(interp.getInterpID(), interp);
        return interp;
    }

    public void deleteInterp(int interpID) throws SQLException, SBException {
        this.interpHdrs.get(interpID).delete();
        this.interpHdrs.remove(interpID);
    }

    public void fillUser(SBdb db, int userID) throws SQLException, SBException {
        assert (!this.isConnected() && db.isConnected());
        if (this.getUser(userID) != null) {
            return;
        }
        Userdef dbUser = db.getUser(userID);
        if (dbUser == null) {
            throw new SBException("User not found for user ID: " + userID + " in SBdb.fillUser");
        }
        if (this.getUser(dbUser.getAbr()) == null) {
            this.users.put(userID, Userdef.copyToWorkspace(this, dbUser));
        }
    }

    public void parseXMLDocument(Document xmlDocument, Set<Integer> dataTypes, ZipFile zip, String fileName, int projID, List<SBException> exceptions) throws SBException, SQLException, ParseException, FileNotFoundException, IOException {
        Element element;
        Element xmlGs;
        Element txList;
        IteratorIterable it = xmlDocument.getDescendants((Filter)new ElementFilter("UserList"));
        if (it.hasNext()) {
            this.getUsers();
            Element userList = (Element)it.next();
            for (Element xmlUser : userList.getChildren()) {
                Userdef us = new Userdef(this, xmlUser);
                this.users.put(us.getUsrID(), us);
            }
        }
        if (it.hasNext()) {
            throw new SBException("Error - XML document contains more than one user list");
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("StratigraphicScheme"));
        while (it.hasNext()) {
            this.addIGDScheme(new IGDScheme(this, (Element)it.next(), exceptions));
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("EnvironmentScheme"));
        while (it.hasNext()) {
            try {
                this.addEnvScheme(new EnvScheme(this, (Element)it.next()));
            }
            catch (SBPermissionException e) {
                throw new SBException("PermissionException from addEnvScheme: " + e.getMessage(), (Throwable)e);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("AgeCurve"));
        while (it.hasNext()) {
            try {
                this.addAgeCurve(AgeCurve.parseXML(this, (Element)it.next()));
            }
            catch (SBPermissionException e) {
                throw new SBException("PermissionException from addAgeCurve: " + e.getMessage(), (Throwable)e);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("AbundanceScheme"));
        while (it.hasNext()) {
            AbundanceScheme abundanceScheme = XmlReader.parseAbundanceScheme((Element)it.next());
            this.getAbundanceSchemeService().addAbundanceScheme(abundanceScheme);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonList"));
        while (it.hasNext()) {
            txList = (Element)it.next();
            for (Element xmlTx : txList.getContent((Filter)new ElementFilter("Taxon"))) {
                this.taxa.parseTaxon(xmlTx, zip);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonList"));
        while (it.hasNext()) {
            txList = (Element)it.next();
            for (Element el : txList.getContent((Filter)new ElementFilter("Genus"))) {
                this.taxa.parseGenus(el, zip);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonGroup"));
        while (it.hasNext()) {
            xmlGs = (Element)it.next();
            TxGroup group = this.parseTxGroup(xmlGs, zip);
            this.getTxGroups();
            this.txGroups.put(group.getID(), group);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("GroupSet"));
        while (it.hasNext()) {
            xmlGs = (Element)it.next();
            TxGroupSet set = this.parseTxGroupSet(xmlGs, zip);
            this.getTxGroupSets();
            this.sets.put(set.getID(), set);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("SynonymScheme"));
        while (it.hasNext()) {
            Element xmlSS = (Element)it.next();
            SynonymScheme synScheme = this.parseSynonymScheme(xmlSS, zip);
            if (this.synSch == null) {
                this.synSch = new SynSch(this);
            }
            this.synSch.put(synScheme.getSchID(), synScheme);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("Event"));
        while (it.hasNext()) {
            element = (Element)it.next();
            this.events.parseEvent(element);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("CompositeStandard"));
        while (it.hasNext()) {
            this.getCompositeStandards(true);
            element = (Element)it.next();
            CompositeStandard std = new CompositeStandard(this, element);
            if (std.getName() == null) continue;
            this.compositeStandards.put(std.getStdID(), std);
            if (dataTypes.contains(16)) continue;
            dataTypes.add(16);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("WirelineLogHeader"));
        while (it.hasNext()) {
            element = (Element)it.next();
            if (!"StrataBugs".equals(element.getParentElement().getName())) continue;
            this.getLogDefs();
            LogDef d = LogDef.parseXML(this, element);
            this.logDef.put(d.getAbr(), d);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("Well"));
        while (it.hasNext()) {
            try {
                Element well = (Element)it.next();
                this.wells.parseWell(well, dataTypes, zip, fileName);
            }
            catch (SBPermissionException sp) {
                throw new SBException(sp.getMessage(), (Throwable)sp);
            }
        }
    }

    private TxGroup parseTxGroup(Element xml, ZipFile zip) throws SBException, ParseException, SQLException {
        TxGroup group = TxGroup.parseTxGroup(xml, this);
        Element taxonList = xml.getChild("TaxonList");
        LinkedList<Taxon> grpTaxa = new LinkedList<Taxon>();
        if (taxonList != null) {
            for (Element el : taxonList.getContent((Filter)new ElementFilter("Taxon"))) {
                String strgID = el.getChildTextNormalize("SpeciesID");
                if (strgID == null) {
                    throw new SBException("ID null in XML - invalid");
                }
                int specID = Integer.parseInt(strgID);
                Taxon taxon = this.taxa.getTaxon(specID);
                if (taxon == null) {
                    throw new SBException("Unparsed taxon in group " + group.getName() + " (" + el.getChildTextNormalize("Species") + ")");
                }
                grpTaxa.add(taxon);
            }
        } else {
            for (Object o : xml.getChildren("Taxon")) {
                int specID = Integer.parseInt(((Element)o).getAttributeValue("SpeciesID"));
                if (this.getTaxon(specID) == null) assert (false);
                grpTaxa.add(this.getTaxon(specID));
            }
        }
        try {
            group.addTaxa(grpTaxa);
        }
        catch (SBPermissionException sp) {
            throw new SBException(sp.getMessage(), (Throwable)sp);
        }
        LinkedList<Genus> genera = new LinkedList<Genus>();
        if (taxonList != null) {
            for (Element el : taxonList.getContent((Filter)new ElementFilter("Genus"))) {
                String strgID = el.getChildTextNormalize("GenusID");
                if (strgID == null) {
                    throw new SBException("ID null in XML - invalid");
                }
                int genID = Integer.parseInt(strgID);
                Genus genus = this.taxa.getGenus(genID);
                if (genus == null) {
                    throw new SBException("Unparsed genus in group " + group.getName() + " (" + el.getChildTextNormalize("Genus") + ")");
                }
                genera.add(genus);
            }
        } else {
            for (Object o : xml.getChildren("Genus")) {
                int genID = Integer.parseInt(((Element)o).getAttributeValue("GenusID"));
                Genus genus = this.getGenus(genID);
                if (genus != null) {
                    genera.add(genus);
                    continue;
                }
                LOGGER.warning("Missing genus with id: " + genID + " for group " + group.getName() + " - probable malformed XML file");
            }
        }
        try {
            group.addGenera(genera);
        }
        catch (SBPermissionException sp) {
            throw new SBException(sp.getMessage(), (Throwable)sp);
        }
        return group;
    }

    private TxGroupSet parseTxGroupSet(Element xml, ZipFile zip) throws SBException, ParseException, SQLException {
        String name = xml.getChildText("SetName");
        String strgID = xml.getChildTextNormalize("SetID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int grpSetID = Integer.parseInt(strgID);
        Element ela = xml.getChild("Audit");
        Audit audit = null;
        if (ela != null) {
            try {
                audit = new Audit(this, ela);
            }
            catch (SBException sbe) {
                System.out.println("Message from Audit in TxGroupSet (ignored): " + sbe.getMessage());
            }
        } else {
            System.out.println("Warning: no audit info for TxGroupSet: " + String.valueOf(this));
        }
        String descr = xml.getChildTextNormalize("Description");
        boolean isOrdered = false;
        String ordered = xml.getChildTextNormalize("Ordered");
        if (ordered != null) {
            isOrdered = Boolean.parseBoolean(ordered);
        }
        TxGroupSet set = new TxGroupSet(this, grpSetID, name, 0, descr, audit, isOrdered);
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
        }
        for (Element el : xml.getContent((Filter)new ElementFilter("TaxonGroup"))) {
            TxGroup group = this.parseTxGroup(el, zip);
            this.txGroups.put(group.getID(), group);
            set.addGroupID(group.getID());
        }
        for (Element el : xml.getContent((Filter)new ElementFilter("Group"))) {
            int id = Integer.parseInt(el.getAttributeValue("GroupID"));
            assert (this.txGroups.get(id) != null);
            set.addGroupID(id);
        }
        return set;
    }

    private SynonymScheme parseSynonymScheme(Element xml, ZipFile zip) throws SBException, ParseException, SQLException {
        String name = xml.getChildText("SchemeName");
        String strgID = xml.getChildTextNormalize("SchemeID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int schemeID = Integer.parseInt(strgID);
        SynonymScheme scheme = new SynonymScheme(this, schemeID, name);
        for (Element el : xml.getContent((Filter)new ElementFilter("Entry"))) {
            strgID = el.getChildTextNormalize("SpeciesID");
            if (strgID == null) {
                throw new SBException("ID null in XML - invalid");
            }
            int specID = Integer.parseInt(strgID);
            strgID = el.getChildTextNormalize("PrefID");
            if (strgID == null) {
                throw new SBException("ID null in XML - invalid");
            }
            int prefID = Integer.parseInt(strgID);
            scheme.addSyn(specID, prefID);
        }
        return scheme;
    }

    public void parseTaxonList(File textFile) throws IOException, SQLException, SBException, SBPermissionException {
        if (this.isConnected() || this.taxa.getSize() > 0) {
            throw new IllegalStateException("Illegal use of taxon list parse in database");
        }
        BufferedReader in = new BufferedReader(new FileReader(textFile));
        String buff = in.readLine();
        int specID = 1;
        while (buff != null) {
            if (this.taxa.parse(buff, specID, false, null) != null) {
                ++specID;
            }
            buff = in.readLine();
        }
        TxGroup grp = new TxGroup(this, textFile.getName().substring(0, textFile.getName().lastIndexOf(46)), "NEW", this.nextTxGroupID(), 0, null);
        grp.addTaxa(this.taxa.getTaxa());
        this.putTxGroup(grp);
    }

    public HashMap<Taxon, Integer> parseBugWareDictionary(File textFile, CategoryService categoryService) throws IOException, SQLException, SBException, SBPermissionException {
        String buff;
        if (this.isConnected() || this.taxa.getSize() > 0) {
            throw new IllegalStateException("Illegal use of taxon list parse in database");
        }
        BufferedReader in = new BufferedReader(new FileReader(textFile));
        int specID = 1;
        int dictID = 0;
        HashMap<Taxon, Integer> numericCodes = new HashMap<Taxon, Integer>();
        HashSet<String> taxonNames = new HashSet<String>();
        while ((buff = in.readLine()) != null) {
            Object taxonStrg;
            if (buff.length() >= 32 && ((String)(taxonStrg = buff.substring(0, 32).trim())).length() > 0 && !((String)taxonStrg).equalsIgnoreCase("x") && !taxonNames.contains(((String)taxonStrg).toLowerCase())) {
                Taxon taxon;
                if (((String)taxonStrg).split(" ").length == 1) {
                    taxonStrg = (String)taxonStrg + " .";
                }
                com.stratadata.model3.taxon.Category category = null;
                if (buff.length() > 45) {
                    String categoryCode;
                    switch (categoryCode = buff.substring(44, 46)) {
                        case "01": {
                            category = categoryService.findCategory("FOBC").orElse(null);
                            break;
                        }
                        case "02": {
                            category = categoryService.findCategory("FOP").orElse(null);
                            break;
                        }
                        case "03": {
                            category = categoryService.findCategory("FOBA").orElse(null);
                        }
                    }
                }
                if (category != null && this.taxa.getCategory(category.getMnemonic()) == null) {
                    this.taxa.addCategory(category);
                }
                if ((taxon = this.taxa.parse((String)taxonStrg, specID, false, category)) != null) {
                    ++specID;
                    if (buff.length() > 32) {
                        String taxonCode = buff.substring(32, 44).trim();
                        taxon.setAlphaCode(taxonCode);
                    }
                } else {
                    System.out.println("Can't parse: " + buff);
                }
                numericCodes.put(taxon, dictID);
                taxonNames.add(((String)taxonStrg).toLowerCase());
            }
            ++dictID;
        }
        in.close();
        TxGroup grp = new TxGroup(this, textFile.getName().substring(0, textFile.getName().lastIndexOf(46)), null, this.nextTxGroupID(), 0, Color.BLACK);
        grp.addTaxa(this.taxa.getTaxa());
        this.putTxGroup(grp);
        return numericCodes;
    }

    private int nextTxGroupID() {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to get workspace TxGroup ID in connected database");
        }
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
        }
        int maxID = 1;
        for (Integer i : this.txGroups.keySet()) {
            if (i < maxID) continue;
            maxID = i + 1;
        }
        return maxID;
    }

    public Collection<Genus> getIndependentGenera() {
        if (this.isConnected()) assert (false);
        try {
            HashSet<Integer> genIDs = new HashSet<Integer>();
            for (TxGroup group : this.txGroups.values()) {
                genIDs.addAll(group.getGenIDs());
            }
            ArrayList<Genus> list = new ArrayList<Genus>();
            for (Integer genID : genIDs) {
                list.add(this.taxa.getGenus(genID));
            }
            return list;
        }
        catch (SQLException sql) {
            throw new IllegalStateException("Attempt to load genera in workspace", sql);
        }
    }

    public SBEvent fillEvent(SBdb db, SBEvent dbEvent) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill SBEvent into connected workspace");
        }
        SBEvent wsEvent = this.getSBEvent(dbEvent.getEvID());
        if (wsEvent == null) {
            Taxon wsTaxon = null;
            if (dbEvent.getTaxon() != null) {
                wsTaxon = this.fillTaxon(db, dbEvent.getTaxon());
            }
            wsEvent = this.events.copyToWorkspace(dbEvent, db, wsTaxon);
        }
        return wsEvent;
    }

    public IGDScheme fillIGDScheme(SBdb db, int schID) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill SBEvent into connected workspace");
        }
        IGDScheme scheme = this.getIGDScheme(schID);
        if (scheme == null) {
            IGDScheme dbScheme = db.getIGDScheme(schID);
            scheme = IGDScheme.copyToWorkspace(this, dbScheme);
            this.addIGDScheme(scheme);
        }
        return scheme;
    }

    public Taxon fillTaxon(SBdb db, Taxon dbTaxon) throws SQLException, SBException {
        return this.fillTaxon(db, dbTaxon, 0, false);
    }

    public Taxon fillTaxon(SBdb db, Taxon dbTaxon, int synSchID) throws SQLException, SBException {
        return this.fillTaxon(db, dbTaxon, synSchID, false);
    }

    private Taxon fillTaxon(SBdb db, Taxon dbTaxon, int synSchID, boolean copyTypeImageSet) throws SQLException, SBException {
        int typeImageSetID;
        Taxon wsTaxon;
        Optional preferredTerm;
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill taxon into connected workspace");
        }
        if (synSchID > 0 && (preferredTerm = db.getSynonymService().getPreferredTerm(synSchID, dbTaxon.getSpecID(), db.getTaxonService())).isPresent()) {
            dbTaxon = db.getTaxon(((com.stratadata.model3.taxon.Taxon)preferredTerm.get()).getSpecID());
        }
        if ((wsTaxon = this.getTaxon(dbTaxon.getSpecID())) == null) {
            wsTaxon = this.taxa.copyToWorkspace(dbTaxon, db);
        }
        if (copyTypeImageSet && (typeImageSetID = db.getTaxonImageService().getTypeImageSetID(dbTaxon.getSpecID())) > 0 && !this.getTaxonImageService().hasTypeImage(wsTaxon.getSpecID())) {
            List imageRecords = db.getImageRecordService().getImageRecords(typeImageSetID);
            this.getImageRecordService().storeImageSet(typeImageSetID, imageRecords, db.getImageLoader());
            this.getTaxonImageService().addTaxonImageSet(wsTaxon.getSpecID(), new TaxonImageSet(typeImageSetID, wsTaxon.getSpecID(), true));
        }
        return wsTaxon;
    }

    private Genus fillGenus(SBdb db, Genus dbGenus) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill taxon into connected workspace");
        }
        Genus wsGenus = this.getGenus(dbGenus.getGenID());
        if (wsGenus == null) {
            wsGenus = this.taxa.copyToWorkspace(dbGenus, db);
        }
        return wsGenus;
    }

    public AbstractMultiStageProcess.ProcessResult fillTaxonFromWorkspace(SBdb ws, com.stratadata.model3.taxon.Taxon wsTaxon, com.stratadata.model3.taxon.Category category) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Attempt to fill taxon to unconnected database");
        }
        return this.taxa.copyToDataBase(wsTaxon, ws, category);
    }

    public Genus fillGenusFromWorkspace(SBdb ws, Genus wsGenus) throws SQLException, SBException, SBPermissionException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Attempt to fill genus to unconnected database");
        }
        return this.taxa.copyToDataBase(wsGenus, ws);
    }

    public Category fillCategory(SBdb db, com.stratadata.model3.taxon.Category dbCat) throws SQLException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill Category to connected database");
        }
        return this.taxa.fillCategory(dbCat, db);
    }

    void fillAbundanceScheme(SBdb SB2, int abnSchID) {
        if (this.abundanceSchemeService.findAbundanceScheme(abnSchID).isEmpty()) {
            AbundanceSchemeImpl copyOfDbScheme = SB2.getAbundanceSchemeService().findAbundanceScheme(abnSchID).map(sch -> new AbundanceSchemeImpl(sch)).orElseThrow();
            this.abundanceSchemeService.addAbundanceScheme((AbundanceScheme)copyOfDbScheme);
            AbundanceSchemeService abundanceSchemeService = this.abundanceSchemeService;
            if (abundanceSchemeService instanceof AbundanceSchemeServiceImpl) {
                AbundanceSchemeServiceImpl wsImpl = (AbundanceSchemeServiceImpl)abundanceSchemeService;
                wsImpl.setLink(abnSchID, (AbundanceScheme)copyOfDbScheme);
            }
        }
    }

    void fillEnvScheme(SBdb SB2, int envSchID) throws SQLException, SBException {
        if (this.getEnvScheme(envSchID) == null) {
            EnvScheme envScheme = EnvScheme.createCopy(SB2.getEnvScheme(envSchID), this);
            this.envSchemes.put(envScheme.getID(), envScheme);
        }
    }

    public void fillTxGroup(SBdb db, int grpID) throws SQLException, SBException {
        if (this.isConnected() || !db.isConnected()) {
            throw new IllegalStateException("Illegal workspace copy");
        }
        if (this.getTxGroup(grpID) != null) {
            return;
        }
        TxGroup dbGroup = db.getTxGroup(grpID);
        if (dbGroup.getAudit().getCreator() > 0) {
            this.fillUser(db, dbGroup.getAudit().creator);
        }
        if (dbGroup.getAudit().getModifier() > 0) {
            this.fillUser(db, dbGroup.getAudit().modifier);
        }
        TxGroup wsGroup = TxGroup.copyToWorkspace(this, dbGroup);
        ArrayList<Taxon> wsTaxa = new ArrayList<Taxon>();
        Statement dbStmt = db.getDatabase() != null ? db.getDatabase().createStatement() : null;
        for (Taxon taxon : db.getTxGroupTaxa(dbGroup, false)) {
            Taxon wsTaxon = this.fillTaxon(db, taxon, 0, true);
            wsTaxa.add(wsTaxon);
        }
        dbStmt.close();
        ArrayList<Genus> wsGenera = new ArrayList<Genus>();
        for (Genus genus : db.getTxGroupGenera(dbGroup)) {
            wsGenera.add(this.fillGenus(db, genus));
        }
        try {
            wsGroup.addTaxa(wsTaxa);
            wsGroup.addGenera(wsGenera);
        }
        catch (SBPermissionException sBPermissionException) {
            throw new IllegalStateException("Unexpected permission exception in workspace", sBPermissionException);
        }
        this.txGroups.put(grpID, wsGroup);
    }

    public void fillTxGroupSet(SBdb db, int grpSetID) throws SQLException, SBException {
        if (this.isConnected() || !db.isConnected()) {
            throw new IllegalStateException("Illegal workspace copy");
        }
        if (this.getTxGroupSet(grpSetID) != null) {
            return;
        }
        TxGroupSet dbSet = db.getTxGroupSet(grpSetID);
        TxGroupSet wsSet = TxGroupSet.copyToWorkspace(this, dbSet);
        for (TxGroup group : dbSet.getGroups()) {
            this.fillTxGroup(db, group.getID());
            wsSet.addGroupID(group.getID());
        }
        this.sets.put(grpSetID, wsSet);
    }

    public void fillTxList(SBdb db, List<Taxon> list, int synSchID) throws SQLException, SBException {
        if (this.isConnected() || !db.isConnected()) {
            throw new IllegalStateException("Illegal workspace copy");
        }
        ArrayList<Taxon> wsTaxa = new ArrayList<Taxon>();
        for (Taxon dbTaxon : list) {
            Taxon wsTaxon = this.fillTaxon(db, dbTaxon, 0, true);
            wsTaxa.add(wsTaxon);
            if (synSchID <= 0 || dbTaxon.getPreferred(synSchID) == null) continue;
            wsTaxon = this.fillTaxon(db, dbTaxon.getPreferred(synSchID), 0, true);
            wsTaxa.add(wsTaxon);
        }
        if (synSchID > 0) {
            SynonymScheme synScheme = ((SynonymScheme)((Object)db.synSch.get(synSchID))).copyToWorkspace(this, true);
            this.getSynSchemes();
            this.synSch.put(synSchID, synScheme);
        }
    }

    public int getAddIGDScheme(String string, String comments, int igdType, char discID) throws SQLException, SBException {
        IGDScheme scheme = this.getIGDScheme(string, igdType);
        if (scheme == null) {
            scheme = new IGDScheme(this, igdType, string, comments, Discipline.getDisc((char)discID), igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null, 0);
            scheme.storeDetails();
            this.addIGDScheme(scheme);
            System.out.println("Added IGD Scheme: " + String.valueOf(scheme));
        }
        return scheme.getSchID();
    }

    private int findMaxID(int schID, HashMap<Integer, IGDScheme> schemeMap) {
        if (schemeMap == null) {
            return schID;
        }
        for (int existingID : schemeMap.keySet()) {
            if (existingID < schID) continue;
            schID = existingID + 1;
        }
        return schID;
    }

    public boolean canDeleteSBEvent(SBEvent event) throws SQLException, SBException {
        try (Statement stmt = this.getDatabase().createStatement();){
            String[] sqla = new String[]{"SELECT acm FROM " + this.DBTableName("CMPSTDEV") + " e, " + this.DBTableName("CMPSTD") + " c WHERE e.ev_id=" + event.getEvID() + " AND e.std_id=c.std_id", "SELECT acm FROM " + this.DBTableName("WELLS") + " w, " + this.DBTableName("EVENTS") + " e WHERE e.ev_id=" + event.getEvID() + " AND w.well_id=e.well_id", "SELECT acm FROM " + this.DBTableName("CHARTCORR") + " c, " + this.DBTableName("CHTLN_EV") + " e WHERE e.ev_id=" + event.getEvID() + " AND c.CORRSCH_ID=e.CORRSCH_ID"};
            for (String sql : sqla) {
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    int acm = rs.getInt("acm");
                    if (acm != 128) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    public void deleteSBEvent(SBEvent event) throws SQLException, SBPermissionException, SBException {
        this.events.deleteEvent(event.getEvID());
        Iterator<Well> wit = this.getWellIterator();
        while (wit.hasNext()) {
            Well well = wit.next();
            well.loadInterps();
            Iterator<WellInterp> iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = iit.next();
                if (interp.getEvents() == null) continue;
                Iterator<WellEvent> evIt = interp.getEvents().iterator();
                while (evIt.hasNext()) {
                    WellEvent wellEvent = evIt.next();
                    if (wellEvent.getEvent() != event) continue;
                    evIt.remove();
                }
            }
        }
        if (this.compositeStandards != null) {
            for (CompositeStandard std : this.compositeStandards.values()) {
                std.loadEvents();
                LinkedList<CompositeStandardEvent> toKill = new LinkedList<CompositeStandardEvent>();
                for (CompositeStandardEvent cmpEvent : std.getEvents(false)) {
                    if (cmpEvent.getEvent() != event) continue;
                    toKill.add(cmpEvent);
                }
                if (toKill.isEmpty()) continue;
                std.deleteEvents(toKill);
            }
        }
        this.setChanged();
    }

    public void clearUsers() {
        if (this.users != null) {
            this.users.clear();
            this.users = null;
        }
    }

    public void deleteOverlay(Overlay overlay) throws SQLException, SBException, SBPermissionException {
        overlay.delete();
        this.overlays.remove(overlay.getOvrID());
        this.updateAuditTrail("OVERLAY", "DELETE " + String.valueOf(overlay) + " [" + overlay.getOvrID() + "]");
    }

    public void deleteCompositeStandard(CompositeStandard std) throws SQLException, SBException {
        std.delete();
        this.compositeStandards.remove(std.getStdID());
        this.updateAuditTrail("CMPSTD", "DELETE " + std.getName() + " [" + std.getID() + "]");
    }

    public HashMap<Integer, String> getSIPMDicts() throws SQLException {
        if (this.sipmDicts == null) {
            this.loadSipmDicts();
        }
        return this.sipmDicts;
    }

    private void loadSipmDicts() throws SQLException {
        this.sipmDicts = new HashMap();
        String sql = "SELECT ccode,txt FROM " + this.DBTableName("sipmdict") + " ORDER BY ccode";
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int countryCode = rs.getInt("ccode");
                String text = rs.getString("txt");
                this.sipmDicts.put(countryCode, text);
            }
        }
    }

    public String getSipmDict(int cCode) throws SQLException {
        if (this.sipmDicts == null) {
            this.loadSipmDicts();
        }
        return this.sipmDicts.get(cCode);
    }

    public int addSipmDict(String sipmArea) throws SQLException, SBException {
        int ccode;
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "SELECT ccode FROM " + this.DBTableName("sipmdict") + " WHERE ucase(txt)='" + sipmArea.toUpperCase() + "'";
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            if (rs.next()) {
                throw new SBException("SIPMDict entry already exists: " + sipmArea);
            }
            ccode = this.nextControl("sipmdict", "ccode");
            if (this.getSipmDict(ccode) != null) {
                throw new SBException("New ccode in SipmDict already exists");
            }
            sql = "INSERT INTO " + this.DBTableName("sipmdict") + "(ccode,txt) VALUES (" + ccode + "," + SB.DBString((String)sipmArea) + ")";
            stmt.executeUpdate(this.modQuery(sql));
        }
        this.sipmDicts.put(ccode, sipmArea);
        return ccode;
    }

    public int deleteSipmDict(int ccode) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this)) {
            throw new SBPermissionException("Insufficient privilege to delete numeric code dictionary");
        }
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
            stmt.executeUpdate(this.modQuery(sql));
            sql = "DELETE FROM " + this.DBTableName("sipmdict") + " WHERE ccode=" + ccode;
            stmt.executeUpdate(this.modQuery(sql));
        }
        this.sipmDicts.remove(ccode);
        return ccode;
    }

    public int clearSipmDict(int ccode) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this)) {
            throw new SBPermissionException("Insufficient privilege to delete numeric code dictionary");
        }
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
            stmt.executeUpdate(this.modQuery(sql));
        }
        return ccode;
    }

    public int getSipmDictEntryCount(int ccode) throws SQLException, SBException {
        int nSpec;
        block7: {
            try (Statement stmt = this.getDatabase().createStatement();){
                String sql = "SELECT count(spec_id) AS nSpec FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                nSpec = 0;
                if (rs.next()) {
                    nSpec = rs.getInt("nSpec");
                    break block7;
                }
                throw new SBException("Error getting number of species from sipmcode table");
            }
        }
        return nSpec;
    }

    public HashMap<Integer, Integer> getSipmDictEntries(int ccode, boolean keyIsSpecID) throws SQLException {
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "SELECT spec_id, sipm_code FROM " + this.DBTableName("sipmcode") + " WHERE ccode=" + ccode;
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            HashMap<Integer, Integer> dict = new HashMap<Integer, Integer>();
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                int sipmCode = rs.getInt("sipm_code");
                if (keyIsSpecID) {
                    dict.put(specID, sipmCode);
                    continue;
                }
                dict.put(sipmCode, specID);
            }
            HashMap<Integer, Integer> hashMap = dict;
            return hashMap;
        }
    }

    public void deleteLogdef(LogDef d) throws SQLException, SBException, SBPermissionException {
        d.delete();
        this.logDef.remove(d.getAbr());
        this.updateAuditTrail("LOGDEF", "DELETE " + d.getTitle() + " [" + d.getAbr() + "]");
    }

    public LogDef addLogDef(String abr, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) throws SQLException, SBException, SBPermissionException {
        LogDef newEntry = new LogDef(this, abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
        newEntry.store();
        this.logDef.put(abr, newEntry);
        return newEntry;
    }

    public void updateLogDef(LogDef logDefEntry, String abr, String title, String units, float minval, float maxval, boolean asLog, Color backColour, Color lineColour, int penStyle, int traceStyle, float penWidth, boolean wrapTrace, int symbol) throws SQLException, SBException, SBPermissionException {
        if (!logDefEntry.getAbr().equals(abr)) {
            LogDef replacement = new LogDef(this, abr, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
            replacement.store();
            replacement.updateCurveAbr(logDefEntry.getAbr());
            this.logDef.remove(logDefEntry.getAbr());
            logDefEntry.delete();
            this.logDef.put(abr, replacement);
        } else {
            logDefEntry.update(this, title, units, minval, maxval, asLog, backColour, lineColour, penStyle, traceStyle, penWidth, wrapTrace, symbol);
        }
    }

    @Deprecated
    void removeImageSetTxRefs(int imageSetID) {
    }

    public final void setSampleTops(boolean b, boolean isGlobal) throws SQLException {
        SystemPreferences.getInstance().setPreference("SAMPLETOPS", b);
        if (this.isConnected()) {
            if (isGlobal) {
                this.putDatabasePref("sampletops", b);
                Lastval.delete(this, "sampletops");
            } else {
                Boolean globalPref = this.getDatabasePrefBool("sampletops");
                if (globalPref != null && globalPref.equals(b)) {
                    Lastval.delete(this, "sampletops");
                } else {
                    Lastval.putInt(this, "sampletops", b ? 1 : 0);
                }
            }
        }
    }

    public boolean getSampleTops() throws SQLException {
        Boolean which = null;
        try {
            String userSampleTopString = Lastval.getString(this, "sampletops");
            if (userSampleTopString != null && !userSampleTopString.isBlank()) {
                which = Integer.valueOf(userSampleTopString) == 1;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error getting sampletops from PREF_USER: ", e);
        }
        if (which == null) {
            which = this.getDatabasePrefBool("sampletops");
        }
        if (which != null) {
            SystemPreferences.getInstance().setPreference("SAMPLETOPS", which.booleanValue());
        }
        return this.useSampleTops();
    }

    public final void setAuditTrail(boolean b) throws SQLException, SBPermissionException {
        if ((this.getUser().getPriv() & 0x40) <= 0) {
            throw new SBPermissionException("You must be a super user to change this setting.");
        }
        if (b != this.auditTrail) {
            this.auditTrail = b;
            if (this.isConnected()) {
                this.putDatabasePref("audittrail", this.auditTrail);
                this.updateAuditTrail("AUDITTRAIL", "Switch audit recording " + (this.auditTrail ? "on" : "off"));
            }
        }
    }

    public boolean getAuditTrail() {
        return this.auditTrail;
    }

    private void queryAuditTrail() throws SQLException {
        Boolean which = this.getDatabasePrefBool("audittrail");
        if (which != null) {
            this.auditTrail = which;
        }
    }

    private void setEventPrefixes() throws SQLException {
        Boolean singlePrefix = this.getDatabasePrefBool("EVENTPRSGL");
        if (singlePrefix == null) {
            singlePrefix = true;
        }
        String f_well = this.getDatabasePref("EVENTPRXWT");
        String l_well = this.getDatabasePref("EVENTPRXWB");
        String f_scheme = this.getDatabasePref("EVENTPRXCT");
        String l_scheme = this.getDatabasePref("EVENTPRXCB");
        EventType.setPrefixes((String)f_well, (String)l_well, (String)f_scheme, (String)l_scheme, (boolean)singlePrefix);
    }

    public final void setAllowMultipleEnvSchemes(boolean b) throws SQLException {
        this.allowMultipleEnvSchemes = b;
        if (this.isConnected()) {
            this.putDatabasePref("multenvsch", this.allowMultipleEnvSchemes);
        }
    }

    public boolean getAllowMultipleEnvSchemes() throws SQLException {
        Boolean which = this.getDatabasePrefBool("multenvsch");
        if (which != null) {
            this.allowMultipleEnvSchemes = which;
        }
        return this.allowMultipleEnvSchemes;
    }

    public final void setAllowCountryCase(boolean b) throws SQLException {
        this.allowCountryCase = b;
        if (this.isConnected()) {
            this.putDatabasePref("countrycse", this.allowCountryCase);
        }
    }

    public boolean getAllowCountryCase() throws SQLException {
        Boolean which = this.getDatabasePrefBool("countrycse");
        if (which != null) {
            this.allowCountryCase = which;
        }
        return this.allowCountryCase;
    }

    public boolean getShowArchivedSchemes() {
        String s = Lastval.tryGetString(this, "ARCHIVEDSCH");
        this.showArchivedSchemes = Boolean.valueOf(s);
        return this.showArchivedSchemes;
    }

    public void putShowArchivedSchemes(boolean value) {
        if (this.isConnected()) {
            Lastval.tryPutString(this, "ARCHIVEDSCH", Boolean.toString(value));
        }
        this.showArchivedSchemes = value;
    }

    public String getDBCharType() {
        if (this.connectionManager.getDBType() == DBType.ORACLE) {
            return "varchar2";
        }
        if (this.connectionManager.getDBType() == DBType.MYSQL || this.connectionManager.getDBType() == DBType.MSSQLSERVER) {
            return "varchar";
        }
        return "text";
    }

    public String DBBoolean(Boolean bool) {
        if (bool == null) {
            return "null";
        }
        return switch (this.connectionManager.getDBType()) {
            case DBType.POSTGRESQL, DBType.H2 -> {
                if (bool.booleanValue()) {
                    yield "true";
                }
                yield "false";
            }
            default -> bool != false ? "1" : "0";
        };
    }

    public int setNullSampleDepths(boolean setTops) throws SQLException {
        String sql;
        try (Statement stmt = this.getDatabase().createStatement();){
            sql = "UPDATE " + this.DBTableName("samples") + " SET ";
            sql = setTops ? sql + " top_depth=NULL " : sql + " base_depth=NULL ";
            sql = sql + " WHERE top_depth=base_depth";
            int nRows = stmt.executeUpdate(this.modQuery(sql));
            System.out.println("First tranche nrows: " + nRows);
            sql = "UPDATE " + this.DBTableName("samples") + " SET ";
            sql = setTops ? sql + " base_depth=top_depth, top_depth=NULL WHERE base_depth is NULL AND top_depth is not NULL" : sql + " top_depth=base_depth, base_depth=NULL WHERE top_depth is NULL AND base_depth is not NULL ";
        }
        return nRows += stmt.executeUpdate(this.modQuery(sql));
    }

    public void mergeEvents(SBEvent donorEvent, SBEvent targetEvent) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.getDatabase().createStatement();
             Statement auditStmt = this.getDatabase().createStatement();){
            TreeSet<CallSite> deleteSql = new TreeSet<CallSite>();
            String sql = "SELECT e1.well_id, e1.interp_id, e1.samp_id, e1.ev_type FROM " + this.DBTableName("events") + " e1, " + this.DBTableName("events") + " e2  WHERE e1.well_id=e2.well_id AND e1.interp_id=e2.interp_id AND e1.samp_id=e2.samp_id AND e1.ev_type=e2.ev_type AND  e1.ev_id=" + donorEvent.getEvID() + " AND e2.ev_id=" + targetEvent.getEvID();
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int interpID = rs.getInt("interp_id");
                int sampID = rs.getInt("samp_id");
                char evType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
                Iterator<Well> wit = this.wells.getWellIterator();
                block11: while (wit.hasNext()) {
                    Well well = wit.next();
                    if (well.getWellID() != wellID) continue;
                    Iterator<WellInterp> iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp wellInterp = iit.next();
                        if (wellInterp.getHeader().getInterpID() != interpID) continue;
                        Iterator<WellEvent> eit = wellInterp.getEvents().iterator();
                        while (eit.hasNext()) {
                            WellEvent wellEvent = eit.next();
                            if (wellEvent.getSampID() != sampID || wellEvent.getEvent().getEvID() != donorEvent.getEvID() || wellEvent.getCharType() != evType) continue;
                            System.out.println("Removing event from well: " + String.valueOf(well) + ", sample: " + String.valueOf(well.getSample(sampID)));
                            eit.remove();
                            break block11;
                        }
                    }
                }
                deleteSql.add((CallSite)((Object)("DELETE FROM " + this.DBTableName("events") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND samp_id=" + sampID + " AND ev_type=" + SB.DBChar((char)evType) + " AND ev_id=" + donorEvent.getEvID())));
            }
            while (!deleteSql.isEmpty()) {
                int nRows = stmt.executeUpdate(this.modQuery((String)deleteSql.pollFirst()));
                if (nRows != 0) continue;
                throw new SBException("Error: no rows deleted in statement: " + SqlCache.getSql());
            }
            Audit audit = new Audit();
            sql = "UPDATE " + this.DBTableName("events") + " SET ev_id=" + targetEvent.getEvID() + "," + audit.sqlUpdate(this, auditStmt, true) + " WHERE ev_id=" + donorEvent.getEvID();
            stmt.executeUpdate(this.modQuery(sql));
            Iterator<Well> wit = this.wells.getWellIterator();
            while (wit.hasNext()) {
                Well well = wit.next();
                well.loadInterps();
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp wellInterp = iit.next();
                    for (WellEvent wellEvent : wellInterp.getEvents()) {
                        if (wellEvent.getEvent().getEvID() != donorEvent.getEvID()) continue;
                        wellEvent.setEvent(targetEvent);
                    }
                }
            }
            sql = "SELECT e1.std_id,e1.ev_type FROM " + this.DBTableName("cmpstdev") + " e1, " + this.DBTableName("cmpstdev") + " e2  WHERE e1.std_id=e2.std_id AND e1.ev_type=e2.ev_type AND  e1.ev_id=" + donorEvent.getEvID() + " AND e2.ev_id=" + targetEvent.getEvID();
            rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int stdID = rs.getInt("std_id");
                char evType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
                for (CompositeStandard std : this.getCompositeStandards(true)) {
                    if (std.getStdID() != stdID) continue;
                    std.loadEvents();
                    Iterator<CompositeStandardEvent> cit = std.getEvents(false).iterator();
                    while (cit.hasNext()) {
                        CompositeStandardEvent event = cit.next();
                        if (event.getEvID() != donorEvent.getEvID() || event.getEvType() != evType) continue;
                        cit.remove();
                    }
                }
                deleteSql.add((CallSite)((Object)("DELETE FROM " + this.DBTableName("cmpstdev") + " WHERE std_id=" + stdID + " AND ev_type=" + SB.DBChar((char)evType) + " AND ev_id=" + donorEvent.getEvID())));
            }
            while (!deleteSql.isEmpty()) {
                int nRows = stmt.executeUpdate(this.modQuery((String)deleteSql.pollFirst()));
                if (nRows != 0) continue;
                throw new SBException("Error: no rows deleted in statement: " + SqlCache.getSql());
            }
            sql = "UPDATE " + this.DBTableName("cmpstdev") + " SET ev_id=" + targetEvent.getEvID() + "," + audit.sqlUpdate(this, auditStmt, true) + " WHERE ev_id=" + donorEvent.getEvID();
            stmt.executeUpdate(this.modQuery(sql));
            for (CompositeStandard std : this.getCompositeStandards(true)) {
                std.loadEvents();
                for (CompositeStandardEvent event : std.getEvents(false)) {
                    if (event.getEvID() != donorEvent.getEvID()) continue;
                    event.setSBEvent(targetEvent);
                }
            }
            deleteSql.clear();
            sql = "SELECT e1.corrsch_id,e1.ev_type FROM " + this.DBTableName("chtln_ev") + " e1, " + this.DBTableName("chtln_ev") + " e2  WHERE e1.corrsch_id=e2.corrsch_id AND e1.ev_type=e2.ev_type AND  e1.ev_id=" + donorEvent.getEvID() + " AND e2.ev_id=" + targetEvent.getEvID();
            rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int stdID = rs.getInt("corrsch_id");
                String evType = SB.getDBString((ResultSet)rs, (String)"ev_type");
                deleteSql.add((CallSite)((Object)("DELETE FROM " + this.DBTableName("chtln_ev") + " WHERE corrsch_id=" + stdID + " AND ev_type=" + SB.DBString((String)evType) + " AND ev_id=" + donorEvent.getEvID())));
            }
            while (!deleteSql.isEmpty()) {
                int nRows = stmt.executeUpdate(this.modQuery((String)deleteSql.pollFirst()));
                if (nRows != 0) continue;
                throw new SBException("Error: no rows deleted in statement: " + SqlCache.getSql());
            }
            sql = "UPDATE " + this.DBTableName("chtln_ev") + " SET ev_id=" + targetEvent.getEvID() + " WHERE ev_id=" + donorEvent.getEvID();
            stmt.executeUpdate(this.modQuery(sql));
            this.events.deleteEvent(donorEvent.getEvID());
            this.updateAuditTrail("SBEVENT", "MERGE " + String.valueOf(donorEvent) + " [" + donorEvent.getEvID() + "] with " + String.valueOf(targetEvent) + " [" + targetEvent.getEvID() + "]");
            this.setChanged();
        }
    }

    public boolean hasSoundex() {
        switch (this.connectionManager.getDBType()) {
            case H2: 
            case ORACLE: 
            case MSSQLSERVER: 
            case MYSQL: {
                return true;
            }
        }
        return false;
    }

    public Collection<Taxon> getTaxa() {
        return this.taxa.getTaxa();
    }

    public Collection<SBEvent> getEvents() {
        return this.events.getEvents();
    }

    public boolean hasTaxa() {
        return this.taxa != null ? this.taxa.getSize() > 0 : false;
    }

    public boolean hasTaxon(Taxon taxon) {
        return this.taxa.hasTaxon(taxon);
    }

    public Set<Taxon> getTaxa(int genID) throws SQLException {
        return this.taxa.getTaxa(genID);
    }

    public void matchTaxon(Taxon wsTaxon, boolean ignoreUnknownCategories) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Illegal connection status in match taxon");
        }
        this.taxa.matchTaxon(wsTaxon, ignoreUnknownCategories);
    }

    public void matchAllGeneraIndependent(SBdb db, boolean ignoreUnknownCategories) throws SQLException {
        if (this.isConnected() || !db.isConnected()) {
            throw new IllegalStateException("Illegal connection status in match all genera");
        }
        this.taxa.matchGenera(db, this.getIndependentGenera(), ignoreUnknownCategories);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.events) {
            this.setChanged();
            if (arg != null && arg instanceof SBEvent) {
                this.notifyObservers(arg);
            } else {
                this.notifyObservers(SBEvent.class);
            }
        }
    }

    public boolean restrictedToDiscID(char discID) {
        int priv = this.getUser().getPriv();
        if ((priv & 0x40) > 0) {
            return false;
        }
        return (priv & 4) > 0 && discID != this.getUser().getDiscipline().getChar();
    }

    public boolean restrictedToDiscID(Discipline discID) {
        int priv = this.getUser().getPriv();
        if ((priv & 0x40) > 0) {
            return false;
        }
        return (priv & 4) > 0 && discID != this.getUser().getDiscipline();
    }

    public HashSet<String> getDonorSampleTypes() throws SQLException, SBException {
        HashSet<String> donorTypes = null;
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            for (Sample sample : well.getSamples()) {
                if (sample.donorSampleType == null) continue;
                if (donorTypes == null) {
                    donorTypes = new HashSet<String>();
                }
                donorTypes.add(sample.donorSampleType);
            }
        }
        return donorTypes;
    }

    public void reloadReassignedEnvScheme(EnvScheme scheme) throws SQLException, SBException {
        Iterator<Well> wit = this.wells.getWellIterator();
        while (wit.hasNext()) {
            Well well = wit.next();
            if (well.interps == null) continue;
            Iterator<WellInterp> iit = well.getInterpIterator();
            block1: while (iit.hasNext()) {
                WellInterp wellInterp = iit.next();
                for (EnvScheme e : wellInterp.getEnvSchemes()) {
                    if (e.getID() != scheme.getID()) continue;
                    wellInterp.loadEnvs(well);
                    wellInterp.setChanged(null);
                    IGDIntervalEnv arg = null;
                    Iterator<IGDIntervalEnv> iterator = wellInterp.getEnvs().iterator();
                    if (iterator.hasNext()) {
                        IGDIntervalEnv env;
                        arg = env = iterator.next();
                    }
                    if (arg == null) continue block1;
                    wellInterp.notifyObservers(arg);
                    continue block1;
                }
            }
        }
    }

    public DBType getDBType() {
        return this.connectionManager.getDBType();
    }

    public Userdef getUser() {
        return this.user;
    }

    public void setUser(String abr) throws SBException, SQLException {
        this.getUsers();
        for (Userdef temp : this.users.values()) {
            if (!temp.getAbr().equals(abr)) continue;
            this.user = temp;
            break;
        }
        if (this.user == null) {
            throw new SBException("Attempt to set user to invalid abbreviation: " + abr);
        }
    }

    public String getUserObjectTimestamp() throws SBException {
        if (this.getUser() == null) {
            throw new SBException("User not set in sbdb");
        }
        String strg = "'" + SB.DBdf.format(new Date()) + "',";
        strg = strg + this.getUser().getUsrID();
        return strg;
    }

    public boolean needsPassword() {
        return this.needsPassword;
    }

    public boolean hasTVDplan() {
        return this.hasTVDplan;
    }

    public boolean hasWellsMaster() {
        return this.hasWellsMaster;
    }

    public boolean hasCoresMaster() {
        return this.hasCoresMaster;
    }

    public boolean hasCasingMaster() {
        return this.hasCasingMaster;
    }

    public boolean hasSmarkMaster() {
        return this.hasSmarkMaster;
    }

    public boolean hasUserPassword() {
        return this.hasUserPassword;
    }

    public boolean hasWITSML() {
        return this.hasWITSML;
    }

    public static boolean isInterpDataType(int dType) throws SBException {
        switch (dType) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return false;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 29: {
                return true;
            }
        }
        throw new SBException("Unknown data type: " + dType + " passed to isInterpDataType");
    }

    public static native String getReg(String var0);

    public static native String getUReg(String var0);

    public static native String getRegOption(String var0);

    public static native String getURegOption(String var0);

    public Taxon getTaxon(int specID) throws SQLException {
        return this.getTaxon(specID, null);
    }

    public Taxon getTaxon(int specID, PreparedStatement pStmt) throws SQLException {
        return this.taxa.getTaxon(specID, pStmt);
    }

    public Taxon getTaxon(String donorString, int specID, boolean notNull) {
        Taxon taxon = this.taxa.getTaxon(donorString, specID);
        if (taxon == null) {
            taxon = this.taxa.parse(donorString, specID, notNull, null);
        }
        return taxon;
    }

    public Taxon getTaxon(Taxon.Builder builder) {
        return this.taxa.getTaxon(builder);
    }

    @Override
    public CategoryService getCategoryService() {
        return this.taxa.getCategoryService();
    }

    @Override
    public GenusService getGenusService() {
        return this.taxa;
    }

    @Override
    public TaxonService getTaxonService() {
        return this.taxa;
    }

    public void setTaxonCat(int specID, String cat_mnem) {
        this.taxa.setTaxonCat(specID, cat_mnem);
    }

    public void checkDeleteGenus(int genID) throws SQLException, SBException {
        this.taxa.checkDeleteGenus(genID);
    }

    public Taxon addTaxon(Taxon.Builder txBuilder, Genus.Builder genBuilder, String cat_mnem, int specID, String donorString) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to add Taxon to database");
        }
        Taxon taxon = this.taxa.getTaxon(specID);
        if (taxon == null) {
            taxon = this.taxa.addTaxon(txBuilder, genBuilder, cat_mnem, specID, null);
            taxon.donorString = donorString;
        } else {
            Category cat = this.taxa.getCategory(cat_mnem);
            if (cat != null) {
                genBuilder.genus.setCategory(cat.getCategoryCopy());
            }
            if (!taxon.equalsBuilder(txBuilder) || !taxon.getGenus().equalsBuilder(genBuilder, false)) {
                throw new SBException("Duplicate species IDs in workspace for: " + taxon.toString() + " and " + genBuilder.getName() + " " + txBuilder.getName());
            }
        }
        return taxon;
    }

    public void copyLinkedTaxon(int specID) {
        this.taxa.copyLink(specID);
    }

    public void copyLinkedEvent(int evID) {
        this.events.copyLink(evID);
    }

    public Category getCategory(String mnem) throws SQLException {
        return this.taxa.getCategory(mnem);
    }

    public Collection<Overlay> getOverlays() throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        return this.overlays.values();
    }

    public Overlay getOverlay(int ovrID) throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        return this.overlays.get(ovrID);
    }

    public Overlay getOverlay(String name) throws SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        for (Overlay overlay : this.overlays.values()) {
            if (!overlay.getName().equalsIgnoreCase(name)) continue;
            return overlay;
        }
        return null;
    }

    public void addOverlay(Overlay overlay) throws SBException, SQLException {
        if (this.overlays == null) {
            this.overlays = Overlay.loadAll(this);
        }
        if (this.overlays.put(overlay.getOvrID(), overlay) != null) {
            throw new SBException("Error putting new overlay: Over;lay ID already exists");
        }
    }

    public SpeciesTypeService getSpeciesTypeService() {
        return this.speciesTypeService;
    }

    public int[] getSpecTypeUsage(int iType) throws SQLException {
        int[] nOccs = new int[2];
        if (iType > 0) {
            try (Statement stmt = this.getDatabase().createStatement();){
                String sql = "SELECT count(spec_type_id) AS nocc FROM " + this.DBTableName("taxonocc") + " WHERE spec_type_id=" + iType;
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                if (rs.next()) {
                    nOccs[0] = rs.getInt("nocc");
                }
                if ((rs = stmt.executeQuery(this.modQuery(sql = "SELECT count(panel_id) as nocc FROM " + this.DBTableName("CHTSPECTYPE") + " WHERE spec_type_id=" + iType + " GROUP BY panel_id"))).next()) {
                    nOccs[1] = rs.getInt("nocc");
                }
            }
        }
        return nOccs;
    }

    public boolean useSampleTops() {
        return SystemPreferences.getInstance().useSampleTops();
    }

    public boolean allowMultipleEnvSchemes() {
        return this.allowMultipleEnvSchemes;
    }

    public boolean allowCountryCase() {
        return this.allowCountryCase;
    }

    public Set<LogDef> getLogDefs() throws SQLException {
        if (this.logDef == null) {
            this.logDef = new HashMap();
            if (this.isConnected()) {
                LogDef.load(this, this.logDef);
            }
        }
        return new HashSet<LogDef>(this.logDef.values());
    }

    public ArrayList<String> getLogDefAbrs() throws SQLException {
        this.getLogDefs();
        return new ArrayList<String>(this.logDef.keySet());
    }

    public LogDef getLogDef(String abr) throws SQLException {
        this.getLogDefs();
        return this.logDef.get(abr != null ? abr.toUpperCase() : null);
    }

    public void fillLogDef(LogDef toFill) throws SQLException {
        if (this.getLogDef(toFill.getAbr()) == null) {
            LogDef newLD = new LogDef(toFill);
            this.logDef.put(newLD.getAbr(), newLD);
        }
    }

    public Color getMiscColour(String abr) throws SQLException {
        String s;
        Color colour;
        if (this.miscColours == null) {
            this.miscColours = new HashMap();
        }
        if (!((String)abr).startsWith("COL_")) {
            abr = "COL_" + (String)abr;
        }
        if ((colour = this.miscColours.get(abr)) == null && this.isConnected() && (s = this.getDatabasePref((String)abr)) != null && !s.isEmpty()) {
            colour = ColourUtils.getDBColour((String)s);
            this.miscColours.put((String)abr, colour);
        }
        return colour;
    }

    public Color getMiscColour(String abr, Color defaultColor) throws SQLException {
        Color color = this.getMiscColour(abr);
        if (color == null) {
            color = defaultColor;
        }
        return color;
    }

    public void setMiscColour(String abr, Color colour) throws SQLException {
        if (this.miscColours == null) {
            this.miscColours = new HashMap();
        }
        if (!((String)abr).startsWith("COL_")) {
            abr = "COL_" + (String)abr;
        }
        if (this.miscColours.get(abr) != colour) {
            this.putDatabasePref((String)abr, ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)false));
            this.miscColours.remove(abr);
            this.miscColours.put((String)abr, colour);
            this.setChanged();
            this.notifyObservers(colour);
        }
    }

    public TxGroupSet getTxGroupSet(int setID) throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        return this.sets.get(setID);
    }

    public Collection<TxGroupSet> getTxGroupSets() throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        return this.sets.values();
    }

    public List<TxGroupSet> getTxGroupSetsSorted() throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        LinkedList<TxGroupSet> list = new LinkedList<TxGroupSet>(this.sets.values());
        Collections.sort(list);
        return list;
    }

    public List<TxGroupSet> getTxGroupSets(int projID, boolean includeGlobal) throws SQLException {
        LinkedList<TxGroupSet> list = new LinkedList<TxGroupSet>();
        for (TxGroupSet set : this.getTxGroupSets()) {
            if (set.getProjID() == projID) {
                list.add(set);
                continue;
            }
            if (set.getProjID() != 0 || !includeGlobal) continue;
            list.add(set);
        }
        return list;
    }

    public TxGroupSet getTxGroupSet(String name, Integer projID) throws SQLException {
        if (this.sets == null) {
            this.sets = TxGroupSet.loadAll(this);
        }
        for (TxGroupSet set : this.sets.values()) {
            if (!set.getName().equalsIgnoreCase(name) || projID != null && set.getProjID() != 0 && set.getProjID() != projID.intValue()) continue;
            return set;
        }
        return null;
    }

    public Collection<TxGroupSet> getTxGroupSets(TxGroup member) throws SQLException {
        LinkedList<TxGroupSet> list = new LinkedList<TxGroupSet>();
        for (TxGroupSet set : this.getTxGroupSets()) {
            set.loadGroups();
            if (!set.isGroupMember(member.getID())) continue;
            list.add(set);
        }
        return list;
    }

    public TxGroupSet addTxGroupSet(String name, String descr, int projID, Collection<TxGroup> groups, boolean isOrdered) throws SQLException, SBException, SBPermissionException {
        LinkedHashSet<Integer> groupIDs = new LinkedHashSet<Integer>();
        for (TxGroup group : groups) {
            groupIDs.add(group.getID());
        }
        return this.addTxGroupSet(name, descr, projID, groupIDs, isOrdered);
    }

    public TxGroupSet addTxGroupSet(String name, String descr, int projID, LinkedHashSet<Integer> groupIDs, boolean isOrdered) throws SQLException, SBException, SBPermissionException {
        int setID;
        if (this.getTxGroupSet(name, projID) != null) {
            throw new SBException("Set: " + name + " already exists in project");
        }
        if (this.isConnected()) {
            setID = this.nextControl("GROUPSET", "GRPSET_ID");
        } else {
            int maxID = 0;
            for (TxGroupSet s : this.sets.values()) {
                if (s.getID() <= maxID) continue;
                maxID = s.getID();
            }
            setID = ++maxID;
        }
        TxGroupSet set = new TxGroupSet(this, name, groupIDs, setID, projID, descr, isOrdered);
        this.getTxGroupSets();
        this.sets.put(setID, set);
        this.setChanged();
        return set;
    }

    public void deleteTxGroupSet(TxGroupSet set) throws SQLException, SBPermissionException {
        String action = "DELETE " + set.getName() + " [" + set.getID() + "] (size: " + set.getGroups().size() + ")";
        set.delete();
        this.sets.remove(set.getID());
        this.updateAuditTrail("TXGROUPSET", action);
    }

    public TxGroup getTxGroup(int groupID) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        return this.txGroups.get(groupID);
    }

    public TxGroup getTxGroup(String name) throws SQLException {
        return this.getTxGroup(name, null);
    }

    public TxGroup getTxGroup(String name, Integer projID) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            if (!group.getName().equalsIgnoreCase(name) || projID != null && group.getProjID() != 0 && group.getProjID() != projID.intValue()) continue;
            return group;
        }
        return null;
    }

    public String isTxGroupNameAllowed(String name, int projID) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            if (!group.getName().equalsIgnoreCase(name) || projID != 0 && group.getProjID() != 0 && group.getProjID() != projID) continue;
            if (group.getProjID() > 0) {
                return "A group of this name exists in project " + this.getProject(group.getProjID()).getName();
            }
            return "A global group of this name already exists";
        }
        return null;
    }

    public Collection<Taxon> getTxGroupTaxa(TxGroup group) throws SQLException {
        return this.getTxGroupTaxa(group, true);
    }

    public Collection<Taxon> getTxGroupTaxa(TxGroup group, boolean includeGenera) throws SQLException {
        group.load();
        boolean reloaded = false;
        TreeSet<Taxon> set = new TreeSet<Taxon>();
        while (true) {
            for (Integer i : group.getSpecIDs()) {
                Taxon t = this.getTaxon(i);
                if (t == null) {
                    if (!reloaded) {
                        group.load(true);
                        set.clear();
                        reloaded = true;
                        continue;
                    }
                    throw new IllegalStateException("Attempt to load null taxon from specID: " + i + " in getTxGroupTaxa");
                }
                set.add(t);
            }
            break;
        }
        if (!includeGenera) {
            Set<Integer> genIDs = group.getGenIDs();
            Iterator<Taxon> it = set.iterator();
            while (it.hasNext()) {
                Taxon taxon = it.next();
                if (!genIDs.contains(taxon.getGenID())) continue;
                it.remove();
            }
        }
        return set;
    }

    public Collection<Genus> getTxGroupGenera(TxGroup group) throws SQLException {
        group.load();
        TreeSet<Genus> set = new TreeSet<Genus>();
        for (Integer i : group.getGenIDs()) {
            set.add(this.taxa.getGenus(i));
            this.taxa.getTaxa(i);
        }
        return set;
    }

    public Genus getGenus(int genID) throws SQLException {
        return this.getGenus(genID, null);
    }

    public Genus getGenus(int genID, Statement stmt) throws SQLException {
        return this.taxa.getGenus(genID, stmt);
    }

    public void insertGroupTaxa(TxGroup group, Well well, char discID, String analyst) throws SQLException, SBException, SBPermissionException {
        LinkedList<Taxon> toAdd = new LinkedList<Taxon>();
        List<Integer> wellTaxa = this.getWellSpecIDs(well, discID, analyst, null, null);
        for (int specID : wellTaxa) {
            if (group.isMember(specID, 0)) continue;
            toAdd.add(this.getTaxon(specID));
        }
        if (toAdd.size() > 0) {
            group.addTaxa(toAdd);
        }
    }

    public List<Taxon> getWellTaxa(Well well, char discID, String analyst) throws SQLException, SBException {
        return this.getWellTaxa(well, discID, analyst, null, null);
    }

    public List<Taxon> getWellTaxa(Well well, char discID, String analyst, Sample topSample, Sample baseSample) throws SQLException, SBException {
        LinkedList<Taxon> wellTaxa = new LinkedList<Taxon>();
        List<Integer> wellSpecID = this.getWellSpecIDs(well, discID, analyst, topSample, baseSample);
        for (int specID : wellSpecID) {
            wellTaxa.add(this.getTaxon(specID));
        }
        return wellTaxa;
    }

    void notifyTxGroupUpdate(int updatedGrpID) {
        if (this.txGroups == null) {
            return;
        }
        TxGroup updated = this.txGroups.get(updatedGrpID);
        if (this.sets == null) {
            return;
        }
        for (TxGroupSet set : this.sets.values()) {
            if (!set.isLoaded() || !set.isGroupMember(updatedGrpID)) continue;
            set.groupUpdated(updated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> getTaxaWithImages() throws SQLException {
        String sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TXIMAGE");
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            LinkedList<Taxon> imageTaxa = new LinkedList<Taxon>();
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                imageTaxa.add(this.getTaxon(specID));
            }
            sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TAXONOCC") + " WHERE image_set_id IS NOT NULL";
            ResultSet rs2 = stmt.executeQuery(this.modQuery(sql));
            while (rs2.next()) {
                int specID = rs2.getInt("spec_id");
                Taxon t = this.getTaxon(specID);
                if (imageTaxa.contains(t)) continue;
                imageTaxa.add(t);
            }
            LinkedList<Taxon> linkedList = imageTaxa;
            return linkedList;
        }
    }

    private List<Integer> getWellSpecIDs(Well well, char discID, String analyst, Sample topSample, Sample baseSample) throws SQLException, SBException {
        LinkedList<Integer> wellTaxa;
        String sql = "SELECT distinct(spec_id) FROM " + this.DBTableName("TAXONOCC") + " f, " + this.DBTableName("ANALY_HDR") + " h";
        if (topSample != null || baseSample != null) {
            sql = sql + "," + this.DBTableName("SAMPLES") + " s";
        }
        sql = sql + " WHERE f.well_id=" + well.getWellID();
        sql = sql + " AND f.well_id=h.well_id AND f.analy_id=h.analy_id AND h.disc_id=" + SB.DBChar((char)discID);
        if (analyst != null && analyst.length() > 0) {
            sql = sql + " AND h.analyst=" + this.getUserID(analyst);
        }
        if (topSample != null || baseSample != null) {
            sql = sql + " AND s.samp_id=f.samp_id AND s.well_id=f.well_id ";
        }
        if (topSample != null) {
            sql = this.useSampleTops() ? sql + " AND s.top_depth >=" + topSample.getDepth() : sql + " AND s.base_depth >=" + topSample.getDepth();
        }
        if (baseSample != null) {
            sql = this.useSampleTops() ? sql + " AND s.top_depth <=" + baseSample.getDepth() : sql + " AND s.base_depth <=" + baseSample.getDepth();
        }
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            wellTaxa = new LinkedList<Integer>();
            while (rs.next()) {
                int specID = rs.getInt("spec_id");
                wellTaxa.add(specID);
            }
        }
        return wellTaxa;
    }

    public void deleteTxGroup(TxGroup group) throws SQLException, SBPermissionException, SBException {
        String audit = "DELETE " + group.getName() + " [" + group.getID() + "] (size: " + group.getSize() + ")";
        group.delete();
        this.txGroups.remove(group.getID());
        this.updateAuditTrail("TXGROUP", audit);
        this.setChanged();
        this.notifyObservers(group);
    }

    public TxGroup copyToDatabase(SBdb ws, TxGroup wsGroup, int dbProjID) throws SQLException, SBException, SBPermissionException {
        TxGroup dbGroup = TxGroup.copyToDatabase(ws, this, wsGroup, dbProjID);
        wsGroup.setLink(dbGroup);
        wsGroup.updateStatus();
        this.putTxGroup(dbGroup);
        this.setChanged();
        this.notifyObservers(dbGroup);
        return dbGroup;
    }

    public TxGroup addTxGroup(String name, String abr, int groupID, int projID, Color colour) throws SQLException, SBException, SBPermissionException {
        if (this.isTxGroupNameAllowed(name, projID) != null) {
            throw new SBException("Group name '" + name + "' already in use");
        }
        int ID = groupID > 0 ? groupID : (this.isConnected() ? TxGroup.nextControl(this) : this.nextTxGroupID());
        TxGroup group = new TxGroup(this, name, abr, ID, projID, colour);
        this.putTxGroup(group);
        this.setChanged();
        this.notifyObservers(group);
        return group;
    }

    private void putTxGroup(TxGroup group) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
        }
        this.txGroups.put(group.getID(), group);
    }

    public Collection<TxGroup> getTxGroups() throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        return this.txGroups.values();
    }

    public Collection<TxGroup> getTxGroups(Integer projID, boolean includeGlobal) throws SQLException {
        if (this.txGroups == null) {
            this.txGroups = new HashMap();
            if (this.isConnected()) {
                TxGroup.load(this, this.txGroups);
            }
        }
        if (projID == null) {
            return this.txGroups.values();
        }
        LinkedList<TxGroup> list = new LinkedList<TxGroup>();
        for (TxGroup group : this.txGroups.values()) {
            if (group.getProjID() == projID.intValue()) {
                list.add(group);
                continue;
            }
            if (group.getProjID() != 0 || !includeGlobal) continue;
            list.add(group);
        }
        return list;
    }

    HashMap<Integer, InterpHdr> getInterpHdrs() throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        return this.interpHdrs;
    }

    public List<EnvScheme> getEnvSchemes() throws SQLException {
        if (this.envSchemes == null) {
            this.envSchemes = new HashMap();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        LinkedList<EnvScheme> list = new LinkedList<EnvScheme>(this.envSchemes.values());
        Collections.sort(list);
        return list;
    }

    public void addEnvScheme(EnvScheme scheme) throws SBException, SQLException, SBPermissionException {
        this.getEnvSchemes();
        for (EnvScheme e : this.envSchemes.values()) {
            if (!e.getName().equals(scheme.getName())) continue;
            throw new SBException("New scheme name is not unique");
        }
        if (this.isConnected()) {
            scheme.store();
        }
        this.envSchemes.put(scheme.getID(), scheme);
        this.setChanged();
        this.notifyObservers(scheme);
    }

    void refreshEnvSchemes(Connection conn) throws SQLException, SBException {
        try (Statement stmt = conn.createStatement();){
            if (this.envSchemes != null) {
                Object sql = "SELECT envsch_id,updated ";
                sql = (String)sql + " FROM " + this.DBTableName("env_sch");
                sql = this.modQuery((String)sql);
                ResultSet rs = stmt.executeQuery((String)sql);
                EnvScheme notifier = null;
                HashSet<Integer> keys = new HashSet<Integer>();
                while (rs.next()) {
                    int key = rs.getInt("envsch_id");
                    keys.add(key);
                    Timestamp time = rs.getTimestamp("updated");
                    boolean found = false;
                    for (EnvScheme a : this.envSchemes.values()) {
                        if (a.getID() != key) continue;
                        found = true;
                        if (time == null || !time.after(a.getUpdated())) break;
                        EnvScheme.load(this, key, a);
                        notifier = a;
                        break;
                    }
                    if (found) continue;
                    notifier = EnvScheme.load(this, key, null);
                    this.envSchemes.put(notifier.getID(), notifier);
                }
                if (keys.size() < this.envSchemes.size()) {
                    Iterator<EnvScheme> it = this.envSchemes.values().iterator();
                    while (it.hasNext()) {
                        EnvScheme a = it.next();
                        if (keys.contains(a.getID())) continue;
                        it.remove();
                        notifier = a;
                    }
                }
                if (notifier != null) {
                    this.setChanged();
                    this.notifyObservers(notifier);
                }
            }
        }
    }

    public void setImageFolder(String imageFolder) {
        this.imageFolder = imageFolder;
    }

    public String getImageFolder() throws SQLException {
        if (this.imageFolder == null) {
            if (this.isConnected()) {
                this.imageFolder = this.getDatabasePref("imagefolder");
                if (this.imageFolder == null) {
                    this.imageFolder = "";
                }
            } else {
                this.imageFolder = "";
            }
        }
        return this.imageFolder.isEmpty() ? null : this.imageFolder;
    }

    @Override
    public ImageRecordService getImageRecordService() {
        return this.imageRecordService;
    }

    @Override
    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    @Override
    public TaxonImageService getTaxonImageService() {
        return this.taxonImageService;
    }

    public List<TaxonImageSet> getTaxonImages(int specID) {
        return this.taxonImageService.getImages(specID);
    }

    public void deleteTaxonImageSet(int specID, TaxonImageSet imageSet) throws SQLException, SBException {
        if (imageSet.getAnalysisID().isPresent()) {
            AnalysisID analysisID = (AnalysisID)imageSet.getAnalysisID().get();
            Well well = this.wells.getWell((int)analysisID.wellID());
            Sample sample = well.getSample(analysisID.sampID());
            Smpdtl analysis = sample.getAnalysis(analysisID.analyID());
            analysis.getOccurUnsorted().stream().filter(occ -> occ.getImageSetID() == imageSet.getImageSetID()).findFirst().ifPresent(occ -> occ.clearImageSet());
        }
        this.imageRecordService.deleteImageRecords(imageSet.getImageSetID());
        this.taxonImageService.deleteTaxonImageSet(specID, imageSet);
        if (this.isConnected()) {
            this.commit();
        }
    }

    public AbundanceSchemeService getAbundanceSchemeService() {
        return this.abundanceSchemeService;
    }

    public AbundanceSchemeInformationService getAbundanceSchemeInformationService() {
        return new AbundanceSchemeInformationService(this, this.getUserService());
    }

    public void mergeAbnScheme(AbundanceScheme target, AbundanceScheme donor) throws SQLException, SBException, SBPermissionException {
        if (target.getAbnSchID() == 0 || donor.getAbnSchID() == 0) {
            throw new SBException("Scheme ID zero in AbnScheme.merge");
        }
        if (!AbundanceSchemeService.checkEquivalence((AbundanceScheme)target, (AbundanceScheme)donor)) {
            throw new IllegalArgumentException("Cannot merge schemes which are not equivalent");
        }
        if (!SBRestrictable.canWrite(this)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.getDatabase().createStatement();){
            String sql = "UPDATE " + this.DBTableName("ANALY_HDR") + " SET abnsch_id=" + target.getAbnSchID() + " WHERE abnsch_id=" + donor.getAbnSchID();
            stmt.executeUpdate(this.modQuery(sql));
        }
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<AnalystHeader> itra = well.getAnalystHeaderIterator();
            while (itra.hasNext()) {
                AnalystHeader h = itra.next();
                if (h.getAbnSchID() != donor.getAbnSchID()) continue;
                h.replaceAbnScheme(target.getAbnSchID());
            }
        }
        this.abundanceSchemeService.deleteAbundanceScheme(donor.getAbnSchID());
        this.updateAuditTrail("ABNSCHEME", "MERGE " + String.valueOf(donor) + " [" + donor.getAbnSchID() + "] with " + String.valueOf(target) + " [" + target.getAbnSchID() + "]");
    }

    public void deleteEnvScheme(EnvScheme scheme) throws SQLException, SBException, SBPermissionException {
        scheme.deleteEntries();
        scheme.delete();
        this.envSchemes.remove(scheme.getID());
        this.updateAuditTrail("ENVSCH", "DELETE " + scheme.getName() + " [" + scheme.getID() + "]");
    }

    public void deleteIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        if (this.isConnected()) {
            scheme.delete();
            String action = "DELETE " + scheme.getName() + " [" + scheme.getID() + "] (type: " + IGDInterval.getIGDName(scheme.getIGDType()) + ")";
            this.updateAuditTrail("IGDSCH", action);
        }
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.remove(scheme.getID());
                break;
            }
            case 4: {
                this.biozoneSchemes.remove(scheme.getID());
                break;
            }
            case 2: {
                this.lstratSchemes.remove(scheme.getID());
                break;
            }
            case 10: {
                this.sequenceSchemes.remove(scheme.getID());
                break;
            }
            case 26: {
                this.magnetoSchemes.remove(scheme.getID());
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot remove scheme, unknown IGD type: " + scheme.getIGDType());
            }
        }
        this.setChanged();
        this.notifyObservers(scheme);
    }

    public IGDScheme addIGDScheme(IGDScheme scheme) throws SQLException, SBException {
        if (scheme.getSchID() <= 0) {
            throw new IllegalArgumentException("Attempt to add scheme with ID " + scheme.getSchID());
        }
        this.getIGDSchemes(scheme.getIGDType(), true);
        switch (scheme.getIGDType()) {
            case 3: {
                this.chronoSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 4: {
                this.biozoneSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 2: {
                this.lstratSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 10: {
                this.sequenceSchemes.put(scheme.getID(), scheme);
                break;
            }
            case 26: {
                this.magnetoSchemes.put(scheme.getID(), scheme);
                break;
            }
            default: {
                throw new SBException("Cannot add new scheme '" + scheme.toString() + "', unknown IGD type: " + scheme.getIGDType());
            }
        }
        this.setChanged();
        this.notifyObservers(scheme);
        return scheme;
    }

    public IGDScheme addIGDScheme(int igdType, String name, String comments) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace scheme to a connected database.");
        }
        int schID = 1;
        schID = this.findMaxID(schID, this.chronoSchemes);
        schID = this.findMaxID(schID, this.lstratSchemes);
        schID = this.findMaxID(schID, this.biozoneSchemes);
        schID = this.findMaxID(schID, this.sequenceSchemes);
        schID = this.findMaxID(schID, this.magnetoSchemes);
        IGDScheme scheme = new IGDScheme(this, igdType, name, comments, (Discipline)(igdType == 4 ? Discipline.MICRO : null), igdType == 10 ? IGDScheme.SequenceType.DEPOSITIONAL : null, 0);
        scheme.setSchID(schID);
        return this.addIGDScheme(scheme);
    }

    public Collection<SynonymScheme> getSynSchemes() throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynSch.initSchemeHeaders(this);
        }
        return this.synSch.values();
    }

    public SynonymScheme getSynSch(int schID) throws SQLException {
        if (this.synSch == null) {
            this.synSch = SynSch.initSchemeHeaders(this);
        }
        return (SynonymScheme)((Object)this.synSch.get(schID));
    }

    public boolean hasEvents() {
        return this.events.hasEvents();
    }

    public SBEvent getSBEvent(int evID) throws SQLException {
        return this.events.getEvent(evID);
    }

    public SBEvent getSBEvent(DictionaryEvent parameters) throws SQLException {
        return this.getSBEvent(parameters, false);
    }

    public SBEvent getSBEvent(DictionaryEvent parameters, boolean asymmetricTypes) throws SQLException {
        return this.events.findEvent(parameters, asymmetricTypes);
    }

    public SBEvent getSBEvent(String evName) throws SQLException {
        return this.events.findEvent(evName);
    }

    public SBEvent getSBEventGenerate(int specID) throws SQLException {
        SBEvent event = this.events.getEvent(specID);
        if (event != null && event.isGenerate()) {
            return event;
        }
        return null;
    }

    public List<SBEvent> getSBEvents(int specID) throws SQLException {
        try {
            return this.getSBEvents(specID, 0);
        }
        catch (SBException e) {
            throw new IllegalStateException("This should never be thrown", e);
        }
    }

    public List<SBEvent> getSBEvents(int specID, int synschID) throws SQLException, SBException {
        Taxon preferred;
        if (synschID > 0 && (preferred = this.getPreferredTerm(synschID, specID)) != null) {
            ArrayList<SBEvent> list = new ArrayList<SBEvent>();
            list.addAll(this.events.getEvents(preferred.getSpecID()));
            list.addAll(this.events.getEvents(specID));
            return list;
        }
        return this.events.getEvents(specID);
    }

    public List<SBEvent> getSBEvents(boolean loadAll) throws SQLException {
        return this.getSBEvents(loadAll, null);
    }

    public List<SBEvent> getSBEvents(boolean loadAll, Project project) throws SQLException {
        if (loadAll && this.isConnected()) {
            this.events.loadAll(project != null ? project.getID() : 0);
        }
        return this.events.getEvents(project != null, project != null ? project.getID() : 0);
    }

    public SBEvent addSBEvent(SBEvent.Builder builder) throws SQLException, SBPermissionException {
        return this.events.addEvent(builder);
    }

    public SBEvent addSBEvent(SBEvent.Builder builder, int evID) throws SQLException {
        return this.events.addEvent(builder, evID);
    }

    public SBEvent addSBEvent(SBEvent.Builder builder, String taxonName) throws SQLException, SBPermissionException {
        if (builder.getTaxon() == null && taxonName != null && !taxonName.isEmpty()) {
            builder.taxon(this.taxa.getTaxonFromName(taxonName));
        }
        return this.addSBEvent(builder);
    }

    public void updateSBEventName(SBEvent event, String name) throws SQLException, SBException, SBPermissionException {
        assert (this.events.getEvent(event.getEvID()) == event);
        event.updateName(name);
        event.notifyObservers();
    }

    public void updateSBEvent(SBEvent event, SBEvent.Builder builder) throws SQLException, SBEvent.GenerateUniqueException, SBPermissionException {
        this.events.updateEvent(event.getEvID(), builder);
    }

    public EnvScheme getEnvScheme(int schID) throws SQLException {
        if (this.envSchemes == null) {
            this.envSchemes = new HashMap();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        return this.envSchemes.get(schID);
    }

    public EnvScheme getEnvScheme(String schemeName) throws SQLException, SBException {
        if (this.envSchemes == null) {
            this.envSchemes = new HashMap();
            if (this.isConnected()) {
                EnvScheme.loadAll(this, this.envSchemes);
            }
        }
        for (EnvScheme scheme : this.envSchemes.values()) {
            if (!scheme.getName().equals(schemeName)) continue;
            return scheme;
        }
        return null;
    }

    public List<CompositeStandard> getCompositeStandards() throws SQLException {
        return this.getCompositeStandards(this.showArchivedSchemes);
    }

    public List<CompositeStandard> getCompositeStandards(CompositeStandard mustBeIncluded) throws SQLException {
        return this.getCompositeStandards(mustBeIncluded != null && mustBeIncluded.isArchived() ? true : this.showArchivedSchemes);
    }

    public List<CompositeStandard> getAllCompositeStandards() throws SQLException {
        return this.getCompositeStandards(true);
    }

    private List<CompositeStandard> getCompositeStandards(boolean includeArchived) throws SQLException {
        this.initComposites();
        return this.compositeStandards.values().stream().filter(std -> std.isArchived() ? includeArchived : true).sorted().collect(Collectors.toCollection(LinkedList::new));
    }

    private void initComposites() throws SQLException {
        if (this.compositeStandards != null) {
            return;
        }
        this.compositeStandards = new HashMap();
        if (this.isConnected()) {
            List<CompositeStandard> stds = CompositeStandard.loadAll(this);
            for (CompositeStandard std : stds) {
                this.putComposite(std);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putComposite(CompositeStandard std) {
        if (std.getStdID() <= 0) {
            throw new IllegalArgumentException("Attempt to put composite with ID: " + std.getStdID());
        }
        HashMap<Integer, CompositeStandard> hashMap = this.compositeStandards;
        synchronized (hashMap) {
            CompositeStandard orig = this.compositeStandards.put(std.getStdID(), std);
            if (orig != null && orig != std) {
                throw new IllegalStateException("New composite '" + String.valueOf(std) + "' replaced old '" + String.valueOf(orig) + "', ID: " + std.getStdID());
            }
        }
    }

    public CompositeStandard addCompositeStandard(String name, double minAge, double maxAge, double topCSU, double baseCSU, boolean ageScale, List<CompositeStandardEvent.Builder> builders, Audit audit, int parentSchID, CompositeStandard parentCmpStd) throws SQLException, InvalidFieldException, SBPermissionException {
        int stdID = this.isConnected() ? this.nextControl("CMPSTD", "STD_ID") : this.nextStdID();
        this.initComposites();
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (!std.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("Composite Standard to be added already exists in model");
        }
        CompositeStandard cmpStd = new CompositeStandard(this, stdID, name, minAge, maxAge, topCSU, baseCSU, ageScale, builders, audit, parentSchID, parentCmpStd);
        this.putComposite(cmpStd);
        this.setChanged();
        return cmpStd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeStandard getCompositeStandard(int stdID) throws SQLException {
        this.initComposites();
        HashMap<Integer, CompositeStandard> hashMap = this.compositeStandards;
        synchronized (hashMap) {
            if (this.compositeStandards.get(stdID) == null && this.isConnected()) {
                try {
                    CompositeStandard cmpStd = CompositeStandard.load(this, stdID, null);
                    if (cmpStd.getName() != null && !cmpStd.getName().isEmpty()) {
                        this.compositeStandards.put(stdID, cmpStd);
                    }
                }
                catch (SBException se) {
                    se.printStackTrace();
                }
            }
            return this.compositeStandards.get(stdID);
        }
    }

    public CompositeStandard getCompositeStandard(String name) throws SQLException {
        this.initComposites();
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (!std.getName().equalsIgnoreCase(name)) continue;
            return std;
        }
        return null;
    }

    public CompositeStandard recalibrateComposite(CompositeStandard original, IGDScheme chronoOld, IGDScheme chronoNew, String newName) throws SQLException, InvalidFieldException, SBPermissionException {
        original.loadEvents();
        LinkedList<CompositeStandardEvent.Builder> cmpEvents = new LinkedList<CompositeStandardEvent.Builder>();
        for (CompositeStandardEvent event : original.getEvents(false)) {
            CompositeStandardEvent.Builder b = CompositeStandardEvent.Builder.copyOf(event).event(event.getEvent());
            b.csu(chronoNew.getRecalibratedAge(chronoOld, event.getCSU()));
            cmpEvents.add(b);
        }
        CompositeStandard copy = this.addCompositeStandard(newName, original.getMinAge(), original.getMaxAge(), original.getTopCSU(), original.getBaseCSU(), original.isAgeScale(), cmpEvents, null, chronoNew.getID(), original.getParentCmpStd());
        this.commit();
        return copy;
    }

    public CompositeStandard fillCompositeStandard(CompositeStandard std) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill composite to connected workspace");
        }
        if (std.getDatabase() == this) {
            throw new IllegalArgumentException("Attempt to copy composite within same model");
        }
        this.initComposites();
        CompositeStandard wsStd = this.getCompositeStandard(std.getStdID());
        if (wsStd == null) {
            wsStd = new CompositeStandard(this, std);
            this.putComposite(wsStd);
        }
        return wsStd;
    }

    public CompositeStandard copyCompositeStandard(CompositeStandard std, String name) throws InvalidFieldException, SQLException, SBPermissionException {
        if (std.getDatabase() != this) {
            throw new IllegalStateException("Attempt to copy compositeStandard to a different model");
        }
        this.initComposites();
        if (this.getCompositeStandard(name) != null) {
            throw new InvalidFieldException("A composite with this name already exists");
        }
        LinkedList<CompositeStandardEvent.Builder> cmpEvents = new LinkedList<CompositeStandardEvent.Builder>();
        std.loadEvents();
        for (CompositeStandardEvent compositeStandardEvent : std.getEvents(false)) {
            cmpEvents.add(CompositeStandardEvent.Builder.copyOf(compositeStandardEvent).event(compositeStandardEvent.getEvent()));
        }
        for (CompositeStandardEvent.Builder builder : std.getEventsNotInherited()) {
            cmpEvents.add(builder);
        }
        CompositeStandard copy = this.addCompositeStandard(name, std.getMinAge(), std.getMaxAge(), std.getTopCSU(), std.getBaseCSU(), std.isAgeScale(), cmpEvents, null, std.getParentSchID(), std.getParentCmpStd());
        this.commit();
        this.setChanged();
        this.notifyObservers(copy);
        return copy;
    }

    private int nextStdID() {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to get next composite standard ID in connected database");
        }
        try {
            this.initComposites();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int maxID = 1;
        for (CompositeStandard std : this.compositeStandards.values()) {
            if (std.getStdID() < maxID) continue;
            maxID = std.getStdID() + 1;
        }
        return maxID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshCompositeStandards(Connection conn) throws SQLException, SBException {
        if (this.compositeStandards == null) {
            return;
        }
        HashMap<Integer, CompositeStandard> hashMap = this.compositeStandards;
        synchronized (hashMap) {
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT std_id,updated FROM " + this.DBTableName("CMPSTD");
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                CompositeStandard notifier = null;
                HashSet<Integer> keys = new HashSet<Integer>();
                while (rs.next()) {
                    int key = rs.getInt("std_id");
                    keys.add(key);
                    Timestamp time = rs.getTimestamp("updated");
                    boolean found = false;
                    for (CompositeStandard c : this.compositeStandards.values()) {
                        if (c.getStdID() != key) continue;
                        found = true;
                        if (time == null || !time.after(c.getAudit().updated)) break;
                        CompositeStandard.load(this, key, c);
                        Statement stmt2 = conn.createStatement();
                        c.refresh(stmt2);
                        stmt2.close();
                        notifier = c;
                        break;
                    }
                    if (found) continue;
                    notifier = CompositeStandard.load(this, key, null);
                    this.compositeStandards.put(key, notifier);
                }
                if (keys.size() < this.compositeStandards.size()) {
                    Iterator<CompositeStandard> it = this.compositeStandards.values().iterator();
                    while (it.hasNext()) {
                        CompositeStandard c = it.next();
                        if (!keys.contains(c.getStdID())) {
                            it.remove();
                            notifier = c;
                            continue;
                        }
                        c.refresh(stmt);
                    }
                }
                if (notifier != null) {
                    this.setChanged();
                    this.notifyObservers(notifier);
                }
            }
        }
    }

    private void refreshEvents(Connection conn) throws SQLException, SBException {
        this.events.refreshEvents(conn);
    }

    private void refreshTaxa(Connection conn) throws SQLException, SBException {
        this.taxa.refreshTaxa(conn);
    }

    public Collection<IGDScheme> getMagnetoSchemes() throws SQLException {
        if (this.magnetoSchemes == null) {
            this.loadMagnetoSchemes();
        }
        ArrayList<IGDScheme> list = new ArrayList<IGDScheme>(this.magnetoSchemes.values());
        Collections.sort(list);
        return list;
    }

    public List<IGDScheme> getIGDSchemes(DataType dataType) throws SQLException {
        return this.getIGDSchemes(switch (dataType) {
            case DataType.SEQUENCE -> 10;
            case DataType.CHRONOSTRAT -> 3;
            case DataType.LITHOSTRAT -> 2;
            case DataType.BIOZONE -> 4;
            case DataType.MAGNETOSTRAT -> 26;
            default -> throw new IllegalArgumentException("Cannot get schemes with data type: " + String.valueOf((Object)dataType));
        });
    }

    public List<IGDScheme> getIGDSchemes(int igdType, Collection<IGDScheme> mustBeIncluded) throws SQLException {
        return this.getIGDSchemes(igdType, this.showArchivedSchemes || mustBeIncluded.stream().anyMatch(IGDScheme::isArchived));
    }

    public List<IGDScheme> getIGDSchemes(int igdType, IGDScheme mustBeIncluded) throws SQLException {
        return this.getIGDSchemes(igdType, mustBeIncluded != null ? List.of(mustBeIncluded) : Collections.emptyList());
    }

    public List<IGDScheme> getIGDSchemes(int igdType) throws SQLException {
        return this.getIGDSchemes(igdType, this.showArchivedSchemes);
    }

    public List<IGDScheme> getIGDSchemes(int igdType, boolean includeArchived) throws SQLException {
        HashMap<Integer, IGDScheme> schemeMap = null;
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                schemeMap = this.chronoSchemes;
                break;
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                schemeMap = this.lstratSchemes;
                break;
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                schemeMap = this.biozoneSchemes;
                break;
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                schemeMap = this.sequenceSchemes;
                break;
            }
            case 26: {
                if (this.magnetoSchemes == null) {
                    this.loadMagnetoSchemes();
                }
                schemeMap = this.magnetoSchemes;
            }
        }
        if (schemeMap != null) {
            Predicate<IGDScheme> archivedFilter = s -> s.isArchived() ? includeArchived : true;
            return schemeMap.values().stream().filter(archivedFilter).collect(Collectors.toCollection(ArrayList::new));
        }
        return null;
    }

    public List<IGDScheme> getIGDSchemes() throws SQLException {
        int[] igdTypes = new int[]{3, 2, 4, 10};
        ArrayList<IGDScheme> schemes = new ArrayList<IGDScheme>();
        for (int igdType : igdTypes) {
            List<IGDScheme> schemesOfType = this.getIGDSchemes(igdType, this.showArchivedSchemes);
            Collections.sort(schemesOfType);
            schemes.addAll(schemesOfType);
        }
        return schemes;
    }

    public Collection<IGDScheme> getBiozoneSchemes(Discipline disc) throws SQLException {
        List<IGDScheme> biozSchemes = this.getIGDSchemes(4);
        ListIterator<IGDScheme> it = biozSchemes.listIterator();
        while (it.hasNext()) {
            IGDScheme scheme = it.next();
            if (scheme.getDiscipline() == disc) continue;
            it.remove();
        }
        return biozSchemes;
    }

    public IGDScheme getIGDScheme(int schID) throws SQLException {
        IGDScheme scheme = null;
        if (this.chronoSchemes == null) {
            this.loadChronoSchemes();
        }
        if (this.chronoSchemes != null && (scheme = this.chronoSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.lstratSchemes == null) {
            this.loadLstratSchemes();
        }
        if (this.lstratSchemes != null && (scheme = this.lstratSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.biozoneSchemes == null) {
            this.loadBiozoneSchemes();
        }
        if (this.biozoneSchemes != null && (scheme = this.biozoneSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.sequenceSchemes == null) {
            this.loadSequenceSchemes();
        }
        if (this.sequenceSchemes != null && (scheme = this.sequenceSchemes.get(schID)) != null) {
            return scheme;
        }
        if (this.magnetoSchemes == null) {
            this.loadMagnetoSchemes();
        }
        if (this.magnetoSchemes.get(schID) != null) {
            return this.magnetoSchemes.get(schID);
        }
        return null;
    }

    public IGDScheme getIGDScheme(String name, int igdType) throws SQLException, SBException {
        Iterator<IGDScheme> it = null;
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                it = this.chronoSchemes.values().iterator();
                break;
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                it = this.lstratSchemes.values().iterator();
                break;
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                it = this.biozoneSchemes.values().iterator();
                break;
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                it = this.sequenceSchemes.values().iterator();
                break;
            }
            case 26: {
                if (this.magnetoSchemes == null) {
                    this.loadMagnetoSchemes();
                }
                it = this.magnetoSchemes.values().iterator();
                break;
            }
            default: {
                throw new SBException("Unknown IGD type in getIGDScheme: " + igdType);
            }
        }
        while (it.hasNext()) {
            IGDScheme scheme = it.next();
            if (!scheme.toString().equalsIgnoreCase(name)) continue;
            return scheme;
        }
        return null;
    }

    public IGDScheme getIGDScheme(int schID, int igdType) throws SQLException, SBException {
        switch (igdType) {
            case 3: {
                if (this.chronoSchemes == null) {
                    this.loadChronoSchemes();
                }
                return this.chronoSchemes.get(schID);
            }
            case 2: {
                if (this.lstratSchemes == null) {
                    this.loadLstratSchemes();
                }
                return this.lstratSchemes.get(schID);
            }
            case 4: {
                if (this.biozoneSchemes == null) {
                    this.loadBiozoneSchemes();
                }
                return this.biozoneSchemes.get(schID);
            }
            case 10: {
                if (this.sequenceSchemes == null) {
                    this.loadSequenceSchemes();
                }
                return this.sequenceSchemes.get(schID);
            }
        }
        return null;
    }

    public Collection<IGDScheme> getChronoSchemeParents() throws SQLException {
        HashMap<Integer, IGDScheme> parents = new HashMap<Integer, IGDScheme>();
        for (IGDScheme scheme : this.getIGDSchemes()) {
            if (scheme.getParentSchID() <= 0 || parents.get(scheme.getParentSchID()) != null) continue;
            if (this.getIGDScheme(scheme.getParentSchID()) != null) {
                parents.put(scheme.getParentSchID(), this.getIGDScheme(scheme.getParentSchID()));
                continue;
            }
            System.out.println("Parent scheme: " + scheme.getParentSchID() + " Is null");
        }
        for (CompositeStandard std : this.getCompositeStandards(true)) {
            if (std.getParentSchID() <= 0 || parents.get(std.getParentSchID()) != null) continue;
            System.out.println("Getting parent for std. scheme: " + std.getName() + ", ID=" + std.getParentSchID());
            parents.put(std.getParentSchID(), this.getIGDScheme(std.getParentSchID()));
        }
        if (!this.getShowArchivedSchemes()) {
            return parents.values().stream().filter(Predicate.not(IGDScheme::isArchived)).sorted().toList();
        }
        return parents.values();
    }

    public Collection<Comparable> getSchemeChildren(int parentSchID) throws SQLException {
        LinkedList<Comparable> children = new LinkedList<Comparable>();
        for (IGDScheme scheme : this.getIGDSchemes()) {
            if (scheme.getParentSchID() != parentSchID) continue;
            children.add(scheme);
        }
        for (CompositeStandard std : this.getCompositeStandards(true)) {
            if (std.getParentSchID() != parentSchID) continue;
            children.add(std);
        }
        return children;
    }

    private void refreshIGDSchemes(Connection conn) throws SQLException, SBException {
        if (this.chronoSchemes != null) {
            this.refreshIGDSchemes(conn, 3, this.chronoSchemes);
        }
        if (this.lstratSchemes != null) {
            this.refreshIGDSchemes(conn, 2, this.lstratSchemes);
        }
        if (this.biozoneSchemes != null) {
            this.refreshIGDSchemes(conn, 4, this.biozoneSchemes);
        }
        if (this.sequenceSchemes != null) {
            this.refreshIGDSchemes(conn, 10, this.sequenceSchemes);
        }
    }

    public boolean hasIGDSchemesLoaded() {
        if (this.chronoSchemes != null && !this.chronoSchemes.isEmpty()) {
            return true;
        }
        if (this.lstratSchemes != null && !this.lstratSchemes.isEmpty()) {
            return true;
        }
        if (this.biozoneSchemes != null && !this.biozoneSchemes.isEmpty()) {
            return true;
        }
        if (this.sequenceSchemes != null && !this.sequenceSchemes.isEmpty()) {
            return true;
        }
        return this.magnetoSchemes != null && !this.magnetoSchemes.isEmpty();
    }

    private void refreshIGDSchemes(Connection conn, int igdType, HashMap<Integer, IGDScheme> schemes) throws SQLException, SBException {
        IGDScheme notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        try (Statement stmt = conn.createStatement();){
            Object sql = "SELECT sch_id,updated ";
            sql = (String)sql + " FROM " + this.DBTableName("IGD_SCH") + " WHERE igd_type=" + igdType;
            sql = this.modQuery((String)sql);
            ResultSet rs = stmt.executeQuery((String)sql);
            while (rs.next()) {
                int key = rs.getInt("sch_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (IGDScheme o : schemes.values()) {
                    if (o.getSchID() != key) continue;
                    found = true;
                    if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                    IGDScheme.load(this, key, o);
                    try (Statement stmt2 = conn.createStatement();){
                        o.refresh(stmt2);
                    }
                    notifier = o;
                    break;
                }
                if (found) continue;
                notifier = IGDScheme.load(this, key, null);
                schemes.put(key, notifier);
            }
            Iterator<IGDScheme> it = schemes.values().iterator();
            while (it.hasNext()) {
                IGDScheme o = it.next();
                if (!keys.contains(o.getSchID())) {
                    it.remove();
                    if (notifier != null) continue;
                    notifier = o;
                    continue;
                }
                o.refresh(stmt);
            }
        }
        if (notifier != null) {
            this.setChanged();
            this.notifyObservers(notifier);
        }
    }

    private void loadChronoSchemes() throws SQLException {
        this.chronoSchemes = new HashMap();
        if (this.isConnected()) {
            List<IGDScheme> list = IGDScheme.getSchemes(this, 3);
            Iterator<IGDScheme> iterator = list.iterator();
            while (iterator.hasNext()) {
                IGDScheme o;
                IGDScheme scheme = o = iterator.next();
                this.chronoSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadLstratSchemes() throws SQLException {
        this.lstratSchemes = new HashMap();
        if (this.isConnected()) {
            List<IGDScheme> list = IGDScheme.getSchemes(this, 2);
            Iterator<IGDScheme> iterator = list.iterator();
            while (iterator.hasNext()) {
                IGDScheme o;
                IGDScheme scheme = o = iterator.next();
                this.lstratSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadBiozoneSchemes() throws SQLException {
        this.biozoneSchemes = new HashMap();
        if (this.isConnected()) {
            List<IGDScheme> list = IGDScheme.getSchemes(this, 4);
            Iterator<IGDScheme> iterator = list.iterator();
            while (iterator.hasNext()) {
                IGDScheme o;
                IGDScheme scheme = o = iterator.next();
                this.biozoneSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadSequenceSchemes() throws SQLException {
        this.sequenceSchemes = new HashMap();
        if (this.isConnected()) {
            List<IGDScheme> list = IGDScheme.getSchemes(this, 10);
            Iterator<IGDScheme> iterator = list.iterator();
            while (iterator.hasNext()) {
                IGDScheme o;
                IGDScheme scheme = o = iterator.next();
                this.sequenceSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    private void loadMagnetoSchemes() throws SQLException {
        this.magnetoSchemes = new HashMap();
        if (this.isConnected()) {
            List<IGDScheme> list = IGDScheme.getSchemes(this, 26);
            for (IGDScheme scheme : list) {
                this.magnetoSchemes.put(scheme.getSchID(), scheme);
            }
        }
    }

    public Optional<StratigraphicUnit> findUnit(int schID, int unitID) {
        try {
            IGDUnitBase unit;
            IGDScheme scheme = this.getIGDScheme(schID);
            if (scheme != null && (unit = scheme.findUnitBase(unitID)) != null && unit instanceof IGDUnit) {
                IGDUnit u = (IGDUnit)unit;
                return Optional.of(u.getDomainUnit());
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return Optional.empty();
    }

    public List<StratigraphicUnit> getUnits(int schID) {
        return Collections.EMPTY_LIST;
    }

    public Userdef getUser(int userID) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        return this.users.get(userID);
    }

    @Override
    public UserService getUserService() {
        return this;
    }

    public Optional<User> findUser(int userID) {
        try {
            Userdef userdef = this.getUser(userID);
            if (userdef != null) {
                return Optional.of(userdef.getUserCopy());
            }
            return Optional.empty();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withoutRollback(ex);
        }
    }

    public int getCurrentUserID() {
        return this.getUserID();
    }

    public int getUserID(String userAbr) throws SQLException {
        if (userAbr == null || userAbr.length() == 0) {
            return 0;
        }
        Userdef u = this.getUser(userAbr);
        if (u == null) {
            return 0;
        }
        return u.getUsrID();
    }

    public int getUserID() {
        if (this.user == null) {
            return 0;
        }
        return this.user.getUsrID();
    }

    public Userdef getUser(String userAbr) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        for (Userdef u : this.users.values()) {
            if (!u.getAbr().equalsIgnoreCase(userAbr)) continue;
            return u;
        }
        return null;
    }

    public void putUser(Userdef user) throws SQLException {
        if (this.users == null) {
            this.getUsers();
        }
        if (this.users.get(user.getUsrID()) == null) {
            this.users.put(user.getUsrID(), user);
        }
    }

    public void putUserIDs(List<Integer> userIDList) {
        for (Integer userID : userIDList) {
            if (this.userIDs.contains(userID)) continue;
            this.userIDs.add(userID);
        }
    }

    public List getUserIDs() {
        return this.userIDs;
    }

    void removeUser(String userID) throws SQLException {
        this.users.remove(this.getUserID(userID));
    }

    public Collection<Userdef> getUsers() throws SQLException {
        if (this.users == null) {
            this.users = new TreeMap();
            if (this.isConnected()) {
                for (Userdef u : Userdef.getUsers(this)) {
                    if (u.getUsrID() <= 0) {
                        throw new IllegalArgumentException("Attempt to add user with ID: " + u.getUsrID());
                    }
                    if (this.users.get(u.getUsrID()) != null) {
                        throw new IllegalArgumentException("Attempt to add duplicate user: " + u.getAbr());
                    }
                    this.putUser(u);
                }
            }
        }
        return this.users.values();
    }

    public List<User> getAllUsers() {
        try {
            Collection<Userdef> allUsers = this.getUsers();
            return allUsers.stream().map(Userdef::getUserCopy).sorted().collect(Collectors.toCollection(ArrayList::new));
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
    }

    public void mergeUsers(Userdef donor, Userdef target) throws SQLException, InvalidFieldException, SBException {
        int total;
        ResultSet rs2;
        Statement stmt = this.getDatabase().createStatement(1003, 1008);
        Statement stmt2 = this.getDatabase().createStatement();
        int donorID = donor.getUsrID();
        int targetID = target.getUsrID();
        String sql = "SELECT analy_id,well_id,disc_id,analy_no,analyst FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + donorID;
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int analyID = rs.getInt("analy_id");
            int well_id = rs.getInt("well_id");
            char disc_id = SB.getDBChar((ResultSet)rs, (String)"disc_id");
            int analy_no = rs.getInt("analy_no");
            int analystTemp = rs.getInt("analyst");
            sql = "SELECT COUNT(analy_id) AS nMatches FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND analy_no=" + analy_no + " AND disc_id=" + SB.DBChar((char)disc_id);
            rs2 = stmt2.executeQuery(this.modQuery(sql));
            int nMatches = -1;
            if (rs2.next()) {
                nMatches = rs2.getInt("nMatches");
            }
            rs.refreshRow();
            if (nMatches > 0) {
                boolean allowed = false;
                int matches = -1;
                while (!allowed) {
                    sql = "SELECT COUNT(analy_id) as nMatches FROM " + this.DBTableName("ANALY_HDR") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND analy_no=" + ++analy_no + " AND disc_id=" + SB.DBChar((char)disc_id);
                    rs2 = stmt2.executeQuery(this.modQuery(sql));
                    if (rs2.next()) {
                        matches = rs2.getInt("nMatches");
                    }
                    if (matches != 0) continue;
                    allowed = true;
                }
                rs.updateInt("analy_no", analy_no);
                rs.updateInt("analyst", targetID);
                rs.updateRow();
                continue;
            }
            rs.updateInt("analyst", targetID);
            rs.updateRow();
        }
        sql = "SELECT well_id,usamp_id,interp_id,disc_id,analyst,comments FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + donorID;
        rs = stmt.executeQuery(this.modQuery(sql));
        while (rs.next()) {
            int well_id = rs.getInt("well_id");
            int usamp_id = rs.getInt("usamp_id");
            int interp_id = rs.getInt("interp_id");
            char disc_id = SB.getDBChar((ResultSet)rs, (String)"disc_id");
            String donorComments = rs.getString("comments");
            sql = "SELECT comments FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND usamp_id=" + usamp_id + " AND interp_id=" + interp_id + " AND disc_id=" + SB.DBChar((char)disc_id);
            rs2 = stmt2.executeQuery(this.modQuery(sql));
            if (rs2.next()) {
                if (donorComments == null || donorComments.trim().isEmpty()) {
                    rs.deleteRow();
                    continue;
                }
                String targetComments = rs2.getString("comments");
                if (targetComments == null || targetComments.trim().isEmpty() || targetComments.trim().equalsIgnoreCase(donorComments.trim())) {
                    rs2.close();
                    sql = "DELETE FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + targetID + " AND well_id=" + well_id + " AND usamp_id=" + usamp_id + " AND interp_id=" + interp_id + " AND disc_id=" + SB.DBChar((char)disc_id);
                    stmt2.executeUpdate(this.modQuery(sql));
                } else {
                    InterpHdr interp = this.getInterp(donor.getAbr());
                    if (interp == null) {
                        interp = this.addInterp(donor.getAbr(), null);
                    }
                    rs.updateInt("interp_id", interp.getInterpID());
                }
            }
            rs.updateInt("analyst", targetID);
            rs.updateRow();
        }
        sql = "SELECT count(*) as total FROM " + this.DBTableName("BCMMNTS") + " WHERE analyst=" + donorID;
        rs = stmt.executeQuery(this.modQuery(sql));
        if (rs.next() && (total = rs.getInt("total")) > 0) {
            throw new SBException("Donor comments remaining after merge: " + total + ". Aborting");
        }
        for (String auditTable : SBTables.auditTables()) {
            sql = "UPDATE " + this.DBTableName(auditTable) + " SET creator=" + targetID + " WHERE creator=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
            sql = "UPDATE " + this.DBTableName(auditTable) + " SET modifier=" + targetID + " WHERE modifier=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
            sql = "UPDATE " + this.DBTableName(auditTable) + " SET updater=" + targetID + " WHERE updater=" + donorID;
            stmt.executeUpdate(this.modQuery(sql));
        }
        sql = "UPDATE " + this.DBTableName("IGD") + " SET top_analy=" + targetID + " WHERE top_analy=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("IGD") + " SET base_analy=" + targetID + " WHERE base_analy=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("EVENTS") + " SET analyst=" + targetID + " WHERE analyst=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("SBTEMPLT") + " SET owner=" + SB.DBString((String)target.getAbr()) + " WHERE owner=" + SB.DBString((String)donor.getAbr());
        stmt.executeUpdate(this.modQuery(sql));
        sql = "UPDATE " + this.DBTableName("CHTANALYST") + " SET analyst_id=" + targetID + " WHERE analyst_id=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "DELETE FROM " + this.DBTableName("PREF_USER") + " WHERE user_id=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        sql = "DELETE FROM " + this.DBTableName("USERDEF") + " WHERE user_id=" + donorID;
        stmt.executeUpdate(this.modQuery(sql));
        stmt.close();
        stmt2.close();
    }

    public SBdb() {
        this.taxa = new TaxaMap(this);
        this.events = new EventDictionary(this);
        this.wells = new WellManager(this);
        this.imageRecordService = new ImageRecordServiceDbImpl(this);
        this.taxonImageService = new TaxonImageServiceDbImpl(this);
        this.speciesTypeService = new SpeciesTypeServiceDbImpl(this);
        this.slideStoreService = new SlideStoreServiceDbImpl(this);
        this.abundanceSchemeService = new AbundanceSchemeServiceDbImpl(this);
        this.init();
    }

    public SBdb(SBdb db) throws SQLException {
        this.lithdesc = db.getLithdesc();
        SystemPreferences.getInstance().setPreference("SAMPLETOPS", db.getSampleTops());
        this.taxa = new TaxaMap(this);
        this.events = new EventDictionary(this);
        this.wells = new WellManager(this);
        this.imageRecordService = new ImageRecordServiceImpl();
        this.taxonImageService = new TaxonImageServiceImpl();
        this.speciesTypeService = new SpeciesTypeServiceImpl();
        this.slideStoreService = null;
        this.abundanceSchemeService = new AbundanceSchemeServiceImpl();
        this.init();
    }

    private void init() {
        this.events.addObserver(this);
        if (this.isConnected()) {
            try {
                this.queryAuditTrail();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
        }
    }

    public Lithdesc getLithdesc() throws SQLException {
        if (this.lithdesc == null) {
            this.lithdesc = new Lithdesc(this, false);
        }
        return this.lithdesc;
    }

    public JComboBox getLithologyCombo(boolean includeQualifiers) throws SQLException, SBException {
        JComboBox<Object> comboBox = new JComboBox<Object>();
        Enumeration<Lithology> en = this.getLithdesc().lithologies.elements();
        while (en.hasMoreElements()) {
            Lithology lith = en.nextElement();
            if (lith.getLithID() < 1000 || lith.getLithID() >= 2000) continue;
            String descr = lith.getDescr();
            boolean inserted = false;
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                String item = (String)comboBox.getItemAt(i);
                if (item.compareTo(descr) > 0) {
                    comboBox.insertItemAt(descr, i);
                    inserted = true;
                    break;
                }
                if (!item.equals(descr)) continue;
                inserted = true;
                break;
            }
            if (inserted) continue;
            comboBox.addItem(descr);
        }
        if (includeQualifiers) {
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().getAccessories()) {
                String string = "Accessory : " + lith.getDescr();
                comboBox.addItem(string);
            }
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().getStringers()) {
                String string = "Stringer : " + lith.getDescr();
                comboBox.addItem(string);
            }
            comboBox.addItem("----------------");
            for (Lithology lith : this.getLithdesc().getQualifiers()) {
                String string = "Qualifier : " + lith.getDescr();
                comboBox.addItem(string);
            }
        }
        comboBox.setMaximumRowCount(25);
        return comboBox;
    }

    public void deleteSpeciesModel(Collection<Integer> specIDs, Collection<Integer> genIDs) {
        for (int specID : specIDs) {
            Iterator<Well> itw = this.getWellIterator();
            while (itw.hasNext()) {
                Well well = itw.next();
                try {
                    for (Sample sample : well.getSamples()) {
                        for (Smpdtl smpdtl : sample.getAnalysesCopy()) {
                            if (!smpdtl.removeSpecies(specID)) continue;
                            smpdtl.notifyObservers();
                        }
                    }
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback(e);
                }
            }
        }
        for (TxGroup group : this.txGroups.values()) {
            for (int specID : specIDs) {
                group.removeSpecies(specID);
            }
            for (int genID : genIDs) {
                group.removeGenus(genID);
            }
            group.notifyObservers();
        }
    }

    public void excludeSpecies(List<Taxon> excluders) {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to exclude taxa from connected workspace");
        }
        try {
            Iterator<Well> it = this.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<Sample> sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    for (Smpdtl dtl : sit.next().getSmpdtls()) {
                        dtl.excludeOccur(excluders);
                    }
                }
            }
            for (TxGroup group : this.getTxGroups()) {
                group.deleteTaxa(excluders);
            }
        }
        catch (SBPermissionException pe) {
            throw new RuntimeException("Unexpected permission exception deleting taxa from group in workspace", pe);
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected exception loading samples in workspace", sql);
        }
        this.taxa.excludeTaxa(excluders);
    }

    public int updateOcc(Taxon taxon, String field, char newValue) throws SQLException, SBException, SBPermissionException {
        int nUpdated = taxon.updateOcc(field, newValue);
        this.updateOcc(taxon, field, newValue, -1);
        return nUpdated;
    }

    public void updateOcc(Taxon taxon, int newSpecType) throws SQLException, SBException, SBPermissionException {
        taxon.updateOccSpecType(newSpecType);
        this.updateOcc(taxon, null, '\u0000', newSpecType);
    }

    public void setFssOccType(TaxonOcc fss, String donorOccType) {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to set occurrence type in connected workspace");
        }
        if (StringUtils.isBlank((CharSequence)donorOccType)) {
            return;
        }
        if (Arrays.stream(Situation.values()).anyMatch(situation -> situation.getDescr().equalsIgnoreCase(donorOccType))) {
            fss.setSituation(Situation.parse((String)donorOccType));
        } else if (donorOccType.equalsIgnoreCase("Questionable")) {
            fss.setIdentType('?', false);
        } else {
            try {
                Object existing = "";
                if (fss.getSpecType() > 0 && !((String)(existing = (String)existing + fss.getSpecTypeString())).isEmpty()) {
                    existing = (String)existing + "/";
                }
                int specType = this.speciesTypeService.getAddSpeciesType((String)existing + donorOccType).specTypeID();
                fss.setSpecType(specType);
            }
            catch (SQLException sql) {
                throw new RuntimeException("Unexpected SQLException in workspace", sql);
            }
        }
        fss.getTaxon().setDonorOccType(donorOccType);
    }

    private void updateOcc(Taxon taxon, String field, char newValue, int newSpecType) throws SQLException, SBException {
        Iterator<Well> itw = this.getWellIterator();
        while (itw.hasNext()) {
            Well well = itw.next();
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.analyses) {
                    if (!smpdtl.updateOccs(taxon, field, newValue, newSpecType)) continue;
                    smpdtl.notifyObservers();
                }
            }
        }
    }

    public boolean checkAnalystConflicts(int usrID1, int usrID2) throws SQLException, SBException {
        Iterator<Well> itw = this.getWellIterator();
        while (itw.hasNext()) {
            Well well = itw.next();
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.analyses) {
                    if (smpdtl.getHeader().getAnalystUsrid() != usrID1) continue;
                    for (Smpdtl smpdtl2 : sample.analyses) {
                        if (smpdtl == smpdtl2 || smpdtl2.getHeader().getAnalystUsrid() != usrID2) continue;
                        return false;
                    }
                }
            }
            Iterator<WellInterp> wellInterpIterator = well.getInterpIterator();
            while (wellInterpIterator.hasNext()) {
                WellInterp interp = wellInterpIterator.next();
                for (Biocom biocom : interp.getComments()) {
                    if (biocom.getAnalyst() != usrID1) continue;
                    for (Biocom biocom2 : interp.getComments()) {
                        if (biocom == biocom2 || biocom.getSample() != biocom2.getSample() || biocom2.getAnalyst() != usrID2) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    void refreshInterps(Connection conn) throws SQLException {
        if (this.interpHdrs != null) {
            InterpHdr.refresh(conn, this, this.interpHdrs);
        }
    }

    void loadInterps() throws SQLException {
        if (this.interpHdrs == null) {
            this.interpHdrs = new HashMap();
            InterpHdr.loadAll(this, this.interpHdrs);
        }
    }

    public boolean hasInterpsLoaded() {
        return this.interpHdrs != null;
    }

    public List<InterpHdr> getInterps() throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        LinkedList<InterpHdr> list = new LinkedList<InterpHdr>();
        Collection<InterpHdr> c = this.interpHdrs.values();
        for (InterpHdr o : c) {
            InterpHdr interp = o;
            if (interp.getInterpID() <= 0) continue;
            list.add(interp);
        }
        Collections.sort(list);
        InterpHdr defaultInterp = this.interpHdrs.get(0);
        if (defaultInterp != null) {
            list.add(0, defaultInterp);
        }
        return list;
    }

    public InterpHdr getInterp(int interpID) throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        return this.interpHdrs.get(interpID);
    }

    public InterpHdr getInterp(String name) throws SQLException {
        if (this.interpHdrs == null) {
            this.loadInterps();
        }
        Collection<InterpHdr> c = this.interpHdrs.values();
        for (InterpHdr o : c) {
            InterpHdr interp = o;
            if (!interp.getDescription().equalsIgnoreCase(name)) continue;
            return interp;
        }
        return null;
    }

    public void removeInterp(InterpHdr interp) {
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            try {
                if (!well.hasInterpLoaded(interp.getInterpID())) continue;
                WellInterp wellInterp = well.getInterp(interp.getInterpID());
                well.removeInterp(wellInterp);
                wellInterp.setChanged(null);
                wellInterp.notifyObservers();
                well.notifyObservers(interp);
            }
            catch (SBException sBException) {}
        }
        this.interpHdrs.remove(interp.getInterpID());
    }

    public void loadTaxa() throws SQLException {
        this.taxa.loadAll();
        System.out.println("Number of taxa loaded: " + this.taxa.getSize());
    }

    void loadTaxa(int wellID) throws SQLException {
        this.taxa.loadTaxa(wellID);
    }

    public void load() throws SQLException, SBException {
        Calendar time = Calendar.getInstance();
        this.taxa.loadAll();
        System.out.println("Number of taxa loaded: " + this.taxa.getSize());
        this.lithdesc = new Lithdesc(this, false);
        System.out.println("User: " + this.user.getUsrID());
        this.getAbundanceSchemeService().getAllAbundanceSchemes();
        this.getEnvScheme(0);
        String sql = "SELECT well_id FROM " + this.DBTableName("wells") + " ORDER BY well_id";
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                this.getWell(wellID);
            }
        }
        System.out.println("Loaded: " + this.getnLoadedWells() + " wells");
        int nSamples = Well.loadAllSamples(this);
        System.out.println("Loaded: " + nSamples + " samples");
        System.out.println("Loaded: " + Smpdtl.loadAll(this) + " analyses.");
        System.out.println("Loaded: " + TaxonOcc.loadAll(this, this.taxa) + " occurrences.");
        this.loadInterps();
        HashMap<Integer, Well> wellLookup = new HashMap<Integer, Well>();
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            wellLookup.put(well.getWellID(), well);
        }
        System.out.println("Loaded: " + IGDIntervalZone.loadAll(this, wellLookup, this.interpHdrs, true) + " IGD intervals.");
        System.out.println("Loaded: " + IGDIntervalZone.loadAll(this, wellLookup, this.interpHdrs, false) + " Lithostrat intervals.");
        System.out.println("Loaded: " + Biocom.loadAll(this, wellLookup, this.interpHdrs) + " Biostrat Comments.");
        it = this.getWellIterator();
        int totalWells = this.getnLoadedWells();
        int n = 0;
        while (it.hasNext()) {
            Well well = it.next();
            System.out.println("Loading data for well (" + ++n + "/" + totalWells + ") :" + String.valueOf(well));
            System.out.flush();
            well.loadInterps();
            Iterator<WellInterp> wit = well.getInterpIterator();
            while (wit.hasNext()) {
                WellInterp wellInterp = wit.next();
                wellInterp.load(well);
                well.loadSampleAges(wellInterp);
            }
            block28: for (int dType = 1; dType < 27; ++dType) {
                switch (dType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        continue block28;
                    }
                    case 14: {
                        continue block28;
                    }
                    case 15: {
                        continue block28;
                    }
                    case 16: {
                        continue block28;
                    }
                    case 17: {
                        continue block28;
                    }
                    case 18: {
                        continue block28;
                    }
                    case 19: {
                        well.getCores();
                    }
                    case 20: {
                        well.getCasing();
                    }
                    case 21: {
                        well.getLithIntervals();
                    }
                    case 22: {
                        continue block28;
                    }
                    case 24: {
                        well.getMarkers();
                        continue block28;
                    }
                    case 25: {
                        well.getTVDlist(true);
                        well.getTVDlist(false);
                        continue block28;
                    }
                    case 26: {
                        well.getTWTlist();
                        continue block28;
                    }
                    case 27: {
                        continue block28;
                    }
                    case 23: {
                        continue block28;
                    }
                    default: {
                        try {
                            throw new SBException("Attempt to load data");
                        }
                        catch (SBException sbe) {
                            System.out.println("Exception while loading data type: " + dType + " : " + sbe.getMessage());
                        }
                    }
                }
            }
            Runtime.getRuntime().gc();
        }
        System.out.println("Elapsed: " + (Calendar.getInstance().getTimeInMillis() - time.getTimeInMillis()) / 1000L + " secs.");
    }

    public void getChartScales(DefaultComboBoxModel model) throws SQLException {
        if (this.chartScales == null) {
            this.loadChartScales();
        }
        model.removeAllElements();
        for (Integer iScale : this.chartScales) {
            model.addElement(((Object)iScale).toString());
        }
    }

    public List<Integer> getChartScales() throws SQLException {
        if (this.chartScales == null) {
            this.loadChartScales();
        }
        return new ArrayList<Integer>(this.chartScales);
    }

    private void loadChartScales() throws SQLException {
        if (this.chartScales != null) {
            return;
        }
        this.chartScales = new ArrayList<Integer>();
        String sql = "SELECT scale FROM " + this.DBTableName("SBSCALES") + " ORDER BY scale";
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery(sql));
            while (rs.next()) {
                int iScale = rs.getInt("scale");
                this.chartScales.add(iScale);
            }
        }
    }

    public void addChartScale(int scale) throws SQLException {
        if (scale < 1 || scale > 100000) {
            throw new IllegalArgumentException("Attempt to add illegal chart scale: " + scale);
        }
        this.loadChartScales();
        for (Integer i : this.chartScales) {
            if (i != scale) continue;
            return;
        }
        String sql = "INSERT INTO " + this.DBTableName("SBSCALES") + " (scale) VALUES (" + scale + ")";
        try (Statement stmt = this.getDatabase().createStatement();){
            stmt.executeUpdate(this.modQuery(sql));
        }
        this.chartScales.add(scale);
        Collections.sort(this.chartScales);
    }

    public void deleteChartScale(int scale) throws SQLException {
        this.loadChartScales();
        Integer found = null;
        for (Integer i : this.chartScales) {
            if (!i.equals(scale)) continue;
            found = i;
        }
        if (found == null) {
            return;
        }
        String sql = "DELETE FROM " + this.DBTableName("SBSCALES") + " WHERE scale=" + scale;
        try (Statement stmt = this.getDatabase().createStatement();){
            stmt.executeUpdate(this.modQuery(sql));
        }
        this.chartScales.remove(found);
    }

    public List<String> getCasingDiameters() throws SQLException {
        if (this.casingDiameters == null) {
            this.casingDiameters = new ArrayList<String>();
            String[] diams = new String[]{"42", "36", "32 3/4", "32", "30", "26", "24", "20", "18 3/4", "18 5/8", "18 1/2", "18", "16", "13 3/8", "10 3/4", "10 3/8", "9 5/8", "8 1/2", "7 5/8", "7", "6", "5 1/2", "5", "4 1/2"};
            this.casingDiameters.addAll(Arrays.asList(diams));
            if (this.isConnected()) {
                String sql = "SELECT diam FROM " + this.DBTableName("casdiam") + " ORDER BY sort_order";
                try (Statement stmt = this.getDatabase().createStatement();){
                    ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                    while (rs.next()) {
                        String diam = rs.getString("diam");
                        if (this.casingDiameters.contains(diam)) continue;
                        this.casingDiameters.add(diam);
                    }
                }
            }
        }
        return this.casingDiameters;
    }

    public void createCasdiam() throws SQLException {
        if (!this.hasCasdiam) {
            try (Statement stmt = this.getDatabase().createStatement();){
                String sql = "CREATE TABLE " + this.DBTableName("casdiam") + " (sort_order number, diam ";
                sql = sql + this.getDBCharType();
                sql = sql + "(10))";
                stmt.executeUpdate(this.modQuery(sql));
                if (this.connectionManager.getDBType() == DBType.ORACLE) {
                    sql = "GRANT SELECT,INSERT,UPDATE,DELETE TO PUBLIC ON " + this.DBTableName("casdiam");
                    stmt.executeUpdate(this.modQuery(sql));
                }
            }
            this.hasCasdiam = true;
        }
    }

    public void storeCasingDiameters(List<String> diameters) throws SQLException, SBException, SBPermissionException {
        if (diameters != null && this.hasCasdiam) {
            if (!SBRestrictable.canWrite(this)) {
                throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
            }
            try (Statement stmt = this.getDatabase().createStatement();){
                String sql = "DELETE FROM " + this.DBTableName("casdiam");
                stmt.executeUpdate(this.modQuery(sql));
                int n = 1;
                for (String d : diameters) {
                    if (d == null || d.length() == 0) {
                        throw new SBException("Casing diameter blank");
                    }
                    sql = "INSERT INTO " + this.DBTableName("casdiam") + " (sort_order, diam) VALUES (" + n + "," + SB.DBString((String)d) + ")";
                    stmt.executeUpdate(this.modQuery(sql));
                    ++n;
                }
            }
        }
        this.casingDiameters = diameters;
    }

    public boolean getHasCasdiam() {
        return this.hasCasdiam;
    }

    public String getSchema() {
        String schema = null;
        if (this.connectionManager.getTablePrefix() != null && this.connectionManager.getTablePrefix().length() > 0) {
            schema = this.connectionManager.getTablePrefix().indexOf(46) > 0 ? this.connectionManager.getTablePrefix().substring(0, this.connectionManager.getTablePrefix().indexOf(46)) : this.connectionManager.getTablePrefix();
            schema = this.connectionManager.getDBType() == DBType.POSTGRESQL ? schema.toLowerCase() : schema.toUpperCase(Locale.ENGLISH);
        }
        return schema;
    }

    public void setSchema() throws SQLException {
        String schema = this.getSchema();
        if (schema != null && !schema.isBlank() && this.isConnected()) {
            String sql = null;
            if (this.connectionManager.getDBType() == DBType.POSTGRESQL) {
                sql = "SET SCHEMA " + SB.DBString((String)schema);
            } else if (this.connectionManager.getDBType() == DBType.ORACLE) {
                sql = "ALTER SESSION SET CURRENT_SCHEMA=" + schema;
            }
            if (sql != null) {
                try (Statement stmt = this.getDatabase().createStatement();){
                    LOGGER.log(Level.INFO, "Setting schema to {0}", schema);
                    stmt.execute(sql);
                }
            }
        }
    }

    public Well getCurrentWell() throws SQLException, SBException {
        if (this.currentWell != null) {
            return this.currentWell;
        }
        int wellID = Lastval.getInt(this, "WELL_ID");
        if (wellID > 0) {
            this.currentWell = this.getWell(wellID);
            return this.currentWell;
        }
        return null;
    }

    public Project getProject(int projID) throws SQLException {
        if (projID == 0) {
            throw new IllegalStateException("Attempt to get default project");
        }
        return this.wells.getProject(projID);
    }

    public Project addProject(String name, String descr) throws SQLException, SBPermissionException, InvalidFieldException {
        Project project = this.wells.addProject(name, descr);
        this.setChanged();
        this.notifyObservers((Object)project);
        return project;
    }

    public WellList addWellList(String name, String descr, int projID) throws SQLException, SBPermissionException, InvalidFieldException {
        WellList wellList = this.wells.addWellList(name, descr, projID);
        this.setChanged();
        this.notifyObservers((Object)wellList);
        return wellList;
    }

    public Set<Integer> getProjIDs(Well well) {
        return this.wells.getProjIDs(well);
    }

    public void deleteProject(int projID, boolean deleteGroups, boolean deleteSets) throws SQLException, SBPermissionException, SBException {
        Collection<TxGroup> groups = this.getTxGroups(projID, false);
        List<TxGroupSet> sets = this.getTxGroupSets(projID, false);
        if (deleteGroups && !deleteSets) {
            for (TxGroupSet set : sets) {
                for (TxGroup group : set.getGroups()) {
                    if (!groups.contains(group)) continue;
                    throw new SBException("Can't delete group '" + group.getName() + "', which occurrs in set '" + String.valueOf(set) + "'");
                }
            }
        }
        if (!deleteGroups && !deleteSets) {
            for (TxGroup group : groups) {
                group.updateDetails(group.getName(), group.getColour(), 0, group.getDescr());
            }
            for (TxGroupSet set : sets) {
                set.update(set.getName(), 0, set.getGroups(), set.isOrdered(), set.getDescr());
            }
        } else {
            for (TxGroupSet set : sets) {
                if (deleteSets) {
                    this.deleteTxGroupSet(set);
                    continue;
                }
                set.update(set.getName(), 0, set.getGroups(), set.isOrdered(), set.getDescr());
            }
            for (TxGroup group : groups) {
                if (deleteGroups) {
                    this.deleteTxGroup(group);
                    continue;
                }
                group.updateDetails(group.getName(), group.getColour(), 0, group.getDescr());
            }
        }
        assert (this.getTxGroups(projID, false).isEmpty());
        assert (this.getTxGroupSets(projID, false).isEmpty());
        this.wells.deleteProject(projID);
    }

    public void deleteWellList(int wellListID) throws SQLException, SBPermissionException, SBException {
        this.wells.deleteWellList(wellListID);
    }

    public List<Project> getProjects() throws SuppressedSQLException {
        return this.wells.getProjects();
    }

    public WellList getDefaultWellList(int projectID, boolean useAnyDefault) {
        return this.wells.getDefaultWellList(projectID, useAnyDefault);
    }

    public WellList getDefaultWellList(int projectID) {
        return this.wells.getDefaultWellList(projectID);
    }

    @Deprecated
    public void loadProjectCombo(DefaultComboBoxModel model, boolean includeDefault) throws SQLException {
        this.wells.loadProjectCombo(model, includeDefault);
    }

    public void writeWellLocations(List<Well> wells, String title, BufferedWriter out, String eol) throws IOException, SQLException, SBException {
        this.wells.writeWellLocations(wells, title, out, eol);
    }

    public WellRepository<Well> getWellService() {
        return this.wells;
    }

    public WellListRepository<WellList> getWellListService() {
        return this.wells;
    }

    public Iterator<Well> getWellIterator(String wellListName) throws SQLException, SBException {
        return this.wells.getWellIterator(wellListName);
    }

    public Project getProject(String projectName) throws SQLException {
        return this.wells.getProject(projectName);
    }

    public Iterator<Well> getWellIterator(int wellListID) throws SQLException, SBException {
        return this.wells.getWellIterator(wellListID);
    }

    public Iterator<Well> getWellIterator(int wellListID, WellGeoSort order) throws SQLException, SBException {
        return this.wells.getWellIterator(wellListID, order);
    }

    public Stream<Well> getWellStream(int wellListID) {
        return this.wells.getWellStream(wellListID);
    }

    public int getnWells(int wellListID) throws SQLException, SBException {
        return this.wells.getnWells(wellListID);
    }

    public int getnProjects() throws SQLException {
        return this.wells.getnProjects();
    }

    public int getnLoadedWells() {
        return this.wells.size();
    }

    public void addWellToProject(Well well, int projID) throws SQLException, SBPermissionException {
        this.wells.addWellsToProject(List.of(well), projID);
    }

    public void addWellsToProject(List<Well> list, int projID) throws SQLException, SBPermissionException {
        this.wells.addWellsToProject(list, projID);
    }

    public void addWellToWellList(Well well, int wellListID) throws SQLException, SBPermissionException {
        this.wells.addWells(List.of(well), wellListID);
    }

    public void addWellsToWellList(List<Well> list, int wellListID) throws SQLException, SBPermissionException {
        this.wells.addWells(list, wellListID);
    }

    public void removeWellsFromWellList(Collection<Well> wellsToRemove, int wellListID) throws SQLException, SBPermissionException {
        this.wells.removeWellsFromWellList(wellsToRemove, wellListID);
    }

    public void removeWellFromProject(Well well, int projectID) throws SQLException, SBPermissionException {
        List<Well> listOfWell = List.of(well);
        for (WellList wellList : this.wells.getWellLists(projectID)) {
            this.wells.removeWellsFromWellList(listOfWell, wellList.getID());
            this.commit();
        }
    }

    public void deleteWell(Well well) throws SQLException, SBException, SBPermissionException {
        this.wells.deleteWell(well);
    }

    public Well getWell(int wellID) throws SQLException, SBException {
        return this.wells.getWell(wellID);
    }

    public Well getWell(String wellCode) throws SQLException, SBException {
        for (Well well : this.wells.getWells(0)) {
            if (!well.getWellCode().equals(wellCode)) continue;
            return well;
        }
        return null;
    }

    public Well getWellAt(int nWell) {
        return this.wells.getWellAt(nWell);
    }

    public Well addWell(WellHeader header) throws SQLException, SBException {
        return this.wells.addWell(header);
    }

    public WsWell addWellToWorkspace(int wellID, String filePath) {
        return this.addWellToWorkspace(wellID, filePath, null);
    }

    public WsWell addWellToWorkspace(int wellID, String filePath, WellHeader header) {
        return this.wells.addWellToWorkspace(wellID, filePath, header);
    }

    public WsWell addWellToWorkspace(Well dbWell) {
        assert (dbWell.getDataModel() != this);
        return this.wells.addWellToWorkspace(dbWell);
    }

    public Iterator<Well> getWellIterator() {
        return this.wells.getWellIterator();
    }

    @Override
    public int nextControl(String tableName, String columnName) throws SQLException {
        return this.nextControl(tableName, columnName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextControl(String tableName, String columnName, Statement existingStatement) throws SQLException {
        Statement stmt = existingStatement;
        if (existingStatement == null) {
            stmt = this.getDatabase().createStatement();
        }
        try {
            int n = this.nextControl.nextControl(this, tableName, columnName, stmt);
            return n;
        }
        finally {
            if (existingStatement == null) {
                stmt.close();
            }
        }
    }

    private void queryMetaData() throws SQLException, SBException {
        String tableName;
        assert (this.connectionManager.getConnectionMetaData() != null) : "Metadata not set";
        String schema = this.getSchema();
        this.hasUserPassword = false;
        boolean hasControlTable = false;
        ResultSet rs = this.connectionManager.getConnectionMetaData().getColumns(null, schema, "%", "%");
        boolean tablesExist = false;
        while (rs.next()) {
            tablesExist = true;
            tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            if (tableName.equalsIgnoreCase("WELLPERM")) {
                this.hasWellPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("USERPERM")) {
                this.hasUserPerm = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLTVD") && columnName.equalsIgnoreCase("ISPLAN")) {
                this.hasTVDplan = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("USERDEF") && columnName.equalsIgnoreCase("PASSWORD")) {
                this.hasUserPassword = true;
                continue;
            }
            if (!tableName.equalsIgnoreCase("CONTROL")) continue;
            hasControlTable = true;
        }
        rs.close();
        this.nextControl = new NextControl(hasControlTable);
        rs = this.connectionManager.getConnectionMetaData().getTables(null, schema, "%", null);
        while (rs.next()) {
            tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            if (tableName.equalsIgnoreCase("WELLIST_MBR")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.sbwlIsView = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLS_MASTER")) {
                if (tableType.equalsIgnoreCase("VIEW")) {
                    this.hasWellsMaster = true;
                }
                Well.loadWellMasterFields(this, this.wellMasterFields);
                continue;
            }
            if (tableName.equalsIgnoreCase("CASING_MASTER")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.hasCasingMaster = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("CORES_MASTER")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.hasCoresMaster = true;
                continue;
            }
            if (tableName.equalsIgnoreCase("WELLSMARK_MASTER")) {
                if (!tableType.equalsIgnoreCase("VIEW")) continue;
                this.hasSmarkMaster = true;
                continue;
            }
            if (!tableName.equalsIgnoreCase("WITSML_CURVE")) continue;
            this.hasWITSML = true;
        }
        rs.close();
        if (!tablesExist) {
            throw new SBException("No tables found for schema: " + schema);
        }
        try {
            Boolean bool = this.getDatabasePrefBool("IMAGEDB");
            if (bool != null) {
                this.storeImage = bool;
            }
        }
        catch (SQLException sqle) {
            throw new SBException("Error querying table: " + this.DBTableName("pref_system") + "\nSQL Error: " + sqle.getMessage());
        }
        if (this.connectionManager.getDBType() == DBType.ORACLE) {
            rs = this.connectionManager.getConnectionMetaData().getTables(null, "EPISAMGR", "CORES", null);
            if (rs.next()) {
                this.hasSAMBA = true;
            }
            rs.close();
        }
    }

    public static String getJregOption(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getURegOption(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getRegOption(str);
            return setting;
        }
        return value;
    }

    public static String getJreg(String str) throws UnsatisfiedLinkError {
        String value = SBdb.getUReg(str);
        if (value == null || value.length() == 0 || value.startsWith("Error")) {
            String setting = SBdb.getReg(str);
            return setting;
        }
        return value;
    }

    public boolean isConnected() {
        if (this.connectionManager != null) {
            return this.connectionManager.isPersistentConnectionPresent();
        }
        return false;
    }

    public static String getHostName(String hostName) {
        if (((String)hostName).toLowerCase().endsWith(".mdb")) {
            hostName = "Driver={Microsoft Access Driver (*.mdb)};DBQ=" + (String)hostName;
        }
        return hostName;
    }

    public boolean reconnect() throws SQLException {
        if (this.connectionManager == null) {
            throw new IllegalStateException("Attempting to reconnect whithout a connection manager.");
        }
        try {
            this.connectionManager.closePersistentConnection();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error occurred while attempting to close connection during reconnection attempt.", e);
        }
        this.connectionManager.setupPersistentConnection();
        return true;
    }

    public boolean connect(ConnectionFactory connFactory) throws SQLException {
        this.connectionManager = new ConnectionManager(connFactory);
        this.connectionManager.setupPersistentConnection();
        if (this.connectionManager.getConnectionMetaData().supportsResultSetType(1004)) {
            // empty if block
        }
        return true;
    }

    public int getDaysToPwExpiry() throws SQLException {
        int days = 999;
        String sql = "SELECT expiry_date FROM user_users";
        try (Statement stmt = this.getDatabase().createStatement();){
            Date now = Audit.getDatabaseServerDate(this, stmt);
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                java.sql.Date date = rs.getDate("expiry_date");
                if (date != null) {
                    days = (int)((date.getTime() - now.getTime()) / 24L / 60L / 60L / 1000L);
                } else {
                    LOGGER.log(Level.INFO, "No password expiry date set");
                }
            }
        }
        return days;
    }

    public boolean validSchema() throws SQLException {
        if (!this.isConnected()) {
            return false;
        }
        ResultSet rs = this.connectionManager.getConnectionMetaData().getColumns(null, this.getSchema(), this.connectionManager.getDBType() == DBType.POSTGRESQL ? "pref_system" : "PREF_SYSTEM", "%");
        boolean tablesExist = false;
        while (rs.next()) {
            tablesExist = true;
        }
        return tablesExist;
    }

    public boolean login(String abr, String password) throws SQLException, SBException {
        this.queryMetaData();
        this.fillUserDetails(abr, password);
        this.getSampleTops();
        this.setEventPrefixes();
        this.getAllowMultipleEnvSchemes();
        this.getShowArchivedSchemes();
        return true;
    }

    public String getDefaultUser(String sysName) throws SQLException, SBException {
        String shortSysName;
        ResultSet rs;
        Statement stmt;
        Object sql;
        if (sysName == null || sysName.length() == 0) {
            if (this.connectionManager.getDBType() == DBType.ORACLE) {
                sql = "SELECT user FROM DUAL";
                stmt = this.getDatabase().createStatement();
                try {
                    rs = stmt.executeQuery(this.modQuery((String)sql));
                    if (rs.next()) {
                        sysName = rs.getString("user");
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                System.out.println("Queried for default Oracle user: " + sysName);
                if (sysName == null || sysName.isEmpty()) {
                    return null;
                }
            } else if (this.connectionManager.getDBType() == DBType.MSSQLSERVER) {
                sql = "SELECT SYSTEM_USER AS mssqluser";
                stmt = this.getDatabase().createStatement();
                try {
                    rs = stmt.executeQuery(this.modQuery((String)sql));
                    if (rs.next()) {
                        sysName = rs.getString("mssqluser");
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                System.out.println("Queried for default SQL Server user: " + sysName);
                if (sysName == null || sysName.isEmpty()) {
                    return null;
                }
            } else if (this.connectionManager.getDBType() == DBType.POSTGRESQL) {
                sql = "SELECT user";
                stmt = this.getDatabase().createStatement();
                try {
                    rs = stmt.executeQuery(this.modQuery((String)sql));
                    if (rs.next()) {
                        sysName = rs.getString("user");
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                System.out.println("Queried for default Postgres user: " + sysName);
                if (sysName == null || sysName.isEmpty()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        sql = "SELECT abr, user_priv FROM " + this.DBTableName("USERDEF") + " WHERE ucase(sys_name)=ucase(" + SB.DBString((String)sysName.toUpperCase()) + ")";
        if (sysName.contains("@") && (shortSysName = sysName.substring(0, sysName.indexOf("@"))).length() > 0) {
            sql = (String)sql + " OR ucase(sys_name)=ucase(" + SB.DBString((String)shortSysName.toUpperCase()) + ")";
        }
        stmt = this.getDatabase().createStatement();
        try {
            rs = stmt.executeQuery(this.modQuery((String)sql));
            int count = 0;
            String abr = null;
            int priv = 0;
            while (rs.next()) {
                ++count;
                abr = rs.getString("abr");
                priv = rs.getInt("user_priv");
            }
            if (count == 1) {
                if (priv == 0) {
                    throw new SBException("Database connection successful but no privilege to use StrataBugs.");
                }
                this.needsPassword = false;
                String string = abr;
                return string;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return null;
    }

    public void close() throws SQLException {
        this.connectionManager.closePersistentConnectionAndConnectionFactory();
    }

    public void describeText(File file) throws SBException, SQLException, IOException {
        String eol = "\r\n";
        if (this.connectionManager == null || !this.connectionManager.isPersistentConnectionPresent()) {
            throw new SBException("No connection");
        }
        if (this.connectionManager.getConnectionMetaData() == null) {
            this.connectionManager.setupPersistentConnection();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        String lastTable = null;
        String schema = this.connectionManager.getTablePrefix();
        System.out.println("Scheme is: " + schema);
        if (schema != null && schema.indexOf(46) >= 0) {
            schema = schema.substring(0, schema.indexOf(46));
        }
        ResultSet rs = this.connectionManager.getConnectionMetaData().getColumns(null, schema, "%", "%");
        LinkedList<String> pks = new LinkedList<String>();
        while (rs.next()) {
            String remarks;
            String isNullable;
            int nullable;
            String tableName = rs.getString("TABLE_NAME");
            if (tableName.startsWith("MSys") || tableName.indexOf(32) >= 0) continue;
            String columnName = rs.getString("COLUMN_NAME");
            if (!tableName.equals(lastTable)) {
                lastTable = tableName;
                out.write("#" + eol + tableName);
                pks.clear();
                try {
                    ResultSet rs2 = this.connectionManager.getConnectionMetaData().getPrimaryKeys(null, schema, tableName);
                    if (rs2.next()) {
                        pks.add(rs2.getString("COLUMN_NAME"));
                    }
                }
                catch (Exception e) {
                    System.out.println("Warning: primary keys not supported.");
                }
                out.write(eol);
            }
            String paddedColumnName = (columnName + "            ").substring(0, 12);
            String paddedTypName = (rs.getString("TYPE_NAME") + "             ").substring(0, 10);
            out.write("Column\t" + paddedColumnName + "\t\t" + paddedTypName + "\t" + rs.getInt("COLUMN_SIZE"));
            if (pks.contains(columnName)) {
                out.write("\tPRIMARYKEY");
            }
            if ((nullable = rs.getInt("NULLABLE")) == 0) {
                out.write("\tNOTNULL");
            }
            if ((isNullable = rs.getString("IS_NULLABLE")) != null && isNullable.equals("NO")) {
                out.write("\tNOTNULL");
            }
            if ((remarks = rs.getString("REMARKS")) != null) {
                out.write("\t# " + remarks);
            }
            out.write(eol);
        }
        out.write(eol);
        out.close();
    }

    public void createTables(File schemaFile) throws SQLException, IOException, SBException {
        BufferedReader tableDef = new BufferedReader(new FileReader(schemaFile));
        String line = tableDef.readLine();
        boolean requiredTable = true;
        String tableName = null;
        LinkedList<Column> columns = new LinkedList<Column>();
        try (Statement stmt = this.getDatabase().createStatement();){
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    if (line.indexOf(35) > 0) {
                        line = line.substring(0, line.indexOf(35)).trim();
                    }
                    if (line.equalsIgnoreCase("[OPTIONAL]")) {
                        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                            tableName = null;
                            break;
                        }
                        tableName = null;
                        requiredTable = false;
                    } else if (line.equalsIgnoreCase("[REQUIRED]")) {
                        if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                            tableName = null;
                            break;
                        }
                        tableName = null;
                        requiredTable = true;
                    } else if (line.startsWith("Column") || line.startsWith("Optional")) {
                        StringTokenizer tok = new StringTokenizer(line);
                        Column column = new Column();
                        if (tok.nextToken().equals("Optional")) {
                            tok.nextToken();
                        }
                        column.name = tok.nextToken();
                        if (column.name.equalsIgnoreCase("references")) {
                            column.name = "reference";
                        }
                        column.type = tok.nextToken();
                        if (tok.hasMoreTokens()) {
                            column.size = Integer.parseInt(tok.nextToken().trim());
                        }
                        while (tok.hasMoreTokens()) {
                            String constraint = tok.nextToken();
                            if (constraint.equalsIgnoreCase("NOTNULL")) {
                                column.notNull = true;
                                continue;
                            }
                            if (constraint.equalsIgnoreCase("PRIMARYKEY")) {
                                column.primaryKey = true;
                                continue;
                            }
                            throw new SBException("Unrecognised constraint in line: " + line);
                        }
                        columns.add(column);
                    } else {
                        if (tableName != null && columns.size() > 0) {
                            if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                                tableName = null;
                                break;
                            }
                            tableName = null;
                        }
                        tableName = line;
                    }
                }
                line = tableDef.readLine();
            }
            if (!this.saveTable(requiredTable, stmt, tableName, columns)) {
                return;
            }
        }
        this.commit();
        tableDef.close();
    }

    boolean saveTable(boolean requiredTable, Statement stmt, String tableName, List columns) throws SQLException {
        if (tableName == null) {
            return true;
        }
        if (requiredTable || tableName.equalsIgnoreCase("ANALY_HDR") || tableName.equalsIgnoreCase("CASDIAM") || tableName.equalsIgnoreCase("ENVTRN") || tableName.equalsIgnoreCase("IGD_HDR") || tableName.equalsIgnoreCase("SBLTHTRN") || tableName.equalsIgnoreCase("LTHTRNSCH") || tableName.equalsIgnoreCase("SYNSCH")) {
            this.createTable(stmt, tableName, columns, false);
            System.out.println("Created table: " + tableName);
            columns.clear();
        } else {
            columns.clear();
        }
        return true;
    }

    public int getTableRowCount(Statement stmt, String tableName, String query) throws SQLException {
        ResultSet rs = this.connectionManager.getConnectionMetaData().getTables(null, this.getSchema(), tableName, null);
        if (rs.next()) {
            return this.getTableRowCount(stmt, tableName);
        }
        if (query == null) {
            return -1;
        }
        rs = stmt.executeQuery(this.modQuery(query));
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        return count;
    }

    public int getTableRowCount(Statement stmt, String tableName) throws SQLException {
        String sql = "SELECT count(*) AS r FROM " + this.DBTableName(tableName);
        ResultSet rs = stmt.executeQuery(this.modQuery(sql));
        if (rs.next()) {
            return rs.getInt("r");
        }
        return -1;
    }

    public void copyTable(SBdb newDB, String tableName, String whereClause, boolean clearValues) throws SQLException, ParseException {
        int i;
        ResultSet rs;
        SimpleDateFormat timestampDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Statement newStmt = newDB.getDatabase().createStatement();
        if (clearValues) {
            System.out.println("Deleting from table: " + newDB.DBTableName(tableName));
            newStmt.executeUpdate("DELETE FROM " + newDB.DBTableName(tableName));
        }
        Object selectQuery = "SELECT * FROM " + newDB.DBTableName(tableName);
        ResultSet rsNew = newStmt.executeQuery((String)selectQuery);
        ResultSetMetaData copyMeta = rsNew.getMetaData();
        int nCols = copyMeta.getColumnCount();
        selectQuery = "SELECT ";
        for (int i2 = 1; i2 <= nCols; ++i2) {
            Object columnName = copyMeta.getColumnName(i2);
            if (((String)columnName).equalsIgnoreCase("PLAN") && this.connectionManager.getDBType() == DBType.MSSQLSERVER) {
                columnName = "[" + (String)columnName + "]";
            }
            selectQuery = (String)selectQuery + (String)columnName;
            if (i2 >= nCols) continue;
            selectQuery = (String)selectQuery + ",";
        }
        selectQuery = (String)selectQuery + " FROM " + this.DBTableName(tableName);
        Statement stmt = this.getDatabase().createStatement();
        if (whereClause != null) {
            selectQuery = (String)selectQuery + whereClause;
        }
        try {
            System.out.println("Executing query in copyTable: " + (String)selectQuery);
            rs = stmt.executeQuery((String)selectQuery);
        }
        catch (SQLException se) {
            selectQuery = "SELECT * FROM " + this.DBTableName(tableName);
            if (whereClause != null) {
                selectQuery = (String)selectQuery + whereClause;
            }
            System.out.println("Re-trying: Select query: " + (String)selectQuery);
            rs = stmt.executeQuery((String)selectQuery);
            copyMeta = rs.getMetaData();
            nCols = copyMeta.getColumnCount();
        }
        ResultSetMetaData copyFromMeta = rs.getMetaData();
        String sql = "INSERT INTO " + newDB.DBTableName(tableName) + " (";
        for (i = 1; i <= nCols; ++i) {
            Object columnName = copyMeta.getColumnName(i);
            if (((String)columnName).equalsIgnoreCase("PLAN") && newDB.getDBType() == DBType.MSSQLSERVER) {
                columnName = "[" + (String)columnName + "]";
            }
            sql = sql + (String)columnName;
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + " ) VALUES (";
        for (i = 1; i <= nCols; ++i) {
            sql = sql + "?";
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement pStmt = newDB.getDatabase().prepareStatement(sql);
        int nRows = 0;
        int nBatch = 0;
        while (rs.next()) {
            Object paramString = "";
            if (newDB.getDBType() != DBType.ORACLE) {
                pStmt.clearParameters();
            }
            for (int col = 1; col <= nCols; ++col) {
                Object obj;
                block32: {
                    if (copyFromMeta.getColumnType(col) == 2004) {
                        pStmt.setBytes(col, rs.getBytes(col));
                        paramString = (String)paramString + "BLOB as GetBytes,";
                        continue;
                    }
                    if (copyFromMeta.getColumnType(col) == 2005) {
                        pStmt.setCharacterStream(col, rs.getCharacterStream(col));
                        paramString = (String)paramString + "CLOB,";
                        continue;
                    }
                    obj = rs.getObject(col);
                    if (obj != null) {
                        if (newDB.getDBType() == DBType.SQLITE && obj instanceof Float) {
                            Float f = (Float)obj;
                            obj = f.doubleValue();
                        }
                        if (copyMeta.getColumnName(col).equalsIgnoreCase("CREATOR") || copyMeta.getColumnName(col).equalsIgnoreCase("MODIFIER") || copyMeta.getColumnName(col).equalsIgnoreCase("UPDATER")) {
                            try {
                                int usrID = Integer.parseInt(obj.toString());
                                if (usrID > 0 && this.getUser(usrID) != null) {
                                    pStmt.setObject(col, obj);
                                    break block32;
                                }
                                pStmt.setNull(col, copyMeta.getColumnType(col));
                            }
                            catch (NumberFormatException ex) {
                                pStmt.setNull(col, copyMeta.getColumnType(col));
                            }
                        } else if (obj.getClass().getName().equals("oracle.sql.TIMESTAMP")) {
                            Date d = timestampDateFormat.parse(obj.toString());
                            Timestamp o = new Timestamp(d.getTime());
                            pStmt.setObject(col, o);
                        } else if (copyFromMeta.getColumnType(col) == 2) {
                            if (obj.toString().length() > 40) {
                                System.out.println("Truncating object: " + String.valueOf(obj) + " in param string: " + (String)paramString);
                                pStmt.setObject(col, obj.toString().substring(0, 40));
                            } else {
                                pStmt.setObject(col, obj);
                            }
                        } else {
                            pStmt.setObject(col, obj);
                        }
                    } else {
                        int type = copyMeta.getColumnType(col);
                        if (type == 3) {
                            type = 8;
                        }
                        if (type == -9) {
                            type = 12;
                        }
                        pStmt.setNull(col, type);
                    }
                }
                paramString = (String)paramString + String.valueOf(obj) + ",";
            }
            pStmt.addBatch();
            if (++nRows % 10000 == 0) {
                System.out.printf("Added %,d rows\n", nRows);
            }
            if (nRows % 300000 != 0) continue;
            System.out.println("Executing & committing batch # " + ++nBatch + " ...");
            this.executeBatch(pStmt, sql);
            newDB.commit();
        }
        System.out.println("Executing & committing batch # " + ++nBatch);
        this.executeBatch(pStmt, sql);
        newStmt.close();
        pStmt.close();
        stmt.close();
        newDB.commit();
    }

    private void executeBatch(PreparedStatement pStmt, String sql) throws SQLException {
        try {
            int[] affectedRows = pStmt.executeBatch();
            int nInserted = 0;
            int nError = 0;
            int nNoInfo = 0;
            for (int row : affectedRows) {
                if (row > 0) {
                    ++nInserted;
                    continue;
                }
                if (row == -3) {
                    ++nError;
                    continue;
                }
                ++nNoInfo;
            }
            System.out.println("Number of rows affected: " + affectedRows.length + ", Inserted: " + nInserted + ", Error: " + nError + ", No Info: " + nNoInfo);
        }
        catch (SQLException se) {
            System.out.println("SQL :" + sql);
            throw se;
        }
    }

    public void setGrants(String grantee) throws SQLException, SBException {
        if (this.connectionManager.getDBType() != DBType.ORACLE) {
            throw new SBException("Not an Oracle database");
        }
        ResultSet tables = this.connectionManager.getConnectionMetaData().getTables(null, this.getSchema(), "%", new String[]{"TABLE"});
        try (Statement stmt = this.getDatabase().createStatement();){
            while (tables.next()) {
                String tableName = tables.getString("table_name");
                String sql = "GRANT ALL ON " + this.DBTableName(tableName) + " TO " + grantee;
                stmt.execute(sql);
            }
        }
        this.commit();
    }

    void createTable(Statement stmt, String name, List columns, boolean drop) throws SQLException {
        String sql;
        if (name.equalsIgnoreCase("image")) {
            return;
        }
        if (drop) {
            try {
                sql = "DROP table " + name;
                stmt.executeUpdate(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sql = "CREATE TABLE " + this.DBTableName(name) + " ( ";
        Iterator it = columns.iterator();
        String pk = " CONSTRAINT " + name + "_pk PRIMARY KEY (";
        boolean hasPk = false;
        while (it.hasNext()) {
            Column column = (Column)it.next();
            sql = sql + column.name + " ";
            sql = sql + column.getType(this.connectionManager.getDBType());
            if (column.type.equalsIgnoreCase("text")) {
                sql = sql + "(" + column.size + ")";
            }
            if (column.notNull) {
                sql = sql + " NOT NULL";
            }
            if (column.primaryKey) {
                if (hasPk) {
                    pk = pk + ",";
                }
                pk = pk + column.name;
                hasPk = true;
            }
            if (!it.hasNext()) continue;
            sql = sql + ",";
        }
        if (hasPk) {
            sql = sql + "," + pk + ")";
        }
        sql = sql + ")";
        stmt.executeUpdate(sql);
    }

    @Override
    public String DBTableName(String tableName) {
        tableName = tableName.toUpperCase(Locale.ENGLISH);
        if (this.connectionManager != null && this.connectionManager.getTablePrefix() != null && this.connectionManager.getTablePrefix().length() > 0) {
            if (!this.connectionManager.getTablePrefix().contains(".")) {
                return this.connectionManager.getTablePrefix() + "." + tableName;
            }
            return this.connectionManager.getTablePrefix() + tableName;
        }
        return tableName;
    }

    @Override
    public String modQuery(String query) {
        int i;
        if (this.connectionManager.getDBType() == DBType.ORACLE || this.connectionManager.getDBType() == DBType.MSSQLSERVER || this.connectionManager.getDBType() == DBType.MYSQL || this.connectionManager.getDBType() == DBType.SQLITE || this.connectionManager.getDBType() == DBType.H2 || this.connectionManager.getDBType() == DBType.POSTGRESQL) {
            while ((i = ((String)query).toUpperCase().indexOf(" UCASE")) >= 0) {
                query = ((String)query).substring(0, i) + " upper" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf("(UCASE")) >= 0) {
                query = ((String)query).substring(0, i) + "(upper" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf(" LCASE")) >= 0) {
                query = ((String)query).substring(0, i) + " lower" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf("(LCASE")) >= 0) {
                query = ((String)query).substring(0, i) + "(lower" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf("=UCASE")) >= 0) {
                query = ((String)query).substring(0, i) + "=upper" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf(",UCASE")) >= 0) {
                query = ((String)query).substring(0, i) + ",upper" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf("=LCASE")) >= 0) {
                query = ((String)query).substring(0, i) + "=lower" + ((String)query).substring(i + 6);
            }
            while ((i = ((String)query).toUpperCase().indexOf(",LCASE")) >= 0) {
                query = ((String)query).substring(0, i) + ",lower" + ((String)query).substring(i + 6);
            }
        } else {
            while ((i = ((String)query).indexOf("floor(")) >= 0) {
                query = ((String)query).substring(0, i) + "int(" + ((String)query).substring(i + 6);
            }
        }
        if (this.connectionManager.getDBType() == DBType.POSTGRESQL) {
            while ((i = ((String)query).toUpperCase().indexOf("NVL(")) >= 0) {
                query = ((String)query).substring(0, i) + "coalesce(" + ((String)query).substring(i + "NVL(".length());
            }
        }
        SqlCache.setSql((String)query);
        SqlCache.printSql();
        return query;
    }

    private void fillUserDetails(String abr, String password) throws SQLException, SBException {
        block10: {
            Statement stmt = this.getDatabase().createStatement();
            Object sql = "SELECT user_id,name,sys_name,disc,user_priv,colour";
            if (this.needsPassword()) {
                sql = (String)sql + ",password";
            }
            sql = (String)sql + "," + Audit.sqlFieldString();
            sql = (String)sql + " FROM " + this.DBTableName("USERDEF") + " WHERE abr='" + abr + "'";
            try {
                ResultSet rs = stmt.executeQuery(this.modQuery((String)sql));
                if (rs.next()) {
                    int userID = rs.getInt("user_id");
                    String name = rs.getString("name");
                    String sysName = rs.getString("sys_name");
                    char discID = rs.getString("disc").charAt(0);
                    Discipline disc = Discipline.getDisc((char)discID);
                    int priv = rs.getInt("user_priv");
                    Color colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                    String userPassword = "";
                    if (this.needsPassword() && (userPassword = rs.getString("password")) != null) {
                        userPassword = SB.crypt((boolean)false, (String)"SBPW", (String)userPassword);
                    }
                    if (this.needsPassword() && (userPassword == null || !userPassword.equalsIgnoreCase(password))) {
                        stmt.close();
                        throw new SBException("Password incorrect");
                    }
                    Audit audit = new Audit(rs);
                    this.user = this.getUser(userID);
                    if (this.user == null) {
                        this.user = new Userdef(this, userID, abr, name, sysName, disc, colour, userPassword, priv, audit);
                    }
                    break block10;
                }
                stmt.close();
                throw new SBException("Login name not recognised");
            }
            catch (NumberFormatException ne) {
                throw new SBException("Problem getting password from database");
            }
            finally {
                stmt.close();
            }
        }
    }

    public Userdef addUser(String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        if (this.getUser(abr) != null) {
            throw new SBException("User: " + abr + " already exists");
        }
        Userdef u = new Userdef(this, abr, name, sysName, discID, colour, pwd, priv);
        this.putUser(u);
        return u;
    }

    public void deleteUser(String abr) throws SQLException, SBPermissionException {
        Userdef u = this.getUser(abr);
        if (this.getUser().isReadOnly()) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        u.delete();
        this.users.remove(u.getUsrID());
        this.updateAuditTrail("USERDEF", "DELETE " + u.getName() + "/" + abr + " [" + u.getUsrID() + "]");
    }

    public static int did2dtype(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 2;
            }
            case 'N': {
                return 4;
            }
            case 'P': {
                return 6;
            }
            case 'A': 
        }
        return 8;
    }

    public static int did2comType(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'M': {
                return 3;
            }
            case 'N': {
                return 5;
            }
            case 'P': {
                return 7;
            }
            case 'A': 
        }
        return 9;
    }

    public static String getDiscNoun(char discID) {
        switch (discID) {
            default: {
                return discNounString[0];
            }
            case 'N': {
                return discNounString[1];
            }
            case 'P': {
                return discNounString[2];
            }
            case 'A': 
        }
        return discNounString[3];
    }

    public static char getDiscIDFromNoun(String discAdj) {
        if (discAdj.equalsIgnoreCase(discNounString[0])) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase(discNounString[1])) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase(discNounString[2])) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase(discNounString[3])) {
            return 'A';
        }
        return '\u0000';
    }

    public static int did2i(char discID) {
        switch (discID) {
            default: {
                return 0;
            }
            case 'N': {
                return 1;
            }
            case 'P': {
                return 2;
            }
            case 'A': 
        }
        return 3;
    }

    public static char dt2discID(int dataType) {
        switch (dataType) {
            case 2: 
            case 3: {
                return 'M';
            }
            case 4: 
            case 5: {
                return 'N';
            }
            case 6: 
            case 7: {
                return 'P';
            }
            case 8: 
            case 9: {
                return 'A';
            }
        }
        return ' ';
    }

    public static String getDiscAbr(char discID) {
        switch (discID) {
            default: {
                return "Micro.";
            }
            case 'N': {
                return "Nanno.";
            }
            case 'P': {
                return "Paly.";
            }
            case 'A': 
        }
        return "Macro.";
    }

    public static String getDiscAdj(char discID) {
        switch (discID) {
            default: {
                return "Microfaunal";
            }
            case 'N': {
                return "Nannofloral";
            }
            case 'P': {
                return "Palynofloral";
            }
            case 'A': 
        }
        return "Macrofaunal";
    }

    public static char getDiscIDFromAdj(String discAdj) {
        if (discAdj.equalsIgnoreCase("Microfaunal")) {
            return 'M';
        }
        if (discAdj.equalsIgnoreCase("Nannofloral")) {
            return 'N';
        }
        if (discAdj.equalsIgnoreCase("Palynofloral")) {
            return 'P';
        }
        if (discAdj.equalsIgnoreCase("Macrofaunal")) {
            return 'A';
        }
        return '\u0000';
    }

    public void putTableColumnWidths(String name, JTable table) throws SQLException {
        Object widths = "";
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int columnWidth = table.getColumnModel().getColumn(i).getWidth();
            widths = (String)widths + columnWidth + " ";
        }
        Lastval.putString(this, name, (String)widths);
    }

    public void setTableColumnWidths(String name, JTable table) throws SQLException {
        String widths = Lastval.getString(this, name);
        if (widths != null && widths.length() > 0) {
            StringTokenizer tok = new StringTokenizer(widths);
            if (tok.countTokens() != table.getColumnCount()) {
                return;
            }
            int i = 0;
            while (tok.hasMoreTokens()) {
                int columnWidth = Integer.parseInt(tok.nextToken());
                table.getColumnModel().getColumn(i++).setPreferredWidth(columnWidth);
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.getDatabase() != null) {
            this.connectionManager.commitPersistentConnection();
            SqlCache.printCommit();
        }
    }

    @Override
    public void doRollback() {
        try {
            if (this.getDatabase() != null) {
                this.connectionManager.rollbackPersistentConnection();
            }
            SqlCache.printRollback();
        }
        catch (SQLException sqle) {
            LOGGER.log(Level.WARNING, "Error rolling back: " + sqle.getMessage());
            sqle.printStackTrace();
        }
    }

    @Override
    public SynonymService getSynonymService() {
        if (this.synSch == null) {
            try {
                this.synSch = SynSch.initSchemeHeaders(this);
            }
            catch (SQLException ex) {
                throw SuppressedSQLException.withoutRollback(ex);
            }
        }
        return this.synSch;
    }

    @Deprecated
    public Taxon getPreferredTerm(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getPreferredTerm");
        }
        int prefID = scheme.getPref(specID);
        if (prefID > 0) {
            return this.getTaxon(prefID);
        }
        return null;
    }

    public void updateSynonymy(int schID, Taxon taxon, Taxon pref, List<Taxon> synonymList) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        SynonymScheme scheme = this.getSynSch(schID);
        if (synonymList == null) {
            scheme.remove(taxon.getSpecID());
        } else {
            if (pref == null) {
                throw new SBException("No prefrred term");
            }
            ArrayList<Integer> list = new ArrayList<Integer>(synonymList.size());
            for (Taxon t : synonymList) {
                if (t == pref) {
                    throw new SBException("Synonym is same as preferred term");
                }
                list.add(t.getSpecID());
            }
            Taxon prefPref = this.getPreferredTerm(schID, pref.getSpecID());
            if (prefPref != null) {
                if (!list.contains(prefPref.getSpecID())) {
                    System.out.println("Previous Preferred term: " + String.valueOf(prefPref) + " is not listed as a junior synonym of: " + String.valueOf(pref));
                }
                scheme.deleteSyn(prefPref.getSpecID());
            }
            if (taxon != pref && !list.contains(taxon.getSpecID())) {
                list.add(taxon.getSpecID());
            }
            scheme.updateSyn(pref.getSpecID(), list);
        }
    }

    @Deprecated
    public List<Taxon> getSynonymy(int schID, int specID) throws SQLException, SBException {
        SynonymScheme scheme = this.getSynSch(schID);
        if (scheme == null) {
            throw new SBException("Synonym scheme ID: " + schID + " unknown in SBdb.getSynonymy");
        }
        LinkedList<Taxon> tSyn = new LinkedList<Taxon>();
        List<Integer> syn = scheme.getSyn(specID);
        for (Integer synID : syn) {
            tSyn.add(this.getTaxon(synID));
        }
        return tSyn;
    }

    public void deleteSynonymScheme(SynonymScheme scheme) throws SQLException, SBException, SBPermissionException {
        scheme.delete();
        this.synSch.remove(scheme.getSchID());
    }

    public SynonymScheme addSynonymScheme(String name) throws SQLException, InvalidFieldException, SBPermissionException {
        Collection<SynonymScheme> c = this.getSynSchemes();
        for (SynonymScheme s : c) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("Scheme '" + name + "' already exists");
        }
        SynonymScheme scheme = new SynonymScheme(this, name);
        this.synSch.put(scheme.getSchID(), scheme);
        return scheme;
    }

    public int addWsSynonymScheme(SBdb ws, SynonymScheme wsScheme) throws SQLException, InvalidFieldException, SBPermissionException, SBException {
        Collection<SynonymScheme> c = this.getSynSchemes();
        SynonymScheme dbScheme = null;
        int nUpdated = 0;
        for (SynonymScheme s : c) {
            if (!s.getName().equalsIgnoreCase(wsScheme.getName())) continue;
            dbScheme = s;
            break;
        }
        if (dbScheme == null) {
            dbScheme = this.addSynonymScheme(wsScheme.getName());
        }
        for (Map.Entry<Integer, Integer> entry : wsScheme.getSynonyms().entrySet()) {
            Taxon wsTaxon = ws.getTaxon(entry.getKey());
            if (wsTaxon != null) {
                if (wsTaxon.getLink() != null) {
                    Taxon dbTaxon = wsTaxon.getLink();
                    Taxon wsPref = ws.getTaxon(entry.getValue());
                    if (wsPref != null) {
                        Taxon dbPref = wsPref.getLink();
                        if (dbPref != null) {
                            List<Integer> existingDbSyns = dbScheme.getSyn(dbPref.getSpecID());
                            if (!existingDbSyns.contains(dbTaxon.getSpecID())) {
                                existingDbSyns.add(dbTaxon.getSpecID());
                                try {
                                    dbScheme.updateSyn(dbPref.getSpecID(), existingDbSyns);
                                    ++nUpdated;
                                }
                                catch (SBException sbe) {
                                    System.out.println("Error adding synonym for: " + String.valueOf(wsTaxon) + ". " + sbe.getMessage());
                                }
                                continue;
                            }
                            System.out.println("Synonym already exists for: " + String.valueOf(dbTaxon));
                            continue;
                        }
                        System.out.println("Workspace preferred term " + String.valueOf(wsPref) + " is unmatched in database");
                        continue;
                    }
                    System.out.println("Can't find workspace taxon for ws preferred term specID: " + String.valueOf(entry.getValue()));
                    continue;
                }
                System.out.println("Workspace taxon: " + String.valueOf(wsTaxon) + " is unmatched.");
                continue;
            }
            System.out.println("Can't find workspace taxon for ws specID: " + String.valueOf(entry.getValue()));
        }
        return nUpdated;
    }

    public void mergeOcc(CoOccurrence coOcc, boolean mergeAbundance) throws SQLException, SBException {
        this.wells.mergeOcc(coOcc, mergeAbundance);
    }

    public void mergeTaxa(Taxon donor, Taxon target, int targetSpecType, int retainJuniorSynonym) throws SQLException, SBException, SBPermissionException {
        this.events.mergeTaxonEvents(donor.getSpecID(), target.getSpecID());
        this.taxa.merge(donor, target, targetSpecType, retainJuniorSynonym);
        Iterator<Well> it = this.wells.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            well.updateTaxonRef(donor, target);
        }
        if (this.txGroups != null) {
            for (TxGroup group : this.txGroups.values()) {
                if (group.removeSpecies(donor.getSpecID())) {
                    group.insertSpecies(target.getSpecID());
                }
                if (!group.hasChanged()) continue;
                group.notifyObservers();
            }
        }
        if (this.overlays != null) {
            for (Overlay overlay : this.overlays.values()) {
                if (!overlay.isLoaded() || !overlay.hasSpecID(donor.getSpecID())) continue;
                if (overlay.hasSpecID(target.getSpecID())) {
                    overlay.clearTaxon(donor.getSpecID());
                    continue;
                }
                overlay.replaceSpecID(donor.getSpecID(), target.getSpecID());
                overlay.notifyObservers();
            }
        }
        if (retainJuniorSynonym > 0) {
            this.getSynSch(retainJuniorSynonym).load();
        }
        this.setChanged();
        this.notifyObservers(donor);
    }

    public List<AgeCurve> getAgeCurves() throws SQLException {
        if (this.ageCurves == null) {
            this.ageCurves = new LinkedList<AgeCurve>();
            if (this.isConnected()) {
                AgeCurve.loadAll(this, this.ageCurves);
                Collections.sort(this.ageCurves);
            }
        }
        return this.ageCurves;
    }

    public AgeCurve getAgeCurve(int curveID) throws SQLException {
        for (AgeCurve curve : this.getAgeCurves()) {
            if (curve.getCurveID() != curveID) continue;
            return curve;
        }
        return null;
    }

    public void addAgeCurve(AgeCurve ageCurve) throws SQLException, SBPermissionException {
        if (this.isConnected()) {
            ageCurve.store(this);
        } else if (ageCurve.getCurveID() < 1) {
            throw new IllegalStateException("Attempt to add age curve to workspace with ID " + ageCurve.getCurveID());
        }
        if (this.ageCurves == null) {
            this.ageCurves = new LinkedList<AgeCurve>();
        }
        this.ageCurves.add(ageCurve);
        Collections.sort(this.ageCurves);
    }

    public void deleteAgeCurve(int curveID) throws SQLException, SBPermissionException {
        AgeCurve curve = this.getAgeCurve(curveID);
        curve.delete(this);
        this.ageCurves.remove(curve);
        this.updateAuditTrail("AGECURVE", "DELETE " + curve.getTitle() + " [" + curve.getCurveID() + "]");
    }

    public AgeCurve fillAgeCurve(SBdb db, int curveID) throws SQLException, SBException {
        if (this.isConnected()) {
            throw new IllegalStateException("Attempt to fill AgeCurve into connected workspace");
        }
        AgeCurve wsCurve = this.getAgeCurve(curveID);
        if (wsCurve == null) {
            AgeCurve dbCurve = db.getAgeCurve(curveID);
            wsCurve = dbCurve.copyToWorkspace(this, db);
            this.ageCurves.add(wsCurve);
        }
        return wsCurve;
    }

    public void writeXML(BufferedWriter out, Set<Integer> dataTypes, SBdb db, List<File> files, boolean closeFile, boolean includeTaxonReferences) throws IOException, SQLException, SBException {
        Object well;
        String abr;
        if (db.getExportSingleUser(false) && !db.getExportSingleUserAbr(false).isEmpty() && (abr = db.getExportSingleUserAbr(false)) != null && !abr.isEmpty()) {
            this.setWorkspaceUserID(abr, dataTypes);
        }
        int INDENT = 3;
        String ind = SB.getXMLIndent((int)3);
        String ind2 = SB.getXMLIndent((int)6);
        TaxonOcc.SPECIESRECORD.clear();
        XmlWriter.writeXMLHeader(out, db.getLicenceCustomer());
        if (this.chronoSchemes != null) {
            for (IGDScheme iGDScheme : this.chronoSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.lstratSchemes != null) {
            for (IGDScheme iGDScheme : this.lstratSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.biozoneSchemes != null) {
            for (IGDScheme iGDScheme : this.biozoneSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.sequenceSchemes != null) {
            for (IGDScheme iGDScheme : this.sequenceSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.magnetoSchemes != null) {
            for (IGDScheme iGDScheme : this.magnetoSchemes.values()) {
                iGDScheme.writeXML(out, 3);
            }
        }
        if (this.envSchemes != null) {
            for (EnvScheme envScheme : this.envSchemes.values()) {
                envScheme.writeXML(out, 3);
            }
        }
        if (this.ageCurves != null) {
            for (AgeCurve ageCurve : this.ageCurves) {
                ageCurve.writeXML(out, 3);
            }
        }
        HashSet<Integer> abundanceSchemesInUse = new HashSet<Integer>();
        Iterator<Well> iterator = this.getWellIterator();
        while (iterator.hasNext()) {
            well = (WsWell)iterator.next();
            abundanceSchemesInUse.addAll(((Well)well).getAbnSchemeList());
        }
        for (AbundanceScheme abundanceScheme : this.getAbundanceSchemeService().getAllAbundanceSchemes()) {
            if (!abundanceSchemesInUse.contains(abundanceScheme.getAbnSchID())) continue;
            XmlWriter.writeAbundanceScheme(out, 1, abundanceScheme);
        }
        Taxon.exportImages = null;
        if (this.taxa.getSize() > 0 || this.txGroups != null && !this.txGroups.isEmpty()) {
            out.write(ind + "<TaxonList>\n");
            for (Taxon taxon : this.taxa.getTaxa()) {
                out.write(ind2 + "<Taxon Species=\"" + SB.getXMLstring((String)taxon.toString()) + "\">\n");
                taxon.writeXML(out, 3, files);
                out.write(ind2 + "</Taxon>\n");
            }
            Iterator<SbugsLink> wsGenera = new HashSet();
            if (this.txGroups != null && !this.txGroups.isEmpty()) {
                for (TxGroup group : this.txGroups.values()) {
                    wsGenera.addAll(this.getTxGroupGenera(group));
                }
            }
            Iterator iterator2 = wsGenera.iterator();
            while (iterator2.hasNext()) {
                Genus genus = (Genus)iterator2.next();
                out.write(ind2 + "<Genus Genus=\"" + SB.getXMLstring((String)genus.toString()) + "\">\n");
                List<String> genusLines = XmlWriter.getGenusLines(genus.getGenusCopy());
                XmlWriter.writeLines(out, XmlWriter.getIndentString(3), genusLines);
                out.write(ind2 + "</Genus>\n");
            }
            out.write(ind + "</TaxonList>\n");
        }
        if (this.txGroups != null && !this.txGroups.isEmpty()) {
            for (TxGroup txGroup : this.txGroups.values()) {
                txGroup.writeXML(out, 3, files);
            }
        }
        if (this.sets != null && !this.sets.isEmpty()) {
            for (TxGroupSet txGroupSet : this.sets.values()) {
                txGroupSet.writeXML(out, 3, files);
            }
        }
        if (this.synSch != null && !this.synSch.isEmpty()) {
            for (SynonymScheme synonymScheme : this.synSch.values()) {
                if (!synonymScheme.hasSynonyms()) continue;
                out.write(ind + "<SynonymScheme Name=\"" + SB.getXMLstring((String)synonymScheme.getName()) + "\">\n");
                synonymScheme.writeXML(out, 3);
                out.write(ind + "</SynonymScheme>\n");
            }
        }
        out.write(ind + "<UserList>\n");
        for (Userdef userdef : this.getUsers()) {
            userdef.writeXML(out, 6);
        }
        out.write(ind + "</UserList>\n");
        for (SBEvent sBEvent : this.getSBEvents(false, null)) {
            sBEvent.writeXML(out, 3);
        }
        if (this.compositeStandards != null) {
            for (CompositeStandard compositeStandard : this.compositeStandards.values()) {
                compositeStandard.writeXML(out, 3);
            }
        }
        if (this.logDef != null) {
            for (LogDef logDef : this.logDef.values()) {
                logDef.writeXML(out, 3);
            }
        }
        Iterator<Well> iterator3 = this.getWellIterator();
        TaxonOcc.exportImages = null;
        while (iterator3.hasNext()) {
            well = (WsWell)iterator3.next();
            out.write(ind + "<Well Name=\"" + SB.getXMLstring((String)((Well)well).getWellName()) + "\">\n");
            this.putUserIDs(((WsWell)well).writeXML(out, 6, ((Well)well).getWellUnits(), dataTypes, files));
            out.write(ind + "</Well>\n");
        }
        if (closeFile) {
            out.write("</StrataBugs>\n");
            out.flush();
            out.close();
        }
    }

    public LinkedList<LithTrnScheme> getLithTrnSchemes() throws SBException, SQLException {
        if (this.lithTrnSchemes == null) {
            this.lithTrnSchemes = LithTrnScheme.loadSchemes(this);
        }
        return this.lithTrnSchemes;
    }

    public void addLithTrnScheme(LithTrnScheme scheme) throws SBException, SQLException {
        this.getLithTrnSchemes();
        for (LithTrnScheme sch : this.lithTrnSchemes) {
            if (sch.getID() != scheme.getID()) continue;
            return;
        }
        this.lithTrnSchemes.add(scheme);
    }

    public void deleteLithTrnScheme(int schID) throws SBException, SQLException {
        LithTrnScheme scheme = null;
        for (LithTrnScheme sch : this.getLithTrnSchemes()) {
            if (sch.getID() != schID) continue;
            scheme = sch;
            break;
        }
        if (scheme == null) {
            throw new SBException("Cannot delete LithTrnScheme: No scheme with ID: " + schID + " found.");
        }
        LithTrnScheme.delete(this, schID);
        this.commit();
        this.lithTrnSchemes.remove(scheme);
    }

    public int decodeChartPrintPrefs() {
        int fit = 0;
        try {
            String params = Lastval.getString(this, "CHPRNTPREF");
            if (params.isEmpty()) {
                System.out.println("No chart print parameters to decode");
                return fit;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                int token;
                fit = token = Integer.parseInt(tok.nextToken());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return fit;
    }

    public String getDBDateSQLString(long date) {
        if (this.connectionManager.getDBType() == DBType.ACCESS) {
            Date utilDate = new Date(date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "#" + df.format(utilDate) + "#";
        }
        if (this.connectionManager.getDBType() == DBType.H2) {
            Date utilDate = new Date(date);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + df.format(utilDate) + "'";
        }
        Timestamp stamp = new Timestamp(date);
        return "to_timestamp('" + String.valueOf(stamp) + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    public boolean getExportSingleUser(boolean load) throws SQLException {
        if (load) {
            EXPORT_SINGLE_USER = Lastval.getInt(this, "EXPSGLUSR") == 1;
        }
        return EXPORT_SINGLE_USER;
    }

    public void setExportSingleUser(boolean exportSingle) throws SQLException {
        if (exportSingle != EXPORT_SINGLE_USER) {
            Lastval.putInt(this, "EXPSGLUSR", exportSingle ? 1 : 0);
        }
        EXPORT_SINGLE_USER = exportSingle;
    }

    public String getExportSingleUserAbr(boolean load) throws SQLException {
        if (load) {
            EXPORT_SINGLE_USER_ABR = this.getDatabasePref("expsglusr");
        }
        return EXPORT_SINGLE_USER_ABR;
    }

    public void setExportSingleUserAbr(String abr) throws SQLException {
        this.putDatabasePref("expsglusr", abr);
    }

    void setWorkspaceUserID(String abr, Set<Integer> dTypes) throws SBException, SQLException {
        Well well;
        if (this.isConnected()) {
            throw new SBException("Attempt to change user ID on connected database");
        }
        Iterator<Well> it = this.getWellIterator();
        while (it.hasNext()) {
            well = it.next();
            Discipline[] interpIt = well.getInterpIterator();
            while (interpIt.hasNext()) {
                WellInterp interp = interpIt.next();
                for (Biocom b : interp.getComments()) {
                    for (Biocom biocom : interp.getComments()) {
                        if (b == biocom || b.getDiscID() != biocom.getDiscID() || !b.getTopSample().equals(biocom.getTopSample())) continue;
                        throw new SBException("Cannot export with single user ID due to duplicated comments.\nEnsure you export only one comment per discipline/depth.");
                    }
                }
            }
        }
        it = this.getWellIterator();
        while (it.hasNext()) {
            well = it.next();
            for (Discipline discID : Discipline.values()) {
                LinkedList<AnalystHeader> thisDisc = new LinkedList<AnalystHeader>();
                for (AnalystHeader hdr : well.getAnalystHeaders()) {
                    if (hdr.getDiscipline() != discID) continue;
                    thisDisc.add(hdr);
                }
                if (thisDisc.size() <= 1) continue;
                HashSet<Integer> hashSet = new HashSet<Integer>();
                int newNo = 1;
                for (AnalystHeader h : thisDisc) {
                    if (hashSet.contains(h.getAnalyNumber())) {
                        while (hashSet.contains(newNo)) {
                            ++newNo;
                        }
                        h.setAnalyNo(newNo);
                    }
                    hashSet.add(h.getAnalyNumber());
                }
            }
        }
        Userdef newUser = this.getUser(abr);
        if (newUser == null) {
            int ID = this.users.lastKey() + 1;
            newUser = new Userdef(this, ID, abr, abr, "", Discipline.MICRO, Color.BLACK, null, 0, null);
            this.putUser(newUser);
        }
        System.out.println("Setting all workspace data to user: " + newUser.getAbr());
        it = this.getWellIterator();
        while (it.hasNext()) {
            Well well2 = it.next();
            block25: for (Integer i : dTypes) {
                if (SBdb.isInterpDataType(i)) {
                    Iterator<WellInterp> interpIt = well2.getInterpIterator();
                    while (interpIt.hasNext()) {
                        WellInterp interp = interpIt.next();
                        switch (i) {
                            case 10: 
                            case 11: 
                            case 12: {
                                List<IGDIntervalZone> list = interp.getIGDList(IGDInterval.dType2IGDtype(i));
                                for (IGDIntervalZone zone : list) {
                                    zone.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 7: 
                            case 9: {
                                for (Biocom comment : interp.getComments(SBdb.dt2discID(i))) {
                                    comment.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 15: {
                                for (IGDIntervalEnv env : interp.getEnvs()) {
                                    env.audit.setAnalyst(newUser.getUsrID());
                                }
                                break;
                            }
                            case 14: {
                                for (SQPick pick : interp.getSQPicks()) {
                                    pick.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 16: {
                                for (WellEvent event : interp.getEvents()) {
                                    event.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 18: {
                                for (Intcom intcom : interp.getIntcoms()) {
                                    intcom.setAnalyst(newUser);
                                }
                                break;
                            }
                            case 17: {
                                if (interp.getLOC() == null) break;
                                interp.getLOC().setAnalyst(newUser);
                                break;
                            }
                        }
                        interp.getHeader().setAnalyst(newUser);
                    }
                    continue;
                }
                switch (i) {
                    case 1: {
                        for (Sample sample : well2.getSamples()) {
                            sample.setAnalyst(newUser);
                        }
                        continue block25;
                    }
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        for (AnalystHeader hdr : well2.getAnalystHeaders()) {
                            if (hdr.getDiscID() != SBdb.dt2discID(i)) continue;
                            hdr.setAnalyst(newUser);
                        }
                    }
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 25: {
                        break;
                    }
                    case 24: {
                        well2.getMarkers().setAnalyst(newUser);
                        break;
                    }
                }
            }
            well2.setAnalyst(newUser);
        }
        LinkedList<Integer> schTypes = new LinkedList<Integer>();
        if (this.chronoSchemes != null) {
            schTypes.add(3);
        }
        if (this.lstratSchemes != null) {
            schTypes.add(2);
        }
        if (this.biozoneSchemes != null) {
            schTypes.add(4);
        }
        if (this.sequenceSchemes != null) {
            schTypes.add(10);
        }
        for (Integer i : schTypes) {
            for (IGDScheme s : this.getIGDSchemes((int)i, true)) {
                s.setAnalyst(newUser);
            }
        }
        for (EnvScheme es : this.getEnvSchemes()) {
            es.setAnalyst(newUser);
        }
        for (SBEvent e : this.getSBEvents(false, null)) {
            e.setAnalyst(newUser);
        }
        if (this.compositeStandards != null) {
            for (CompositeStandard cmpStd : this.compositeStandards.values()) {
                cmpStd.setAnalyst(newUser);
            }
        }
        if (this.ageCurves != null) {
            for (AgeCurve ageCurve : this.ageCurves) {
                ageCurve.setAnalyst(newUser);
            }
        }
        if (this.txGroups != null) {
            for (TxGroup g : this.txGroups.values()) {
                g.setAnalyst(newUser);
            }
        }
        if (this.sets != null) {
            for (TxGroupSet s : this.sets.values()) {
                s.setAnalyst(newUser);
            }
        }
        this.users = new TreeMap();
        this.users.put(newUser.getUsrID(), newUser);
    }

    public String DBDate(Date date) {
        Object string = SB.DBdf.format(date);
        string = this.connectionManager.getDBType() == DBType.ACCESS ? "#" + (String)string + "#" : SB.DBString((String)string);
        return string;
    }

    public boolean isNetworkError(SQLException ex) {
        int code = ex.getErrorCode();
        String erMsg = ex.getMessage();
        System.out.println("SQLError code is: " + code);
        if (ex instanceof SQLRecoverableException && ex.getMessage().toLowerCase().contains("closed connection")) {
            return true;
        }
        if (ex instanceof SQLTransientConnectionException) {
            return true;
        }
        switch (this.connectionManager.getDBType()) {
            case ACCESS: {
                return code == -1022 || code == -1023;
            }
            case ORACLE: {
                if (code == 3113 || code == 17008 || code == 3135 || code == 3114) {
                    return true;
                }
                if ((erMsg = erMsg.toLowerCase()).contains("connection is closed") || erMsg.contains("connection was aborted") || erMsg.contains("connection lost")) {
                    return true;
                }
                return !this.connectionManager.isConnectionValid();
            }
            case H2: {
                return erMsg.contains("session closed") || erMsg.contains("Database is already closed") || erMsg.toLowerCase().contains("connection is closed");
            }
            case MSSQLSERVER: {
                return erMsg.contains("recv failed") || erMsg.contains("socket write error") || erMsg.toLowerCase().contains("connection is closed") || erMsg.toLowerCase().contains("connection is broken") || erMsg.toLowerCase().contains("reset by peer") || erMsg.contains("not connected");
            }
            case POSTGRESQL: {
                erMsg = erMsg.toLowerCase();
                return erMsg.contains("connection") && erMsg.contains("closed");
            }
        }
        return false;
    }

    private void loadSequenceColours() throws SQLException {
        if (this.sequenceColours != null) {
            return;
        }
        this.sequenceColours = new Color[3];
        this.sequenceColours[0] = this.getMiscColour("COL_HST", Color.RED);
        this.sequenceColours[1] = this.getMiscColour("COL_TST", Color.GREEN);
        this.sequenceColours[2] = this.getMiscColour("COL_LST", Color.BLUE);
    }

    public Color getHstColour() throws SQLException {
        if (this.sequenceColours == null) {
            this.loadSequenceColours();
        }
        return this.sequenceColours[0];
    }

    public Color getTstColour() throws SQLException {
        if (this.sequenceColours == null) {
            this.loadSequenceColours();
        }
        return this.sequenceColours[1];
    }

    public Color getLstColour() throws SQLException {
        if (this.sequenceColours == null) {
            this.loadSequenceColours();
        }
        return this.sequenceColours[2];
    }

    public void updateAuditTrail(String dataType, String ... actions) throws SQLException {
        block15: {
            if (!this.auditTrail || !this.isConnected()) {
                return;
            }
            try (Statement stmt = this.getDatabase().createStatement();){
                String sql = "INSERT INTO " + this.DBTableName("AUDITTRAIL") + "(track_date,user_id,data_type,descrip) VALUES ('" + SB.DBdtf.format(Audit.getDatabaseServerDate(this, stmt)) + "','" + this.getUser().getAbr() + "','" + dataType + "',";
                if (actions.length > 1) {
                    sql = sql + "?)";
                    try (PreparedStatement pStmt = this.getDatabase().prepareStatement(this.modQuery(sql));){
                        for (String action : actions) {
                            pStmt.setString(1, action);
                            pStmt.execute();
                        }
                        break block15;
                    }
                }
                sql = sql + SB.DBString((String)actions[0]) + ")";
                stmt.execute(this.modQuery(sql));
            }
        }
    }

    public void clearVersionsInProjectCache() {
        this.versionsInProjectCache = null;
    }

    public Set<InterpHdr> getVersionsInProject(int projID) throws SQLException, SBException {
        if (projID == 0) {
            return null;
        }
        if (this.versionsInProjectCache == null) {
            this.versionsInProjectCache = new HashMap<Integer, Set<Integer>>();
        }
        if (!this.versionsInProjectCache.containsKey(projID)) {
            this.versionsInProjectCache.put(projID, this.getVersionIdsInProject(projID));
        }
        Set<Integer> versionIds = this.versionsInProjectCache.get(projID);
        HashSet<InterpHdr> hdrs = new HashSet<InterpHdr>();
        for (int interp_id : versionIds) {
            InterpHdr hdr = this.getInterp(interp_id);
            hdrs.add(hdr);
        }
        if (hdrs.isEmpty()) {
            hdrs = null;
        }
        return hdrs;
    }

    private Set<Integer> getVersionIdsInProject(int projID) throws SQLException {
        String sql = "select i.interp_id from ((" + this.DBTableName("IGD") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("IGD_LSTRAT") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("IGD_ENV") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("BCMMNTS") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("EVENTS") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("SQPICK") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("INTCMMNTS") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("LOC") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("FAULTS") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\nunion select i.interp_id from ((" + this.DBTableName("SBSSR") + " i INNER JOIN " + this.DBTableName("WELLIST_MBR") + " m ON i.well_id=m.well_id) INNER JOIN " + this.DBTableName("WELLIST") + " w on m.wellist_id=w.wellist_id) where w.proj_id=?\n group by i.interp_id";
        PreparedStatement stmt = this.getDatabase().prepareStatement(this.modQuery(sql));
        for (int i = 1; i <= 10; ++i) {
            stmt.setInt(i, projID);
        }
        HashSet<Integer> versions = new HashSet<Integer>();
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            versions.add(rs.getInt("interp_id"));
        }
        return versions;
    }

    public List<Userdef> getAnalystsInProject(int projID, Discipline disc) throws SQLException, SBException {
        if (projID == 0) {
            return null;
        }
        HashSet<Userdef> list = new HashSet<Userdef>();
        List wellLists = this.getWellListService().getWellLists(projID);
        for (com.stratadata.model3.project.WellList wl : wellLists) {
            Iterator<Well> wellIterator = this.getWellIterator(wl.getID());
            while (wellIterator.hasNext()) {
                Well well = wellIterator.next();
                if (disc != null) {
                    for (String abr : well.getAnalysts(disc)) {
                        list.add(this.getUser(abr));
                    }
                    continue;
                }
                for (AnalystHeader hdr : well.getAnalystHeaders()) {
                    list.add(this.getUser(hdr.getAnalyst()));
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return new ArrayList<Userdef>(list);
    }

    public void DSCScript() {
        Object sql = "";
        try {
            System.out.println("Modify events table for Duxbury ....");
            Statement stmt = this.getDatabase().createStatement();
            Statement stmt2 = this.getDatabase().createStatement();
            Statement stmt3 = this.getDatabase().createStatement();
            String[] type = new String[]{"FDO", "LDO", ""};
            for (int i = 0; i < type.length; ++i) {
                sql = "SELECT surface_id, name, sch_id FROM SURFACE WHERE sch_id in (select sch_id from igd_sch_bioevents) ";
                if (!type[i].isEmpty()) {
                    sql = (String)sql + "AND name like '" + type[i] + "%'";
                }
                ResultSet rs = stmt.executeQuery((String)sql);
                while (rs.next()) {
                    CompositeStandard std;
                    int surface_id = rs.getInt("surface_id");
                    String evName = rs.getString("name");
                    int sch_id = rs.getInt("sch_id");
                    if (!type[i].isEmpty()) {
                        evName = evName.substring(type[i].length());
                    }
                    System.out.println("Processing event name:" + evName);
                    SBEvent event = this.events.findEvent(evName);
                    if (event == null) {
                        SBEvent.Builder b = new SBEvent.Builder().name(evName);
                        event = this.addSBEvent(b);
                    }
                    sql = "SELECT well_id, interp_id, samp_id FROM sqpick WHERE surface_id=" + surface_id;
                    ResultSet rs2 = stmt2.executeQuery((String)sql);
                    while (rs2.next()) {
                        int wellID = rs2.getInt("well_id");
                        int interpID = rs2.getInt("interp_id");
                        int samp_id = rs2.getInt("samp_id");
                        sql = "INSERT INTO events (well_id, interp_id, samp_id, ev_id, ev_type, disc_id) VALUES (" + wellID + "," + interpID + "," + samp_id + "," + event.getEvID() + ",";
                        switch (i) {
                            case 0: {
                                sql = (String)sql + "'F'";
                                break;
                            }
                            case 1: {
                                sql = (String)sql + "'L'";
                                break;
                            }
                            case 2: {
                                sql = (String)sql + "'S'";
                            }
                        }
                        sql = (String)sql + ",'P')";
                        stmt3.executeUpdate((String)sql);
                    }
                    sql = "SELECT name FROM igd_sch WHERE sch_id=" + sch_id;
                    String schName = "";
                    rs2 = stmt2.executeQuery((String)sql);
                    if (rs2.next()) {
                        schName = rs2.getString("name");
                    }
                    if ((std = this.getCompositeStandard(schName)) == null) {
                        System.out.println("Created composite: " + schName);
                    } else {
                        System.out.println("Found composite; " + schName);
                    }
                    CompositeStandardEvent.Builder cb = new CompositeStandardEvent.Builder().event(event);
                    try {
                        if (event.hasEvType(EventType.SINGLE)) {
                            cb.type(EventType.SINGLE);
                            std.addEvent(cb);
                        }
                        if (event.hasEvType(EventType.TOP)) {
                            cb.type(EventType.TOP);
                            std.addEvent(cb);
                        }
                        if (event.hasEvType(EventType.BASE)) {
                            cb.type(EventType.BASE);
                            std.addEvent(cb);
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Exception from adding event to composite: " + std.getName() + "\t" + ex.getMessage());
                    }
                    sql = "DELETE FROM sqpick where surface_id=" + surface_id;
                    stmt2.executeUpdate((String)sql);
                    sql = "DELETE FROM surface where surface_id=" + surface_id;
                    stmt2.executeUpdate((String)sql);
                }
            }
            if (JOptionPane.showConfirmDialog(null, "Commit?") == 0) {
                this.commit();
            } else {
                this.doRollback();
            }
        }
        catch (Exception ex) {
            this.doRollback();
            System.out.println("SQL: " + (String)sql);
            ex.printStackTrace();
        }
    }

    public void DSCScript2() {
        Object sql = "";
        try {
            System.out.println("Modify events table for Duxbury ....");
            Statement stmt = this.getDatabase().createStatement();
            Statement stmt2 = this.getDatabase().createStatement();
            sql = "SELECT interp_id, ev_id, samp_id, well_id, ev_type FROM events WHERE interp_id=5";
            ResultSet rs = stmt.executeQuery((String)sql);
            while (rs.next()) {
                int interp_id = rs.getInt("interp_id");
                int ev_id = rs.getInt("ev_id");
                int well_id = rs.getInt("well_id");
                int samp_id = rs.getInt("samp_id");
                String evType = rs.getString("ev_type");
                try {
                    sql = "UPDATE EVENTS SET interp_id=0 WHERE interp_id=" + interp_id + " AND well_id=" + well_id + " AND samp_id=" + samp_id + " AND ev_id=" + ev_id + " AND ev_type='" + evType + "'";
                    stmt2.executeUpdate((String)sql);
                    System.out.println("Row updated");
                }
                catch (SQLException se) {
                    System.out.println("Exception updating row: " + interp_id + "," + well_id + "," + samp_id + "," + ev_id + "," + evType);
                    System.out.println(se.getMessage());
                }
            }
            if (JOptionPane.showConfirmDialog(null, "Commit?") == 0) {
                this.commit();
            } else {
                this.doRollback();
            }
        }
        catch (Exception ex) {
            this.doRollback();
            System.out.println("SQL: " + (String)sql);
            ex.printStackTrace();
        }
    }

    public boolean resequenceSpecIDs() throws SQLException {
        double ratio;
        String sql;
        Statement stmt = this.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sql = "select max(spec_id)/count(spec_id) as ratio from " + this.DBTableName("species"));
        if (rs.next() && (ratio = rs.getDouble("ratio")) < 1.1) {
            return false;
        }
        sql = "select spec_id from " + this.DBTableName("species") + " order by spec_id";
        LinkedList<Integer> specIDs = new LinkedList<Integer>();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            specIDs.add(rs.getInt("spec_id"));
        }
        String[] specTables = new String[]{"TAXONOCC", "EVENTDIC", "GROUPMBR", "OVR_MAP", "SIPMCODE", "SYNONYMY", "TXLOAD", "TXIMAGE", "CHTPANLMBR"};
        boolean complete = false;
        block1: while (!complete) {
            complete = true;
            Iterator it = specIDs.iterator();
            int last = 0;
            while (it.hasNext()) {
                int specID = (Integer)it.next();
                if (specID - last > 1) {
                    complete = false;
                    int newSpecID = last + 1;
                    System.out.println("Changing: " + specID + " ==> " + newSpecID);
                    sql = "INSERT INTO " + this.DBTableName("species") + " (gen_id,spec_id,q1,species,q2,q3,sub_spec,q4,author,year,alphacode,created,creator,modified,modifier,updated,updater) SELECT gen_id," + newSpecID + ",q1,species,q2,q3,sub_spec,q4,author,year,alphacode,created,creator,modified,modifier,updated,updater FROM species WHERE spec_id=" + specID;
                    stmt.executeUpdate(sql);
                    for (String table : specTables) {
                        sql = "UPDATE " + this.DBTableName(table) + " SET spec_id=" + newSpecID + " WHERE spec_id=" + specID;
                        stmt.executeUpdate(sql);
                    }
                    sql = "UPDATE " + this.DBTableName("SYNONYMY") + " SET pref=" + newSpecID + " WHERE pref=" + specID;
                    stmt.executeUpdate(sql);
                    sql = "DELETE FROM " + this.DBTableName("SPECIES") + " WHERE spec_id=" + specID;
                    stmt.executeUpdate(sql);
                    this.commit();
                    it.remove();
                    specIDs.add(last, newSpecID);
                    continue block1;
                }
                last = specID;
            }
        }
        return true;
    }

    public static int getBSint(Discipline disc) {
        switch (disc) {
            case MICRO: {
                return 3;
            }
            case NANNO: {
                return 5;
            }
            case PALY: {
                return 7;
            }
            case MACRO: {
                return 9;
            }
        }
        assert (false);
        return 0;
    }

    public static int getDType(Discipline disc) {
        switch (disc) {
            case MICRO: {
                return 2;
            }
            case NANNO: {
                return 4;
            }
            case PALY: {
                return 6;
            }
            case MACRO: {
                return 8;
            }
        }
        assert (false);
        return 0;
    }

    public boolean canDeleteInterp(int interpID) throws SQLException {
        boolean canDelete = true;
        try (Statement stmt = this.getDatabase().createStatement();){
            String[] sqla = new String[]{"SELECT * FROM " + this.DBTableName("CHTCORROCC") + " WHERE INTERP_ID=" + interpID, "SELECT * FROM " + this.DBTableName("CHTMBR") + " WHERE INTERP_ID=" + interpID, "SELECT * FROM " + this.DBTableName("CHTBLOCKMBR") + " WHERE INTERP_ID=" + interpID};
            for (String sql : sqla) {
                ResultSet rs = stmt.executeQuery(this.modQuery(sql));
                while (rs.next()) {
                    canDelete = false;
                }
            }
        }
        return canDelete;
    }

    public String interpChartUsageMessage(int interpID) throws SQLException {
        TreeSet<Object> chartNames = new TreeSet<Object>(Collator.getInstance());
        TreeSet<Object> blockNames = new TreeSet<Object>(Collator.getInstance());
        try (Statement stmt = this.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.modQuery("SELECT c.DESCR FROM " + this.DBTableName("CHTCORROCC") + " cco, " + this.DBTableName("CHART") + "  c WHERE cco.CHART_ID = c.CHART_ID AND cco.INTERP_ID =" + interpID));
            while (rs.next()) {
                chartNames.add(rs.getString("DESCR"));
            }
            rs = stmt.executeQuery(this.modQuery("SELECT c.DESCR FROM " + this.DBTableName("CHTMBR") + " cm, " + this.DBTableName("CHART") + " c WHERE cm.CHART_ID = c.CHART_ID AND cm.INTERP_ID =" + interpID));
            while (rs.next()) {
                chartNames.add(rs.getString("DESCR"));
            }
            rs = stmt.executeQuery(this.modQuery("SELECT cb.DESCR FROM " + this.DBTableName("CHTBLOCKMBR") + " cbm, " + this.DBTableName("CHTBLOCK") + " cb WHERE cbm.BLOCK_ID = cb.BLOCK_ID AND cbm.INTERP_ID = " + interpID));
            while (rs.next()) {
                blockNames.add(rs.getString("DESCR"));
            }
        }
        if (chartNames.size() == 0 && blockNames.size() == 0) {
            return "Interpretation version with ID " + interpID + " is not used in any charts.";
        }
        StringBuilder sb = new StringBuilder("The version is being used in the ");
        if (chartNames.size() > 0) {
            sb.append(chartNames.size() == 1 ? "chart " : "charts ");
            sb.append(TextUtils.joinItems(chartNames, (String)","));
        }
        if (blockNames.size() > 0) {
            if (chartNames.size() > 0) {
                sb.append(" and the ");
            }
            sb.append(blockNames.size() == 1 ? "block " : "blocks ");
            sb.append(TextUtils.joinItems(blockNames, (String)","));
        }
        sb.append(".");
        return sb.toString();
    }

    public LicenseCustomer getLicenceCustomer() {
        return this.licence;
    }

    public void setLicenceCustomer(LicenseCustomer customer) {
        this.licence = customer;
    }

    public WebServiceDescriptionService getWebServiceDescriptionService() throws SuppressedSQLException {
        if (this.webServiceDescriptions == null) {
            try {
                this.webServiceDescriptions = new WebServices(this);
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
        }
        return this.webServiceDescriptions;
    }

    public SlideStoreService getSlideStoreService() {
        return this.slideStoreService;
    }
}

