/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.image.OccurrenceImage;
import com.stratadata.model3.image.OccurrenceImageDelete;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.analysis.Situation;
import com.stratadata.model3.well.sample.SampleComparator;
import com.stratadata.model3.well.sample.SampleProperties;
import com.stratadata.model3.well.sample.SampleStringFactory;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import model3.AnalystHeader;
import model3.Audit;
import model3.DEXFile;
import model3.IGDIntervalZone;
import model3.Lithdesc;
import model3.SBdb;
import model3.SampleAge;
import model3.SampleInsertException;
import model3.SampleLithology;
import model3.SampleLithologyUnit;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.Well;
import model3.WellInterp;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;
import util.SortEntry;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class Sample
extends SBObservable
implements SbugsStatus,
SortEntry,
SampleProperties,
Comparable<Sample> {
    private final SBdb sbdb;
    private final int sampID;
    private HashSet<Integer> mergedIDs;
    private final int wellID;
    private SampleDepth depth;
    private SampleType type;
    private double gridX;
    private double gridY;
    private String textLabel = "";
    private SectionType sectionType = SectionType.WELL;
    private Audit audit = new Audit();
    private String stratigraphyString = null;
    String donorAnalyst = "";
    String donorSampleType = null;
    boolean hasImportedAgeData = false;
    Color status = SbugsStatus.UNKNOWN;
    public char displayUnits = (char)77;
    boolean[] detailsLoaded = new boolean[4];
    List<Smpdtl> analyses = new LinkedList<Smpdtl>();
    final SampleLithology sampleLithology;
    private HashMap<Integer, SampleAge> ages = new HashMap();
    Sample link = null;
    public static final float SMALL = 0.0029f;

    private Sample(Builder builder, SBdb sbdb, int wellID, int sampID, SectionType sectionType) {
        this.sbdb = sbdb;
        this.wellID = wellID;
        this.sampID = sampID;
        this.sectionType = sectionType;
        this.depth = builder.depth;
        this.type = builder.type;
        this.textLabel = builder.textLabel;
        if (builder.audit != null) {
            this.audit = builder.audit;
        }
        this.sampleLithology = builder.sampleLithology;
    }

    public SectionType getSectionType() {
        return this.sectionType;
    }

    public Sample getLink() {
        return this.link;
    }

    void setLink(Sample comp) throws SQLException, SBException {
        this.link = comp;
        for (Smpdtl dtl : this.analyses) {
            dtl.link = null;
            if (comp == null) continue;
            int analyNo = dtl.getAnalyNo();
            for (Smpdtl compDtl : comp.analyses) {
                if (compDtl.getDiscID() != dtl.getDiscID() || !compDtl.getAnalystAbr().equals(dtl.getAnalystAbr()) || compDtl.getAnalyNo() != analyNo) continue;
                dtl.link = compDtl;
            }
        }
    }

    public String getStratigraphy(WellInterp wellInterp, boolean refresh) throws SBException {
        if (wellInterp != null && (refresh || this.stratigraphyString == null)) {
            this.stratigraphyString = wellInterp.getStratigraphy(this.getDepth());
        }
        return this.stratigraphyString;
    }

    public void moveDtl(int wellID, AnalystHeader hdr, AnalystHeader newHdr) throws SBException, SQLException {
        if (this.getSmpdtl(newHdr.getAnalyID()) != null) {
            throw new SBException("New Analyst already exists for Sample: " + String.valueOf(this));
        }
        Smpdtl dtl = this.getSmpdtl(hdr.getAnalyID());
        if (dtl == null) {
            throw new SBException("Can't relocate analysis for moving in sample: " + String.valueOf(this));
        }
        dtl.move(wellID, newHdr);
        this.setChanged();
    }

    public void mergeDtl(int wellID, Smpdtl dtl, AnalystHeader newHdr) throws SBException, SQLException {
        Smpdtl target = this.getSmpdtl(newHdr.getAnalyID());
        if (target == null) {
            throw new SBException("Cannot find target analysis for Sample: " + String.valueOf(this));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            target.mergeOcc(dtl, stmt, wellID, this.sampID);
            this.deleteDtl(wellID, dtl.getHeader().getAnalyID(), dtl);
        }
    }

    boolean hasEnvData(AnalystHeader hdr) {
        for (Smpdtl smpdtl : this.analyses) {
            if (hdr != null && smpdtl.getHeader() != hdr || !smpdtl.hasEnvData()) continue;
            return true;
        }
        return false;
    }

    void mergeAnalyses(Sample donor) throws SBException {
        if (donor.analyses != null) {
            for (Smpdtl smpdtl : donor.analyses) {
                smpdtl.setSample(this, true);
                this.insert(smpdtl);
            }
        }
    }

    private SampleAge getDefaultSampleAge() {
        SampleAge age = this.ages.get(0);
        if (age == null) {
            age = new SampleAge();
            this.ages.put(0, age);
        }
        return age;
    }

    public SampleLithology getLithology() {
        return this.sampleLithology;
    }

    public String getSortEntry() {
        return Sample.getSortEntry(this.getTopDepth(), this.getBaseDepth(), this.type, this.sbdb.useSampleTops());
    }

    private static String getSortEntry(Double topDepth, Double baseDepth, SampleType type, boolean useSampleTops) {
        int second;
        int first;
        int SLFACT = 10000000;
        int top = topDepth == null ? (int)Math.round(baseDepth * 1000.0) : (int)Math.round(topDepth * 1000.0);
        int base = baseDepth == null ? (int)Math.round(topDepth * 1000.0) : (int)Math.round(baseDepth * 1000.0);
        if (useSampleTops) {
            first = top;
            second = base;
        } else {
            first = base;
            second = top;
        }
        String entry = "" + (first + 10000000);
        while (entry.length() < 8) {
            entry = " " + entry;
        }
        String baseString = "" + (second + 10000000);
        while (baseString.length() < 8) {
            baseString = " " + baseString;
        }
        return entry + baseString + type.name();
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return true;
        }
        if (this.getTopDepth() != null && this.getBaseDepth() != null) {
            return false;
        }
        Sample sample = (Sample)e;
        if (!sample.type.equals((Object)this.type) || sample.getTopDepth() == null || sample.getBaseDepth() == null) {
            return false;
        }
        if (this.getTopDepth() != null && this.depth.compareTop(sample.getTopDepth()) == 0) {
            return true;
        }
        return this.getBaseDepth() != null && this.depth.compareBase(sample.getBaseDepth()) == 0;
    }

    boolean isEquivalent(Builder builder) {
        if (builder.type != this.type) {
            return false;
        }
        if (builder.depth.top == null ^ this.depth.top == null) {
            return false;
        }
        if (this.depth.top != null && (int)(builder.depth.top * 1000.0) != (int)(this.depth.top * 1000.0)) {
            return false;
        }
        if (builder.depth.base == null ^ this.depth.base == null) {
            return false;
        }
        return this.depth.base == null || (int)(builder.depth.base * 1000.0) == (int)(this.depth.base * 1000.0);
    }

    public int getCreatorID() {
        return this.audit.creator;
    }

    public int getModifierID() {
        return this.audit.modifier;
    }

    public int getUpdaterID() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public com.stratadata.model3.audit.Audit getAudit() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    SampleAge getSampleAge(int interpID) {
        return this.ages.get(interpID);
    }

    public Double getAge(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.age;
        }
        return null;
    }

    public Double getRatio(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ratio;
        }
        return null;
    }

    public Float getAgeErrorPlus(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageErrorPlus;
        }
        return null;
    }

    public Float getAgeErrorMinus(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageErrorMinus;
        }
        return null;
    }

    public Double getAgeBelow(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.ageBelow;
        }
        return null;
    }

    public double getAge(WellInterp interp) {
        return this.getAge(interp.interpID);
    }

    public double getAgeBelow(WellInterp interp) {
        return this.getAgeBelow(interp.interpID);
    }

    static Builder copyToDatabase(SBdb db, Sample wsSample) throws SQLException, SBException {
        if (wsSample.sbdb.isConnected()) {
            throw new IllegalArgumentException("Illegal attempt to copy database sample");
        }
        Builder builder = new Builder();
        builder.type(wsSample.type).label(wsSample.textLabel).topDepth(wsSample.depth.top).baseDepth(wsSample.depth.base);
        builder.audit(new Audit(db, wsSample.sbdb, wsSample.audit));
        return builder;
    }

    static Builder copyToWorkspace(SBdb ws, Sample dbSample) throws SQLException, SBException {
        if (!dbSample.sbdb.isConnected()) {
            throw new IllegalArgumentException("Illegal attempt to copy workspace sample");
        }
        Builder builder = new Builder();
        builder.type(dbSample.type).label(dbSample.textLabel).topDepth(dbSample.depth.top).baseDepth(dbSample.depth.base);
        dbSample.audit.fillWorkspace(dbSample.sbdb, ws);
        builder.audit(new Audit(ws, dbSample.sbdb, dbSample.audit));
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    static Sample parseSample(SBdb db, Lithdesc lithdesc, DEXFile.DEXsection section, char sectionType, Well well, Set dataTypes, int[] wellAbn, boolean setWellHeaderUnits, HashMap<Integer, Sample> dups) throws SBException, SQLException {
        Builder builder = new Builder();
        char displayUnits = 'M';
        int sampID = 0;
        String donorAnalyst = null;
        SampleAge age = null;
        LinkedList<SampleLithologyUnit> liths = new LinkedList<SampleLithologyUnit>();
        Audit audit = new Audit();
        char discID = '\u0000';
        int lithCode = 0;
        int lithPercent = 0;
        String analyst = null;
        String picker = null;
        String source = null;
        String notes = null;
        Date smpdtlModified = null;
        String smpdtlModifier = null;
        float coarse = 0.0f;
        float medium = 0.0f;
        float fine = 0.0f;
        float weight = 0.0f;
        Smpdtl.AnalysisType analysisType = Smpdtl.AnalysisType.ANALYSED;
        String taxonDonorString = null;
        int counts = 0;
        int fssCoarse = 0;
        int fssFine = 0;
        boolean reworked = false;
        boolean caved = false;
        boolean marker = false;
        int identType = 80;
        int form = 67;
        int growth = 65;
        String preservation = null;
        String comment = null;
        String colour = null;
        String subjAbund = null;
        String speciesType = null;
        LinkedList<Object> occs = new LinkedList<Object>();
        int specID = 0;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("TOP DEPTH")) {
                builder.topDepth(DepthUtils.parseDepthString((String)value, (sectionType == 'O' ? 1 : 0) != 0));
                displayUnits = DepthUnits.parseDepthUnitsFromString((String)value).getChar();
                if (well.getWellUnits() == displayUnits || displayUnits <= '\u0000' || !setWellHeaderUnits) continue;
                well.getHeader().setWellUnits(displayUnits);
                continue;
            }
            if (label.equalsIgnoreCase("BASE DEPTH")) {
                builder.baseDepth(DepthUtils.parseDepthString((String)value, (sectionType == 'O' ? 1 : 0) != 0));
                displayUnits = DepthUnits.parseDepthUnitsFromString((String)value).getChar();
                if (well.getWellUnits() == displayUnits || displayUnits <= '\u0000' || !setWellHeaderUnits) continue;
                well.getHeader().setWellUnits(displayUnits);
                continue;
            }
            if (label.equalsIgnoreCase("TYPE")) {
                builder.type(SampleType.parseType((String)value));
                continue;
            }
            if (label.equalsIgnoreCase("SAMPLE ID")) {
                sampID = Integer.parseInt(value);
                Logger.getLogger(Sample.class.toString()).log(Level.FINE, "Parsing sample, ID=" + sampID);
                continue;
            }
            if (label.equalsIgnoreCase("ANALYST") && sepChar == '=') {
                donorAnalyst = value;
                if (db.getUser(donorAnalyst) != null) continue;
                db.getAddUserID(donorAnalyst);
                continue;
            }
            if (label.equalsIgnoreCase("GRID X") || label.equalsIgnoreCase("GRID Y")) continue;
            if (label.equalsIgnoreCase("LABEL")) {
                builder.label(value);
                continue;
            }
            if (label.equalsIgnoreCase("AGE")) {
                age = new SampleAge();
                age.age = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("AGE BELOW UNCONFORMITY")) {
                if (age == null) {
                    age = new SampleAge();
                }
                age.ageBelow = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("AGE ERROR PLUS")) {
                if (age == null) {
                    age = new SampleAge();
                }
                age.ageErrorPlus = Float.valueOf(Float.parseFloat(value));
                continue;
            }
            if (label.equalsIgnoreCase("AGE ERROR MINUS")) {
                if (age == null) {
                    age = new SampleAge();
                }
                age.ageErrorMinus = Float.valueOf(Float.parseFloat(value));
                continue;
            }
            if (label.equalsIgnoreCase("RATIO")) {
                if (age == null) {
                    age = new SampleAge();
                }
                age.ratio = Double.parseDouble(value);
                continue;
            }
            if (label.equalsIgnoreCase("LITHOLOGY CODE")) {
                if (lithCode != 0) {
                    Sample.addSampleLithComponent(lithdesc, liths, lithCode, lithPercent);
                    dataTypes.add(22);
                }
                lithCode = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("LITHOLOGY PERCENT")) {
                lithPercent = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("CREATED")) {
                try {
                    audit.created = SB.df.parse(value);
                }
                catch (ParseException parseException) {}
                continue;
            }
            if (!label.equalsIgnoreCase("MODIFIED") || sepChar != '=') continue;
            try {
                audit.modified = SB.df.parse(value);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (lithCode != 0) {
            Sample.addSampleLithComponent(lithdesc, liths, lithCode, lithPercent);
            dataTypes.add(22);
        }
        if (sampID <= 0) {
            throw new SBException("Sample from DEX file has no ID");
        }
        builder.audit(audit);
        Sample sample = well.getSample(builder);
        if (sample == null) {
            try {
                sample = well.addSample(builder, sampID, null);
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace", pe);
            }
        }
        if (sample.getSampID() != sampID) {
            System.out.println("WARNING: potential sample duplicates (ID " + sampID + ")");
            try {
                sample = well.addSample(builder, sampID, null);
                if (sample == null) {
                    throw new SBException("Can't add sample: " + sampID);
                }
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace", pe);
            }
            catch (SampleInsertException se) {
                sample = se.clash;
                dups.put(sampID, sample);
            }
        }
        sample.ages.put(0, age);
        for (SampleLithologyUnit u : liths) {
            sample.sampleLithology.add(u);
        }
        sample.donorAnalyst = donorAnalyst;
        sample.displayUnits = displayUnits;
        sample.status = NOTSTORED;
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            char sepChar = ((Character)section.sepChar.get(i)).charValue();
            if (label.equalsIgnoreCase("DISCIPLINE")) {
                if (discID != '\u0000') {
                    try {
                        void var53_72;
                        if (analyst == null) {
                            analyst = db.getUser().getAbr();
                        }
                        AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
                        Audit audit2 = new Audit(audit);
                        if (smpdtlModifier != null && smpdtlModified != null) {
                            Audit audit3 = new Audit(db.getAddUserID(smpdtlModifier), smpdtlModified, db.getAddUserID(smpdtlModifier), smpdtlModified);
                        }
                        Smpdtl smpdtl = new Smpdtl(db, sample, header, null, picker, source, notes, 0, 0, 0, weight, coarse, medium, fine, (Audit)var53_72, analysisType);
                        sample.insert(smpdtl);
                        dataTypes.add(SBdb.did2dtype(discID));
                        if (taxonDonorString != null) {
                            if (db.getTaxon(specID) == null) {
                                db.getTaxon(taxonDonorString, specID, true);
                            }
                            Situation situation = reworked ? Situation.RW : (caved ? Situation.CV : Situation.INSITU);
                            TaxonOcc.Builder tbuilder = new TaxonOcc.Builder(db, db.getTaxon(specID), situation, identType == 63, db.getSpeciesTypeService().getAddLegacySpeciesType((char)form, (char)growth, speciesType).specTypeID());
                            tbuilder.marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
                            tbuilder.preservation(preservation).colour(colour).comment(comment);
                            occs.add(tbuilder);
                            counts = 0;
                            fssCoarse = 0;
                            fssFine = 0;
                            reworked = false;
                            caved = false;
                            marker = false;
                            identType = 80;
                            form = 67;
                            growth = 65;
                            preservation = null;
                            comment = null;
                            colour = null;
                            subjAbund = null;
                            speciesType = null;
                            weight = 0.0f;
                        }
                        boolean hasSemiQuant = false;
                        for (TaxonOcc.Builder builder2 : occs) {
                            if (builder2.getSubAbund() != null && builder2.getSubAbund().length() > 0) {
                                hasSemiQuant = true;
                            }
                            smpdtl.insertOccurrence(builder2, well.getWellID(), false);
                        }
                        if (hasSemiQuant) {
                            int abnSchID = wellAbn[SBdb.did2i(discID)];
                            if (abnSchID == 0) {
                                for (int aID : wellAbn) {
                                    if (aID <= 0) continue;
                                    abnSchID = aID;
                                    break;
                                }
                            }
                            if (abnSchID > 0) {
                                header.setAbnScheme(abnSchID);
                            }
                        }
                        occs = new LinkedList();
                        taxonDonorString = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                discID = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("MODIFIED") && sepChar == ':') {
                try {
                    smpdtlModified = SB.df.parse(value);
                }
                catch (ParseException ex) {}
                continue;
            }
            if (label.equalsIgnoreCase("MODIFIER") && sepChar == ':') {
                smpdtlModifier = value;
                continue;
            }
            if (label.equalsIgnoreCase("ANALYST") && sepChar == ':') {
                analyst = value;
                continue;
            }
            if (label.equalsIgnoreCase("PICKER")) {
                picker = value;
                continue;
            }
            if (label.equalsIgnoreCase("SOURCE")) {
                source = value;
                continue;
            }
            if (label.equalsIgnoreCase("NOTES")) {
                notes = value;
                continue;
            }
            if (label.equalsIgnoreCase("COARSE FRACTION")) {
                coarse = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("MEDIUM FRACTION")) {
                medium = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("FINE FRACTION")) {
                fine = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("WEIGHT")) {
                weight = Float.parseFloat(value);
                continue;
            }
            if (label.equalsIgnoreCase("ANALYSIS")) {
                if (!value.equalsIgnoreCase("Barren")) continue;
                analysisType = Smpdtl.AnalysisType.BARREN;
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES") && sepChar == '=') {
                if (taxonDonorString != null) {
                    if (db.getTaxon(specID) == null) {
                        db.getTaxon(taxonDonorString, specID, true);
                    }
                    Situation situation = reworked ? Situation.RW : (caved ? Situation.CV : Situation.INSITU);
                    TaxonOcc.Builder builder3 = new TaxonOcc.Builder(db, db.getTaxon(specID), situation, identType == 63, db.getSpeciesTypeService().getAddLegacySpeciesType((char)form, (char)growth, speciesType).specTypeID());
                    builder3.marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
                    builder3.preservation(preservation).colour(colour).comment(comment);
                    occs.add(builder3);
                    counts = 0;
                    fssCoarse = 0;
                    fssFine = 0;
                    reworked = false;
                    caved = false;
                    marker = false;
                    identType = 80;
                    form = 67;
                    growth = 65;
                    preservation = null;
                    comment = null;
                    colour = null;
                    subjAbund = null;
                    speciesType = null;
                    analysisType = Smpdtl.AnalysisType.ANALYSED;
                }
                taxonDonorString = value;
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES ID")) {
                specID = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT")) {
                counts = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT COARSE")) {
                fssCoarse = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES COUNT FINE")) {
                fssFine = Integer.parseInt(value);
                continue;
            }
            if (label.equalsIgnoreCase("QUALIFIER")) {
                if (value.charAt(0) == 'R') {
                    reworked = true;
                }
                if (value.charAt(0) != '?') continue;
                identType = 63;
                continue;
            }
            if (label.equalsIgnoreCase("FLAG")) {
                if (value.charAt(0) == 'C') {
                    caved = true;
                }
                if (value.charAt(0) != 'M') continue;
                marker = true;
                continue;
            }
            if (label.equalsIgnoreCase("FORM")) {
                form = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("GROWTH STAGE")) {
                growth = value.charAt(0);
                continue;
            }
            if (label.equalsIgnoreCase("SPECIES TYPE")) {
                speciesType = value;
                continue;
            }
            if (label.equalsIgnoreCase("PRESERVATION")) {
                preservation = value;
                continue;
            }
            if (label.equalsIgnoreCase("SP COMMENT")) {
                comment = value;
                continue;
            }
            if (label.equalsIgnoreCase("COLOUR")) {
                colour = value;
                continue;
            }
            if (!label.equalsIgnoreCase("ABUNDANCE")) continue;
            subjAbund = value;
        }
        if (taxonDonorString != null) {
            if (db.getTaxon(specID) == null) {
                db.getTaxon(taxonDonorString, specID, true);
            }
            Situation situation = reworked ? Situation.RW : (caved ? Situation.CV : Situation.INSITU);
            TaxonOcc.Builder tbuilder = new TaxonOcc.Builder(db, db.getTaxon(specID), situation, identType == 63, db.getSpeciesTypeService().getAddLegacySpeciesType((char)form, (char)growth, speciesType).specTypeID());
            tbuilder.marker(marker).count(fssCoarse, counts, fssFine).subjAbund(subjAbund);
            tbuilder.preservation(preservation).colour(colour).comment(comment);
            occs.add(tbuilder);
        }
        if (discID != '\u0000') {
            try {
                if (analyst == null) {
                    analyst = db.getUser().getAbr();
                }
                AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
                Audit smpdtlAudit = new Audit(audit);
                if (smpdtlModifier != null && smpdtlModified != null) {
                    smpdtlAudit = new Audit(db.getAddUserID(smpdtlModifier), smpdtlModified, db.getAddUserID(smpdtlModifier), smpdtlModified);
                }
                Smpdtl smpdtl = new Smpdtl(db, sample, header, null, picker, source, notes, 0, 0, 0, weight, coarse, medium, fine, smpdtlAudit, analysisType);
                sample.insert(smpdtl);
                dataTypes.add(SBdb.did2dtype(discID));
                boolean hasSemiQuant = false;
                for (TaxonOcc.Builder builder4 : occs) {
                    if (builder4.getSubAbund() != null && builder4.getSubAbund().length() > 0) {
                        hasSemiQuant = true;
                    }
                    smpdtl.insertOccurrence(builder4, well.getWellID(), false);
                }
                if (hasSemiQuant) {
                    header.setAbnScheme(wellAbn[SBdb.did2i(discID)]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return sample;
    }

    private static void addSampleLithComponent(Lithdesc lithdesc, List<SampleLithologyUnit> liths, int lithCode, int lithPercent) throws SBException {
        boolean lithAlreadyExists = false;
        for (SampleLithologyUnit unit : liths) {
            if (!unit.getDescription().equals(lithdesc.getLithology(lithCode))) continue;
            unit.setPercent(unit.getPercent() + lithPercent);
            lithAlreadyExists = true;
            break;
        }
        if (!lithAlreadyExists) {
            SampleLithologyUnit lith = new SampleLithologyUnit(lithdesc.getLithology(lithCode), lithPercent);
            liths.add(lith);
        }
    }

    private SampleAge getAddAge(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age == null) {
            age = new SampleAge();
            this.ages.put(interpID, age);
        }
        return age;
    }

    public void copyLithology(SampleLithology rhs) {
        this.sampleLithology.getLithology().clear();
        for (SampleLithologyUnit lith : rhs.getLithology()) {
            this.sampleLithology.add(new SampleLithologyUnit(lith));
        }
    }

    @Deprecated
    public List<Smpdtl> getSmpdtls() {
        return this.analyses;
    }

    public List<Smpdtl> getAnalysesCopy() {
        return new LinkedList<Smpdtl>(this.analyses);
    }

    public Sample(SBdb SB2, char sectionType, Double topDepth, Double baseDepth, SampleType sampleType, String label, SampleLithologyUnit ... lithology) throws SBException {
        this.sbdb = SB2;
        this.sectionType = SectionType.getSectionType((char)sectionType);
        this.setDepth(topDepth, baseDepth, 'M');
        this.type = sampleType;
        this.textLabel = label;
        this.sampleLithology = new SampleLithology();
        this.sampID = 0;
        this.wellID = 0;
        if (lithology != null) {
            for (SampleLithologyUnit lu : lithology) {
                this.sampleLithology.add(lu);
            }
        }
        this.analyses.add(new Smpdtl(SB2, this, null, null, "PICK", "SOURCE", "Notes", 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, null, Smpdtl.AnalysisType.ANALYSED));
    }

    public static Sample load(SBdb sbdb, int wellID, int sampID, SectionType sectionType, Sample sample) throws SQLException, SBException {
        Builder builder;
        block13: {
            if (sample != null && (sample.sampID != sampID || sample.wellID != wellID || sample.sbdb != sbdb)) {
                throw new IllegalArgumentException("Illegal attempt to update sample");
            }
            builder = new Builder();
            String sql = "SELECT top_depth,base_depth,type,grid_x,grid_y,label," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("SAMPLES") + " WHERE well_id=" + wellID + " AND samp_id =" + sampID;
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                    BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (sbdb.getDBType() == DBType.SQLITE ? 1 : 0) != 0);
                    if (topDepth != null) {
                        builder.topDepth(topDepth.doubleValue());
                    }
                    if (baseDepth != null) {
                        builder.baseDepth(baseDepth.doubleValue());
                    }
                    builder.type(SampleType.parseType((String)rs.getString("type")));
                    builder.label(rs.getString("label"));
                    builder.audit(new Audit(rs));
                    break block13;
                }
                assert (false);
                Sample sample2 = null;
                return sample2;
            }
        }
        if (sample == null) {
            sample = builder.buildExisting(sbdb, wellID, sampID, sectionType);
        } else {
            sample.depth.top = builder.depth.top;
            sample.depth.base = builder.depth.base;
            sample.type = builder.type;
            sample.textLabel = builder.textLabel;
            sample.audit = builder.audit;
        }
        return sample;
    }

    void setSectionType(char newType) {
        SectionType newSectionType = SectionType.getSectionType((char)newType);
        if (this.sectionType != newSectionType) {
            if (this.depth != null) {
                if (this.depth.top != null) {
                    this.depth.top = -this.depth.top.doubleValue();
                }
                if (this.depth.base != null) {
                    this.depth.base = -this.depth.base.doubleValue();
                }
            }
            this.sectionType = newSectionType;
        }
    }

    public SampleType getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type == null) {
            return "";
        }
        return this.type.name();
    }

    Date getAgeUpdated(int interpID) {
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            return age.audit.updated;
        }
        return null;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    public void update(Well well, Sample sample) throws SQLException {
        if (!this.sbdb.isConnected() || sample.sbdb.isConnected()) {
            throw new IllegalStateException("Illegal attempt to update workspace sample");
        }
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("samples") + " SET label=" + SB.DBString((String)sample.textLabel) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE samp_id=" + this.sampID + " AND well_id=" + well.getWellID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.textLabel = sample.textLabel;
        this.audit = temp;
    }

    boolean update(Builder builder) throws SQLException, SBException {
        builder.validate();
        if (this.isEquivalent(builder) && (builder.textLabel == null && this.textLabel == null || builder.textLabel.equals(this.textLabel))) {
            return false;
        }
        Audit temp = new Audit(this.audit);
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "UPDATE " + this.sbdb.DBTableName("samples") + " SET top_depth=" + builder.depth.top + ",base_depth=" + builder.depth.base + ",type='" + builder.type.name() + "',label=" + SB.DBString((String)builder.textLabel) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE samp_id=" + this.sampID + " AND well_id=" + this.wellID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.setDepth(builder.depth.top, builder.depth.base, 'M');
        this.type = builder.type;
        this.textLabel = builder.textLabel;
        this.audit = temp;
        return true;
    }

    public String getLabel() {
        if (this.textLabel != null && this.textLabel.length() > 0) {
            return this.textLabel;
        }
        return "";
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public double getDepth() {
        return this.depth.getDepth(this.sbdb != null ? this.sbdb.useSampleTops() : false);
    }

    public double getDepth(char units) {
        return DepthUtils.convFromM((double)this.getDepth(), (char)units);
    }

    public boolean hasDepthRange() {
        if (this.depth == null) {
            return false;
        }
        return this.depth.top != null && this.depth.base != null && Math.abs(this.depth.top - this.depth.base) > (double)0.0029f;
    }

    public void setDepth(double d, char units, boolean useSampleTops, boolean useSectionType) {
        this.depth = useSampleTops ? new SampleDepth(DepthUtils.convToM((double)d, (char)units, (char)(useSectionType ? this.sectionType.getCharType() : (char)'W')), null) : new SampleDepth(null, DepthUtils.convToM((double)d, (char)units, (char)(useSectionType ? this.sectionType.getCharType() : (char)'W')));
    }

    public boolean hasTopDepth() {
        if (this.depth == null) {
            return false;
        }
        return this.depth.top != null;
    }

    public boolean hasBaseDepth() {
        if (this.depth == null) {
            return false;
        }
        return this.depth.base != null;
    }

    public double getTopDepth(char units) {
        if (this.depth == null) {
            throw new NullPointerException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.top == null) {
            return 0.0;
        }
        return DepthUtils.convFromM((double)this.depth.top, (char)units, (char)this.sectionType.getCharType());
    }

    public double getBaseDepth(char units) {
        if (this.depth == null) {
            throw new NullPointerException("Null depth requested for sample, ID no: " + this.sampID);
        }
        if (this.depth.base == null) {
            return 0.0;
        }
        return DepthUtils.convFromM((double)this.depth.base, (char)units, (char)this.sectionType.getCharType());
    }

    public Double getTopDepth() {
        if (this.depth == null) {
            throw new IllegalStateException("Null depth requested for sample, ID: " + this.sampID);
        }
        return this.depth.top;
    }

    public Double getBaseDepth() {
        if (this.depth == null) {
            throw new IllegalStateException("Null depth requested for sample, ID: " + this.sampID);
        }
        return this.depth.base;
    }

    public boolean hasDepth() {
        return this.depth != null;
    }

    public void setBaseDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(null, DepthUtils.convToM((double)d, (char)units, (char)this.sectionType.getCharType()));
        } else {
            this.depth.base = DepthUtils.convToM((double)d, (char)units, (char)this.sectionType.getCharType());
        }
        if (this.depth.top != null) {
            switch (this.sectionType) {
                case WELL: {
                    if (!(this.depth.top > this.depth.base)) break;
                    throw new SBException("Top depth larger than base depth: " + DepthUtils.convFromM((double)this.depth.top, (char)units) + " - " + DepthUtils.convFromM((double)this.depth.base, (char)units));
                }
                case OUTCROP: {
                    if (!(this.depth.base > this.depth.top)) break;
                    throw new SBException("Base depth larger than top depth: " + DepthUtils.convFromM((double)this.depth.top, (char)units) + " - " + DepthUtils.convFromM((double)this.depth.base, (char)units));
                }
            }
        }
        if (this.depth.base > 99999.0) {
            throw new SBException("Base depth set to unreasonably high value: " + DepthUtils.convFromM((double)this.depth.base, (char)units));
        }
    }

    void clearDepths() {
        this.depth = null;
    }

    public final void setTopDepth(double d, char units) throws SBException {
        if (this.depth == null) {
            this.depth = new SampleDepth(DepthUtils.convToM((double)d, (char)units, (char)this.sectionType.getCharType()), null);
        } else {
            this.depth.top = DepthUtils.convToM((double)d, (char)units, (char)this.sectionType.getCharType());
        }
        if (this.depth.base != null) {
            switch (this.sectionType) {
                case WELL: {
                    if (!(this.depth.top > this.depth.base)) break;
                    throw new SBException("Top depth larger than base depth");
                }
                case OUTCROP: {
                    if (!(this.depth.base > this.depth.top)) break;
                    throw new SBException("Base depth larger than top depth");
                }
            }
        }
        if (this.depth.top > 99999.0 || this.depth.top < -99999.0) {
            throw new SBException("Top depth set to unreasonably high value");
        }
    }

    public void setDepth(Double top, Double base, char units) throws SBException {
        if (top != null && base != null && top > base) {
            throw new SBException("Top depth larger than base depth in sample: " + top + " - " + base);
        }
        if (top != null && top > 99999.0 || base != null && base > 99999.0) {
            throw new SBException("Top or base depth unreasonably high value in sample: " + top + " - " + base);
        }
        this.depth = new SampleDepth(top == null ? null : Double.valueOf(DepthUtils.convToM((double)top, (char)units)), base == null ? null : Double.valueOf(DepthUtils.convToM((double)base, (char)units)));
    }

    int compareDepth(Sample s) {
        if (this.depth != null && s.depth != null) {
            int compareBase = this.depth.compareBase(s.depth.base);
            if (compareBase == 0) {
                return this.depth.compareTop(s.depth.top);
            }
            return compareBase;
        }
        return 1;
    }

    boolean compareDepth(Double topDepth, Double baseDepth) throws SBException {
        if (this.depth == null) {
            throw new SBException("Attempt to compare null sample depth for sample: " + String.valueOf(this));
        }
        if (topDepth == null && baseDepth == null) {
            throw new SBException("Attempt to compare top & base sample depths with sample: " + String.valueOf(this));
        }
        return this.depth.compareBase(baseDepth) == 0 && this.depth.compareTop(topDepth) == 0;
    }

    static Builder parseDepthTypeLabelString(String buff, char units, boolean decideUnits, boolean useSampleTops, SectionType sectionType, SampleType defaultSampleType) throws SBException, NumberFormatException {
        String strg;
        Builder builder = new Builder();
        StringTokenizer tok = new StringTokenizer(buff, " -");
        boolean hasTopDepth = false;
        boolean hasBaseDepth = false;
        boolean hasType = false;
        boolean hasUnits = false;
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (strg.equalsIgnoreCase("m")) {
                units = (char)77;
                hasUnits = true;
                continue;
            }
            if (!strg.equalsIgnoreCase("f") && !strg.equalsIgnoreCase("ft")) continue;
            units = (char)70;
            hasUnits = true;
        }
        if (!hasUnits && decideUnits) {
            if (buff.indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        tok = new StringTokenizer(buff, " -");
        while (tok.hasMoreTokens()) {
            strg = tok.nextToken();
            if (hasUnits && (strg.equalsIgnoreCase("m") || strg.equalsIgnoreCase("f") || strg.equalsIgnoreCase("ft"))) {
                hasUnits = false;
                continue;
            }
            if (Character.isDigit(strg.charAt(0))) {
                if (!hasTopDepth) {
                    builder.topDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(strg)), (char)units, (char)sectionType.getCharType()));
                    hasTopDepth = true;
                    continue;
                }
                if (!hasBaseDepth) {
                    builder.baseDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(strg)), (char)units, (char)sectionType.getCharType()));
                    hasBaseDepth = true;
                    continue;
                }
                if (!strg.toUpperCase().trim().equals("SAMPLE")) {
                    builder.label(strg);
                }
                if (!hasTopDepth) continue;
                hasBaseDepth = true;
                continue;
            }
            if (hasTopDepth) {
                hasBaseDepth = true;
            }
            if (!hasType) {
                Sample.parseType(strg, builder);
                if (builder.type != null) continue;
                builder.textLabel = builder.textLabel + strg;
                builder.type(defaultSampleType);
                continue;
            }
            if (strg.toUpperCase().trim().equals("SAMPLE")) continue;
            builder.textLabel = builder.textLabel + strg;
        }
        if (builder.type == null) {
            builder.type(defaultSampleType);
        }
        return builder;
    }

    private static void parseType(String buff, Builder builder) {
        builder.type(SampleType.parseType((String)buff));
        if (buff.startsWith("SWC")) {
            builder.label(builder.textLabel + buff.substring(3));
            assert (builder.type == SampleType.SC);
        } else if (buff.startsWith("SC")) {
            builder.label(builder.textLabel + buff.substring(2));
            assert (builder.type == SampleType.SC);
        }
    }

    public String getDonorSampleType() {
        return this.donorSampleType;
    }

    public static Builder parseDepthString(String buff, char units, boolean decideUnits, boolean useSampleTops) throws NumberFormatException {
        if (decideUnits) {
            if ((buff = buff.trim()).indexOf(109) >= 0 || buff.indexOf(77) >= 0) {
                units = (char)77;
            }
            if (buff.indexOf(102) >= 0 || buff.indexOf(70) >= 0) {
                units = (char)70;
            }
            if (buff.indexOf(39) >= 0) {
                units = (char)70;
            }
        }
        Builder builder = new Builder();
        StringTokenizer tok = new StringTokenizer(buff, " -");
        if (tok.countTokens() == 1) {
            String depthString = tok.nextToken();
            if (useSampleTops) {
                builder.topDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(depthString)), (char)units));
            } else {
                builder.baseDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(depthString)), (char)units));
            }
        } else {
            String topDepthString = tok.nextToken();
            String baseDepthString = tok.nextToken();
            try {
                builder.topDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(topDepthString)), (char)units));
                builder.baseDepth(DepthUtils.convToM((double)Double.parseDouble(Sample.stripUnitsFromDepth(baseDepthString)), (char)units));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return builder;
    }

    public static String stripUnitsFromDepth(String buff) {
        buff = ((String)buff).trim();
        if (((String)(buff = ((String)buff).toLowerCase())).indexOf(109) > 0) {
            buff = ((String)buff).substring(0, ((String)buff).indexOf(109));
        }
        if (((String)buff).indexOf(102) > 0) {
            buff = ((String)buff).substring(0, ((String)buff).indexOf(102));
        }
        if (((String)buff).indexOf(39) > 0) {
            buff = ((String)buff).substring(0, ((String)buff).indexOf(39));
        }
        for (int i = 0; i < ((String)buff).length(); ++i) {
            if (!Character.isDigit(((String)buff).charAt(i)) && ((String)buff).charAt(i) != '.' && ((String)buff).charAt(i) != ',') {
                System.out.println("Warning: truncating string: " + (String)buff);
                buff = ((String)buff).substring(0, i);
                continue;
            }
            if (((String)buff).charAt(i) != ',') continue;
            buff = ((String)buff).length() > i + 1 ? ((String)buff).substring(0, i) + ((String)buff).substring(i + 1) : ((String)buff).substring(0, i);
        }
        return buff;
    }

    @Override
    public int compareTo(Sample other) {
        return SampleComparator.compareSamples((SampleProperties)this, (SampleProperties)other);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        return this.sampID == other.sampID;
    }

    public void setType(SampleType type) throws SBException {
        if (type == null) {
            throw new SBException("Can't set sample type to null");
        }
        this.type = type;
    }

    void setLabel(String label) {
        if (label != null) {
            this.textLabel = label;
        }
    }

    void loadLithology(int wellID, Lithdesc lithdesc) throws SQLException, SBException {
        if (this.sampID > 0) {
            this.sampleLithology.getLithology().clear();
            String sql = "SELECT lith_id,percnt FROM " + this.sbdb.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int lithID = rs.getInt("lith_id");
                    SampleLithologyUnit lith = new SampleLithologyUnit(this.sbdb, this.sbdb.getLithdesc().getLithology(lithID), rs.getInt("percnt"));
                    this.sampleLithology.add(lith);
                }
            }
        }
    }

    public Color getDbStatus() {
        return null;
    }

    public String dbStatusString() {
        return null;
    }

    public Color getStatus() {
        if (this.status == UNKNOWN) {
            this.status = this.sampID != 0 ? STORED : NOTSTORED;
        }
        return this.status;
    }

    void loadAges(int wellID, int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        if (this.hasImportedAgeData) {
            return;
        }
        this.ages.remove(interpID);
        SampleAge age = new SampleAge(this.sbdb, this.sampID, wellID, interpID);
        if (age.hasData()) {
            this.ages.put(interpID, age);
        }
    }

    void fillTaxa(HashMap<Integer, Taxon> taxa, char discID, int analyst, int analyNo) {
        for (Smpdtl smpdtl : this.analyses) {
            if (discID != '\u0000' && discID != smpdtl.getDiscID() || analyst != 0 && smpdtl.getHeader().getAnalystUsrid() != analyst || analyNo != 0 && smpdtl.getHeader().getAnalyNumber() != analyNo) continue;
            smpdtl.fillTaxonList(taxa);
        }
    }

    public boolean hasDisciplineData(char discID) {
        for (Smpdtl smpdtl : this.analyses) {
            if (smpdtl.getDiscID() != discID) continue;
            return true;
        }
        return false;
    }

    String hasSemiQuantData(AnalystHeader hdr, String semiQuant) {
        for (Smpdtl smpdtl : this.analyses) {
            if (hdr != null && smpdtl.getHeader() != hdr) continue;
            semiQuant = smpdtl.hasSemiQuantData(semiQuant);
        }
        return semiQuant;
    }

    void delete(int wellID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID + " AND image_set_id > 0";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashSet<Integer> imgIDs = new HashSet<Integer>();
            while (rs.next()) {
                imgIDs.add(rs.getInt("image_set_id"));
            }
            OccurrenceImageDelete.deleteImageSetsWithTypeCheck(this.sbdb.getImageRecordService(), this.sbdb.getTaxonImageService(), this.sbdb.getWellService(), imgIDs, wellID);
            sql = "DELETE FROM " + this.sbdb.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("FAULTS") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public int getWellID() {
        return this.wellID;
    }

    public String getIGDOccurrences(int wellID) throws SQLException {
        Object strg = "";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int n;
            String table = this.sbdb.DBTableName("IGD");
            String sql = "SELECT count(d1.top_id) AS n FROM " + table + " d1 WHERE (d1.top_id=" + this.sampID + " OR d1.base_id=" + this.sampID + ") AND d1.well_id=" + wellID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Interval" + (n > 1 ? "s, " : ", ");
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.top_id) AS n FROM " + (table = this.sbdb.DBTableName("IGD_ENV")) + " d1 WHERE (d1.top_id=" + this.sampID + " OR d1.base_id=" + this.sampID + ") AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Env" + (n > 1 ? "s, " : ", ");
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.usamp_id) AS n FROM " + (table = this.sbdb.DBTableName("BCMMNTS")) + " d1 WHERE (d1.usamp_id=" + this.sampID + " OR d1.lsamp_id=" + this.sampID + ")  AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Comment" + (n > 1 ? "s, " : ", ");
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.samp_id) AS n FROM " + (table = this.sbdb.DBTableName("EVENTS")) + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Event" + (n > 1 ? "s, " : ", ");
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.samp_id) AS n FROM " + (table = this.sbdb.DBTableName("FAULTS")) + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Fault" + (n > 1 ? "s, " : ", ");
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.samp_id) AS n FROM " + (table = this.sbdb.DBTableName("SBSLITH")) + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Liths, ";
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.samp_id) AS n FROM " + (table = this.sbdb.DBTableName("SBSSR")) + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Age, ";
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT count(d1.samp_id) AS n FROM " + (table = this.sbdb.DBTableName("SQPICK")) + " d1 WHERE d1.samp_id=" + this.sampID + " AND d1.well_id=" + wellID))).next() && (n = rs.getInt("n")) > 0) {
                strg = (String)strg + n + " Sequence Pick" + (n > 1 ? "s" : "");
            }
            if (((String)(strg = ((String)strg).trim())).endsWith(",")) {
                strg = ((String)strg).substring(0, ((String)strg).length() - 1);
            }
        }
        return strg;
    }

    void replace(int wellID, int newSampID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("SBSLITH") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("SBSSR") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("SMPDTL") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("EVENTS") + " SET samp_id=" + newSampID + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET top_id=" + newSampID + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_ENV") + " SET base_id=" + newSampID + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("BCMMNTS") + " SET usamp_id=" + newSampID + " WHERE usamp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("BCMMNTS") + " SET lsamp_id=" + newSampID + " WHERE lsamp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("SAMPLES") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    int hasIGDdataInDB(int wellID) throws SQLException, SBException {
        if (this.sampID == 0) {
            return 0;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT igd_type FROM " + this.sbdb.DBTableName("IGD") + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = IGDIntervalZone.igdType2dType(rs.getInt("igd_type"));
                return n;
            }
            sql = "SELECT top_id FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE top_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 15;
                return n;
            }
            sql = "SELECT igd_type FROM " + this.sbdb.DBTableName("IGD") + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = IGDIntervalZone.igdType2dType(rs.getInt("igd_type"));
                return n;
            }
            sql = "SELECT base_id FROM " + this.sbdb.DBTableName("IGD_ENV") + " WHERE base_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 15;
                return n;
            }
            sql = "SELECT samp_id FROM " + this.sbdb.DBTableName("SQPICK") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 14;
                return n;
            }
            sql = "SELECT samp_id FROM " + this.sbdb.DBTableName("SBSLITH") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 21;
                return n;
            }
            sql = "SELECT disc_id FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE usamp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = SBdb.did2comType(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                return n;
            }
            sql = "SELECT disc_id FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE lsamp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = SBdb.did2comType(SB.getDBChar((ResultSet)rs, (String)"disc_id"));
                return n;
            }
            sql = "SELECT samp_id FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 16;
                return n;
            }
            sql = "SELECT samp_id FROM " + this.sbdb.DBTableName("SBSSR") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = 1;
                return n;
            }
        }
        return 0;
    }

    public Smpdtl getAnySmpdtl(char discID, String analyst) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || analyst.length() != 0 && !smpdtl.getAnalystAbr().equals(analyst)) continue;
            return smpdtl;
        }
        return null;
    }

    public Smpdtl getSmpdtl(char discID, String analyst, int suiteNo) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || analyst.length() != 0 && !smpdtl.getAnalystAbr().equals(analyst) || smpdtl.getAnalyNo() != suiteNo) continue;
            return smpdtl;
        }
        return null;
    }

    public LinkedList getAnalysts(int wellID, char discID) throws SQLException, SBException {
        LinkedList<String> analysts = new LinkedList<String>();
        if (this.sampID > 0) {
            String sql = "SELECT distinct analyst FROM " + this.sbdb.DBTableName("SMPDTL") + " WHERE samp_id=" + this.sampID + " AND well_id=" + wellID;
            if (discID > '\u0000') {
                sql = sql + " AND disc_id='" + discID + "'";
            }
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    analysts.add(rs.getString("analyst"));
                }
            }
        }
        for (Smpdtl dtl : this.analyses) {
            if (discID != '\u0000' && discID != dtl.getDiscID() || analysts.contains(dtl.getAnalystAbr())) continue;
            analysts.add(dtl.getAnalystAbr());
        }
        return analysts;
    }

    public Smpdtl getSmpdtl(int analyID) throws SBException {
        for (Smpdtl smpdtl : this.analyses) {
            if (smpdtl.getAnalyID() != analyID) continue;
            return smpdtl;
        }
        return null;
    }

    void removeSmpdtl(char discID) {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            this.analyses.remove(i);
            break;
        }
    }

    void removeSmpdtl(char discID, String analyst) throws SQLException, SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID || !smpdtl.getAnalystAbr().equals(analyst)) continue;
            this.analyses.remove(i);
            break;
        }
    }

    void updateLithologyStatus(List<Sample> list) {
        for (Sample sample : list) {
            if (this.compareTo(sample) <= 0) continue;
            this.getLithology().getStatus(sample.getLithology());
        }
    }

    Color updateStatus(Sample sample) throws SQLException, SBException {
        MergeStatus m = new MergeStatus(this.status);
        this.gridX = m.compareDoubleField("grid x", this.gridX, sample.gridX);
        this.gridY = m.compareDoubleField("grid y", this.gridY, sample.gridY);
        m.compareStringField("Label", this.textLabel, sample.textLabel, true);
        this.status = m.getStatus();
        return this.status;
    }

    boolean hasSpecies(Discipline discID, int specID) {
        for (Smpdtl smpdtl : this.analyses) {
            if (discID != null && smpdtl.getDiscID() != discID.getChar() || !smpdtl.hasSpecies(specID)) continue;
            return true;
        }
        return false;
    }

    boolean hasInSituSpecies(Discipline discID, int specID, char flag) {
        for (Smpdtl smpdtl : this.analyses) {
            if (discID != null && smpdtl.getDiscID() != discID.getChar() || !smpdtl.hasInSituSpecies(specID, flag)) continue;
            return true;
        }
        return false;
    }

    void writeSbugs(FileWriter out, char discID) throws IOException, SQLException, SBException {
        String blanks = "                        ";
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl smpdtl = this.analyses.get(i);
            if (smpdtl.getDiscID() != discID) continue;
            out.write("S ");
            if (Math.abs(this.depth.top) > (double)0.0029f) {
                out.write(this.padDouble(9, 3, this.depth.top));
            } else {
                out.write(this.padDouble(9, 3, this.depth.base));
            }
            out.write(blanks.substring(0, 6 - this.type.name().length()) + this.type.name() + "\t");
            out.write(this.padInt(6, (int)this.gridX) + "\t");
            out.write(this.padInt(6, (int)this.gridY) + "\t");
            if (Math.abs(this.depth.top) > (double)0.0029f && Math.abs(this.depth.top - this.depth.base) > (double)0.0029f) {
                out.write(this.padDouble(9, 3, this.depth.base));
            }
            out.write(10);
            smpdtl.writeSbugs(out);
        }
    }

    public String padFloat(int width, int precision, float number) {
        Object result = String.valueOf(number);
        if (((String)result).length() - ((String)result).indexOf(46) > precision) {
            result = ((String)result).substring(0, ((String)result).indexOf(46) + precision);
        }
        while (((String)result).length() < width) {
            result = " " + (String)result;
        }
        return result;
    }

    public String padDouble(int width, int precision, double number) {
        Object result = String.valueOf(number);
        if (((String)result).length() - ((String)result).indexOf(46) > precision) {
            result = ((String)result).substring(0, ((String)result).indexOf(46) + precision);
        }
        while (((String)result).length() < width) {
            result = " " + (String)result;
        }
        return result;
    }

    public String padInt(int width, int value) {
        Object result = String.valueOf(value);
        while (((String)result).length() < width) {
            result = " " + (String)result;
        }
        return result;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(this.displayUnits);
    }

    public String toString(char units) {
        return this.toString(units, true, true);
    }

    public String toString(char units, boolean showUnits, boolean showLabel) {
        return this.toString(units, showUnits, showLabel, true, true, null, null);
    }

    public String toString(char units, boolean showUnits, boolean showLabel, boolean pad) {
        Object string = this.toString(units, showUnits, showLabel, true, true, null, null);
        if (pad) {
            int dotIndex = ((String)string).indexOf(46);
            int spIndex = ((String)string).indexOf(32);
            int index = 0;
            for (index = dotIndex > 0 && spIndex > 0 ? Math.min(dotIndex, spIndex) : (dotIndex > 0 ? dotIndex : spIndex); index > 0 && index < 5; ++index) {
                string = " " + (String)string;
            }
        }
        return string;
    }

    public String toString(char units, boolean showUnits, boolean showLabel, boolean showType, boolean showRange, Double correctedDepthTop, Double correctedDepthBase) {
        return SampleStringFactory.toString((SampleProperties)this, (com.stratadata.util.depth.DepthUnits)com.stratadata.util.depth.DepthUnits.getUnits((char)units), (boolean)showUnits, (boolean)showLabel, (boolean)showType, (boolean)showRange, (Double)correctedDepthTop, (Double)correctedDepthBase);
    }

    public Smpdtl addDtl(int wellID, AnalystHeader hdr, Smpdtl.AnalysisType analysisType, String label, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SBException, SQLException {
        if (!this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "add analysis", "well", true));
        }
        for (Smpdtl d : this.analyses) {
            if (d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst ID: " + hdr.getAnalyID() + " for sample: " + this.toString(this.sbdb.getWell(wellID).getWellUnits()));
        }
        Smpdtl smpdtl = new Smpdtl(this.sbdb, this, hdr, label, picker, source, notes, analysisType, proximal, distal, fov, weight, coarse, medium, fine, wellID);
        this.insert(smpdtl);
        this.setChanged();
        return smpdtl;
    }

    public void addDtl(Smpdtl smpdtl) throws SBException {
        AnalystHeader hdr = smpdtl.getHeader();
        for (Smpdtl o : this.analyses) {
            Smpdtl d = o;
            if (d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst ID: " + hdr.getAnalyID() + " for sample: " + this.toString());
        }
        this.insert(smpdtl);
        this.setChanged();
    }

    public void deleteDtl(int wellID, int analyID, Smpdtl smpdtl) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected() && !this.sbdb.getWell(wellID).canWrite(this.sbdb, null)) {
            throw new SBException(this.sbdb.getWell(wellID).getDeniedReason(this.sbdb, "delete analysis", "well", true));
        }
        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
            if (occ.getImageSetID() <= 0) continue;
            new OccurrenceImageDelete(this.sbdb.getImageRecordService(), this.sbdb.getTaxonImageService(), this.sbdb.getWellService()).deleteOccurrenceImageSet(occ.getImageSetID(), wellID);
        }
        if (this.sbdb != null && this.sbdb.isConnected()) {
            Smpdtl.delete(this.sbdb, wellID, this.sampID, analyID);
        }
        this.analyses.remove((Object)smpdtl);
        this.setChanged();
    }

    void removeDtl(int analyID) {
        Iterator<Smpdtl> it = this.analyses.iterator();
        while (it.hasNext()) {
            Smpdtl dtl = it.next();
            if (analyID != dtl.getAnalyID()) continue;
            it.remove();
            this.setChanged();
            break;
        }
    }

    public Smpdtl getAnalysis(int analyID) {
        for (Smpdtl dtl : this.analyses) {
            if (dtl.getHeader().getAnalyID() != analyID) continue;
            return dtl;
        }
        return null;
    }

    public void updateDtl(int wellID, Smpdtl smpdtl, AnalystHeader hdr, Smpdtl.AnalysisType analysisType, boolean clearOccs, String label, String picker, String source, String notes, float weight, float coarse, float medium, float fine, int proximal, int distal, int fov) throws SBException, SQLException {
        for (Smpdtl d : this.analyses) {
            if (d == smpdtl || d.getAnalyID() != hdr.getAnalyID()) continue;
            throw new SBException("Duplicate analyst & discipline for sample: " + this.toString());
        }
        if (hdr != smpdtl.getHeader()) {
            this.setChanged();
        }
        smpdtl.update(wellID, hdr, analysisType, clearOccs, label, picker, source, notes, weight, coarse, medium, fine, proximal, distal, fov);
    }

    void insert(Smpdtl smpdtl) throws SBException {
        this.checkDtl(smpdtl);
        this.analyses.add(smpdtl);
    }

    void checkDtl(Smpdtl smpdtl) throws SBException {
        for (int i = 0; i < this.analyses.size(); ++i) {
            Smpdtl dtl = this.analyses.get(i);
            if (dtl.getAnalyID() != smpdtl.getAnalyID()) continue;
            throw new SBException("Duplicate analyst,discipline & no for sample: " + this.toString());
        }
    }

    private void store(Statement stmt, int wellID) throws SQLException {
        assert (this.sampID > 0);
        String sql = "INSERT INTO " + this.sbdb.DBTableName("SAMPLES") + " (well_id,samp_id,type," + Audit.sqlFieldString();
        Object suffix = "";
        if (this.depth.top != null) {
            sql = sql + ",top_depth";
            suffix = (String)suffix + "," + this.depth.top;
        }
        if (this.depth.base != null) {
            sql = sql + ",base_depth";
            suffix = (String)suffix + "," + this.depth.base;
        }
        if (!this.textLabel.isEmpty()) {
            sql = sql + ",label";
            suffix = (String)suffix + "," + SB.DBString((String)this.textLabel);
        }
        if (this.gridX > 0.0) {
            sql = sql + ",grid_x";
            suffix = (String)suffix + "," + this.gridX;
        }
        if (this.gridY > 0.0) {
            sql = sql + ",grid_y";
            suffix = (String)suffix + "," + this.gridY;
        }
        sql = sql + ") VALUES (" + wellID + "," + this.sampID + ",'" + this.type.name() + "'," + this.audit.sqlInsert(this.sbdb, stmt) + (String)suffix + ")";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.status = STORED;
    }

    public void updateLithology(List<SampleLithologyUnit> liths, int wellID) throws SQLException, SBException {
        this.sampleLithology.updateLithology(liths, wellID, this.sampID, this.sbdb);
        this.setChanged();
    }

    public void storeAge(int wellID, int interpID) throws SQLException {
        if (this.sampID == 0) {
            return;
        }
        SampleAge age = this.ages.get(interpID);
        if (age != null) {
            age.store(this.sbdb, this.sampID, wellID, interpID);
        }
        this.hasImportedAgeData = false;
    }

    LinkedList<Integer> writeXMLAges(BufferedWriter out, int indent, int interpID) throws IOException {
        LinkedList<Integer> userIDs = new LinkedList<Integer>();
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        SampleAge age = this.ages.get(interpID);
        if (age == null) {
            return userIDs;
        }
        out.write((String)ind + "<SampleID>" + this.sampID + "</SampleID>\n");
        out.write((String)ind + "<Age>" + age.age + "</Age>\n");
        if (Math.abs(age.ageBelow) > 1.0E-6) {
            out.write((String)ind + "<AgeBelowUnconformity>" + age.ageBelow + "</AgeBelowUnconformity>\n");
        }
        if ((double)Math.abs(age.ageErrorPlus.floatValue()) > 1.0E-4) {
            out.write((String)ind + "<AgeErrorPlus>" + age.ageErrorPlus + "</AgeErrorPlus>\n");
        }
        if ((double)Math.abs(age.ageErrorMinus.floatValue()) > 1.0E-4) {
            out.write((String)ind + "<AgeErrorMinus>" + age.ageErrorMinus + "</AgeErrorMinus>\n");
        }
        if (Math.abs(age.ratio) > 1.0E-4) {
            out.write((String)ind + "<Ratio>" + age.ratio + "</Ratio>\n");
        }
        if (this.ages.get(0) != null) {
            out.write((String)ind + "<AgeAudit>\n");
            out.write((String)ind);
            userIDs.addAll(age.audit.writeXML(out, indent + 3));
            out.write((String)ind + "</AgeAudit>\n");
        }
        return userIDs;
    }

    LinkedList<Integer> writeXML(BufferedWriter out, int indent, char units, List<File> files) throws IOException, SQLException, SBException {
        LinkedList<Integer> userIDs = new LinkedList();
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        if (this.sampID > 0) {
            out.write((String)ind + "<SampleID>" + this.sampID + "</SampleID>\n");
        }
        if (this.depth != null) {
            if ((this.depth.top == null || this.depth.base == null) && this.type != SampleType.CU) {
                out.write((String)ind + "<Depth>" + DepthUtils.convFromM((double)this.getDepth(), (char)units) + "</Depth>\n");
            } else {
                if (this.depth.top != null) {
                    out.write((String)ind + "<TopDepth>" + DepthUtils.convFromM((double)this.depth.top, (char)units) + "</TopDepth>\n");
                }
                if (this.depth.base != null) {
                    out.write((String)ind + "<BaseDepth>" + DepthUtils.convFromM((double)this.depth.base, (char)units) + "</BaseDepth>\n");
                }
            }
        }
        out.write((String)ind + "<Type>" + String.valueOf(this.type) + "</Type>\n");
        if (this.gridX != 0.0) {
            out.write((String)ind + "<GridX>" + this.gridX + "</GridX>\n");
        }
        if (this.gridY != 0.0) {
            out.write((String)ind + "<GridY>" + this.gridY + "</GridY>\n");
        }
        if (this.textLabel != null && this.textLabel.length() > 0) {
            out.write((String)ind + "<Label>" + SB.getXMLstring((String)this.textLabel) + "</Label>\n");
        }
        if (this.audit != null) {
            userIDs = this.audit.writeXML(out, indent);
        }
        for (int i = 0; i < this.sampleLithology.getLithology().size(); ++i) {
            out.write((String)ind + "<Lithology>\n");
            SampleLithologyUnit lith = this.sampleLithology.getLithology().get(i);
            lith.writeXML(out, indent + 3);
            out.write((String)ind + "</Lithology>\n");
        }
        for (Smpdtl smpdtl : this.analyses) {
            out.write((String)ind + "<Analysis>\n");
            userIDs.addAll(smpdtl.writeXML(out, indent + 3, files));
            out.write((String)ind + "</Analysis>\n");
        }
        return userIDs;
    }

    static void parseSample(SBdb db, Well well, char sectionType, Element xml, Set<Integer> dataTypes, ZipFile zip, Builder builder) throws ParseException, SBException, SQLException, SampleInsertException, SBPermissionException {
        Sample sample;
        String strg = xml.getChildTextNormalize("TopDepth");
        if (strg != null) {
            builder.topDepth(DepthUtils.convToM((double)Double.parseDouble(strg), (char)well.getWellUnits()));
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            builder.baseDepth(DepthUtils.convToM((double)Double.parseDouble(strg), (char)well.getWellUnits()));
        }
        if ((strg = xml.getChildTextNormalize("Depth")) != null) {
            builder.depth(db, DepthUtils.convToM((double)Double.parseDouble(strg), (char)well.getWellUnits()));
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            builder.type(SampleType.parseType((String)strg));
        }
        if ((strg = xml.getChildText("Label")) != null) {
            builder.label(strg);
        }
        if ((strg = xml.getChildTextNormalize("GridX")) != null) {
            System.out.println("didn't parse sample gridx " + strg);
        }
        if ((strg = xml.getChildTextNormalize("GridY")) != null) {
            System.out.println("didn't parse sample gridy " + strg);
        }
        int sampID = Integer.parseInt(xml.getChildTextNormalize("SampleID"));
        Element el = xml.getChild("Audit");
        if (el != null) {
            builder.audit(new Audit(db, el));
        } else {
            System.out.println("Warning: no audit info for sample: " + sampID);
        }
        try {
            sample = well.addSample(builder, sampID, null);
        }
        catch (SampleInsertException se) {
            System.out.println("Error inserting sample, looking for duplicate ... " + se.toString());
            sample = well.getSample(builder);
            if (sample == null) {
                throw se;
            }
            sample.addMergedID(sampID);
        }
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("Analysis"));
        while (it.hasNext()) {
            Smpdtl smpdtl = new Smpdtl(db, well, sample, (Element)it.next(), dataTypes, zip);
            dataTypes.add(SBdb.getDType(smpdtl.getDiscipline()));
            sample.analyses.add(smpdtl);
        }
        for (Smpdtl smpdtl : sample.analyses) {
            for (TaxonOcc taxonOcc : smpdtl.getOccurUnsorted()) {
                if (taxonOcc.getImageSetID() <= 0) continue;
                db.getTaxonImageService().addTaxonImageSet(taxonOcc.getSpecID(), (TaxonImageSet)new OccurrenceImage(taxonOcc.getImageSetID(), taxonOcc.getSpecID(), well, sample, smpdtl, false));
            }
        }
        IteratorIterable it1 = xml.getDescendants((Filter)new ElementFilter("Lithology"));
        while (it1.hasNext()) {
            sample.sampleLithology.add(new SampleLithologyUnit(db, (Element)it1.next()));
            dataTypes.add(22);
        }
        dataTypes.add(1);
    }

    public int getSampID() {
        return this.sampID;
    }

    public boolean hasMergedID(int ID) {
        return this.mergedIDs == null ? false : this.mergedIDs.contains(ID);
    }

    public void addMergedID(int ID) {
        if (this.mergedIDs == null) {
            this.mergedIDs = new HashSet();
        }
        this.mergedIDs.add(ID);
    }

    public void setAge(int interpID, Double age, Double ageBelow, Float ageErrorPlus, Float ageErrorMinus, Double ratio, int wellID) throws SQLException {
        SampleAge sampleAge = this.ages.get(interpID);
        if (age == null && ageBelow == null && ageErrorPlus == null && ageErrorMinus == null && ratio == null) {
            if (sampleAge != null) {
                this.ages.remove(interpID);
                sampleAge.delete(this.sbdb, this.sampID, wellID, interpID);
            }
            return;
        }
        if (sampleAge == null) {
            sampleAge = new SampleAge();
            this.ages.put(interpID, sampleAge);
        }
        sampleAge.age = age;
        sampleAge.ageBelow = ageBelow;
        sampleAge.ageErrorPlus = ageErrorPlus;
        sampleAge.ageErrorMinus = ageErrorMinus;
        sampleAge.ratio = ratio;
        this.setChanged();
    }

    public void updateAge(int wellID, double age, WellInterp interp) throws SQLException {
        SampleAge sage = this.ages.get(interp.interpID);
        if (sage == null) {
            sage = new SampleAge();
            this.ages.put(interp.interpID, sage);
        }
        sage.setAge(this.sbdb, this.sampID, wellID, interp.interpID, age);
        this.setChanged();
    }

    public void updateAgeBelow(int wellID, double age, WellInterp interp) throws SQLException {
        SampleAge sage = this.ages.get(interp.interpID);
        if (sage == null) {
            sage = new SampleAge();
            this.ages.put(interp.interpID, sage);
        }
        sage.setAgeBelow(this.sbdb, this.sampID, wellID, interp.interpID, age);
        this.setChanged();
    }

    void writeDEX(FileWriter out, Set dataTypes, boolean useAges, boolean useLithology, LinkedList taxa, char units, String eol, SimpleDateFormat df) throws IOException, SBException, SQLException {
        this.displayUnits = units;
        out.write("[SAMPLE " + this.toString().trim() + "]" + eol);
        if (this.depth != null) {
            if (this.depth.top != null) {
                out.write("Top Depth = " + SB.getDepthString((double)this.depth.top, (char)units, (int)3, (char)this.sectionType.getCharType()).trim() + eol);
            }
            if (this.depth.base != null) {
                out.write("Base Depth = " + SB.getDepthString((double)this.depth.base, (char)units, (int)3, (char)this.sectionType.getCharType()).trim() + eol);
            }
        }
        out.write("Type = " + String.valueOf(this.type) + eol);
        if (this.gridX > 0.0) {
            out.write("Grid X = " + this.gridX + eol);
        }
        if (this.gridY > 0.0) {
            out.write("Grid Y = " + this.gridY + eol);
        }
        if (this.audit.created != null) {
            out.write("Created = " + df.format(this.audit.created) + eol);
        }
        if (this.audit.modified != null) {
            out.write("Modified = " + df.format(this.audit.modified) + eol);
        }
        out.write("Sample id = " + this.getSampID() + eol);
        if (this.textLabel != null && this.textLabel.length() > 0) {
            out.write("Label = " + this.textLabel + eol);
        }
        SampleAge sampleAge = this.ages.get(0);
        if (useAges && sampleAge != null) {
            out.write("Age = " + sampleAge.age + eol);
            out.write("Age error plus : " + sampleAge.ageErrorPlus + eol);
            out.write("Age error minus : " + sampleAge.ageErrorMinus + eol);
        }
        if (useAges && sampleAge != null && sampleAge.ageBelow > 0.0) {
            out.write("Age below unconformity = " + sampleAge.ageBelow + eol);
        }
        if (useAges && sampleAge != null && sampleAge.ratio > 0.0) {
            out.write("Ratio : " + sampleAge.ratio + eol);
        }
        if (useLithology) {
            for (int i = 0; i < this.sampleLithology.getLithology().size(); ++i) {
                SampleLithologyUnit lith = this.sampleLithology.getLithology().get(i);
                out.write("Lithology = " + lith.getDescription().getDescr() + eol);
                out.write("  Lithology code : " + lith.getDescription().getLithID() + eol);
                out.write("  Lithology percent : " + lith.getPercent() + eol);
            }
        }
        Iterator it = dataTypes.iterator();
        while (it.hasNext()) {
            int columnType = (Integer)it.next();
            if (columnType != 8 && columnType != 2 && columnType != 6 && columnType != 4 || !this.hasDisciplineData(SBdb.dt2discID(columnType))) continue;
            out.write(eol);
            for (Smpdtl smpdtl : this.analyses) {
                if (smpdtl.getDiscID() != SBdb.dt2discID(columnType)) continue;
                smpdtl.writeDEX(out, taxa, df, eol);
            }
        }
        out.write(eol);
    }

    void removeAgeData(int interpID) {
        this.ages.remove(interpID);
    }

    public boolean hasAgeData(WellInterp interp) {
        return this.hasAgeData(interp.interpID);
    }

    public boolean hasAgeData(int interpID) {
        SampleAge age = this.ages.get(interpID);
        return age != null && age.hasData();
    }

    void mergeDEX(Sample sample) throws SBException, SQLException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to merge samples in database instance.");
        }
        if (!this.getSortEntry().equals(sample.getSortEntry())) {
            throw new SBException("Attempt to merge unequal.");
        }
        for (Smpdtl smpdtl : this.analyses) {
            for (Smpdtl mergeAnaly : sample.analyses) {
                if (smpdtl.getHeader() != mergeAnaly.getHeader()) continue;
                throw new SBException("Attempt to read/merge sample with duplicate analyses:  " + String.valueOf(this) + " : " + String.valueOf(smpdtl.getHeader()));
            }
        }
        for (Smpdtl mergeAnaly : sample.analyses) {
            mergeAnaly.setSample(this);
        }
        this.analyses.addAll(sample.analyses);
        this.textLabel = SB.mergeString((String)this.textLabel, (String)sample.textLabel, (boolean)true);
        if (this.sampleLithology.getLithology().isEmpty() && sample.getLithology().getLithology().size() > 0) {
            this.sampleLithology.lithology.addAll(sample.getLithology().getLithology());
        }
        if (this.ages.isEmpty() && sample.ages.size() > 0) {
            this.ages = sample.ages;
        }
        if (Math.abs(this.gridX) < (double)0.0029f && Math.abs(sample.gridX) > (double)0.0029f) {
            this.gridX = sample.gridX;
        }
        if (Math.abs(this.gridY) < (double)0.0029f && Math.abs(sample.gridY) > (double)0.0029f) {
            this.gridY = sample.gridY;
        }
    }

    public static void insert(List samples, Sample sample, char wellUnits) throws SampleInsertException {
        int i;
        for (i = 0; i < samples.size(); ++i) {
            Sample existing = (Sample)samples.get(i);
            int compare = sample.compareTo(existing);
            if (compare == 0) {
                if (sample.sampID > 0 && existing.sampID == 0) {
                    assert (false);
                } else {
                    if (sample.sampID > 0 && existing.sampID > 0 && sample.sampID != existing.sampID) break;
                    sample.displayUnits = wellUnits;
                    throw new SampleInsertException("Duplicate sample at depth: " + sample.toString() + ". Sample ID: " + sample.sampID, existing);
                }
            }
            if (compare < 0) break;
        }
        samples.add(i, sample);
    }

    public int hashCode() {
        return this.sampID;
    }

    public void deleteLithology(int wellID) throws SQLException {
        if (this.sbdb != null && this.sbdb.isConnected() && wellID > 0) {
            SampleLithology.clear(this.sbdb, wellID, this.sampID);
        }
        this.sampleLithology.lithology.clear();
    }

    public static String roundSampleDepth(Sample sample) throws SBException {
        return SB.floatString((double)sample.getDepth(), (int)sample.getType().getPrecision());
    }

    public static String roundSampleDepth(double corrDepth, SampleType type) {
        return SB.floatString((double)corrDepth, (int)type.getPrecision());
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for sample: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
        for (Smpdtl dtl : this.getSmpdtls()) {
            dtl.setAnalyst(analyst);
        }
    }

    public com.stratadata.model3.well.sample.Sample getDomainSample() {
        com.stratadata.model3.well.sample.Sample s = new com.stratadata.model3.well.sample.Sample((long)this.wellID, this.sampID);
        s.setSectionType(this.sectionType);
        s.setType(this.type);
        s.setDepth(this.getTopDepth(), this.getBaseDepth(), com.stratadata.util.depth.DepthUnits.M);
        s.setLabel(this.getLabel());
        return s;
    }

    public static final class Builder {
        private SampleDepth depth;
        private SampleType type;
        private String textLabel = "";
        private Audit audit;
        public final SampleLithology sampleLithology = new SampleLithology();

        private void validate() {
            if (this.depth == null || this.type == null) {
                throw new IllegalStateException("Illegal attempt to build Sample - no depth or type " + (String)(this.depth != null ? " at " + this.depth.getDepth(false) + "m" : ""));
            }
            if (this.depth.base == null && this.depth.top == null) {
                throw new IllegalStateException("Illegal attempt to build Sample: no depth");
            }
            if (this.depth.top != null && this.depth.base != null && this.depth.base < this.depth.top) {
                throw new IllegalStateException("Base depth is less than top depth in Sample builder at " + this.depth.top + "m /" + this.depth.base + "m");
            }
        }

        Sample buildExisting(SBdb sbdb, int wellID, int sampID, SectionType sectionType) {
            if (sampID <= 0) {
                throw new IllegalArgumentException("Attempt to build sample with illegal ID: " + sampID);
            }
            this.validate();
            return new Sample(this, sbdb, wellID, sampID, sectionType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Sample buildStore(SBdb sbdb, int wellID, SectionType sectionType, Statement reuseStatement) throws SQLException {
            this.validate();
            String sql = "SELECT max(samp_id) AS noof_samp FROM " + sbdb.DBTableName("samples") + " WHERE well_id=" + wellID;
            int sampID = 0;
            Statement stmt = reuseStatement;
            if (stmt == null) {
                stmt = sbdb.getDatabase().createStatement();
            }
            try {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next()) {
                    sampID = rs.getInt("noof_samp");
                }
                Sample sample = new Sample(this, sbdb, wellID, ++sampID, sectionType);
                sample.store(stmt, wellID);
                Sample sample2 = sample;
                return sample2;
            }
            finally {
                if (reuseStatement == null) {
                    stmt.close();
                }
            }
        }

        public static Builder copyOf(Sample sample) {
            return new Builder().type(sample.type).depth(sample.depth).label(sample.textLabel);
        }

        public Builder label(String label) {
            this.textLabel = label == null ? "" : label.trim();
            return this;
        }

        public Builder type(SampleType type) {
            this.type = type;
            return this;
        }

        public Builder depth(SBdb sbdb, double depth) {
            this.depth = new SampleDepth(sbdb.useSampleTops() ? Double.valueOf(depth) : null, sbdb.useSampleTops() ? null : Double.valueOf(depth));
            return this;
        }

        public Builder topDepth(Double topDepth) {
            if (this.depth == null) {
                this.depth = new SampleDepth();
            }
            this.depth.top = topDepth;
            return this;
        }

        public Builder baseDepth(Double baseDepth) {
            if (this.depth == null) {
                this.depth = new SampleDepth();
            }
            this.depth.base = baseDepth;
            return this;
        }

        Builder depth(SampleDepth depth) {
            this.depth = depth;
            return this;
        }

        Builder audit(Audit audit) {
            this.audit = audit;
            return this;
        }

        String getSortEntry(boolean useSampleTops) {
            return Sample.getSortEntry(this.depth.top, this.depth.base, this.type, useSampleTops);
        }

        double getDepth(boolean useSampleTops) {
            return this.depth.getDepth(useSampleTops);
        }
    }

    private static class SampleDepth {
        Double top;
        Double base;

        SampleDepth() {
        }

        SampleDepth(Double top, Double base) {
            this.top = top;
            this.base = base;
        }

        private int compareBase(Double base) {
            if (this.base == null && base == null) {
                return 0;
            }
            if (this.base == null) {
                return -1;
            }
            if (base == null) {
                return 1;
            }
            if (Math.abs(this.base - base) < (double)0.0029f) {
                return 0;
            }
            return this.base < base ? -1 : 1;
        }

        private int compareTop(Double top) {
            if (this.top == null || top == null) {
                return 0;
            }
            if (Math.abs(this.top - top) < (double)0.0029f) {
                return 0;
            }
            return this.top < top ? -1 : 1;
        }

        double getDepth(boolean useSampleTops) {
            if (useSampleTops) {
                if (this.top != null) {
                    return this.top;
                }
                if (this.base != null) {
                    return this.base;
                }
            } else {
                if (this.base != null) {
                    return this.base;
                }
                if (this.top != null) {
                    return this.top;
                }
            }
            return 0.0;
        }
    }

    public static class CorrectedSample
    implements Comparable {
        public final double correctedDepth;
        public final Sample sample;

        public CorrectedSample(double correctedDepth, Sample sample) {
            this.correctedDepth = correctedDepth;
            this.sample = sample;
        }

        public int compareTo(Object o) {
            if (o instanceof CorrectedSample) {
                CorrectedSample cs = (CorrectedSample)o;
                int depth = (int)(this.correctedDepth * 1000.0);
                int comp = (int)(cs.correctedDepth * 1000.0);
                return depth - comp;
            }
            return -1;
        }
    }
}

