/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import model3.Audit;
import model3.Lithology;
import model3.SBdb;
import org.jdom2.Element;
import util.SBException;

public class SampleLithologyUnit
implements Comparable<SampleLithologyUnit> {
    SBdb SB;
    private Lithology description;
    private int percent;
    private Audit audit = new Audit();

    SampleLithologyUnit(SBdb SB2, Lithology descr, int percent) {
        this.SB = SB2;
        this.description = descr;
        this.percent = percent;
    }

    public SampleLithologyUnit(Lithology descr, int percent) {
        this.description = descr;
        this.percent = percent;
    }

    public SampleLithologyUnit(SampleLithologyUnit rhs) {
        this.description = rhs.description;
        this.percent = rhs.percent;
        this.audit = rhs.audit;
    }

    public SampleLithologyUnit(SBdb SB2, Element xml) throws SBException, SQLException {
        this.SB = SB2;
        String codeStrg = xml.getChildTextNormalize("Code");
        if (codeStrg == null) {
            throw new SBException("Attempt to get lithology for unrecognised code: " + codeStrg);
        }
        int code = Integer.parseInt(codeStrg);
        this.description = this.SB.getLithdesc().getLithology(code);
        if (this.description == null) {
            throw new SBException("Attempt to get lithology for unrecognised code: " + code);
        }
        String percentStrg = xml.getChildTextNormalize("Percent");
        this.percent = Integer.parseInt(percentStrg);
    }

    public void setPercent(int percent) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.percent = percent;
    }

    public void setDescription(Lithology descr) throws SBException {
        if (this.SB != null) {
            throw new SBException("Attempt to set sample lithology");
        }
        this.description = descr;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write((String)ind + "<Description>" + this.description.getDescr() + "</Description>\n");
        out.write((String)ind + "<Code>" + this.description.getLithID() + "</Code>\n");
        out.write((String)ind + "<Percent>" + this.percent + "</Percent>\n");
    }

    void parseXML(String chars, String element) throws ParseException, SQLException {
    }

    public Lithology getDescription() {
        return this.description;
    }

    public int getPercent() {
        return this.percent;
    }

    Audit getAudit() {
        return this.audit;
    }

    @Override
    public int compareTo(SampleLithologyUnit o) {
        Integer s2;
        int val;
        Integer s1 = this.description.getSortOrder();
        if (o.getDescription() == null) {
            System.out.println("Lithology type record null for: " + String.valueOf(o));
        }
        if ((val = s1.compareTo(s2 = Integer.valueOf(o.getDescription().getSortOrder()))) == 0) {
            Integer p1 = this.percent;
            Integer p2 = o.getPercent();
            val = p1.compareTo(p2);
        }
        return val;
    }
}

