/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.taxon.SynonymService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import model3.ConnectionProvider;
import model3.SBdb;
import model3.SynonymScheme;
import model3.exception.SuppressedSQLException;
import util.SBException;
import util.SBPermissionException;

public class SynSch
extends HashMap<Integer, SynonymScheme>
implements SynonymService {
    public static final String DEFAULT_TEXT = "Default scheme";
    private final ConnectionProvider conn;

    public SynSch(ConnectionProvider conn) {
        this.conn = conn;
    }

    public Optional<Taxon> getPreferredTerm(int synSchID, int specID, TaxonService taxonService) {
        if (synSchID > 0) {
            SynonymScheme scheme = (SynonymScheme)((Object)this.get(synSchID));
            if (scheme == null) {
                throw new IllegalStateException("Synonym scheme ID: " + synSchID + " unknown in SBdb.getPreferredTerm");
            }
            try {
                int prefID = scheme.getPref(specID);
                if (prefID > 0) {
                    return taxonService.findTaxon(prefID);
                }
            }
            catch (SQLException sqlException) {
                throw SuppressedSQLException.withoutRollback(sqlException);
            }
        }
        return Optional.empty();
    }

    public List<Taxon> getSynonyms(int synSchID, int specID, TaxonService taxonService) {
        SynonymScheme scheme = (SynonymScheme)((Object)this.get(synSchID));
        if (scheme == null) {
            throw new IllegalStateException("Synonym scheme ID: " + synSchID + " unknown in SBdb.getPreferredTerm");
        }
        try {
            return scheme.getSyn(specID).stream().map(synID -> taxonService.findTaxon(synID.intValue())).flatMap(Optional::stream).toList();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withoutRollback(ex);
        }
    }

    static SynSch initSchemeHeaders(SBdb sbdb) throws SQLException {
        SynSch schemes = new SynSch(sbdb);
        schemes.put(1, new SynonymScheme(sbdb, 1, DEFAULT_TEXT));
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "SELECT sch_id,name FROM " + sbdb.DBTableName("SYNSCH");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("sch_id");
                String name = rs.getString("name");
                if (schemes.get(ID) == null) {
                    schemes.put(ID, new SynonymScheme(sbdb, ID, name));
                    continue;
                }
                if (ID == 1) continue;
                System.out.println("Duplicate Synonym Scheme: " + ID + "," + name);
            }
        }
        return schemes;
    }

    public void addSynonym(int synSchID, int specID, int preferredSpecID) {
        ((SynonymScheme)((Object)this.get(synSchID))).addSyn(specID, preferredSpecID);
    }

    public void removeSpecies(int specID) {
        for (SynonymScheme sSch : this.values()) {
            sSch.removeRefs(specID);
        }
    }

    public void updateSynonymy(int synSchID, int preferredSpecID, List<Integer> juniorSynonyms, TaxonService taxonService) {
        if (synSchID == 0) {
            return;
        }
        SynonymScheme scheme = (SynonymScheme)((Object)this.get(synSchID));
        if (scheme == null) {
            throw new IllegalStateException("Synonym scheme ID: " + synSchID + " unknown");
        }
        this.getPreferredTerm(synSchID, preferredSpecID, taxonService).ifPresent(prefOfPref -> {
            if (!juniorSynonyms.contains(prefOfPref.getSpecID())) {
                System.out.println("Previous preferred term: " + String.valueOf(prefOfPref) + " is not listed as a junior synonym of: " + preferredSpecID);
            }
            try {
                scheme.deleteSyn(prefOfPref.getSpecID());
            }
            catch (SBPermissionException ex) {
                throw new IllegalStateException(ex.getMessage());
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withRollback("", e, this.conn);
            }
        });
        try {
            scheme.updateSyn(preferredSpecID, juniorSynonyms);
            this.conn.commit();
        }
        catch (SBException | SBPermissionException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withRollback("Error updating synonymy", sql, this.conn);
        }
    }

    public String getSchemeName(int synSchID) {
        return ((SynonymScheme)((Object)this.get(synSchID))).getName();
    }

    public Map<Integer, Integer> getSchemeEntries(int synSchID) {
        try {
            return ((SynonymScheme)((Object)this.get(synSchID))).getSynonyms();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withoutRollback(ex);
        }
    }

    public List<Integer> getAllSchemeIDs() {
        return new LinkedList<Integer>(this.keySet());
    }
}

