/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.db.DBType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import model3.Audit;
import model3.SBdb;
import model3.WellDocument;
import org.apache.commons.lang3.StringUtils;

public class WellDocumentService {
    private final SBdb sbdb;
    private static final Comparator<WellDocument> COMPARE_WELL_NAME = Comparator.comparing(doc -> doc.getPrimaryWellName().toLowerCase(Locale.UK));
    private static final Comparator<WellDocument> COMPARE_DOC_NAME = Comparator.comparing(doc -> doc.getDescr().toLowerCase(Locale.UK));

    public WellDocumentService(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    public List<WellDocument> getDocumentList(int wellID) throws SQLException {
        ArrayList<WellDocument> docs = new ArrayList<WellDocument>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT wd.doc_id, wd.well_id, wd.interp_id, wd.descrip, wd.doc_path, wd.doc, " + Audit.sqlFieldString("wd") + ", i.descrip as interp_descrip, w.well_name as well_name FROM " + this.sbdb.DBTableName("WELL_DOCS") + " wd INNER JOIN " + this.sbdb.DBTableName("wells") + " w ON wd.well_id = w.well_id LEFT JOIN " + this.sbdb.DBTableName("interp") + " i ON wd.interp_id = i.interp_id WHERE wd.well_id=" + wellID + " OR wd.doc_id IN(SELECT doc_id from " + this.sbdb.DBTableName("DOC_REFS") + " WHERE well_id=" + wellID + ")";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int docID = rs.getInt("doc_id");
                int primaryWellID = rs.getInt("well_id");
                Integer interpID = rs.getInt("interp_id");
                if (rs.wasNull()) {
                    interpID = null;
                }
                String descr = rs.getString("descrip");
                String path = rs.getString("doc_path");
                Audit audit = new Audit(rs, "wd");
                WellDocument doc = new WellDocument(docID, primaryWellID, interpID, descr, path, audit);
                doc.setPrimaryWellName(rs.getString("well_name"));
                doc.setInterpDescr(rs.getString("interp_descrip"));
                if (this.sbdb.getDBType() == DBType.POSTGRESQL) {
                    docData = rs.getBytes("doc");
                    doc.setDocLength(((byte[])docData).length);
                } else {
                    docData = rs.getBlob("doc");
                    doc.setDocLength(docData.length());
                }
                docs.add(doc);
            }
        }
        Comparator isPrimaryWell = (o1, o2) -> {
            if (o1.getPrimaryWellID() == wellID && o2.getPrimaryWellID() == wellID) {
                return 0;
            }
            if (o1.getPrimaryWellID() == wellID) {
                return -1;
            }
            if (o2.getPrimaryWellID() == wellID) {
                return 1;
            }
            return 0;
        };
        docs.sort(isPrimaryWell.thenComparing(COMPARE_WELL_NAME).thenComparing(COMPARE_DOC_NAME));
        return docs;
    }

    public File getDocumentContent(int docID) throws SQLException, IOException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT doc, doc_path FROM " + this.sbdb.DBTableName("WELL_DOCS") + " WHERE doc_id = " + docID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                String extension;
                Object fileType = ".pdf";
                String docPath = rs.getString("doc_path");
                if (!StringUtils.isEmpty((CharSequence)docPath) & docPath.length() > 4 && docPath.contains(".") && (extension = docPath.substring(docPath.lastIndexOf(".") + 1)).length() < 5) {
                    fileType = "." + extension;
                }
                InputStream inputStream = rs.getBinaryStream("doc");
                Path tempFilename = Files.createTempFile(null, (String)fileType, new FileAttribute[0]);
                File tempFile = new File(tempFilename.toString());
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                tempFile.deleteOnExit();
                File file = tempFile;
                return file;
            }
        }
        return null;
    }

    public void deleteDocument(int docID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("DOC_REFS") + " WHERE doc_id = " + docID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("WELL_DOCS") + " WHERE doc_id = " + docID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public void storeDocument(int wellId, Integer interpId, String docDescrip, String docPath, FileInputStream pdfFile) throws SQLException {
        int docId = this.sbdb.nextControl("well_docs", "doc_id");
        String sql = "INSERT INTO " + this.sbdb.DBTableName("WELL_DOCS") + " (doc_id, well_id, interp_id, descrip, doc_path, doc, created, creator) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement pstmt = this.sbdb.getDatabase().prepareStatement(sql);){
            pstmt.setInt(1, docId);
            pstmt.setInt(2, wellId);
            if (interpId != null) {
                pstmt.setInt(3, interpId);
            } else {
                pstmt.setNull(3, 0);
            }
            pstmt.setString(4, docDescrip);
            pstmt.setString(5, docPath);
            pstmt.setBinaryStream(6, pdfFile);
            pstmt.setDate(7, new Date(System.currentTimeMillis()));
            pstmt.setInt(8, this.sbdb.getUserID());
            pstmt.execute();
        }
    }

    public void storeReferences(int docID, Set<Integer> wellIDs) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("DOC_REFS") + " WHERE DOC_ID=" + docID;
        try (PreparedStatement pstmt = this.sbdb.getDatabase().prepareStatement(sql);){
            pstmt.execute();
        }
        if (wellIDs.isEmpty()) {
            return;
        }
        sql = "INSERT INTO " + this.sbdb.DBTableName("DOC_REFS") + " (doc_id, well_id) VALUES (?, ?)";
        pstmt = this.sbdb.getDatabase().prepareStatement(sql);
        try {
            pstmt.setInt(1, docID);
            for (int wellID : wellIDs) {
                pstmt.setInt(2, wellID);
                pstmt.execute();
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public Set<Integer> getReferencedWellIDs(int docID) throws SQLException {
        HashSet<Integer> refs = new HashSet<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT WELL_ID FROM " + this.sbdb.DBTableName("DOC_REFS") + " WHERE DOC_ID=" + docID;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                refs.add(rs.getInt("WELL_ID"));
            }
            HashSet<Integer> hashSet = refs;
            return hashSet;
        }
    }
}

