/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.depth.DepthUnits;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleInsertException;
import model3.Surface;
import model3.WellHeader;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellLstratBujakXLS {
    Set dataTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellLstratBujakXLS(SBdb ws, File file, char units, Set dataTypes) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        String unassignesSeqSchemeName;
        IGDScheme seqScheme;
        String unassignedSchemeName = IGDInterval.getIGDName(2) + " (undefined)";
        IGDScheme scheme = ws.getIGDScheme(unassignedSchemeName, 2);
        if (scheme == null) {
            scheme = ws.addIGDScheme(2, unassignedSchemeName, "");
        }
        if ((seqScheme = ws.getIGDScheme(unassignesSeqSchemeName = IGDInterval.getIGDName(10) + " (undefined)", 10)) == null) {
            seqScheme = ws.addIGDScheme(10, unassignesSeqSchemeName, "");
        }
        GridReader in = null;
        boolean dataRows = false;
        HashMap<Integer, WsWell> wellColumnMap = new HashMap<Integer, WsWell>();
        WsWell well = null;
        boolean firstRow = true;
        boolean hasDescriptorColumn = false;
        try {
            in = GridReader.getGridReader((String)file.getPath(), null);
            block17: while (in.nextRow()) {
                String cell;
                if (!dataRows) {
                    cell = in.getNextCell();
                    int column = 0;
                    if (cell.isEmpty()) {
                        while ((cell = in.getNextCell()) != null) {
                            ++column;
                            if (cell.isEmpty()) continue;
                        }
                    }
                    if (firstRow && column > 1) {
                        hasDescriptorColumn = true;
                    }
                    if (firstRow) {
                        if (cell.equalsIgnoreCase("Well Name") || cell.equalsIgnoreCase("Well")) {
                            cell = in.getNextCell();
                        }
                        String wellName = "";
                        column = 0;
                        do {
                            ++column;
                            if (cell.isEmpty()) continue;
                            if (cell.equalsIgnoreCase(wellName)) {
                                wellColumnMap.put(column, well);
                                continue;
                            }
                            wellName = cell;
                            well = ws.addWellToWorkspace(0, null);
                            WellHeader wh = well.getHeader();
                            wh.setWellUnits(units);
                            wh.setCountry("UNITED KINGDOM");
                            wh.setDatum(WellDatum.ROTARY_TABLE.getDbInt());
                            well.loadInterps();
                            wh.setWellName(wellName);
                            wellColumnMap.put(column, well);
                        } while ((cell = in.getNextCell()) != null);
                        firstRow = false;
                        continue;
                    }
                    if (cell.equalsIgnoreCase("Stratigraphic Unit")) {
                        dataRows = true;
                        continue;
                    }
                    if (hasDescriptorColumn) {
                        cell = in.getNextCell();
                    }
                    this.parseHeader(cell, in, wellColumnMap, units);
                    continue;
                }
                cell = in.getNextCell();
                if (cell == null || cell.isEmpty()) continue;
                int hier = 0;
                if (hasDescriptorColumn) {
                    switch (cell) {
                        case "SEQUENCE": {
                            break;
                        }
                        case "EVENT": {
                            continue block17;
                        }
                        case "GROUP": {
                            hier = 1;
                            break;
                        }
                        case "FORMATION": {
                            hier = 2;
                            break;
                        }
                        case "BED": {
                            hier = 4;
                        }
                    }
                    if ((cell = in.getNextCell()) == null || cell.isEmpty()) continue;
                }
                this.parseIntervals(ws, scheme, seqScheme, cell, hier, in, wellColumnMap);
            }
            dataTypes.add(1);
            dataTypes.add(12);
            dataTypes.add(14);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void parseHeader(String headerField, GridReader in, HashMap<Integer, WsWell> wellColumnMap, char units) throws GridReaderException, SBException {
        String cell;
        int column = 0;
        while ((cell = in.getNextCell()) != null) {
            ++column;
            if (cell.isEmpty()) continue;
            WellHeader wellHeader = wellColumnMap.get(column).getHeader();
            com.stratadata.model3.well.WellHeader wh = wellHeader.getWellHeaderCopy();
            switch (headerField) {
                case "OPERATOR": {
                    wh.setOperator(cell);
                    break;
                }
                case "LOCATION": {
                    wh.setField(cell);
                    break;
                }
                case "KB": {
                    wh.setRotaryTableElevation(Double.valueOf(DepthUtils.parseDepthString((String)cell, (char)units)));
                    if (cell.contains("ft")) {
                        wh.setUnits(DepthUnits.F);
                    }
                    if (!cell.contains("m")) break;
                    wh.setUnits(DepthUnits.M);
                    break;
                }
                case "TD": {
                    wh.setTerminalDepth(DepthUtils.parseDepthString((String)cell, (char)units));
                    if (cell.contains("ft")) {
                        wh.setUnits(DepthUnits.F);
                    }
                    if (!cell.contains("m")) break;
                    wh.setUnits(DepthUnits.M);
                }
            }
            try {
                wellColumnMap.get(column).update(wh);
            }
            catch (Exception e) {
                throw new SBException("Error updating well header", (Throwable)e);
            }
        }
    }

    private void parseIntervals(SBdb ws, IGDScheme scheme, IGDScheme seqScheme, String name, int hier, GridReader in, HashMap<Integer, WsWell> wellColumnMap) throws GridReaderException, SBException, SQLException, SampleInsertException, SBPermissionException {
        String cell;
        int column = 0;
        WsWell lastWell = null;
        double top = 0.0;
        System.out.println("Parsing: " + name);
        while ((cell = in.getNextCell()) != null) {
            WsWell well;
            block21: {
                ++column;
                if (cell.isEmpty()) continue;
                well = wellColumnMap.get(column);
                if (well == null) {
                    throw new SBException("Invalid well for column: " + column + " in parseIntervals");
                }
                if (well == lastWell) {
                    double base = DepthUtils.parseDepthString((String)cell, (char)well.getWellUnits());
                    if (base > (double)0.0029f) {
                        Sample baseSample;
                        System.out.println("Well: " + String.valueOf(well));
                        WellInterp wellInterp = well.getInterp(0);
                        Sample topSample = well.getSample(top, "LOG", true);
                        if (topSample == null) {
                            topSample = well.addSample(top, SampleType.LOG, null);
                        }
                        if ((baseSample = well.getSample(base, "LOG", true)) == null) {
                            baseSample = well.addSample(base, SampleType.LOG, null);
                        }
                        boolean addSQPick = false;
                        if (hier == 0) {
                            hier = 2;
                            if (name.toUpperCase().contains("SEQUENCE")) {
                                addSQPick = true;
                            } else if (name.toUpperCase().contains(" GP")) {
                                hier = 1;
                            } else if (name.toUpperCase().contains(" FM")) {
                                hier = 2;
                            } else if (name.toUpperCase().contains(" SST")) {
                                hier = 4;
                            } else if (name.toUpperCase().contains(" TUFF")) {
                                hier = 4;
                            }
                        }
                        try {
                            if (addSQPick) {
                                Surface surface = seqScheme.getSurface(name = name.replace("Sequence", "").replace("SEQUENCE", "").trim(), null);
                                if (surface == null) {
                                    surface = seqScheme.addSurface(new Surface.Builder(ws).name(name).type(Surface.SurfaceType.parseType(name, Surface.SurfaceType.MFS)));
                                }
                                SQPick.Builder pickBuilder = new SQPick.Builder(ws, surface, topSample, 3);
                                wellInterp.addSQPick(well, pickBuilder);
                                break block21;
                            }
                            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(ws, 2, topSample, baseSample, hier, scheme.getSchID()).uppInf(name).topBnd(3).baseBnd(3);
                            wellInterp.addZone(builder, well);
                        }
                        catch (InvalidFieldException ex) {
                            System.out.println("Can't insert: " + name + " into well: " + well.toString());
                        }
                    }
                } else {
                    top = DepthUtils.parseDepthString((String)cell, (char)well.getWellUnits());
                }
            }
            lastWell = well;
        }
    }
}

