/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.project.WellListRepository;
import com.stratadata.model3.well.WellGeoSort;
import com.stratadata.model3.well.WellRepository;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.DateUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import javax.swing.DefaultComboBoxModel;
import model3.Audit;
import model3.CoOccurrence;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellHeader;
import model3.WsWell;
import model3.exception.SuppressedSQLException;
import model3.project.Project;
import model3.project.WellList;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class WellManager
implements WellRepository<Well>,
WellListRepository<WellList> {
    private final SBdb sbdb;
    private final HashMap<Integer, Well> wells = new HashMap();
    private final LoadedTreeMap<Integer, WellList> wellLists = new LoadedTreeMap();
    private final LoadedTreeMap<Integer, Project> projects = new LoadedTreeMap();
    private static final Logger LOGGER = Logger.getLogger(WellManager.class.getName());
    private boolean projectsLoaded = false;

    WellManager(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    Iterator<Well> getWellIterator() {
        return this.wells.values().iterator();
    }

    public static void sortWells(List<Well> list, WellGeoSort direction) {
        LinkedList<Well> removed = new LinkedList<Well>();
        Iterator<Well> it = list.iterator();
        while (it.hasNext()) {
            Well w = it.next();
            if (w.getHeader().getLat_dec() != null && w.getHeader().getLong_dec() != null) continue;
            it.remove();
            removed.add(w);
        }
        if (list.size() < 2) {
            list.addAll(removed);
            return;
        }
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int i = 1; i < list.size(); ++i) {
                Well w1 = list.get(i - 1);
                Well w2 = list.get(i);
                switch (direction) {
                    case NS: {
                        if (!(w1.getHeader().getLat_dec() < w2.getHeader().getLat_dec())) break;
                        sorted = false;
                        break;
                    }
                    case SN: {
                        if (!(w1.getHeader().getLat_dec() > w2.getHeader().getLat_dec())) break;
                        sorted = false;
                        break;
                    }
                    case WE: {
                        if (!(w1.getHeader().getLong_dec() > w2.getHeader().getLong_dec())) break;
                        sorted = false;
                        break;
                    }
                    case EW: {
                        if (!(w1.getHeader().getLong_dec() < w2.getHeader().getLong_dec())) break;
                        sorted = false;
                    }
                }
                if (sorted) continue;
                list.remove(i - 1);
                list.add(i, w1);
            }
        }
        list.addAll(removed);
    }

    List<Well> getWells(int wellListID, WellGeoSort order) throws SQLException, SBException {
        List<Well> list = this.getWells(wellListID);
        WellManager.sortWells(list, order);
        return list;
    }

    Set<Integer> getProjIDs(Well well) {
        try {
            this.loadWellLists();
        }
        catch (SQLException sqle) {
            throw SuppressedSQLException.withoutRollback(sqle);
        }
        return well.getHeader().getWellListIDs().stream().filter(wlID -> this.wellLists.containsKey(wlID)).map(wlID -> ((WellList)((Object)((Object)this.wellLists.get(wlID)))).getProjID()).collect(Collectors.toSet());
    }

    List<Well> getWells(int wellListID) throws SQLException, SBException {
        ArrayList<Well> list = new ArrayList<Well>();
        if (this.sbdb.isConnected()) {
            String sql = "SELECT well_id FROM " + this.sbdb.DBTableName("WELLIST_MBR") + " WHERE WELLIST_ID=" + wellListID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    try {
                        Well well = this.getWell(rs.getInt("well_id"));
                        assert (well.getHeader().isWellListMember(wellListID));
                        list.add(well);
                    }
                    catch (SBException e) {
                        if (e.getCause() != null && e.getCause() instanceof SBPermissionException) {
                            LOGGER.log(Level.WARNING, "Did not add well to well list: {0}", e.getMessage());
                            continue;
                        }
                        throw e;
                    }
                    catch (WellHeader.MissingWellException e) {
                        LOGGER.log(Level.WARNING, "Missing well: did not add well to well list: {0}", e.getMessage());
                    }
                }
            }
        } else {
            for (Well well : this.wells.values()) {
                if (wellListID != 0 && !well.getHeader().isWellListMember(wellListID)) continue;
                list.add(well);
            }
        }
        Collections.sort(list);
        return list;
    }

    Iterator<Well> getWellIterator(int wellListID) throws SQLException, SBException {
        return this.getWells(wellListID).iterator();
    }

    public Stream<Well> getWellStream(int wellListID) {
        try {
            List<Well> w = this.getWells(wellListID);
            return w.stream();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        catch (SBException e) {
            throw new RuntimeException(e);
        }
    }

    Iterator<Well> getWellIterator(int wellListID, WellGeoSort order) throws SQLException, SBException {
        return this.getWells(wellListID, order).iterator();
    }

    public Iterator<Well> getProjectWells(int projID) throws SuppressedSQLException {
        TreeSet<Well> projectWells = new TreeSet<Well>();
        try {
            for (WellList list : this.wellLists.values()) {
                if (list.getProjID() != projID) continue;
                projectWells.addAll(this.getWells(list.getID()));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        catch (SBException e) {
            throw new RuntimeException(e);
        }
        return projectWells.iterator();
    }

    public Iterator<Well> getWellListWells(int wellListID) throws SuppressedSQLException {
        try {
            return this.getWellIterator(wellListID);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        catch (SBException e) {
            throw new RuntimeException(e);
        }
    }

    int getnWells(int wellListID) throws SQLException, SBException {
        return this.getWells(wellListID).size();
    }

    Well getWellAt(int nWell) {
        ArrayList<Well> list = new ArrayList<Well>(this.wells.values());
        Collections.sort(list);
        return list.get(nWell);
    }

    Well getWell(int wellID) throws SQLException, SBException {
        Well well = this.wells.get(wellID);
        if (well == null && this.sbdb.isConnected()) {
            try {
                well = new Well(this.sbdb, wellID);
                this.wells.put(wellID, well);
            }
            catch (IllegalArgumentException | SBPermissionException pe) {
                throw new SBException(pe.getMessage(), pe);
            }
        }
        return well;
    }

    public Well getWellByID(int wellID) {
        try {
            return this.getWell(wellID);
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        catch (SBException sbe) {
            throw new RuntimeException(sbe.getCause());
        }
    }

    void addWell(Well well) {
        if (well.getWellID() == 0) {
            throw new IllegalArgumentException("Attempt to add well with ID 0");
        }
        if (this.wells.get(well.getWellID()) != null) {
            if (this.wells.get(well.getWellID()) == well) {
                assert (false);
                return;
            }
            throw new IllegalArgumentException("Attempt to add duplicate well");
        }
        this.wells.put(well.getWellID(), well);
    }

    Well addWell(com.stratadata.model3.well.WellHeader header) throws SQLException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT well_code FROM " + this.sbdb.DBTableName("wells") + " WHERE well_code='" + header.getWellCode() + "'";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                throw new SBException("Well code: '" + header.getWellCode() + "' Already exists. Well not saved");
            }
        }
        if (header.getCountry().isBlank()) {
            throw new SBException("Cannot add well '" + header.getCountry() + "': country name missing");
        }
        if (header.getDescription().isBlank()) {
            header.setDescription("Created: " + DateUtils.DB_DATE_FORMAT.format(LocalDate.now()));
        }
        int wellID = this.sbdb.nextControl("WELLS", "WELL_ID");
        Well well = new Well(this.sbdb, wellID, header);
        this.addWell(well);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            well.loadAcm(this.sbdb, stmt);
        }
        return well;
    }

    WsWell addWellToWorkspace(int wellID, String filePath, com.stratadata.model3.well.WellHeader header) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace well to connected database");
        }
        if (wellID <= 0) {
            wellID = this.getNextWellID();
        }
        try {
            WsWell well = new WsWell(this.sbdb, wellID, filePath, header);
            this.addWell(well);
            well.getSamples();
            return well;
        }
        catch (SQLException | SBException | SBPermissionException e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextWellID() {
        int wellID = 1;
        for (Well well : this.wells.values()) {
            if (well.getWellID() < wellID) continue;
            wellID = well.getWellID() + 1;
        }
        return wellID;
    }

    WsWell addWellToWorkspace(Well dbWell) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to add workspace well to connected database");
        }
        if (!dbWell.getDataModel().isConnected()) {
            throw new IllegalArgumentException("Attempt to copy workspace well to workspace");
        }
        if (this.wells.get(dbWell.getWellID()) != null) {
            return (WsWell)this.wells.get(dbWell.getWellID());
        }
        try {
            WsWell well = new WsWell(this.sbdb, dbWell);
            this.addWell(well);
            well.getSamples();
            return well;
        }
        catch (SQLException | SBException | SBPermissionException e) {
            throw new RuntimeException(e);
        }
    }

    void parseWell(Element xml, Set<Integer> dataTypes, ZipFile zip, String fileName) throws SQLException, SBException, ParseException, SBPermissionException {
        int wellID = this.getNextWellID();
        WsWell well = new WsWell(this.sbdb, xml, dataTypes, zip, fileName, wellID);
        this.addWell(well);
    }

    void deleteWell(Well well) throws SQLException, SBException, SBPermissionException {
        if (this.wells.get(well.getWellID()) != well) {
            throw new IllegalStateException("Attempt to delete well which was not loaded");
        }
        if (this.sbdb.isConnected()) {
            if (!well.canWrite(this.sbdb, null)) {
                throw new SBPermissionException(well.getDeniedReason(this.sbdb, "well", true));
            }
            Well.deleteWell(this.sbdb, well.getWellID(), well.getWellCode());
            this.sbdb.updateAuditTrail("WELL", "DELETE " + well.toString() + " [" + well.getWellID() + "]");
        }
        this.wells.remove(well.getWellID());
        for (Integer wellListID : well.getHeader().getWellListIDs()) {
            WellList wellList = this.getWellList(wellListID);
            wellList.updateAudit(this.sbdb);
            wellList.getListeners().forEach(wellListObserver -> wellListObserver.wellRemoved(well));
        }
    }

    int size() {
        return this.wells.size();
    }

    private void loadWellLists() throws SQLException {
        if (this.wellLists.isLoaded()) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT wellist_id,proj_id,name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("WELLIST");
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int wellListID = rs.getInt("wellist_id");
                    int projID = rs.getInt("proj_id");
                    String name = rs.getString("name");
                    String descr = rs.getString("descr");
                    Audit audit = new Audit(rs);
                    WellList wellList = new WellList(wellListID, projID, name, descr, audit);
                    this.wellLists.put(wellListID, wellList);
                }
            }
        }
        this.wellLists.setLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWellList(WellList wellList) {
        if (wellList == null) {
            throw new IllegalArgumentException("Attempt to put null wellList");
        }
        if (!this.wellLists.isLoaded()) {
            assert (false);
            System.out.println("WARNING: wellLists not loaded!");
        }
        LoadedTreeMap<Integer, WellList> loadedTreeMap = this.wellLists;
        synchronized (loadedTreeMap) {
            this.wellLists.put(wellList.getID(), wellList);
        }
    }

    WellList addWellList(String name, String descr, int projID) throws SQLException, SBPermissionException, InvalidFieldException {
        WellList wellList2;
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Attempt to add wellList with no name");
        }
        name = name.trim();
        this.loadWellLists();
        for (WellList wellList2 : this.wellLists.values()) {
            if (wellList2.getProjID() != projID || !wellList2.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("That name is already used in the project");
        }
        int wellListID = this.sbdb.nextControl("WELLIST", "WELLIST_ID");
        wellList2 = new WellList(wellListID, projID, name, descr, new Audit());
        wellList2.store(this.sbdb);
        this.putWellList(wellList2);
        this.updateProjectAuditAndNotifyListeners(projID);
        return wellList2;
    }

    private void updateProjectAuditAndNotifyListeners(int projID) throws SQLException {
        this.loadProjects();
        Project project = (Project)((Object)this.projects.get(projID));
        if (project == null) {
            throw new IllegalArgumentException("No project for projID " + projID);
        }
        project.updateAudit(this.sbdb);
        project.getListeners().forEach(l -> l.projectWellListsChanged(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteProject(int projID) throws SQLException, SBPermissionException {
        this.loadProjects();
        Project project = (Project)((Object)this.projects.get(projID));
        if (project == null) {
            throw new IllegalStateException("Attempt to delete project: " + projID + " which did not exist");
        }
        for (WellList wellList : this.getWellLists(projID)) {
            this.deleteWellList(wellList.getID());
        }
        project.delete(this.sbdb);
        LoadedTreeMap<Integer, Project> loadedTreeMap = this.projects;
        synchronized (loadedTreeMap) {
            this.projects.remove(projID);
        }
        this.sbdb.updateAuditTrail("PROJECT", "DELETE " + project.getName() + " [" + projID + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteWellList(int wellListID) throws SQLException, SBPermissionException {
        this.loadWellLists();
        WellList wellList = (WellList)((Object)this.wellLists.get(wellListID));
        if (wellList == null) {
            throw new IllegalStateException("Attempt to delete well list which did not exist");
        }
        wellList.delete(this.sbdb);
        for (Well well : this.wells.values()) {
            well.getHeader().removeFromWellList(wellListID);
        }
        LoadedTreeMap<Integer, WellList> loadedTreeMap = this.wellLists;
        synchronized (loadedTreeMap) {
            this.wellLists.remove(wellListID);
        }
        this.updateProjectAuditAndNotifyListeners(wellList.getProjID());
        this.sbdb.updateAuditTrail("WELLLIST", "DELETE " + wellList.getName() + " [" + wellListID + "]");
    }

    void loadProjectCombo(DefaultComboBoxModel model, boolean includeDefault) throws SQLException {
        this.loadProjects();
        if (includeDefault) {
            model.addElement("<none>");
        }
        ArrayList list = new ArrayList(this.projects.values());
        Collections.sort(list);
        for (Project p : list) {
            model.addElement(p);
        }
    }

    List<Project> getProjects() throws SuppressedSQLException {
        try {
            this.loadProjects();
            ArrayList<Project> list = new ArrayList<Project>(this.projects.values());
            Collections.sort(list);
            return list;
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
    }

    Iterator<Well> getWellIterator(String wellListName) throws SQLException, SBException {
        this.loadWellLists();
        WellList wellList = null;
        for (WellList p : this.wellLists.values()) {
            if (!p.getName().equalsIgnoreCase(wellListName)) continue;
            wellList = p;
            break;
        }
        if (wellList != null) {
            return this.getWells(wellList.getID()).iterator();
        }
        return null;
    }

    public WellList getWellList(int wellListID) throws SuppressedSQLException {
        try {
            this.loadWellLists();
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        return (WellList)((Object)this.wellLists.get(wellListID));
    }

    WellList getDefaultWellList(int projID) {
        return this.getDefaultWellList(projID, true);
    }

    WellList getDefaultWellList(int projID, boolean useAnyDefault) {
        Project project = (Project)((Object)this.projects.get(projID));
        if (project == null) {
            return null;
        }
        List<WellList> projectWellLists = this.getWellLists(projID);
        for (WellList wellList : projectWellLists) {
            if (!wellList.getName().equalsIgnoreCase(project.getName())) continue;
            return wellList;
        }
        if (!useAnyDefault) {
            return null;
        }
        return projectWellLists.get(0);
    }

    public List<WellList> getWellLists(int projectID) throws SuppressedSQLException {
        try {
            this.loadWellLists();
        }
        catch (SQLException sqle) {
            throw SuppressedSQLException.withoutRollback(sqle);
        }
        List<WellList> list = this.wellLists.values().stream().filter(wllst -> wllst.getProjID() == projectID).collect(Collectors.toList());
        Collections.sort(list);
        return list;
    }

    void addWells(List<Well> wells, int wellListID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        WellList wellList = this.getWellList(wellListID);
        ListIterator<Well> it = wells.listIterator();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            while (it.hasNext()) {
                Well well = it.next();
                if (!well.getHeader().isWellListMember(wellListID)) {
                    String sql = "INSERT INTO " + this.sbdb.DBTableName("WELLIST_MBR") + " (wellist_id,well_id) VALUES (" + wellListID + "," + well.getWellID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    continue;
                }
                it.remove();
            }
        }
        if (!wells.isEmpty()) {
            for (Well well : wells) {
                if (well.getHeader().isWellListMember(wellListID)) continue;
                well.getHeader().addToWellList(wellListID);
            }
            wellList.updateAudit(this.sbdb);
            wellList.getListeners().forEach(wellListObserver -> wellListObserver.wellsAdded(wells));
        }
    }

    void removeWellsFromWellList(Collection<Well> wellsToRemove, int wellListID) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        WellList wellList = this.getWellList(wellListID);
        if (wellList == null || wellsToRemove.isEmpty()) {
            return;
        }
        for (Well well : wellsToRemove) {
            if (!well.getHeader().isWellListMember(wellListID)) continue;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "DELETE FROM " + this.sbdb.DBTableName("WELLIST_MBR") + " WHERE WELLIST_ID=" + wellListID + " AND WELL_ID=" + well.getWellID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            well.getHeader().removeFromWellList(wellListID);
            wellList.updateAudit(this.sbdb);
            wellList.getListeners().forEach(wellListObserver -> wellListObserver.wellRemoved(well));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshWellLists(Connection conn) throws SQLException, SBException {
        if (!this.wellLists.isLoaded()) {
            return;
        }
        LinkedList<WellList> notifiers = new LinkedList<WellList>();
        LoadedTreeMap<Integer, WellList> loadedTreeMap = this.wellLists;
        synchronized (loadedTreeMap) {
            HashSet<Integer> keys = new HashSet<Integer>();
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT wellist_id,updated FROM " + this.sbdb.DBTableName("WELLIST");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int key = rs.getInt("wellist_id");
                    keys.add(key);
                    Timestamp time = rs.getTimestamp("updated");
                    WellList o = (WellList)((Object)this.wellLists.get(key));
                    if (o != null) {
                        if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) continue;
                        this.refreshWellList(o);
                        notifiers.add(o);
                        continue;
                    }
                    WellList newWellList = this.loadWellList(key);
                    this.wellLists.put(newWellList.getID(), newWellList);
                    notifiers.add(newWellList);
                }
            }
            if (keys.size() < this.wellLists.size()) {
                this.wellLists.values().stream().filter(wl -> !keys.contains(wl.getID())).forEach(wl -> {
                    notifiers.add((WellList)((Object)wl));
                    this.wellLists.remove(wl.getID());
                });
            }
        }
        for (WellList notifier : notifiers) {
            this.refreshWellListMembership(notifier.getID());
            notifier.getListeners().forEach(wellListObserver -> wellListObserver.wellListChanged(notifier));
        }
    }

    private void refreshWellList(WellList wellList) throws SQLException {
        String sql = "SELECT proj_id,name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("WELLIST") + " WHERE wellist_id=" + wellList.getID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int projID = rs.getInt("proj_id");
                if (projID != wellList.getProjID()) {
                    throw new IllegalStateException("WellList project has changed");
                }
                wellList.setName(rs.getString("name").trim());
                wellList.setDescription(rs.getString("descr"));
                wellList.setAudit(new Audit(rs));
            }
        }
    }

    private WellList loadWellList(int wellListID) throws SQLException {
        String sql = "SELECT proj_id,name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("WELLIST") + " WHERE wellist_id=" + wellListID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int projID = rs.getInt("proj_id");
                String name = rs.getString("name");
                String descr = rs.getString("descr");
                Audit audit = new Audit(rs);
                WellList wellList = new WellList(wellListID, projID, name, descr, audit);
                return wellList;
            }
        }
        throw new IllegalStateException("WellList with ID " + wellListID + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshWellListMembership(int wellListID) throws SQLException {
        String sql = "SELECT well_id FROM " + this.sbdb.DBTableName("WELLIST_MBR") + " WHERE WELLIST_ID=" + wellListID;
        HashSet<Integer> wellsInList = new HashSet<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellsInList.add(rs.getInt("well_id"));
            }
        }
        HashMap<Integer, Well> hashMap = this.wells;
        synchronized (hashMap) {
            for (Well well : this.wells.values()) {
                if (wellsInList.contains(well.getWellID())) {
                    well.getHeader().addToWellList(wellListID);
                    continue;
                }
                well.getHeader().removeFromWellList(wellListID);
            }
        }
    }

    void refreshWells(Connection conn) throws SQLException, SBException {
        LinkedList<Well> list = new LinkedList<Well>(this.wells.values());
        try (Statement stmt = conn.createStatement();){
            for (Well well : list) {
                well.refresh(stmt);
            }
        }
    }

    void writeWellLocations(List<Well> wellsToWrite, String title, BufferedWriter out, String eol) throws IOException, SQLException, SBException {
        if (title != null) {
            out.write("<name>" + title + "</name>" + eol);
        }
        String br = "<br/>";
        Collections.sort(wellsToWrite);
        for (Well w : wellsToWrite) {
            WellHeader h = w.getHeader();
            if (h.getLat_dec() == null || h.getLong_dec() == null || !(Math.abs(h.getLat_dec()) > 0.0) || !(Math.abs(h.getLong_dec()) > 0.0)) continue;
            out.write("<Placemark>" + eol);
            out.write("<name>" + w.getWellName() + "</name>" + eol);
            out.write("<description>");
            Object descrip = "";
            descrip = (String)descrip + "Well code: " + w.getWellCode() + "<br/>";
            if (w.getHeader().getDescription() != null) {
                String desc = h.getDescription().replace("Version created at", "StrataBugs");
                descrip = (String)descrip + desc + "<br/>";
            }
            descrip = (String)descrip + h.getCountry() + "<br/>";
            if (!h.getField().isEmpty()) {
                descrip = (String)descrip + h.getField() + "<br/>";
            }
            if (!h.getOperator().isEmpty()) {
                descrip = (String)descrip + h.getOperator() + "<br/>";
            }
            descrip = (String)descrip + "TD: " + SB.getDepthString((double)w.getTD(), (char)h.getWellUnits(), (int)2) + "<br/>";
            out.write(SB.getXMLstring((String)descrip) + "</description>" + eol);
            out.write("<Point>" + eol);
            out.write("<coordinates>" + h.getLong_dec() + "," + h.getLat_dec() + (h.getRTEValue() + h.getSLValue()) + "</coordinates>" + eol);
            out.write("</Point>" + eol);
            out.write("</Placemark>" + eol);
        }
    }

    void mergeOcc(CoOccurrence coOcc, boolean mergeAbundance) throws SQLException, SBException {
        Smpdtl smpdtl;
        Sample sample;
        Well well;
        boolean loaded = true;
        if (this.wells.get(coOcc.getWellID()) == null) {
            well = this.getWell(coOcc.getWellID());
            loaded = false;
        } else {
            well = this.getWell(coOcc.getWellID());
            well.loadSamples();
        }
        AbundanceScheme abn = this.sbdb.getAbundanceSchemeService().findAbundanceScheme(well.getAnalystHeader(coOcc.analyID, true).getAbnSchID()).orElse(null);
        if (abn == null) {
            abn = this.sbdb.getAbundanceSchemeService().getDefaultAbundanceScheme();
        }
        if (mergeAbundance) {
            coOcc.target.merge(coOcc.donor, abn);
        }
        coOcc.donor.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
        if (mergeAbundance) {
            coOcc.target.delete(coOcc.wellID, coOcc.sampID, coOcc.analyID);
            coOcc.target.store(null, coOcc.wellID, coOcc.sampID, coOcc.analyID, abn);
        }
        if (loaded && (sample = well.getSample(coOcc.sampID)) != null && (smpdtl = sample.getSmpdtl(coOcc.analyID)) != null) {
            if (mergeAbundance) {
                smpdtl.replaceOcc(coOcc.wellID, coOcc.target);
            }
            smpdtl.removeOcc(coOcc.donor);
            smpdtl.notifyObservers();
        }
    }

    private Well getWellListDepth(boolean top, boolean useTVD, int wellListID) throws SBException, SQLException {
        Double depth = null;
        Well w = null;
        Iterator<Well> wellIterator = this.getWellIterator(wellListID);
        while (wellIterator.hasNext()) {
            Well well = wellIterator.next();
            if (top) {
                double topDepth = well.getTopSampleDepth();
                if (depth != null && !(topDepth < depth)) continue;
                depth = topDepth;
                w = well;
                continue;
            }
            double baseDepth = 0.0;
            if (useTVD) {
                baseDepth = well.getTVDlist(false).getBaseTVD();
            }
            if (baseDepth == 0.0) {
                baseDepth = well.getBaseSampleDepth();
            }
            if (depth != null && !(baseDepth > depth)) continue;
            depth = baseDepth;
            w = well;
        }
        return w;
    }

    Project getProject(int projID) throws SQLException {
        this.loadProjects();
        return (Project)((Object)this.projects.get(projID));
    }

    Project getProject(String projectName) throws SQLException {
        this.loadProjects();
        Project project = null;
        for (Project p : this.projects.values()) {
            if (!p.getName().equalsIgnoreCase(projectName)) continue;
            project = p;
            break;
        }
        return project;
    }

    int getnProjects() throws SQLException {
        this.loadProjects();
        return this.projects.size();
    }

    public boolean isWellProjectMember(int projID, int wellID) {
        try {
            this.loadWellLists();
            Well well = this.getWell(wellID);
            return this.wellLists.values().stream().filter(wl -> wl.getProjID() == projID).anyMatch(wl -> well.getHeader().isWellListMember(wl.getID()));
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
        catch (SBException sbe) {
            throw new RuntimeException(sbe);
        }
    }

    private void loadProjects() throws SQLException {
        if (this.projectsLoaded) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT proj_id,name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("PROJECT");
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int projID = rs.getInt("proj_id");
                    String name = rs.getString("name");
                    String descr = rs.getString("descr");
                    Audit audit = new Audit(rs);
                    Project project = new Project(projID, name, descr, audit);
                    this.projects.put(projID, project);
                }
            }
        }
        this.projectsLoaded = true;
    }

    Project addProject(String name, String descr) throws SQLException, SBPermissionException, InvalidFieldException {
        Project project2;
        if (name == null || name.isEmpty()) {
            throw new IllegalStateException("Attempt to add wellList with no name");
        }
        name = name.trim();
        this.loadProjects();
        for (Project project2 : this.projects.values()) {
            if (!project2.getName().equalsIgnoreCase(name)) continue;
            throw new InvalidFieldException("That name is already in use.");
        }
        int projectID = this.sbdb.nextControl("PROJECT", "PROJ_ID");
        project2 = new Project(projectID, name, descr, new Audit());
        project2.store(this.sbdb);
        this.putProject(project2);
        this.addWellList(name, null, projectID);
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putProject(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Attempt to put null project");
        }
        if (!this.projectsLoaded) {
            assert (false);
            System.out.println("WARNING: projects not loaded!");
        }
        LoadedTreeMap<Integer, Project> loadedTreeMap = this.projects;
        synchronized (loadedTreeMap) {
            this.projects.put(project.getID(), project);
        }
    }

    void addWellsToProject(List<Well> wells, int projID) throws SQLException, SBPermissionException {
        this.addWells(wells, this.getDefaultWellList(projID).getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshProjects(Connection conn) throws SQLException, SBException {
        if (!this.projectsLoaded) {
            return;
        }
        LoadedTreeMap<Integer, Project> loadedTreeMap = this.projects;
        synchronized (loadedTreeMap) {
            HashSet<Integer> keys = new HashSet<Integer>();
            LinkedList<Project> notifiers = new LinkedList<Project>();
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT proj_id,updated FROM " + this.sbdb.DBTableName("PROJECT");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int key = rs.getInt("proj_id");
                    keys.add(key);
                    Timestamp time = rs.getTimestamp("updated");
                    boolean found = false;
                    for (Project o : this.projects.values()) {
                        if (o.getID() != key) continue;
                        found = true;
                        if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                        this.refreshProject(o);
                        notifiers.add(o);
                        break;
                    }
                    if (found) continue;
                    Project newProject = this.loadProject(key);
                    this.projects.put(newProject.getID(), newProject);
                    notifiers.add(newProject);
                }
            }
            if (keys.size() < this.projects.size()) {
                Iterator it = this.projects.values().iterator();
                while (it.hasNext()) {
                    Project o = (Project)((Object)it.next());
                    if (keys.contains(o.getID())) continue;
                    it.remove();
                    notifiers.add(o);
                }
            }
            if (!notifiers.isEmpty()) {
                for (Project project : notifiers) {
                    project.getListeners().forEach(l -> l.projectChanged(project));
                }
            }
        }
    }

    private void refreshProject(Project project) throws SQLException {
        String sql = "SELECT name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("PROJECT") + " WHERE proj_id=" + project.getID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                String name = rs.getString("name").trim();
                if (name == null) {
                    name = "<none>";
                }
                project.setName(name);
                project.setDescription(rs.getString("descr"));
                project.setAudit(new Audit(rs));
            }
        }
    }

    private Project loadProject(int projID) throws SQLException {
        String sql = "SELECT name,descr," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("PROJECT") + " WHERE proj_id=" + projID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                String name = rs.getString("name").trim();
                if (name == null) {
                    name = "<none>";
                }
                String descr = rs.getString("descr");
                Audit audit = new Audit(rs);
                Project project = new Project(projID, name, descr, audit);
                return project;
            }
        }
        throw new IllegalStateException("Project with ID " + projID + " not found");
    }

    private static class LoadedTreeMap<K, V>
    extends TreeMap<K, V> {
        private boolean loaded = false;

        private LoadedTreeMap() {
        }

        void setLoaded() {
            this.loaded = true;
        }

        boolean isLoaded() {
            return this.loaded;
        }
    }
}

