/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeServiceImpl;
import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.Curves;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import model3.AnalystHeader;
import model3.Audit;
import model3.Biocom;
import model3.Casing;
import model3.CasingPoint;
import model3.CoreImage;
import model3.CoredInterval;
import model3.Cores;
import model3.Coreshift;
import model3.EnvScheme;
import model3.Fault;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.Intcom;
import model3.InterpHdr;
import model3.LOC;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.LogDef;
import model3.Markers;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SampleAge;
import model3.SampleInsertException;
import model3.SampleLithology;
import model3.SeismicMarker;
import model3.Smpdtl;
import model3.TVDList;
import model3.TVDepth;
import model3.TWTDepth;
import model3.TWTList;
import model3.Well;
import model3.WellEvent;
import model3.WellHeader;
import model3.WellInterp;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.InvalidFieldException;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.DTMonitor;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class WsWell
extends Well
implements SbugsStatus {
    Well link = null;
    HashMap<Integer, HashMap> monitors = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(WsWell.class.getName());
    public String fileName;
    private Color headerStatus = NOTSTORED;

    WsWell(SBdb ws, int wellID, String filePath, com.stratadata.model3.well.WellHeader header) throws SQLException, SBException, SBPermissionException {
        super(ws, wellID);
        if (ws.isConnected()) {
            throw new IllegalArgumentException("Attempt to create WsWell in connected model");
        }
        if (header != null) {
            this.header = new WellHeader(header);
        }
        if (filePath != null) {
            String temp = filePath.contains("\\") ? filePath.substring(filePath.lastIndexOf(92)) : filePath;
            this.fileName = temp.length() > 0 ? ".." + temp : filePath;
        }
    }

    public Well getLink() {
        return this.link;
    }

    public DTMonitor getMonitor(int interpID, int dataType) throws SBException {
        DTMonitor monitor;
        HashMap<Integer, DTMonitor> map;
        if (!SBdb.isInterpDataType(dataType)) {
            interpID = 0;
        }
        if ((map = this.monitors.get(interpID)) == null) {
            map = new HashMap<Integer, DTMonitor>();
            this.monitors.put(interpID, map);
        }
        if ((monitor = (DTMonitor)map.get(dataType)) == null) {
            monitor = new DTMonitor();
            map.put(dataType, monitor);
        }
        return monitor;
    }

    void removeMonitor(int interpID, int dataType) throws SBException {
        HashMap map;
        if (!SBdb.isInterpDataType(dataType)) {
            interpID = 0;
        }
        if ((map = this.monitors.get(interpID)) == null) {
            return;
        }
        map.remove(dataType);
    }

    public void removeInterp(InterpHdr hdr) throws SBException {
        WellInterp wellInterp = super.getInterp(hdr.getInterpID());
        super.removeInterp(wellInterp);
    }

    WsWell(SBdb ws, Well well) throws SQLException, SBException, SBPermissionException {
        super(ws, well.getWellID());
        this.link = well;
        this.header = new WellHeader(well.getHeader().getWellHeaderCopy());
        this.loadInterps();
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            WellInterp wellInterp = it.next();
            wellInterp.getHeader().setLink(this.link.getInterp(wellInterp.interpID).getHeader());
        }
    }

    public void updateLithologyStatus(boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(0, 21);
        if (this.lithIntervals == null) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating lithology status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(21, this.getWellUnits());
        if (this.lithIntervals.size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.lithIntervals.size(); ++i) {
                LithBase lith = (LithBase)this.lithIntervals.get(i);
                if (lith instanceof LithQualifier) {
                    LithQualifier qual = (LithQualifier)lith;
                    qual.updateStatus(this.lithIntervals, false);
                    if (qual.status != CONFLICT && this.link != null && this.link.getLithIntervals().size() > 0) {
                        qual.updateStatus(this.link.getLithIntervals(), true);
                    }
                } else {
                    lith.updateStatus(this.lithIntervals, false);
                    if (lith.status != CONFLICT && this.link != null && this.link.getLithIntervals().size() > 0) {
                        lith.updateStatus(this.link.getLithIntervals(), true);
                    }
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)lith.status));
            }
        }
    }

    public void updateCoreStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.getCores() == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating Cores status...");
        DTMonitor monitor = this.getMonitor(0, 19);
        if (reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(19, this.getWellUnits());
        if (this.getCores().getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (CoredInterval core : this.getCores().getList()) {
                core.updateStatus(this.getCores());
                if (this.link != null && core.status != CONFLICT) {
                    core.updateStatus(this.link.getCores());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)core.status));
            }
        }
    }

    public void updateCurvesStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.curves == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating curves status...");
        DTMonitor monitor = this.getMonitor(0, 23);
        if (reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(23, this.getWellUnits());
        if (!this.curves.getCurves().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            for (Curve curve : this.curves.getCurves()) {
                Color curveStatus = SbugsStatus.NOTSTORED;
                if (this.link != null) {
                    LogDef linkedLogDef = this.db.getLogDef(curve.getAbr()).getLink();
                    String curveAbr = linkedLogDef != null ? linkedLogDef.getAbr() : curve.getAbr();
                    for (Curve linkCurve : this.link.getCurves().getCurves()) {
                        if (!linkCurve.getSortEntry(linkCurve.getAbr()).equals(curve.getSortEntry(curveAbr))) continue;
                        curveStatus = STORED;
                        break;
                    }
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)curveStatus));
            }
        }
    }

    public void updateAnalystHeadersStatus() throws SQLException, SBException {
        if (this.link == null) {
            return;
        }
        List<AnalystHeader> dbHdrs = this.link.getAnalystHeaders();
        this.loadAnalystHeaders();
        if (!this.getAnalystHeaders().isEmpty()) {
            LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating analyst header status...");
        }
        for (AnalystHeader hdr : this.getAnalystHeaders()) {
            if (hdr.getAbnSchID() > 0 || hdr.getEnvSchID() > 0) {
                boolean hasAbn = false;
                boolean hasEnv = false;
                for (Smpdtl dtl : this.getAnalyses(hdr.getDiscID(), hdr.getAnalyst(), hdr.getAnalyNumber())) {
                    if (dtl.getProximal() > 0 || dtl.getDistal() > 0) {
                        hasEnv = true;
                    }
                    if (dtl.hasSemiQuantData(null) != null) {
                        hasAbn = true;
                    }
                    if (!hasAbn || !hasEnv) continue;
                    break;
                }
                if (!hasAbn) {
                    hdr.setAbnScheme(-1);
                }
                if (!hasEnv) {
                    hdr.setEnvScheme(-1);
                }
            }
            hdr.updateStatus(dbHdrs);
        }
    }

    public void updateTVDStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.TVD == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating TVD status...");
        DTMonitor monitor = this.getMonitor(0, 25);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(25, this.getWellUnits());
        boolean stored = false;
        boolean conflict = false;
        boolean notstored = false;
        if (this.link != null && this.link.getTVDlist(false) != null && !this.link.getTVDlist(false).getList().isEmpty()) {
            block0: for (TVDepth wsTVDepth : this.TVD.getList()) {
                for (TVDepth dbTVDepth : this.link.getTVDlist(false).getList()) {
                    if (Math.abs(dbTVDepth.getDDepth() - wsTVDepth.getDDepth()) < (double)0.0029f) {
                        if (wsTVDepth.getTVDepth() - dbTVDepth.getTVDepth() < (double)0.0029f) {
                            stored = true;
                            break block0;
                        }
                        conflict = true;
                        break block0;
                    }
                    notstored = true;
                }
            }
            if (conflict) {
                this.TVD.setStatus(CONFLICT);
            } else if (stored && notstored) {
                this.TVD.setStatus(PARTSTORED);
            } else if (notstored && !stored) {
                this.TVD.setStatus(NOTSTORED);
            } else if (stored && !notstored) {
                this.TVD.setStatus(STORED);
            }
        } else if (this.TVD.getSize() > 0) {
            this.TVD.setStatus(NOTSTORED);
        }
        monitor.setStatus(this.TVD.getStatus());
    }

    public void updateTWTStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.TWT == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating TWT status...");
        DTMonitor monitor = this.getMonitor(0, 26);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(26, this.getWellUnits());
        boolean stored = false;
        boolean conflict = false;
        boolean notstored = false;
        if (this.link != null && this.link.getTWTlist() != null && !this.link.getTWTlist().getList().isEmpty()) {
            block0: for (TWTDepth wsTWTDepth : this.TWT.getList()) {
                for (TWTDepth dbTWTDepth : this.link.getTWTlist().getList()) {
                    if (Math.abs(dbTWTDepth.getDepth() - wsTWTDepth.getDepth()) < (double)0.0029f) {
                        if (wsTWTDepth.getTWT() - dbTWTDepth.getTWT() < (double)0.0029f) {
                            stored = true;
                            break block0;
                        }
                        conflict = true;
                        break block0;
                    }
                    notstored = true;
                }
            }
            if (conflict) {
                this.TWT.setStatus(CONFLICT);
            } else if (stored && notstored) {
                this.TWT.setStatus(PARTSTORED);
            } else if (notstored && !stored) {
                this.TWT.setStatus(NOTSTORED);
            } else if (stored && !notstored) {
                this.TWT.setStatus(STORED);
            }
        } else if (this.TWT.getSize() > 0) {
            this.TWT.setStatus(NOTSTORED);
        }
        monitor.setStatus(this.TWT.getStatus());
    }

    public void updateCasingStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.casing == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating Casing status...");
        DTMonitor monitor = this.getMonitor(0, 20);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(20, this.getWellUnits());
        if (this.casing.getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.casing.getSize(); ++i) {
                CasingPoint casingPoint = this.casing.getCasingPoint(i);
                casingPoint.updateStatus(this.casing);
                if (this.link != null && casingPoint.status != CONFLICT) {
                    casingPoint.updateStatus(this.link.getCasing());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)casingPoint.status));
            }
        }
    }

    public void updateSampleLithologyStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.getSamples() == null) {
            return;
        }
        boolean found = false;
        for (Sample sample : this.getSamples()) {
            if (sample.getLithology() == null || sample.getLithology().lithology.isEmpty()) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating sample lithology status...");
        DTMonitor monitor = this.getMonitor(0, 22);
        if (monitor != null && reloadRange) {
            monitor.setStatus(UNKNOWN);
            if (this.link != null && monitor.getLink() != null) {
                monitor.getLink().setStatus(UNKNOWN);
            }
        }
        this.getNonInterpDataRange(22, this.getWellUnits());
        if (this.getSamples().size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.getSamples().size(); ++i) {
                Sample sample = this.getSamples().get(i);
                if (sample.getLithology() == null || sample.getLithology().getLithology().isEmpty()) continue;
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.getLithology().getStatus(this.link != null && sample.link != null ? sample.link.getLithology() : null)));
            }
        }
    }

    public void updateMarkersStatus(boolean reloadRange) throws SBException, SQLException {
        if (this.markers == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating marker status...");
        DTMonitor monitor = this.getMonitor(0, 24);
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getNonInterpDataRange(24, this.getWellUnits());
        if (this.markers.getSize() > 0) {
            monitor.setStatus(UNKNOWN);
            for (int i = 0; i < this.markers.getSize(); ++i) {
                SeismicMarker marker = this.markers.get(i);
                marker.updateStatus(this.markers);
                if (this.link != null && marker.status != CONFLICT) {
                    marker.updateStatus(this.link.markers);
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)marker.status));
            }
        }
    }

    public void updateStatus() throws SQLException, SBException {
        this.updateHeaderStatus();
        this.updateAnalystHeadersStatus();
        this.updateSampleStatus(true);
        if (this.link != null) {
            this.link.loadInterps();
        }
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            this.updateInterpStatus(it.next(), this.getWellUnits());
        }
        this.updateCoreStatus(true);
        this.updateCasingStatus(true);
        this.updateMarkersStatus(true);
        this.updateTVDStatus(true);
        this.updateTWTStatus(true);
        this.updateLithologyStatus(true);
        this.updateSampleLithologyStatus(true);
        this.updateCurvesStatus(true);
    }

    public void updateStatus(Set<Integer> dTypes) throws SQLException, SBException {
        boolean samplesUpdated = false;
        boolean allBCMUpdated = false;
        boolean allZonesUpdated = false;
        block15: for (Integer i : dTypes) {
            if (SBdb.isInterpDataType(i)) {
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        if (allZonesUpdated) continue block15;
                        allZonesUpdated = true;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        if (allBCMUpdated) continue block15;
                        allBCMUpdated = true;
                        break;
                    }
                }
                Iterator<WellInterp> it = this.getInterpIterator();
                while (it.hasNext()) {
                    this.updateInterpTypeStatus(it.next(), i, this.getWellUnits());
                }
                continue;
            }
            switch (i) {
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    if (samplesUpdated) continue block15;
                    this.updateSampleStatus(true);
                    samplesUpdated = true;
                    continue block15;
                }
                case 19: {
                    this.updateCoreStatus(true);
                    continue block15;
                }
                case 20: {
                    this.updateCasingStatus(true);
                    continue block15;
                }
                case 24: {
                    this.updateMarkersStatus(true);
                    continue block15;
                }
                case 25: {
                    this.updateTVDStatus(true);
                    continue block15;
                }
                case 26: {
                    this.updateTWTStatus(true);
                    continue block15;
                }
                case 21: {
                    this.updateLithologyStatus(true);
                    continue block15;
                }
                case 22: {
                    this.updateSampleLithologyStatus(true);
                    continue block15;
                }
                case 23: {
                    this.updateCurvesStatus(true);
                    continue block15;
                }
            }
            throw new SBException("Unrecognised data type is WsWell.updateStatus: " + i);
        }
    }

    public void updateSampleStatus(boolean refreshRange) throws SBException, SQLException {
        DTMonitor monitor;
        if (this.getSamples().isEmpty()) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating Sample status...");
        if (refreshRange) {
            monitor = this.getMonitor(0, 1);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 2);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 4);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 6);
            monitor.setStatus(UNKNOWN);
            monitor = this.getMonitor(0, 8);
            monitor.setStatus(UNKNOWN);
        }
        this.getNonInterpDataRange(1, this.getWellUnits());
        this.getNonInterpDataRange(2, this.getWellUnits());
        this.getNonInterpDataRange(4, this.getWellUnits());
        this.getNonInterpDataRange(6, this.getWellUnits());
        this.getNonInterpDataRange(8, this.getWellUnits());
        if (this.link != null) {
            this.link.loadAnalyses();
        }
        this.getMonitor(0, 1).setStatus(UNKNOWN);
        for (Sample sample : this.getSamples()) {
            sample.status = Sample.NOTSTORED;
            for (Sample comp : this.getSamples()) {
                if (sample == comp || !comp.getSortEntry().equals(sample.getSortEntry())) continue;
                sample.status = Sample.CONFLICT;
                break;
            }
            if (this.link != null && sample.status != Sample.CONFLICT) {
                for (Sample comp : this.link.getSamples()) {
                    if (!sample.isFuncEquivalent(comp)) continue;
                    sample.status = SbugsStatus.STORED;
                    sample.updateStatus(comp);
                    sample.setLink(comp);
                }
                if (sample.status == Sample.NOTSTORED) {
                    sample.setLink(null);
                }
            } else if (this.link == null) {
                sample.setLink(null);
            }
            monitor = this.getMonitor(0, 1);
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)sample.getStatus()));
            monitor.setHasData(true);
            for (int j = 0; j < sample.analyses.size(); ++j) {
                Smpdtl smpdtl = sample.analyses.get(j);
                if (sample.link == null || sample.link != null && smpdtl.link == null) {
                    smpdtl.status = Smpdtl.NOTSTORED;
                    smpdtl.updateStatus();
                } else {
                    smpdtl.updateStatus(smpdtl.link);
                }
                monitor = this.getMonitor(0, SBdb.did2dtype(smpdtl.getDiscID()));
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)smpdtl.getStatus()));
                monitor.setHasData(true);
            }
        }
    }

    public void resetDataMonitors() {
        this.monitors.clear();
    }

    public void resetInterpDataMonitors(Set<Integer> dataTypes, int interpID) throws SBException {
        for (int dType : dataTypes) {
            if (dType == 0 || !SBdb.isInterpDataType(dType)) continue;
            this.removeMonitor(interpID, dType);
        }
    }

    public DTMonitor getDataMonitor(int dType, char units, int interpID) throws SQLException, SBException {
        if (units == 'D') {
            units = this.getHeader().getWellUnits();
        }
        DTMonitor monitor = this.getMonitor(interpID, dType);
        if (SBdb.isInterpDataType(dType)) {
            WellInterp interp = this.getInterp(interpID);
            this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, dType, units);
        } else {
            this.getNonInterpDataRange(dType, units);
        }
        return monitor;
    }

    public DTMonitor getInterpDataRange(WellInterp interp, int wellID, int dType, char units) throws SQLException, SBException {
        DTMonitor monitor = this.getMonitor(interp.interpID, dType);
        if (monitor.getStatus() == UNKNOWN) {
            interp.refreshDataRange(wellID, dType, monitor);
        }
        if (!monitor.isHasData()) {
            monitor.setStatusString("(No data)");
            monitor.setStatus(SbugsStatus.NODATA);
        } else {
            String range = SB.getDepthString((double)monitor.getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getDepthTo(), (char)units, (int)2, (char)this.getType());
            monitor.setStatusString(range);
        }
        if (this.link != null) {
            InterpHdr linkInterpHdr;
            if (monitor.getLink() == null) {
                monitor.setLink(new DTMonitor());
            }
            if ((linkInterpHdr = interp.getHeader().getLink()) != null && monitor.getLink().getStatus() == UNKNOWN) {
                try {
                    this.link.getInterp(linkInterpHdr.getInterpID()).refreshDataRange(wellID, dType, monitor.getLink());
                }
                catch (SBException ex) {
                    monitor.getLink().setHasData(false);
                }
            }
            if (!monitor.getLink().isHasData()) {
                monitor.getLink().setStatusString("(No data)");
                monitor.getLink().setStatus(SbugsStatus.NODATA);
            } else {
                String range = SB.getDepthString((double)monitor.getLink().getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getLink().getDepthTo(), (char)units, (int)2, (char)this.getType());
                monitor.getLink().setStatusString(range);
            }
        }
        return monitor;
    }

    public DTMonitor getNonInterpDataRange(int dType, char units) throws SQLException, SBException {
        String range;
        DTMonitor monitor = this.getMonitor(0, dType);
        if (monitor.getStatus() == UNKNOWN) {
            this.refreshDataRange(dType, monitor);
        }
        if (!monitor.isHasData()) {
            monitor.setStatusString("(No data)");
            monitor.setStatus(SbugsStatus.NODATA);
        } else {
            range = SB.getDepthString((double)monitor.getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getDepthTo(), (char)units, (int)2, (char)this.getType());
            monitor.setStatusString(range);
        }
        if (this.link != null) {
            if (monitor.getLink() == null) {
                monitor.setLink(new DTMonitor());
            }
            if (monitor.getLink().getStatus() == UNKNOWN) {
                try {
                    this.link.refreshDataRange(dType, monitor.getLink());
                }
                catch (SBException ex) {
                    monitor.getLink().setHasData(false);
                }
            }
            if (!monitor.getLink().isHasData()) {
                monitor.getLink().setStatusString("(No data)");
                monitor.getLink().setStatus(SbugsStatus.NODATA);
            } else {
                range = SB.getDepthString((double)monitor.getLink().getDepthFrom(), (char)units, (int)2, (char)this.getType()) + " - " + SB.getDepthString((double)monitor.getLink().getDepthTo(), (char)units, (int)2, (char)this.getType());
                monitor.getLink().setStatusString(range);
            }
        }
        return monitor;
    }

    public List<Integer> writeXML(BufferedWriter out, int indent, char units, Set<Integer> dataTypes, List<File> files) throws IOException, SBException, SQLException {
        String ind = SB.getXMLIndent((int)indent);
        LinkedList<Integer> userIDList = new LinkedList<Integer>();
        out.write(ind + "<WellHeader>\n");
        userIDList.addAll(this.getHeader().writeXML(out, indent + 3));
        out.write(ind + "</WellHeader>\n");
        Iterator<AnalystHeader> ita = this.getAnalystHeaderIterator();
        while (ita.hasNext()) {
            AnalystHeader analyHdr = ita.next();
            out.write(ind + "<AnalystHeader DisciplineID=\"" + analyHdr.getDiscipline().getChar() + "\">\n");
            userIDList.addAll(analyHdr.writeXML(out, indent + 3, units));
            out.write(ind + "</AnalystHeader>\n");
        }
        for (int i = 0; i < this.getSamples().size(); ++i) {
            Sample sample = this.getSamples().get(i);
            out.write(ind + "<Sample Label=\"" + SB.getXMLstring((String)sample.toString(this.getWellUnits())) + "\">\n");
            userIDList.addAll(sample.writeXML(out, indent + 3, this.getWellUnits(), files));
            out.write(ind + "</Sample>\n");
        }
        Iterator<WellInterp> itWellInterp = this.getInterpIterator();
        while (itWellInterp.hasNext()) {
            WellInterp wellInterp = itWellInterp.next();
            if (!wellInterp.hasData()) continue;
            out.write(ind + "<WellInterpretation Description=\"" + SB.getXMLstring((String)wellInterp.getHeader().getDescription()) + "\">\n");
            userIDList.addAll(wellInterp.writeXML(out, units, indent + 3, dataTypes));
            out.write(ind + "</WellInterpretation>\n");
        }
        if (dataTypes.contains(20)) {
            this.getCasing().writeXML(out, indent, units);
        }
        if (dataTypes.contains(19)) {
            this.getCores().writeXML(out, indent, units);
            this.getCoreShift().writeXML(out, indent, units);
        }
        if (dataTypes.contains(24)) {
            this.getMarkers().writeXML(out, indent, units);
        }
        if (dataTypes.contains(25)) {
            this.getTVDlist(false).writeXML(out, indent, units);
        }
        if (dataTypes.contains(26)) {
            this.getTWTlist().writeXML(out, indent, units);
        }
        if (dataTypes.contains(21)) {
            for (LithBase zone : this.getLithIntervals()) {
                if (zone instanceof LithQualifier) continue;
                zone.writeXML(out, indent, units);
            }
            for (LithBase zone : this.getLithIntervals()) {
                if (!(zone instanceof LithQualifier)) continue;
                LithQualifier qual = (LithQualifier)zone;
                qual.writeXML(out, indent, units);
            }
        }
        if (dataTypes.contains(23) && this.curves != null) {
            this.curves.writeXML(out, indent);
        }
        return userIDList;
    }

    WsWell(SBdb db, Element xml, Set<Integer> dataTypes, ZipFile zip, String fileName, int wellID) throws SQLException, SBException, ParseException, SBPermissionException {
        super(db, wellID);
        this.header.setWellName(xml.getAttributeValue("Name"));
        this.header.parseXML(xml.getChild("WellHeader"));
        this.fileName = fileName;
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("AnalystHeader"));
        while (it.hasNext()) {
            this.addAnalystHeader(new AnalystHeader(db, (Element)it.next()));
        }
        this.resetDataMonitors();
        it = xml.getDescendants((Filter)new ElementFilter("Sample"));
        this.getSamples();
        while (it.hasNext()) {
            Sample.Builder builder = new Sample.Builder();
            Sample.parseSample(db, this, this.getType(), (Element)it.next(), dataTypes, zip, builder);
        }
        it = xml.getDescendants((Filter)new ElementFilter("CoredInterval"));
        while (it.hasNext()) {
            this.getCores().add(new CoredInterval(db, (Element)it.next()));
            dataTypes.add(19);
        }
        Element element = xml.getChild("CoreShift");
        if (element != null) {
            this.coreShift = new Coreshift(db, element);
        }
        it = xml.getDescendants((Filter)new ElementFilter("CasingPoint"));
        while (it.hasNext()) {
            if (this.casing == null) {
                this.getCasing();
            }
            this.casing.add(new CasingPoint(db, (Element)it.next()));
            dataTypes.add(20);
        }
        it = xml.getDescendants((Filter)new ElementFilter("SeismicMarker"));
        while (it.hasNext()) {
            if (this.markers == null) {
                this.getMarkers();
            }
            this.markers.add(new SeismicMarker(db, (Element)it.next()));
            dataTypes.add(24);
        }
        it = xml.getDescendants((Filter)new ElementFilter("WellInterpretation"));
        this.loadInterps();
        while (it.hasNext()) {
            WellInterp wellInterp = new WellInterp(db, this, (Element)it.next(), dataTypes);
            LOGGER.log(Level.FINE, "Processing interp: " + String.valueOf(wellInterp));
            Iterator<WellInterp> wit = this.getInterpIterator();
            while (wit.hasNext()) {
                WellInterp interp = wit.next();
                if (interp.interpID != wellInterp.interpID) continue;
                wit.remove();
                break;
            }
            this.interps.add(wellInterp);
            for (int dType : dataTypes) {
                if (!SBdb.isInterpDataType(dType)) continue;
                wellInterp.refreshDataRange(wellID, dType, this.getMonitor(wellInterp.interpID, dType));
            }
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithologyInterval"));
        while (it.hasNext()) {
            if (this.lithIntervals == null) {
                this.getLithIntervals();
            }
            this.insertLithInterval(new LithInterval(db, (Element)it.next()));
            dataTypes.add(21);
        }
        it = xml.getDescendants((Filter)new ElementFilter("LithologyQualifier"));
        while (it.hasNext()) {
            if (this.lithIntervals == null) {
                this.getLithIntervals();
            }
            LithQualifier qual = new LithQualifier(db, (Element)it.next());
            this.insertLithInterval(qual);
            dataTypes.add(21);
        }
        it = xml.getDescendants((Filter)new ElementFilter("DeviationSurvey"));
        while (it.hasNext()) {
            this.TVD = new TVDList(db, false);
            it = xml.getDescendants((Filter)new ElementFilter("TVDData"));
            while (it.hasNext()) {
                TVDepth tvd = new TVDepth((Element)it.next());
                this.TVD.add(tvd);
            }
            dataTypes.add(25);
        }
        it = xml.getDescendants((Filter)new ElementFilter("TWTList"));
        while (it.hasNext()) {
            this.TWT = new TWTList(db);
            it = xml.getDescendants((Filter)new ElementFilter("TWTData"));
            while (it.hasNext()) {
                TWTDepth twt = new TWTDepth((Element)it.next());
                this.TWT.add(twt);
            }
            dataTypes.add(26);
        }
        it = xml.getDescendants((Filter)new ElementFilter("WirelineLog"));
        while (it.hasNext()) {
            this.getCurves().add(Curves.parseCurve((Element)it.next()));
            dataTypes.add(23);
        }
        this.updateStatus(dataTypes);
    }

    void parseXML(String chars, String element) throws ParseException {
        this.getHeader().parseXML(chars, element);
    }

    public Color getStatus() {
        return this.headerStatus;
    }

    public String statusString() {
        if (!(this.link == null || this.link.getWellName().equals(this.getWellName()) && this.link.getWellCode().equals(this.getWellCode()))) {
            return this.header.toString() + " / " + this.link.getHeader().toString();
        }
        return this.toString();
    }

    public void updateHeaderStatus() throws SBException, SQLException {
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating header status...");
        this.headerStatus = this.link == null ? NOTSTORED : WellHeader.getStatus(this.header.getWellHeaderCopy(), this.link.header.getWellHeaderCopy());
    }

    public void setSectionType(char type) throws SBException, SQLException {
        if (this.getType() != type) {
            this.getHeader().setType(SectionType.getSectionType((char)type));
            for (Sample sample : this.getSamples()) {
                sample.setSectionType('O');
            }
        }
    }

    public void setLink(Well linkWell) throws SQLException, SBException {
        if (linkWell != this.link) {
            this.link = linkWell;
            this.resetDataMonitors();
            this.updateStatus();
        }
    }

    public void match(SBdb db, boolean useCode) throws SQLException, SBException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "SELECT well_id FROM " + db.DBTableName("wells") + " WHERE ";
            boolean addedName = false;
            if (!this.getWellName().isEmpty()) {
                sql = sql + " ucase(well_name)=" + SB.DBString((String)this.getWellName().toUpperCase());
                addedName = true;
            }
            if (useCode && this.getWellCode().length() > 0) {
                if (addedName) {
                    sql = sql + " AND ";
                }
                sql = sql + " well_code=" + SB.DBString((String)this.getWellCode());
            }
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            Well linkCandidate = null;
            while (rs.next()) {
                if (linkCandidate == null) {
                    linkCandidate = db.getWell(rs.getInt("well_id"));
                    continue;
                }
                linkCandidate = null;
                break;
            }
            if (linkCandidate != null) {
                this.setLink(linkCandidate);
            }
            rs.close();
        }
    }

    public void unMatch() {
        this.link = null;
    }

    public void unloadData(int dType, int interpID) throws SBException, SQLException {
        if (SBdb.isInterpDataType(dType)) {
            if (this.hasInterpLoaded(interpID)) {
                WellInterp interp = this.getInterp(interpID);
                interp.unloadData(dType);
            }
            return;
        }
        if (!this.getMonitor(interpID, dType).isHasData()) {
            return;
        }
        switch (dType) {
            case 1: {
                this.unloadSamples();
                if (this.getSamples().isEmpty()) break;
                return;
            }
            case 8: {
                this.unloadOccs('A');
                break;
            }
            case 2: {
                this.unloadOccs('M');
                break;
            }
            case 4: {
                this.unloadOccs('N');
                break;
            }
            case 6: {
                this.unloadOccs('P');
                break;
            }
            case 21: {
                this.unloadLithology();
                break;
            }
            case 19: {
                this.getCores().clear();
                break;
            }
            case 20: {
                this.casing.clear();
                break;
            }
            case 24: {
                this.markers.clear();
                break;
            }
            case 25: {
                this.unloadTVDs();
                break;
            }
            case 26: {
                this.unloadTWTs();
                break;
            }
            case 22: {
                this.unloadSampleLithology();
                break;
            }
            case 23: {
                break;
            }
            default: {
                throw new SBException("No status for data type: " + dType);
            }
        }
        this.removeMonitor(interpID, dType);
    }

    public void deleteLinkData(Set<Integer> dataTypes) throws SQLException, SBException {
        block9: for (int i : dataTypes) {
            if (SBdb.isInterpDataType(i)) {
                Iterator<WellInterp> it = this.getInterpIterator();
                while (it.hasNext()) {
                    WellInterp interp = it.next();
                    WellInterp linkInterp = this.link.getAddInterp(interp.getHeader());
                    if (linkInterp == null) {
                        throw new SBException("Attempt to delete linked data for interp: " + String.valueOf(interp) + " - not linked");
                    }
                    linkInterp.deleteLinkData(i, this.link.getWellID());
                }
                continue;
            }
            switch (i) {
                case 1: 
                case 22: {
                    continue block9;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    Sample s = null;
                    Smpdtl d = null;
                    Iterator<Smpdtl> iterator = this.link.getAnalyses(SBdb.dt2discID(i), null, 0).iterator();
                    while (iterator.hasNext()) {
                        Smpdtl dtl;
                        d = dtl = iterator.next();
                        s = dtl.getSample();
                        s.deleteDtl(this.link.getWellID(), dtl.getAnalyID(), dtl);
                    }
                    if (s == null || d == null) continue block9;
                    s.notifyObservers((Object)d);
                    continue block9;
                }
                case 21: {
                    this.link.deleteLithIntervals();
                    continue block9;
                }
                case 19: {
                    Cores.deleteAll(this.link.db, this.link.getWellID());
                    this.link.cores = null;
                    continue block9;
                }
                case 20: {
                    if (this.link.casing == null) continue block9;
                    this.link.casing.deleteAll(this.link.getWellID());
                    this.link.casing = null;
                    continue block9;
                }
                case 24: {
                    if (this.link.markers == null) continue block9;
                    this.link.markers.deleteAll(this.link.getWellID());
                    this.link.markers = null;
                    continue block9;
                }
                case 25: {
                    if (this.link.TVD == null) continue block9;
                    this.link.TVD.deleteAll(this.link.getWellID());
                    this.link.TVD = null;
                    continue block9;
                }
            }
            LOGGER.log(Level.WARNING, "Unrecognised data type in WsWell.deleteLinkData(): " + SBdb.dTypeNames[i]);
        }
        this.link.db.commit();
    }

    public void store(Set<Integer> dataTypes) throws SBException, SQLException, IOException, SBPermissionException {
        if (this.link == null) {
            throw new SBException("Attempt to store well with no linked well");
        }
        if (this.headerStatus == PARTSTORED) {
            this.link.updateHeaderFromLink(this.getHeader().getWellHeaderCopy());
        }
        boolean storeAges = false;
        if (dataTypes.contains(29)) {
            if (this.getInterp(0).getHeader().getLink() == null) {
                throw new SBException("Can't store sample ages - Version not linked - see Match | Versions");
            }
            storeAges = true;
        }
        try (Statement stmt = this.link.db.getDatabase().createStatement();){
            MatchData matchSamples = new MatchData();
            matchSamples.init(this.getSamples(), this.link.getSamples());
            boolean storeLiths = dataTypes.contains(22);
            SampleLithology notifier = null;
            for (int row = 0; row < matchSamples.size(); ++row) {
                MatchData.MatchPair pair = matchSamples.get(row);
                Sample ws = (Sample)pair.getWs();
                Sample dbSample = (Sample)pair.getDb();
                if (ws == null) continue;
                if (dbSample == null) {
                    dbSample = this.link.checkSample(Sample.copyToDatabase(this.link.db, ws));
                    if (dbSample == null) {
                        dbSample = this.link.addSample(Sample.copyToDatabase(this.link.db, ws), 0, stmt);
                    }
                    ws.link = dbSample;
                    ws.status = Sample.STORED;
                } else if (ws.getStatus() == Sample.PARTSTORED) {
                    dbSample.update(this.link, ws);
                }
                if (storeLiths && ws.getLithology() != null) {
                    dbSample.updateLithology(ws.getLithology().lithology, this.link.getWellID());
                    notifier = dbSample.getLithology();
                }
                if (!storeAges || ws.getAge(0) == null) continue;
                SampleAge a = ws.getSampleAge(0);
                dbSample.setAge(this.getInterp(0).getHeader().getLink().getInterpID(), a.age, a.ageBelow, a.ageErrorPlus, a.ageErrorMinus, a.ratio, this.link.getID());
            }
            if (storeLiths) {
                this.link.setDataChanged();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.link.notifyObservers(notifier);
                }
            }
            Audit.setServerDate(this.link.getDataModel(), stmt);
            MatchData matchSmpdtls = new MatchData();
            for (int i = 0; i < SBdb.discArr.length; ++i) {
                char discID = SBdb.discArr[i];
                int dType = SBdb.did2dtype(discID);
                if (!dataTypes.contains(dType)) continue;
                matchSmpdtls.init(this.getAnalyses(discID, null, 0), this.link.getAnalyses(discID, null, 0));
                for (int row = 0; row < matchSmpdtls.size(); ++row) {
                    MatchData.MatchPair pair = matchSmpdtls.get(row);
                    Smpdtl ws = (Smpdtl)pair.getWs();
                    if (ws == null) continue;
                    Smpdtl dbSmpdtl = (Smpdtl)pair.getDb();
                    AnalystHeader hdr = this.link.getAnalystHeader(ws.getAnalystAbr(), ws.getDiscID(), ws.getAnalyNo(), false);
                    if (dbSmpdtl == null) {
                        Sample wsSample = ws.getSample();
                        Sample dbSample = wsSample.getLink();
                        if (dbSample == null) {
                            dbSample = this.link.addSample(Sample.copyToDatabase(this.link.db, wsSample), 0, stmt);
                            wsSample.status = Sample.STORED;
                            wsSample.link = dbSample;
                        }
                        if (hdr == null) {
                            wsHdr = this.getAnalystHeader(ws.getAnalystAbr(), ws.getDiscID(), ws.getAnalyNo(), false);
                            if (wsHdr == null) {
                                hdr = this.link.getAnalystHeader(ws.getAnalystAbr(), ws.getDiscID(), ws.getAnalyNo(), true);
                            } else {
                                int envSchID = -1;
                                int abnSchID = -1;
                                if (wsHdr.getEnvSchID() > 0) {
                                    EnvScheme envScheme = this.db.getEnvScheme(wsHdr.getEnvSchID());
                                    if (envScheme == null) {
                                        throw new SBException("Error in well: " + this.getWellName() + ". Palaeoeonvironment scheme from analyst header not found in workspace: " + wsHdr.getEnvSchID());
                                    }
                                    if (envScheme.getLink() == null) {
                                        throw new SBException("Cannot store well: " + this.getWellName() + ". Palaeoenvironment scheme not matched: " + envScheme.toString());
                                    }
                                    envSchID = envScheme.getLink().getID();
                                }
                                if (wsHdr.getAbnSchID() > 0) {
                                    AbundanceScheme abnScheme = this.db.getAbundanceSchemeService().findAbundanceScheme(wsHdr.getAbnSchID()).orElse(null);
                                    AbundanceScheme link = ((AbundanceSchemeServiceImpl)this.db.getAbundanceSchemeService()).getLinkObject(wsHdr.getAbnSchID());
                                    if (abnScheme == null) {
                                        throw new SBException("Error in well: " + this.getWellName() + ". Abundance scheme from analyst header not found in workspace: " + wsHdr.getAbnSchID());
                                    }
                                    if (link == null) {
                                        throw new SBException("Cannot store well: " + this.getWellName() + ". Abundance scheme not matched: " + abnScheme.toString());
                                    }
                                    abnSchID = link.getAbnSchID();
                                }
                                hdr = this.link.addAnalystHeader(ws.getAnalystAbr(), ws.getDiscID(), ws.getAnalyNo(), wsHdr.getDepthFrom(), wsHdr.getDepthTo(), wsHdr.getDateFrom(), wsHdr.getDateTo(), wsHdr.getComments(), envSchID, abnSchID, Color.BLACK);
                            }
                        } else {
                            wsHdr = this.getAnalystHeader(ws.getAnalystAbr(), ws.getDiscID(), ws.getAnalyNo(), false);
                            if (wsHdr.getStatus() == SbugsStatus.CONFLICT) {
                                throw new SBException("Cannot save analyses due to conflict in analyst headers");
                            }
                            if (wsHdr.getAbnSchID() > 0 && hdr.getAbnSchID() == 0) {
                                Integer linkAbnSchID = ((AbundanceSchemeServiceImpl)this.db.getAbundanceSchemeService()).getLink(wsHdr.getAbnSchID());
                                hdr.setAbnScheme(this.link.getWellID(), linkAbnSchID);
                            }
                        }
                        dbSmpdtl = new Smpdtl(stmt, this.link.getDataModel(), this.db, ws, this.link.getWellID(), dbSample.getSampID(), hdr);
                        this.link.addSmpdtl(dbSample, dbSmpdtl);
                    } else if (ws.getStatus() == Smpdtl.PARTSTORED) {
                        dbSmpdtl.update(this.link.getWellID(), ws);
                    }
                    ws.status = Smpdtl.STORED;
                }
            }
            this.link.setDataChanged();
            if (SwingUtilities.isEventDispatchThread()) {
                this.link.notifyObservers(Sample.class);
            }
        }
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            WellInterp wellInterp = it.next();
            if (wellInterp.getHeader().getLink() == null) {
                LOGGER.log(Level.FINE, "Can't store wellInterp : " + wellInterp.getHeader().getDescription() + " - not linked. (or no interpreted data)");
                continue;
            }
            WellInterp linkedInterp = this.link.getAddInterp(wellInterp.getHeader().getLink());
            linkedInterp.store(wellInterp, this.link.getWellID(), dataTypes, this.getDataModel());
            if (!SwingUtilities.isEventDispatchThread()) continue;
            linkedInterp.notifyObservers(linkedInterp);
        }
        block21: for (int dType : dataTypes) {
            switch (dType) {
                case 20: {
                    if (this.casing == null) continue block21;
                    this.link.storeCasing(this.db, this.casing);
                    break;
                }
                case 19: {
                    if (this.getCores() != null) {
                        this.link.storeCores(this.db, this.getCores());
                    }
                    if (this.coreShift == null) continue block21;
                    this.link.storeCoreshift(this.db, this.coreShift);
                    break;
                }
                case 24: {
                    if (this.markers == null) continue block21;
                    this.link.storeMarkers(this.db, this.markers);
                    break;
                }
                case 21: {
                    if (this.lithIntervals == null) continue block21;
                    try {
                        this.link.storeLithology(this.db, this.lithIntervals);
                        break;
                    }
                    catch (InvalidFieldException e) {
                        throw new SBException(e.getMessage());
                    }
                }
                case 25: {
                    if (this.TVD == null) continue block21;
                    this.link.storeTVD(this.db, this.TVD);
                    break;
                }
                case 26: {
                    if (this.TWT == null) continue block21;
                    this.link.storeTWT(this.db, this.TWT);
                    break;
                }
                case 23: {
                    block22: for (Curve curve : this.curves.getCurves()) {
                        String linkAbr = this.db.getLogDef(curve.getAbr()).getLink().getAbr();
                        String curveSortEntry = curve.getSortEntry(linkAbr);
                        for (Curve stored : this.link.getCurves().getCurves()) {
                            if (!stored.getSortEntry(stored.getAbr()).equals(curveSortEntry)) continue;
                            continue block22;
                        }
                        Curve dbCopy = Curve.copyOf((Curve)curve, (int)0, (AuditImpl)new AuditImpl(), (String)linkAbr);
                        this.link.addCurve(dbCopy);
                    }
                    continue block21;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 22: {
                    break;
                }
                default: {
                    if (SBdb.isInterpDataType(dType)) continue block21;
                    LOGGER.log(Level.WARNING, "WsWell: Cannot store data type: " + dType);
                }
            }
        }
        Audit.setServerDate(this.link.getDataModel(), null);
        this.resetDataMonitors();
        this.updateStatus();
        if (SwingUtilities.isEventDispatchThread()) {
            this.link.notifyObservers();
        }
    }

    public void storeLithology() throws SQLException, SBException, InvalidFieldException {
        if (this.lithIntervals != null) {
            this.link.storeLithology(this.db, this.lithIntervals);
        }
    }

    void unloadIGD(int igdType) {
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            WellInterp in = it.next();
            List<IGDIntervalZone> vect = in.getIGDList(igdType, 0);
            vect.clear();
        }
    }

    private void unloadSamples() throws SQLException, SBException {
        LinkedList<Sample> toKill = new LinkedList<Sample>();
        block2: for (Sample sample : this.getSamples()) {
            if (!sample.getSmpdtls().isEmpty() || sample.getLithology() != null && !sample.getLithology().lithology.isEmpty()) continue;
            Iterator<WellInterp> it = this.getInterpIterator();
            while (it.hasNext()) {
                WellInterp interp = it.next();
                if (interp.hasSampleIGD(sample) <= 0) continue;
                continue block2;
            }
            toKill.add(sample);
        }
        try {
            this.deleteSamples(toKill);
        }
        catch (SBPermissionException pe) {
            throw new SBException("Unexpected permission exception in workspace", (Throwable)pe);
        }
    }

    void unloadTVDs() {
        this.TVD.clear();
    }

    void unloadTWTs() {
        this.TWT.clear();
    }

    void unloadLithology() {
        this.lithIntervals.clear();
    }

    @Override
    public void loadSamples() {
        if (this.link != null) {
            // empty if block
        }
    }

    void unloadOccs(char discID) throws SQLException, SBException {
        for (Sample sample : this.getSamples()) {
            Iterator<Smpdtl> it = sample.analyses.iterator();
            while (it.hasNext()) {
                Smpdtl smpdtl = it.next();
                if (smpdtl.getDiscID() != discID) continue;
                it.remove();
            }
        }
    }

    void unloadSampleLithology() throws SQLException, SBException {
        for (Sample sample : this.getSamples()) {
            sample.deleteLithology(0);
        }
    }

    public void updateInterpStatus(WellInterp interp, char units) throws SBException, SQLException {
        InterpHdr linkInterpHdr = interp.getHeader().getLink();
        if (this.link == null) {
            linkInterpHdr = null;
        }
        if (linkInterpHdr != null) {
            try {
                WellInterp linkInterp = this.link.getInterp(linkInterpHdr.getInterpID());
                linkInterp.load(this.link);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "link well " + String.valueOf(this.link) + " did not have interp " + String.valueOf(linkInterpHdr) + "; updating interp status for internal consistency");
                this.link.getAddInterp(linkInterpHdr, false);
            }
        }
        this.updateAllZonesStatus(interp, linkInterpHdr, units, true);
        this.updateAllBCMStatus(interp, linkInterpHdr, units, true);
        this.updateEnvStatus(interp, linkInterpHdr, units, true);
        this.updateSQPickStatus(interp, linkInterpHdr, units, true);
        this.updateEventsStatus(interp, linkInterpHdr, units, true);
        this.updateIntcomStatus(interp, linkInterpHdr, units, true);
        this.updateLOCStatus(interp, linkInterpHdr, units, true);
        this.updateFaultStatus(interp, linkInterpHdr, units, true);
    }

    public void updateInterpTypeStatus(WellInterp interp, int dType, char units) throws SBException, SQLException {
        InterpHdr linkInterpHdr = interp.getHeader().getLink();
        if (this.link == null) {
            linkInterpHdr = null;
        }
        if (linkInterpHdr != null) {
            try {
                this.link.getInterp(linkInterpHdr.getInterpID()).load(this.link);
            }
            catch (Exception ex) {
                linkInterpHdr = null;
            }
        }
        switch (dType) {
            case 10: 
            case 11: 
            case 12: {
                this.updateAllZonesStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                this.updateAllBCMStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 15: {
                this.updateEnvStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 14: {
                this.updateSQPickStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 16: {
                this.updateEventsStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 18: {
                this.updateIntcomStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 17: {
                this.updateLOCStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 27: {
                this.updateFaultStatus(interp, linkInterpHdr, units, true);
                break;
            }
            case 29: {
                this.updateSampleAgeStatus(interp, linkInterpHdr, units, true);
                break;
            }
            default: {
                throw new SBException("Unknown data type in updateInterpType: " + dType);
            }
        }
    }

    public void updateLOCStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        if (interp.getLOC() == null) {
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating LOC status...");
        DTMonitor monitor = this.getMonitor(interp.interpID, 17);
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 17, units);
        if (interp.getLOC() != null && monitor != null) {
            monitor.setStatus(UNKNOWN);
            if (linkInterpHdr != null && this.link.getInterp(linkInterpHdr.getInterpID()).getLOC() != null) {
                interp.getLOC().updateStatus(this.link.getAddInterp(linkInterpHdr).getLOC());
            } else {
                interp.getLOC().status = LOC.NOTSTORED;
            }
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)interp.getLOC().getStatus()));
        }
    }

    public void updateAllZonesStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        for (Integer igdType : interp.getZoneTypes()) {
            this.updateZoneStatus(interp, linkInterpHdr, igdType, units, reloadRange);
        }
    }

    public void updateZoneStatus(WellInterp interp, InterpHdr linkInterpHdr, int igdType, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, IGDInterval.igdType2dType(igdType));
        if (interp.getIGDList(igdType).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating " + SBdb.dTypeNames[IGDInterval.igdType2dType(igdType)] + " status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, IGDInterval.igdType2dType(igdType), units);
        if (!interp.getIGDList(igdType).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            for (IGDIntervalZone zone : interp.getIGDList(igdType)) {
                zone.updateStatus(interp.getIGDList(igdType), true);
                if (this.link != null && linkInterpHdr != null && zone.status != CONFLICT) {
                    zone.updateStatus(this.link.getAddInterp(linkInterpHdr).getIGDList(igdType, 0), false);
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)zone.getStatus()));
            }
        }
    }

    public void updateAllBCMStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        for (int i = 0; i < 4; ++i) {
            char discID = SBdb.discArr[i];
            this.updateBCMStatus(interp, linkInterpHdr, discID, units, true);
        }
    }

    public void updateBCMStatus(WellInterp interp, InterpHdr linkInterpHdr, char discID, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, SBdb.did2comType(discID));
        if (interp.getComments(discID).isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating " + SBdb.getDiscAdj(discID) + " comments...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, SBdb.did2comType(discID), units);
        if (!interp.getComments().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            for (Biocom comment : interp.getComments()) {
                if (comment.getDiscID() != discID) continue;
                comment.updateStatus(interp.getComments());
                if (linkInterpHdr != null && comment.status != CONFLICT) {
                    comment.updateStatus(this.link.getAddInterp(linkInterpHdr).getComments());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)comment.getStatus()));
            }
        }
    }

    public void updateEnvStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 15);
        if (interp.getEnvs() == null || interp.getEnvs().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating Envs status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 15, units);
        if (!interp.getEnvs().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            for (IGDIntervalEnv env : interp.getEnvs()) {
                env.updateStatus(interp.getEnvs());
                if (linkInterpHdr != null && env.status != CONFLICT) {
                    env.updateStatus(this.link.getAddInterp(linkInterpHdr).getEnvs());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)env.status));
            }
        }
    }

    public void updateSQPickStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 14);
        if (interp.getSQPicks().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating SQPick status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 14, units);
        if (interp.getSQPicks() != null) {
            monitor.setStatus(UNKNOWN);
            for (SQPick pick : interp.getSQPicks()) {
                pick.updateStatus(interp.getSQPicks());
                if (linkInterpHdr != null && pick.status != CONFLICT) {
                    pick.updateStatus(this.link.getAddInterp(linkInterpHdr).getSQPicks());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)pick.getStatus()));
            }
        }
    }

    public void updateFaultStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 27);
        if (interp.getFaults().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating disconformities status...");
        if (reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 27, units);
        if (interp.getFaults() != null) {
            monitor.setStatus(UNKNOWN);
            for (Fault fault : interp.getFaults()) {
                fault.updateStatus(interp.getFaults());
                if (linkInterpHdr != null && fault.getStatus() != CONFLICT) {
                    fault.updateStatus(this.link.getAddInterp(linkInterpHdr).getFaults());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)fault.getStatus()));
            }
        }
    }

    public void updateSampleAgeStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 29);
        boolean hasSampleAges = false;
        for (Sample sample : this.getSamples()) {
            if (!sample.hasAgeData(interp)) continue;
            hasSampleAges = true;
            break;
        }
        if (!hasSampleAges) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating sample ages status...");
        if (reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 29, units);
    }

    public void updateEventsStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 16);
        if (interp.getEvents().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating Events status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 16, units);
        if (interp.getEvents().size() > 0) {
            monitor.setStatus(UNKNOWN);
            for (WellEvent event : interp.getEvents()) {
                event.updateStatus(interp.getEvents());
                if (linkInterpHdr != null && event.status != CONFLICT) {
                    event.updateStatus(this.link.getAddInterp(linkInterpHdr).getEvents());
                }
                monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)event.getStatus()));
            }
        }
    }

    public void updateIntcomStatus(WellInterp interp, InterpHdr linkInterpHdr, char units, boolean reloadRange) throws SBException, SQLException {
        DTMonitor monitor = this.getMonitor(interp.interpID, 18);
        if (interp.getAllIntcoms().isEmpty()) {
            monitor.setStatus(UNKNOWN);
            monitor.setHasData(false);
            return;
        }
        LOGGER.log(Level.FINE, "WsWell " + this.getWellName() + " updating intcom status...");
        if (monitor != null && reloadRange) {
            monitor.setStatus(DTMonitor.UNKNOWN);
            if (monitor.getLink() != null) {
                monitor.getLink().setStatus(DTMonitor.UNKNOWN);
            }
        }
        this.getInterpDataRange(interp, this.link != null ? this.link.getWellID() : 0, 18, units);
        monitor.setStatus(UNKNOWN);
        for (Intcom intcom : interp.getAllIntcoms()) {
            intcom.updateStatus(interp.getIntcoms(intcom.getIGDType()));
            if (linkInterpHdr != null && intcom.getStatus() != CONFLICT) {
                intcom.updateStatus(this.link.getAddInterp(linkInterpHdr).getIntcoms(intcom.getIGDType()));
            }
            monitor.setStatus(MergeStatus.merge((Color)monitor.getStatus(), (Color)intcom.getStatus()));
        }
    }

    public void fillData(Set<Integer> dataTypes, int synSchID) throws SQLException, SBException {
        if (this.link == null) {
            return;
        }
        if (this.link.getHeader().getCreator() > 0) {
            this.db.fillUser(this.link.getDataModel(), this.link.getHeader().getCreator());
        }
        if (this.link.getHeader().getModifier() > 0) {
            this.db.fillUser(this.link.getDataModel(), this.link.getHeader().getModifier());
        }
        if (dataTypes.contains(4) || dataTypes.contains(2) || dataTypes.contains(6) || dataTypes.contains(8)) {
            this.link.loadAnalystHeaders();
            this.getAnalystHeaders();
            Iterator<AnalystHeader> itHdr = this.link.getAnalystHeaderIterator();
            while (itHdr.hasNext()) {
                AnalystHeader analyHdr = itHdr.next();
                if (!(dataTypes.contains(2) && analyHdr.getDiscipline() == Discipline.MICRO || dataTypes.contains(4) && analyHdr.getDiscipline() == Discipline.NANNO || dataTypes.contains(6) && analyHdr.getDiscipline() == Discipline.PALY) && (!dataTypes.contains(8) || analyHdr.getDiscipline() != Discipline.MACRO) || !analyHdr.hasData(this.link.getWellID())) continue;
                AnalystHeader wsAnalyHdr = AnalystHeader.copyToWorkspace(this.db, analyHdr);
                this.addAnalystHeader(wsAnalyHdr);
            }
        }
        Iterator<Sample> it = this.link.getSamples().iterator();
        if (dataTypes.contains(1)) {
            while (it.hasNext()) {
                Sample dbSample = it.next();
                if (this.hasSample(dbSample)) continue;
                this.addSampleCopy(null, dbSample);
            }
        }
        if (dataTypes.contains(2) || dataTypes.contains(4) || dataTypes.contains(6) || dataTypes.contains(8)) {
            this.link.loadAnalyses();
            it = this.link.getSamples().iterator();
            assert (this.link != null && this.link.getDataModel() != null && this.link.getDataModel().getDatabase() != null);
            Statement dbStmt = this.link.getDataModel().getDatabase().createStatement();
            while (it.hasNext()) {
                Sample dbSample = it.next();
                if (dbSample.getSmpdtls().isEmpty()) continue;
                for (Smpdtl smpdtl : dbSample.getSmpdtls()) {
                    if (!(dataTypes.contains(2) && smpdtl.getDiscID() == 'M' || dataTypes.contains(4) && smpdtl.getDiscID() == 'N' || dataTypes.contains(6) && smpdtl.getDiscID() == 'P') && (!dataTypes.contains(8) || smpdtl.getDiscID() != 'A')) continue;
                    Sample wsSample = !this.hasSample(dbSample) ? this.addSampleCopy(null, dbSample) : this.getSample(dbSample.getSampID());
                    try {
                        AnalystHeader wsHeader = this.getAnalystHeader(smpdtl.getAnalyID(), false);
                        Smpdtl existing = wsSample.getSmpdtl(smpdtl.getDiscID(), wsHeader.getAnalyst(), wsHeader.getAnalyNumber());
                        if (existing != null) {
                            wsSample.deleteDtl(0, 0, existing);
                        }
                        Smpdtl wsSmpdtl = new Smpdtl(this.db, smpdtl, wsSample, wsHeader);
                        wsSmpdtl.fillOccurrences(dbStmt, synSchID);
                        wsSample.insert(wsSmpdtl);
                    }
                    catch (Exception e) {
                        StackError.showStackError((String)"Error creating sample detail", (Throwable)e);
                    }
                }
            }
            dbStmt.close();
        }
        if (dataTypes.contains(22)) {
            for (Sample dbSample : this.link.getSamples()) {
                if (dbSample.getLithology() == null || dbSample.getLithology().getLithology().isEmpty()) continue;
                dbSample.loadLithology(this.link.getWellID(), this.link.getDataModel().getLithdesc());
                Sample wsSample = !this.hasSample(dbSample) ? this.addSampleCopy(null, dbSample) : this.getSample(dbSample.getSampID());
                wsSample.copyLithology(dbSample.getLithology());
            }
        }
        block17: for (int dType : dataTypes) {
            if (SBdb.isInterpDataType(dType)) continue;
            switch (dType) {
                default: {
                    throw new SBException("Cannot process data type: " + dType + " in WsWell.fillData");
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 22: {
                    break;
                }
                case 26: {
                    if (this.link.getTWTlist().getSize() <= 0) continue block17;
                    this.TWT = new TWTList(this.db);
                    for (int i = 0; i < this.link.getTWTlist().getSize(); ++i) {
                        this.TWT.add(this.link.getTWTlist().get(i));
                    }
                    continue block17;
                }
                case 20: {
                    this.link.getCasing().load(this.link.getWellID());
                    this.fillCasing(this.link.getCasing().getList());
                    break;
                }
                case 19: {
                    this.fillCores(this.link.getCores().getList(), this.link.getCoreImages(), true);
                    break;
                }
                case 24: {
                    this.fillMarkers(this.link.getMarkers().getList());
                    break;
                }
                case 25: {
                    this.fillTVD(false);
                    break;
                }
                case 21: {
                    this.fillLithology(this.link.getLithIntervals());
                    break;
                }
                case 23: {
                    for (Curve curve : this.link.getCurves().getCurves()) {
                        this.fillCurves(curve.getAbr());
                    }
                    continue block17;
                }
            }
        }
        this.resetDataMonitors();
        this.updateStatus(dataTypes);
    }

    public void fillCurves(String abr) throws SQLException, SBException {
        block0: for (Curve curve : this.link.getCurves().getCurves()) {
            if (!curve.getAbr().equals(abr)) continue;
            for (Curve existing : this.getCurves().getCurves()) {
                if (existing.getID() != curve.getID()) continue;
                continue block0;
            }
            this.db.fillLogDef(this.link.getDataModel().getLogDef(abr));
            this.getCurves().add(Curve.copyOf((Curve)curve, (int)curve.getID(), (AuditImpl)new AuditImpl(), (String)curve.getAbr()));
        }
    }

    public void fillTVD(boolean plan) throws SQLException, SBException {
        if (!plan && this.TVD != null || plan && this.TVDplan != null) {
            return;
        }
        if (this.link.getTVDlist(false).getSize() > 0) {
            TVDList list = new TVDList(this.db, false);
            for (int i = 0; i < this.link.getTVDlist(plan).getSize(); ++i) {
                list.add(new TVDepth(this.link.getTVDlist(plan).get(i)));
            }
            if (plan) {
                this.TVDplan = list;
            } else {
                this.TVD = list;
            }
        }
    }

    public void fillCasing(List<CasingPoint> list) throws SBException {
        if (this.casing == null) {
            this.casing = new Casing(this.db);
        }
        block0: for (CasingPoint casingPoint : list) {
            for (CasingPoint existing : this.casing.getList()) {
                if (!existing.getSortEntry().equals(casingPoint.getSortEntry())) continue;
                continue block0;
            }
            CasingPoint wsCasingPoint = new CasingPoint(casingPoint);
            this.casing.add(wsCasingPoint);
        }
    }

    public void fillMarkers(List<SeismicMarker> list) throws SBException {
        boolean check = true;
        if (this.markers == null) {
            this.markers = new Markers(this.db);
            check = false;
        }
        block0: for (SeismicMarker marker : list) {
            if (check) {
                for (SeismicMarker existing : this.markers.getList()) {
                    if (!(Math.abs(existing.getDepth() - marker.getDepth()) < (double)0.0029f)) continue;
                    continue block0;
                }
            }
            this.markers.add(new SeismicMarker(marker));
        }
    }

    public void fillLithology(List<LithBase> dbLithBases) throws SQLException {
        boolean checkExisting;
        boolean bl = checkExisting = this.lithIntervals != null;
        if (!checkExisting) {
            this.getLithIntervals();
        }
        block0: for (LithBase lithInterval : dbLithBases) {
            if (checkExisting) {
                for (LithBase existing : this.lithIntervals) {
                    if (existing.getClass() != lithInterval.getClass() || !(Math.abs(existing.topDepth - lithInterval.topDepth) < (double)0.0029f)) continue;
                    continue block0;
                }
            }
            LithBase wsLithInterval = lithInterval instanceof LithQualifier ? new LithQualifier(this.db, (LithQualifier)lithInterval) : new LithInterval(this.db, (LithInterval)lithInterval);
            this.lithIntervals.add(wsLithInterval);
        }
    }

    public void fillCores(List<CoredInterval> cores, List<CoreImage> coreImages, boolean coreShift) throws SBException, SQLException {
        if (cores != null && !cores.isEmpty()) {
            if (this.cores == null) {
                this.cores = new Cores(this.db);
            }
            for (CoredInterval coredInterval : cores) {
                CoredInterval wsCoredInterval = new CoredInterval(coredInterval);
                try {
                    this.cores.add(wsCoredInterval);
                }
                catch (SBException sBException) {}
            }
        }
        if (coreImages != null && !coreImages.isEmpty()) {
            if (this.coreImages == null) {
                this.coreImages = new LinkedList();
            }
            block3: for (CoreImage coreImage : coreImages) {
                for (CoreImage existing : this.coreImages) {
                    if (!(Math.abs(existing.getTopDepth() - coreImage.getTopDepth()) < 0.01)) continue;
                    continue block3;
                }
                CoreImage wsCoreImage = new CoreImage(this.db, coreImage);
                this.coreImages.add(wsCoreImage);
            }
        }
        if (coreShift && this.link.hasShifts() && this.coreShift == null) {
            this.coreShift = new Coreshift(this.link.getCoreShift());
        }
    }

    public void fillAnalyses(List<Smpdtl> dbDtls, boolean occurrences, int synSchID) throws SQLException, SBException {
        Statement dbStmt = this.link.getDataModel().getDatabase().createStatement();
        for (Smpdtl smpdtl : dbDtls) {
            Sample dbSample = smpdtl.getSample();
            Sample wsSample = !this.hasSample(dbSample) ? this.addSampleCopy(null, dbSample) : this.getSample(dbSample.getSampID());
            if (this.db.getUser(smpdtl.getHeader().getAnalystUsrid()) == null) {
                this.db.fillUser(this.link.db, smpdtl.getHeader().getAnalystUsrid());
            }
            AnalystHeader wsHeader = this.getAnalystHeader(smpdtl.getHeader().getAnalyst(), smpdtl.getDiscID(), smpdtl.getAnalyNo(), true);
            Smpdtl wsDtl = wsSample.getSmpdtl(smpdtl.getDiscID(), wsHeader.getAnalyst(), wsHeader.getAnalyNumber());
            if (wsDtl != null) {
                if (!occurrences || wsDtl.getNOccs() != 0) continue;
                wsDtl.fillOccurrences(dbStmt, synSchID);
                continue;
            }
            wsDtl = new Smpdtl(this.db, smpdtl, wsSample, wsHeader);
            if (occurrences) {
                wsDtl.fillOccurrences(dbStmt, synSchID);
            }
            wsSample.insert(wsDtl);
        }
        dbStmt.close();
    }

    public Sample fillSample(int sampID) throws SQLException, SBException {
        this.getSamples();
        Sample wsSample = this.getSample(sampID);
        if (wsSample == null) {
            Sample dbSample = this.link.getSample(sampID);
            wsSample = this.addSampleCopy(null, dbSample);
        }
        return wsSample;
    }

    public void fillData(Set<Integer> dataTypes, InterpHdr wsHdr) throws SQLException, SBException, SBPermissionException {
        if (this.link == null) {
            return;
        }
        WellInterp wsWellInterp = null;
        Iterator<WellInterp> it = this.getInterpIterator();
        while (it.hasNext()) {
            WellInterp wsInterp = it.next();
            if (wsInterp.getHeader().getInterpID() != wsHdr.getInterpID()) continue;
            wsWellInterp = wsInterp;
            break;
        }
        if (wsWellInterp == null) {
            LOGGER.log(Level.FINE, "Adding Interp in wsWell.fillData: " + wsHdr.toString());
            wsWellInterp = new WellInterp(this.db, this.link.getInterp(wsHdr.getLink().getInterpID()), wsHdr);
            this.interps.add(wsWellInterp);
        }
        WellInterp dbWellInterp = this.link.getInterp(wsHdr.getLink().getInterpID());
        wsWellInterp.fillWorkspace(dataTypes, dbWellInterp, this, this.link);
        this.resetDataMonitors();
        this.updateStatus(dataTypes);
    }

    public boolean hasSample(Sample sample) throws SQLException, SBException {
        for (Sample current : this.getSamples()) {
            if (sample.getSampID() != current.getSampID()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTDorTop() {
        if (this.getType() == 'W' && this.getHeader().getTD() < (double)0.0029f) {
            return false;
        }
        return this.getType() != 'O' || !(this.getHeader().getKickoValue() > (double)0.0029f);
    }

    @Override
    public Sample addSampleCopy(Statement stmt, Sample dbSample) throws SampleInsertException, SBException, SQLException {
        Sample wsSample;
        assert (!this.db.isConnected());
        Sample.Builder builder = Sample.copyToWorkspace(this.db, dbSample);
        try {
            wsSample = this.addSample(builder, dbSample.getSampID(), null);
            wsSample.setLink(dbSample);
        }
        catch (SBPermissionException e) {
            throw new IllegalStateException("Unexpected exception in workspace", e);
        }
        wsSample.status = SbugsStatus.STORED;
        return wsSample;
    }

    @Override
    public Sample addSample(Double topDepth, Double baseDepth, String sampleType, String label) throws SQLException, SampleInsertException {
        try {
            return super.addSample(topDepth, baseDepth, sampleType, label);
        }
        catch (SBPermissionException pe) {
            throw new IllegalStateException("Unexpected PermissionException in workspace", pe);
        }
    }

    @Override
    public Coreshift getCoreShift() throws SQLException {
        if (this.link != null) {
            return this.link.getCoreShift();
        }
        return super.getCoreShift();
    }
}

