/*
 * Decompiled with CFR 0.152.
 */
package model3.wellinterp;

import com.stratadata.model3.Discipline;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Objects;
import java.util.Set;
import model3.Biocom;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WsWell;
import model3.wellinterp.InterpEdit;
import model3.wellinterp.InterpList;
import model3.wellinterp.InterpListObserver;
import model3.wellinterp.RefreshKey;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class BiocomList
extends InterpList<Biocom> {
    public BiocomList(int interpID, InterpListObserver observer) {
        super(interpID, observer);
    }

    @Override
    public String getItemDescriptor() {
        return "biostratigraphic comment";
    }

    @Override
    String getAuditType() {
        return "BIOCOM";
    }

    @Override
    String getTableName() {
        return "BCMMNTS";
    }

    @Override
    public void load(Well well) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InterpEdit<Biocom> add() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BiocomEdit add(Biocom.Builder builder, int wellID, SBdb sbdb) throws InvalidFieldException, SQLException, SBException {
        this.checkExisting(builder);
        BiocomEdit edit = new BiocomEdit(this, wellID, null, builder, sbdb);
        edit.doEdit();
        return edit;
    }

    public Biocom update(Biocom biocomToUpdate, int wellID, Discipline discID, Sample topSample, Sample baseSample, String analyst, String dataSource, String text, SBdb sbdb) throws SQLException, InvalidFieldException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BiocomEdit update(Biocom original, Biocom.Builder builder, int wellID, SBdb sbdb) throws SBException, SQLException, InvalidFieldException {
        if (original != null && (original.getAnalyst() != builder.getAnalyst() || original.getTopSample().getSampID() != builder.getTopSample().getSampID() || original.getDiscID() != builder.getDiscID())) {
            this.checkExisting(builder);
        }
        BiocomEdit edit = new BiocomEdit(this, wellID, original, builder, sbdb);
        edit.doEdit();
        return edit;
    }

    private void checkExisting(Biocom.Builder builder) throws InvalidFieldException {
        for (Biocom biocom : this.getItems()) {
            if (biocom.getTopID() != builder.getTopSample().getSampID() || biocom.getDiscipline() != builder.getDiscipline() || biocom.getAnalyst() != builder.getAnalyst()) continue;
            throw new InvalidFieldException("A comment of this discipline/depth/analyst already exists");
        }
    }

    public InterpEdit<Biocom> delete(Biocom biocom, int wellID, SBdb sbdb) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getRefreshQueryString(SBdb sbdb, int wellID, int interpID) {
        return "SELECT usamp_id,disc_id,analyst,updated FROM " + sbdb.DBTableName("BCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
    }

    @Override
    RefreshKey<Biocom> getRefreshKey(ResultSet rs) throws SQLException {
        final int sampID = rs.getInt("usamp_id");
        final Discipline discID = Discipline.getDisc((char)SB.getDBChar((ResultSet)rs, (String)"disc_id"));
        final int analystID = rs.getInt("analyst");
        return new RefreshKey<Biocom>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public String getKey() {
                return "" + discID.getChar() + sampID + analystID;
            }

            @Override
            public boolean matches(Biocom b) {
                return b.getTopID() == sampID && b.getDiscipline() == discID && b.getAnalyst() == analystID;
            }

            @Override
            public int getSampID() {
                return sampID;
            }

            @Override
            public Discipline getDiscID() {
                return discID;
            }

            @Override
            public Integer getAnalystID() {
                return analystID;
            }
        };
    }

    @Override
    Biocom load(RefreshKey<Biocom> refreshKey, Biocom b, SBdb sbdb, Well well, int interpID) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getRefreshKeyString(Biocom t) {
        return "" + t.getDiscipline().getChar() + t.getSample().getSampID() + t.getAnalyst();
    }

    @Override
    Biocom copyToWorkspace(Biocom biocom, SBdb db, WsWell wsWell) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void remove(Discipline disc) {
        for (Biocom biocom : this.getItems()) {
            if (biocom.getDiscipline() != disc) continue;
            this.remove(biocom);
        }
    }

    @Override
    public void insertStoredCopy(Biocom biocomToCopy, int wellID, SBdb sbdb) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    Biocom copyToDatabase(Biocom wsBiocom, int wellID, SBdb db) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    int getDataType(Biocom t) {
        return SBdb.did2comType(t.getDiscID());
    }

    @Override
    String getXmlElementFilterName() {
        return "BiostratigraphicComment";
    }

    @Override
    public Biocom parseXmlItem(SBdb sbdb, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String initBiocomEditPresentationName(Biocom originalComment, Biocom.Builder builder) {
        String s = originalComment != null && builder != null ? "update comment" : (originalComment != null ? "delete comment" : "new comment");
        return s;
    }

    public class BiocomEdit
    extends InterpEdit<Biocom> {
        final Biocom originalComment;
        final int wellID;
        Biocom.Builder builder;
        Biocom newComment;
        final SBdb sbdb;
        final /* synthetic */ BiocomList this$0;

        private BiocomEdit(BiocomList this$0, int wellID, Biocom originalComment, Biocom.Builder builder, SBdb sbdb) {
            BiocomList biocomList = this$0;
            Objects.requireNonNull(biocomList);
            this.this$0 = biocomList;
            super(BiocomList.initBiocomEditPresentationName(originalComment, builder));
            this.originalComment = originalComment;
            this.builder = builder;
            this.wellID = wellID;
            this.sbdb = sbdb;
        }

        public void undo() {
            try {
                if (this.newComment != null) {
                    this.deleteActionDB(this.newComment);
                }
                if (this.originalComment != null) {
                    this.insertActionDB(this.originalComment);
                }
                this.sbdb.commit();
                this.this$0.notifyObserver(this.originalComment != null ? this.originalComment : this.newComment);
            }
            catch (SQLException e) {
                this.sbdb.doRollback();
                throw new RuntimeException("Error undoing biocom edit", e);
            }
            if (this.newComment != null) {
                this.deleteActionModel(this.newComment);
            }
            if (this.originalComment != null) {
                this.insertActionModel(this.originalComment);
            }
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalComment != null) {
                    this.deleteActionDB(this.originalComment);
                }
                if (!(built = this.buildNewComment()) && this.newComment != null) {
                    this.insertActionDB(this.newComment);
                }
                this.sbdb.commit();
            }
            catch (SQLException e) {
                this.sbdb.doRollback();
                throw new RuntimeException("Error redoing biocom edit", e);
            }
            if (this.originalComment != null) {
                this.deleteActionModel(this.originalComment);
            }
            if (this.newComment != null) {
                this.insertActionModel(this.newComment);
            }
            this.this$0.notifyObserver(this.newComment != null ? this.newComment : this.originalComment);
            super.redo();
        }

        private boolean buildNewComment() throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionDB(Biocom biocom) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionModel(Biocom bc) {
            this.this$0.insert(bc);
        }

        private void deleteActionDB(Biocom bc) throws SQLException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void deleteActionModel(Biocom bc) {
            this.this$0.remove(bc);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public Biocom getItem() {
            return this.newComment;
        }

        @Override
        public Biocom getNotifier() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

