/*
 * Decompiled with CFR 0.152.
 */
package model3.wellinterp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Objects;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WsWell;
import model3.wellinterp.InterpEdit;
import model3.wellinterp.InterpList;
import model3.wellinterp.InterpListObserver;
import model3.wellinterp.RefreshKey;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SBException;
import util.SbugsCompoundEdit;

public class IGDIntervalZoneList
extends InterpList<IGDIntervalZone> {
    private final int igdType;

    public IGDIntervalZoneList(int interpID, InterpListObserver observer, int igdType) {
        super(interpID, observer);
        this.igdType = igdType;
    }

    private boolean isLithostrat() {
        return this.igdType == 2;
    }

    @Override
    public void load(Well well) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InterpEdit<IGDIntervalZone> add() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    IGDIntervalZone copyToDatabase(IGDIntervalZone wsT, int wellID, SBdb db) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertStoredCopy(IGDIntervalZone itemToCopy, int wellID, SBdb sbdb) throws SQLException, SBException, InvalidFieldException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDescriptor() {
        switch (this.igdType) {
            case 3: {
                return "chronostratigraphy zone";
            }
            case 2: {
                return "lithostratigraphy zone";
            }
            case 4: {
                return "biozone";
            }
        }
        assert (false);
        return "zone";
    }

    @Override
    String getAuditType() {
        return "IGDINTERVAL";
    }

    @Override
    String getTableName() {
        return this.isLithostrat() ? "IGD_LSTRAT" : "IGD";
    }

    @Override
    String getRefreshQueryString(SBdb sbdb, int wellID, int interpID) {
        return "SELECT top_id,sch_id,hier,updated FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE igd_type=" + this.igdType + " AND interp_id=" + interpID + " AND well_id=" + wellID;
    }

    @Override
    RefreshKey<IGDIntervalZone> getRefreshKey(ResultSet rs) throws SQLException {
        final int topID = rs.getInt("top_id");
        final int schID = rs.getInt("sch_id");
        final int hier = rs.getInt("hier");
        return new RefreshKey<IGDIntervalZone>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public String getKey() {
                return topID + "|" + schID + "|" + hier;
            }

            @Override
            public boolean matches(IGDIntervalZone t) {
                return t.getTopID() == topID && t.getSchID() == schID && t.getHier() == hier;
            }

            @Override
            public int getSampID() {
                return topID;
            }

            @Override
            public Integer getDictID() {
                return schID;
            }

            @Override
            public int getHier() {
                return hier;
            }
        };
    }

    @Override
    String getRefreshKeyString(IGDIntervalZone t) {
        return t.getTopID() + "|" + t.getSchID() + "|" + t.getHier();
    }

    @Override
    IGDIntervalZone load(RefreshKey<IGDIntervalZone> refreshKey, IGDIntervalZone t, SBdb sbdb, Well well, int interpID) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    IGDIntervalZone copyToWorkspace(IGDIntervalZone dbZone, SBdb db, WsWell wsWell) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    int getDataType(IGDIntervalZone t) {
        try {
            return IGDInterval.igdType2dType(this.igdType);
        }
        catch (SBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    String getXmlElementFilterName() {
        return "IGDInterval";
    }

    @Override
    IGDIntervalZone parseXmlItem(SBdb sbdb, WsWell well, Element xml, Set<Integer> dataTypes) throws SQLException, SBException, ParseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getAgeLimit(IGDScheme scheme, boolean minAge) throws SBException, SQLException {
        double age = -1.0;
        for (IGDIntervalZone zone : this.getItems(scheme.getID())) {
            int unitID = !minAge && zone.getLowZone() > 0 ? zone.getLowZone() : zone.getUppZone();
            IGDUnit unit = scheme.findUnit(unitID);
            if (unit == null) continue;
            if (minAge && unit.getUage() != null) {
                if (!(age < 0.0) && !(unit.getUage() < age)) continue;
                age = unit.getUage();
                continue;
            }
            if (unit.getLage() == null || !(age < 0.0) && !(unit.getLage() > age)) continue;
            age = unit.getLage();
        }
        return age;
    }

    public UndoableEdit updateBoundary(Sample oldSample, Sample newSample, int wellID, int schID, SBdb sbdb) throws InvalidFieldException, SBException, SQLException {
        boolean moveDown = newSample.getDepth() - oldSample.getDepth() > 0.0;
        IGDIntervalZone[] moveTops = new IGDIntervalZone[IGDIntervalZone.getNHier(this.igdType, true)];
        IGDIntervalZone[] moveBases = new IGDIntervalZone[IGDIntervalZone.getNHier(this.igdType, true)];
        for (IGDIntervalZone zone : this.getItems(schID)) {
            if (zone.getTopSample() == oldSample && (zone.getTopSample() != zone.getBaseSample() || !moveDown) && zone.getBaseSample().getDepth() > newSample.getDepth()) {
                moveTops[zone.getHier() - 1] = zone;
            }
            if (zone.getBaseSample() != oldSample || zone.getTopSample() == zone.getBaseSample() && !moveDown || !(zone.getTopSample().getDepth() < newSample.getDepth())) continue;
            moveBases[zone.getHier() - 1] = zone;
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update interval boundary");
        try {
            for (int i = 0; i < moveTops.length; ++i) {
                IGDIntervalZone moveTop = moveTops[i];
                IGDIntervalZone moveBase = moveBases[i];
                if (moveTop == null && moveBase == null) continue;
                if (moveTop != null ^ moveBase != null) {
                    if (moveTop != null) {
                        edit.addEdit((UndoableEdit)((Object)this.update(moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), wellID, sbdb)));
                        continue;
                    }
                    edit.addEdit((UndoableEdit)((Object)this.update(moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), wellID, sbdb)));
                    continue;
                }
                SbugsCompoundEdit innerEdit = new SbugsCompoundEdit("Update interval boundary");
                if (moveDown) {
                    if (newSample.getDepth() > moveTop.getBaseSample().getDepth()) {
                        throw new InvalidFieldException("New top is below base");
                    }
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(this, wellID, moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), sbdb)));
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(this, wellID, moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), sbdb)));
                } else {
                    if (newSample.getDepth() < moveBase.getTopSample().getDepth()) {
                        throw new InvalidFieldException("New base is above top");
                    }
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(this, wellID, moveBase, IGDIntervalZone.Builder.copyOf(moveBase, moveBase.getTopSample(), newSample), sbdb)));
                    innerEdit.addEdit((UndoableEdit)((Object)new ZoneEdit(this, wellID, moveTop, IGDIntervalZone.Builder.copyOf(moveTop, newSample, moveTop.getBaseSample()), sbdb)));
                }
                innerEdit.doEdits();
                edit.addEdit((UndoableEdit)innerEdit);
            }
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            if (edit.canRedo()) {
                edit.undo();
            }
            throw e;
        }
        edit.end();
        return edit;
    }

    private ZoneEdit update(IGDIntervalZone original, IGDIntervalZone.Builder builder, int wellID, SBdb sbdb) throws SQLException, InvalidFieldException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void checkOverlap(IGDIntervalZone.Builder builder, IGDIntervalZone original, boolean checkBoundaries) throws InvalidFieldException, SBException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static String initZoneEditPresentationName(IGDIntervalZone originalZone, IGDIntervalZone.Builder builder) {
        String s = originalZone != null && builder != null ? "update interval" : (originalZone != null ? "delete interval" : "new interval");
        return s;
    }

    public class ZoneEdit
    extends InterpEdit<IGDIntervalZone> {
        final IGDIntervalZone originalZone;
        final int wellID;
        IGDIntervalZone.Builder builder;
        IGDIntervalZone newZone;
        final SBdb sbdb;
        final /* synthetic */ IGDIntervalZoneList this$0;

        private ZoneEdit(IGDIntervalZoneList this$0, int wellID, IGDIntervalZone originalZone, IGDIntervalZone.Builder builder, SBdb sbdb) {
            IGDIntervalZoneList iGDIntervalZoneList = this$0;
            Objects.requireNonNull(iGDIntervalZoneList);
            this.this$0 = iGDIntervalZoneList;
            super(IGDIntervalZoneList.initZoneEditPresentationName(originalZone, builder));
            this.originalZone = originalZone;
            this.builder = builder;
            this.wellID = wellID;
            this.sbdb = sbdb;
        }

        public void undo() {
            try {
                if (this.newZone != null) {
                    this.deleteActionDB(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionDB(this.originalZone);
                }
                this.sbdb.commit();
                if (this.newZone != null) {
                    this.deleteActionModel(this.newZone);
                }
                if (this.originalZone != null) {
                    this.insertActionModel(this.originalZone);
                }
            }
            catch (SQLException | SBException e) {
                this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error undoing interval edit", e);
            }
            this.this$0.notifyObserver(this.originalZone != null ? this.originalZone : this.newZone);
            super.undo();
        }

        public void redo() {
            try {
                boolean built;
                if (this.originalZone != null) {
                    this.deleteActionDB(this.originalZone);
                }
                if (!(built = this.buildNewZone()) && this.newZone != null) {
                    this.insertActionDB(this.newZone);
                }
                this.sbdb.commit();
                if (this.originalZone != null) {
                    this.deleteActionModel(this.originalZone);
                }
                if (this.newZone != null) {
                    this.insertActionModel(this.newZone);
                }
            }
            catch (SQLException | SBException e) {
                this.sbdb.doRollback();
                e.printStackTrace();
                throw new RuntimeException("Error redoing interval edit", e);
            }
            this.this$0.notifyObserver(this.newZone != null ? this.newZone : this.originalZone);
            super.redo();
        }

        private boolean buildNewZone() throws SQLException, SBException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private void insertActionModel(IGDIntervalZone zone) throws SBException {
            this.this$0.insert(zone);
        }

        private void deleteActionDB(IGDIntervalZone zone) throws SQLException, SBException {
            zone.delete(this.wellID, this.this$0.interpID, null);
        }

        private void deleteActionModel(IGDIntervalZone zone) {
            this.this$0.remove(zone);
        }

        public void doEdit() throws SQLException {
            try {
                this.redo();
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException) {
                    throw (SQLException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public IGDIntervalZone getItem() {
            return this.newZone;
        }

        @Override
        public IGDIntervalZone getNotifier() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

