/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.api.style.Font;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.renderer.style.StyleAttributeExtractor;

public class StyleAttributeExtractorTruncated
extends StyleAttributeExtractor
implements StyleVisitor {
    boolean usingVolatileFunctions = false;

    public StyleAttributeExtractorTruncated() {
        this.setSymbolizerGeometriesVisitEnabled(false);
    }

    @Override
    public void clear() {
        super.clear();
        this.usingVolatileFunctions = false;
    }

    public boolean isUsingVolatileFunctions() {
        return this.usingVolatileFunctions;
    }

    @Override
    public Object visit(Function expression, Object data) {
        this.usingVolatileFunctions |= expression instanceof VolatileFunction;
        return super.visit(expression, data);
    }

    @Override
    public void visit(TextSymbolizer text) {
        if (text instanceof TextSymbolizer && text.getGraphic() != null) {
            text.getGraphic().accept((StyleVisitor)this);
        }
        if (text.getFill() != null) {
            text.getFill().accept((StyleVisitor)this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.fonts() != null) {
            List fonts = text.fonts();
            for (Font font : fonts) {
                if (font.getFamily() != null) {
                    for (Expression family : font.getFamily()) {
                        family.accept((ExpressionVisitor)this, null);
                    }
                }
                if (font.getSize() != null) {
                    font.getSize().accept((ExpressionVisitor)this, null);
                }
                if (font.getStyle() != null) {
                    font.getStyle().accept((ExpressionVisitor)this, null);
                }
                if (font.getWeight() == null) continue;
                font.getWeight().accept((ExpressionVisitor)this, null);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept((StyleVisitor)this);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept((StyleVisitor)this);
        }
    }
}

