/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.ddl;

import org.h2.mod.command.ddl.SchemaCommand;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.Session;
import org.h2.mod.message.DbException;
import org.h2.mod.schema.Schema;
import org.h2.mod.schema.TriggerObject;
import org.h2.mod.table.Table;

public class DropTrigger
extends SchemaCommand {
    private String triggerName;
    private boolean ifExists;

    public DropTrigger(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        TriggerObject triggerObject = this.getSchema().findTrigger(this.triggerName);
        if (triggerObject == null) {
            if (!this.ifExists) {
                throw DbException.get(90042, this.triggerName);
            }
        } else {
            Table table = triggerObject.getTable();
            this.session.getUser().checkRight(table, 15);
            database.removeSchemaObject(this.session, triggerObject);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 45;
    }
}

