/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.command.dml;

import java.util.Map;
import java.util.TreeMap;
import org.h2.mod.command.Prepared;
import org.h2.mod.engine.Database;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionColumn;
import org.h2.mod.mvstore.db.MVTableEngine;
import org.h2.mod.result.LocalResult;
import org.h2.mod.result.ResultInterface;
import org.h2.mod.store.PageStore;
import org.h2.mod.table.Column;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueString;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared prepared) {
        this.command = prepared;
    }

    public Prepared getCommand() {
        return this.command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    @Override
    protected void checkParameters() {
        if (this.executeCommand) {
            super.checkParameters();
        }
    }

    @Override
    public ResultInterface query(int n) {
        Column column = new Column("PLAN", 13);
        Database database = this.session.getDatabase();
        ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
        Expression[] expressionArray = new Expression[]{expressionColumn};
        this.result = database.getResultFactory().create(this.session, expressionArray, 1);
        boolean bl = true;
        if (n >= 0) {
            String string;
            if (this.executeCommand) {
                PageStore pageStore = null;
                MVTableEngine.Store store = null;
                if (database.isPersistent()) {
                    pageStore = database.getPageStore();
                    if (pageStore != null) {
                        pageStore.statisticsStart();
                    }
                    if ((store = database.getStore()) != null) {
                        store.statisticsStart();
                    }
                }
                if (this.command.isQuery()) {
                    this.command.query(n);
                } else {
                    this.command.update();
                }
                string = this.command.getPlanSQL(bl);
                Map<String, Integer> map = null;
                if (pageStore != null) {
                    map = pageStore.statisticsEnd();
                } else if (store != null) {
                    map = store.statisticsEnd();
                }
                if (map != null) {
                    int n2 = 0;
                    for (Map.Entry<String, Integer> object : map.entrySet()) {
                        n2 += object.getValue().intValue();
                    }
                    if (n2 > 0) {
                        map = new TreeMap<String, Integer>(map);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (map.size() > 1) {
                            stringBuilder.append("total: ").append(n2).append('\n');
                        }
                        for (Map.Entry<String, Integer> entry : map.entrySet()) {
                            int n3 = entry.getValue();
                            int n4 = (int)(100L * (long)n3 / (long)n2);
                            stringBuilder.append(entry.getKey()).append(": ").append(n3);
                            if (map.size() > 1) {
                                stringBuilder.append(" (").append(n4).append("%)");
                            }
                            stringBuilder.append('\n');
                        }
                        string = string + "\n/*\n" + stringBuilder.toString() + "*/";
                    }
                }
            } else {
                string = this.command.getPlanSQL(bl);
            }
            this.add(string);
        }
        this.result.done();
        return this.result;
    }

    private void add(String string) {
        Value[] valueArray = new Value[]{ValueString.get(string)};
        this.result.addRow(valueArray);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return this.executeCommand ? 86 : 60;
    }
}

