/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression;

import org.h2.mod.command.Parser;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.ExpressionColumn;
import org.h2.mod.expression.ExpressionVisitor;
import org.h2.mod.table.ColumnResolver;
import org.h2.mod.table.TableFilter;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;

public class Alias
extends Expression {
    private final String alias;
    private Expression expr;
    private final boolean aliasColumnName;

    public Alias(Expression expression, String string, boolean bl) {
        this.expr = expression;
        this.alias = string;
        this.aliasColumnName = bl;
    }

    @Override
    public Expression getNonAliasExpression() {
        return this.expr;
    }

    @Override
    public Value getValue(Session session) {
        return this.expr.getValue(session);
    }

    @Override
    public TypeInfo getType() {
        return this.expr.getType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.expr.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.expr = this.expr.optimize(session);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.expr.setEvaluatable(tableFilter, bl);
    }

    @Override
    public boolean isAutoIncrement() {
        return this.expr.isAutoIncrement();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        this.expr.getSQL(stringBuilder, bl).append(" AS ");
        return Parser.quoteIdentifier(stringBuilder, this.alias, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.expr.updateAggregate(session, n);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getNullable() {
        return this.expr.getNullable();
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.expr.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.expr.getCost();
    }

    @Override
    public String getTableName() {
        if (this.aliasColumnName) {
            return null;
        }
        return this.expr.getTableName();
    }

    @Override
    public String getColumnName() {
        if (!(this.expr instanceof ExpressionColumn) || this.aliasColumnName) {
            return this.alias;
        }
        return this.expr.getColumnName();
    }
}

