/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.h2.mod.engine.Database;
import org.h2.mod.expression.aggregate.AggregateData;
import org.h2.mod.message.DbException;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueNull;

class AggregateDataCollecting
extends AggregateData
implements Iterable<Value> {
    private final boolean distinct;
    Collection<Value> values;
    private Value shared;

    AggregateDataCollecting(boolean bl) {
        this.distinct = bl;
    }

    @Override
    void add(Database database, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        Collection<Value> collection = this.values;
        if (collection == null) {
            collection = this.distinct ? new TreeSet<Value>(database.getCompareMode()) : new ArrayList();
            this.values = collection;
        }
        collection.add(value);
    }

    @Override
    Value getValue(Database database, int n) {
        return null;
    }

    int getCount() {
        return this.values != null ? this.values.size() : 0;
    }

    Value[] getArray() {
        Collection<Value> collection = this.values;
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Value[0]);
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values != null ? this.values.iterator() : Collections.emptyIterator();
    }

    void setSharedArgument(Value value) {
        if (this.shared == null) {
            this.shared = value;
        } else if (!this.shared.equals(value)) {
            throw DbException.get(90008, "Inverse distribution function argument", this.shared.getTraceSQL() + "<>" + value.getTraceSQL());
        }
    }

    Value getSharedArgument() {
        return this.shared;
    }
}

