/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.expression.aggregate;

import org.h2.mod.engine.Database;
import org.h2.mod.expression.aggregate.AggregateData;
import org.h2.mod.expression.aggregate.AggregateType;
import org.h2.mod.message.DbException;
import org.h2.mod.value.DataType;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueBoolean;
import org.h2.mod.value.ValueDouble;
import org.h2.mod.value.ValueLong;
import org.h2.mod.value.ValueNull;

class AggregateDataDefault
extends AggregateData {
    private final AggregateType aggregateType;
    private final int dataType;
    private long count;
    private Value value;
    private double m2;
    private double mean;

    AggregateDataDefault(AggregateType aggregateType, int n) {
        this.aggregateType = aggregateType;
        this.dataType = n;
    }

    @Override
    void add(Database database, Value value) {
        if (value == ValueNull.INSTANCE) {
            return;
        }
        ++this.count;
        switch (this.aggregateType) {
            case SUM: {
                if (this.value == null) {
                    this.value = value.convertTo(this.dataType);
                    break;
                }
                value = value.convertTo(this.value.getValueType());
                this.value = this.value.add(value);
                break;
            }
            case AVG: {
                if (this.value == null) {
                    this.value = value.convertTo(DataType.getAddProofType(this.dataType));
                    break;
                }
                value = value.convertTo(this.value.getValueType());
                this.value = this.value.add(value);
                break;
            }
            case MIN: {
                if (this.value != null && database.compare(value, this.value) >= 0) break;
                this.value = value;
                break;
            }
            case MAX: {
                if (this.value != null && database.compare(value, this.value) <= 0) break;
                this.value = value;
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                double d = value.getDouble();
                if (this.count == 1L) {
                    this.mean = d;
                    this.m2 = 0.0;
                    break;
                }
                double d2 = d - this.mean;
                this.mean += d2 / (double)this.count;
                this.m2 += d2 * (d - this.mean);
                break;
            }
            case EVERY: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() && value.getBoolean());
                break;
            }
            case ANY: {
                value = value.convertTo(1);
                if (this.value == null) {
                    this.value = value;
                    break;
                }
                this.value = ValueBoolean.get(this.value.getBoolean() || value.getBoolean());
                break;
            }
            case BIT_AND: {
                if (this.value == null) {
                    this.value = value.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() & value.getLong()).convertTo(this.dataType);
                break;
            }
            case BIT_OR: {
                if (this.value == null) {
                    this.value = value.convertTo(this.dataType);
                    break;
                }
                this.value = ValueLong.get(this.value.getLong() | value.getLong()).convertTo(this.dataType);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
    }

    @Override
    Value getValue(Database database, int n) {
        Value value = null;
        switch (this.aggregateType) {
            case SUM: 
            case MIN: 
            case MAX: 
            case EVERY: 
            case ANY: 
            case BIT_AND: 
            case BIT_OR: {
                value = this.value;
                break;
            }
            case AVG: {
                if (this.value == null) break;
                value = AggregateDataDefault.divide(this.value, this.count);
                break;
            }
            case STDDEV_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                value = ValueDouble.get(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.aggregateType));
            }
        }
        return value == null ? ValueNull.INSTANCE : value.convertTo(n);
    }

    private static Value divide(Value value, long l) {
        if (l == 0L) {
            return ValueNull.INSTANCE;
        }
        int n = Value.getHigherOrder(value.getValueType(), 5);
        Value value2 = ValueLong.get(l).convertTo(n);
        value = value.convertTo(n).divide(value2);
        return value;
    }
}

