/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.mod.engine.Session;
import org.h2.mod.index.Cursor;
import org.h2.mod.message.DbException;
import org.h2.mod.result.Row;
import org.h2.mod.result.SearchRow;
import org.h2.mod.table.Column;
import org.h2.mod.table.TableLink;
import org.h2.mod.value.DataType;
import org.h2.mod.value.Value;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final Session session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet resultSet, Session session, String string, PreparedStatement preparedStatement) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = resultSet;
        this.sql = string;
        this.prep = preparedStatement;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int n;
        try {
            n = this.rs.next();
            if (n == 0) {
                this.rs.close();
                this.tableLink.reusePreparedStatement(this.prep, this.sql);
                this.current = null;
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
        this.current = this.tableLink.getTemplateRow();
        for (n = 0; n < this.current.getColumnCount(); ++n) {
            Column column = this.tableLink.getColumn(n);
            Value value = DataType.readValue(this.session, this.rs, n + 1, column.getType().getValueType());
            this.current.setValue(n, value);
        }
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

