/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.index;

import org.h2.mod.engine.Session;
import org.h2.mod.index.Cursor;
import org.h2.mod.message.DbException;
import org.h2.mod.result.Row;
import org.h2.mod.result.SearchRow;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueLong;

class RangeCursor
implements Cursor {
    private final Session session;
    private boolean beforeFirst;
    private long current;
    private Row currentRow;
    private final long start;
    private final long end;
    private final long step;

    RangeCursor(Session session, long l, long l2) {
        this(session, l, l2, 1L);
    }

    RangeCursor(Session session, long l, long l2, long l3) {
        this.session = session;
        this.start = l;
        this.end = l2;
        this.step = l3;
        this.beforeFirst = true;
    }

    @Override
    public Row get() {
        return this.currentRow;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.beforeFirst) {
            this.beforeFirst = false;
            this.current = this.start;
        } else {
            this.current += this.step;
        }
        this.currentRow = this.session.createRow(new Value[]{ValueLong.get(this.current)}, 1);
        return this.step > 0L ? this.current <= this.end : this.current >= this.end;
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

