/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.mvstore.tx;

import java.nio.ByteBuffer;
import org.h2.mod.mvstore.DataUtils;
import org.h2.mod.mvstore.WriteBuffer;
import org.h2.mod.mvstore.tx.VersionedValueCommitted;
import org.h2.mod.mvstore.tx.VersionedValueUncommitted;
import org.h2.mod.mvstore.type.DataType;
import org.h2.mod.value.VersionedValue;

public class VersionedValueType
implements DataType {
    private final DataType valueType;

    public VersionedValueType(DataType dataType) {
        this.valueType = dataType;
    }

    @Override
    public int getMemory(Object object) {
        if (object == null) {
            return 0;
        }
        VersionedValue versionedValue = (VersionedValue)object;
        int n = 48 + this.getValMemory(versionedValue.getCurrentValue());
        if (versionedValue.getOperationId() != 0L) {
            n += this.getValMemory(versionedValue.getCommittedValue());
        }
        return n;
    }

    private int getValMemory(Object object) {
        return object == null ? 0 : this.valueType.getMemory(object);
    }

    @Override
    public int compare(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        VersionedValue versionedValue = (VersionedValue)object;
        VersionedValue versionedValue2 = (VersionedValue)object2;
        long l = versionedValue.getOperationId() - versionedValue2.getOperationId();
        if (l == 0L) {
            return this.valueType.compare(versionedValue.getCurrentValue(), versionedValue2.getCurrentValue());
        }
        return Long.signum(l);
    }

    @Override
    public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
        if (byteBuffer.get() == 0) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = VersionedValueCommitted.getInstance(this.valueType.read(byteBuffer));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }
    }

    @Override
    public Object read(ByteBuffer byteBuffer) {
        long l = DataUtils.readVarLong(byteBuffer);
        if (l == 0L) {
            return VersionedValueCommitted.getInstance(this.valueType.read(byteBuffer));
        }
        byte by = byteBuffer.get();
        Object object = (by & 1) != 0 ? this.valueType.read(byteBuffer) : null;
        Object object2 = (by & 2) != 0 ? this.valueType.read(byteBuffer) : null;
        return VersionedValueUncommitted.getInstance(l, object, object2);
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
        VersionedValue versionedValue;
        int n2;
        boolean bl2 = true;
        for (n2 = 0; n2 < n; ++n2) {
            versionedValue = (VersionedValue)objectArray[n2];
            if (versionedValue.getOperationId() == 0L && versionedValue.getCurrentValue() != null) continue;
            bl2 = false;
        }
        if (bl2) {
            writeBuffer.put((byte)0);
            for (n2 = 0; n2 < n; ++n2) {
                versionedValue = (VersionedValue)objectArray[n2];
                this.valueType.write(writeBuffer, versionedValue.getCurrentValue());
            }
        } else {
            writeBuffer.put((byte)1);
            for (n2 = 0; n2 < n; ++n2) {
                this.write(writeBuffer, objectArray[n2]);
            }
        }
    }

    @Override
    public void write(WriteBuffer writeBuffer, Object object) {
        VersionedValue versionedValue = (VersionedValue)object;
        long l = versionedValue.getOperationId();
        writeBuffer.putVarLong(l);
        if (l == 0L) {
            this.valueType.write(writeBuffer, versionedValue.getCurrentValue());
        } else {
            Object object2 = versionedValue.getCommittedValue();
            int n = (versionedValue.getCurrentValue() == null ? 0 : 1) | (object2 == null ? 0 : 2);
            writeBuffer.put((byte)n);
            if (versionedValue.getCurrentValue() != null) {
                this.valueType.write(writeBuffer, versionedValue.getCurrentValue());
            }
            if (object2 != null) {
                this.valueType.write(writeBuffer, object2);
            }
        }
    }
}

