/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.table;

import java.util.ArrayList;
import org.h2.mod.engine.Session;
import org.h2.mod.expression.Expression;
import org.h2.mod.expression.function.FunctionCall;
import org.h2.mod.expression.function.TableFunction;
import org.h2.mod.index.FunctionIndex;
import org.h2.mod.index.Index;
import org.h2.mod.index.IndexType;
import org.h2.mod.message.DbException;
import org.h2.mod.result.ResultInterface;
import org.h2.mod.result.Row;
import org.h2.mod.schema.Schema;
import org.h2.mod.table.Column;
import org.h2.mod.table.IndexColumn;
import org.h2.mod.table.Table;
import org.h2.mod.table.TableType;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueNull;
import org.h2.mod.value.ValueResultSet;

public class FunctionTable
extends Table {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;
    private ResultInterface cachedResult;
    private Value cachedValue;

    public FunctionTable(Schema schema, Session session, Expression expression, FunctionCall functionCall) {
        super(schema, 0, functionCall.getName(), false, true);
        this.functionExpr = expression;
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n = functionCall.getValueType();
        if (n != 18) {
            throw DbException.get(90000, functionCall.getName());
        }
        Expression[] expressionArray = functionCall.getArgs();
        int n2 = expressionArray.length;
        Expression[] expressionArray2 = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = expressionArray[i].optimize(session);
            expressionArray2[i] = expressionArray[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray2);
        if (valueResultSet == null) {
            throw DbException.get(90000, functionCall.getName());
        }
        ResultInterface resultInterface = valueResultSet.getResult();
        int n3 = resultInterface.getVisibleColumnCount();
        Column[] columnArray = new Column[n3];
        for (int i = 0; i < n3; ++i) {
            columnArray[i] = new Column(resultInterface.getColumnName(i), resultInterface.getColumnType(i));
        }
        this.setColumns(columnArray);
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canDrop() {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public TableType getTableType() {
        return null;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new FunctionIndex(this, IndexColumn.wrap(this.columns));
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    public ResultInterface getResult(Session session) {
        ValueResultSet valueResultSet = this.getValueResultSet(session);
        if (valueResultSet == null) {
            return null;
        }
        if (this.cachedResult != null && this.cachedValue == valueResultSet) {
            this.cachedResult.reset();
            return this.cachedResult;
        }
        ResultInterface resultInterface = valueResultSet.getResult();
        if (this.function.isDeterministic()) {
            this.cachedResult = resultInterface;
            this.cachedValue = valueResultSet;
        }
        return resultInterface;
    }

    public ResultInterface getResultSet(Session session) {
        ValueResultSet valueResultSet = this.getValueResultSet(session);
        return valueResultSet == null ? null : valueResultSet.getResult();
    }

    private ValueResultSet getValueResultSet(Session session) {
        this.functionExpr = this.functionExpr.optimize(session);
        Value value = this.functionExpr.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        return (ValueResultSet)value;
    }

    public boolean isBufferResultSetToLocalTemp() {
        return this.function.isBufferResultSetToLocalTemp();
    }

    @Override
    public long getMaxDataModificationId() {
        return Long.MAX_VALUE;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public String getSQL(boolean bl) {
        return this.function.getSQL(bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append(this.function.getSQL(bl));
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

