/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.h2.mod.engine.SysProperties;
import org.h2.mod.util.StringUtils;
import org.h2.mod.value.CharsetCollator;
import org.h2.mod.value.CompareModeDefault;
import org.h2.mod.value.CompareModeIcu4J;
import org.h2.mod.value.Value;

public class CompareMode
implements Comparator<Value> {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;
    private final boolean uuidUnsigned;

    protected CompareMode(String string, int n, boolean bl, boolean bl2) {
        this.name = string;
        this.strength = n;
        this.binaryUnsigned = bl;
        this.uuidUnsigned = bl2;
    }

    public static CompareMode getInstance(String string, int n) {
        return CompareMode.getInstance(string, n, SysProperties.SORT_BINARY_UNSIGNED, SysProperties.SORT_UUID_UNSIGNED);
    }

    public static CompareMode getInstance(String string, int n, boolean bl, boolean bl2) {
        CompareMode compareMode = lastUsed;
        if (compareMode != null && Objects.equals(compareMode.name, string) && compareMode.strength == n && compareMode.binaryUnsigned == bl && compareMode.uuidUnsigned == bl2) {
            return compareMode;
        }
        if (string == null || string.equals(OFF)) {
            compareMode = new CompareMode(string, n, bl, bl2);
        } else {
            boolean bl3;
            if (string.startsWith(ICU4J)) {
                bl3 = true;
                string = string.substring(ICU4J.length());
            } else if (string.startsWith(DEFAULT)) {
                bl3 = false;
                string = string.substring(DEFAULT.length());
            } else {
                bl3 = CAN_USE_ICU4J;
            }
            compareMode = bl3 ? new CompareModeIcu4J(string, n, bl, bl2) : new CompareModeDefault(string, n, bl, bl2);
        }
        lastUsed = compareMode;
        return compareMode;
    }

    public boolean equalsChars(String string, int n, String string2, int n2, boolean bl) {
        char c = string.charAt(n);
        char c2 = string2.charAt(n2);
        if (bl) {
            c = Character.toUpperCase(c);
            c2 = Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public int compareString(String string, String string2, boolean bl) {
        if (bl) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string = StringUtils.toUpperEnglish(string.trim().replace(' ', '_'));
        return string;
    }

    static boolean compareLocaleNames(Locale locale, String string) {
        return string.equalsIgnoreCase(locale.toString()) || string.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string) {
        String string2;
        String string3;
        Locale locale2;
        int n;
        Collator collator = null;
        if (string.startsWith(ICU4J)) {
            string = string.substring(ICU4J.length());
        } else if (string.startsWith(DEFAULT)) {
            string = string.substring(DEFAULT.length());
        } else if (string.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(string.substring(CHARSET.length())));
        }
        int n2 = string.length();
        if (n2 == 2) {
            Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (n2 == 5 && (n = string.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(string3 = StringUtils.toLowerEnglish(string.substring(0, n)), string2 = string.substring(n + 1)), string)) {
            collator = Collator.getInstance(locale2);
        }
        if (collator == null) {
            for (Locale locale2 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale2, string)) continue;
                collator = Collator.getInstance(locale2);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean isUuidUnsigned() {
        return this.uuidUnsigned;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompareMode)) {
            return false;
        }
        CompareMode compareMode = (CompareMode)object;
        if (!this.getName().equals(compareMode.getName())) {
            return false;
        }
        if (this.strength != compareMode.strength) {
            return false;
        }
        if (this.binaryUnsigned != compareMode.binaryUnsigned) {
            return false;
        }
        return this.uuidUnsigned == compareMode.uuidUnsigned;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + this.strength;
        n = 31 * n + (this.binaryUnsigned ? 1231 : 1237);
        n = 31 * n + (this.uuidUnsigned ? 1231 : 1237);
        return n;
    }

    @Override
    public int compare(Value value, Value value2) {
        return value.compareTo(value2, null, this);
    }

    static {
        boolean bl = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = bl;
    }
}

