/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.mod.engine.SysProperties;
import org.h2.mod.util.Bits;
import org.h2.mod.util.MathUtils;
import org.h2.mod.util.StringUtils;
import org.h2.mod.util.Utils;
import org.h2.mod.value.CompareMode;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;

public class ValueBytes
extends Value {
    public static final ValueBytes EMPTY = new ValueBytes(Utils.EMPTY_BYTES);
    protected byte[] value;
    protected TypeInfo type;
    protected int hash;

    protected ValueBytes(byte[] byArray) {
        this.value = byArray;
    }

    public static ValueBytes get(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        byArray = Utils.cloneByteArray(byArray);
        return ValueBytes.getNoCopy(byArray);
    }

    public static ValueBytes getNoCopy(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        ValueBytes valueBytes = new ValueBytes(byArray);
        if (byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueBytes;
        }
        return (ValueBytes)Value.cache(valueBytes);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            long l = this.value.length;
            this.type = typeInfo = new TypeInfo(12, l, 0, MathUtils.convertLongToInt(l * 2L), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return 12;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("X'");
        return StringUtils.convertBytesToHex(stringBuilder, this.getBytesNoCopy()).append('\'');
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.value;
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.getBytesNoCopy());
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        byte[] byArray = ((ValueBytes)value).value;
        if (compareMode.isBinaryUnsigned()) {
            return Bits.compareNotNullUnsigned(this.value, byArray);
        }
        return Bits.compareNotNullSigned(this.value, byArray);
    }

    @Override
    public String getString() {
        return StringUtils.convertBytesToHex(this.value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Utils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    @Override
    public Object getObject() {
        return this.getBytes();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.value);
    }

    @Override
    public int getMemory() {
        return this.value.length + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueBytes && Arrays.equals(this.value, ((ValueBytes)object).value);
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        if ((long)this.value.length <= l) {
            return this;
        }
        int n = MathUtils.convertLongToInt(l);
        return ValueBytes.getNoCopy(Arrays.copyOf(this.value, n));
    }
}

