/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.mod.engine.SysProperties;
import org.h2.mod.message.DbException;
import org.h2.mod.value.CompareMode;
import org.h2.mod.value.Value;
import org.h2.mod.value.ValueCollectionBase;

public class ValueRow
extends ValueCollectionBase {
    private static final Object EMPTY = ValueRow.get(new Value[0]);

    private ValueRow(Value[] valueArray) {
        super(valueArray);
    }

    public static ValueRow get(Value[] valueArray) {
        return new ValueRow(valueArray);
    }

    public static ValueRow getEmpty() {
        return (ValueRow)EMPTY;
    }

    @Override
    public int getValueType() {
        return 39;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i].getString());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        ValueRow valueRow = (ValueRow)value;
        if (this.values == valueRow.values) {
            return 0;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            throw DbException.get(21002);
        }
        for (int i = 0; i < n; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueRow.values[i];
            int n2 = value2.compareTo(value3, null, compareMode);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            Value value = this.values[i];
            objectArray[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value.getValueType()) == 2 || n2 == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        throw this.getUnsupportedExceptionForOperation("PreparedStatement.set");
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("ROW (");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.values[i].getSQL(stringBuilder);
        }
        return stringBuilder.append(')');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder("ROW (");
        for (int i = 0; i < this.values.length; ++i) {
            Value value;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((value = this.values[i]) == null ? "null" : value.getTraceSQL());
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueRow)) {
            return false;
        }
        ValueRow valueRow = (ValueRow)object;
        if (this.values == valueRow.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueRow.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueRow.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        int n;
        if (!bl) {
            return this;
        }
        int n2 = this.values.length;
        Value[] valueArray = new Value[n2];
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            Value value = this.values[n];
            Value value2 = value.convertPrecision(l, true);
            if (value2 != value) {
                bl2 = true;
            }
            if ((l -= Math.max(1L, value2.getType().getPrecision())) < 0L) break;
            valueArray[n] = value2;
        }
        if (n < n2) {
            return ValueRow.get(Arrays.copyOf(valueArray, n));
        }
        return bl2 ? ValueRow.get(valueArray) : this;
    }
}

