/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mod.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.h2.mod.message.DbException;
import org.h2.mod.util.Bits;
import org.h2.mod.util.MathUtils;
import org.h2.mod.util.StringUtils;
import org.h2.mod.value.CompareMode;
import org.h2.mod.value.TypeInfo;
import org.h2.mod.value.Value;

public class ValueUuid
extends Value {
    static final int PRECISION = 16;
    static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long l = MathUtils.secureRandomLong();
        long l2 = MathUtils.secureRandomLong();
        l = l & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        l2 = l2 & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(l, l2);
    }

    public static ValueUuid get(byte[] byArray) {
        if (byArray.length < 16) {
            return ValueUuid.get(StringUtils.convertBytesToHex(byArray));
        }
        long l = Bits.readLong(byArray, 0);
        long l2 = Bits.readLong(byArray, 8);
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(long l, long l2) {
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(UUID uUID) {
        return ValueUuid.get(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static ValueUuid get(String string) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                l = l << 4 | (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                l = l << 4 | (long)(c - 97 + 10);
            } else {
                if (c == '-') continue;
                if (c >= 'A' && c <= 'F') {
                    l = l << 4 | (long)(c - 65 + 10);
                } else {
                    if (c <= ' ') continue;
                    throw DbException.get(22018, string);
                }
            }
            if (n++ != 15) continue;
            l2 = l;
            l = 0L;
        }
        return (ValueUuid)Value.cache(new ValueUuid(l2, l));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append('\'');
        return this.addString(stringBuilder).append('\'');
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_UUID;
    }

    @Override
    public int getMemory() {
        return 32;
    }

    @Override
    public int getValueType() {
        return 20;
    }

    @Override
    public String getString() {
        return this.addString(new StringBuilder(36)).toString();
    }

    private StringBuilder addString(StringBuilder stringBuilder) {
        StringUtils.appendHex(stringBuilder, this.high >> 32, 4).append('-');
        StringUtils.appendHex(stringBuilder, this.high >> 16, 2).append('-');
        StringUtils.appendHex(stringBuilder, this.high, 2).append('-');
        StringUtils.appendHex(stringBuilder, this.low >> 48, 2).append('-');
        return StringUtils.appendHex(stringBuilder, this.low, 6);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        if (value == this) {
            return 0;
        }
        ValueUuid valueUuid = (ValueUuid)value;
        long l = this.high;
        long l2 = valueUuid.high;
        if (l == l2) {
            l = this.low;
            l2 = valueUuid.low;
            if (compareMode.isUuidUnsigned()) {
                l += Long.MIN_VALUE;
                l2 += Long.MIN_VALUE;
            }
            return Long.compare(l, l2);
        }
        if (compareMode.isUuidUnsigned()) {
            l += Long.MIN_VALUE;
            l2 += Long.MIN_VALUE;
        }
        return l > l2 ? 1 : -1;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueUuid)) {
            return false;
        }
        ValueUuid valueUuid = (ValueUuid)object;
        return this.high == valueUuid.high && this.low == valueUuid.low;
    }

    @Override
    public Object getObject() {
        return new UUID(this.high, this.low);
    }

    @Override
    public byte[] getBytes() {
        return Bits.uuidToBytes(this.high, this.low);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }
}

