/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import com.stratadata.model3.well.WellRepository;
import com.stratadata.model3.wellinterp.DepthAgeCurve;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartPanelSnapshot;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.listener.ChartNode;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.LayerWellLocationWithSelection;
import jsbchart.util.DrawZone;
import model3.InterpHdr;
import model3.LOC;
import model3.SBdb;
import model3.TVDList;
import model3.TWTList;
import model3.Well;
import model3.WellInterp;
import model3.project.WellList;
import model3.project.WellListObserver;
import util.SBException;
import util.SBPermissionException;

public abstract class ChartBlockBase
extends ChartNode
implements BlockTemplate.Listener,
WellListObserver,
Observer {
    private static final Logger LOGGER = Logger.getLogger(ChartBlockBase.class.getName());
    private BlockTemplate template;
    private boolean preloadWellData = true;
    private Date templateUpdated;
    private int templateUpdatedUser;
    private final SBdb sbdb;
    private final WellRepository<Well> wellService;
    private int interpID;
    private final ArrayList<Well> wells = new ArrayList();
    private WellList wellList;
    private String caption;
    boolean updatingTemplate = false;
    private boolean isSelected = false;
    private boolean isTemplateSelected = false;

    ChartBlockBase(BlockTemplate template, SBdb sbdb, boolean enabled) {
        super(enabled);
        this.template = template;
        this.sbdb = sbdb;
        this.wellService = sbdb.getWellService();
        this.init();
    }

    private void init() {
        if (this.template != null) {
            this.template.addListener(this);
        }
        if (this.template != null && this.template.getID() > 0) {
            this.templateUpdated = this.template.getUpdated() != null ? new Date(this.template.getUpdated().getTime()) : new Date();
            this.templateUpdatedUser = this.template.getUpdater() > 0 ? this.template.getUpdater() : this.sbdb.getUserID();
        }
    }

    public boolean hasBeenRefreshed() {
        if (this.templateUpdated == null) {
            return false;
        }
        if (this.template.getUpdated() == null) {
            return false;
        }
        boolean b = this.template.getUpdated().after(this.templateUpdated) && this.templateUpdatedUser != this.template.getUpdater();
        return b;
    }

    public abstract BlockType getBlockType();

    public SBdb getDb() {
        return this.sbdb;
    }

    abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, Chart.Mode var5, EnumMap<CorrelationType, HashSet<CorrelationPoint>> var6, Chart.Mode var7);

    public abstract EnumMap<CorrelationType, HashSet<CorrelationPoint>> getCorrelationLines();

    public abstract Set<CorrelationPoint> getCorrelationLines(CorrelationType var1);

    public abstract Set<CorrelationLine> getCorrelationLines(Correlation var1, ChartProperties var2) throws SQLException, SBException;

    public abstract void clearCorrelationData();

    public abstract void addCorrelationData(Correlation var1, ChartProperties var2) throws SBException, SQLException;

    public float drawBlock(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode hMode, Chart.Mode vMode) {
        float xpos = this.draw(g, x, y, p, hMode, this.getCorrelationLines(), vMode);
        if (this.isSelected() || this.isTemplateSelected()) {
            if (this.isSelected()) {
                g.setStroke(1.6f);
            } else if (this.isTemplateSelected()) {
                g.setDashStroke(1.2f, 3.5f);
            }
            g.setColor(p.foreground);
            g.drawRect(x, y, this.getWidth(p), this.getTotalHeight(p, hMode));
        }
        return xpos;
    }

    public void drawCaption(SBGraphics g, float x, float y, ChartProperties cp, boolean hasRowHeader) {
        String capString = this.getTemplatedCaption(cp);
        if (capString.isEmpty()) {
            return;
        }
        g.setColor(cp.foreground);
        g.setFont(cp.font, 1, cp.getGiantFontSize(cp.blockcapFontSize));
        float width = this.getWidth(cp);
        if (hasRowHeader) {
            width -= this.getVheaderWidth(cp.getnVfreeze(), cp.drawEmptyPanels);
        }
        float captionMiddleY = y + cp.blockCapHeight * (cp.blockCapTop ? 0.33f : 0.66f);
        float fontSize = cp.blockCapHeight < 10.0f ? (cp.blockCapHeight < 6.0f ? cp.getFontSize(ChartProperties.FontSize.SMALL) : cp.getFontSize(ChartProperties.FontSize.PANEL)) : cp.getGiantFontSize(cp.blockcapFontSize);
        Rectangle2D.Float drawnArea = g.drawStringWithinBox(capString, new Rectangle2D.Float(x, captionMiddleY - g.stringHeightSB() * 0.5f, width, g.stringHeightSB()), new TextLayoutPreferences().overflowVisible().dontTruncateText().setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle).setFont(new SBFont(cp.font, 1, fontSize)));
        g.setStroke(0.4f);
        float stringWidth = drawnArea.width;
        float pad = 2.5f;
        if (width > stringWidth + pad) {
            g.drawLine(x, captionMiddleY, x + width / 2.0f - stringWidth / 2.0f - pad, captionMiddleY);
            g.drawLine(x + width / 2.0f + stringWidth / 2.0f + pad, captionMiddleY, x + width, captionMiddleY);
            if (cp.blockCapTop) {
                g.drawLine(x, captionMiddleY, x, y + cp.blockCapHeight - 3.0f);
                g.drawLine(x + width, captionMiddleY, x + width, y + cp.blockCapHeight - 3.0f);
            } else {
                g.drawLine(x, captionMiddleY, x, y + 3.0f);
                g.drawLine(x + width, captionMiddleY, x + width, y + 3.0f);
            }
        }
    }

    public abstract float getWidth(ChartProperties var1);

    public abstract float getVheaderWidth(int var1, boolean var2);

    public abstract float getHeight();

    public abstract float getHeaderHeight(ChartProperties var1);

    public abstract float getTotalHeight(ChartProperties var1, Chart.Mode var2);

    public abstract float getDatumOffset();

    public abstract Object getObject(float var1, float var2, ChartProperties var3, float var4);

    public abstract String getTooltip(float var1, float var2, ChartProperties var3, float var4);

    public abstract boolean isEmpty();

    public void terminate() {
        this.wells.forEach(well -> well.deleteObserver((Observer)this));
        if (this.template != null) {
            this.template.deleteListener(this);
        }
    }

    public abstract void setData(ChartProperties var1) throws SBException, SQLException, IOException;

    public int getInterpID() {
        return this.interpID;
    }

    public WellInterp getInterp(Well well) {
        return this.getInterp(well, this.interpID);
    }

    public WellInterp getInterp(Well well, int interpID) {
        if (well != null && well.hasInterpLoaded(interpID)) {
            try {
                return well.getInterp(interpID);
            }
            catch (SBException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void loadInterps() throws SBException, SQLException {
        for (Well well : this.getWells()) {
            well.loadInterps();
            well.loadInterp(well.getInterp(this.interpID));
        }
    }

    public Well getWell() {
        if (this.wells.isEmpty()) {
            return null;
        }
        return this.wells.get(0);
    }

    public WellInterp getInterp() {
        return this.getInterp(this.getWell());
    }

    public void setInterpID(int interpID) throws SQLException, SBException {
        if (this.interpID == interpID) {
            return;
        }
        for (Well well : this.getWells()) {
            WellInterp oldInterpTemp;
            well.loadInterps();
            well.loadInterp(well.getAddInterp(well.getDataModel().getInterp(interpID)));
            try {
                oldInterpTemp = well.getInterp(this.interpID);
                oldInterpTemp.deleteWeakObserver((Observer)this);
            }
            catch (SBException e) {
                oldInterpTemp = null;
            }
            WellInterp oldInterp = oldInterpTemp;
            WellInterp newInterp = well.getInterp(interpID);
            newInterp.addWeakObserver((Observer)this);
            this.members().filter(panel -> panel.getPanelType().isInterpPanel() && panel.getPanelOcc().getInterpID() == null).forEach(panel -> {
                if (oldInterp != null) {
                    oldInterp.deleteWeakObserver((Observer)panel);
                }
                newInterp.addWeakObserver((Observer)panel);
            });
        }
        this.interpID = interpID;
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public List<Well> getWells() {
        return new ArrayList<Well>(this.wells);
    }

    public int getWellID() {
        if (this.wells.size() == 1) {
            return this.getWell().getWellID();
        }
        return 0;
    }

    public void setWell(Well well) {
        this.setWells(well == null ? Collections.EMPTY_LIST : List.of(well));
        if (this.wellList != null) {
            this.wellList.deleteListener((WellListObserver)this);
            this.wellList = null;
        }
    }

    public void wellListChanged(WellList notifier) {
        try {
            this.setWells(this.wellService.getWellListWells(this.getWellListID()));
            this.notifyListeners();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error setting updated well list", e);
        }
    }

    public void wellRemoved(Well notifier) {
        if (this.wellList == null) {
            throw new IllegalStateException("Well list observation erroneously triggered");
        }
        this.clearMemberWellObservation(notifier);
        this.wells.remove(notifier);
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public void wellsAdded(List<Well> notifier) {
        if (this.wellList == null) {
            throw new IllegalStateException("Well list observation erroneously triggered");
        }
        for (Well well : notifier) {
            this.addWell(well);
            this.setPropertyChanged();
        }
        this.notifyListeners();
    }

    public void wellAdded(Well notifier) {
        this.wellsAdded(List.of(notifier));
    }

    public void setWells(Collection<Well> newWells) {
        if (new HashSet<Well>(this.wells).equals(new HashSet<Well>(newWells))) {
            return;
        }
        this.wells.forEach(w -> {
            w.deleteWeakObserver((Observer)this);
            this.clearMemberWellObservation((Well)w);
        });
        this.wells.clear();
        newWells.forEach(w -> this.addWell((Well)w));
        Collections.sort(this.wells);
        this.setPropertyChanged();
    }

    public void setWells(Iterator<Well> wellIterator) {
        ArrayList<Well> list = new ArrayList<Well>();
        while (wellIterator.hasNext()) {
            list.add(wellIterator.next());
        }
        this.setWells(list);
    }

    private void addWell(Well well) {
        try {
            if (this.preloadWellData) {
                this.loadWellData(well);
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            LOGGER.log(Level.SEVERE, "Error initialising well for chart block - well not added", e);
            return;
        }
        well.addWeakObserver((Observer)this);
        this.initMemberWellObservation(well);
        this.wells.add(well);
    }

    private void loadWellData(Well well) throws SQLException, SBException {
        well.getSamples();
        well.loadInterps();
        well.loadInterp(well.getInterp(this.interpID));
    }

    abstract void initMemberWellObservation(Well var1);

    abstract void clearMemberWellObservation(Well var1);

    public void disableWellDataPreload() {
        this.preloadWellData = false;
    }

    public WellList getWellList() {
        return this.wellList;
    }

    public int getWellListID() {
        if (this.wellList != null) {
            return this.wellList.getID();
        }
        return 0;
    }

    public final void setWellList(WellList wellList) {
        if (this.wellList == wellList) {
            return;
        }
        if (this.wellList != null) {
            this.wellList.deleteListener((WellListObserver)this);
        }
        this.wellList = wellList;
        wellList.addListener((WellListObserver)this);
        this.setWells(this.wellService.getWellListWells(wellList.getID()));
    }

    public ScaleConverter getScaleConverter(Well well) {
        LOC loc;
        WellInterp interp = this.getInterp(well, this.getInterpID());
        DepthAgeCurve depthAgeCurve = null;
        if (interp != null && (loc = interp.getLOC()) != null) {
            depthAgeCurve = loc.getDepthAgeCurve();
        }
        return new ScaleConverter(this.getTVDList(well), depthAgeCurve, this.getTWTList(well), this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN), this.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX), this.getProp().getScaleType());
    }

    TVDList getTVDList(Well well) {
        if (well != null) {
            try {
                TVDList list = well.getTVDlist(false);
                if (!list.getList().isEmpty()) {
                    return list;
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        return null;
    }

    TWTList getTWTList(Well well) {
        if (well != null) {
            try {
                TWTList list = well.getTWTlist();
                if (list != null && list.getSize() > 0) {
                    return list;
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
        return null;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        if (!Objects.equals(this.caption, caption)) {
            this.caption = caption;
            this.setSoftChanged();
        }
    }

    public String getTemplatedCaption(ChartProperties cp) {
        if (this.getTemplate() == null) {
            return "";
        }
        if (this.caption == null) {
            return this.getDefaultCaption(cp);
        }
        if (this.caption.isEmpty()) {
            return this.caption;
        }
        return this.convertCaption(this.caption, cp);
    }

    public String convertCaption(String caption, ChartProperties cp) {
        if (caption.isEmpty()) {
            return caption;
        }
        Pattern pattern = Pattern.compile("\\<(.*?)\\>");
        Matcher m = pattern.matcher(caption);
        ArrayList<String> replacements = new ArrayList<String>();
        while (m.find()) {
            String display = caption.substring(m.start(), m.end());
            for (CaptionTemplate el : CaptionTemplate.values()) {
                if (!el.toDisplayString().equals(display)) continue;
                replacements.add(this.getCaptionElement(el, cp));
            }
        }
        for (String replacement : replacements) {
            caption = pattern.matcher(caption).replaceFirst(replacement);
        }
        return caption.trim();
    }

    String getCaptionElement(CaptionTemplate el, ChartProperties cp) {
        switch (el) {
            case WELLNAME: {
                if (this.getWellList() != null) {
                    return this.getWellList().getName();
                }
                if (this.getWell() != null) {
                    return this.getWell().getWellName();
                }
                return "";
            }
            case WELLCODE: {
                if (this.getWell() != null) {
                    return this.getWell().getWellCode();
                }
                return "";
            }
            case VERSION: {
                if (this.getWell() == null) {
                    return "";
                }
                String s = "<error>";
                try {
                    InterpHdr hdr = this.getDb().getInterp(this.getInterpID());
                    if (hdr != null) {
                        s = hdr.getDescription();
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
                return s;
            }
            case TEMPLNAME: {
                if (this.getTemplate() != null) {
                    return this.getTemplate().getName();
                }
                return "";
            }
            case SCHEME: {
                Object schName = "";
                try {
                    if (cp.bgSchID > 0) {
                        schName = String.valueOf(this.getDb().getIGDScheme(cp.bgSchID));
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
                return schName;
            }
        }
        return "";
    }

    public abstract String getDefaultCaption(ChartProperties var1);

    public abstract String getProperties();

    public abstract IBlockProperties getProp();

    public abstract void setScaleType(BlockProperties.ScaleType var1);

    public abstract void setLabelScaleType(BlockProperties.ScaleType var1);

    public List<DrawZone> getBackgroundZones() {
        return Collections.EMPTY_LIST;
    }

    public BlockTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(BlockTemplate template) throws SQLException, SBException {
        if (template == this.template) {
            return;
        }
        this.template.deleteListener(this);
        this.templateUpdated = null;
        this.template = template;
        template.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateTemplate(SBdb sbdb, boolean force) throws SQLException, SBPermissionException, SBException {
        if (this.getTemplate() == null) {
            throw new IllegalStateException("Template is null");
        }
        Logger.getLogger(this.getClass().getName()).log(Level.CONFIG, "{0} updating template...", this);
        this.updatingTemplate = true;
        try {
            List<ChartPanelSnapshot> panelSnapshot = this.getPanelSnapshot();
            if (force || !this.getTemplate().equals(panelSnapshot)) {
                this.getTemplate().updatePanels(sbdb, panelSnapshot);
                this.members().forEach(ChartPanel::updatePanelOcc);
                this.setTemplateUpdated();
                this.members().forEach(m -> m.getPanelOcc().notifyObservers());
            }
        }
        finally {
            this.updatingTemplate = false;
        }
    }

    private List<ChartPanelSnapshot> getPanelSnapshot() {
        LinkedList<ChartPanelSnapshot> panelOccUpdates = new LinkedList<ChartPanelSnapshot>();
        for (ChartPanel panel : this.members().collect(Collectors.toList())) {
            if (panel instanceof LayerWellLocationWithSelection) continue;
            if (panel.getTemplateID() == null) {
                throw new IllegalStateException("No template for panel: " + String.valueOf(panel));
            }
            if (panel.getPanelOcc() == null) {
                throw new IllegalStateException("No panelOcc for panel: " + String.valueOf(panel));
            }
            if (!panelOccUpdates.isEmpty() && panelOccUpdates.getLast().getActivePanelOcc() == panel.getPanelOcc()) continue;
            panelOccUpdates.add(panel.createPanelSnapshot());
        }
        return panelOccUpdates;
    }

    void setTemplateUpdated() {
        if (this.template == null) {
            return;
        }
        this.templateUpdated = this.template.getUpdated() != null ? new Date(this.template.getUpdated().getTime()) : new Date();
        this.templateUpdatedUser = this.template.getUpdater();
    }

    public void updateFromTemplate() {
        this.updateFromTemplate(this.getTemplate());
    }

    public void updateFromTemplate(BlockTemplate blockTemplateToCopy) {
        this.members().forEach(ChartPanel::clearPanelOccTemp);
        if (!blockTemplateToCopy.equals(this.getPanelSnapshot())) {
            LOGGER.log(Level.CONFIG, "{0} (block) updating panels from template...", this);
            this.clearMembers();
            for (PanelOcc po : blockTemplateToCopy.getPanels()) {
                try {
                    PanelTemplate panelTemplate = blockTemplateToCopy.getPanelTemplate(po.getPanelID());
                    Optional<PanelProperties> newPanelProperties = Optional.empty();
                    if (this.getTemplate() != blockTemplateToCopy && !panelTemplate.isVisible()) {
                        PanelTemplate defaultTemplate = blockTemplateToCopy.getPanelTemplate(panelTemplate.getType());
                        newPanelProperties = Optional.of(panelTemplate.getProperties().copy());
                        panelTemplate = defaultTemplate;
                        po = new PanelOcc(panelTemplate.getID(), po.getInterpID(), po.getCaption(), po.getSubCaption(), po.getCapOrient(), po.getSchID());
                    }
                    List<ChartPanel> newMembers = this.addNewMember(panelTemplate, po);
                    newPanelProperties.ifPresent(pprop -> newMembers.stream().forEach(m -> m.setProperties((PanelProperties)pprop)));
                }
                catch (SQLException | SBException ex) {
                    LOGGER.log(Level.SEVERE, "Caught exception while loading panel template", ex);
                }
            }
            this.setPropertyChanged();
        }
        this.setTemplateUpdated();
    }

    public boolean hasLocalChanges() {
        List<PanelOcc> templatePanelOccs = this.getTemplate().getPanels();
        List panels = this.members().collect(Collectors.toList());
        if (panels.size() != templatePanelOccs.size()) {
            return true;
        }
        record PanelRecord(ChartPanel panel, PanelOcc panelOcc) {
            boolean hasChanges() {
                return !this.panel.getProperties().equals(this.panel.getTemplate().getProperties()) || !this.panelOcc.equals((Object)this.panel.getPanelOcc());
            }
        }
        return IntStream.range(0, panels.size()).mapToObj(i -> new PanelRecord((ChartPanel)panels.get(i), (PanelOcc)((Object)((Object)templatePanelOccs.get(i))))).anyMatch(PanelRecord::hasChanges);
    }

    public void clearLocalChanges() {
        this.members().forEach(ChartPanel::clearPanelOccTemp);
        this.members().forEach(chartPanel -> chartPanel.setProperties(chartPanel.getTemplate().getProperties()));
        this.setDataChanged();
    }

    public abstract List<ChartPanel> addNewMember(PanelTemplate var1, PanelOcc var2) throws SQLException, SBException;

    public abstract void addMember(ChartPanel var1);

    public abstract Stream<ChartPanel> members();

    public abstract void clearMembers();

    public void setSelectedPanel(ChartPanel selected) {
        this.members().forEach(m -> {
            m.setTemplateSelected(selected != null && selected.getTemplate() != null && m.getTemplate() == selected.getTemplate());
            m.setPanelOccSelected(m == selected);
        });
    }

    public void setSelectedPanels(PanelTemplate selection) {
        this.members().forEach(m -> {
            m.setTemplateSelected(selection != null && Objects.equals(selection.getID(), m.getTemplateID()));
            m.setPanelOccSelected(false);
        });
    }

    public Optional<ChartPanel> getSelectedPanel() {
        return this.members().filter(ChartPanel::isPanelOccSelected).findFirst();
    }

    public void useEditingPanelProperties() {
        this.members().forEach(m -> m.useEditingProperties());
    }

    public boolean equalsTemplate() {
        List<ChartPanelSnapshot> panelOccUpdates = this.getPanelSnapshot();
        return this.getTemplate().equals(panelOccUpdates);
    }

    public abstract boolean moveSelectedPanel(boolean var1);

    public abstract boolean removeSelectedPanel();

    public abstract void removePanel(ChartPanel var1);

    @Override
    public void onTemplateMembersUpdated() {
        if (this.updatingTemplate) {
            return;
        }
        this.updateFromTemplate(this.getTemplate());
        this.notifyListeners();
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setTemplateSelected(boolean isSelected) {
        this.isTemplateSelected = isSelected;
    }

    public boolean isTemplateSelected() {
        return this.isTemplateSelected;
    }
}

