/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProjectLocation;
import jsbchart.panel.SBPanel;
import model3.SBdb;
import util.SBException;

public class LocationBlock
extends ChartBlock {
    public PanelProjectLocation panel;
    public float scale = 10000.0f;

    public LocationBlock(SBdb sbdb) {
        super(sbdb, null);
        this.prop = new BlockProperties(BlockProperties.ScaleType.MD);
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> correlationLines, Chart.Mode vMode) {
        x = this.panel.draw(g, x, y, p, this.prop, mode, correlationLines);
        return x;
    }

    public void clearPanel() {
        this.panel = null;
    }

    public float scale(float offset) {
        return offset * 1000.0f / this.scale;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, float zoom) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        String string = this.panel.getTooltip(x, y, cp, this.prop, zoom);
        return string;
    }

    @Override
    public Point2D.Float getPanelOrigin(SBPanel panel, float x, float y, Chart.Mode mode, float xPos, ChartProperties cp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getHeight() {
        this.prop.setHeight(this.panel.getHeight(this.prop) * 1000.0f / this.scale);
        return this.prop.getHeight();
    }

    @Override
    public float getWidth(ChartProperties cp) {
        return this.panel.getWidth(this.prop) * 1000.0f / this.scale;
    }

    public PanelProjectLocation getPanel() {
        return this.panel;
    }

    @Override
    public BlockType getBlockType() {
        return null;
    }

    @Override
    public Set<CorrelationLine> getCorrelationLines(Correlation c, ChartProperties cp) throws SQLException, SBException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection<CorrelationPoint> getYPos(CorrelationLine line, boolean visibleOnly, boolean useBlockInterp, ChartProperties cp, int maxUnconfidence, boolean correlateRangedIntervals) throws SBException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDefaultCaption(ChartProperties p) {
        return "";
    }
}

