/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jsbchart.graphics.map.SBMapRenderer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;

public class MapBlockSwingWorker
extends SwingWorker<BufferedImage, Void> {
    private static final Logger LOGGER = Logger.getLogger(MapBlockSwingWorker.class.getName());
    private final MapViewport viewport;
    private final Dimension imageSizeInPixels;
    private final MapContent map;
    private final Consumer<BufferedImage> imageTarget;

    MapBlockSwingWorker(Consumer<BufferedImage> imageTarget, MapViewport viewport, Dimension imageSizeInPixels, MapContent mapToDraw) {
        this.imageTarget = imageTarget;
        this.viewport = viewport;
        this.imageSizeInPixels = imageSizeInPixels;
        this.map = mapToDraw;
    }

    @Override
    public BufferedImage doInBackground() {
        LOGGER.log(Level.FINEST, "Beginning rendering on {0} {1}", new Object[]{Thread.currentThread().getName(), System.identityHashCode(this)});
        SBMapRenderer sbMapRenderer = new SBMapRenderer();
        MapViewport newVp = new MapViewport();
        newVp.setMatchingAspectRatio(this.viewport.isMatchingAspectRatio());
        newVp.setScreenArea(new Rectangle(0, 0, this.imageSizeInPixels.width, this.imageSizeInPixels.height));
        newVp.setBounds(this.viewport.getBounds());
        this.map.setViewport(newVp);
        BufferedImage img = sbMapRenderer.renderMapToBufferedImage(this.map, this.imageSizeInPixels);
        return img;
    }

    @Override
    public void done() {
        try {
            BufferedImage image = (BufferedImage)this.get();
            this.imageTarget.accept(image);
        }
        catch (CancellationException ex) {
            LOGGER.log(Level.FINEST, "Rendering cancelled on MapBlockSwingWorker {0}", new Object[]{Thread.currentThread().getName()});
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.CONFIG, "Rendering interrupted on MapBlockSwingWorker {0}", new Object[]{Thread.currentThread().getName()});
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while retrieving background map image on worker " + System.identityHashCode(this), e);
        }
    }
}

