/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlockProperties;
import jsbchart.graphics.SBGraphicsConverter;
import jsbchart.graphics.map.SBMapViewport;
import jsbchart.util.GeotoolsUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class MapBlockViewport
implements SBMapViewport {
    private static final Logger LOGGER = Logger.getLogger(MapBlockViewport.class.getName());
    private MapViewport mapViewport = new MapViewport();
    SBGraphicsConverter converter = new SBGraphicsConverter(0.028346456587314606);

    public MapBlockViewport() {
        CoordinateReferenceSystem crs = GeotoolsUtils.getWGS84CRS();
        double lonMin = -178.0;
        double lonMax = 178.0;
        double latMin = -89.0;
        double latMax = 89.0;
        ReferencedEnvelope envelope = new ReferencedEnvelope(lonMin, lonMax, latMin, latMax, crs);
        this.mapViewport.setCoordinateReferenceSystem(crs);
        this.mapViewport.setBounds(envelope);
        this.mapViewport.setMatchingAspectRatio(true);
        this.mapViewport.setScreenArea(new Rectangle(0, 0, 100, 100));
    }

    public ReferencedEnvelope getBounds() {
        return this.mapViewport.getBounds();
    }

    public void setBounds(ReferencedEnvelope bounds) {
        this.mapViewport.setBounds(bounds);
    }

    public void setViewportScreenArea(Rectangle areaInPx) {
        this.mapViewport.setScreenArea(areaInPx);
    }

    public void setMatchAspectRatio(boolean value) {
        this.mapViewport.setMatchingAspectRatio(value);
    }

    public MapViewport getMapViewport() {
        return this.mapViewport;
    }

    @Override
    public Rectangle2D.Float getMapArea() {
        float xMM = this.converter.convertUnscaledPixelsToFloat(this.mapViewport.getScreenArea().x);
        float yMM = this.converter.convertUnscaledPixelsToFloat(this.mapViewport.getScreenArea().y);
        float widthMM = this.converter.convertUnscaledPixelsToFloat(this.mapViewport.getScreenArea().width);
        float heightMM = this.converter.convertUnscaledPixelsToFloat(this.mapViewport.getScreenArea().height);
        return new Rectangle2D.Float(xMM, yMM, widthMM, heightMM);
    }

    public void setMapAreaAndBounds(Rectangle mapAreaInPx, MapBlockProperties props) {
        this.mapViewport.setScreenArea(mapAreaInPx);
        try {
            this.mapViewport.setMatchingAspectRatio(true);
            this.mapViewport.setBounds(props.getReferenceEnvelope());
            this.mapViewport.setCoordinateReferenceSystem(props.getCRS());
        }
        catch (FactoryException | TransformException ex) {
            LOGGER.log(Level.SEVERE, "Error setting viewport on map", ex);
        }
    }

    public void setBounds(MapBlockProperties props) {
        try {
            this.mapViewport.setMatchingAspectRatio(true);
            this.mapViewport.setBounds(props.getReferenceEnvelope());
            this.mapViewport.setCoordinateReferenceSystem(props.getCRS());
        }
        catch (FactoryException | TransformException ex) {
            LOGGER.log(Level.SEVERE, "Error setting viewport on map", ex);
        }
    }

    public void setViewportPosition(float xMM, float yMM) {
        int xPx = this.converter.convertFloatToUnscaledPixels(xMM);
        int yPx = this.converter.convertFloatToUnscaledPixels(yMM);
        ReferencedEnvelope originalBounds = this.mapViewport.getBounds();
        Rectangle screenArea = this.mapViewport.getScreenArea();
        screenArea.setLocation(xPx, yPx);
        this.mapViewport.setScreenArea(screenArea);
        this.mapViewport.setBounds(originalBounds);
    }

    public ReferencedEnvelope convertMMRectToMapUnits(Rectangle2D.Float rect) {
        AffineTransform screenToWorld = this.calculateScreenToWorldTransformRelativeToViewport();
        if (screenToWorld == null) {
            return null;
        }
        Rectangle searchAreaPx = this.calcRectInUnscaledPixels(rect);
        Rectangle2D searchAreaMapUnits = screenToWorld.createTransformedShape(searchAreaPx).getBounds2D();
        ReferencedEnvelope bbox = new ReferencedEnvelope(searchAreaMapUnits, this.mapViewport.getCoordinateReferenceSystem());
        bbox.setCoordinateReferenceSystem(this.mapViewport.getCoordinateReferenceSystem());
        return bbox;
    }

    public Position2D getLatLonOfMapPosition(float x, float y) {
        AffineTransform tr = this.calculateScreenToWorldTransformRelativeToViewport();
        if (tr == null) {
            return null;
        }
        Rectangle2D.Float mapAreaMM = this.getMapArea();
        float viewportX = x - mapAreaMM.x;
        float viewportY = y - mapAreaMM.y;
        Point pointInPx = this.calculatePointInUnscaledPixels(new Point2D.Float(viewportX, viewportY));
        Position2D pos = new Position2D((double)pointInPx.x, (double)pointInPx.y);
        tr.transform((Point2D)pos, (Point2D)pos);
        pos.setCoordinateReferenceSystem(this.mapViewport.getCoordinateReferenceSystem());
        return pos;
    }

    @Override
    public Position2D getLatLonOfMapPosition(Point2D.Float mapPosition) {
        return this.getLatLonOfMapPosition(mapPosition.x, mapPosition.y);
    }

    public ReferencedEnvelope calculateZoomAtPoint(Point2D.Float pointInMM, double zoom) {
        ReferencedEnvelope boundsWGS84 = this.getViewportBoundsInWGS84();
        if (boundsWGS84 == null) {
            return null;
        }
        zoom = MapBlockViewport.calculateMaxAllowedZoom(zoom, boundsWGS84);
        AffineTransform screenToWorld = this.getSimpleScreenToWorldTransform(boundsWGS84);
        if (screenToWorld == null) {
            return null;
        }
        Point zoomPointPx = this.calculatePointInUnscaledPixels(pointInMM);
        screenToWorld.translate(zoomPointPx.x, zoomPointPx.y);
        screenToWorld.scale(zoom, zoom);
        screenToWorld.translate(-zoomPointPx.x, -zoomPointPx.y);
        Position2D lowerCorner = new Position2D();
        Position2D upperCorner = new Position2D();
        screenToWorld.transform(new Point2D.Float(0.0f, 0.0f), (Point2D)lowerCorner);
        screenToWorld.transform(new Point2D.Float(this.mapViewport.getScreenArea().width, this.mapViewport.getScreenArea().height), (Point2D)upperCorner);
        ReferencedEnvelope newBounds = new ReferencedEnvelope(lowerCorner.x, upperCorner.x, upperCorner.y, lowerCorner.y, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return newBounds;
    }

    public ReferencedEnvelope calculateZoomToRect(Rectangle2D.Float mmRectRelativeToMapBox) {
        ReferencedEnvelope boundsWGS84 = this.getViewportBoundsInWGS84();
        if (boundsWGS84 == null) {
            return null;
        }
        AffineTransform screenToWorld = this.getSimpleScreenToWorldTransform(boundsWGS84);
        if (screenToWorld == null) {
            return null;
        }
        Rectangle zoomAreaInPx = this.calcRectInUnscaledPixels(mmRectRelativeToMapBox);
        LOGGER.log(Level.CONFIG, "zoom to rect {1}", new Object[]{mmRectRelativeToMapBox});
        Position2D upperLeftCorner = new Position2D();
        Position2D lowerRightCorner = new Position2D();
        screenToWorld.transform((Point2D)new Position2D((double)zoomAreaInPx.x, (double)zoomAreaInPx.y), (Point2D)upperLeftCorner);
        screenToWorld.transform((Point2D)new Position2D((double)(zoomAreaInPx.x + zoomAreaInPx.width), (double)(zoomAreaInPx.y + zoomAreaInPx.height)), (Point2D)lowerRightCorner);
        ReferencedEnvelope newBounds = new ReferencedEnvelope(upperLeftCorner.x, lowerRightCorner.x, lowerRightCorner.y, upperLeftCorner.y, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (newBounds.getWidth() < 0.01) {
            newBounds.expandBy((0.01 - newBounds.getWidth()) * 0.5, 0.0);
        }
        if (newBounds.getHeight() < 0.01) {
            newBounds.expandBy(0.0, (0.01 - newBounds.getHeight()) * 0.5);
        }
        return newBounds;
    }

    @Override
    public Point2D.Float getMMPositionFromLatLon(Position2D posLonLat) {
        AffineTransform tr = this.calculateWorldToScreenTransformRelativeToViewport();
        if (tr == null) {
            return null;
        }
        Position2D posOnMap = GeotoolsUtils.convertPositionToCRS(posLonLat, this.mapViewport.getCoordinateReferenceSystem());
        Position2D posPxRelativeToViewport = new Position2D();
        tr.transform((Point2D)posOnMap, (Point2D)posPxRelativeToViewport);
        Point posPxRelativeToBlock = new Point(new Point((int)posPxRelativeToViewport.x + this.mapViewport.getScreenArea().x, (int)posPxRelativeToViewport.y + this.mapViewport.getScreenArea().y));
        Point2D.Float posMM = this.converter.convertUnscaledPixelsToMMPoint(posPxRelativeToBlock);
        return posMM;
    }

    public Rectangle calcRectInUnscaledPixels(Rectangle2D.Float rectInMM) {
        float pixPerMM = 2.8346457f;
        SBGraphicsConverter converter = new SBGraphicsConverter(pixPerMM / 100.0f);
        int xPixels = converter.convertFloatToUnscaledPixels(rectInMM.x);
        int yPixels = converter.convertFloatToUnscaledPixels(rectInMM.y);
        int widthPixels = converter.convertFloatToUnscaledPixels(rectInMM.width);
        int heightPixels = converter.convertFloatToUnscaledPixels(rectInMM.height);
        return new Rectangle(xPixels, yPixels, widthPixels, heightPixels);
    }

    public Rectangle calcRectInScaledPixels(Rectangle2D.Float mapBlockArea, double zoom) {
        float pixPerMM = 2.8346457f;
        SBGraphicsConverter converter = new SBGraphicsConverter(pixPerMM / 100.0f);
        converter.setZoom(zoom);
        int xPixels = converter.convertFloatToScaledPixels(mapBlockArea.x);
        int yPixels = converter.convertFloatToScaledPixels(mapBlockArea.y);
        int widthPixels = converter.convertFloatToScaledPixels(mapBlockArea.width);
        int heightPixels = converter.convertFloatToScaledPixels(mapBlockArea.height);
        return new Rectangle(xPixels, yPixels, widthPixels, heightPixels);
    }

    public Point calculatePointInUnscaledPixels(Point2D.Float pointInMM) {
        float pixPerMM = 2.8346457f;
        SBGraphicsConverter converter = new SBGraphicsConverter(pixPerMM / 100.0f);
        int x = converter.convertFloatToUnscaledPixels(pointInMM.x);
        int y = converter.convertFloatToUnscaledPixels(pointInMM.y);
        return new Point(x, y);
    }

    private Point2D.Float calculatePointInMMFromPixels(Point pointInPx) {
        float pixPerMM = 2.8346457f;
        SBGraphicsConverter converter = new SBGraphicsConverter(pixPerMM / 100.0f);
        float x = converter.convertUnscaledPixelsToFloat(pointInPx.x);
        float y = converter.convertUnscaledPixelsToFloat(pointInPx.y);
        return new Point2D.Float(x, y);
    }

    private Position2D calculateMapPositionOfPointInPx(Point point) {
        AffineTransform at = this.calculateScreenToWorldTransformRelativeToViewport();
        Position2D pos = new Position2D((double)point.x, (double)point.y);
        at.transform((Point2D)pos, (Point2D)pos);
        pos.setCoordinateReferenceSystem(this.mapViewport.getCoordinateReferenceSystem());
        return pos;
    }

    private AffineTransform calculateScreenToWorldTransformRelativeToViewport() {
        double xscale = this.mapViewport.getBounds().getWidth() / this.mapViewport.getScreenArea().getWidth();
        double yscale = this.mapViewport.getBounds().getHeight() / this.mapViewport.getScreenArea().getHeight();
        AffineTransform screenToWorld = new AffineTransform(xscale, 0.0, 0.0, -yscale, this.mapViewport.getBounds().getMinX(), this.mapViewport.getBounds().getMaxY());
        return screenToWorld;
    }

    private AffineTransform calculateWorldToScreenTransformRelativeToViewport() {
        double xscale = this.mapViewport.getScreenArea().getWidth() / this.mapViewport.getBounds().getWidth();
        double yscale = this.mapViewport.getScreenArea().getHeight() / this.mapViewport.getBounds().getHeight();
        AffineTransform screenToWorld = new AffineTransform(xscale, 0.0, 0.0, -yscale, -xscale * this.mapViewport.getBounds().getMinX(), yscale * this.mapViewport.getBounds().getMaxY());
        return screenToWorld;
    }

    private static double calculateMaxAllowedZoom(double zoom, ReferencedEnvelope bounds) {
        double newWidth = zoom * bounds.getWidth();
        double newHeight = zoom * bounds.getHeight();
        double lonZoom = zoom;
        double latZoom = zoom;
        if (newWidth < 0.01) {
            lonZoom = 0.01 / bounds.getWidth();
        } else if (newWidth > 540.0) {
            lonZoom = 540.0 / bounds.getWidth();
        }
        if (newHeight < 0.01) {
            latZoom = 0.01 / bounds.getHeight();
        } else if (newHeight > 270.0) {
            latZoom = 270.0 / bounds.getHeight();
        }
        zoom = Math.max(lonZoom, latZoom);
        return zoom;
    }

    public ReferencedEnvelope getViewportBoundsInWGS84() {
        ReferencedEnvelope bounds = this.mapViewport.getBounds();
        bounds.setCoordinateReferenceSystem(this.mapViewport.getCoordinateReferenceSystem());
        ReferencedEnvelope boundsWGS84 = null;
        try {
            boundsWGS84 = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (FactoryException | TransformException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        return boundsWGS84;
    }

    private AffineTransform getSimpleScreenToWorldTransform(ReferencedEnvelope bounds) {
        double xscale = bounds.getWidth() / this.mapViewport.getScreenArea().getWidth();
        double yscale = bounds.getHeight() / this.mapViewport.getScreenArea().getHeight();
        return new AffineTransform(xscale, 0.0, 0.0, -yscale, bounds.getMinX(), bounds.getMaxY());
    }

    public ReferencedEnvelope calculateMapPan(Point2D.Float dragOrigin, Point2D.Float dragDestination) {
        Point destInPx;
        Point originInPx = this.calculatePointInUnscaledPixels(dragOrigin);
        if (originInPx.equals(destInPx = this.calculatePointInUnscaledPixels(dragDestination))) {
            return null;
        }
        Position2D originPos = this.calculateMapPositionOfPointInPx(originInPx);
        Position2D destPos = this.calculateMapPositionOfPointInPx(destInPx);
        double deltaX = originPos.x - destPos.x;
        double deltaY = originPos.y - destPos.y;
        double newMaxX = this.mapViewport.getBounds().getMaxX() + deltaX;
        double newMinX = this.mapViewport.getBounds().getMinX() + deltaX;
        double newMaxY = this.mapViewport.getBounds().getMaxY() + deltaY;
        double newMinY = this.mapViewport.getBounds().getMinY() + deltaY;
        ReferencedEnvelope newBounds = new ReferencedEnvelope(newMinX, newMaxX, newMinY, newMaxY, this.mapViewport.getCoordinateReferenceSystem());
        return newBounds;
    }
}

