/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.block;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import jsbchart.block.BlockProperties;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.EventLine;
import jsbchart.correlation.IGDUnitLine;
import jsbchart.correlation.SurfaceLine;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelCompositeStandard;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.PanelRange;
import jsbchart.panel.PanelSequences;
import jsbchart.panel.PanelSurfaces;
import jsbchart.panel.SBPanel;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbchart.util.DrawZone;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBEvent;
import model3.SBdb;
import model3.Surface;
import util.ColourUtils;
import util.InvalidFieldException;
import util.SBException;

public class SchemeBlock
extends ChartBlock {
    public static float[] scales = new float[]{0.5f, 1.0f, 5.0f, 20.0f, 50.0f, 100.0f};
    public static final float AGE_SCALE_MIN = 0.1f;
    public static final float AGE_SCALE_MAX = 1000.0f;
    private LinkedList<DrawZone> backgroundUnits;

    public SchemeBlock(SBdb db) {
        super(db, null);
        this.prop = new BlockProperties(BlockProperties.ScaleType.AGE);
    }

    public SchemeBlock(SBdb sbdb, BlockTemplate template, BlockProperties bp) {
        super(sbdb, template);
        this.prop = bp != null ? bp : new BlockProperties(BlockProperties.ScaleType.AGE);
    }

    public void setTemplateProperties() throws SQLException {
        Double min = null;
        Double max = null;
        for (SBPanel panel : this.getPanels()) {
            double smax;
            double smin;
            IGDScheme scheme = null;
            CompositeStandard std = null;
            if (panel instanceof PanelSequences) {
                scheme = (IGDScheme)panel.getProperties().getProperty(0);
            } else if (panel instanceof PanelIGDScheme) {
                scheme = (IGDScheme)panel.getProperties().getProperty(0);
            } else if (panel instanceof PanelLithostratScheme) {
                scheme = ((PanelLithostratScheme)panel).getScheme();
            } else if (panel instanceof PanelCompositeStandard) {
                std = ((PanelCompositeStandard)panel).getCmpStd();
            } else if (panel instanceof PanelRange) {
                std = ((PanelRange)panel).getComposite();
            }
            if (scheme != null) {
                smin = scheme.getMinAge();
                smax = scheme.getMaxAge();
            } else {
                if (std == null) continue;
                smin = std.getMinAge();
                smax = std.getMaxAge();
            }
            if (min == null || min > smin) {
                min = smin;
            }
            if (max != null && !(max < smax)) continue;
            max = smax;
        }
        this.prop.setMin(min != null ? min.floatValue() : 0.0f);
        this.prop.setMax(max != null ? max.floatValue() : 0.0f);
        this.prop.setScale(SchemeBlock.calcIdealScale(this.prop.getMin(), this.prop.getMax()));
    }

    public SchemeBlock(BlockProperties bp) {
        super(null, null);
        if (bp == null) {
            throw new IllegalArgumentException("Attempt to create scheme block with null properties");
        }
        this.prop = bp;
    }

    public IGDScheme getScheme() {
        for (SBPanel panel : this.getPanels()) {
            if (!panel.getClass().equals(PanelIGDScheme.class)) continue;
            PanelIGDScheme schemePanel = (PanelIGDScheme)panel;
            return schemePanel.getScheme();
        }
        return null;
    }

    public CompositeStandard getCompositeStandard() {
        for (SBPanel panel : this.getPanels()) {
            if (!panel.getClass().equals(PanelCompositeStandard.class)) continue;
            PanelCompositeStandard schemePanel = (PanelCompositeStandard)panel;
            return schemePanel.getStd();
        }
        return null;
    }

    public SBPanel getPanelHorz(float y) {
        int totalWidth = 0;
        for (SBPanel panel : this.getPanels()) {
            int n;
            if (!(y > (float)totalWidth)) continue;
            totalWidth = (int)((float)totalWidth + panel.getWidth(this.prop));
            if (!(y <= (float)n)) continue;
            return panel;
        }
        return null;
    }

    @Override
    public Point2D.Float getPanelOrigin(SBPanel panel, float x, float y, Chart.Mode mode, float xPosInPanel, ChartProperties cp) {
        float xPos = 0.0f;
        for (SBPanel p : this.getPanels()) {
            if (p == panel) {
                return new Point2D.Float(xPos, y);
            }
            if (!cp.drawEmptyPanels && !panel.hasData(this.prop)) continue;
            xPos += p.getWidth(this.prop);
        }
        return null;
    }

    public Point2D.Float getPanelOrigin(SBPanel panel) {
        float xPos = 0.0f;
        float y = 0.0f;
        for (SBPanel p : this.getPanels()) {
            if (p == panel) {
                return new Point2D.Float(xPos, y);
            }
            xPos += p.getWidth(this.prop);
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, float zoom) {
        String obj = null;
        float xLeft = 0.0f;
        for (SBPanel panel : this.getPanels()) {
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getTooltip(x - xLeft, y, cp, this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, float zoom) {
        Object obj = null;
        float xLeft = 0.0f;
        for (SBPanel panel : this.getPanels()) {
            float xRight = xLeft + panel.getWidth(this.prop);
            if (x < xRight) {
                obj = panel.getObject(x - xLeft, y, cp, this.prop, zoom);
                break;
            }
            xLeft = xRight;
        }
        return obj;
    }

    @Override
    synchronized float draw(SBGraphics g, float x, float y, ChartProperties p, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, Chart.Mode vMode) {
        float xpos = this.drawPanels(g, x, y, p, mode, cLines, vMode);
        return xpos;
    }

    public float drawHorz(SBGraphics g, float x, float y, ChartProperties p) {
        Iterator it = this.panels.iterator();
        float yPos = y;
        while (it.hasNext()) {
            SBPanel panel = (SBPanel)it.next();
            yPos += panel.drawHorz(g, x, yPos, p, this.prop);
        }
        return x;
    }

    public static void fillScaleCombo(DefaultComboBoxModel model) {
        model.removeAllElements();
        for (int i = 0; i < scales.length; ++i) {
            model.addElement(Float.valueOf(scales[i]));
        }
    }

    public static float calcIdealScale(double minAge, double maxAge) {
        double ideal = 500.0 / (maxAge - minAge);
        float closest = scales[scales.length - 1];
        for (int i = scales.length; i > 0 && ideal < (double)scales[i - 1]; --i) {
            closest = scales[i - 1];
        }
        return closest;
    }

    public void setIdealScale() {
        float ideal = 500.0f / (this.prop.getMax() - this.prop.getMin());
        float closest = scales[scales.length - 1];
        for (int i = scales.length; i > 0 && ideal < scales[i - 1]; --i) {
            closest = scales[i - 1];
        }
        this.prop.setScale(closest);
    }

    public float scaleAge(float value) {
        if (this.prop.scaleType != BlockProperties.ScaleType.AGE) assert (false);
        return this.scale(value, BlockProperties.ScaleType.AGE);
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.SCHEME;
    }

    @Override
    public void setMin(float min, int section) throws InvalidFieldException {
        if (min < 0.0f) {
            min = 0.0f;
        }
        if ((double)Math.abs(min - this.prop.getMin()) < 1.0E-6) {
            return;
        }
        super.setMin(min, section);
    }

    @Override
    public void setMin(float min) throws InvalidFieldException {
        if (min < 0.0f) {
            min = 0.0f;
        }
        if ((double)Math.abs(min - this.prop.getMin()) < 1.0E-6) {
            return;
        }
        super.setMin(min);
    }

    public Collection<CompositeStandard> getCompositeStandards() {
        HashSet<CompositeStandard> set = new HashSet<CompositeStandard>();
        for (SBPanel panel : this.getPanels()) {
            if (panel instanceof PanelCompositeStandard) {
                set.add(((PanelCompositeStandard)panel).getStd());
                continue;
            }
            if (!(panel instanceof PanelRange)) continue;
            set.add(((PanelRange)panel).getComposite());
        }
        return set;
    }

    public Collection<IGDScheme> getSequenceSchemes() {
        HashSet<IGDScheme> list = new HashSet<IGDScheme>();
        for (SBPanel panel : this.getPanels()) {
            if (!panel.getClass().equals(PanelSurfaces.class)) continue;
            PanelSurfaces surfacePanel = (PanelSurfaces)panel;
            list.add(surfacePanel.getScheme());
        }
        return list;
    }

    private Collection<IGDScheme> getIGDSchemes(int igdType) {
        HashSet<IGDScheme> schemes = new HashSet<IGDScheme>();
        for (SBPanel panel : this.getPanels()) {
            if (panel instanceof PanelIGDScheme) {
                PanelIGDScheme p = (PanelIGDScheme)panel;
                if (p.getScheme().getIGDType() != igdType) continue;
                schemes.add(p.getScheme());
                continue;
            }
            if (!(panel instanceof PanelLithostratScheme)) continue;
            PanelLithostratScheme p = (PanelLithostratScheme)panel;
            if (igdType != 2) continue;
            schemes.add(p.getScheme());
        }
        return schemes;
    }

    @Override
    public Collection<CorrelationPoint> getYPos(CorrelationLine line, boolean visibleOnly, boolean useBlockInterp, ChartProperties cp, int maxUnconfidence, boolean correlateRangedIntervals) throws SQLException {
        class AgeBndPair {
            final double age;
            final Boundary bnd;

            AgeBndPair(SchemeBlock this$0, double age, Boundary bnd) {
                Objects.requireNonNull(this$0);
                this.age = age;
                this.bnd = bnd;
            }
        }
        ArrayList<AgeBndPair> ages = new ArrayList<AgeBndPair>();
        Boundary bnd = line.getStyle().getBnd();
        switch (line.getCorrelationType()) {
            case EVENT: {
                EventLine eLine = (EventLine)line;
                for (CompositeStandard std : this.getCompositeStandards()) {
                    for (CompositeStandardEvent e : std.getEvents(true)) {
                        if (e.getEvID() != ((SBEvent)eLine.getObject()).getEvID() || e.getType() != eLine.getEventType() || e.getConfidence().getDBint() > maxUnconfidence) continue;
                        ages.add(new AgeBndPair(this, std.getAge(e.getCSU()), (Boundary)(bnd == null ? Boundary.CONF : null)));
                    }
                }
                break;
            }
            case SURFACE: {
                for (IGDScheme scheme : this.getSequenceSchemes()) {
                    for (Surface surface : scheme.getSurfaces()) {
                        if (surface.getSurfaceID() != ((Surface)line.getObject()).getSurfaceID()) continue;
                        ages.add(new AgeBndPair(this, surface.getAge(), (Boundary)(bnd == null ? Boundary.CONF : null)));
                    }
                }
                break;
            }
            case CHRONO: 
            case LITHO: 
            case BIOZONE: {
                int igdType = DataType.getIGDType((DataType)line.getCorrelationType().getDataType());
                IGDUnitBase unit = (IGDUnitBase)line.getObject();
                for (IGDScheme scheme : this.getIGDSchemes(igdType)) {
                    if (scheme.getID() != unit.getSchID() || !unit.hasAges()) continue;
                    if (line.getObjectType() == IGDIntervalZone.BoundaryType.TOP) {
                        ages.add(new AgeBndPair(this, unit.getUage(), (Boundary)(bnd == null ? Boundary.CONF : null)));
                        continue;
                    }
                    if (line.getObjectType() != IGDIntervalZone.BoundaryType.BASE) continue;
                    ages.add(new AgeBndPair(this, unit.getLage(), (Boundary)(bnd == null ? Boundary.CONF : null)));
                }
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        if (ages.isEmpty()) {
            return null;
        }
        ArrayList<CorrelationPoint> ypos = new ArrayList<CorrelationPoint>();
        for (AgeBndPair pair : ages) {
            if (!(pair.age >= (double)this.getAgeLimit(true)) || !(pair.age <= (double)this.getAgeLimit(false))) continue;
            ypos.add(new CorrelationPoint(line, this.scaleAge((float)pair.age), pair.bnd));
        }
        return ypos.isEmpty() ? null : ypos;
    }

    @Override
    public Set<CorrelationLine> getCorrelationLines(Correlation c, ChartProperties cp) throws SQLException, SBException {
        float minAge = this.getAgeLimit(true);
        float maxAge = this.getAgeLimit(false);
        HashSet<CorrelationLine> lines = new HashSet<CorrelationLine>();
        switch (c.getCorrType()) {
            case EVENT: {
                for (CompositeStandard std : this.getCompositeStandards()) {
                    for (CompositeStandardEvent e : std.getEvents(true)) {
                        double age;
                        if (!c.includesType(e.getType()) || !((age = std.getAge(e.getCSU())) >= (double)minAge) || !(age <= (double)maxAge)) continue;
                        lines.add(new EventLine(e.getEvent(), e.getType(), c.getDefaultLineStyle(), c.getInterpID()));
                    }
                }
                break;
            }
            case SURFACE: {
                for (IGDScheme scheme : this.getSequenceSchemes()) {
                    for (Surface surface : scheme.getSurfaces()) {
                        double age = surface.getAge();
                        if (!(age >= (double)minAge) || !(age <= (double)maxAge)) continue;
                        lines.add(new SurfaceLine(surface, c.getDefaultLineStyle(), (Integer)c.getInterpID()));
                    }
                }
                break;
            }
            case CHRONO: 
            case LITHO: 
            case BIOZONE: {
                int igdType = DataType.getIGDType((DataType)c.getCorrType().getDataType());
                for (IGDScheme scheme : this.getIGDSchemes(igdType)) {
                    if (scheme.getID() != c.getSchID()) continue;
                    for (IGDUnit unit : scheme.getUnits()) {
                        double baseAge;
                        double topAge;
                        if (unit.getHier() != c.getHier()) continue;
                        if (c.includesType(IGDIntervalZone.BoundaryType.TOP) && unit.hasAges() && (topAge = unit.getUage().doubleValue()) >= (double)minAge && topAge <= (double)maxAge) {
                            lines.add(new IGDUnitLine(c.getCorrType(), (IGDUnitBase)unit, IGDIntervalZone.BoundaryType.TOP, c.getDefaultLineStyle(), c.getInterpID()));
                        }
                        if (!c.includesType(IGDIntervalZone.BoundaryType.BASE) || !unit.hasAges() || !((baseAge = unit.getUage().doubleValue()) >= (double)minAge) || !(baseAge <= (double)maxAge)) continue;
                        lines.add(new IGDUnitLine(c.getCorrType(), (IGDUnitBase)unit, IGDIntervalZone.BoundaryType.BASE, c.getDefaultLineStyle(), c.getInterpID()));
                    }
                }
                break;
            }
            default: {
                assert (false);
                return null;
            }
        }
        return lines;
    }

    @Override
    public List<DrawZone> getBackgroundZones() {
        if (this.backgroundUnits == null) {
            return Collections.EMPTY_LIST;
        }
        return this.backgroundUnits;
    }

    @Override
    public void setData(ChartProperties cp) throws SQLException, SBException, IOException {
        super.setData(cp);
        if (cp.bgSchID <= 0) {
            this.backgroundUnits = null;
            return;
        }
        IGDScheme scheme = this.getDb().getIGDScheme(cp.bgSchID);
        if (scheme != null) {
            scheme.loadUnits();
            float minAge = this.getAgeLimit(true);
            float maxAge = this.getAgeLimit(false);
            this.backgroundUnits = new LinkedList();
            for (IGDUnitBase unit : scheme.getIGDType() == 2 ? scheme.getLithostratUnits() : scheme.getUnitsX()) {
                float yBase;
                if (unit.getHier() > cp.bgHier || !unit.hasAges() || !(unit.getLage() >= (double)minAge) || !(unit.getUage() <= (double)maxAge)) continue;
                double uAge = Math.max(unit.getUage(), (double)minAge);
                double lAge = Math.min(unit.getLage(), (double)maxAge);
                float yTop = this.scaleAge((float)uAge);
                if (Math.abs(yTop - (yBase = this.scaleAge((float)lAge))) < 1.0f) continue;
                DrawZone i = new DrawZone(yTop, yBase, ColourUtils.getLighterColour((Color)unit.getColour(), (float)cp.bgDensity), null, -1, -1, null, null, null, null, 0.0, 0.0);
                i.setObject(unit);
                this.backgroundUnits.add(i);
            }
            Collections.sort(this.backgroundUnits, new Comparator<DrawZone>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(DrawZone o1, DrawZone o2) {
                    if (o1.getObject() != null && o1.getObject() instanceof IGDUnit && o2.getObject() != null && o2.getObject() instanceof IGDUnit) {
                        IGDUnit z1 = (IGDUnit)o1.getObject();
                        IGDUnit z2 = (IGDUnit)o2.getObject();
                        if (z1.getHier() > z2.getHier()) {
                            return 1;
                        }
                        if (z1.getHier() < z2.getHier()) {
                            return -1;
                        }
                    }
                    return 0;
                }
            });
        } else {
            this.backgroundUnits = null;
        }
    }

    public HashSet<SBEvent> getCompositeStandardEvents() {
        HashSet<SBEvent> events = new HashSet<SBEvent>();
        for (SBPanel panel : this.getPanels()) {
            if (!(panel instanceof PanelCompositeStandard)) continue;
            CompositeStandard cmpStd = ((PanelCompositeStandard)panel).getStd();
            for (CompositeStandardEvent cse : cmpStd.getEvents(true)) {
                events.add(cse.getEvent());
            }
        }
        return events;
    }

    @Override
    public void setProperties(BlockProperties bp) {
        this.prop = bp;
    }

    @Override
    public String getDefaultCaption(ChartProperties p) {
        if (this.getTemplate() != null) {
            return this.getTemplate().getName();
        }
        return "";
    }
}

