/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.SQLException;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.ChartManager;
import model3.Audit;
import model3.SBdb;
import util.SB;

public class BlockTemplateChild
extends BlockTemplate {
    private final int parentID;
    private final int wellID;

    BlockTemplateChild(ChartManager manager, int ID, BlockType type, String descr, String comments, int projID, Audit audit, int acm, int parentID, int wellID) {
        super(manager, ID, type, descr, comments, projID, audit, acm);
        this.parentID = parentID;
        this.wellID = wellID;
    }

    @Override
    public int getWellID() {
        return this.wellID;
    }

    @Override
    public Integer getParentID() {
        return this.parentID;
    }

    @Override
    String getInsertFields(SBdb sbdb, int ID) {
        return "INSERT INTO " + sbdb.DBTableName(this.getTableName()) + "(" + this.getTableIDField() + ",type,descr,comments,proj_id,parent_id,well_id";
    }

    @Override
    String getInsertValues(SBdb sbdb, int ID) {
        return ID + "," + SB.DBString((String)this.getType().name()) + ",?,?," + String.valueOf(this.getProjID() > 0 ? Integer.valueOf(this.getProjID()) : "NULL") + "," + this.parentID + "," + this.wellID;
    }

    @Override
    public String toParentString() {
        try {
            return this.getBlockTemplate(this.parentID).toString();
        }
        catch (SQLException ex) {
            return this.toString();
        }
    }
}

