/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import jsbchart.block.BlockType;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateChildException;
import jsbchart.core.ChartManager;
import jsbchart.core.ChartPanelSnapshot;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelType;
import model3.Audit;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class BlockTemplateParent
extends BlockTemplate {
    private final HashMap<Integer, BlockTemplateChild> children = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(BlockTemplateParent.class.getName());

    public BlockTemplateParent(ChartManager manager, int ID, BlockType type, String descr, String comments, int projID, Audit audit, int acm) {
        super(manager, ID, type, descr, comments, projID, audit, acm);
    }

    @Override
    public Integer getParentID() {
        return null;
    }

    public BlockTemplateChild getChild(int wellID) {
        return this.children.get(wellID);
    }

    public BlockTemplateChild getChild(boolean useTemplateID, int childID) {
        for (BlockTemplateChild child : this.children.values()) {
            if (child.getID() != childID) continue;
            return child;
        }
        return null;
    }

    public Set<Integer> getChildWellIDs() {
        return new HashSet<Integer>(this.children.keySet());
    }

    void addChild(BlockTemplateChild child) {
        if (this.getID() == 0) {
            throw new IllegalStateException("Cannot add child before parent is saved");
        }
        if (child.getID() == 0) {
            throw new IllegalStateException("Cannot add child before child is saved");
        }
        if (this.getChild(child.getWellID()) != null) {
            throw new IllegalArgumentException("Block: " + this.getID() + " already has child panel for this well (" + child.getWellID() + ")");
        }
        if (child.getParentID().intValue() != this.getID()) {
            throw new IllegalArgumentException("Tried to add child (" + child.getID() + ") for wrong parent (" + this.getID());
        }
        this.children.put(child.getWellID(), child);
    }

    BlockTemplateChild removeChild(int wellID) {
        return this.children.remove(wellID);
    }

    @Override
    String getInsertFields(SBdb sbdb, int ID) {
        return "INSERT INTO " + sbdb.DBTableName(this.getTableName()) + "(" + this.getTableIDField() + ",type,descr,comments,proj_id";
    }

    @Override
    String getInsertValues(SBdb sbdb, int ID) {
        return ID + "," + SB.DBString((String)this.getType().name()) + ",?,?," + String.valueOf(this.getProjID() > 0 ? Integer.valueOf(this.getProjID()) : "NULL");
    }

    @Override
    public synchronized void updatePanels(SBdb sbdb, List<ChartPanelSnapshot> newPanelList) throws SQLException, SBPermissionException, SBException {
        this.verifyChildren();
        PanelOcc[] originalParentPanels = this.getPanels().toArray(new PanelOcc[this.getPanels().size()]);
        for (BlockTemplateChild childTemplate : this.children.values()) {
            List<PanelOcc> originalChildPanels = childTemplate.getPanels();
            assert (originalParentPanels.length == originalChildPanels.size());
            class PanelOverride {
                final int indexInOriginalPanelList;
                final PanelOcc overridingPanelOcc;

                public PanelOverride(BlockTemplateParent this$0, int indexInOriginalPanelList, PanelOcc overridingPanelOcc) {
                    Objects.requireNonNull(this$0);
                    this.indexInOriginalPanelList = indexInOriginalPanelList;
                    this.overridingPanelOcc = overridingPanelOcc;
                }
            }
            LinkedList<PanelOverride> panelOverrides = new LinkedList<PanelOverride>();
            for (int i = 0; i < originalParentPanels.length; ++i) {
                PanelOcc orig = originalParentPanels[i];
                PanelOcc child = originalChildPanels.get(i);
                assert (orig.getPanelNo().equals(child.getPanelNo()));
                if (orig.equals((Object)child)) continue;
                panelOverrides.add(new PanelOverride(this, i, child));
            }
            ArrayList<ChartPanelSnapshot> childPanelUpdates = new ArrayList<ChartPanelSnapshot>();
            block2: for (ChartPanelSnapshot parentUpdate : newPanelList) {
                Integer originalParentIndex = parentUpdate.getRealPanelOcc().getPanelNo();
                if (originalParentIndex != null) {
                    PanelOcc originalChild = originalChildPanels.get(originalParentIndex);
                    boolean wasOverridden = false;
                    for (PanelOverride panelOverride : panelOverrides) {
                        if (panelOverride.indexInOriginalPanelList != originalParentIndex) continue;
                        if (parentUpdate.getActivePanelOcc().getPanelID() != originalParentPanels[originalParentIndex].getPanelID()) {
                            PanelTemplate originalPanelTemplate = this.getPanelTemplate(originalParentPanels[originalParentIndex].getPanelID());
                            PanelTemplate activePanelTemplate = this.getPanelTemplate(parentUpdate.getActivePanelOcc().getPanelID());
                            assert (originalPanelTemplate.getType() == activePanelTemplate.getType());
                            if (!originalPanelTemplate.getProperties().equals(activePanelTemplate.getProperties())) {
                                childPanelUpdates.add(new ChartPanelSnapshot(PanelOcc.copy(parentUpdate.getActivePanelOcc()), null, null));
                                continue block2;
                            }
                        }
                        originalChild = panelOverride.overridingPanelOcc;
                        wasOverridden = true;
                        break;
                    }
                    PanelOcc updatedPanelOcc = null;
                    if (!wasOverridden && !originalChild.equals((Object)parentUpdate.getActivePanelOcc())) {
                        updatedPanelOcc = parentUpdate.getActivePanelOcc();
                    }
                    childPanelUpdates.add(new ChartPanelSnapshot(originalChild, updatedPanelOcc, null));
                    continue;
                }
                childPanelUpdates.add(new ChartPanelSnapshot(PanelOcc.copy(parentUpdate.getRealPanelOcc()), null, null));
            }
            childTemplate.updatePanels(sbdb, childPanelUpdates);
            for (ChartPanelSnapshot u : childPanelUpdates) {
                u.updateRealPanelOcc();
            }
        }
        super.updatePanels(sbdb, newPanelList);
    }

    private void verifyChildren() throws SQLException, SBException {
        PanelOcc[] panelArr = this.getPanels().toArray(new PanelOcc[this.getPanels().size()]);
        for (BlockTemplateChild childTemplate : this.children.values()) {
            List<PanelOcc> childPanels = childTemplate.getPanels();
            if (panelArr.length != childPanels.size()) {
                throw new BlockTemplateChildException("Child has wrong number of panels", childTemplate.getID(), childTemplate.getWellID());
            }
            PanelOcc[] childPanelArr = childPanels.toArray(new PanelOcc[childPanels.size()]);
            for (int i = 0; i < childPanelArr.length; ++i) {
                PanelType childType;
                PanelType parentType = this.getPanelTemplate(panelArr[i].panelID).getType();
                if (parentType == (childType = this.getPanelTemplate(childPanelArr[i].panelID).getType())) continue;
                throw new BlockTemplateChildException("Child panel order is incorrect", childTemplate.getID(), childTemplate.getWellID());
            }
        }
    }

    public Set<Integer> getOverridingWellIDsForPanel(int panelIndex) {
        if (this.children.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Integer> overridingWellIDs = new HashSet<Integer>();
        PanelOcc parentPanel = this.getPanels().get(panelIndex);
        for (BlockTemplateChild childTemplate : this.children.values()) {
            PanelOcc childPanel = childTemplate.getPanels().get(panelIndex);
            if (childPanel.equals((Object)parentPanel)) continue;
            overridingWellIDs.add(childTemplate.getWellID());
        }
        return overridingWellIDs;
    }

    public void notifyObservers() {
        super.notifyObservers();
        for (BlockTemplate blockTemplate : this.children.values()) {
            blockTemplate.notifyObservers();
        }
    }

    public void notifyObservers(Object arg) {
        super.notifyObservers(arg);
        for (BlockTemplate blockTemplate : this.children.values()) {
            blockTemplate.notifyObservers();
        }
    }

    @Override
    public int getWellID() {
        return 0;
    }

    @Override
    void preDelete(SBdb sbdb, Statement stmt) throws SQLException {
        super.preDelete(sbdb, stmt);
        String sql = "DELETE FROM " + sbdb.DBTableName("CHTBLOCKMBR") + " WHERE block_id IN(SELECT block_id FROM " + sbdb.DBTableName("CHTBLOCK") + " WHERE parent_id=" + this.getID() + ")";
        stmt.executeUpdate(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName(this.getTableName()) + " WHERE parent_id=" + this.getID();
        stmt.executeUpdate(sbdb.modQuery(sql));
    }
}

