/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.BlockColumn;
import jsbchart.core.Chart;
import jsbchart.core.ChartLayout;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.IGDUnitLine;
import model3.IGDIntervalZone;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.Well;
import util.SBException;

class ChartBlockColumn
extends BlockColumn {
    final ChartBlock block;

    public ChartBlockColumn(ChartBlock block) {
        this.block = block;
    }

    @Override
    float getWidth(ChartProperties cp) {
        return this.block.getWidth(cp);
    }

    @Override
    float getTotalHeight(ChartProperties cp) {
        this.block.getProp().calcHeight();
        float h = this.block.getTotalHeight(cp, Chart.Mode.NORMAL);
        if (cp.plotBlockCaptions && cp.blockCapTop) {
            h += cp.blockCapHeight;
        }
        return h;
    }

    @Override
    List<ChartLayout.Position> getBlockPositions(ChartProperties cp) {
        float ypos1 = this.ypos;
        if (cp.plotBlockCaptions && cp.blockCapTop) {
            ypos1 += cp.blockCapHeight;
        }
        return List.of(new ChartLayout.Position(this.xpos, ypos1));
    }

    @Override
    Well getSingleWell() {
        List<Well> wells = this.block.getWells();
        if (wells.size() == 1) {
            return wells.get(0);
        }
        return null;
    }

    @Override
    List<ChartBlockBase> getBlocks() {
        return List.of(this.block);
    }

    Float getYPos(float age, ChartProperties cp) {
        float scaledValue = this.block.scale(age, BlockProperties.ScaleType.AGE);
        if (scaledValue < 0.0f) {
            return null;
        }
        return Float.valueOf(this.ypos + scaledValue + this.block.getHeaderHeight(cp));
    }

    Float getYPos(LithostratUnit unit, ChartProperties cp) {
        if (unit == null) {
            return null;
        }
        Float yPosTop = null;
        Float yPosBase = null;
        try {
            IGDUnitLine baseLine;
            Collection<CorrelationPoint> baseCol;
            IGDUnitLine topLine = new IGDUnitLine(CorrelationType.LITHO, (IGDUnitBase)unit, IGDIntervalZone.BoundaryType.TOP, new CorrLineStyle(null), this.block.getInterpID());
            Collection<CorrelationPoint> topCol = this.block.getYPos(topLine, true, true, cp, 100, true);
            if (topCol != null && !topCol.isEmpty()) {
                yPosTop = Float.valueOf(topCol.iterator().next().ypos());
            }
            if ((baseCol = this.block.getYPos(baseLine = new IGDUnitLine(CorrelationType.LITHO, (IGDUnitBase)unit, IGDIntervalZone.BoundaryType.BASE, new CorrLineStyle(null), this.block.getInterpID()), true, true, cp, 0, true)) != null && !baseCol.isEmpty()) {
                yPosBase = Float.valueOf(baseCol.iterator().next().ypos());
            }
            if (yPosTop != null && yPosBase != null) {
                return Float.valueOf(this.ypos + yPosTop.floatValue() + (yPosBase.floatValue() - yPosTop.floatValue()) / 2.0f + this.block.getHeaderHeight(cp));
            }
        }
        catch (SQLException | SBException sbe) {
            throw new RuntimeException(sbe);
        }
        return null;
    }

    @Override
    boolean plotPinchouts() {
        return !(this.block instanceof SchemeBlock);
    }
}

