/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.core.BlockColumn;
import jsbchart.core.Chart;
import jsbchart.core.ChartBlockColumn;
import jsbchart.core.ChartProperties;
import jsbchart.core.MapColumn;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import model3.Well;

class ChartLayout {
    static final float HALF_LINE = 0.2f;
    float chartWidth = -1.0f;
    float chartHeight = -1.0f;
    float[] blankPanelWidths;
    Position[] blockPositions;
    Position[] blockCaptionPositions;
    Position headerPos;
    float headerWidth;
    KeyLayout keyPos;

    ChartLayout() {
    }

    float keyHeight() {
        return this.keyPos != null ? this.keyPos.h : 0.0f;
    }

    float[] blockXpositions() {
        float[] xpos = new float[this.blockPositions.length];
        for (int i = 0; i < xpos.length; ++i) {
            xpos[i] = this.blockPositions[i].x;
        }
        return xpos;
    }

    float[] blockYpositions() {
        float[] ypos = new float[this.blockPositions.length];
        for (int i = 0; i < ypos.length; ++i) {
            ypos[i] = this.blockPositions[i].y;
        }
        return ypos;
    }

    static Consumer<ChartLayout> getHeaderTranslator(ChartLayout l, PanelWellHeader.Orientation headerOrientation, Chart.Mode hMode, Chart.Mode vMode, float margin, float rowHeaderWidth, float headerHeight) {
        Consumer<ChartLayout> no_header = cl -> {
            cl.headerPos = null;
        };
        Consumer<ChartLayout> shift_header_x_remove_margin = cl -> {
            cl.headerPos = new Position(cl.headerPos.x() - margin, cl.headerPos.y());
        };
        Consumer<ChartLayout> remove_row_header_width = cl -> cl.headerWidth -= rowHeaderWidth - margin;
        Consumer<ChartLayout> shift_header_y_remove_header_height = cl -> {
            cl.headerPos = new Position(cl.headerPos.x(), cl.headerPos.y() - headerHeight);
        };
        Consumer<ChartLayout> headerTranslator = switch (headerOrientation) {
            default -> throw new MatchException(null, null);
            case PanelWellHeader.Orientation.TOP -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NO_HEADER: {
                        yield no_header;
                    }
                    case NORMAL: 
                    case HEADER_ONLY: 
                }
                switch (vMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        yield null;
                    }
                    case HEADER_ONLY: {
                        yield no_header;
                    }
                    case NO_HEADER: 
                }
                yield shift_header_x_remove_margin.andThen(remove_row_header_width);
            }
            case PanelWellHeader.Orientation.BOTTOM -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NO_HEADER: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield shift_header_y_remove_header_height;
                            }
                            case HEADER_ONLY: {
                                yield no_header;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_header_y_remove_header_height.andThen(shift_header_x_remove_margin).andThen(remove_row_header_width);
                    }
                    case NORMAL: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield null;
                            }
                            case HEADER_ONLY: {
                                yield no_header;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_header_x_remove_margin.andThen(remove_row_header_width);
                    }
                    case HEADER_ONLY: 
                }
                yield no_header;
            }
        };
        return headerTranslator;
    }

    static Consumer<ChartLayout> getKeyTranslator(ChartLayout l, PanelKey.Orientation keyOrientation, Chart.Mode hMode, Chart.Mode vMode, float margin, float rowHeaderWidth, float headerHeight) {
        Consumer<ChartLayout> no_key = cl -> {
            cl.keyPos = null;
        };
        Consumer<ChartLayout> shift_x_by_margin = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x() - margin, cl.keyPos.pos.y()), cl.keyPos.w(), cl.keyPos.h());
        };
        Consumer<ChartLayout> shift_x_remove_row_header = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x() - rowHeaderWidth, cl.keyPos.pos.y()), cl.keyPos.w(), cl.keyPos.h());
        };
        Consumer<ChartLayout> remove_row_header_width = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x(), cl.keyPos.pos.y()), cl.keyPos.w() - rowHeaderWidth + margin, cl.keyPos.h());
        };
        Consumer<ChartLayout> shift_y_by_margin = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x(), cl.keyPos.pos.y() - margin), cl.keyPos.w(), cl.keyPos.h());
        };
        Consumer<ChartLayout> shift_y_remove_header_height = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x(), cl.keyPos.pos.y() - headerHeight), cl.keyPos.w(), cl.keyPos.h());
        };
        Consumer<ChartLayout> remove_header_height = cl -> {
            cl.keyPos = new KeyLayout(new Position(cl.keyPos.pos().x(), cl.keyPos.pos.y()), cl.keyPos.w(), cl.keyPos.h() - headerHeight + margin);
        };
        Consumer<ChartLayout> keyTranslator = switch (keyOrientation) {
            default -> throw new MatchException(null, null);
            case PanelKey.Orientation.TOP -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: 
                    case HEADER_ONLY: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield null;
                            }
                            case HEADER_ONLY: {
                                yield no_key;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_x_by_margin.andThen(remove_row_header_width);
                    }
                    case NO_HEADER: 
                }
                yield no_key;
            }
            case PanelKey.Orientation.BOTTOM -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield null;
                            }
                            case HEADER_ONLY: {
                                yield no_key;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_x_by_margin.andThen(remove_row_header_width);
                    }
                    case HEADER_ONLY: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: 
                            case HEADER_ONLY: {
                                yield no_key;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_x_by_margin.andThen(remove_row_header_width);
                    }
                    case NO_HEADER: 
                }
                switch (vMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        yield shift_y_remove_header_height;
                    }
                    case HEADER_ONLY: {
                        yield no_key;
                    }
                    case NO_HEADER: 
                }
                yield shift_y_remove_header_height.andThen(shift_x_by_margin).andThen(remove_row_header_width);
            }
            case PanelKey.Orientation.LEFT -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield null;
                            }
                            case HEADER_ONLY: 
                            case NO_HEADER: 
                        }
                        yield no_key;
                    }
                    case HEADER_ONLY: {
                        yield no_key;
                    }
                    case NO_HEADER: 
                }
                switch (vMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        yield shift_y_by_margin;
                    }
                    case HEADER_ONLY: 
                    case NO_HEADER: 
                }
                yield no_key;
            }
            case PanelKey.Orientation.RIGHT -> {
                switch (hMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        switch (vMode) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case NORMAL: {
                                yield null;
                            }
                            case HEADER_ONLY: {
                                yield no_key;
                            }
                            case NO_HEADER: 
                        }
                        yield shift_x_remove_row_header;
                    }
                    case HEADER_ONLY: {
                        yield no_key;
                    }
                    case NO_HEADER: 
                }
                switch (vMode) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        yield shift_y_by_margin.andThen(remove_header_height);
                    }
                    case HEADER_ONLY: {
                        yield no_key;
                    }
                    case NO_HEADER: 
                }
                yield shift_y_by_margin.andThen(remove_header_height).andThen(shift_x_remove_row_header);
            }
        };
        return keyTranslator;
    }

    static Position translateBlockPos(Position p, Chart.Mode vMode, Chart.Mode hMode, ChartProperties cp) {
        BiFunction<Float, Float, Float> subtraction = (a, b) -> Float.valueOf(a.floatValue() - b.floatValue());
        float ty = ChartLayout.translateY(p.y, hMode, cp, subtraction);
        if (vMode == Chart.Mode.NO_HEADER) {
            return new Position(p.x - cp.margin, ty);
        }
        return new Position(p.x, ty);
    }

    static Position translateToBlockPos(Position p, Chart.Mode vMode, Chart.Mode hMode, ChartProperties cp, float rowHeaderWidth) {
        BiFunction<Float, Float, Float> addition = (a, b) -> Float.valueOf(a.floatValue() + b.floatValue());
        float ty = ChartLayout.translateY(p.y, hMode, cp, addition);
        if (vMode == Chart.Mode.NO_HEADER) {
            return new Position(p.x + rowHeaderWidth, ty);
        }
        return new Position(p.x, ty);
    }

    private static float translateY(float y, Chart.Mode hMode, ChartProperties cp, BiFunction<Float, Float, Float> operation) {
        if (hMode == Chart.Mode.NO_HEADER) {
            float ty = operation.apply(Float.valueOf(y), Float.valueOf(cp.margin)).floatValue();
            if (cp.header != null && cp.header.orientation == PanelWellHeader.Orientation.TOP) {
                ty = operation.apply(Float.valueOf(ty), Float.valueOf(cp.header.height)).floatValue();
            }
            if (cp.key != null && cp.key.orientation == PanelKey.Orientation.TOP) {
                ty = operation.apply(Float.valueOf(ty), Float.valueOf(cp.key.height)).floatValue();
            }
            return ty;
        }
        return y;
    }

    static Position translateBlockCaptionPos(Position p, Chart.Mode vMode, Chart.Mode hMode, boolean blockCapTop, float margin, float headerHeight) {
        Position tp;
        if (vMode == Chart.Mode.HEADER_ONLY) {
            return null;
        }
        if (blockCapTop) {
            tp = switch (hMode) {
                default -> throw new MatchException(null, null);
                case Chart.Mode.NORMAL, Chart.Mode.HEADER_ONLY -> p;
                case Chart.Mode.NO_HEADER -> null;
            };
        } else {
            switch (hMode) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORMAL: {
                    Position position = p;
                    break;
                }
                case HEADER_ONLY: {
                    Position position = null;
                    break;
                }
                case NO_HEADER: {
                    Position position = tp = new Position(p.x(), p.y() - headerHeight);
                }
            }
        }
        if (tp != null && vMode == Chart.Mode.NO_HEADER) {
            return new Position(tp.x() - margin, tp.y());
        }
        return tp;
    }

    static float[] calcBlankPanels(ChartProperties cp, List<BlockColumn> columns) {
        if (columns.size() < 2) {
            return new float[0];
        }
        float[] blankPanels = new float[columns.size() - 1];
        if (!cp.blankPanelRelative) {
            for (int i = 0; i < blankPanels.length; ++i) {
                blankPanels[i] = cp.blankPanel;
            }
            return blankPanels;
        }
        for (int index = 0; index < columns.size() - 1; ++index) {
            Well well2;
            BlockColumn col1 = columns.get(index);
            Object col2 = columns.get(index + 1);
            Well well1 = col1.getSingleWell();
            if (well1 == null || well1.getHeader().getLat_dec() == null || well1.getHeader().getLong_dec() == null || (well2 = ((BlockColumn)col2).getSingleWell()) == null || well2.getHeader().getLat_dec() == null || well2.getHeader().getLong_dec() == null) continue;
            double latSq = Math.pow(Math.abs(well1.getHeader().getLat_dec() - well2.getHeader().getLat_dec()), 2.0);
            double longSq = Math.pow(Math.abs(well1.getHeader().getLong_dec() - well2.getHeader().getLong_dec()), 2.0);
            double dist = Math.sqrt(latSq + longSq);
            blankPanels[index] = (float)dist;
        }
        float total = 0.0f;
        int count = 0;
        for (float val : blankPanels) {
            if (!(val > 0.0f)) continue;
            total += val;
            ++count;
        }
        if (count == 0) {
            for (int i = 0; i < blankPanels.length; ++i) {
                blankPanels[i] = cp.blankPanel;
            }
            return blankPanels;
        }
        float mean = total / (float)count;
        float scaleFactor = cp.blankPanel / mean;
        for (int i = 0; i < blankPanels.length; ++i) {
            if (blankPanels[i] == 0.0f) {
                blankPanels[i] = cp.blankPanel;
            } else {
                blankPanels[i] = blankPanels[i] * scaleFactor;
                if (blankPanels[i] > cp.blankPanel * 5.0f) {
                    blankPanels[i] = cp.blankPanel * 5.0f;
                } else if (blankPanels[i] < 0.0f) {
                    blankPanels[i] = 0.0f;
                }
            }
            blankPanels[i] = Math.max(blankPanels[i], cp.blankPanel / 5.0f);
        }
        return blankPanels;
    }

    static List<BlockColumn> getColumns(List<ChartBlockBase> blocks) {
        LinkedList<BlockColumn> columns = new LinkedList<BlockColumn>();
        blocks.forEach(block -> {
            if (block instanceof ChartBlock) {
                ChartBlock cb = (ChartBlock)block;
                ChartBlockColumn col = new ChartBlockColumn(cb);
                columns.add(col);
            } else if (block instanceof MapBlock) {
                Object patt0$temp;
                MapBlock mb = (MapBlock)block;
                if (!columns.isEmpty() && (patt0$temp = columns.get(columns.size() - 1)) instanceof MapColumn) {
                    MapColumn mapColumn = (MapColumn)patt0$temp;
                    mapColumn.add(mb);
                } else {
                    columns.add(new MapColumn(mb));
                }
            }
        });
        return columns;
    }

    record KeyLayout(Position pos, float w, float h) {
    }

    record Position(float x, float y) {
    }
}

