/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.SpeciesType;
import com.stratadata.util.DateUtils;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import jsbchart.block.BlockType;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.BlockTemplateBulkLoadTask;
import jsbchart.core.BlockTemplateChild;
import jsbchart.core.BlockTemplateChildException;
import jsbchart.core.BlockTemplateInfo;
import jsbchart.core.BlockTemplateLoadingHelper;
import jsbchart.core.BlockTemplateParent;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartContainer;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartPanelSnapshot;
import jsbchart.core.ChartTemplate;
import jsbchart.core.ChartTemplateBase;
import jsbchart.core.PanelIsDefaultListener;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateDescrImpl;
import jsbchart.core.TemplateFactory;
import jsbchart.core.TemplateType;
import jsbchart.core.UnknownPanelTypeException;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.CorrelationStandard;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.legacy.LegacyChart;
import jsbchart.legacy.LegacyChartCache;
import jsbchart.legacy.LegacyChartConverter;
import jsbchart.legacy.LegacyChartPanelOption;
import jsbchart.legacy.LegacyChartType;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertiesBuilder;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbchart.panel.spatial.ShapeStoreServiceImpl;
import jsbchart.panel.spatial.ShapeStoreServiceWs;
import jsbchart.panel.spatial.ShapefileFileFinder;
import jsbchart.tag.ChartTagTemplate;
import model3.AgeCurve;
import model3.Audit;
import model3.CompositeStandard;
import model3.ConnectionProvider;
import model3.EnvScheme;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.LogDef;
import model3.SBEvent;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Surface;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WsWell;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;
import org.jdom2.xpath.XPathBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.UnmatchedException;
import util.process.ModelProcess;

public class ChartManager {
    private static final Logger LOGGER = Logger.getLogger(ChartManager.class.getName());
    public static final EnumMap<CorrelationType, CorrelationStandard[]> corrStds;
    public static final int CORR_STD_LENGTH;
    public static final String INT_CHART_LOC_STRING = "INTS";
    public static final String TXDB_CHART_LOC_STRING = "TXDB";
    public static final String DIALOGIGDSCH_CHART_LOC_STRING_PREFIX = "DSC";
    final SBdb sbdb;
    private final HashMap<Integer, PanelTemplate> panelsByID;
    private final EnumMap<PanelType, List<PanelTemplate>> panelsByType;
    private final HashMap<Integer, BlockTemplate> blocksByID;
    private final EnumMap<BlockType, List<BlockTemplate>> blocksByType;
    private List<BlockTemplateInfo> blockInfoList;
    private final HashMap<Integer, ChartTemplate> charts;
    private final HashMap<Integer, CorrelationTemplate> corrTemplates;
    private final EnumMap<CorrelationType, List<CorrelationTemplate>> corrByType;
    private final LegacyChartCache legacyChartCache = new LegacyChartCache();
    private final ShapeStoreService shapeStoreService;
    private final WeakHashMap<PanelIsDefaultListener, Object> panelDefaultListeners = new WeakHashMap();
    private static final Object object;
    private final WeakHashMap<ChartContainer, Object> chartContainers = new WeakHashMap();

    public ChartManager(SBdb sbdb) {
        this.sbdb = sbdb;
        this.panelsByType = new EnumMap(PanelType.class);
        for (PanelType panelType : PanelType.values()) {
            this.panelsByType.put(panelType, null);
        }
        this.blocksByType = new EnumMap(BlockType.class);
        for (Enum enum_ : BlockType.values()) {
            this.blocksByType.put((BlockType)enum_, null);
        }
        this.panelsByID = new HashMap();
        this.blocksByID = new HashMap();
        this.charts = new HashMap();
        this.corrTemplates = new HashMap();
        this.corrByType = new EnumMap(CorrelationType.class);
        for (Enum enum_ : CorrelationType.values()) {
            this.corrByType.put((CorrelationType)enum_, null);
        }
        this.shapeStoreService = sbdb.isConnected() ? new ShapeStoreServiceImpl((ConnectionProvider)sbdb) : new ShapeStoreServiceWs();
    }

    public String toString() {
        return "Chart Manager";
    }

    public ShapeStoreService getShapeStoreService() {
        return this.shapeStoreService;
    }

    private List<PanelTemplate> getPanels(PanelType type) throws SQLException, SBException {
        List<PanelTemplate> list = this.panelsByType.get(type);
        if (list == null) {
            this.loadPanels(type);
            list = this.panelsByType.get(type);
        }
        return list;
    }

    public List<PanelTemplate> getPanels(PanelType type, Integer projID, boolean includeGlobal) throws SQLException, SBException {
        LinkedList<PanelTemplate> list = type == null ? new LinkedList<PanelTemplate>(this.panelsByID.values()) : new LinkedList<PanelTemplate>(this.getPanels(type));
        if (projID == null) {
            return list;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            PanelTemplate pTemp = (PanelTemplate)it.next();
            if (projID == 0) {
                if (pTemp.getProjID() <= 0) continue;
                it.remove();
                continue;
            }
            if (pTemp.getProjID() == 0) {
                if (includeGlobal) continue;
                it.remove();
                continue;
            }
            if (pTemp.getProjID() == projID.intValue()) continue;
            it.remove();
        }
        return list;
    }

    public List<PanelTemplate> getPanels(PanelType type, Integer projID, boolean includeGlobal, Comparator<TemplateDescr> comparator) throws SQLException, SBException {
        List<PanelTemplate> panels = this.getPanels(type, projID, includeGlobal);
        Collections.sort(panels, comparator);
        return panels;
    }

    public BlockTemplate getBlockTemplateFromInfo(BlockTemplateInfo info) {
        int id = info.getBlockID();
        BlockTemplate template = null;
        try {
            template = this.getBlockTemplate(id);
        }
        catch (SQLException | BlockTemplateChildException ex) {
            LOGGER.log(Level.SEVERE, "Error retrieving block template form info object.", ex);
        }
        return template;
    }

    public List<BlockTemplateInfo> getBlockInfo(BlockType ofType, Integer projID, boolean includeGlobal, Comparator<TemplateDescr> comparator) throws SuppressedSQLException {
        Comparator c;
        if (this.blockInfoList == null) {
            this.initTemplateInfoList();
        }
        Predicate<BlockTemplateInfo> p = t -> t.getProjID() == 0 || t.getProjID() == projID.intValue();
        if (ofType != null) {
            p = p.and(t -> t.getType() == ofType);
        }
        if ((c = comparator) == null) {
            c = (a, b) -> a.toString().compareTo(b.toString());
        }
        List<BlockTemplateInfo> results = this.blockInfoList.stream().filter(p).sorted(c).toList();
        return results;
    }

    private void initTemplateInfoList() throws SuppressedSQLException {
        ArrayList<BlockTemplateInfo> results = new ArrayList<BlockTemplateInfo>();
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE parent_id is null";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("block_id");
                int projID = rs.getInt("proj_id");
                String rsType = rs.getString("type");
                BlockType type = BlockType.valueOf(rsType);
                String descr = rs.getString("descr");
                int acm = rs.getInt("acm");
                String comments = rs.getString("comments");
                Audit audit = new Audit(rs);
                results.add(new BlockTemplateInfo(ID, projID, type, descr, comments, audit, acm));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback((SQLException)e);
        }
        this.blockInfoList = results;
    }

    public List<BlockTemplate> getBlocks(BlockType type, Integer projID, boolean includeGlobal) throws SQLException {
        LinkedList<BlockTemplate> list = type != null ? new LinkedList<BlockTemplate>(this.getBlockTemplates(type)) : new LinkedList<BlockTemplate>(this.blocksByID.values());
        if (projID == null) {
            return list;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            BlockTemplate bTemp = (BlockTemplate)it.next();
            if (projID == 0) {
                if (bTemp.getProjID() <= 0) continue;
                it.remove();
                continue;
            }
            if (bTemp.getProjID() == 0) {
                if (includeGlobal) continue;
                it.remove();
                continue;
            }
            if (bTemp.getProjID() == projID.intValue()) continue;
            it.remove();
        }
        return list;
    }

    public List<BlockTemplate> getBlocks(BlockType type, Integer projID, boolean includeGlobal, Comparator<TemplateDescr> comparator, boolean includeChildTemplates) throws SQLException {
        return this.getBlocks(type, projID, includeGlobal).stream().filter(blockTemplate -> includeChildTemplates || blockTemplate.getParentID() == null).sorted(comparator).toList();
    }

    private List<BlockTemplate> getBlockTemplates(BlockType type) throws SQLException {
        List<BlockTemplate> list = this.blocksByType.get(type);
        if (list == null) {
            this.loadBlocks(type);
            list = this.blocksByType.get(type);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PanelTemplate getPanelTemplate(int panelID) throws SQLException, SBException {
        HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
        synchronized (hashMap) {
            if (this.panelsByID.get(panelID) == null) {
                this.loadPanelTemplate(panelID);
            }
            return this.panelsByID.get(panelID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockTemplate getBlockTemplate(int ID) throws SQLException, BlockTemplateChildException {
        HashMap<Integer, BlockTemplate> hashMap = this.blocksByID;
        synchronized (hashMap) {
            if (this.blocksByID.get(ID) == null) {
                this.loadBlockTemplateWithPanelsAndChildren(ID);
            }
            return this.blocksByID.get(ID);
        }
    }

    public BlockTemplate getParentBlockTemplate(int childID) throws SQLException {
        String sql = "SELECT parent_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " where block_id=" + childID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int parentID = rs.getInt("parent_id");
                if (parentID == 0) {
                    throw new IllegalStateException("Parent ID not found");
                }
                BlockTemplate blockTemplate = this.getBlockTemplate(parentID);
                return blockTemplate;
            }
            throw new IllegalStateException("Parent ID not found");
        }
    }

    private void loadPanelTemplate(int panelID) throws SQLException, SBException {
        block11: {
            String sql = "SELECT panel_id,type,isvisible,descr,comments,isdefault,prop,sch_id,std_id,envsch_id,synsch_id,grpset_id,proj_id,agecurve_id,shape_id," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE panel_id=" + panelID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    try {
                        this.getPanelTemplateFromResultSet(rs);
                        break block11;
                    }
                    catch (Exception ex) {
                        String panelType = "";
                        String props = "";
                        try {
                            panelType = rs.getString("type");
                            props = rs.getString("prop");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Logger.getLogger(ChartManager.class.getName()).log(Level.WARNING, "Exception occurred while opening panel template. Panel type:" + panelType + ", Props: " + props, ex);
                        throw ex;
                    }
                }
                throw new IllegalStateException("Could not load panel template with ID " + panelID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PanelTemplate getPanelTemplateFromResultSet(ResultSet rs) throws SQLException, SBException {
        int panelID = rs.getInt("panel_id");
        if (this.panelsByID.get(panelID) != null) {
            return this.panelsByID.get(panelID);
        }
        PanelTemplate sbPanelTemplate = this.createPanelTemplateFromResultSet(panelID, rs);
        HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
        synchronized (hashMap) {
            if (this.panelsByID.get(panelID) == null) {
                this.putPanelTemplate(sbPanelTemplate);
            } else {
                System.out.println(String.valueOf(sbPanelTemplate) + " was already loaded.");
            }
        }
        return sbPanelTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PanelTemplate createPanelTemplateFromResultSet(int panelID, ResultSet rs) throws SQLException, SBException {
        PanelType type;
        String panelTypeString = rs.getString("type").trim();
        try {
            type = PanelType.valueOf(panelTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new UnknownPanelTypeException(panelTypeString);
        }
        boolean isVisible = rs.getString("isvisible").charAt(0) == 'Y';
        String descr = rs.getString("descr");
        String comments = rs.getString("comments");
        char defaultChar = rs.getString("isdefault").charAt(0);
        boolean defaultTemplate = defaultChar == 'Y';
        String prop = rs.getString("prop");
        PanelPropertiesBuilder builder = new PanelPropertiesBuilder(type, prop);
        builder.schID(rs.getInt("sch_id"));
        builder.cmpStdID(rs.getInt("std_id"));
        builder.envSchID(rs.getInt("envsch_id"));
        builder.synSchID(rs.getInt("synsch_id"));
        builder.grpSetID(rs.getInt("grpset_id"));
        int projID = rs.getInt("proj_id");
        builder.ageCurveID(rs.getInt("agecurve_id"));
        builder.shapeStoreID(rs.getInt("shape_id"));
        Audit audit = new Audit(rs);
        int acm = rs.getInt("acm");
        try (Statement stmt = null;){
            String sql;
            if (type == PanelType.DEPTHAGE || type == PanelType.SUBSIDENCE) {
                sql = "SELECT block_id FROM " + this.sbdb.DBTableName("CHTPANL_BLKMBR") + " WHERE panel_id=" + panelID;
                stmt = this.sbdb.getDatabase().createStatement();
                ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs2.next()) {
                    int blockID = rs2.getInt("block_id");
                    BlockTemplate templ = this.getBlockTemplate(blockID);
                    builder.mbrBlock((ChartBlock)ChartFactory.createBlock(this.sbdb, templ));
                }
            }
            if (PanelType.isTaxonPanel(type)) {
                sql = "SELECT panel_no,type,isdefault,overplot,prop,std_id,caption,spec_id,grp_id,grpset_id,cat_mnem,foreach,highlight_grp_id,sch_id,exclude_grp_id FROM " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE panel_id=" + panelID + " ORDER BY panel_no";
                if (stmt == null) {
                    stmt = this.sbdb.getDatabase().createStatement();
                }
                ResultSet rs3 = stmt.executeQuery(this.sbdb.modQuery(sql));
                LinkedList<PanelTaxonOcc> occList = new LinkedList<PanelTaxonOcc>();
                while (rs3.next()) {
                    int stdID;
                    PanelTaxonType taxonType = PanelTaxonType.valueOf(rs3.getString("type"));
                    boolean isDefault = rs3.getBoolean("isdefault");
                    boolean overplot = rs3.getString("overplot") != null;
                    String props = rs3.getString("prop");
                    String occProps = null;
                    String[] splits = props.split("\\^");
                    String panelProps = splits[splits.length - 1];
                    if (splits.length > 1) {
                        occProps = splits[0];
                    }
                    CompositeStandard std = (stdID = rs3.getInt("std_id")) > 0 ? this.sbdb.getCompositeStandard(stdID) : null;
                    PanelTaxonOcc ptOcc = new PanelTaxonOcc(taxonType, isDefault, panelProps, std, overplot);
                    ptOcc.setCaption(CaptionTemplate.getDisplayString(rs3.getString("caption")));
                    ptOcc.specID(rs3.getInt("spec_id"), this.sbdb);
                    ptOcc.groupID(rs3.getInt("grp_id"), this.sbdb);
                    ptOcc.setID(rs3.getInt("grpset_id"), this.sbdb);
                    ptOcc.catMnem(rs3.getString("cat_mnem"), this.sbdb);
                    ptOcc.forEach(rs3.getInt("foreach"));
                    ptOcc.highlightGroup(rs3.getInt("highlight_grp_id"), this.sbdb);
                    ptOcc.hdrScheme(rs3.getInt("sch_id"), this.sbdb);
                    ptOcc.exclGrp(rs3.getInt("exclude_grp_id"), this.sbdb);
                    ptOcc.setOccProps(occProps, std);
                    occList.add(ptOcc);
                }
                sql = "SELECT panel_no,spec_type_id FROM " + this.sbdb.DBTableName("CHTSPECTYPE") + " WHERE panel_id=" + panelID;
                ResultSet rs4 = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs4.next()) {
                    int occNo = rs4.getInt("panel_no");
                    PanelTaxonOcc ptOcc = (PanelTaxonOcc)occList.get(occNo);
                    ptOcc.getProperties().addSubType(rs4.getInt("spec_type_id"));
                }
                for (PanelTaxonOcc occ : occList) {
                    builder.innerPanel(occ);
                }
            }
            if (PanelType.isAnalystPanel(type)) {
                sql = "SELECT analyst_id FROM " + this.sbdb.DBTableName("CHTANALYST") + " WHERE panel_id=" + panelID;
                if (stmt == null) {
                    stmt = this.sbdb.getDatabase().createStatement();
                }
                ResultSet rs5 = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs5.next()) {
                    Userdef user = this.sbdb.getUser(rs5.getInt("analyst_id"));
                    if (user == null) continue;
                    builder.analyst(user);
                }
            }
            if (type == PanelType.WLOG || type == PanelType.VS) {
                sql = "SELECT abr,prop FROM " + this.sbdb.DBTableName("CHTLOG") + " WHERE panel_id=" + panelID + " ORDER BY abr";
                if (stmt == null) {
                    stmt = this.sbdb.getDatabase().createStatement();
                }
                ResultSet rs6 = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs6.next()) {
                    String abr = rs6.getString("abr");
                    String defString = rs6.getString("prop");
                    builder.logDef(abr, defString);
                }
            }
            PanelProperties panelProperties = builder.build(this.sbdb, this.shapeStoreService);
            PanelTemplate panelTemplate = new PanelTemplate(type, panelID, isVisible, descr, comments, defaultTemplate, panelProperties, projID, audit, acm);
            return panelTemplate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPanels(PanelType type) throws SQLException, SBException {
        String sql = "SELECT panel_id,type,isvisible,descr,comments,isdefault,prop,sch_id,std_id,envsch_id,synsch_id,grpset_id,proj_id,agecurve_id,shape_id," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE type='" + type.name() + "' AND isvisible='Y'";
        LinkedList<PanelTemplate> list = new LinkedList<PanelTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                PanelTemplate sbPanelTemplate = null;
                try {
                    sbPanelTemplate = this.getPanelTemplateFromResultSet(rs);
                }
                catch (Exception ex) {
                    String panelType = "";
                    String props = "";
                    try {
                        panelType = rs.getString("type");
                        props = rs.getString("prop");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Logger.getLogger(ChartManager.class.getName()).log(Level.WARNING, "Exception occurred while opening panel template. Panel type:" + panelType + ", Props: " + props, ex);
                }
                if (sbPanelTemplate == null) continue;
                list.add(sbPanelTemplate);
            }
        }
        this.panelsByType.put(type, list);
    }

    private void loadBlocks(BlockType type) throws SQLException {
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE type='" + type.name() + "'";
        LinkedList<BlockTemplate> results = new LinkedList<BlockTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                BlockTemplate t = this.getBlockTemplateFromResultSet(rs);
                results.add(t);
            }
            ListIterator it = results.listIterator();
            while (it.hasNext()) {
                BlockTemplateChild child;
                BlockTemplate t = (BlockTemplate)it.next();
                t.loadPanels(this.sbdb, stmt);
                if (t.getParentID() == null) continue;
                BlockTemplateParent parent = (BlockTemplateParent)this.blocksByID.get(t.getParentID());
                if (parent.getChild((child = (BlockTemplateChild)t).getWellID()) == null) {
                    parent.addChild((BlockTemplateChild)t);
                }
                it.remove();
            }
        }
        this.blocksByType.put(type, results);
    }

    private void loadBlockTemplate(int ID) throws SQLException, BlockTemplateChildException {
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE block_id=" + ID + " OR parent_id=" + ID;
        LinkedList<BlockTemplateChild> children = new LinkedList<BlockTemplateChild>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                BlockTemplate template = this.getBlockTemplateFromResultSet(rs);
                if (template.getID() == ID) {
                    if (!(template instanceof BlockTemplateParent)) {
                        throw new BlockTemplateChildException("Tried to load a child block", ID, template.getWellID());
                    }
                    assert (this.blocksByID.get(ID) == template);
                    continue;
                }
                children.add((BlockTemplateChild)template);
            }
            BlockTemplateParent parent = (BlockTemplateParent)this.blocksByID.get(ID);
            if (parent != null) {
                parent.loadPanels(this.sbdb, stmt);
                if (!children.isEmpty()) {
                    for (BlockTemplateChild child : children) {
                        if (parent.getChild(child.getWellID()) != null) continue;
                        child.loadPanels(this.sbdb, stmt);
                        parent.addChild(child);
                    }
                }
            }
        }
    }

    private void loadBlockTemplateWithPanelsAndChildren(int blockID) throws SQLException, BlockTemplateChildException {
        String sql = BlockTemplateLoadingHelper.getBlockSelectStringWithPanels((ConnectionProvider)this.sbdb, blockID);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            record ParsedResult(BlockTemplate template, List<PanelOcc> panelOccs) {
            }
            HashMap<Integer, ParsedResult> results = new HashMap<Integer, ParsedResult>();
            while (rs.next()) {
                int rowID = rs.getInt("block_id");
                if (results.get(rowID) == null) {
                    BlockTemplate template = BlockTemplateLoadingHelper.createBlockTemplateFromResultSet(this, rs, "b");
                    this.putBlockTemplate(template);
                    if (template.getID() == blockID) {
                        if (!(template instanceof BlockTemplateParent)) {
                            throw new BlockTemplateChildException("Tried to load a child block", rowID, template.getWellID());
                        }
                        assert (this.blocksByID.get(rowID) == template);
                    }
                    results.put(rowID, new ParsedResult(template, new LinkedList<PanelOcc>()));
                }
                try {
                    PanelOcc panelOcc = BlockTemplateLoadingHelper.getPanelOccFromResultSet(rs);
                    ((ParsedResult)results.get((Object)Integer.valueOf((int)rowID))).panelOccs.add(panelOcc);
                }
                catch (BlockTemplateLoadingHelper.NullPanelException panelOcc) {}
            }
            results.values().forEach(result -> result.template.setPanelOccs(result.panelOccs));
            List<BlockTemplateChild> children = results.values().stream().map(ParsedResult::template).filter(blockTemplate -> blockTemplate instanceof BlockTemplateChild).map(blockTemplate -> (BlockTemplateChild)blockTemplate).toList();
            BlockTemplateParent parent = (BlockTemplateParent)this.blocksByID.get(blockID);
            if (parent != null) {
                for (BlockTemplateChild child : children) {
                    if (parent.getChild(child.getWellID()) != null) continue;
                    parent.addChild(child);
                }
            }
        }
    }

    private BlockTemplate getBlockTemplateFromResultSet(ResultSet rs) throws SQLException {
        int ID = rs.getInt("block_id");
        if (this.blocksByID.get(ID) != null) {
            return this.blocksByID.get(ID);
        }
        BlockTemplate t = BlockTemplateLoadingHelper.createBlockTemplateFromResultSet(this, rs);
        this.putBlockTemplate(t);
        return t;
    }

    private void loadCorrTemplate(int ID) throws SQLException {
        CorrelationTemplate t = CorrelationTemplate.load(this.sbdb, ID);
        this.putCorrTemplate(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCorrTemplates(CorrelationType type) throws SQLException {
        List<CorrelationTemplate> list = CorrelationTemplate.load(this.sbdb, type);
        ListIterator<CorrelationTemplate> it = list.listIterator();
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            while (it.hasNext()) {
                CorrelationTemplate t = it.next();
                if (this.corrTemplates.get(t.getID()) != null) {
                    it.set(this.corrTemplates.get(t.getID()));
                    continue;
                }
                this.putCorrTemplate(t);
            }
        }
        this.corrByType.put(type, list);
    }

    private List<CorrelationTemplate> getCorrelationTemplates(CorrelationType type) throws SQLException {
        List<CorrelationTemplate> list;
        if (type != null) {
            list = this.corrByType.get(type);
            if (list == null) {
                this.loadCorrTemplates(type);
                list = this.corrByType.get(type);
            }
        } else {
            list = new ArrayList<CorrelationTemplate>(this.corrTemplates.values());
        }
        return list;
    }

    public List<CorrelationTemplate> getCorrTemplates(CorrelationType type, Integer projID, boolean includeGlobal) throws SQLException {
        LinkedList<CorrelationTemplate> list = new LinkedList<CorrelationTemplate>(this.getCorrelationTemplates(type));
        if (projID == null) {
            return list;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            CorrelationTemplate cTemp = (CorrelationTemplate)it.next();
            if (projID == 0) {
                if (cTemp.getProjID() <= 0) continue;
                it.remove();
                continue;
            }
            if (cTemp.getProjID() == 0) {
                if (includeGlobal) continue;
                it.remove();
                continue;
            }
            if (cTemp.getProjID() == projID.intValue()) continue;
            it.remove();
        }
        return list;
    }

    public List<CorrelationTemplate> getCorrTemplates(CorrelationType type, Integer projID, boolean includeGlobal, Comparator<TemplateDescr> comparator) throws SQLException {
        List<CorrelationTemplate> corrs = this.getCorrTemplates(type, projID, includeGlobal);
        Collections.sort(corrs, comparator);
        return corrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockTemplate> searchBlocks(BlockType type, String name, Integer projID, Date dateFrom, Date dateTo, Integer modifier) throws SQLException {
        String sql = BlockTemplateLoadingHelper.getBlockSearchString((ConnectionProvider)this.sbdb, type, name, projID, DateUtils.asLocalDate((Date)dateFrom), DateUtils.asLocalDate((Date)dateTo), modifier);
        LinkedList<BlockTemplate> results = new LinkedList<BlockTemplate>();
        LinkedList<BlockTemplate> freshlyLoadedresults = new LinkedList<BlockTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("block_id");
                if (this.blocksByID.get(ID) != null) {
                    results.add(this.blocksByID.get(ID));
                    continue;
                }
                String rstype = rs.getString("type");
                String descr = rs.getString("descr");
                String comments = rs.getString("comments");
                int pID = rs.getInt("proj_id");
                Audit audit = new Audit(rs, "b");
                int acm = rs.getInt("acm");
                BlockTemplate t = TemplateFactory.newBlockTemplateFromResults(this, ID, BlockType.valueOf(rstype), descr, comments, pID, audit, acm);
                results.add(t);
                freshlyLoadedresults.add(t);
                HashMap<Integer, BlockTemplate> hashMap = this.blocksByID;
                synchronized (hashMap) {
                    assert (t instanceof BlockTemplateParent);
                    this.blocksByID.put(ID, t);
                }
            }
            this.loadBlockMembers(freshlyLoadedresults, stmt);
        }
        return results;
    }

    public List<BlockTemplateInfo> searchBlockInfo(BlockType type, String name, Integer projID, LocalDate dateFrom, LocalDate dateTo, Integer modifier) throws SQLException {
        String sql = BlockTemplateLoadingHelper.getBlockSearchString((ConnectionProvider)this.sbdb, type, name, projID, dateFrom, dateTo, modifier);
        LinkedList<BlockTemplateInfo> results = new LinkedList<BlockTemplateInfo>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("block_id");
                String rstype = rs.getString("type");
                String descr = rs.getString("descr");
                String comments = rs.getString("comments");
                int pID = rs.getInt("proj_id");
                Audit audit = new Audit(rs, "b");
                int acm = rs.getInt("acm");
                BlockTemplateInfo info = new BlockTemplateInfo(ID, pID, BlockType.valueOf(rstype), descr, comments, audit, acm);
                info.setnMbrs(rs.getInt("nmbrs"));
                results.add(info);
            }
        }
        return results;
    }

    public List<BlockTemplate> searchBlocks(int withPanelID) throws SQLException {
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE block_id IN(SELECT DISTINCT block_id FROM " + this.sbdb.DBTableName("CHTBLOCKMBR") + " WHERE panel_id=" + withPanelID + ") AND parent_id IS NULL";
        LinkedList<BlockTemplate> results = new LinkedList<BlockTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                results.add(this.getBlockTemplateFromResultSet(rs));
            }
            this.loadBlockMembers(results, stmt);
        }
        return results;
    }

    private void loadBlockMembers(List<BlockTemplate> parentBlocks, Statement stmt) throws SQLException {
        LinkedList<BlockTemplate> loadedChildren = new LinkedList<BlockTemplate>();
        for (BlockTemplate t : parentBlocks) {
            t.loadPanels(this.sbdb, stmt);
            if (!(t instanceof BlockTemplateParent) || !((BlockTemplateParent)t).getChildWellIDs().isEmpty()) continue;
            ResultSet childRs = stmt.executeQuery(this.sbdb.modQuery(BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE parent_id=" + t.getID()));
            while (childRs.next()) {
                BlockTemplate child = this.getBlockTemplateFromResultSet(childRs);
                ((BlockTemplateParent)t).addChild((BlockTemplateChild)child);
                loadedChildren.add(child);
            }
            for (BlockTemplate child : loadedChildren) {
                child.loadPanels(this.sbdb, stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChartTemplate> searchCharts(int withMbrID, boolean block) throws SQLException {
        String sql = "SELECT chart_id,descr,comments,proj_id,wellist_id,props,sch_id,header,cht_key,acm," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("CHART");
        sql = block ? sql + " WHERE chart_id IN(SELECT DISTINCT chart_id FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE block_id=" + withMbrID + ")" : sql + " WHERE chart_id IN(SELECT DISTINCT chart_id FROM " + this.sbdb.DBTableName("CHTCORROCC") + " WHERE corrsch_id=" + withMbrID + ")";
        LinkedList<ChartTemplate> list = new LinkedList<ChartTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(this.getChartTemplateFromResultSet(rs));
            }
            for (ChartTemplate templ : list) {
                templ.loadMbrs(this.sbdb, stmt);
            }
        }
        return list;
    }

    public List<PanelTemplate> searchPanels(int withBlockMbrID) throws SQLException, SBException {
        String sql = "SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL_BLKMBR") + " WHERE block_id=" + withBlockMbrID;
        LinkedList<PanelTemplate> list = new LinkedList<PanelTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(this.getPanelTemplate(rs.getInt("panel_id")));
            }
        }
        return list;
    }

    public List<PanelTemplate> findSimilar(PanelTemplate templ, Integer projID) throws SQLException, SBException {
        ArrayList<PanelTemplate> list = new ArrayList<PanelTemplate>();
        for (PanelTemplate comp : this.getPanels(templ.getType())) {
            if (comp == templ || projID != null && comp.getProjID() > 0 && comp.getProjID() != projID.intValue() || !comp.getProperties().isSimilarTo(templ.getProperties())) continue;
            list.add(comp);
        }
        return list;
    }

    public List<PanelTemplate> findSimilar(PanelProperties prop, Integer projID) throws SQLException, SBException {
        ArrayList<PanelTemplate> list = new ArrayList<PanelTemplate>();
        for (PanelTemplate comp : this.getPanels(prop.getPanelType())) {
            if (projID != null && comp.getProjID() > 0 && comp.getProjID() != projID.intValue() || !comp.getProperties().isSimilarTo(prop)) continue;
            list.add(comp);
        }
        return list;
    }

    public void mergePanels(Collection<PanelTemplate> panels, PanelTemplate target) throws SQLException, SBException, SBPermissionException {
        if (panels.size() < 2) {
            return;
        }
        if (!panels.contains(target)) {
            throw new IllegalArgumentException("No target");
        }
        for (PanelTemplate panel : panels) {
            if (panel == target) continue;
            if (panel.getType() != target.getType()) {
                throw new IllegalArgumentException("Panel type mismatch in mergePanels");
            }
            if (panel.canWrite(this.sbdb, null)) continue;
            throw new SBPermissionException("Locked panel '" + panel.getName() + "' cannot be deleted. Merge aborted.");
        }
        HashMap exceptions = new HashMap();
        HashMap<Integer, BlockTemplate> blocksToNotify = new HashMap<Integer, BlockTemplate>();
        for (PanelTemplate panel : panels) {
            if (panel == target) continue;
            ArrayList<Exception> exceptionsForPanel = new ArrayList<Exception>();
            for (BlockTemplate block : this.searchBlocks(panel.getID())) {
                try {
                    if (panel.getProjID() != target.getProjID() && target.getProjID() > 0 && target.getProjID() != block.getProjID()) {
                        throw new InvalidFieldException("project mismatch: target panel cannot be used in block '" + block.getName() + "'");
                    }
                    block.replacePanel(this.sbdb, panel.getID(), target.getID());
                    this.sbdb.commit();
                    blocksToNotify.put(block.getID(), block);
                }
                catch (Exception e) {
                    exceptionsForPanel.add(e);
                }
            }
            if (exceptionsForPanel.isEmpty()) {
                this.deletePanelTemplate(panel.getID());
                continue;
            }
            exceptions.put(panel, exceptionsForPanel);
        }
        for (BlockTemplate template : blocksToNotify.values()) {
            template.notifyObservers();
        }
        if (!exceptions.isEmpty()) {
            SBException sbeException = new SBException("Errors in merge. " + exceptions.size() + " panel" + (exceptions.size() > 1 ? "s were" : " was") + " not merged.");
            sbeException.setData(exceptions);
            throw sbeException;
        }
    }

    public List<ChartTemplate> searchCharts(String name, Integer projID) throws SQLException {
        return this.searchCharts(name, projID, null, false, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChartTemplate> searchCharts(String name, Integer projID, Integer wellListID, boolean onlyWithTemplateBlock, Date dateFrom, Date dateTo, Integer modifier, Integer wellID, Boolean multiWell) throws SQLException {
        if (name == null || name.isEmpty()) {
            name = "%";
        }
        String sql = "SELECT c.chart_id,c.descr,c.comments,c.proj_id,c.wellist_id,c.props,c.sch_id,c.header,c.cht_key," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHART") + " c WHERE ucase(descr) like " + SB.DBString((String)name.toUpperCase());
        if (projID != null) {
            sql = sql + " AND proj_id" + (String)(projID > 0 ? "=" + projID : " IS NULL");
        }
        if (wellListID != null) {
            sql = sql + " AND wellist_id=" + wellListID;
        }
        if (dateFrom != null) {
            sql = dateTo != null ? sql + " AND modified BETWEEN " + this.sbdb.DBDate(dateFrom) + " AND " + this.sbdb.DBDate(dateTo) : sql + " AND modified > " + this.sbdb.DBDate(dateFrom);
        }
        if (modifier != null) {
            sql = sql + " AND modifier=" + modifier;
        }
        if (wellID != null) {
            sql = sql + " AND chart_id IN(SELECT DISTINCT chart_id FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE well_id=" + wellID + ")";
        }
        if (multiWell != null) {
            String inner = "(SELECT count(well_id) from " + this.sbdb.DBTableName("CHTMBR") + " m WHERE m.chart_id=c.chart_id)";
            sql = sql + " AND " + inner + (multiWell != false ? ">1" : "=1");
            System.out.println("sql: " + sql);
        }
        LinkedList<ChartTemplate> list = new LinkedList<ChartTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(this.getChartTemplateFromResultSet(rs));
            }
            for (ChartTemplate t : list) {
                t.loadMbrs(this.sbdb, stmt);
            }
        }
        if (onlyWithTemplateBlock) {
            ListIterator it = list.listIterator();
            block5: while (it.hasNext()) {
                ChartTemplate t = (ChartTemplate)it.next();
                for (ChartTemplate.BlockOcc bOcc : t.getBlocks()) {
                    if (bOcc.getWellID() != 0) continue;
                    this.loadBlockTemplate(bOcc.getBlockID());
                    if (this.blocksByID.get(bOcc.getBlockID()).getType() != BlockType.WELL) continue;
                    continue block5;
                }
                it.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TemplateDescr> searchChartHeaders(String name, Integer projID, Integer wellListID, boolean onlyWithTemplateBlock, Date dateFrom, Date dateTo, Integer modifier, Integer wellID, Boolean multiWell) throws SQLException {
        if (name == null || name.isEmpty()) {
            name = "%";
        }
        String sql = "SELECT c.chart_id,c.descr,c.comments,c.proj_id,c.wellist_id,c.modified,c.modifier,count(m.block_no) as nmbrs FROM " + this.sbdb.DBTableName("CHART") + " c LEFT JOIN " + this.sbdb.DBTableName("CHTMBR") + " m ON m.chart_id=c.chart_id ";
        if (onlyWithTemplateBlock) {
            sql = sql + "INNER JOIN " + this.sbdb.DBTableName("CHTBLOCK") + " b ON m.block_id=b.block_id ";
        }
        sql = sql + "WHERE ucase(c.descr) like " + SB.DBString((String)name.toUpperCase());
        if (projID != null) {
            sql = sql + " AND c.proj_id" + (String)(projID > 0 ? "=" + projID : " IS NULL");
        }
        if (wellListID != null) {
            sql = sql + " AND c.wellist_id=" + wellListID;
        }
        if (dateFrom != null) {
            sql = dateTo != null ? sql + " AND c.modified BETWEEN " + this.sbdb.DBDate(dateFrom) + " AND " + this.sbdb.DBDate(dateTo) : sql + " AND c.modified > " + this.sbdb.DBDate(dateFrom);
        }
        if (modifier != null) {
            sql = sql + " AND c.modifier=" + modifier;
        }
        if (wellID != null) {
            sql = sql + " AND c.chart_id IN(SELECT DISTINCT chart_id FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE well_id=" + wellID + ")";
        }
        sql = sql + " GROUP BY c.chart_id,c.descr,c.comments,c.proj_id,c.wellist_id,c.modified,c.modifier";
        if (multiWell != null || onlyWithTemplateBlock) {
            ArrayList<Object> havings = new ArrayList<Object>();
            if (multiWell != null) {
                havings.add("COUNT(m.block_no)" + (multiWell != false ? ">1" : "=1"));
            }
            if (onlyWithTemplateBlock) {
                havings.add("COUNT(CASE WHEN m.well_id is null AND b.type='WELL' THEN 1 END) >0");
            }
            sql = sql + " HAVING " + StringUtils.join(havings, (String)" AND ");
        }
        LinkedList<TemplateDescr> list = new LinkedList<TemplateDescr>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int id = rs.getInt("chart_id");
                TemplateDescrImpl templ = new TemplateDescrImpl(id);
                templ.setDescription(rs.getString("descr"));
                templ.setComments(rs.getString("comments"));
                templ.setProjectID(rs.getInt("proj_id"));
                templ.setWellListID(rs.getInt("wellist_id"));
                AuditImpl audit = new AuditImpl();
                audit.setModifierID(rs.getInt("modifier"));
                Timestamp modifiedTimestamp = rs.getTimestamp("modified");
                if (modifiedTimestamp != null) {
                    audit.setModified(modifiedTimestamp.toLocalDateTime().toLocalDate());
                }
                templ.setAudit((com.stratadata.model3.audit.Audit)audit);
                templ.setnMbrs(rs.getInt("nmbrs"));
                list.add(templ);
            }
        }
        return list;
    }

    public List<Integer> searchChartMember(int wellID, Integer projID) throws SQLException {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (this.sbdb.isConnected()) {
            String sql = projID != null ? "SELECT DISTINCT c.chart_id as cid FROM " + this.sbdb.DBTableName("CHTMBR") + " m," + this.sbdb.DBTableName("CHART") + " c WHERE m.well_id=" + wellID + " AND c.proj_id=" + projID + " AND m.chart_id=c.chart_id" : "SELECT DISTINCT chart_id as cid FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE well_id=" + wellID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    list.add(rs.getInt("cid"));
                }
            }
        } else {
            block6: for (ChartTemplate templ : this.charts.values()) {
                for (ChartTemplate.BlockOcc block : templ.getBlocks()) {
                    if (block.getWellID() != wellID) continue;
                    list.add(templ.getID());
                    continue block6;
                }
            }
        }
        return list;
    }

    public List<Integer> searchBlockTemplateChildren(int wellID) throws SQLException {
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (this.sbdb.isConnected()) {
            String sql = "SELECT DISTINCT parent_id as parent FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE well_id=" + wellID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    list.add(rs.getInt("parent"));
                }
            }
        } else {
            for (BlockTemplate parent : this.blocksByID.values()) {
                if (((BlockTemplateParent)parent).getChild(wellID) == null) continue;
                list.add(parent.getID());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PanelTemplate> searchPanels(PanelType type, String name, Integer projID) throws SQLException, SBException {
        if (name == null || name.isEmpty()) {
            name = "%";
        }
        String sql = "SELECT panel_id,type,isvisible,descr,comments,isdefault,prop,sch_id,std_id,envsch_id,synsch_id,grpset_id,proj_id,agecurve_id,shape_id," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE ucase(descr) like " + SB.DBString((String)name.toUpperCase());
        if (projID != null) {
            sql = sql + " AND proj_id" + (String)(projID > 0 ? "=" + projID : " IS NULL");
        }
        if (type != null) {
            sql = sql + " AND type='" + type.name() + "'";
        }
        sql = sql + " AND isvisible='Y' ORDER BY type";
        LinkedList<PanelTemplate> list = new LinkedList<PanelTemplate>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(this.getPanelTemplateFromResultSet(rs));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartTemplate getChartTemplate(int ID) throws SQLException {
        HashMap<Integer, ChartTemplate> hashMap = this.charts;
        synchronized (hashMap) {
            if (this.charts.get(ID) != null) {
                return this.charts.get(ID);
            }
        }
        if (this.sbdb.isConnected()) {
            String sql = "SELECT chart_id,descr,comments,proj_id,wellist_id,props,sch_id,header,cht_key," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHART") + " WHERE chart_id=" + ID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    ChartTemplate chartTemplate = this.getChartTemplateFromResultSet(rs);
                    return chartTemplate;
                }
            }
        }
        return null;
    }

    public List<ChartTemplate> getCharts(Integer projID) throws SQLException {
        ArrayList<ChartTemplate> list = new ArrayList<ChartTemplate>();
        for (ChartTemplate templ : this.charts.values()) {
            if (projID != null && templ.getProjID() != projID.intValue()) continue;
            list.add(templ);
        }
        return list;
    }

    public ChartTemplate getLoadChartTemplate(int ID) throws SQLException {
        ChartTemplate templ = this.getChartTemplate(ID);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            templ.loadMbrs(this.sbdb, stmt);
        }
        return templ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChartTemplate getChartTemplateFromResultSet(ResultSet rs) throws SQLException {
        int ID = rs.getInt("chart_id");
        HashMap<Integer, ChartTemplate> hashMap = this.charts;
        synchronized (hashMap) {
            if (this.charts.get(ID) != null) {
                return this.charts.get(ID);
            }
            ChartTemplate t = this.createChartTemplateFromResultSet(ID, rs);
            this.charts.put(ID, t);
            return t;
        }
    }

    private ChartTemplate createChartTemplateFromResultSet(int ID, ResultSet rs) throws SQLException {
        String descr = rs.getString("descr");
        String comments = rs.getString("comments");
        int pID = rs.getInt("proj_id");
        int wellListID = rs.getInt("wellist_id");
        String props = rs.getString("props");
        int schID = rs.getInt("sch_id");
        String header = rs.getString("header");
        String key = rs.getString("cht_key");
        Audit audit = new Audit(rs);
        int acm = rs.getInt("acm");
        return new ChartTemplate(this, ID, descr, comments, pID, wellListID, props, schID, header, key, audit, acm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] deleteWell(int wellID, Integer projID) throws SQLException, SBException, SBPermissionException {
        boolean deletedBlocks = false;
        boolean updatedSchemeBlocks = true;
        int deletedCharts = 2;
        int[] results = new int[3];
        List<Integer> chartIDs = this.searchChartMember(wellID, projID);
        List<Integer> parentBlocks = this.searchBlockTemplateChildren(wellID);
        try (Statement stmt = this.sbdb.isConnected() ? this.sbdb.getDatabase().createStatement() : null;){
            for (Integer id : chartIDs) {
                ChartTemplate templ = this.getChartTemplate(id);
                if (projID != null) assert (templ.getProjID() == projID.intValue());
                int[] templRes = templ.deleteWell(this.sbdb, wellID, stmt);
                results[0] = results[0] + templRes[0];
                results[1] = results[1] + templRes[1];
                if (this.sbdb.isConnected()) {
                    this.sbdb.commit();
                    if (templRes[2] <= 0) continue;
                    this.deleteTemplate(templ);
                    results[2] = results[2] + 1;
                    this.sbdb.commit();
                    continue;
                }
                if (templRes[2] <= 0) continue;
                this.charts.remove(templ.getID());
            }
            for (Integer parentId : parentBlocks) {
                BlockTemplateParent parent = (BlockTemplateParent)this.blocksByID.get(parentId);
                if (parent == null) {
                    parent = (BlockTemplateParent)this.getBlockTemplate(parentId);
                }
                if (this.sbdb.isConnected()) {
                    this.deleteBlockChild(parent, wellID);
                    this.sbdb.commit();
                    continue;
                }
                parent.removeChild(wellID);
            }
        }
        return results;
    }

    public void fireWellWillBeDeleted(int wellID) {
        for (ChartContainer c : this.chartContainers.keySet()) {
            c.wellWillBeDeleted(wellID);
        }
    }

    void fireTemplateAdded(TemplateDescr template) {
        for (ChartContainer c : this.chartContainers.keySet()) {
            c.templateAdded(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemplate(ChartTemplateBase templ) throws SQLException, SBException, SBPermissionException {
        Object stmt;
        if (templ == null) {
            throw new IllegalArgumentException("Can't delete: template is null");
        }
        if (!(templ instanceof BlockTemplate) && !(templ instanceof ChartTemplate)) {
            throw new IllegalArgumentException("Unrecognised template type");
        }
        if (templ.countObservers() > 0) {
            // empty if block
        }
        if (templ instanceof BlockTemplate) {
            stmt = this.sbdb.getDatabase().createStatement();
            try {
                int nRows;
                if (!templ.canWrite(this.sbdb, (Statement)stmt)) {
                    throw new SBPermissionException("Can't delete read-only template: " + templ.getName());
                }
                String sql = "SELECT COUNT(DISTINCT(CHART_ID)) as n FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE block_id=" + templ.getID();
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next() && (nRows = rs.getInt("n")) > 0) {
                    throw new SBException("Can't delete '" + templ.getName() + "': block is used in " + nRows + " charts");
                }
                sql = "SELECT COUNT(*) as n from " + this.sbdb.DBTableName("CHTPANL_BLKMBR") + " WHERE block_id=" + templ.getID();
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next() && (nRows = rs.getInt("n")) > 0) {
                    throw new SBException("Can't delete '" + templ.getName() + "': block is used in " + nRows + " panels");
                }
                sql = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE block_id=" + templ.getID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                sql = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE block_id=" + templ.getID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        templ.delete(this.sbdb);
        if (templ instanceof BlockTemplate) {
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.blockWillBeDeleted(templ.getID(), false);
            }
        } else if (templ instanceof ChartTemplate) {
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.chartWillBeDeleted(templ.getID());
            }
        }
        if (templ instanceof BlockTemplate) {
            Optional<BlockTemplateInfo> info;
            stmt = this.blocksByID;
            synchronized (stmt) {
                this.blocksByID.remove(templ.getID());
            }
            List<BlockTemplate> list = this.blocksByType.get(((BlockTemplate)templ).getType());
            if (list != null) {
                list.remove(templ);
            }
            if (this.blockInfoList != null && (info = this.blockInfoList.stream().filter(i -> i.getID() == templ.getID()).findFirst()).isPresent()) {
                this.blockInfoList.remove(info.get());
            }
        } else {
            HashMap<Integer, ChartTemplate> hashMap = this.charts;
            synchronized (hashMap) {
                this.charts.remove(templ.getID());
            }
        }
    }

    public void deleteBlockChild(BlockTemplateParent parent, int wellID) throws SQLException, SBException, SBPermissionException {
        BlockTemplateChild child = parent.removeChild(wellID);
        if (child == null) {
            throw new NullPointerException("No child block for wellID " + wellID);
        }
        child.delete(this.sbdb);
        for (ChartContainer c : this.chartContainers.keySet()) {
            c.blockWillBeDeleted(child.getID(), false);
        }
    }

    public void deleteRedundantBlockChildren(BlockTemplateParent parent) throws SQLException, SBException, SBPermissionException {
        for (Integer wellID : parent.getChildWellIDs()) {
            BlockTemplateChild child = parent.getChild(wellID);
            if (!child.getPanels().equals(parent.getPanels())) continue;
            Logger.getLogger(ChartManager.class.getName()).log(Level.INFO, "Deleting redundant child block template for well {0}", wellID);
            this.deleteBlockChild(parent, wellID);
        }
    }

    public void resetBlockChildPanel(BlockTemplateParent parent, int wellID, int panelIndex) throws SQLException, SBException, SBPermissionException {
        PanelOcc parentPanelOcc = parent.getPanels().get(panelIndex);
        BlockTemplateChild child = parent.getChild(wellID);
        List<PanelOcc> childPanels = child.getPanels();
        PanelOcc realChildOcc = childPanels.get(panelIndex);
        childPanels.remove(panelIndex);
        childPanels.add(panelIndex, parentPanelOcc);
        if (parent.getPanels().equals(childPanels)) {
            this.deleteBlockChild(parent, wellID);
        } else {
            List<ChartPanelSnapshot> updates = BlockTemplate.createPanelOccUpdates(childPanels);
            updates.remove(panelIndex);
            PanelOcc newPanelOccForChild = PanelOcc.copy(parentPanelOcc);
            newPanelOccForChild.setPanelNo(null);
            ChartPanelSnapshot toUpdate = new ChartPanelSnapshot(newPanelOccForChild, null, null);
            updates.add(panelIndex, toUpdate);
            child.updatePanels(this.sbdb, updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCorrTemplate(CorrelationTemplate cTempl) throws SQLException, SBException, SBPermissionException {
        Object rs;
        if (cTempl == null) {
            throw new IllegalArgumentException("Can't delete correlation: template is null");
        }
        String sql = "SELECT COUNT(*) as n FROM " + this.sbdb.DBTableName("CHTCORROCC") + " WHERE corrsch_id=" + cTempl.getID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int nRows;
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && (nRows = rs.getInt("n")) > 0) {
                throw new SBException("Can't delete '" + cTempl.getName() + "': in use in " + nRows + " charts");
            }
        }
        cTempl.delete(this.sbdb);
        rs = this.corrTemplates;
        synchronized (rs) {
            this.corrTemplates.remove(cTempl.getID());
        }
        List<CorrelationTemplate> list = this.corrByType.get(cTempl.getType());
        if (list != null) {
            list.remove(cTempl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePanelTemplate(int panelID) throws SQLException, SBException, SBPermissionException {
        HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
        synchronized (hashMap) {
            PanelTemplate template = this.getPanelTemplate(panelID);
            if (this.sbdb.isConnected()) {
                template.delete(this.sbdb);
            } else {
                for (BlockTemplate block : this.blocksByID.values()) {
                    block.excludePanel(panelID);
                }
            }
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.panelTemplateWillBeDeleted(template.getID());
            }
            this.panelsByID.remove(panelID);
            if (this.panelsByType.get(template.getType()) != null) {
                this.panelsByType.get(template.getType()).remove(template);
            }
        }
    }

    public ModelProcess deleteCorrelationLinesLinkedToUnits(final List<IGDUnitBase> units) {
        if (units.isEmpty()) {
            return ModelProcess.emptyProcess();
        }
        return new ModelProcess(this){
            private final List<ModelProcess> affectedTemplateProcesses;
            final /* synthetic */ ChartManager this$0;
            {
                ChartManager chartManager = this$0;
                Objects.requireNonNull(chartManager);
                this.this$0 = chartManager;
                this.affectedTemplateProcesses = new LinkedList<ModelProcess>();
            }

            public void doDatabaseProcess() throws SQLException {
                LinkedList<Integer> unitIDs = new LinkedList<Integer>();
                LinkedList<Integer> lstratUnitIDs = new LinkedList<Integer>();
                for (IGDUnitBase unit : units) {
                    if (unit instanceof LithostratUnit) {
                        lstratUnitIDs.add(unit.getUnitID());
                        continue;
                    }
                    unitIDs.add(unit.getUnitID());
                }
                LinkedList<CorrelationTemplate> affectedCorrTemplates = new LinkedList<CorrelationTemplate>();
                try (Statement stmt = this.this$0.sbdb.getDatabase().createStatement();){
                    ResultSet rs;
                    String sql;
                    if (!unitIDs.isEmpty()) {
                        sql = "SELECT corrsch_id from " + this.this$0.sbdb.DBTableName("CHTLN_UNIT") + " l WHERE l.igd_id in(" + StringUtils.join(unitIDs, (String)",") + ") GROUP BY corrsch_id";
                        rs = stmt.executeQuery(this.this$0.sbdb.modQuery(sql));
                        while (rs.next()) {
                            affectedCorrTemplates.add(this.this$0.getCorrTemplate(rs.getInt("corrsch_id")));
                        }
                    }
                    if (!lstratUnitIDs.isEmpty()) {
                        sql = "SELECT corrsch_id from " + this.this$0.sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " l WHERE l.unit_id in(" + StringUtils.join(lstratUnitIDs, (String)",") + ") GROUP BY corrsch_id";
                        rs = stmt.executeQuery(this.this$0.sbdb.modQuery(sql));
                        while (rs.next()) {
                            affectedCorrTemplates.add(this.this$0.getCorrTemplate(rs.getInt("corrsch_id")));
                        }
                    }
                    for (CorrelationTemplate templ : affectedCorrTemplates) {
                        ModelProcess templProcess = templ.deleteLinesLinkedToUnits(units, this.this$0.sbdb, stmt);
                        templProcess.doDatabaseProcess();
                        this.affectedTemplateProcesses.add(templProcess);
                    }
                }
            }

            public void doModelProcess() {
                for (ModelProcess p : this.affectedTemplateProcesses) {
                    p.doModelProcess();
                }
            }
        };
    }

    public ModelProcess deleteCorrelationLinesLinkedToSurfaces(final List<Surface> surfaces) {
        if (surfaces.isEmpty()) {
            return ModelProcess.emptyProcess();
        }
        return new ModelProcess(this){
            private final List<ModelProcess> affectedTemplateProcesses;
            final /* synthetic */ ChartManager this$0;
            {
                ChartManager chartManager = this$0;
                Objects.requireNonNull(chartManager);
                this.this$0 = chartManager;
                this.affectedTemplateProcesses = new LinkedList<ModelProcess>();
            }

            public void doDatabaseProcess() throws SQLException {
                LinkedList<Integer> surfaceIDs = new LinkedList<Integer>();
                for (Surface surface : surfaces) {
                    surfaceIDs.add(surface.getSurfaceID());
                }
                LinkedList<CorrelationTemplate> affectedCorrTemplates = new LinkedList<CorrelationTemplate>();
                try (Statement stmt = this.this$0.sbdb.getDatabase().createStatement();){
                    String sql = "SELECT corrsch_id from " + this.this$0.sbdb.DBTableName("CHTLN_SURFACE") + " l WHERE l.surface_id in(" + StringUtils.join(surfaceIDs, (String)",") + ") GROUP BY corrsch_id";
                    ResultSet rs = stmt.executeQuery(this.this$0.sbdb.modQuery(sql));
                    while (rs.next()) {
                        affectedCorrTemplates.add(this.this$0.getCorrTemplate(rs.getInt("corrsch_id")));
                    }
                    for (CorrelationTemplate templ : affectedCorrTemplates) {
                        ModelProcess templProcess = templ.deleteLinesLinkedToSurfaces(surfaces, this.this$0.sbdb, stmt);
                        templProcess.doDatabaseProcess();
                        this.affectedTemplateProcesses.add(templProcess);
                    }
                }
            }

            public void doModelProcess() {
                for (ModelProcess p : this.affectedTemplateProcesses) {
                    p.doModelProcess();
                }
            }
        };
    }

    public boolean checkDeleteTxGroup(int groupID) throws SQLException {
        String sql = "SELECT COUNT(panel_id) as c from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE grp_id=" + groupID + " OR highlight_grp_id=" + groupID + " OR exclude_grp_id=" + groupID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int nInnerPanels = rs.getInt("c");
                boolean bl = nInnerPanels <= 0;
                return bl;
            }
        }
        throw new IllegalStateException("No result set");
    }

    public List<PanelTemplate> getTxGroupPanels(int groupID) throws SQLException, SBException {
        String sql = "SELECT panel_id from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE grp_id=" + groupID + " OR highlight_grp_id=" + groupID + " OR exclude_grp_id=" + groupID + " GROUP BY panel_id";
        HashSet<Integer> ids = new HashSet<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                ids.add(rs.getInt("panel_id"));
            }
        }
        return this.getPanelTemplates(ids);
    }

    public List<PanelTemplate> getTxGroupSetPanels(int groupSetID) throws SQLException, SBException {
        String sql = "SELECT panel_id from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE grpset_id=" + groupSetID + " GROUP BY panel_id";
        HashSet<Integer> ids = new HashSet<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                ids.add(rs.getInt("panel_id"));
            }
            sql = "SELECT panel_id from " + this.sbdb.DBTableName("CHTPANL") + " WHERE grpset_id=" + groupSetID + " GROUP BY panel_id";
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs2.next()) {
                ids.add(rs2.getInt("panel_id"));
            }
        }
        return this.getPanelTemplates(ids);
    }

    public List<TxGroup> getTxGroupsNotInCharts() throws SQLException {
        String sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("TXGROUP") + " WHERE grp_id NOT IN (SELECT grp_id FROM " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE grp_id IS NOT NULL) AND grp_id NOT IN (SELECT highlight_grp_id FROM " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE highlight_grp_id IS NOT NULL) AND grp_id NOT IN (SELECT grp_id from " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id IN (SELECT grpset_id FROM " + this.sbdb.DBTableName("CHTPANL") + ")) AND grp_id NOT IN (SELECT grp_id from " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id IN (SELECT grpset_id FROM " + this.sbdb.DBTableName("CHTPANLMBR") + "))";
        HashSet<Integer> ids = new HashSet<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                ids.add(rs.getInt("grp_id"));
            }
        }
        LinkedList<TxGroup> list = new LinkedList<TxGroup>();
        for (Integer i : ids) {
            list.add(this.sbdb.getTxGroup(i.intValue()));
        }
        Collections.sort(list);
        return list;
    }

    private List<PanelTemplate> getPanelTemplates(Collection<Integer> panelIDs) throws SQLException, SBException {
        LinkedList<PanelTemplate> panels = new LinkedList<PanelTemplate>();
        for (Integer id : panelIDs) {
            panels.add(this.getPanelTemplate(id));
        }
        return panels;
    }

    public boolean checkDeleteTxGroupSet(int groupSetID) throws SQLException {
        String sql = "SELECT COUNT(panel_id) as c from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE grpset_id=" + groupSetID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int nPanels;
            int nInnerPanels;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && (nInnerPanels = rs.getInt("c")) > 0) {
                boolean bl = false;
                return bl;
            }
            sql = "SELECT COUNT(panel_id) as c from " + this.sbdb.DBTableName("CHTPANL") + " WHERE grpset_id=" + groupSetID;
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs2.next() && (nPanels = rs2.getInt("c")) > 0) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean checkTxGroupProjChange(int groupID, int newProjID) throws SQLException {
        assert (newProjID != 0);
        String sql = "SELECT COUNT(p.panel_id) as c from " + this.sbdb.DBTableName("CHTPANLMBR") + " m, " + this.sbdb.DBTableName("CHTPANL") + " p WHERE (m.grp_id=" + groupID + " OR m.highlight_grp_id=" + groupID + ")  AND p.panel_id=m.panel_id AND p.proj_id<>" + newProjID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int nInnerPanels = rs.getInt("c");
                boolean bl = nInnerPanels <= 0;
                return bl;
            }
        }
        throw new IllegalStateException("No result set");
    }

    public boolean checkTxGroupSetProjChange(int groupSetID, int newProjID) throws SQLException {
        assert (newProjID != 0);
        String sql = "SELECT COUNT(m.panel_id) as c from " + this.sbdb.DBTableName("CHTPANLMBR") + " m, " + this.sbdb.DBTableName("CHTPANL") + " p WHERE m.grpset_id=" + groupSetID + "  AND p.panel_id=m.panel_id AND p.proj_id<>" + newProjID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && rs.getInt("c") > 0) {
                boolean bl = false;
                return bl;
            }
            sql = "SELECT COUNT(panel_id) as c FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE grpset_id=" + groupSetID + " AND proj_id<>" + newProjID;
            ResultSet rs2 = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs2.next() && rs2.getInt("c") > 0) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static boolean checkDeleteIGDScheme(SBdb sbdb, int schID) throws SQLException {
        String[] sql = new String[]{"SELECT COUNT(panel_id) as c from " + sbdb.DBTableName("CHTPANL") + " WHERE sch_id=" + schID, "SELECT COUNT(panel_id) as c from " + sbdb.DBTableName("CHTPANLMBR") + " WHERE sch_id=" + schID, "SELECT COUNT(chart_id) as c from " + sbdb.DBTableName("CHART") + " WHERE sch_id=" + schID, "SELECT COUNT (chart_id) as c from " + sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " WHERE sch_id=" + schID, "SELECT COUNT(corrsch_id) as c from " + sbdb.DBTableName("CHTLN_UNIT") + " l, " + sbdb.DBTableName("IGD_DICT") + " d WHERE d.sch_id= " + schID + " AND l.igd_id=d.igd_id", "SELECT COUNT(corrsch_id) as c from " + sbdb.DBTableName("CHTLN_SURFACE") + " l, " + sbdb.DBTableName("SURFACE") + " s WHERE s.sch_id= " + schID + " AND l.surface_id=s.surface_id", "SELECT COUNT(block_id) as c from " + sbdb.DBTableName("CHTPREF_BLK") + " WHERE sch_id=" + schID, "SELECT COUNT(block_id) as c from " + sbdb.DBTableName("CHTPREF_SCH") + " WHERE sch_id=" + schID, "SELECT COUNT(corrsch_id) as c from " + sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " l, " + sbdb.DBTableName("IGD_DICT_LSTRAT") + " d WHERE d.sch_id= " + schID + " AND l.unit_id=d.unit_id", "SELECT COUNT(block_id) as c from " + sbdb.DBTableName("CHTBLOCKMBR") + " WHERE sch_id=" + schID};
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            for (String s : sql) {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(s));
                if (!rs.next() || rs.getInt("c") <= 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public List<ChartOcc> getIGDSchemeUsages(int schID) throws SQLException, SBException {
        ArrayList<ChartOcc> list = new ArrayList<ChartOcc>();
        String[] sql = new String[]{"SELECT panel_id from " + this.sbdb.DBTableName("CHTPANL") + " WHERE sch_id=" + schID, "SELECT panel_id, panel_no from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE sch_id=" + schID, "SELECT chart_id from " + this.sbdb.DBTableName("CHART") + " WHERE sch_id=" + schID, "SELECT chart_id from " + this.sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " WHERE sch_id=" + schID, "SELECT corrsch_id from " + this.sbdb.DBTableName("CHTLN_UNIT") + " l, " + this.sbdb.DBTableName("IGD_DICT") + " d WHERE d.sch_id= " + schID + " AND l.igd_id=d.igd_id GROUP BY corrsch_id", "SELECT corrsch_id from " + this.sbdb.DBTableName("CHTLN_SURFACE") + " l, " + this.sbdb.DBTableName("SURFACE") + " s WHERE s.sch_id= " + schID + " AND l.surface_id=s.surface_id GROUP BY corrsch_id", "SELECT p.block_id,u.abr as userAbr,i.well_name as well FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " p, " + this.sbdb.DBTableName("WELLS") + " i," + this.sbdb.DBTableName("USERDEF") + " u WHERE p.sch_id=" + schID + " AND p.well_id=i.well_id AND u.user_id=p.user_id", "SELECT p.block_id,u.abr as userAbr,p.location from " + this.sbdb.DBTableName("CHTPREF_SCH") + " p," + this.sbdb.DBTableName("USERDEF") + " u  WHERE p.sch_id=" + schID + " AND u.user_id=p.user_id", "SELECT b.block_id, b.parent_id, m.panel_no from " + this.sbdb.DBTableName("CHTBLOCKMBR") + " m, " + this.sbdb.DBTableName("CHTBLOCK") + " b WHERE b.block_id=m.block_id and m.sch_id=" + schID};
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (int i = 0; i < sql.length; ++i) {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql[i]));
                while (rs.next()) {
                    switch (i) {
                        case 0: 
                        case 1: {
                            PanelTemplate panel = this.getPanelTemplate(rs.getInt("panel_id"));
                            list.add(new ChartOcc(panel.getType(), panel, i == 0 ? "panel template" : "Header for inner panel"));
                            break;
                        }
                        case 2: {
                            ChartTemplate chart = this.getChartTemplate(rs.getInt("chart_id"));
                            list.add(new ChartOcc("Chart", chart, "background colour scheme"));
                            break;
                        }
                        case 3: {
                            ChartTemplate chart2 = this.getChartTemplate(rs.getInt("chart_id"));
                            list.add(new ChartOcc("Chart", chart2, "standard correlation"));
                            break;
                        }
                        case 4: 
                        case 5: {
                            CorrelationTemplate templ = this.getCorrTemplate(rs.getInt("corrsch_id"));
                            list.add(new ChartOcc(templ.getType(), templ, "correlation template" + (String)(templ.getProjID() > 0 ? " (" + String.valueOf(this.sbdb.getProject(templ.getProjID())) + ")" : "")));
                            break;
                        }
                        case 6: {
                            list.add(new ChartOcc(rs.getString("well"), "Chart tab for user " + rs.getString("userAbr"), "background colour scheme"));
                            break;
                        }
                        case 7: {
                            list.add(new ChartOcc(switch (location = rs.getString("location")) {
                                case INT_CHART_LOC_STRING -> "Schemes & Interpreations";
                                case TXDB_CHART_LOC_STRING -> "Taxonomic Database";
                            }, "Scheme chart tab for user " + rs.getString("userAbr"), "background colour scheme"));
                            break;
                        }
                        case 8: {
                            int parentID = rs.getInt("parent_id");
                            int blockID = parentID > 0 ? parentID : rs.getInt("block_id");
                            BlockTemplate block = this.getBlockTemplate(blockID);
                            Object name = block.toString();
                            if (block.getProjID() > 0) {
                                name = (String)name + " (" + String.valueOf(this.sbdb.getProject(block.getProjID())) + ")";
                            }
                            list.add(new ChartOcc("Well Block", name, (parentID > 0 ? "Overridden " : "") + "panel number: " + (rs.getInt("panel_no") + 1)));
                        }
                    }
                }
            }
        }
        return list;
    }

    public List<ChartOcc> getEnvSchemeUsages(int envSchID) throws SQLException, SBException {
        ArrayList<ChartOcc> list = new ArrayList<ChartOcc>();
        String sql = "SELECT panel_id from " + this.sbdb.DBTableName("CHTPANL") + " WHERE envsch_id=" + envSchID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                PanelTemplate panel = this.getPanelTemplate(rs.getInt("panel_id"));
                list.add(new ChartOcc(panel.getType(), panel, "panel template"));
            }
        }
        return list;
    }

    public static boolean checkDeleteCmpStd(SBdb sbdb, int stdID) throws SQLException {
        String[] sql = new String[]{"SELECT COUNT(panel_id) as c from " + sbdb.DBTableName("CHTPANL") + " WHERE std_id=" + stdID, "SELECT COUNT(panel_id) as c from " + sbdb.DBTableName("CHTPANLMBR") + " WHERE std_id=" + stdID};
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            for (String s : sql) {
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(s));
                if (!rs.next() || rs.getInt("c") <= 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public List<ChartOcc> getCmpStdUsages(int stdID) throws SQLException, SBException {
        ArrayList<ChartOcc> list = new ArrayList<ChartOcc>();
        String[] sql = new String[]{"SELECT panel_id from " + this.sbdb.DBTableName("CHTPANL") + " WHERE std_id=" + stdID, "SELECT panel_id, panel_no from " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE std_id=" + stdID};
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (int i = 0; i < sql.length; ++i) {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql[i]));
                while (rs.next()) {
                    switch (i) {
                        case 0: 
                        case 1: {
                            PanelTemplate panel = this.getPanelTemplate(rs.getInt("panel_id"));
                            list.add(new ChartOcc(panel.getType(), panel, i == 0 ? "panel template" : "Header for inner panel"));
                        }
                    }
                }
            }
        }
        return list;
    }

    public List<ChartOcc> getIGDUnitUsages(List<IGDUnitBase> units) throws SQLException {
        ArrayList<ChartOcc> list = new ArrayList<ChartOcc>();
        LinkedList<Integer> unitIDs = new LinkedList<Integer>();
        LinkedList<Integer> lstratUnitIDs = new LinkedList<Integer>();
        for (IGDUnitBase unit : units) {
            if (unit instanceof LithostratUnit) {
                lstratUnitIDs.add(unit.getUnitID());
                continue;
            }
            unitIDs.add(unit.getUnitID());
        }
        String[] queries = new String[2];
        if (!unitIDs.isEmpty()) {
            queries[0] = "SELECT corrsch_id from " + this.sbdb.DBTableName("CHTLN_UNIT") + " l WHERE l.igd_id in(" + StringUtils.join(unitIDs, (String)",") + ") GROUP BY corrsch_id";
        }
        if (!lstratUnitIDs.isEmpty()) {
            queries[1] = "SELECT corrsch_id from " + this.sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " l WHERE l.unit_id in(" + StringUtils.join(lstratUnitIDs, (String)",") + ") GROUP BY corrsch_id";
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (String sql : queries) {
                if (sql == null) continue;
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    CorrelationTemplate templ = this.getCorrTemplate(rs.getInt("corrsch_id"));
                    list.add(new ChartOcc(templ.getType(), templ, "correlation template" + (String)(templ.getProjID() > 0 ? " (" + String.valueOf(this.sbdb.getProject(templ.getProjID())) + ")" : "")));
                }
            }
        }
        return list;
    }

    public List<ChartOcc> getSurfaceUsages(List<Surface> surfaces) throws SQLException {
        LinkedList<Integer> surfaceIDs = new LinkedList<Integer>();
        for (Surface surface : surfaces) {
            surfaceIDs.add(surface.getSurfaceID());
        }
        ArrayList<ChartOcc> occs = new ArrayList<ChartOcc>();
        String sql = "SELECT corrsch_id from " + this.sbdb.DBTableName("CHTLN_SURFACE") + " l WHERE l.surface_id in(" + StringUtils.join(surfaceIDs, (String)",") + ") GROUP BY corrsch_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                CorrelationTemplate templ = this.getCorrTemplate(rs.getInt("corrsch_id"));
                occs.add(new ChartOcc(templ.getType(), templ, "correlation template" + (String)(templ.getProjID() > 0 ? " (" + String.valueOf(this.sbdb.getProject(templ.getProjID())) + ")" : "")));
            }
        }
        return occs;
    }

    public List<String[]> getTabs(ChartTemplateBase templ) throws SQLException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String sql = null;
        if (templ instanceof ChartTemplate) {
            sql = "SELECT i.well_name as well, u.abr as userAbr, i.well_id as wellid FROM " + this.sbdb.DBTableName("CHTPREF_CHT") + " p, " + this.sbdb.DBTableName("WELLS") + " i," + this.sbdb.DBTableName("USERDEF") + " u WHERE p.chart_id=" + templ.getID() + " AND p.well_id=i.well_id AND u.user_id=p.user_id";
        } else if (templ instanceof BlockTemplate && ((BlockTemplate)templ).getType() == BlockType.WELL) {
            sql = "SELECT i.well_name as well, u.abr as userAbr FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " p, " + this.sbdb.DBTableName("WELLS") + " i," + this.sbdb.DBTableName("USERDEF") + " u WHERE p.block_id=" + templ.getID() + " AND p.well_id=i.well_id AND u.user_id=p.user_id";
        }
        if (sql != null) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    String[] arr = new String[]{rs.getString("well"), rs.getString("userAbr")};
                    list.add(arr);
                }
            }
            return list;
        }
        if (templ instanceof BlockTemplate && ((BlockTemplate)templ).getType() == BlockType.SCHEME) {
            sql = "SELECT u.abr as userAbr,p.location as location from " + this.sbdb.DBTableName("CHTPREF_SCH") + " p," + this.sbdb.DBTableName("USERDEF") + " u  WHERE p.block_id=" + templ.getID() + " AND u.user_id=p.user_id";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    String[] arr = new String[]{switch (location = rs.getString("location")) {
                        case INT_CHART_LOC_STRING -> "Schemes & Interpreations";
                        case TXDB_CHART_LOC_STRING -> "Taxonomic Database";
                    }, rs.getString("userAbr")};
                    list.add(arr);
                }
            }
            return list;
        }
        return list;
    }

    public List<String[]> getTabs(int wellID, int projID) throws SQLException {
        String[] arr;
        ResultSet rs;
        ArrayList<String[]> list = new ArrayList<String[]>();
        String sql = "SELECT b.descr as block, u.abr as userAbr FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " p, " + this.sbdb.DBTableName("CHTBLOCK") + " b, " + this.sbdb.DBTableName("USERDEF") + " u WHERE p.well_id=" + wellID + " AND b.proj_id=" + projID + " AND p.block_id=b.block_id AND p.user_id=u.user_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                arr = new String[]{rs.getString("block"), rs.getString("userAbr")};
                list.add(arr);
            }
        }
        sql = "SELECT b.descr as chart, u.abr as userAbr FROM " + this.sbdb.DBTableName("CHTPREF_CHT") + " p, " + this.sbdb.DBTableName("CHART") + " b, " + this.sbdb.DBTableName("USERDEF") + " u WHERE p.well_id=" + wellID + " AND b.proj_id=" + projID + " AND p.chart_id=b.chart_id AND p.user_id=u.user_id";
        stmt = this.sbdb.getDatabase().createStatement();
        try {
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                arr = new String[]{rs.getString("chart"), rs.getString("userAbr")};
                list.add(arr);
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return list;
    }

    public int deleteTabs(int wellID, int projID) throws SQLException {
        for (ChartContainer c : this.chartContainers.keySet()) {
            c.wellWillbeRemovedFromProject(wellID, projID);
        }
        String[] sql = new String[]{"DELETE from " + this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE well_id=" + wellID + " AND block_id IN(SELECT block_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID + ")", "DELETE from " + this.sbdb.DBTableName("CHTPREF_CHT") + " WHERE well_id=" + wellID + " AND chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")"};
        int rows = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (String isql : sql) {
                rows += stmt.executeUpdate(this.sbdb.modQuery(isql));
            }
        }
        return rows;
    }

    public void deleteOrphanedInvisiblePanels() throws SQLException, SBException, SBPermissionException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Calendar cal = Calendar.getInstance();
            cal.add(6, -1);
            Date oneDayAgo = cal.getTime();
            String sql = "SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE isvisible='N' AND created < " + this.sbdb.DBDate(oneDayAgo) + " AND panel_id NOT IN (select panel_id from " + this.sbdb.DBTableName("CHTBLOCKMBR") + ")";
            LOGGER.info("Deleting orphaned invisible panels... '" + sql + "'");
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                this.deletePanelTemplate(rs.getInt("panel_id"));
            }
        }
    }

    public PanelTemplate addPanelTemplate(String name, String comments, int projID, PanelTemplate toCopy, boolean visible) throws SQLException, SBException {
        PanelProperties p = this.copyPanelProperties(toCopy.getEditableProp());
        return this.newPanelTemplate(name, comments, projID, p, visible);
    }

    public PanelTemplate addPanelTemplate(PanelType type, String name, String descr, int projID, PanelProperties properties, Object scheme, boolean visible) throws SQLException, SBException, SBPermissionException {
        PanelProperties p;
        if (!SBRestrictable.canWrite((SBdb)this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason((boolean)true));
        }
        if (properties != null) {
            p = properties;
        } else {
            p = this.getDefaultPanelProperties(type);
            if (p == null) {
                p = PanelType.requiresScheme(type) && scheme != null ? new PanelPropertiesBuilder(type, null).schemeObject(scheme).build(this.sbdb, this.shapeStoreService) : new PanelPropertiesBuilder(type, null).build(this.sbdb, this.shapeStoreService);
            }
            p = this.copyPanelProperties(p);
        }
        return this.newPanelTemplate(name, descr, projID, p, visible);
    }

    public boolean checkNewTemplateName(String name, TemplateType type, int projID) throws SQLException {
        try {
            ChartManager.checkNewTemplateName(this.sbdb, name, type, projID);
        }
        catch (InvalidFieldException ife) {
            return false;
        }
        return true;
    }

    public static void checkNewTemplateName(SBdb sbdb, String descr, TemplateType type, int projID) throws SQLException, InvalidFieldException {
        Object sql = "SELECT descr from ";
        if (type == null) {
            sql = (String)sql + sbdb.DBTableName("CHART") + " WHERE ";
        } else if (type instanceof PanelType) {
            PanelType panelType = (PanelType)type;
            sql = (String)sql + sbdb.DBTableName("CHTPANL") + " WHERE type=" + SB.DBString((String)panelType.name()) + " AND ";
        } else if (type instanceof BlockType) {
            BlockType blockType = (BlockType)type;
            sql = (String)sql + sbdb.DBTableName("CHTBLOCK") + " WHERE type=" + SB.DBString((String)blockType.name()) + " AND ";
        } else if (type instanceof CorrelationType) {
            CorrelationType corrType = (CorrelationType)type;
            sql = (String)sql + sbdb.DBTableName("CHARTCORR") + " WHERE corr_type=" + SB.DBString((String)corrType.name()) + " AND ";
        }
        sql = (String)sql + (String)(projID > 0 ? "(proj_id=" + projID + " OR proj_id IS NULL) AND " : "") + "ucase(descr)=?";
        try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery((String)sql));){
            pStmt.setString(1, descr.toUpperCase());
            ResultSet rs = pStmt.executeQuery();
            if (rs.next()) {
                throw new InvalidFieldException("That name is in use");
            }
        }
    }

    private PanelTemplate newPanelTemplate(String name, String descr, int projID, PanelProperties p, boolean visible) throws SQLException {
        int ID = this.sbdb.nextControl("CHTPANL", "PANEL_ID");
        PanelTemplate template = new PanelTemplate(p.getPanelType(), ID, visible, name, descr, false, p, projID, null, 0);
        template.store(this.sbdb);
        this.sbdb.commit();
        this.putPanelTemplate(template);
        for (ChartContainer c : this.chartContainers.keySet()) {
            c.templateAdded(template);
        }
        return template;
    }

    private PanelProperties copyPanelProperties(PanelProperties p) throws SQLException, SBException {
        HashMap<String, String> logDefs;
        PanelPropertiesBuilder builder = new PanelPropertiesBuilder(p.getPanelType(), p.getPropertiesString());
        builder.ageCurveID(p.getAgeCurveID());
        if (p.getAnalystList() != null) {
            for (Object o : p.getAnalystList()) {
                if (o instanceof String) {
                    builder.analyst(this.sbdb.getUser((String)o));
                    continue;
                }
                builder.analyst((Userdef)o);
            }
        }
        builder.cmpStdID(p.getCmpStdID());
        builder.envSchID(p.getEnvSchID());
        builder.grpSetID(p.getGrpSetID());
        builder.schID(p.getIGDSchemeID());
        builder.synSchID(p.getSynSchID());
        if (p.getBlockMbrTemplateID() > 0) {
            builder.mbrBlock((ChartBlock)ChartFactory.createBlock(this.sbdb, this.getBlockTemplate(p.getBlockMbrTemplateID())));
        }
        if ((logDefs = p.getLogDefs()) != null) {
            for (Map.Entry<String, String> e : logDefs.entrySet()) {
                builder.logDef(e.getKey(), e.getValue());
            }
        }
        if (PanelType.isTaxonPanel(p.getPanelType())) {
            for (PanelTaxonOcc occ : ((PanelTaxonGroupProperties)p).getInnerPanels()) {
                PanelTaxonOcc copiedOcc = new PanelTaxonOcc(occ.getType(), occ.getProperties().createCopy(), occ.isDefault(), occ.isOverplot());
                copiedOcc.setCaption(occ.getCaption());
                copiedOcc.setFilter(occ.getFilterObj() != null ? PanelTaxonOcc.Filter.createCopy(occ.getFilterObj()) : null);
                builder.innerPanel(copiedOcc);
            }
        }
        builder.shapeStoreID(p.getShapeStoreID());
        return builder.build(this.sbdb, this.shapeStoreService);
    }

    private PanelProperties getDefaultPanelProperties(PanelType type) throws SQLException, SBException {
        for (PanelTemplate t : this.getPanels(type)) {
            if (!t.isDefaultTemplate()) continue;
            return t.getProperties();
        }
        return null;
    }

    public PanelTemplate getDefaultPanelTemplate(PanelType type) throws SQLException, SBException, SBPermissionException {
        PanelTemplate t;
        int panelID = this.getDefaultPanelID(type);
        if (panelID > 0 && (t = this.getPanelTemplate(panelID)) != null) {
            return t;
        }
        System.out.println("Creating missing default template for: " + String.valueOf(type));
        PanelTemplate templ = this.addPanelTemplate(type, type.toString(), null, 0, new PanelPropertiesBuilder(type, null).build(this.sbdb, this.shapeStoreService), null, true);
        templ.updateDescr(this.sbdb, true);
        return templ;
    }

    private int getDefaultPanelID(PanelType type) throws SQLException {
        assert (type instanceof PanelType);
        int defaultID = 0;
        String sql = "SELECT panel_id from " + this.sbdb.DBTableName("CHTPANL") + " WHERE type=" + SB.DBString((String)type.name()) + " AND isdefault='Y'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                defaultID = rs.getInt("panel_id");
            }
        }
        return defaultID;
    }

    public boolean isUniquelyDefaultPanelTemplate(int panelID) throws SQLException, SBException {
        PanelTemplate p = this.panelsByID.get(panelID);
        if (!p.isDefaultTemplate()) {
            throw new IllegalArgumentException("Panel '" + String.valueOf(p) + "' is not the default!");
        }
        for (PanelTemplate t : this.getPanels(p.getType())) {
            if (!t.isDefaultTemplate() || t == p) continue;
            return false;
        }
        return true;
    }

    public PanelTemplate setDefaultPanelTemplate(PanelTemplate template) throws SQLException, SBException, SBPermissionException {
        if (template.isDefaultTemplate()) {
            return null;
        }
        PanelTemplate existingDefault = this.getDefaultPanelTemplate(template.getType());
        if (existingDefault == template) {
            return null;
        }
        try {
            if (existingDefault != null) {
                existingDefault.updateDescr(this.sbdb, false);
            }
            template.updateDescr(this.sbdb, true);
            this.sbdb.commit();
        }
        finally {
            this.sbdb.doRollback();
        }
        if (existingDefault != null) {
            existingDefault.setDefaultTemplate(false);
        }
        template.setDefaultTemplate(true);
        for (PanelIsDefaultListener l : this.panelDefaultListeners.keySet()) {
            l.defaultTemplateChanged(template);
        }
        return existingDefault;
    }

    public void addPanelDefaultListener(PanelIsDefaultListener l) {
        this.panelDefaultListeners.put(l, object);
    }

    static String getIDString(int ID) {
        if (ID > 0) {
            return "" + ID;
        }
        return "NULL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrelationTemplate getCorrTemplate(int templID) throws SQLException {
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            if (this.corrTemplates.get(templID) == null) {
                this.loadCorrTemplate(templID);
            }
            return this.corrTemplates.get(templID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCorrTemplate(CorrelationTemplate templ) {
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            if (this.corrTemplates.put(templ.getID(), templ) != null) {
                throw new IllegalStateException("Corrupt correlation scheme mapping");
            }
        }
        if (this.corrByType.get(templ.getType()) != null) {
            this.corrByType.get(templ.getType()).add(templ);
            Collections.sort(this.corrByType.get(templ.getType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBlockTemplate(BlockTemplate templ) {
        if (templ.getID() == 0) {
            throw new IllegalArgumentException("Attempt to put template with ID 0: " + templ.getName());
        }
        if (templ.getParentID() != null) {
            return;
        }
        HashMap<Integer, BlockTemplate> hashMap = this.blocksByID;
        synchronized (hashMap) {
            if (this.blocksByID.put(templ.getID(), templ) != null) {
                throw new IllegalStateException("Corrupt block template mapping");
            }
        }
        if (this.blocksByType.get(templ.getType()) != null) {
            this.blocksByType.get(templ.getType()).add(templ);
            Collections.sort(this.blocksByType.get(templ.getType()));
        }
        if (this.blockInfoList != null) {
            this.blockInfoList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPanelTemplate(PanelTemplate templ) {
        if (templ.getID() == 0) {
            throw new IllegalArgumentException("Attempt to put panel template with ID 0: " + templ.getName());
        }
        HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
        synchronized (hashMap) {
            if (this.panelsByID.put(templ.getID(), templ) != null) {
                throw new IllegalStateException("Corrupt panel template mapping");
            }
        }
        if (templ.isVisible() && this.panelsByType.get(templ.getType()) != null) {
            this.panelsByType.get(templ.getType()).add(templ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChartTemplate(ChartTemplate templ) {
        if (templ.getID() == 0) {
            throw new IllegalArgumentException("Attempt to put template with ID 0: " + templ.getName());
        }
        HashMap<Integer, ChartTemplate> hashMap = this.charts;
        synchronized (hashMap) {
            if (this.charts.put(templ.getID(), templ) != null) {
                throw new IllegalStateException("Corrupt chart template mapping");
            }
        }
    }

    public CorrelationTemplate addCorrTemplate(CorrelationType type, String descr, String comments, int projID) throws SQLException, InvalidFieldException {
        CorrelationTemplate cTempl = CorrelationTemplate.newStoredInstance(this.sbdb, type, descr, comments, projID);
        this.sbdb.commit();
        this.putCorrTemplate(cTempl);
        return cTempl;
    }

    public void addBlockTemplate(BlockTemplate template) throws SQLException, InvalidFieldException, SBException {
        if (template.getID() != 0) {
            throw new IllegalArgumentException("Attempt to add stored block template");
        }
        template.store(this.sbdb);
        this.putBlockTemplate(template);
    }

    public void addChartTemplate(ChartTemplate template) throws SQLException, InvalidFieldException, SBException {
        if (template.getID() != 0) {
            throw new IllegalArgumentException("Attempt to add stored chart template");
        }
        template.store(this.sbdb);
        this.putChartTemplate(template);
    }

    public void updateChartTemplate(Chart chart) throws SQLException, SBException, IOException, SBPermissionException {
        block5: for (ChartTemplate.BlockOcc bOcc : chart.getTemplate().getBlocks()) {
            if (bOcc.getWellID() != 0 || this.getBlockTemplate(bOcc.getBlockID()).getType() != BlockType.WELL) continue;
            for (ChartBlockBase b : chart.getBlocks()) {
                if (!(b instanceof WellBlock) || b.getTemplate().getID() != bOcc.getBlockID() || b.getWell() != null) continue;
                break block5;
            }
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.templateWellBlockRemovedFromChart(chart.getTemplate().getID());
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_CHT") + " WHERE chart_id=" + chart.getTemplate().getID();
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
        for (ChartBlockBase b : chart.getBlocks()) {
            ChartBlock block;
            if (!(b instanceof ChartBlock) || !(block = (ChartBlock)b).hasLocalChanges()) continue;
            if (block.getTemplate().getParentID() != null) {
                this.updateBlockTemplate(block);
                continue;
            }
            TemplateFactory.createChildTemplate(block, this, block.getWellID());
        }
        chart.updateTemplate(this.sbdb);
    }

    public void updateBlockTemplate(ChartBlock block) throws SQLException, SBException, SBPermissionException {
        BlockTemplate blockTemplate = block.getTemplate();
        if (blockTemplate.getParentID() == null) {
            for (SBPanel panel : block.getPanels()) {
                PanelTemplate t = panel.getTemplate();
                if (panel.getProperties().equals(t.getProperties())) continue;
                if (!t.isVisible()) {
                    t.setEditableProp(panel.getProperties());
                    t.update(this.sbdb);
                    continue;
                }
                String descr = "Local to block template [" + blockTemplate.getName() + "]";
                PanelTemplate newChildPanelTemplate = this.addPanelTemplate(panel.getPanelType(), null, descr, blockTemplate.getProjID(), panel.getProperties(), null, false);
                block.replacePanel(panel, newChildPanelTemplate);
            }
        } else {
            BlockTemplateChild childTemplate = (BlockTemplateChild)blockTemplate;
            BlockTemplate parentBlockTemplate = childTemplate.getBlockTemplate(childTemplate.getParentID());
            List<SBPanel> panels = block.getPanels();
            List<PanelOcc> parentTemplatePanelOccs = parentBlockTemplate.getPanels();
            for (int i = 0; i < panels.size(); ++i) {
                SBPanel panel = panels.get(i);
                PanelTemplate t = block.getTemplate().getPanelTemplate(panel.getTemplateID());
                if (panel.getProperties().equals(t.getProperties())) continue;
                if (parentTemplatePanelOccs.get(i).getPanelID() == t.getID()) {
                    String descr = "Local to " + childTemplate.getType().getShortDescr() + " block template [" + childTemplate.getName() + "]";
                    PanelTemplate newChildPanelTemplate = this.addPanelTemplate(panel.getPanelType(), null, descr, childTemplate.getProjID(), panel.getProperties(), null, false);
                    block.replacePanel(panel, newChildPanelTemplate);
                    continue;
                }
                t.setEditableProp(panel.getProperties());
                t.update(this.sbdb);
            }
        }
        block.updateTemplate(this.sbdb, false);
        this.sbdb.commit();
        block.getTemplate().notifyObservers();
        block.notifyListeners();
    }

    public ChartTemplateBase copyTemplate(ChartTemplateBase templ, String newName, String newComments, int projID) throws SQLException, InvalidFieldException, SBException {
        ChartTemplateBase copy;
        if (templ.getProjID() != projID) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                templ.checkProjectChange(this.sbdb, stmt, projID, true);
            }
        }
        if ((copy = templ.copy(this, newName, newComments, projID)) instanceof BlockTemplate) {
            this.addBlockTemplate((BlockTemplate)copy);
        } else {
            this.addChartTemplate((ChartTemplate)copy);
        }
        return copy;
    }

    public static CorrelationStandard getCorrStd(CorrelationType type, CorrelationScope scope) {
        for (CorrelationStandard std : corrStds.get(type)) {
            if (std.scope != scope) continue;
            return std;
        }
        return null;
    }

    public int getnElements(String tableName, String idField, int projID) throws SQLException {
        String sql = "SELECT count(" + idField + ") AS n FROM " + this.sbdb.DBTableName(tableName) + " WHERE proj_id" + (String)(projID > 0 ? "=" + projID : " IS NULL");
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                int n = rs.getInt("n");
                return n;
            }
        }
        return 0;
    }

    public void checkProjectDelete(int projID) throws SQLException, InvalidFieldException {
        String sql = "SELECT count(*) AS n FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE wellist_id IN(SELECT WELLIST_ID FROM " + this.sbdb.DBTableName("WELLIST") + " WHERE proj_id=" + projID + ")";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int n;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && (n = rs.getInt("n")) == 0) {
                return;
            }
            sql = "SELECT c.descr as descr FROM " + this.sbdb.DBTableName("CHART") + " c, " + this.sbdb.DBTableName("CHTMBR") + " m, " + this.sbdb.DBTableName("WELLIST") + " w WHERE c.chart_id=m.chart_id AND m.wellist_id=w.wellist_id AND w.proj_id=" + projID;
            Object msg = "Project's well lists are linked to blocks in these charts:";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                msg = (String)msg + "\n" + rs.getString("descr");
            }
            throw new InvalidFieldException((String)msg);
        }
    }

    public void checkWellListDelete(int wellListID) throws SQLException, InvalidFieldException {
        String sql = "SELECT count(*) AS n FROM " + this.sbdb.DBTableName("CHART") + " WHERE wellist_id=" + wellListID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int n;
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next() && (n = rs.getInt("n")) == 0) {
                return;
            }
            sql = "SELECT descr FROM " + this.sbdb.DBTableName("CHART") + " WHERE wellist_id=" + wellListID;
            Object msg = "Well list is linked to these charts:";
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                msg = (String)msg + "\n" + rs.getString("descr");
            }
            throw new InvalidFieldException((String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point isChartOpen(ChartTemplateBase templ) throws SQLException {
        String wellsql;
        Object usersql;
        block15: {
            block16: {
                block14: {
                    usersql = "SELECT COUNT(user_id) as nusers from ";
                    wellsql = null;
                    if (!(templ instanceof ChartTemplate)) break block14;
                    usersql = (String)usersql + this.sbdb.DBTableName("CHTPREF_CHT") + " WHERE chart_id=";
                    wellsql = this.sbdb.DBTableName("CHTPREF_CHT") + " WHERE chart_id=";
                    break block15;
                }
                if (!(templ instanceof BlockTemplate)) break block16;
                switch (((BlockTemplate)templ).getType()) {
                    case WELL: {
                        usersql = (String)usersql + this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE block_id=";
                        wellsql = this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE block_id=";
                        break block15;
                    }
                    case SCHEME: {
                        usersql = (String)usersql + this.sbdb.DBTableName("CHTPREF_SCH") + " WHERE block_id=";
                        break block15;
                    }
                    case PROJECT: 
                    case MAP: {
                        return null;
                    }
                    default: {
                        assert (false);
                        return null;
                    }
                }
            }
            assert (false);
            return null;
        }
        usersql = (String)usersql + templ.getID();
        if (wellsql != null) {
            wellsql = "SELECT COUNT(well_id) as nwells from " + wellsql + templ.getID();
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        int nUsers = 0;
        int nWells = 0;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)usersql));
            if (rs.next()) {
                nUsers = rs.getInt("nusers");
            }
            if (wellsql != null && (rs = stmt.executeQuery(this.sbdb.modQuery(wellsql))).next()) {
                nWells = rs.getInt("nwells");
            }
        }
        finally {
            stmt.close();
        }
        return new Point(nUsers, nWells);
    }

    public void addChartListener(ChartContainer listener) {
        this.chartContainers.put(listener, object);
    }

    public boolean getProjectReadOnlyElements(int projID, List<String> elements, Boolean deletePanels, Boolean deleteBlocks, Boolean deleteCharts, Boolean deleteCorr) throws SQLException {
        assert (projID > 0);
        int currentUserID = this.sbdb.getUserID();
        if (Userdef.isSuperUser((int)this.sbdb.getUser().getPriv())) {
            return false;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            if (deleteCharts != null && deleteCharts.booleanValue()) {
                this.addElements(stmt, currentUserID, elements, "CHART", "SELECT a.user_id, c.chart_id AS element_id, c.descr FROM " + this.sbdb.DBTableName("CHART_ACL") + " a," + this.sbdb.DBTableName("CHART") + " c WHERE c.acm > 0 AND a.chart_id=c.chart_id AND c.proj_id=" + projID + " ORDER BY descr, user_id");
            }
            if (deletePanels != null && deletePanels.booleanValue()) {
                this.addElements(stmt, currentUserID, elements, "PANEL TEMPLATE", "SELECT a.user_id, p.panel_id AS element_id, p.descr FROM " + this.sbdb.DBTableName("CHTPANL_ACL") + " a," + this.sbdb.DBTableName("CHTPANL") + " p WHERE p.acm > 0 AND a.panel_id=p.panel_id AND p.proj_id=" + projID + " ORDER BY descr, user_id");
            }
            if (deleteBlocks != null && deleteBlocks.booleanValue()) {
                this.addElements(stmt, currentUserID, elements, "BLOCK TEMPLATE", "SELECT a.user_id, b.block_id AS element_id, b.descr FROM " + this.sbdb.DBTableName("CHTBLOCK_ACL") + " a," + this.sbdb.DBTableName("CHTBLOCK") + " b WHERE b.acm > 0 AND a.block_id=b.block_id AND b.proj_id=" + projID + " ORDER BY descr, user_id");
            }
            if (deleteCorr != null && deleteCorr.booleanValue()) {
                this.addElements(stmt, currentUserID, elements, "CORRELATION TEMPLATE", "SELECT a.user_id, c.corrsch_id AS element_id, c.descr FROM " + this.sbdb.DBTableName("CHARTCORR_ACL") + " a," + this.sbdb.DBTableName("CHARTCORR") + " c WHERE c.acm > 0 AND a.corrsch_id=c.corrsch_id AND c.proj_id=" + projID + " ORDER BY descr, user_id");
            }
        }
        return !elements.isEmpty();
    }

    private void addElements(Statement stmt, int currentUserID, List<String> elements, String type, String sql) throws SQLException {
        HashSet<Integer> hasAccess = new HashSet<Integer>();
        HashMap<Integer, CallSite> potentialElements = new HashMap<Integer, CallSite>();
        try (ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                int userID = rs.getInt("user_id");
                int elementId = rs.getInt("element_id");
                String descr = rs.getString("descr");
                if (userID == currentUserID) {
                    hasAccess.add(elementId);
                    continue;
                }
                String userName = this.sbdb.getUser(userID).getName();
                if (potentialElements.get(elementId) == null) {
                    potentialElements.put(elementId, (CallSite)((Object)(type + ": " + descr + " Keyholder: " + userName)));
                    continue;
                }
                potentialElements.put(elementId, (CallSite)((Object)((String)potentialElements.get(elementId) + ", " + userName)));
            }
        }
        Iterator it = hasAccess.iterator();
        while (it.hasNext()) {
            int chartID = (Integer)it.next();
            potentialElements.remove(chartID);
        }
        Iterator it2 = potentialElements.keySet().iterator();
        while (it2.hasNext()) {
            elements.add((String)potentialElements.get(it2.next()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProjectDB(int projID, Boolean deletePanels, Boolean deleteBlocks, Boolean deleteCharts, Boolean deleteCorr) throws SQLException, InvalidFieldException {
        String query;
        assert (projID > 0);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        ArrayList<CallSite> sql = new ArrayList<CallSite>();
        if (deleteCharts != null && deleteCharts.booleanValue()) {
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTMBR") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTCORROCC_STD") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTCORROCC_STD_UNIT") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTCORROCC") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPREF_CHT") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHART_ACL") + " WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID)));
        }
        if (deleteCorr != null && deleteCorr.booleanValue()) {
            ResultSet resultSet;
            if (deleteCharts != null && !deleteCharts.booleanValue() && (resultSet = stmt.executeQuery(this.sbdb.modQuery(query = "SELECT COUNT(b.block_id) as count FROM " + this.sbdb.DBTableName("CHARTCORR") + " b, " + this.sbdb.DBTableName("CHTCORROCC") + " m WHERE b.corrsch_id=m.corrsch_id AND b.proj_id=" + projID))).next() && resultSet.getInt("count") > 0) {
                throw new InvalidFieldException("Can't delete correlations which occur in charts");
            }
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTLN_SURFACE") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTLN_UNIT") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTLN_UNIT_LSTRAT") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTCORROCC") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHARTCORR_ACL") + " WHERE corrsch_id IN(SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHARTCORR") + " WHERE proj_id=" + projID)));
        }
        if (deleteBlocks != null && deleteBlocks.booleanValue()) {
            ResultSet resultSet;
            if (deleteCharts != null && !deleteCharts.booleanValue() && (resultSet = stmt.executeQuery(this.sbdb.modQuery(query = "SELECT COUNT(b.block_id) as count FROM " + this.sbdb.DBTableName("CHTBLOCK") + " b, " + this.sbdb.DBTableName("CHTMBR") + " m WHERE b.block_id=m.block_id AND b.proj_id=" + projID))).next() && resultSet.getInt("count") > 0) {
                throw new InvalidFieldException("Can't delete blocks which occur in charts");
            }
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTBLOCKMBR") + " WHERE block_id IN(SELECT block_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE block_id IN(SELECT block_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTBLOCK_ACL") + " WHERE block_id IN(SELECT block_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID)));
        }
        if (deletePanels != null && deletePanels.booleanValue()) {
            ResultSet resultSet;
            if (deleteBlocks != null && !deleteBlocks.booleanValue() && (resultSet = stmt.executeQuery(this.sbdb.modQuery(query = "SELECT COUNT(panel_id) as count FROM " + this.sbdb.DBTableName("CHTPANL") + " p," + this.sbdb.DBTableName("CHTBLOCKMBR") + " m WHERE m.panel_id=p.ID AND p.proj_id=" + projID))).next() && resultSet.getInt("count") > 0) {
                throw new InvalidFieldException("Can't delete panels which occur in blocks");
            }
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE panel_id IN(SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPANL_BLKMBR") + " WHERE panel_id IN(SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPANL_ACL") + " WHERE panel_id IN(SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE proj_id=" + projID + ")")));
            sql.add((CallSite)((Object)("DELETE FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE proj_id=" + projID)));
        }
        if (deletePanels != null && !deletePanels.booleanValue()) {
            sql.add((CallSite)((Object)("UPDATE " + this.sbdb.DBTableName("CHTPANL") + " SET proj_id=NULL WHERE panel_id IN(SELECT panel_id FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE proj_id=" + projID + ")")));
        }
        if (deleteBlocks != null && !deleteBlocks.booleanValue()) {
            sql.add((CallSite)((Object)("UPDATE " + this.sbdb.DBTableName("CHTBLOCK") + " SET proj_id=NULL WHERE block_id IN(SELECT block_id FROM " + this.sbdb.DBTableName("CHTBLOCK") + " WHERE proj_id=" + projID + ")")));
        }
        if (deleteCorr != null && !deleteCorr.booleanValue()) {
            sql.add((CallSite)((Object)("UPDATE " + this.sbdb.DBTableName("CHARTCORR") + " SET proj_id=NULL WHERE proj_id=" + projID)));
        }
        if (deleteCharts != null && !deleteCharts.booleanValue()) {
            sql.add((CallSite)((Object)("UPDATE " + this.sbdb.DBTableName("CHART") + " SET proj_id=NULL WHERE chart_id IN(SELECT chart_id FROM " + this.sbdb.DBTableName("CHART") + " WHERE proj_id=" + projID + ")")));
        }
        try {
            for (String string : sql) {
                stmt.executeUpdate(this.sbdb.modQuery(string));
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProjectModel(int projID, Boolean deletePanels, Boolean deleteBlocks, Boolean deleteCharts, Boolean deleteCorr) {
        HashMap<Integer, SBRestrictable> hashMap;
        assert (projID > 0);
        this.blockInfoList = null;
        if (deletePanels != null) {
            LinkedList<PanelTemplate> panelsToRemove = null;
            hashMap = this.panelsByID;
            synchronized (hashMap) {
                for (PanelTemplate pTempl : this.panelsByID.values()) {
                    if (pTempl.getProjID() != projID) continue;
                    if (deletePanels.booleanValue()) {
                        if (panelsToRemove == null) {
                            panelsToRemove = new LinkedList<PanelTemplate>();
                        }
                        panelsToRemove.add(pTempl);
                        continue;
                    }
                    pTempl.setGlobal();
                }
                if (panelsToRemove != null) {
                    for (PanelTemplate pTempl : panelsToRemove) {
                        this.panelsByID.remove(pTempl.getID());
                        if (this.panelsByType.get(pTempl.getType()) == null) continue;
                        this.panelsByType.get(pTempl.getType()).remove(pTempl);
                    }
                }
            }
        }
        if (deleteBlocks != null) {
            LinkedList<BlockTemplate> blocksToRemove = null;
            hashMap = this.blocksByID;
            synchronized (hashMap) {
                for (BlockTemplate bTempl : this.blocksByID.values()) {
                    if (bTempl.getProjID() != projID) continue;
                    if (deleteBlocks.booleanValue()) {
                        if (blocksToRemove == null) {
                            blocksToRemove = new LinkedList<BlockTemplate>();
                        }
                        blocksToRemove.add(bTempl);
                        continue;
                    }
                    bTempl.setGlobal();
                }
                if (blocksToRemove != null) {
                    for (BlockTemplate bTempl : blocksToRemove) {
                        for (ChartContainer l : this.chartContainers.keySet()) {
                            l.blockWillBeDeleted(bTempl.getID(), false);
                        }
                        this.blocksByID.remove(bTempl.getID());
                        if (this.blocksByType.get(bTempl.getType()) == null) continue;
                        this.blocksByType.get(bTempl.getType()).remove(bTempl);
                    }
                }
            }
        }
        if (deleteCorr != null) {
            LinkedList<CorrelationTemplate> corrToRemove = null;
            hashMap = this.corrTemplates;
            synchronized (hashMap) {
                for (CorrelationTemplate corrTempl : this.corrTemplates.values()) {
                    if (corrTempl.getProjID() != projID) continue;
                    if (deleteCorr.booleanValue()) {
                        if (corrToRemove == null) {
                            corrToRemove = new LinkedList<CorrelationTemplate>();
                        }
                        corrToRemove.add(corrTempl);
                        continue;
                    }
                    corrTempl.setGlobal();
                }
                if (corrToRemove != null) {
                    for (CorrelationTemplate corrTempl : corrToRemove) {
                        this.corrTemplates.remove(corrTempl.getID());
                        if (this.corrByType.get(corrTempl.getType()) == null) continue;
                        this.corrByType.get(corrTempl.getType()).remove(corrTempl);
                    }
                }
            }
        }
        if (deleteCharts != null) {
            LinkedList<ChartTemplate> chartsToRemove = null;
            hashMap = this.charts;
            synchronized (hashMap) {
                for (ChartTemplate cTempl : this.charts.values()) {
                    if (cTempl.getProjID() != projID) continue;
                    if (deleteCharts.booleanValue()) {
                        if (chartsToRemove == null) {
                            chartsToRemove = new LinkedList<ChartTemplate>();
                        }
                        chartsToRemove.add(cTempl);
                        continue;
                    }
                    cTempl.setGlobal();
                }
                if (chartsToRemove != null) {
                    for (ChartTemplate cTempl : chartsToRemove) {
                        for (ChartContainer l : this.chartContainers.keySet()) {
                            l.chartWillBeDeleted(cTempl.getID());
                        }
                        this.charts.remove(cTempl.getID());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartTemplateBase[] getRecentTemplates(int nTemplates) throws SQLException {
        String[] tables = new String[]{"CHART", "CHTBLOCK"};
        String[] idFields = new String[]{"chart_id", "block_id"};
        LinkedList<ChartTemplateBase> templates = new LinkedList<ChartTemplateBase>();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Statement chtstmt = this.sbdb.getDatabase().createStatement();
        int n = nTemplates;
        try {
            for (int j = 0; j < tables.length; ++j) {
                String sql = "SELECT " + idFields[j] + ",updated FROM " + this.sbdb.DBTableName(tables[j]) + " WHERE updated IS NOT NULL AND updater=" + this.sbdb.getUser().getUserID() + (j == 1 ? " AND parent_id IS NULL" : "") + " ORDER BY updated DESC";
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                for (int i = 0; rs.next() && i < n; ++i) {
                    if (j == 0) {
                        ChartTemplate chartTemplate = this.getChartTemplate(rs.getInt(idFields[j]));
                        chartTemplate.loadMbrs(this.sbdb, chtstmt);
                        templates.add(chartTemplate);
                        continue;
                    }
                    if (j != 1) continue;
                    templates.add(this.getBlockTemplate(rs.getInt(idFields[j])));
                }
            }
        }
        finally {
            stmt.close();
            chtstmt.close();
        }
        Collections.sort(templates, new ChartTemplateBase.AuditComparator());
        ChartTemplateBase[] arr = new ChartTemplateBase[n];
        for (int i = 0; i < n && i < templates.size(); ++i) {
            arr[i] = (ChartTemplateBase)templates.get(i);
        }
        return arr;
    }

    public String getCanWrite(ChartTemplateBase templ) throws SQLException {
        Object unlockedObjects = "";
        if (templ instanceof ChartTemplate) {
            ChartTemplate t = (ChartTemplate)templ;
            for (ChartTemplate.BlockOcc block : t.getBlocks()) {
                BlockTemplate blockTemplate = this.getBlockTemplate(block.getBlockID());
                if (!blockTemplate.canWrite(this.sbdb, null)) continue;
                unlockedObjects = (String)unlockedObjects + blockTemplate.getName();
                unlockedObjects = (String)unlockedObjects + ", ";
            }
            for (CorrTemplateOcc occ : t.getCorrOccs()) {
                CorrelationTemplate corrTemplate = this.getCorrTemplate(occ.getCorrschID());
                if (!corrTemplate.canWrite(this.sbdb, null)) continue;
                unlockedObjects = (String)unlockedObjects + corrTemplate.getName();
                unlockedObjects = (String)unlockedObjects + ", ";
            }
        }
        if (!((String)unlockedObjects).isEmpty()) {
            unlockedObjects = ((String)unlockedObjects).substring(0, ((String)unlockedObjects).length() - 2);
        }
        return unlockedObjects;
    }

    public List<LegacyChart> searchLegacyCharts(String chart_name, String well_name, LegacyChartType type) throws SQLException, SBException {
        return this.legacyChartCache.searchLegacyCharts(this.sbdb, chart_name, well_name, type);
    }

    public Object convertLegacyChart(LegacyChart legChart, LegacyChartPanelOption panelOption, int destinationProjectID) throws SQLException, SBException, SBPermissionException, InvalidFieldException {
        LegacyChartConverter converter = new LegacyChartConverter(this.sbdb, this, legChart, panelOption, destinationProjectID);
        return converter.convertLegacyChart();
    }

    public void refresh() throws SQLException, SBException, IOException {
        try (Connection conn = this.sbdb.getNewConnection();){
            this.refreshPanels(conn);
            this.refreshBlocks(conn);
            this.refreshCorrelations(conn);
            this.refreshCharts(conn);
            conn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPanels(Connection conn) throws SQLException, SBException {
        if (this.panelsByID.isEmpty()) {
            return;
        }
        LinkedList<PanelTemplate> templatesToBeUpdated = new LinkedList<PanelTemplate>();
        HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
        synchronized (hashMap) {
            HashSet<Integer> keys = new HashSet<Integer>();
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT panel_id,type,isdefault,isvisible,updated FROM " + this.sbdb.DBTableName("CHTPANL");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    boolean isNowDefault;
                    int key = rs.getInt("panel_id");
                    keys.add(key);
                    PanelType panelType = PanelType.valueOf(rs.getString("type").trim());
                    boolean bl = isNowDefault = rs.getString("isdefault").charAt(0) == 'Y';
                    if (!isNowDefault || !this.getPanelTemplate(key).isDefaultTemplate()) {
                        // empty if block
                    }
                    boolean isVisible = rs.getString("isvisible").charAt(0) == 'Y';
                    Timestamp time = rs.getTimestamp("updated");
                    PanelTemplate panelForKey = this.panelsByID.get(key);
                    if (panelForKey != null) {
                        if ((time == null || !time.after(panelForKey.getUpdated())) && isNowDefault == panelForKey.isDefaultTemplate()) continue;
                        if (isNowDefault && !panelForKey.isDefaultTemplate()) {
                            for (PanelIsDefaultListener l : this.panelDefaultListeners.keySet()) {
                                l.defaultTemplateChanged(panelForKey);
                            }
                        }
                        templatesToBeUpdated.add(panelForKey);
                        continue;
                    }
                    if (this.panelsByType.get(panelType) == null || !isVisible) continue;
                    this.loadPanelTemplate(key);
                    for (ChartContainer c : this.chartContainers.keySet()) {
                        c.templateAdded(this.panelsByID.get(key));
                    }
                }
            }
            HashSet<Integer> deletedIDs = new HashSet<Integer>(this.panelsByID.keySet());
            deletedIDs.removeAll(keys);
            for (Integer panelID : deletedIDs) {
                for (ChartContainer c : this.chartContainers.keySet()) {
                    c.panelTemplateWillBeDeleted(panelID);
                }
                PanelTemplate deleted = this.panelsByID.get(panelID);
                this.panelsByID.remove(panelID);
                if (this.panelsByType.get(deleted.getType()) == null) continue;
                this.panelsByType.get(deleted.getType()).remove(deleted);
            }
        }
        for (PanelTemplate panelTemplate : templatesToBeUpdated) {
            this.refreshPanelTemplate(conn, panelTemplate);
            if (this.panelsByID.get(panelTemplate.getID()) != panelTemplate && (panelTemplate = this.panelsByID.get(panelTemplate.getID())) == null) continue;
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.templateDescrUpdated(panelTemplate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPanelTemplate(Connection conn, PanelTemplate panel) throws SQLException, SBException {
        block11: {
            int panelID = panel.getID();
            System.out.println("Refreshing panel: " + String.valueOf(panel));
            String sql = "SELECT panel_id,type,isvisible,descr,comments,isdefault,prop,sch_id,std_id,envsch_id,synsch_id,grpset_id,proj_id,agecurve_id,shape_id," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHTPANL") + " WHERE panel_id=" + panelID;
            try (Statement stmt = conn.createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (!rs.next()) break block11;
                PanelTemplate temp = this.createPanelTemplateFromResultSet(panelID, rs);
                try {
                    panel.refresh(temp);
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                    HashMap<Integer, PanelTemplate> hashMap = this.panelsByID;
                    synchronized (hashMap) {
                        this.panelsByID.remove(panel.getID());
                        this.panelsByID.put(panelID, temp);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBlocks(Connection conn) throws SQLException, SBException {
        this.blockInfoList = null;
        if (this.blocksByID.isEmpty()) {
            return;
        }
        LinkedList<BlockTemplate> blockTemplatesToBeUpdated = new LinkedList<BlockTemplate>();
        HashMap<Integer, BlockTemplate> hashMap = this.blocksByID;
        synchronized (hashMap) {
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT block_id,type,updated,parent_id,well_id FROM " + this.sbdb.DBTableName("CHTBLOCK");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                HashSet<Integer> keys = new HashSet<Integer>();
                HashSet<Integer> childKeys = new HashSet<Integer>();
                while (rs.next()) {
                    int key = rs.getInt("block_id");
                    BlockType blockType = BlockType.valueOf(rs.getString("type"));
                    Timestamp time = rs.getTimestamp("updated");
                    int parentID = rs.getInt("parent_id");
                    int wellID = rs.getInt("well_id");
                    if (parentID == 0) {
                        keys.add(key);
                    } else {
                        childKeys.add(key);
                    }
                    BlockTemplate blockTemplateForKey = this.blocksByID.get(key);
                    if (blockTemplateForKey == null && parentID > 0 && this.blocksByID.get(parentID) != null) {
                        BlockTemplate parent = this.blocksByID.get(parentID);
                        blockTemplateForKey = ((BlockTemplateParent)parent).getChild(wellID);
                    }
                    if (blockTemplateForKey != null) {
                        if (time == null || !time.after(blockTemplateForKey.getUpdated())) continue;
                        blockTemplatesToBeUpdated.add(blockTemplateForKey);
                        continue;
                    }
                    BlockTemplate newTemplate = null;
                    if (parentID == 0) {
                        if (this.blocksByType.get(blockType) != null && parentID == 0) {
                            this.loadBlockTemplate(key);
                            newTemplate = this.blocksByID.get(key);
                        }
                    } else {
                        BlockTemplateParent parent = (BlockTemplateParent)this.blocksByID.get(parentID);
                        if (parent == null) {
                            this.loadBlockTemplate(parentID);
                            parent = (BlockTemplateParent)this.blocksByID.get(parentID);
                        }
                        if ((newTemplate = parent.getChild(true, key)) == null) {
                            String childSelectString = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE block_id=" + key;
                            try (Statement innerStmt = this.sbdb.getDatabase().createStatement();){
                                ResultSet childRs = innerStmt.executeQuery(this.sbdb.modQuery(childSelectString));
                                if (childRs.next()) {
                                    BlockTemplateChild child = (BlockTemplateChild)this.getBlockTemplateFromResultSet(childRs);
                                    child.loadPanels(this.sbdb, innerStmt);
                                    parent.addChild(child);
                                    newTemplate = child;
                                }
                            }
                        }
                    }
                    if (newTemplate == null) continue;
                    for (ChartContainer c : this.chartContainers.keySet()) {
                        c.templateAdded(newTemplate);
                    }
                }
                HashSet<Integer> deletedIDs = new HashSet<Integer>(this.blocksByID.keySet());
                deletedIDs.removeAll(keys);
                for (Integer blockID : deletedIDs) {
                    BlockTemplate deleted = this.blocksByID.get(blockID);
                    for (ChartContainer c : this.chartContainers.keySet()) {
                        c.blockWillBeDeleted(blockID, true);
                    }
                    this.blocksByID.remove(blockID);
                    if (this.blocksByType.get(deleted.getType()) == null) continue;
                    this.blocksByType.get(deleted.getType()).remove(deleted);
                }
                if (!childKeys.isEmpty()) {
                    for (BlockTemplate blockTemplate : this.blocksByID.values()) {
                        BlockTemplateParent parent = (BlockTemplateParent)blockTemplate;
                        for (Integer wellID : parent.getChildWellIDs()) {
                            BlockTemplateChild child = parent.getChild(wellID);
                            if (childKeys.contains(child.getID())) continue;
                            parent.removeChild(wellID);
                            for (ChartContainer c : this.chartContainers.keySet()) {
                                c.blockWillBeDeleted(child.getID(), true);
                            }
                        }
                    }
                }
            }
        }
        for (BlockTemplate blockTemplate : blockTemplatesToBeUpdated) {
            this.refreshBlockTemplate(conn, blockTemplate);
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.templateDescrUpdated(blockTemplate);
            }
        }
    }

    private void refreshBlockTemplate(Connection conn, BlockTemplate block) throws SQLException {
        int blockID = block.getID();
        String sql = BlockTemplateLoadingHelper.getBlockSelectString((ConnectionProvider)this.sbdb) + " WHERE block_id=" + blockID;
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                BlockTemplate temp = BlockTemplateLoadingHelper.createBlockTemplateFromResultSet(this, rs);
                temp.loadPanels(this.sbdb, stmt);
                block.refresh(temp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCorrelations(Connection conn) throws SQLException {
        if (this.corrTemplates.isEmpty()) {
            return;
        }
        LinkedList<CorrelationTemplate> templatesToRefresh = new LinkedList<CorrelationTemplate>();
        HashMap<Integer, CorrelationTemplate> hashMap = this.corrTemplates;
        synchronized (hashMap) {
            HashSet<Integer> keys = new HashSet<Integer>();
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT corrsch_id,corr_type,updated FROM " + this.sbdb.DBTableName("CHARTCORR");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int key = rs.getInt("corrsch_id");
                    keys.add(key);
                    CorrelationType type = CorrelationType.valueOf(rs.getString("corr_type"));
                    Timestamp time = rs.getTimestamp("updated");
                    CorrelationTemplate corrTemplForKey = this.corrTemplates.get(key);
                    if (corrTemplForKey != null) {
                        if (time == null || !time.after(corrTemplForKey.getUpdated())) continue;
                        templatesToRefresh.add(corrTemplForKey);
                        continue;
                    }
                    if (this.corrByType.get(type) == null) continue;
                    this.loadCorrTemplate(key);
                    for (ChartContainer c : this.chartContainers.keySet()) {
                        c.templateAdded(this.corrTemplates.get(key));
                    }
                }
            }
            HashSet<Integer> deletedIDs = new HashSet<Integer>(this.corrTemplates.keySet());
            deletedIDs.removeAll(keys);
            for (Integer corrID : deletedIDs) {
                CorrelationTemplate deleted = this.corrTemplates.get(corrID);
                for (ChartContainer c : this.chartContainers.keySet()) {
                    c.corrTemplateWillBeDeleted(corrID);
                }
                this.corrTemplates.remove(corrID);
                if (this.corrByType.get(deleted.getType()) == null) continue;
                this.corrByType.get(deleted.getType()).remove(deleted);
            }
        }
        for (CorrelationTemplate key : templatesToRefresh) {
            this.refreshCorrTemplate(conn, key);
        }
    }

    private void refreshCorrTemplate(Connection conn, CorrelationTemplate template) throws SQLException {
        int corrID = template.getID();
        CorrelationTemplate updated = CorrelationTemplate.loadFromConnection(conn, this.sbdb, corrID);
        template.refresh(updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCharts(Connection conn) throws SQLException, SBException, IOException {
        if (this.charts.isEmpty()) {
            return;
        }
        LinkedList<ChartTemplate> chartTemplatesToRefresh = new LinkedList<ChartTemplate>();
        HashMap<Integer, ChartTemplate> hashMap = this.charts;
        synchronized (hashMap) {
            HashSet<Integer> keys = new HashSet<Integer>();
            try (Statement stmt = conn.createStatement();){
                String sql = "SELECT chart_id,updated FROM " + this.sbdb.DBTableName("CHART");
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int key = rs.getInt("chart_id");
                    keys.add(key);
                    Timestamp time = rs.getTimestamp("updated");
                    ChartTemplate chartForKey = this.charts.get(key);
                    if (chartForKey == null || time == null || !time.after(chartForKey.getUpdated())) continue;
                    chartTemplatesToRefresh.add(chartForKey);
                }
            }
            HashSet<Integer> deletedIDs = new HashSet<Integer>(this.charts.keySet());
            deletedIDs.removeAll(keys);
            for (Integer chartID : deletedIDs) {
                for (ChartContainer c : this.chartContainers.keySet()) {
                    c.chartWillBeDeleted(chartID);
                }
                this.charts.remove(chartID);
            }
        }
        for (ChartTemplate chartTemplate : chartTemplatesToRefresh) {
            this.refreshChart(conn, chartTemplate);
            for (ChartContainer c : this.chartContainers.keySet()) {
                c.templateDescrUpdated(chartTemplate);
            }
        }
    }

    private void refreshChart(Connection conn, ChartTemplate chart) throws SQLException, SBException, IOException {
        int chartID = chart.getID();
        String sql = "SELECT descr,comments,proj_id,wellist_id,props,sch_id,header,cht_key," + Audit.sqlFieldString() + ",acm FROM " + this.sbdb.DBTableName("CHART") + " WHERE chart_id=" + chartID;
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                ChartTemplate temp = this.createChartTemplateFromResultSet(chartID, rs);
                temp.loadMbrs(this.sbdb, stmt);
                chart.refresh(temp, this.sbdb);
            }
        }
    }

    public TaxonMerge mergeTaxa(Taxon donor, Taxon target, TaxonMerge taxonMerge) throws SQLException, SBException, SBPermissionException {
        ResultSet rs;
        String sql;
        Object stmt;
        if (taxonMerge == null) {
            taxonMerge = new TaxonMerge();
        }
        if (taxonMerge.panelSet == null) {
            stmt = this.sbdb.getDatabase().createStatement();
            try {
                sql = "SELECT DISTINCT panel_id FROM " + this.sbdb.DBTableName("CHTPANLMBR") + " WHERE spec_id=" + donor.getSpecID();
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                taxonMerge.panelSet = new HashSet();
                while (rs.next()) {
                    taxonMerge.panelSet.add(rs.getInt("panel_id"));
                }
                sql = "UPDATE " + this.sbdb.DBTableName("CHTPANLMBR") + " SET spec_id=" + target.getSpecID() + " WHERE spec_id=" + donor.getSpecID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        } else {
            for (Integer panelID : taxonMerge.panelSet) {
                if (this.panelsByID.get(panelID) == null) continue;
                PanelTemplate templ = this.getPanelTemplate(panelID);
                templ.mergeTaxa(donor, target);
            }
        }
        if (taxonMerge.corrTemplIDs == null) {
            taxonMerge.corrTemplIDs = new HashSet();
            stmt = this.sbdb.getDatabase().createStatement();
            try {
                sql = "SELECT corrsch_id FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id IN(SELECT ev_id FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + donor.getSpecID() + ")";
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    taxonMerge.corrTemplIDs.add(rs.getInt("corrsch_id"));
                }
                if (taxonMerge.corrTemplIDs.isEmpty()) {
                    TaxonMerge taxonMerge2 = taxonMerge;
                    return taxonMerge2;
                }
                List donorEvents = this.sbdb.getSBEvents(donor.getSpecID());
                List targetEvents = this.sbdb.getSBEvents(target.getSpecID());
                for (SBEvent donorEvent : donorEvents) {
                    SBEvent foundTarget = null;
                    boolean donorNameIsTaxonName = false;
                    if (donor.toString(false, false).equalsIgnoreCase(donorEvent.getName())) {
                        donorNameIsTaxonName = true;
                    }
                    for (SBEvent targetEvent : targetEvents) {
                        if (targetEvent.getName().equalsIgnoreCase(donorEvent.getName())) {
                            foundTarget = targetEvent;
                            break;
                        }
                        if (!donorNameIsTaxonName || !target.toString(false, false).equalsIgnoreCase(targetEvent.getName())) continue;
                        foundTarget = targetEvent;
                        break;
                    }
                    if (foundTarget == null) continue;
                    sql = "SELECT count(1) as count, corrsch_id, ev_type FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + donorEvent.getEvID() + " or ev_id=" + foundTarget.getEvID() + " GROUP BY corrsch_id, ev_type";
                    rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    HashMap<Integer, EventType> deletions = new HashMap<Integer, EventType>();
                    while (rs.next()) {
                        int count = rs.getInt("count");
                        if (count <= 1) continue;
                        int templID = rs.getInt("corrsch_id");
                        EventType evType = EventType.valueOf((String)rs.getString("ev_type"));
                        deletions.put(templID, evType);
                    }
                    if (!deletions.isEmpty()) {
                        for (Map.Entry entry : deletions.entrySet()) {
                            sql = "DELETE FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + donorEvent.getEvID() + " AND corrsch_id=" + String.valueOf(entry.getKey()) + " AND ev_type=" + SB.DBString((String)((EventType)entry.getValue()).name());
                            stmt.executeUpdate(this.sbdb.modQuery(sql));
                            System.out.println("deleted correlation line co-occurrence: " + String.valueOf(donorEvent) + " " + String.valueOf(entry.getValue()) + "/" + String.valueOf(entry.getKey()));
                        }
                    }
                    sql = "UPDATE " + this.sbdb.DBTableName("CHTLN_EV") + " SET ev_id=" + foundTarget.getEvID() + " WHERE ev_id=" + donorEvent.getEvID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    taxonMerge.eventMatches.put(donorEvent, foundTarget);
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        } else {
            for (SBEvent donorEvent : taxonMerge.eventMatches.keySet()) {
                for (Integer corrTemplID : taxonMerge.corrTemplIDs) {
                    CorrelationTemplate templ = this.corrTemplates.get(corrTemplID);
                    if (templ == null) continue;
                    templ.mergeEvents(donorEvent, taxonMerge.eventMatches.get(donorEvent));
                }
            }
        }
        return taxonMerge;
    }

    public void mergeEventCorrelationLines(SBEvent donor, SBEvent target) {
        for (CorrelationTemplate templ : this.corrTemplates.values()) {
            if (templ == null) continue;
            templ.mergeEvents(donor, target);
        }
    }

    public void unloadEventCorrelationLines(SBEvent event) {
        for (CorrelationTemplate templ : this.corrTemplates.values()) {
            if (templ == null) continue;
            templ.unloadEvent(event);
        }
    }

    boolean isConnected() {
        return this.sbdb.isConnected();
    }

    public static void copyToWs(ChartManager dbCM, ChartManager wsCM, Chart chart, Set<Integer> dataTypes) throws SQLException, SBException {
        assert (dbCM.sbdb.isConnected());
        assert (!wsCM.sbdb.isConnected());
        for (ChartBlock block : chart.getChartBlocks()) {
            for (Well well : block.getWells()) {
                WsWell wsWell = wsCM.sbdb.addWellToWorkspace(well);
                if (chart.getProperties().correctDepths || chart.getProperties().correctCuttings) {
                    wsWell.fillCores(null, null, true);
                }
                switch (block.getProp().getScaleType()) {
                    case TVD: 
                    case SUBSIDENCE: {
                        wsWell.fillTVD(false);
                        dataTypes.add(25);
                    }
                }
                wsWell.getHeader().fillAuditWorkspace(dbCM.sbdb, wsCM.sbdb);
            }
            block.fillWorkspaceWellData(wsCM.sbdb, dataTypes);
            if (wsCM.sbdb.getInterp(block.getInterpID()) != null) continue;
            wsCM.sbdb.fillInterp(dbCM.sbdb.getInterp(block.getInterpID()));
        }
        if (chart.getTemplate() != null) {
            ChartTemplate dbChartTempl = dbCM.getChartTemplate(chart.getTemplate().getID());
            if (dbChartTempl.getSchID() > 0 && wsCM.sbdb.getIGDScheme(dbChartTempl.getSchID()) == null) {
                wsCM.sbdb.addIGDScheme(IGDScheme.copyToWorkspace((SBdb)wsCM.sbdb, (IGDScheme)dbCM.sbdb.getIGDScheme(dbChartTempl.getSchID())));
            }
            ChartTemplate wsChartTempl = new ChartTemplate(wsCM, dbChartTempl.getID(), dbChartTempl.getName(), dbChartTempl.getComments(), 0, 0, dbChartTempl.getProperties(), dbChartTempl.getSchID(), dbChartTempl.getHeaderProperties(), dbChartTempl.getKeyProperties(), dbChartTempl.getAuditCopy(), 0);
            wsCM.sbdb.fillUser(dbCM.sbdb, dbChartTempl.getCreator());
            wsCM.sbdb.fillUser(dbCM.sbdb, dbChartTempl.getModifier());
            for (ChartTemplate.BlockOcc blockOcc : dbChartTempl.getBlocks()) {
                ChartManager.copyToWs(dbCM, wsCM, blockOcc.getBlockID());
                wsChartTempl.addOcc(new ChartTemplate.BlockOcc(blockOcc.getBlockID(), blockOcc.getWellID(), blockOcc.getWellListID(), blockOcc.getInterpID(), blockOcc.getProps(), blockOcc.getCaption()));
            }
            for (CorrTemplateOcc corrTemplateOcc : dbChartTempl.getCorrOccs()) {
                if (wsCM.corrTemplates.get(corrTemplateOcc.getCorrschID()) == null) {
                    wsCM.putCorrTemplate(CorrelationTemplate.copyToWorkspace(wsCM.sbdb, dbCM.sbdb, dbCM.getCorrTemplate(corrTemplateOcc.getCorrschID())));
                }
                wsChartTempl.addOcc(corrTemplateOcc.copy());
            }
            for (CorrStdOcc corrStdOcc : dbChartTempl.getCorrStdOccs()) {
                if (corrStdOcc.getSchID() > 0) {
                    wsCM.sbdb.fillIGDScheme(wsCM.sbdb, corrStdOcc.getSchID());
                }
                wsChartTempl.addOcc(corrStdOcc.copy());
            }
            wsCM.putChartTemplate(wsChartTempl);
        } else {
            for (ChartBlock block : chart.getChartBlocks()) {
                ChartManager.copyToWs(dbCM, wsCM, block.getTemplate().getID());
            }
        }
    }

    public static void copyToWs(ChartManager dbCM, ChartManager wsCM, int blockTemplateID) throws SQLException, SBException {
        assert (dbCM.sbdb.isConnected());
        assert (!wsCM.sbdb.isConnected());
        if (wsCM.blocksByID.get(blockTemplateID) != null) {
            return;
        }
        BlockTemplate blockTemplate = dbCM.getBlockTemplate(blockTemplateID);
        BlockTemplate copy = TemplateFactory.newBlockTemplateForWorkspace(wsCM, blockTemplate);
        wsCM.sbdb.fillUser(dbCM.sbdb, blockTemplate.getCreator());
        wsCM.sbdb.fillUser(dbCM.sbdb, blockTemplate.getModifier());
        for (PanelOcc occ : blockTemplate.getPanels()) {
            if (wsCM.panelsByID.get(occ.getPanelID()) == null) {
                ChartManager.copyToWs(dbCM, wsCM, dbCM.getPanelTemplate(occ.getPanelID()));
            }
            if (occ.getSchID() > 0) {
                wsCM.sbdb.fillIGDScheme(dbCM.sbdb, occ.getSchID());
            }
            if (occ.getInterpID() != null) {
                wsCM.sbdb.fillInterp(dbCM.sbdb.getInterp(occ.getInterpID().intValue()));
            }
            copy.addPanel(new PanelOcc(occ.getPanelID(), occ.getInterpID(), occ.getCaption(), occ.getSubCaption(), occ.getCapOrient(), occ.getSchID()));
        }
        wsCM.putBlockTemplate(copy);
    }

    public static void copyToWs(ChartManager dbCM, ChartManager wsCM, PanelTemplate panelTemplate) throws SQLException, SBException {
        HashMap<String, String> logDefs;
        if (wsCM.panelsByID.get(panelTemplate.getID()) != null) {
            return;
        }
        if (dbCM.getPanelTemplate(panelTemplate.getID()) != panelTemplate) {
            throw new IllegalArgumentException("Panel to copy to workspace does not belong to db chart manager");
        }
        PanelProperties p = panelTemplate.getProperties();
        if (p.getAgeCurveID() > 0) {
            wsCM.sbdb.fillAgeCurve(dbCM.sbdb, p.getAgeCurveID());
        }
        if (p.getAnalystList() != null) {
            for (Object o : p.getAnalystList()) {
                if (o instanceof String) {
                    wsCM.sbdb.fillUser(dbCM.sbdb, dbCM.sbdb.getUser((String)o).getUsrID());
                    continue;
                }
                wsCM.sbdb.fillUser(dbCM.sbdb, ((Userdef)o).getUsrID());
            }
        }
        if (p.getCmpStdID() > 0 && wsCM.sbdb.getCompositeStandard(p.getCmpStdID()) == null) {
            wsCM.sbdb.fillCompositeStandard(dbCM.sbdb.getCompositeStandard(p.getCmpStdID()));
        }
        if (p.getEnvSchID() > 0 && wsCM.sbdb.getEnvScheme(p.getEnvSchID()) == null) {
            try {
                wsCM.sbdb.addEnvScheme(EnvScheme.createCopy((EnvScheme)dbCM.sbdb.getEnvScheme(p.getEnvSchID()), (SBdb)wsCM.sbdb));
            }
            catch (SBPermissionException pe) {
                throw new RuntimeException("Unexpected Permission Exception", pe);
            }
        }
        if (p.getIGDSchemeID() > 0 && wsCM.sbdb.getIGDScheme(p.getIGDSchemeID()) == null) {
            wsCM.sbdb.addIGDScheme(IGDScheme.copyToWorkspace((SBdb)wsCM.sbdb, (IGDScheme)dbCM.sbdb.getIGDScheme(p.getIGDSchemeID())));
        }
        if (p.getGrpSetID() > 0 && wsCM.sbdb.getTxGroupSet(p.getGrpSetID()) == null) {
            wsCM.sbdb.fillTxGroupSet(dbCM.sbdb, p.getGrpSetID());
        }
        if (p.getSynSchID() > 0) {
            // empty if block
        }
        if (p.getBlockMbrTemplateID() > 0 && wsCM.blocksByID.get(p.getBlockMbrTemplateID()) == null) {
            ChartManager.copyToWs(dbCM, wsCM, p.getBlockMbrTemplateID());
        }
        if ((logDefs = p.getLogDefs()) != null) {
            for (Map.Entry entry : logDefs.entrySet()) {
                if (entry.getValue() != null) continue;
                wsCM.sbdb.fillLogDef(dbCM.sbdb.getLogDef((String)entry.getKey()));
            }
        }
        if (p.getShapeStoreID() > 0) {
            wsCM.fillShapeStore(dbCM, p.getShapeStoreID());
        }
        if (panelTemplate.isTaxonPanelTemplate()) {
            PanelTaxonGroupProperties txProp = (PanelTaxonGroupProperties)p;
            for (Category category : txProp.getFilterCats()) {
                wsCM.sbdb.fillCategory(dbCM.sbdb, category);
            }
            assert (dbCM.sbdb.getDatabase() != null);
            Statement statement = dbCM.sbdb.getDatabase().createStatement();
            for (PanelTaxonOcc pOcc : txProp.getInnerPanels()) {
                TxGroup highlightGroup;
                if (pOcc.getFilterSpec() != null && wsCM.sbdb.getTaxon(pOcc.getFilterSpec().getSpecID()) == null) {
                    wsCM.sbdb.fillTaxon(dbCM.sbdb, pOcc.getFilterSpec());
                }
                if (pOcc.getFilterGroup() != null && wsCM.sbdb.getTxGroup(pOcc.getFilterGroup().getID()) == null) {
                    wsCM.sbdb.fillTxGroup(dbCM.sbdb, pOcc.getFilterGroup().getID());
                }
                if (pOcc.getFilterSet() != null && wsCM.sbdb.getTxGroupSet(pOcc.getFilterSet().getID()) == null) {
                    wsCM.sbdb.fillTxGroupSet(dbCM.sbdb, pOcc.getFilterSet().getID());
                }
                if (pOcc.getStdID() != null && wsCM.sbdb.getCompositeStandard(pOcc.getStdID().intValue()) == null) {
                    wsCM.sbdb.fillCompositeStandard(dbCM.sbdb.getCompositeStandard(pOcc.getStdID().intValue()));
                }
                if (!(pOcc.getProperties() instanceof PanelTaxonProperties)) continue;
                PanelTaxonProperties prop = (PanelTaxonProperties)pOcc.getProperties();
                IGDScheme hdrScheme = (IGDScheme)prop.getProperty(49);
                if (hdrScheme != null && wsCM.sbdb.getIGDScheme(hdrScheme.getID()) == null) {
                    wsCM.sbdb.addIGDScheme(IGDScheme.copyToWorkspace((SBdb)wsCM.sbdb, (IGDScheme)hdrScheme));
                }
                if (prop.getExclGrpID() != null && wsCM.sbdb.getTxGroup(prop.getExclGrpID().intValue()) == null) {
                    wsCM.sbdb.fillTxGroup(dbCM.sbdb, prop.getExclGrpID().intValue());
                }
                if ((highlightGroup = (TxGroup)prop.getProperty(46)) != null && wsCM.sbdb.getTxGroup(highlightGroup.getID()) == null) {
                    wsCM.sbdb.fillTxGroup(dbCM.sbdb, highlightGroup.getID());
                }
                if (prop.getSubTypes() == null) continue;
                for (Integer subType : prop.getSubTypes()) {
                    wsCM.sbdb.getSpeciesTypeService().addSpeciesType((SpeciesType)dbCM.sbdb.getSpeciesTypeService().getSpeciesType(subType.intValue()).get());
                }
            }
            statement.close();
        }
        PanelProperties propCopy = wsCM.copyPanelProperties(panelTemplate.getProperties());
        PanelTemplate panelTemplate2 = new PanelTemplate(p.getPanelType(), panelTemplate.getID(), panelTemplate.isVisible(), panelTemplate.getName(), panelTemplate.getComments(), false, propCopy, 0, panelTemplate.getAuditCopy(), 0);
        if (panelTemplate.getCreator() > 0) {
            wsCM.sbdb.fillUser(dbCM.sbdb, panelTemplate.getCreator());
        } else {
            System.out.println("Template creator audit record is zero in ChartManager.copyToWs");
        }
        if (panelTemplate.getModifier() > 0) {
            wsCM.sbdb.fillUser(dbCM.sbdb, panelTemplate.getModifier());
        } else {
            System.out.println("Template modifier audit record is zero in ChartManager.copyToWs");
        }
        wsCM.putPanelTemplate(panelTemplate2);
    }

    public void fillShapeStore(ChartManager dbCM, int shapestoreID) {
        SBShapeStore dbSS = dbCM.getShapeStoreService().getShapeStore(shapestoreID);
        SBShapeStore wsSS = SBShapeStore.createShapeStore(dbSS.getShapeStoreID(), dbSS.getStoreType(), dbSS.getName(), dbSS.getUrl(), dbSS.isLongitudeFirst());
        this.shapeStoreService.putShapeStore(wsSS);
    }

    public static void writeXML(BufferedWriter out, SBdb db, ChartManager wsCM, List<File> files, Set<Integer> dataTypes) throws IOException, SQLException, SBException {
        String abr;
        assert (db.isConnected());
        assert (!wsCM.sbdb.isConnected());
        wsCM.sbdb.writeXML(out, dataTypes, db, files, false, false);
        int singleUserID = 0;
        if (db.getExportSingleUser(false) && !db.getExportSingleUserAbr(false).isEmpty() && (abr = db.getExportSingleUserAbr(false)) != null && !abr.isEmpty() && wsCM.sbdb.getUser(abr) != null) {
            singleUserID = wsCM.sbdb.getUser(abr).getUsrID();
        }
        int ind = 3;
        String indent1 = SB.getXMLIndent((int)ind);
        out.write(indent1 + "<ChartTemplates>\n");
        String indent = SB.getXMLIndent((int)(ind += 3));
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        for (SBShapeStore ss : wsCM.shapeStoreService.getAllShapeStores()) {
            out.write(indent + "<ShapeStore ShapeStoreID=\"" + ss.getShapeStoreID() + "\">\n");
            ss.writeXML(out, ind + 3);
            if (ss.getStoreType() == SBShapeStore.StoreType.FILE) {
                System.out.println("ShapeStore url=" + ss.getUrl());
                File tempShapeFileDir = new File(tempDir, "sbugs_shapefiles");
                if (!tempShapeFileDir.exists()) {
                    throw new SBException("Temporary shape file directory doesn't exist");
                }
                File shapeFileDir = new File(tempShapeFileDir, ss.getUrl());
                if (!shapeFileDir.exists()) {
                    throw new SBException("Temporary shape file directory: " + String.valueOf(shapeFileDir) + " doesn't exist");
                }
                File shpFile = new File(shapeFileDir, ss.getUrl() + ".shp");
                if (!shpFile.exists()) {
                    throw new SBException("Temporary shape file: " + String.valueOf(shpFile) + " doesn't exist");
                }
                for (File ssFile : new ShapefileFileFinder().findShapefileFiles(shpFile.getPath())) {
                    System.out.println("ShapeStore file=" + String.valueOf(ssFile.toPath()));
                    if (ssFile.exists()) {
                        files.add(ssFile);
                        continue;
                    }
                    System.out.println("Path doesn't exist");
                }
            }
            out.write(indent + "</ShapeStore>\n");
        }
        for (PanelTemplate panel : wsCM.panelsByID.values()) {
            out.write(indent + "<PanelTemplate PanelID=\"" + panel.getID() + "\" Type=\"" + panel.getType().name() + "\">\n");
            panel.writeXML(out, ind + 3, wsCM.sbdb, singleUserID);
            out.write(indent + "</PanelTemplate>\n");
        }
        for (BlockTemplate block : wsCM.blocksByID.values()) {
            out.write(indent + "<BlockTemplate BlockID=\"" + block.getID() + "\" Type=\"" + block.getType().name() + "\">\n");
            block.writeXML(out, ind + 3, wsCM.sbdb, singleUserID);
            out.write(indent + "</BlockTemplate>\n");
        }
        for (CorrelationTemplate corr : wsCM.corrTemplates.values()) {
            out.write(indent + "<CorrelationTemplate CorrelationID=\"" + corr.getID() + "\">\n");
            corr.writeXML(out, ind + 3, singleUserID);
            out.write(indent + "</CorrelationTemplate>\n");
        }
        for (ChartTemplate chart : wsCM.charts.values()) {
            out.write(indent + "<Chart ChartID=\"" + chart.getID() + "\">\n");
            chart.writeXML(out, ind + 3, wsCM.sbdb, singleUserID);
            out.write(indent + "</Chart>\n");
        }
        out.write(indent1 + "</ChartTemplates>\n");
        out.write("</StrataBugs>\n");
        out.flush();
        out.close();
    }

    public void parseXMLDocument(Document xmlDocument, Set<Integer> dataTypes, ZipFile zip, String fileName, int projID, List<SBException> exceptions) throws SBException, SQLException, ParseException, FileNotFoundException, IOException {
        this.sbdb.parseXMLDocument(xmlDocument, dataTypes, zip, fileName, 0, exceptions);
        IteratorIterable it = xmlDocument.getDescendants((Filter)new ElementFilter("ShapeStore"));
        while (it.hasNext()) {
            Element ssEle = (Element)it.next();
            SBShapeStore ss = SBShapeStore.parseXML(this, ssEle, zip);
            this.shapeStoreService.putShapeStore(ss);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("BlockTemplate"));
        while (it.hasNext()) {
            BlockTemplate templ = BlockTemplate.parseXML(this, this.sbdb, (Element)it.next(), 0);
            this.putBlockTemplate(templ);
        }
        for (BlockTemplate bTempl : this.blocksByID.values()) {
            if (bTempl.getType() != BlockType.SCHEME) continue;
            for (int panelID : bTempl.getPanelIDs()) {
                if (this.panelsByID.get(panelID) != null) continue;
                String query = "//PanelTemplate[@PanelID='" + panelID + "']";
                XPathBuilder xpb = new XPathBuilder(query, Filters.element());
                XPathExpression xpe = xpb.compileWith(XPathFactory.instance());
                for (Element panelEl : xpe.evaluate((Object)xmlDocument.getRootElement())) {
                    this.putPanelTemplate(PanelTemplate.parseXML(this, this.sbdb, panelEl, projID));
                }
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("PanelTemplate"));
        while (it.hasNext()) {
            Element panelEl = (Element)it.next();
            int panelID = Integer.parseInt(panelEl.getAttributeValue("PanelID"));
            if (this.panelsByID.get(panelID) != null) continue;
            this.putPanelTemplate(PanelTemplate.parseXML(this, this.sbdb, panelEl, projID));
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("CorrelationTemplate"));
        while (it.hasNext()) {
            this.putCorrTemplate(CorrelationTemplate.parseXML(this, this.sbdb, (Element)it.next(), projID));
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("Chart"));
        while (it.hasNext()) {
            this.putChartTemplate(ChartTemplate.parseXML(this, this.sbdb, (Element)it.next(), projID));
        }
    }

    static int parseInterpIDelement(SBdb ws, Element el) throws SQLException, SBException {
        int interpID = Integer.parseInt(el.getAttributeValue("ID"));
        if (ws.getInterp(interpID) == null) {
            try {
                ws.addInterp(el.getAttributeValue("Description"), Integer.valueOf(interpID));
            }
            catch (InvalidFieldException ife) {
                throw new SBException(ife.getMessage());
            }
        }
        return interpID;
    }

    public boolean hasDataLoaded() {
        assert (!this.sbdb.isConnected());
        if (!this.panelsByID.isEmpty()) {
            return true;
        }
        if (!this.blocksByID.isEmpty()) {
            return true;
        }
        if (!this.corrTemplates.isEmpty()) {
            return true;
        }
        return !this.charts.isEmpty();
    }

    public boolean hasInterpOccs(Integer interpID) {
        assert (!this.sbdb.isConnected());
        for (BlockTemplate block : this.blocksByID.values()) {
            for (PanelOcc panelOcc : block.getPanels()) {
                if (panelOcc.getInterpID() == null || interpID != null && !Objects.equals(panelOcc.getInterpID(), interpID)) continue;
                return true;
            }
        }
        for (ChartTemplate chart : this.charts.values()) {
            for (ChartTemplate.BlockOcc blockOcc : chart.getBlocks()) {
                if (interpID != null && blockOcc.getInterpID() != interpID.intValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasOccurrences(Object scheme) {
        assert (!this.sbdb.isConnected());
        assert (scheme != null);
        assert (scheme instanceof IGDScheme || scheme instanceof CompositeStandard || scheme instanceof EnvScheme || scheme instanceof TxGroup || scheme instanceof TxGroupSet || scheme instanceof AgeCurve || scheme instanceof Taxon);
        if (scheme instanceof IGDScheme) {
            for (BlockTemplate block : this.blocksByID.values()) {
                for (PanelOcc occ : block.getPanels()) {
                    if (occ.getSchID() <= 0 || ((IGDScheme)scheme).getID() != occ.getSchID()) continue;
                    return true;
                }
            }
        }
        for (PanelTemplate panel : this.panelsByID.values()) {
            if (scheme instanceof IGDScheme && panel.getProperties().getIGDSchemeID() == ((IGDScheme)scheme).getID()) {
                return true;
            }
            if (scheme instanceof CompositeStandard && panel.getProperties().getCmpStdID() == ((CompositeStandard)scheme).getID()) {
                return true;
            }
            if (scheme instanceof EnvScheme && panel.getProperties().getEnvSchID() == ((EnvScheme)scheme).getID()) {
                return true;
            }
            if (scheme instanceof TxGroupSet && panel.getProperties().getGrpSetID() == ((TxGroupSet)scheme).getID()) {
                return true;
            }
            if (scheme instanceof AgeCurve && panel.getProperties().getAgeCurveID() == ((AgeCurve)scheme).getCurveID()) {
                return true;
            }
            if (!panel.isTaxonPanelTemplate()) continue;
            PanelTaxonGroupProperties txProp = (PanelTaxonGroupProperties)panel.getProperties();
            for (PanelTaxonOcc pOcc : txProp.getInnerPanels()) {
                PanelTaxonProperties prop;
                if (scheme instanceof CompositeStandard && pOcc.getFilterCmpStd() != null && pOcc.getFilterCmpStd().getID() == ((CompositeStandard)scheme).getID()) {
                    return true;
                }
                if (scheme instanceof TxGroup && pOcc.getFilterGroup() != null && pOcc.getFilterGroup().getID() == ((TxGroup)scheme).getID()) {
                    return true;
                }
                if (scheme instanceof TxGroupSet && pOcc.getFilterSet() != null && pOcc.getFilterSet().getID() == ((TxGroupSet)scheme).getID()) {
                    return true;
                }
                if (scheme instanceof Taxon && pOcc.getFilterSpec() != null && pOcc.getFilterSpec().getSpecID() == ((Taxon)scheme).getSpecID()) {
                    return true;
                }
                if (!(pOcc.getProperties() instanceof PanelTaxonProperties) || (prop = (PanelTaxonProperties)pOcc.getProperties()).getProperty(49) != scheme && prop.getProperty(48) != scheme && prop.getProperty(5) != scheme) continue;
                return true;
            }
        }
        return false;
    }

    private void checkMatches(SBdb db) throws UnmatchedException, SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to check matches in connected database");
        }
        assert (db.isConnected());
        UnmatchedException ex = new UnmatchedException();
        for (PanelTemplate panel : this.panelsByID.values()) {
            HashMap<String, String> logDefs;
            PanelProperties p;
            Iterator<PanelOcc> users = new HashSet<Userdef>();
            if (panel.getCreator() > 0) {
                ((HashSet)((Object)users)).add((PanelOcc)this.sbdb.getUser(panel.getCreator()));
            }
            if (panel.getModifier() > 0) {
                ((HashSet)((Object)users)).add((PanelOcc)this.sbdb.getUser(panel.getModifier()));
            }
            if ((p = panel.getProperties()).getAnalystList() != null) {
                for (Object o : p.getAnalystList()) {
                    if (o instanceof String) {
                        ((HashSet)((Object)users)).add((PanelOcc)this.sbdb.getUser((String)o));
                        continue;
                    }
                    ((HashSet)((Object)users)).add((PanelOcc)((Userdef)o));
                }
            }
            Iterator iterator = ((HashSet)((Object)users)).iterator();
            while (iterator.hasNext()) {
                Userdef user = (Userdef)iterator.next();
                if (user.getLink() != null) continue;
                ex.addUnmatched((Object)user);
            }
            if (p.getAgeCurveID() > 0 && this.sbdb.getAgeCurve(p.getAgeCurveID()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getAgeCurve(p.getAgeCurveID()));
            }
            if (p.getCmpStdID() > 0 && this.sbdb.getCompositeStandard(p.getCmpStdID()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getCompositeStandard(p.getCmpStdID()));
            }
            if (p.getEnvSchID() > 0 && this.sbdb.getEnvScheme(p.getEnvSchID()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getEnvScheme(p.getEnvSchID()));
            }
            if (p.getIGDSchemeID() > 0 && this.sbdb.getIGDScheme(p.getIGDSchemeID()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getIGDScheme(p.getIGDSchemeID()));
            }
            if (p.getGrpSetID() > 0 && this.sbdb.getTxGroupSet(p.getGrpSetID()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getTxGroupSet(p.getGrpSetID()));
            }
            if (p.getSynSchID() > 0) {
                // empty if block
            }
            if ((logDefs = p.getLogDefs()) != null) {
                for (Map.Entry entry : logDefs.entrySet()) {
                    if (entry.getValue() != null || this.sbdb.getLogDef((String)entry.getKey()).getLink() != null) continue;
                    ex.addUnmatched((Object)this.sbdb.getLogDef((String)entry.getKey()));
                }
            }
            if (!panel.isTaxonPanelTemplate()) continue;
            PanelTaxonGroupProperties txProp = (PanelTaxonGroupProperties)p;
            for (PanelTaxonOcc pOcc : txProp.getInnerPanels()) {
                TxGroup exclGroup;
                if (pOcc.getFilterSpec() != null && this.sbdb.getTaxon(pOcc.getFilterSpec().getSpecID()).getLink() == null) {
                    ex.addUnmatched((Object)this.sbdb.getTaxon(pOcc.getFilterSpec().getSpecID()));
                }
                if (pOcc.getFilterGroup() != null && pOcc.getFilterGroup().getLink() == null) {
                    ex.addUnmatched((Object)pOcc.getFilterGroup());
                }
                if (pOcc.getFilterSet() != null && pOcc.getFilterSet().getLink() == null) {
                    ex.addUnmatched((Object)pOcc.getFilterSet());
                }
                if (pOcc.getStdID() != null && this.sbdb.getCompositeStandard(pOcc.getStdID().intValue()).getLink() == null) {
                    ex.addUnmatched((Object)this.sbdb.getCompositeStandard(pOcc.getStdID().intValue()));
                }
                if (!(pOcc.getProperties() instanceof PanelTaxonProperties)) continue;
                PanelTaxonProperties prop = (PanelTaxonProperties)pOcc.getProperties();
                IGDScheme hdrScheme = (IGDScheme)prop.getProperty(49);
                if (hdrScheme != null && hdrScheme.getLink() == null) {
                    ex.addUnmatched((Object)hdrScheme);
                }
                if ((exclGroup = (TxGroup)prop.getProperty(5)) == null || exclGroup.getLink() != null) continue;
                ex.addUnmatched((Object)exclGroup);
            }
        }
        for (BlockTemplate block : this.blocksByID.values()) {
            if (this.sbdb.getUser(block.getCreator()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getUser(block.getCreator()));
            }
            if (this.sbdb.getUser(block.getModifier()).getLink() == null) {
                ex.addUnmatched((Object)this.sbdb.getUser(block.getModifier()));
            }
            for (PanelOcc pOcc : block.getPanels()) {
                if (pOcc.getInterpID() != null && this.sbdb.getInterp(pOcc.getInterpID().intValue()).getLink() == null) {
                    ex.addUnmatched((Object)this.sbdb.getInterp(pOcc.getInterpID().intValue()));
                }
                if (pOcc.getSchID() <= 0 || this.sbdb.getIGDScheme(pOcc.getSchID()).getLink() != null) continue;
                ex.addUnmatched((Object)this.sbdb.getIGDScheme(pOcc.getSchID()));
            }
        }
        for (CorrelationTemplate corr : this.corrTemplates.values()) {
            for (CorrelationLine line : corr.getLineList()) {
                if (line.hasLink()) continue;
                ex.addUnmatched(line.getObject());
            }
        }
        for (ChartTemplate chart : this.charts.values()) {
            IGDScheme sch;
            if (chart.getSchID() > 0 && (sch = this.sbdb.getIGDScheme(chart.getSchID())).getLink() == null) {
                ex.addUnmatched((Object)sch);
            }
            for (CorrStdOcc csOcc : chart.getCorrStdOccs()) {
                IGDScheme sch2;
                if (csOcc.getSchID() <= 0 || (sch2 = this.sbdb.getIGDScheme(csOcc.getSchID())).getLink() != null) continue;
                ex.addUnmatched((Object)sch2);
            }
            for (ChartTemplate.BlockOcc bOcc : chart.getBlocks()) {
                WsWell wsWell;
                if (bOcc.getWellID() <= 0 || (wsWell = (WsWell)this.sbdb.getWell(bOcc.getWellID())).getLink() != null) continue;
                ex.addUnmatched((Object)wsWell);
            }
        }
        if (ex.hasUnmatched()) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToDb(ChartManager wsCM, ChartManager dbCM, int dbProjID, PANEL_STORE_OPTION panelStoreOption) throws SQLException, SBException, UnmatchedException {
        assert (panelStoreOption != null);
        wsCM.checkMatches(dbCM.sbdb);
        try {
            for (SBShapeStore shapeStore : wsCM.shapeStoreService.getAllShapeStores()) {
                ChartManager.copyToDBShapeStore(wsCM, dbCM, shapeStore);
            }
            for (BlockTemplate block : wsCM.blocksByID.values()) {
                ChartManager.copyToDBblock(wsCM, dbCM, dbProjID, panelStoreOption, block.getID());
            }
            for (PanelTemplate panel : wsCM.panelsByID.values()) {
                ChartManager.copyToDBpanel(wsCM, dbCM, dbProjID, panelStoreOption, panel.getID());
            }
            for (CorrelationTemplate corr : wsCM.corrTemplates.values()) {
                ChartManager.copyToDBcorr(wsCM, dbCM, dbProjID, corr.getID());
            }
            for (ChartTemplate chartTemplate : wsCM.charts.values()) {
                ChartManager.copyToDBchart(wsCM, dbCM, dbProjID, chartTemplate.getID());
            }
        }
        finally {
            wsCM.clearLinks();
            try {
                dbCM.deleteOrphanedInvisiblePanels();
            }
            catch (SBPermissionException pe) {
                throw new SBException("Unexpected permission exception deleting orphaned invisible panels", (Throwable)pe);
            }
        }
    }

    private void clearLinks() {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to clear links in database");
        }
        for (BlockTemplate block : this.blocksByID.values()) {
            block.setLink(null);
        }
        for (PanelTemplate panel : this.panelsByID.values()) {
            panel.setLink(null);
        }
        for (CorrelationTemplate corr : this.corrTemplates.values()) {
            corr.setLink(null);
        }
        for (ChartTemplate chartTemplate : this.charts.values()) {
            chartTemplate.setLink(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static PanelTemplate copyToDBpanel(ChartManager wsCM, ChartManager dbCM, int dbProjID, PANEL_STORE_OPTION panelStoreOption, int panelID) throws SQLException, SBException {
        void var10_18;
        HashMap<String, String> logDefs;
        PanelTemplate wsPanel = wsCM.getPanelTemplate(panelID);
        if (wsPanel.getLink() != null) {
            return wsPanel.getLink();
        }
        PanelPropertiesBuilder builder = new PanelPropertiesBuilder(wsPanel.getType(), wsPanel.getProperties().getPropertiesString());
        PanelProperties wsProperties = wsPanel.getProperties();
        if (wsProperties.getAgeCurveID() > 0) {
            builder.ageCurveID(wsCM.sbdb.getAgeCurve(wsProperties.getAgeCurveID()).getLink().getCurveID());
        }
        if (wsProperties.getAnalystList() != null) {
            for (Object o : wsProperties.getAnalystList()) {
                if (o instanceof String) {
                    builder.analyst(wsCM.sbdb.getUser((String)o).getLink());
                    continue;
                }
                builder.analyst(((Userdef)o).getLink());
            }
        }
        if (wsProperties.getCmpStdID() > 0) {
            builder.cmpStdID(wsCM.sbdb.getCompositeStandard(wsProperties.getCmpStdID()).getLink().getID());
        }
        if (wsProperties.getEnvSchID() > 0) {
            builder.envSchID(wsCM.sbdb.getEnvScheme(wsProperties.getEnvSchID()).getLink().getID());
        }
        if (wsProperties.getIGDSchemeID() > 0) {
            builder.schID(wsCM.sbdb.getIGDScheme(wsProperties.getIGDSchemeID()).getLink().getID());
        }
        if (wsProperties.getGrpSetID() > 0) {
            builder.grpSetID(wsCM.sbdb.getTxGroupSet(wsProperties.getGrpSetID()).getLink().getID());
        }
        if (wsProperties.getSynSchID() > 0) assert (false);
        if (wsProperties.getBlockMbrTemplateID() > 0) {
            if (wsCM.getBlockTemplate(wsProperties.getBlockMbrTemplateID()).getLink() == null) {
                ChartManager.copyToDBblock(wsCM, dbCM, dbProjID, panelStoreOption, wsProperties.getBlockMbrTemplateID());
            }
            builder.mbrBlock((ChartBlock)ChartFactory.createBlock(dbCM.sbdb, dbCM.getBlockTemplate(wsCM.getBlockTemplate(wsProperties.getBlockMbrTemplateID()).getLink().getID())));
        }
        if ((logDefs = wsProperties.getLogDefs()) != null) {
            for (Map.Entry entry : logDefs.entrySet()) {
                String key = (String)entry.getKey();
                if (wsCM.sbdb.getLogDef(key) != null) {
                    key = wsCM.sbdb.getLogDef(key).getLink().getAbr();
                    if (entry.getValue() != null && !((String)entry.getValue()).startsWith(key)) {
                        LogDef wsLD = new LogDef((String)entry.getValue());
                        LogDef dbLD = wsCM.sbdb.getLogDef(key).getLink();
                        wsLD.update(dbLD.getAbr(), dbLD.getTitle());
                        entry.setValue(wsLD.getProperties());
                    }
                }
                builder.logDef(key, (String)entry.getValue());
            }
        }
        if (PanelType.isTaxonPanel(wsProperties.getPanelType())) {
            for (PanelTaxonOcc panelTaxonOcc : ((PanelTaxonGroupProperties)wsProperties).getInnerPanels()) {
                builder.innerPanel(PanelTaxonOcc.copyToDb(panelTaxonOcc, wsCM.sbdb, dbCM.sbdb));
            }
        }
        if (wsProperties.getShapeStoreID() > 0) {
            builder.shapeStoreID(wsCM.shapeStoreService.getShapeStore(wsProperties.getShapeStoreID()).getLink().getShapeStoreID());
        }
        PanelProperties newDbProperties = builder.build(dbCM.sbdb, dbCM.shapeStoreService);
        Object var10_13 = null;
        switch (panelStoreOption.ordinal()) {
            case 1: {
                void var10_15;
                List<PanelTemplate> similar;
                if (wsPanel.isVisible() && !(similar = dbCM.findSimilar(newDbProperties, (Integer)dbProjID)).isEmpty()) {
                    for (PanelTemplate s : similar) {
                        if (s.getProjID() != dbProjID) continue;
                        PanelTemplate panelTemplate = s;
                        System.out.println("Used similar panel: " + panelTemplate.getName());
                        break;
                    }
                    if (var10_15 == null) {
                        PanelTemplate panelTemplate = similar.get(0);
                        System.out.println("Used similar panel: " + panelTemplate.getName());
                        break;
                    }
                }
            }
            case 0: 
            case 2: {
                boolean isVisible;
                void var10_15;
                if (var10_15 != null) break;
                Object name = wsPanel.getName();
                boolean bl = isVisible = panelStoreOption.equals((Object)PANEL_STORE_OPTION.DECOUPLE) ? false : wsPanel.isVisible();
                if (isVisible) {
                    int i = 2;
                    while (!dbCM.checkNewTemplateName((String)name, wsPanel.getType(), dbProjID)) {
                        name = wsPanel.getName() + " (" + i++ + ")";
                    }
                }
                int ID = dbCM.sbdb.nextControl("CHTPANL", "PANEL_ID");
                PanelTemplate panelTemplate = new PanelTemplate(wsPanel.getType(), ID, isVisible, (String)name, wsPanel.getComments(), false, newDbProperties, dbProjID, new Audit(dbCM.sbdb, wsCM.sbdb, wsPanel.getAuditCopy()), 0);
                panelTemplate.store(dbCM.sbdb);
                dbCM.sbdb.commit();
                dbCM.putPanelTemplate(panelTemplate);
                System.out.println("Copied panel: " + panelTemplate.getName());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (var10_18 == null) {
            throw new SBException("Panel copy failed: " + wsPanel.getName());
        }
        wsPanel.setLink((PanelTemplate)var10_18);
        return var10_18;
    }

    private static void copyToDBShapeStore(ChartManager wsCM, ChartManager dbCM, SBShapeStore shapeStore) {
        for (SBShapeStore dbSS : dbCM.shapeStoreService.getAllShapeStores()) {
            if (!dbSS.getName().equals(shapeStore.getName())) continue;
            shapeStore.setLink(dbSS);
            return;
        }
        SBShapeStore dbSS = new SBShapeStore(shapeStore);
        dbCM.shapeStoreService.storeShapeStore(dbSS);
        shapeStore.setLink(dbSS);
    }

    private static void copyToDBblock(ChartManager wsCM, ChartManager dbCM, int dbProjID, PANEL_STORE_OPTION panelStoreOption, int blockID) throws SQLException, SBException {
        BlockTemplate wsBlock = wsCM.getBlockTemplate(blockID);
        if (wsBlock.getLink() != null) {
            return;
        }
        BlockTemplate dbBlock = TemplateFactory.newBlockTemplateForDatabase(dbCM, wsCM, wsBlock, dbProjID);
        for (PanelOcc wspOcc : wsBlock.getPanels()) {
            PanelTemplate wsPanel = wsCM.getPanelTemplate(wspOcc.getPanelID());
            if (wsPanel.getLink() == null) {
                ChartManager.copyToDBpanel(wsCM, dbCM, dbProjID, panelStoreOption, wsPanel.getID());
            }
            int panelID = wsPanel.getLink().getID();
            Integer interpID = null;
            if (wspOcc.getInterpID() != null) {
                interpID = wsCM.sbdb.getInterp(wspOcc.getInterpID().intValue()).getLink().getInterpID();
            }
            int schID = 0;
            if (wspOcc.getSchID() > 0) {
                schID = wsCM.sbdb.getIGDScheme(wspOcc.getSchID()).getLink().getID();
            }
            dbBlock.addPanel(new PanelOcc(panelID, interpID, wspOcc.getCaption(), wspOcc.getSubCaption(), wspOcc.getCapOrient(), schID));
        }
        try {
            dbBlock.store(dbCM.sbdb);
            dbCM.sbdb.commit();
            dbCM.putBlockTemplate(dbBlock);
            wsBlock.setLink(dbBlock);
            System.out.println("Copied block: " + dbBlock.getName());
        }
        catch (InvalidFieldException e) {
            throw new SBException(e.getMessage(), (Throwable)e);
        }
    }

    private static void copyToDBcorr(ChartManager wsCM, ChartManager dbCM, int dbProjID, int corrID) throws SQLException, SBException {
        CorrelationTemplate wsCorr = wsCM.corrTemplates.get(corrID);
        if (wsCorr.getLink() != null) {
            return;
        }
        Object name = wsCorr.getName();
        int i = 1;
        while (!dbCM.checkNewTemplateName((String)name, wsCorr.getType(), dbProjID)) {
            name = wsCorr.getName() + " (" + i++ + ")";
        }
        try {
            CorrelationTemplate dbCorr = CorrelationTemplate.copyToDB(wsCM.sbdb, dbCM.sbdb, wsCorr, (String)name, dbProjID);
            dbCM.sbdb.commit();
            dbCM.putCorrTemplate(dbCorr);
        }
        catch (InvalidFieldException | SBPermissionException e) {
            throw new SBException(e.getMessage(), e);
        }
    }

    private static void copyToDBchart(ChartManager wsCM, ChartManager dbCM, int dbProjID, int chartID) throws SQLException, SBException {
        ChartTemplate ws = wsCM.charts.get(chartID);
        if (ws.getLink() != null) {
            return;
        }
        Object name = ws.getName();
        int i = 1;
        while (!dbCM.checkNewTemplateName((String)name, null, dbProjID)) {
            name = ws.getName() + " (" + i++ + ")";
        }
        int schID = 0;
        if (ws.getSchID() > 0) {
            schID = wsCM.sbdb.getIGDScheme(ws.getSchID()).getLink().getID();
        }
        ChartTemplate dbChart = new ChartTemplate(dbCM, 0, (String)name, ws.getComments(), dbProjID, 0, ws.getProperties(), schID, ws.getHeaderProperties(), ws.getKeyProperties(), new Audit(dbCM.sbdb, wsCM.sbdb, ws.getAuditCopy()), 0);
        try {
            dbChart.store(dbCM.sbdb);
        }
        catch (InvalidFieldException e) {
            throw new SBException(e.getMessage(), (Throwable)e);
        }
        try {
            LinkedList<ChartTemplate.BlockOcc> blockOccCopies = new LinkedList<ChartTemplate.BlockOcc>();
            for (ChartTemplate.BlockOcc blockOcc : ws.getBlocks()) {
                blockOccCopies.add(new ChartTemplate.BlockOcc(wsCM.getBlockTemplate(blockOcc.getBlockID()).getLink().getID(), blockOcc.getWellID() > 0 ? ((WsWell)wsCM.sbdb.getWell(blockOcc.getWellID())).getLink().getWellID() : 0, blockOcc.getWellListID() > 0 ? dbProjID : 0, wsCM.sbdb.getInterp(blockOcc.getInterpID()).getLink().getInterpID(), blockOcc.getProps(), blockOcc.getCaption()));
            }
            HashSet<CorrTemplateOcc> corrOccCopies = new HashSet<CorrTemplateOcc>();
            for (CorrTemplateOcc corrTemplateOcc : ws.getCorrOccs()) {
                corrOccCopies.add(corrTemplateOcc.copy(wsCM.corrTemplates.get(corrTemplateOcc.getCorrschID()).getLink().getID(), wsCM.sbdb.getInterp(corrTemplateOcc.getInterpID()).getLink().getInterpID()));
            }
            HashSet<CorrStdOcc> hashSet = new HashSet<CorrStdOcc>();
            for (CorrStdOcc csOcc : ws.getCorrStdOccs()) {
                int csOccSchID = csOcc.getSchID() > 0 ? wsCM.sbdb.getIGDScheme(csOcc.getSchID()).getLink().getID() : 0;
                hashSet.add(csOcc.copy(wsCM.sbdb.getInterp(csOcc.getInterpID()).getLink().getInterpID(), csOccSchID));
            }
            HashSet<ChartTagTemplate> hashSet2 = new HashSet<ChartTagTemplate>();
            for (ChartTagTemplate t : ws.getTagTemplates()) {
                hashSet2.add(t);
            }
            dbChart.update(dbCM.sbdb, blockOccCopies, corrOccCopies, hashSet, hashSet2, dbChart.getProperties(), dbChart.getHeaderProperties(), dbChart.getKeyProperties(), schID);
        }
        catch (IOException | SBPermissionException ioe) {
            throw new SBException("Unexpected exception storing charts", ioe);
        }
        dbCM.sbdb.commit();
        ws.setLink(ws);
        dbCM.putChartTemplate(dbChart);
        if (dbProjID > 0) {
            try {
                for (ChartTemplate.BlockOcc bOcc : dbChart.getBlocks()) {
                    if (bOcc.getWellID() > 0) {
                        Well well = dbCM.sbdb.getWell(bOcc.getWellID());
                        if (well.getDataModel().getWellListService().isWellProjectMember(dbProjID, well.getID())) continue;
                        dbCM.sbdb.addWellToProject(well, dbProjID);
                        continue;
                    }
                    if (bOcc.getWellListID() <= 0) continue;
                }
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission excepting adding wells to project", pe);
            }
            dbCM.sbdb.commit();
        }
    }

    public static void repairLocalPanels(ChartManager dbCM) {
        try {
            Object sql = "select p.PANEL_ID from chtpanl p, CHTBLOCKMBR m, CHTBLOCK b where p.ISVISIBLE='N' and p.PANEL_ID=m.PANEL_ID and m.BLOCK_ID=b.BLOCK_ID group by  p.PANEL_ID having count(p.panel_id) > 1";
            Statement stmt = dbCM.sbdb.getDatabase().createStatement();
            Statement stmt2 = dbCM.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery((String)sql);
            int nUpdated = 0;
            while (rs.next()) {
                int panelID = rs.getInt("panel_id");
                sql = "SELECT b.block_id,b.descr FROM CHTBLOCKMBR m, CHTBLOCK b WHERE m.block_id=b.block_id AND m.panel_id=" + panelID;
                int blockID = 0;
                String blockDescr = "";
                ResultSet rs2 = stmt2.executeQuery((String)sql);
                while (rs2.next()) {
                    int bID = rs2.getInt("block_id");
                    String bDescr = rs2.getString("descr");
                    if (bID <= blockID) continue;
                    blockID = bID;
                    blockDescr = bDescr;
                }
                String comments = "Local to well block template [" + blockDescr + "]";
                PanelTemplate pt = dbCM.getPanelTemplate(panelID);
                PanelTemplate ptCopy = dbCM.addPanelTemplate(pt.getName(), comments, pt.getProjID(), pt, false);
                sql = "UPDATE CHTBLOCKMBR SET panel_id=" + ptCopy.getID() + " WHERE panel_id=" + panelID + " AND block_id=" + blockID;
                int nRows = stmt2.executeUpdate((String)sql);
                if (nRows != 1) {
                    System.out.println("Error updating: " + (String)sql);
                    dbCM.sbdb.doRollback();
                }
                ++nUpdated;
            }
            int opt = JOptionPane.showConfirmDialog(null, "Number updated: " + nUpdated + ", Commit?");
            if (opt == 0) {
                dbCM.sbdb.commit();
            } else {
                dbCM.sbdb.doRollback();
            }
            stmt2.close();
            stmt.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dbCM.sbdb.doRollback();
        }
    }

    public void updateBlockTemplateInfo(int templateId, String name, String comments, int projID) {
        Optional<BlockTemplateInfo> info;
        if (this.blockInfoList != null && (info = this.blockInfoList.stream().filter(i -> i.getID() == templateId).findFirst()).isPresent()) {
            info.get().updateDescr(name, comments, projID);
        }
    }

    public void preloadBlockTemplates() {
        BlockTemplateBulkLoadTask loader = new BlockTemplateBulkLoadTask(this, this::integrateBulkLoadedBlockTemplates);
        loader.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integrateBulkLoadedBlockTemplates(Collection<BlockTemplateParent> templates) {
        HashMap<Integer, BlockTemplate> hashMap = this.blocksByID;
        synchronized (hashMap) {
            templates.stream().forEach(parentTemplate -> {
                if (!this.blocksByID.containsKey(parentTemplate.getID())) {
                    this.blocksByID.put(parentTemplate.getID(), (BlockTemplate)parentTemplate);
                }
            });
            EnumMap<BlockType, List<BlockTemplate>> enumMap = this.blocksByType;
            synchronized (enumMap) {
                Map<BlockType, List<BlockTemplate>> allBlocksByType = this.blocksByID.values().stream().collect(Collectors.groupingBy(t -> t.getType()));
                this.blocksByType.clear();
                this.blocksByType.putAll(allBlocksByType);
            }
        }
    }

    static {
        CORR_STD_LENGTH = CorrelationScope.values().length - 1;
        corrStds = new EnumMap(CorrelationType.class);
        corrStds.put(CorrelationType.EVENT, new CorrelationStandard[]{new CorrelationStandard(CorrelationScope.ALL, CorrelationType.EVENT), new CorrelationStandard(CorrelationScope.OCCTWO, CorrelationType.EVENT), new CorrelationStandard(CorrelationScope.OCCALL, CorrelationType.EVENT)});
        corrStds.put(CorrelationType.SURFACE, new CorrelationStandard[]{new CorrelationStandard(CorrelationScope.ALL, CorrelationType.SURFACE), new CorrelationStandard(CorrelationScope.OCCTWO, CorrelationType.SURFACE), new CorrelationStandard(CorrelationScope.OCCALL, CorrelationType.SURFACE)});
        corrStds.put(CorrelationType.CHRONO, new CorrelationStandard[]{new CorrelationStandard(CorrelationScope.ALL, CorrelationType.CHRONO), new CorrelationStandard(CorrelationScope.OCCTWO, CorrelationType.CHRONO), new CorrelationStandard(CorrelationScope.OCCALL, CorrelationType.CHRONO)});
        corrStds.put(CorrelationType.LITHO, new CorrelationStandard[]{new CorrelationStandard(CorrelationScope.ALL, CorrelationType.LITHO), new CorrelationStandard(CorrelationScope.OCCTWO, CorrelationType.LITHO), new CorrelationStandard(CorrelationScope.OCCALL, CorrelationType.LITHO)});
        corrStds.put(CorrelationType.BIOZONE, new CorrelationStandard[]{new CorrelationStandard(CorrelationScope.ALL, CorrelationType.BIOZONE), new CorrelationStandard(CorrelationScope.OCCTWO, CorrelationType.BIOZONE), new CorrelationStandard(CorrelationScope.OCCALL, CorrelationType.BIOZONE)});
        object = new Object();
    }

    public static final class ChartOcc {
        public final Object type;
        public final Object what;
        public final String where;

        ChartOcc(Object type, Object what, String where) {
            this.type = type;
            this.what = what;
            this.where = where;
        }
    }

    public static class TaxonMerge {
        HashSet<Integer> panelSet;
        HashSet<Integer> corrTemplIDs;
        HashMap<SBEvent, SBEvent> eventMatches = new HashMap();
    }

    public static enum PANEL_STORE_OPTION {
        ASIS("Import all panel templates as-is"),
        SIMILAR("Use similar panel templates where possible"),
        DECOUPLE("Save all panels as decoupled templates");

        private final String descrip;

        private PANEL_STORE_OPTION(String descrip) {
            this.descrip = descrip;
        }

        public String toString() {
            return this.descrip;
        }
    }

    public static class TemplateComparator
    implements Comparator<TemplateDescr> {
        private Sort sort = Sort.ALPHA;

        public void setSort(Sort sort) {
            this.sort = sort;
        }

        @Override
        public int compare(TemplateDescr o1, TemplateDescr o2) {
            if (o1 instanceof PanelTemplate && o1 instanceof PanelTemplate && ((PanelTemplate)o1).getType() != ((PanelTemplate)o2).getType()) {
                return ((PanelTemplate)o1).getType().compareTo(((PanelTemplate)o2).getType());
            }
            if (o1 instanceof PanelTemplate && ((PanelTemplate)o1).isDefaultTemplate()) {
                return -1;
            }
            if (o2 instanceof PanelTemplate && ((PanelTemplate)o2).isDefaultTemplate()) {
                return 1;
            }
            if (o1.getProjID() < o2.getProjID()) {
                return -1;
            }
            if (o1.getProjID() > o2.getProjID()) {
                return 1;
            }
            switch (this.sort.ordinal()) {
                case 1: {
                    if (o1.getModified() != null && o2.getModified() != null) {
                        return o1.getModified().compareTo(o2.getModified());
                    }
                    if (!(o1.getModified() == null ^ o2.getModified() == null)) break;
                    return o1.getModified() != null ? 1 : -1;
                }
            }
            return o1.getName().compareTo(o2.getName());
        }

        public static enum Sort {
            ALPHA,
            MODIFIED;

        }
    }
}

