/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Date;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import jsbchart.util.ChartKeyData;
import model3.Lastval;
import model3.SBdb;
import util.AgeFormat;
import util.ColourUtils;
import util.SB;

public class ChartProperties {
    public float margin = 5.0f;
    public float panelCaptionHeight = 10.0f;
    public float panelExtCaptionHeight = 35.0f;
    private float panelHeaderHeight = 90.0f;
    public float panelSubHeaderHeight = this.panelHeaderHeight - this.panelCaptionHeight;
    public String font = "Arial";
    public float fontSize = 3.0f;
    public static final float FONT_FACTOR = 0.3527f;
    public static final float linePanelFrame = 0.4f;
    public static final float linePanelInternal = 0.2f;
    public static final float linePanelThinInternal = 0.1f;
    public boolean correctCuttings = false;
    public boolean correctDepths = true;
    public AgeFormat ageFormat = AgeFormat.MA;
    public float blankPanel = 10.0f;
    public boolean blankPanelRelative = false;
    public int bgSchID;
    public int bgHier;
    public float bgDensity = 0.3f;
    public boolean bgBlocks = true;
    public boolean bgPinchouts = true;
    public Color gapHatchColour = Color.CYAN;
    public boolean drawEmptyPanels = true;
    public boolean hideAdjacentBlankPanels = true;
    public boolean drawDisconformities = false;
    public boolean drawDisconfDuration = false;
    private ChartDatum datum = ChartDatum.NONE;
    private boolean drawCorrelationTicks = true;
    public boolean alignMaps = true;
    public boolean plotBlockCaptions = true;
    public float blockCapHeight = 10.0f;
    public boolean blockCapTop = true;
    public boolean blockCapAlignChart = true;
    public FontSize blockcapFontSize = FontSize.TINY;
    public PanelWellHeader.WellNameDisplay blockCapWellNameDisplay = PanelWellHeader.WellNameDisplay.NORMAL;
    public boolean greyscale = false;
    public boolean border = false;
    public PanelWellHeader header;
    public PanelKey key;
    public static final int PROP_FONT = 0;
    public static final int PROP_FONT_SIZE = 1;
    public static final int PROP_CORR = 2;
    public static final int PROP_CORR_CU = 3;
    public static final int PROP_CAP_HEIGHT = 4;
    public static final int PROP_HDR_HEIGHT = 5;
    public static final int PROP_MARGIN = 6;
    public static final int PROP_FOREGROUND = 7;
    public static final int PROP_BACKGROUND = 8;
    public static final int PROP_BLANKPANEL = 9;
    public static final int PROP_BG_HIER = 10;
    public static final int PROP_BG_DENSITY = 11;
    public static final int PROP_BG_BLOCKS = 12;
    public static final int PROP_EMPTY_PANELS = 13;
    public static final int PROP_BCAPS = 14;
    public static final int PROP_BCAP_HEIGHT = 15;
    public static final int PROP_BCAP_TOP = 16;
    public static final int PROP_BCAP_ALIGN = 17;
    public static final int PROP_NVFREEZE = 18;
    public static final int PROP_GAPHATCHCOLOUR = 19;
    public static final int PROP_GREYSCALE = 20;
    public static final int PROP_DISCONFS = 21;
    public static final int PROP_DISCONF_TEXT = 22;
    public static final int PROP_BCAPFONTSIZE = 23;
    public static final int PROP_BLANKRELATIVE = 24;
    public static final int PROP_BGPINCH = 25;
    public static final int PROP_BORDER = 26;
    public static final int PROP_EXTCAP_HEIGHT = 27;
    public static final int PROP_CORRTICK = 28;
    public static final int PROP_CHART_DATUM = 29;
    public static final int PROP_MAP_ALIGN = 30;
    public static final int PROP_BCAP_WELLNAMES = 31;
    private static final int nProps = 32;
    public Date chartGenDate = null;
    private static final Color FOREGROUND_COLOR_DEFAULT = Color.BLACK;
    private static final Color BACKGROUND_COLOR_DEFAULT = Color.WHITE;
    public Color foreground = Color.BLACK;
    public Color background = Color.WHITE;
    public Color accent = Color.LIGHT_GRAY;
    public Color accent2 = Color.DARK_GRAY;
    private Color cachedForeground;
    private Color cachedBackground;
    private static final short NVFREEZE_MAX = 8;
    private int nVfreeze = 1;
    final ChartKeyData keyData = new ChartKeyData();
    boolean keyIsVisible;
    public boolean requestHighResolution;

    public float getFontSize() {
        return this.fontSize;
    }

    public float getFontSizeSmall() {
        return this.fontSize * 0.83f;
    }

    public float getFontSizeTiny() {
        return this.fontSize * 0.64f;
    }

    public float getFontSizeXS() {
        return this.fontSize * 0.5f;
    }

    public float getFontSizePanel() {
        return this.fontSize * 1.27f;
    }

    public float getFontSizeXL() {
        return this.fontSize * 2.0f;
    }

    public float getFontSizeXXL() {
        return this.fontSize * 3.0f;
    }

    public float getFontSizeHeader() {
        return this.fontSize * 1.65f;
    }

    public void setChartDatum(ChartDatum value) {
        this.datum = value;
    }

    public ChartDatum getChartDatum() {
        return this.datum;
    }

    public ChartProperties() {
    }

    public void encode(SBdb sbdb) {
        String properties = this.getProperties();
        String schProp = "" + this.bgSchID;
        try {
            Lastval.putString((SBdb)sbdb, (String)"CHTPROP", (String)properties);
            Lastval.putString((SBdb)sbdb, (String)"CHTPROPSCH", (String)schProp);
            Lastval.putString((SBdb)sbdb, (String)"CHTPROPHDR", (String)this.getHeader());
            Lastval.putString((SBdb)sbdb, (String)"CHTPROPKEY", (String)this.getKey());
            sbdb.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void setSubHeaderHeight() {
        this.panelSubHeaderHeight = this.panelHeaderHeight - this.panelCaptionHeight;
    }

    public float getPanelHeaderHeight() {
        return this.panelHeaderHeight;
    }

    public boolean setPanelCaptionHeight(float panelCaptionHeight) {
        boolean changed = (double)Math.abs(this.panelCaptionHeight - panelCaptionHeight) > 0.001;
        this.panelCaptionHeight = panelCaptionHeight;
        if (this.panelCaptionHeight > this.panelExtCaptionHeight) {
            this.panelExtCaptionHeight = this.panelCaptionHeight;
        }
        this.setPanelHeaderHeight();
        return changed;
    }

    public boolean setPanelExtCaptionHeight(float panelExtCaptionHeight) {
        if (panelExtCaptionHeight < this.panelCaptionHeight || panelExtCaptionHeight > this.panelHeaderHeight) {
            return false;
        }
        boolean changed = (double)Math.abs(this.panelExtCaptionHeight - panelExtCaptionHeight) > 0.001;
        this.panelExtCaptionHeight = panelExtCaptionHeight;
        return changed;
    }

    public void setPanelHeaderHeight() {
        this.panelHeaderHeight = this.panelCaptionHeight + this.panelSubHeaderHeight;
    }

    public void setPanelHeaderHeight(float panelHeaderHeight) {
        this.panelHeaderHeight = panelHeaderHeight;
        this.setSubHeaderHeight();
    }

    public boolean setPanelSubHeaderHeight(float panelSubHeaderHeight) {
        boolean changed = (double)Math.abs(this.panelSubHeaderHeight - panelSubHeaderHeight) > 0.001;
        this.panelSubHeaderHeight = panelSubHeaderHeight;
        this.setPanelHeaderHeight();
        return changed;
    }

    public boolean setMargin(float margin) {
        boolean changed = Math.abs(this.margin - margin) > 1.0f;
        this.margin = margin;
        return changed;
    }

    public boolean setFontSize(float ptSize) {
        boolean change = false;
        float mmSize = ptSize * 0.3527f;
        if ((double)Math.abs(mmSize - this.fontSize) > 0.001) {
            change = true;
            this.fontSize = (float)SB.round((double)mmSize, (int)3);
        }
        return change;
    }

    public float getBlockTop() {
        return this.panelHeaderHeight + this.margin;
    }

    public String getProperties() {
        String[] props = new String[]{this.font, "" + this.fontSize, "" + (this.correctDepths ? 1 : 0), "" + (this.correctCuttings ? 1 : 0), "" + this.panelCaptionHeight, "" + this.panelHeaderHeight, "" + this.margin, ColourUtils.DBColourString((Color)this.foreground, (boolean)false, (boolean)false), ColourUtils.DBColourString((Color)this.background, (boolean)false, (boolean)false), "" + this.blankPanel, "" + this.bgHier, "" + this.bgDensity, "" + (this.bgBlocks ? 1 : 0), "" + (this.drawEmptyPanels ? 1 : 0), "" + (this.plotBlockCaptions ? 1 : 0), "" + this.blockCapHeight, "" + (this.blockCapTop ? 1 : 0), "" + (this.blockCapAlignChart ? 1 : 0), "" + this.nVfreeze, ColourUtils.DBColourString((Color)this.gapHatchColour, (boolean)false, (boolean)false), "" + (this.greyscale ? 1 : 0), "" + (this.drawDisconformities ? 1 : 0), "" + (this.drawDisconfDuration ? 1 : 0), this.blockcapFontSize.name(), "" + (this.blankPanelRelative ? 1 : 0), "" + (this.bgPinchouts ? 1 : 0), "" + (this.border ? 1 : 0), "" + this.panelExtCaptionHeight, "" + (this.drawCorrelationTicks ? 1 : 0), this.datum.name(), "" + (this.alignMaps ? 1 : 0), this.blockCapWellNameDisplay.name()};
        Object string = new String();
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    public String getHeader() {
        return this.header != null ? this.header.getProperties() : null;
    }

    public String getHeader(PanelWellHeader defaultForExclusions) {
        return this.header != null ? this.header.getProperties(defaultForExclusions) : null;
    }

    public String getKey() {
        return this.key != null ? this.key.getProperties() : null;
    }

    public ChartProperties(String props, int schID) {
        this.bgSchID = schID;
        if (props == null || props.trim().isEmpty()) {
            return;
        }
        String[] split = props.split("\\|");
        for (int i = 0; i < split.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.font = split[i];
                        break;
                    }
                    case 1: {
                        this.fontSize = Float.parseFloat(split[i]);
                        break;
                    }
                    case 2: {
                        this.correctDepths = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 3: {
                        this.correctCuttings = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 4: {
                        this.panelCaptionHeight = Float.parseFloat(split[i]);
                        break;
                    }
                    case 5: {
                        this.panelHeaderHeight = Float.parseFloat(split[i]);
                        break;
                    }
                    case 6: {
                        this.margin = Float.parseFloat(split[i]);
                        break;
                    }
                    case 7: {
                        this.foreground = ColourUtils.getColour((String)split[i]);
                        break;
                    }
                    case 8: {
                        this.background = ColourUtils.getColour((String)split[i]);
                        break;
                    }
                    case 9: {
                        this.blankPanel = Float.parseFloat(split[i]);
                        break;
                    }
                    case 10: {
                        this.bgHier = Integer.parseInt(split[i]);
                        break;
                    }
                    case 11: {
                        this.bgDensity = Float.parseFloat(split[i]);
                        break;
                    }
                    case 12: {
                        this.bgBlocks = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 13: {
                        this.drawEmptyPanels = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 14: {
                        this.plotBlockCaptions = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 15: {
                        this.blockCapHeight = Float.parseFloat(split[i]);
                        break;
                    }
                    case 27: {
                        this.panelExtCaptionHeight = Float.parseFloat(split[i]);
                        break;
                    }
                    case 16: {
                        this.blockCapTop = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 17: {
                        this.blockCapAlignChart = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 31: {
                        this.blockCapWellNameDisplay = PanelWellHeader.WellNameDisplay.valueOf(split[i]);
                        break;
                    }
                    case 18: {
                        this.setNvFreeze(Integer.parseInt(split[i]));
                        break;
                    }
                    case 19: {
                        this.gapHatchColour = ColourUtils.getColour((String)split[i]);
                        break;
                    }
                    case 20: {
                        this.greyscale = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 21: {
                        this.drawDisconformities = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 22: {
                        this.drawDisconfDuration = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 23: {
                        this.blockcapFontSize = FontSize.valueOf(split[i]);
                        break;
                    }
                    case 24: {
                        this.blankPanelRelative = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 25: {
                        this.bgPinchouts = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 26: {
                        this.border = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 28: {
                        this.drawCorrelationTicks = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 29: {
                        this.datum = ChartDatum.getValueFromPropString(split[i]);
                        break;
                    }
                    case 30: {
                        this.alignMaps = Integer.parseInt(split[i]) == 1;
                    }
                }
                continue;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return;
            }
        }
        this.setSubHeaderHeight();
    }

    public float getFontSize(FontSizeExtended fontSize) {
        switch (fontSize.ordinal()) {
            case 0: {
                return this.getFontSizeXXL();
            }
            case 1: {
                return this.getFontSizeXL();
            }
            default: {
                return this.getFontSizePanel();
            }
            case 3: {
                return this.getFontSizeSmall();
            }
            case 4: 
        }
        return this.getFontSizeTiny();
    }

    public float getFontSize(FontSize fontSize) {
        switch (fontSize.ordinal()) {
            case 0: {
                return this.getFontSizePanel();
            }
            case 1: {
                return this.getFontSize();
            }
            case 2: {
                return this.getFontSizeSmall();
            }
        }
        assert (false);
        return 0.0f;
    }

    public float getGiantFontSize(FontSize fontSize) {
        switch (fontSize.ordinal()) {
            default: {
                assert (false);
            }
            case 2: {
                return this.getFontSizeHeader();
            }
            case 1: {
                return this.fontSize * 2.33f;
            }
            case 0: 
        }
        return this.fontSize * 4.23f;
    }

    public boolean setFont(String font) {
        if (font.equalsIgnoreCase(this.font)) {
            return false;
        }
        this.font = font;
        return true;
    }

    public boolean setCorrections(boolean correctDepths, boolean correctCuttings) {
        boolean changed = this.correctCuttings != correctCuttings || this.correctDepths != correctDepths;
        this.correctDepths = correctDepths;
        this.correctCuttings = correctCuttings;
        return changed;
    }

    public boolean setAgeFormat(AgeFormat format) {
        boolean changed = this.ageFormat != format;
        this.ageFormat = format;
        return changed;
    }

    public boolean setBlankPanel(float blankPanel, boolean relative) {
        boolean changed = Math.abs(this.blankPanel - blankPanel) > 1.0f || relative != this.blankPanelRelative;
        this.blankPanel = blankPanel;
        this.blankPanelRelative = relative;
        return changed;
    }

    public boolean setSchID(int schID) {
        boolean changed = this.bgSchID != schID;
        this.bgSchID = schID;
        return changed;
    }

    public boolean setHier(int hier) {
        boolean changed = this.bgHier != hier;
        this.bgHier = hier;
        return changed;
    }

    public boolean setBorder(boolean border) {
        boolean changed = this.border != border;
        this.border = border;
        return changed;
    }

    public boolean setMapAlign(boolean alignMaps) {
        boolean changed = this.alignMaps != alignMaps;
        this.alignMaps = alignMaps;
        return changed;
    }

    public boolean setbgDensity(float density) {
        boolean changed = false;
        if (density >= 0.0f && density <= 1.0f) {
            changed = (double)Math.abs(this.bgDensity - density) > 0.05;
            this.bgDensity = density;
        }
        return changed;
    }

    public boolean setbgBlocks(boolean b) {
        if (b != this.bgBlocks) {
            this.bgBlocks = b;
            return true;
        }
        return false;
    }

    public boolean setBlockCapWellNameDisplay(PanelWellHeader.WellNameDisplay displayName) {
        boolean changed = this.blockCapWellNameDisplay != displayName;
        this.blockCapWellNameDisplay = displayName;
        return changed;
    }

    public boolean setbgPinchouts(boolean b) {
        if (b != this.bgPinchouts) {
            this.bgPinchouts = b;
            return true;
        }
        return false;
    }

    public boolean setDrawEmptyPanels(boolean b) {
        if (b != this.drawEmptyPanels) {
            this.drawEmptyPanels = b;
            return true;
        }
        return false;
    }

    public boolean setDrawDisconfs(boolean b) {
        if (b != this.drawDisconformities) {
            this.drawDisconformities = b;
            return true;
        }
        return false;
    }

    public boolean setDrawDisconfDuration(boolean b) {
        if (b != this.drawDisconfDuration) {
            this.drawDisconfDuration = b;
            return true;
        }
        return false;
    }

    public boolean setBlockCap(boolean drawBlockCaps, float capHeight, boolean top, boolean align, FontSize fontSize) {
        boolean change = this.plotBlockCaptions != drawBlockCaps || Math.abs(capHeight - this.blockCapHeight) > 1.0f || this.blockCapTop != top || this.blockCapAlignChart != align || fontSize != this.blockcapFontSize;
        this.plotBlockCaptions = drawBlockCaps;
        this.blockCapHeight = capHeight;
        this.blockCapTop = top;
        this.blockCapAlignChart = align;
        this.blockcapFontSize = fontSize;
        return change;
    }

    public void setTemplateColourScheme() {
        this.cachedForeground = this.foreground;
        this.cachedBackground = this.background;
        this.foreground = Color.DARK_GRAY;
        this.background = new Color(160, 170, 227);
    }

    public void restoreCachedColourScheme() {
        this.foreground = this.cachedForeground != null ? this.cachedForeground : FOREGROUND_COLOR_DEFAULT;
        this.background = this.cachedBackground != null ? this.cachedBackground : BACKGROUND_COLOR_DEFAULT;
    }

    public boolean setForeground(Color colour) {
        if (!colour.equals(this.foreground)) {
            this.foreground = colour;
            return true;
        }
        return false;
    }

    public boolean setBackground(Color colour) {
        if (!colour.equals(this.background)) {
            this.background = colour;
            return true;
        }
        return false;
    }

    public boolean setGapHatchColour(Color colour) {
        if (!colour.equals(this.gapHatchColour)) {
            this.gapHatchColour = colour;
            return true;
        }
        return false;
    }

    public boolean setGreyscale(boolean b) {
        if (b != this.greyscale) {
            this.greyscale = b;
            return true;
        }
        return false;
    }

    float getHeaderFooterHeight(boolean header) {
        float height = 0.0f;
        if (this.header != null && this.header.orientation == (header ? PanelWellHeader.Orientation.TOP : PanelWellHeader.Orientation.BOTTOM)) {
            height += this.header.height;
        }
        if (this.key != null && this.key.orientation == (header ? PanelKey.Orientation.TOP : PanelKey.Orientation.BOTTOM)) {
            height += this.key.height;
        }
        return height;
    }

    public int getnVfreeze() {
        return this.nVfreeze;
    }

    public final boolean setNvFreeze(int nVfreeze) {
        if (nVfreeze < 1) {
            nVfreeze = 1;
        } else if (nVfreeze > 8) {
            nVfreeze = 8;
        }
        if (this.nVfreeze == nVfreeze) {
            return false;
        }
        this.nVfreeze = nVfreeze;
        return true;
    }

    public boolean keyIsVisible() {
        return this.keyIsVisible;
    }

    public ChartKeyData getKeyData() {
        return this.keyData;
    }

    public boolean isDrawCorrelationTicks() {
        return this.drawCorrelationTicks;
    }

    public boolean setDrawCorrelationTicks(boolean drawCorrelationTicks) {
        if (this.drawCorrelationTicks == drawCorrelationTicks) {
            return false;
        }
        this.drawCorrelationTicks = drawCorrelationTicks;
        return true;
    }

    void clearNonPrefFields() {
        if (this.header != null) {
            this.header.enclosure = "";
            this.header.title = "";
        }
    }

    public static enum ChartDatum {
        NONE("None"),
        RT("Rotary Table"),
        SL("Sea Level"),
        SB("Sea Bed");

        private final String description;

        private ChartDatum(String name) {
            this.description = name;
        }

        public String toString() {
            return this.description;
        }

        public static ChartDatum getValueFromPropString(String prop) {
            switch (prop) {
                default: {
                    return NONE;
                }
                case "RT": {
                    return RT;
                }
                case "SL": {
                    return SL;
                }
                case "SB": 
                case "1": 
            }
            return SB;
        }
    }

    public static enum FontSize {
        PANEL("Large"),
        SMALL("Normal"),
        TINY("Small");

        String stringName;

        private FontSize(String stringName) {
            this.stringName = stringName;
        }

        public String toString() {
            return this.stringName;
        }
    }

    public static enum FontSizeExtended {
        XXL("XXL"),
        XL("XL"),
        PANEL("Large"),
        SMALL("Normal"),
        TINY("Small");

        String stringName;

        private FontSizeExtended(String stringName) {
            this.stringName = stringName;
        }

        public String toString() {
            return this.stringName;
        }

        public FontSize convertToFontSize() {
            switch (this.ordinal()) {
                default: {
                    return FontSize.PANEL;
                }
                case 3: {
                    return FontSize.SMALL;
                }
                case 4: 
            }
            return FontSize.TINY;
        }
    }
}

