/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.sample.SampleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jsbchart.core.AbstractLegend;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import jsbchart.graphics.SBGraphics;
import jsbchart.util.ChartKeyData;
import model3.EnvScheme;
import model3.Lithology;
import model3.TxGroup;

public class PanelKey
extends AbstractLegend {
    public Orientation orientation = Orientation.RIGHT;
    public boolean border = true;
    public float height = 50.0f;
    public boolean text = true;
    public boolean bndKey = true;
    public boolean lithBase = true;
    public boolean lithQual = true;
    public boolean sampling = true;
    public boolean abnSchemes = true;
    public boolean correlationLines = true;
    public boolean txGroups = true;
    public boolean envSchemes = true;
    public boolean categories = true;

    public PanelKey() {
    }

    public PanelKey(String prop) {
        if (prop == null || prop.trim().isEmpty()) {
            return;
        }
        String[] s = prop.split("\\|");
        block15: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.orientation = Orientation.valueOf(s[i]);
                    continue block15;
                }
                case 1: {
                    this.text = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 2: {
                    this.bndKey = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 3: {
                    this.height = Float.parseFloat(s[i]);
                    continue block15;
                }
                case 4: {
                    this.border = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 5: {
                    this.lithBase = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 6: {
                    this.lithQual = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 7: {
                    this.abnSchemes = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 8: {
                    this.correlationLines = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 9: {
                    this.sampling = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 10: {
                    this.txGroups = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 11: {
                    this.envSchemes = Integer.parseInt(s[i]) == 1;
                    continue block15;
                }
                case 12: {
                    this.categories = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    public float draw(SBGraphics g, float x, float y, float w, float h, ChartProperties cp) {
        List<AbstractLegend.TextItem> items = this.generateItemList(cp);
        super.draw(g, x, y, w, h, cp, items, this.border);
        return y + h;
    }

    private List<AbstractLegend.TextItem> generateItemList(ChartProperties cp) {
        LinkedList<AbstractLegend.TextItem> items = new LinkedList<AbstractLegend.TextItem>();
        List<Object> unplacedText = cp.getKeyData().getUnplacedText();
        if (this.text && !unplacedText.isEmpty()) {
            items.add(new AbstractLegend.TextItem("Text Keys", null));
            for (int i = 0; i < unplacedText.size(); ++i) {
                items.add(new AbstractLegend.TextItem("*" + (i + 1), unplacedText.get(i)));
            }
        }
        if (this.correlationLines && cp.getKeyData().hasCorr()) {
            items.add(new AbstractLegend.TextItem("Correlation Lines", null));
            for (Correlation correlation : cp.getKeyData().getCorrelations()) {
                if (correlation.getTemplateID() <= 0) {
                    items.add(new AbstractLegend.TextItem(correlation.getDefaultLineStyle(), correlation.toString()));
                    continue;
                }
                assert (false);
            }
            for (Map.Entry entry : cp.getKeyData().getCorrLines().entrySet()) {
                CorrLineStyle style = (CorrLineStyle)entry.getValue();
                if (style.getColour() == null) {
                    style = new CorrLineStyle(style.getProperties());
                    style.setColour(((CorrelationLine)entry.getKey()).getColour());
                }
                items.add(new AbstractLegend.TextItem(style, ((CorrelationLine)entry.getKey()).toString()));
            }
        }
        if (this.lithBase && !cp.getKeyData().getLithInt().isEmpty()) {
            LinkedList<Lithology> lithInt = new LinkedList<Lithology>(cp.getKeyData().getLithInt());
            Collections.sort(lithInt);
            items.add(new AbstractLegend.TextItem("Base Lithology", null));
            for (Lithology lith : lithInt) {
                items.add(new AbstractLegend.TextItem(lith, lith.getDescr()));
            }
        }
        if (this.lithQual && !cp.getKeyData().getLithQual().isEmpty()) {
            LinkedList<Lithology> lithQuals = new LinkedList<Lithology>(cp.getKeyData().getLithQual());
            Collections.sort(lithQuals);
            items.add(new AbstractLegend.TextItem("Lithology Qualifiers", null));
            for (Lithology lith : lithQuals) {
                items.add(new AbstractLegend.TextItem(lith, lith.getDescr()));
            }
        }
        Set<Boundary> bnds = cp.getKeyData().getBnds();
        if (this.bndKey && !bnds.isEmpty()) {
            items.add(new AbstractLegend.TextItem("Boundary Types", null));
            for (Boundary bnd : Boundary.values()) {
                if (!bnds.contains(bnd)) continue;
                items.add(new AbstractLegend.TextItem(bnd, bnd.toString()));
            }
        }
        if (this.sampling) {
            items.add(new AbstractLegend.TextItem("Sampling", null));
            items.add(new AbstractLegend.TextItem(SampleType.CU, "Cutting"));
            items.add(new AbstractLegend.TextItem(SampleType.CO, "Core"));
            items.add(new AbstractLegend.TextItem(SampleType.SC, "Sidewall Core"));
        }
        if (this.abnSchemes) {
            for (ChartKeyData.AbundanceSchemeColor abnColor : cp.getKeyData().getAbnSchemes()) {
                AbundanceScheme sch = abnColor.abundanceScheme();
                items.add(new AbstractLegend.TextItem(sch, null));
                float iWidth = 2.5f / (float)sch.getEntryCount();
                for (int i = 0; i < sch.getEntryCount(); ++i) {
                    AbundanceScheme.AbundanceSchemeEntry e = sch.getEntry(i);
                    String s = e.entryName() + " (" + e.outputVal() + (String)(i == sch.getEntryCount() - 1 ? "+" : (Math.abs(e.outputVal() - (sch.getEntry(i + 1).outputVal() - 1)) > 0 ? "-" + (sch.getEntry(i + 1).outputVal() - 1) : "")) + ")";
                    items.add(new AbstractLegend.TextItem(new AbstractLegend.FloatColor((float)(i + 1) * iWidth, abnColor.color()), s));
                }
            }
        }
        if (this.txGroups && !cp.getKeyData().getTxGroups().isEmpty()) {
            items.add(new AbstractLegend.TextItem("Taxon Groups", null));
            ArrayList<TxGroup> arrayList = new ArrayList<TxGroup>(cp.getKeyData().getTxGroups());
            Collections.sort(arrayList);
            for (TxGroup group : arrayList) {
                items.add(new AbstractLegend.TextItem(group.getColour(), group.getName() + (String)(group.getDescr() != null ? " - " + group.getDescr() : "")));
            }
        }
        if (this.categories && !cp.getKeyData().getCategories().isEmpty()) {
            items.add(new AbstractLegend.TextItem("Taxon Categories", null));
            ArrayList<Category> arrayList = new ArrayList<Category>(cp.getKeyData().getCategories());
            Collections.sort(arrayList);
            for (Category cat : arrayList) {
                items.add(new AbstractLegend.TextItem(cat.getColour(), cat.getMnemonic() + " - " + cat.getName()));
            }
        }
        if (this.envSchemes && !cp.getKeyData().getEnvSchemes().isEmpty()) {
            for (EnvScheme envSch : cp.getKeyData().getEnvSchemes()) {
                items.add(new AbstractLegend.TextItem("Environment: " + envSch.getName(), null));
                for (int i = 1; i <= envSch.getNClasses(); ++i) {
                    items.add(new AbstractLegend.TextItem(envSch.getColour(i), envSch.getTerm(i, true)));
                }
            }
        }
        return items;
    }

    float getHeight() {
        return this.height;
    }

    public String toString() {
        return "Chart Key";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelKey other = (PanelKey)obj;
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        if (this.text != other.text) {
            return false;
        }
        if (this.border != other.border) {
            return false;
        }
        if (this.lithBase != other.lithBase) {
            return false;
        }
        if (this.lithQual != other.lithQual) {
            return false;
        }
        if (this.sampling != other.sampling) {
            return false;
        }
        if (this.abnSchemes != other.abnSchemes) {
            return false;
        }
        if (this.envSchemes != other.envSchemes) {
            return false;
        }
        if (this.correlationLines != other.correlationLines) {
            return false;
        }
        if (this.txGroups != other.txGroups) {
            return false;
        }
        if (this.categories != other.categories) {
            return false;
        }
        return this.bndKey == other.bndKey;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode((Object)this.orientation);
        hash = 37 * hash + (this.border ? 1 : 0);
        hash = 37 * hash + Float.floatToIntBits(this.height);
        hash = 37 * hash + (this.text ? 1 : 0);
        hash = 37 * hash + (this.bndKey ? 1 : 0);
        hash = 37 * hash + (this.lithBase ? 1 : 0);
        hash = 37 * hash + (this.lithQual ? 1 : 0);
        hash = 37 * hash + (this.sampling ? 1 : 0);
        hash = 37 * hash + (this.abnSchemes ? 1 : 0);
        hash = 37 * hash + (this.correlationLines ? 1 : 0);
        hash = 37 * hash + (this.txGroups ? 1 : 0);
        hash = 37 * hash + (this.envSchemes ? 1 : 0);
        hash = 37 * hash + (this.categories ? 1 : 0);
        return hash;
    }

    String getProperties() {
        String[] props = new String[]{this.orientation.name(), "" + (this.text ? 1 : 0), "" + (this.bndKey ? 1 : 0), "" + this.height, "" + (this.border ? 1 : 0), "" + (this.lithBase ? 1 : 0), "" + (this.lithQual ? 1 : 0), "" + (this.abnSchemes ? 1 : 0), "" + (this.correlationLines ? 1 : 0), "" + (this.sampling ? 1 : 0), "" + (this.txGroups ? 1 : 0), "" + (this.envSchemes ? 1 : 0), "" + (this.categories ? 1 : 0)};
        Object string = new String();
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    public static enum Orientation {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

