/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import model3.IGDScheme;
import model3.InterpHdr;
import util.SB;
import util.SBObservable;

public class PanelOcc
extends SBObservable {
    public final int panelID;
    private Integer interpID;
    private String caption;
    private String subcaption;
    private int schID;
    private BlockTemplate.CaptionOrientation capOrient = BlockTemplate.CaptionOrientation.getDefault();
    private Integer panelNo;
    public static final int PROP_CAPTION = 0;
    public static final int PROP_SUBCAPTION = 1;
    public static final int PROP_CAPORIENT = 2;
    public static final int PROP_OVERPLOT = 3;
    public static final int PROP_VERSION = 4;
    public static final int PROP_SCHEME = 5;
    public static final int N_PROPS = 6;

    public PanelOcc(int panelID) {
        this.panelID = panelID;
    }

    public PanelOcc(int panelID, Integer interpID, String caption, String subcaption, int panelNo) {
        this(panelID, interpID, caption, subcaption, null, 0);
        this.panelNo = panelNo;
    }

    public PanelOcc(int panelID, Integer interpID, String caption, String subcaption, BlockTemplate.CaptionOrientation capOrient, int schID) {
        this.panelID = panelID;
        this.interpID = interpID;
        this.caption = caption;
        this.subcaption = subcaption;
        this.capOrient = capOrient != null ? capOrient : BlockTemplate.CaptionOrientation.getDefault();
        this.schID = schID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PanelOcc) {
            PanelOcc rhs = (PanelOcc)((Object)obj);
            if (rhs.getPanelID() != this.panelID) {
                return false;
            }
            if (!SB.equal((Object)rhs.getInterpID(), (Object)this.interpID)) {
                return false;
            }
            if (rhs.caption == null ^ this.caption == null) {
                return false;
            }
            if (rhs.caption != null && this.caption != null && !rhs.caption.equals(this.caption)) {
                return false;
            }
            if (rhs.subcaption == null ^ this.subcaption == null) {
                return false;
            }
            if (rhs.subcaption != null && this.subcaption != null && !rhs.subcaption.equals(this.subcaption)) {
                return false;
            }
            if (this.capOrient != rhs.capOrient) {
                return false;
            }
            return rhs.schID == this.schID;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.panelID;
        hash = 37 * hash + (this.interpID != null ? this.interpID.hashCode() : 0);
        hash = 37 * hash + (this.caption != null ? this.caption.hashCode() : 0);
        hash = 37 * hash + (this.subcaption != null ? this.subcaption.hashCode() : 0);
        hash = 37 * hash + this.capOrient.hashCode();
        hash = 37 * hash + this.schID;
        return hash;
    }

    public int getPanelID() {
        return this.panelID;
    }

    public Integer getInterpID() {
        return this.interpID;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getSubCaption() {
        return this.subcaption;
    }

    public int getSchID() {
        return this.schID;
    }

    public BlockTemplate.CaptionOrientation getCapOrient() {
        return this.capOrient;
    }

    public Integer getPanelNo() {
        return this.panelNo;
    }

    public void setPanelNo(Integer panelNo) {
        this.panelNo = panelNo;
    }

    public static String getPropertyName(int nProp) {
        switch (nProp) {
            case 0: {
                return "Caption";
            }
            case 1: {
                return "Sub caption";
            }
            case 2: {
                return "Caption orientation";
            }
            case 3: {
                return "Overplot";
            }
            case 4: {
                return "Version";
            }
            case 5: {
                return "Scheme";
            }
        }
        return "";
    }

    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.getCaption();
            }
            case 1: {
                return this.getSubCaption();
            }
            case 2: {
                return this.getCapOrient();
            }
            case 3: {
                return null;
            }
            case 4: {
                return this.getInterpID();
            }
            case 5: {
                return this.getSchID();
            }
        }
        return null;
    }

    public static Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: 
            case 1: {
                return CaptionTemplate.class;
            }
            case 2: {
                return BlockTemplate.CaptionOrientation.class;
            }
            case 3: {
                return Boolean.class;
            }
            case 4: {
                return InterpHdr.class;
            }
            case 5: {
                return IGDScheme.class;
            }
        }
        return Object.class;
    }

    public boolean setProperty(int nProp, Object prop) {
        switch (nProp) {
            case 0: {
                return this.setCaption((String)prop);
            }
            case 1: {
                return this.setSubCaption((String)prop);
            }
            case 2: {
                return this.setCaptionOrientation((BlockTemplate.CaptionOrientation)((Object)prop));
            }
            case 3: {
                return this.setOverplot((Boolean)prop);
            }
            case 4: {
                return this.setInterpID((Integer)prop);
            }
            case 5: {
                return this.setSchID((Integer)prop);
            }
        }
        return false;
    }

    private boolean setCaption(String caption) {
        if (caption == null ^ this.caption == null || caption != null && !caption.equals(this.caption)) {
            this.caption = caption;
            return true;
        }
        return false;
    }

    private boolean setSubCaption(String caption) {
        if (this.subcaption == null ^ caption == null || caption != null && !caption.equals(this.subcaption)) {
            this.subcaption = caption;
            return true;
        }
        return false;
    }

    private boolean setInterpID(Integer interpID) {
        if (interpID == null ^ this.interpID == null || interpID != null && this.interpID != null && !interpID.equals(this.interpID)) {
            this.interpID = interpID;
            return true;
        }
        return false;
    }

    private boolean setSchID(int schID) {
        if (schID != this.schID) {
            this.schID = schID;
            return true;
        }
        return false;
    }

    private boolean setCaptionOrientation(BlockTemplate.CaptionOrientation capOrient) {
        if (this.capOrient != capOrient) {
            this.capOrient = capOrient;
            return true;
        }
        return false;
    }

    private boolean setOverplot(boolean overplot) {
        BlockTemplate.CaptionOrientation massiveHack = overplot ? BlockTemplate.CaptionOrientation.getNotDefault() : BlockTemplate.CaptionOrientation.getDefault();
        return this.setCaptionOrientation(massiveHack);
    }

    public static PanelOcc copy(PanelOcc rhs) {
        PanelOcc occ = new PanelOcc(rhs.panelID, rhs.interpID, rhs.caption, rhs.subcaption, rhs.capOrient, rhs.schID);
        return occ;
    }

    public void copyFields(PanelOcc rhs) {
        if (this.equals((Object)rhs)) {
            return;
        }
        this.interpID = rhs.interpID;
        this.caption = rhs.caption;
        this.subcaption = rhs.subcaption;
        this.schID = rhs.schID;
        this.capOrient = rhs.capOrient;
        this.setChanged();
    }
}

