/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.core;

import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.ChartFactory;
import jsbchart.core.ChartManager;
import jsbchart.core.TemplateDescr;
import jsbchart.core.TemplateNotifierService;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertiesBuilder;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.PanelType;
import model3.Audit;
import model3.CompositeStandard;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import org.jdom2.Element;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.listener.WeakListenerList;

public class PanelTemplate
extends SBRestrictable
implements TemplateDescr {
    private final WeakListenerList<Listener> listeners = new WeakListenerList();
    private final int ID;
    private final PanelType type;
    private final boolean isVisible;
    private String descr;
    private String comments;
    private boolean defaultTemplate;
    private int projID;
    private Audit audit;
    private int nUsages = -1;
    private final PanelProperties properties;
    private PanelProperties tempProp = null;
    public static final Object INNER_PANEL_MOVED = new Object();
    private boolean externallyReloaded = false;
    private PanelTemplate link;

    public PanelTemplate(PanelType type, int ID, boolean isVisible, String descr, String comments, boolean defaultTemplate, PanelProperties properties, int projID, Audit audit, int acm) {
        super("CHTPANL", "PANEL_ID", false);
        this.type = type;
        this.ID = ID;
        this.isVisible = isVisible;
        this.descr = descr;
        this.comments = comments;
        this.defaultTemplate = defaultTemplate;
        this.properties = properties;
        this.projID = projID;
        this.audit = audit == null ? new Audit() : audit;
        this.setAcm(acm);
    }

    @Override
    public PanelType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.descr;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    public boolean isDefaultTemplate() {
        return this.defaultTemplate;
    }

    public int getID() {
        return this.ID;
    }

    @Override
    public int getProjID() {
        return this.projID;
    }

    @Override
    public boolean hasWellList() {
        return false;
    }

    @Override
    public int getWellListID() {
        return 0;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public String toParentString() {
        return this.toString();
    }

    public synchronized PanelProperties getProperties() {
        return this.properties;
    }

    public PanelProperties getEditableProp() {
        if (this.tempProp != null) {
            return this.tempProp;
        }
        return this.getProperties();
    }

    void setEditableProp(PanelProperties newProp) {
        if (this.isVisible) {
            throw new IllegalStateException("You can't update all the properties at once for standard panel templates");
        }
        if (newProp.getClass() != this.properties.getClass()) {
            throw new IllegalArgumentException("Wrong type of properties for panel template");
        }
        if (this.tempProp == this.properties) {
            throw new IllegalArgumentException("This is just silly");
        }
        this.tempProp = newProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(Object o, int nProp) {
        if (this.tempProp == null) {
            this.tempProp = this.properties.copy();
            this.listeners.notify(l -> l.onTemplateEditingStarted(this.tempProp));
        }
        if (this.tempProp.setProperty(nProp, o)) {
            this.listeners.notify(l -> l.onTemplatePropertyChanged(this.tempProp));
        }
        PanelTemplate panelTemplate = this;
        synchronized (panelTemplate) {
            if (this.tempProp.equals(this.properties)) {
                this.clearTempProp();
                this.listeners.notify(l -> l.onTemplateEditingFinished(true));
            }
        }
    }

    public boolean isEditing() {
        return this.tempProp != null;
    }

    public String toString() {
        Object s = this.descr;
        if (this.defaultTemplate) {
            s = (String)s + " (default)";
        }
        return s;
    }

    synchronized void store(SBdb sbdb) throws SQLException {
        if (this.ID < 1) {
            throw new IllegalStateException("Attempt to store panel template with ID: " + this.ID);
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("CHTPANL") + " (panel_id,type,isvisible,descr,comments,isdefault,prop,proj_id,sch_id,std_id,envsch_id,synsch_id,grpset_id,agecurve_id,shape_id," + Audit.sqlFieldString() + ") VALUES (" + this.ID + "," + SB.DBString((String)this.type.name()) + "," + SB.DBChar((char)(this.isVisible ? (char)'Y' : 'N')) + ",?,?," + SB.DBChar((char)(this.isDefaultTemplate() ? (char)'Y' : 'N')) + "," + SB.DBString((String)this.properties.getPropertiesString()) + "," + String.valueOf(this.projID > 0 ? Integer.valueOf(this.projID) : "NULL") + "," + String.valueOf(this.properties.getIGDSchemeID() > 0 ? Integer.valueOf(this.properties.getIGDSchemeID()) : "NULL") + "," + String.valueOf(this.properties.getCmpStdID() > 0 ? Integer.valueOf(this.properties.getCmpStdID()) : "NULL") + "," + String.valueOf(this.properties.getEnvSchID() > 0 ? Integer.valueOf(this.properties.getEnvSchID()) : "NULL") + "," + String.valueOf(this.properties.getSynSchID() > 0 ? Integer.valueOf(this.properties.getSynSchID()) : "NULL") + "," + String.valueOf(this.properties.getGrpSetID() > 0 ? Integer.valueOf(this.properties.getGrpSetID()) : "NULL") + "," + String.valueOf(this.properties.getAgeCurveID() > 0 ? Integer.valueOf(this.properties.getAgeCurveID()) : "NULL") + "," + String.valueOf(this.properties.getShapeStoreID() > 0 ? Integer.valueOf(this.properties.getShapeStoreID()) : "NULL") + "," + this.audit.sqlInsert(sbdb, null) + ")";
            try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                pStmt.setString(1, this.descr);
                pStmt.setString(2, this.comments);
                pStmt.executeUpdate();
            }
            this.storeRelated(sbdb, stmt, this.properties);
        }
    }

    public void restoreSavedProperties() {
        if (this.tempProp == null) {
            return;
        }
        this.clearTempProp();
        this.listeners.notify(l -> l.onTemplateEditingFinished(true));
    }

    private void checkProjectChange(SBdb sbdb, Statement stmt, int newProjID) throws SQLException, InvalidFieldException {
        ResultSet rs;
        String sql;
        if (this.properties.getGrpSetID() > 0) {
            sql = "SELECT proj_id FROM " + sbdb.DBTableName("GROUPSET") + " WHERE grpset_id=" + this.properties.getGrpSetID();
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int grpSetProjID = rs.getInt("proj_id");
                if (grpSetProjID <= 0 || grpSetProjID == newProjID) continue;
                throw new InvalidFieldException("Can't update project: panel uses a non-global group set");
            }
        }
        if (PanelType.isTaxonPanel(this.type)) {
            int count;
            int count2;
            sql = "SELECT count(panel_id) as c FROM " + sbdb.DBTableName("CHTPANLMBR") + " m, " + sbdb.DBTableName("TXGROUP") + " g WHERE g.proj_id > 0 AND g.proj_id <> " + newProjID + " AND m.panel_id=" + this.ID + " AND (g.grp_id=m.grp_id OR g.grp_id=m.exclude_grp_id OR g.grp_id=m.highlight_grp_id)";
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next() && (count2 = rs.getInt("c")) > 0) {
                Object msg = "Can't update project: ";
                msg = !this.isVisible ? (String)msg + "a local " + this.type.getNoun().toLowerCase() + " panel template" : (String)msg + "panel " + this.descr;
                msg = (String)msg + " is using a non-global group";
                throw new InvalidFieldException((String)msg);
            }
            String sql2 = "SELECT count(panel_id) as c FROM " + sbdb.DBTableName("CHTPANLMBR") + " m, " + sbdb.DBTableName("GROUPSET") + " g WHERE g.proj_id > 0 AND g.proj_id <> " + newProjID + " AND m.panel_id=" + this.ID + " AND m.grpset_id=g.grpset_id";
            rs = stmt.executeQuery(sbdb.modQuery(sql2));
            if (rs.next() && (count = rs.getInt("c")) > 0) {
                Object msg = "Can't update project: ";
                msg = !this.isVisible ? (String)msg + "a local " + this.type.getNoun().toLowerCase() + " panel template" : (String)msg + "panel " + this.descr;
                msg = (String)msg + " is using a non-global group set";
                throw new InvalidFieldException((String)msg);
            }
        }
        if (newProjID == 0) {
            return;
        }
        sql = "SELECT DISTINCT c.proj_id as proj_id from " + sbdb.DBTableName("CHTBLOCK") + " c, " + sbdb.DBTableName("CHTBLOCKMBR") + " m WHERE m.panel_id=" + this.ID + " AND c.block_id=m.block_id";
        rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int pID = rs.getInt("proj_id");
            if (pID == 0 || pID == newProjID) continue;
            throw new InvalidFieldException("Can't update project: panel is a member of non-global block templates");
        }
    }

    public synchronized boolean updateDescr(SBdb sbdb, String descr, String comments, int projID) throws SQLException, InvalidFieldException, SBPermissionException {
        if (this.ID < 1) {
            throw new IllegalStateException("Attempt to store panel template with ID: " + this.ID);
        }
        if (comments == null) {
            comments = "";
        }
        if (Objects.equals(descr, this.descr) && comments.equals(this.comments) && projID == this.projID) {
            return false;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException("Can't update read-only panel template: " + this.getName());
            }
            if (!Objects.equals(descr, this.descr) && descr != null && !descr.isEmpty()) {
                ChartManager.checkNewTemplateName(sbdb, descr, this.type, projID);
            }
            if (projID != this.projID) {
                this.checkProjectChange(sbdb, stmt, projID);
            }
            String sql = "UPDATE " + sbdb.DBTableName("CHTPANL") + " set descr=?,comments=?,proj_id=" + String.valueOf(projID > 0 ? Integer.valueOf(projID) : "NULL") + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE PANEL_ID=" + this.ID;
            try (PreparedStatement pStmt = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));){
                pStmt.setString(1, descr);
                pStmt.setString(2, comments);
                pStmt.executeUpdate();
            }
        }
        this.descr = descr;
        this.comments = comments;
        this.projID = projID;
        return true;
    }

    synchronized void updateDescr(SBdb sbdb, boolean isDefaultTemplate) throws SQLException {
        if (this.ID < 1) {
            throw new IllegalStateException("Attempt to store panel template with ID: " + this.ID);
        }
        if (this.defaultTemplate == isDefaultTemplate) {
            return;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = isDefaultTemplate ? "UPDATE " + sbdb.DBTableName("CHTPANL") + " set isdefault=" + SB.DBChar((char)(isDefaultTemplate ? (char)'Y' : 'N')) + " WHERE PANEL_ID=" + this.ID : "UPDATE " + sbdb.DBTableName("CHTPANL") + " set isdefault=" + SB.DBChar((char)'N') + " WHERE TYPE=" + SB.DBString((String)this.type.name());
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    void setDefaultTemplate(boolean isDefaultTemplate) {
        this.defaultTemplate = isDefaultTemplate;
    }

    void setGlobal() {
        this.projID = 0;
    }

    public synchronized void update(SBdb sbdb) throws SQLException, SBPermissionException {
        if (this.tempProp == null) {
            return;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(sbdb, "panel template", true));
            }
            String sql = "UPDATE " + sbdb.DBTableName("CHTPANL") + " set prop=" + SB.DBString((String)this.tempProp.getPropertiesString()) + ",sch_id=" + String.valueOf(this.tempProp.getIGDSchemeID() > 0 ? Integer.valueOf(this.tempProp.getIGDSchemeID()) : "NULL") + ",std_id=" + String.valueOf(this.tempProp.getCmpStdID() > 0 ? Integer.valueOf(this.tempProp.getCmpStdID()) : "NULL") + ",envsch_id=" + String.valueOf(this.tempProp.getEnvSchID() > 0 ? Integer.valueOf(this.tempProp.getEnvSchID()) : "NULL") + ",synsch_id=" + String.valueOf(this.tempProp.getSynSchID() > 0 ? Integer.valueOf(this.tempProp.getSynSchID()) : "NULL") + ",grpset_id=" + String.valueOf(this.tempProp.getGrpSetID() > 0 ? Integer.valueOf(this.tempProp.getGrpSetID()) : "NULL") + ",agecurve_id=" + String.valueOf(this.tempProp.getAgeCurveID() > 0 ? Integer.valueOf(this.tempProp.getAgeCurveID()) : "NULL") + ",shape_id=" + String.valueOf(this.tempProp.getShapeStoreID() > 0 ? Integer.valueOf(this.tempProp.getShapeStoreID()) : "NULL") + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE PANEL_ID=" + this.ID;
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.storeRelated(sbdb, stmt, this.tempProp);
        }
        this.properties.copy(this.tempProp);
        this.clearTempProp();
        this.listeners.notify(l -> l.onTemplateEditingFinished(false));
    }

    private void storeRelated(SBdb sbdb, Statement stmt, PanelProperties prop) throws SQLException {
        block14: {
            String sql;
            block13: {
                sql = "DELETE FROM " + sbdb.DBTableName("CHTANALYST") + " WHERE panel_id=" + this.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
                if (prop.getAnalystList() != null) {
                    sql = "INSERT INTO " + sbdb.DBTableName("CHTANALYST") + " (panel_id,analyst_id) VALUES (" + this.ID + ",";
                    for (Object o : prop.getAnalystList()) {
                        int analystID = 0;
                        if (o instanceof String) {
                            analystID = sbdb.getUserID((String)o);
                        } else if (o instanceof Userdef) {
                            analystID = ((Userdef)o).getUsrID();
                        }
                        if (analystID < 1) {
                            throw new IllegalStateException("Panel properties contains illegal analyst: " + String.valueOf(o));
                        }
                        stmt.executeUpdate(sbdb.modQuery(sql + analystID + ")"));
                    }
                }
                sql = "DELETE FROM " + sbdb.DBTableName("CHTPANL_BLKMBR") + " WHERE panel_id=" + this.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
                if (prop.getBlockMbrTemplateID() > 0) {
                    sql = "INSERT INTO " + sbdb.DBTableName("CHTPANL_BLKMBR") + " (panel_id,block_id) VALUES (" + this.ID + "," + prop.getBlockMbrTemplateID() + ")";
                    stmt.executeUpdate(sbdb.modQuery(sql));
                }
                if (!PanelType.isTaxonPanel(this.type)) break block13;
                sql = "DELETE FROM " + sbdb.DBTableName("CHTSPECTYPE") + " WHERE panel_id=" + this.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
                sql = "DELETE FROM " + sbdb.DBTableName("CHTPANLMBR") + " WHERE panel_id=" + this.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
                PanelTaxonGroupProperties ptgTempProp = (PanelTaxonGroupProperties)prop;
                LinkedList<PanelTaxonOcc> innerPanels = ptgTempProp.getInnerPanels();
                if (innerPanels.isEmpty()) break block14;
                sql = "INSERT INTO " + sbdb.DBTableName("CHTPANLMBR") + " (panel_id,panel_no,type,caption,prop,spec_id,grp_id,grpset_id,cat_mnem,isdefault,foreach,highlight_grp_id,std_id,sch_id,exclude_grp_id,overplot) VALUES (" + this.ID + ",";
                String sqlSpecType = "INSERT INTO " + sbdb.DBTableName("CHTSPECTYPE") + " (panel_id,panel_no,spec_type_id) VALUES (" + this.ID + ",";
                int i = 0;
                for (PanelTaxonOcc inner : innerPanels) {
                    String sqlPlus = sql + i + "," + SB.DBString((String)inner.getType().name()) + "," + SB.DBString((String)CaptionTemplate.getDbString(inner.getCaption())) + "," + SB.DBString((String)inner.getPropertiesString()) + "," + String.valueOf(inner.getFilterSpec() != null ? Integer.valueOf(inner.getFilterSpec().getSpecID()) : "NULL") + "," + String.valueOf(inner.getFilterGroup() != null ? Integer.valueOf(inner.getFilterGroup().getID()) : "NULL") + "," + String.valueOf(inner.getFilterSet() != null ? Integer.valueOf(inner.getFilterSet().getID()) : "NULL") + "," + (inner.getFilterCat() != null ? SB.DBString((String)inner.getFilterCat().getMnemonic()) : "NULL") + "," + (inner.isDefault() ? 1 : 0) + "," + String.valueOf(inner.getForEachInt() != null ? inner.getForEachInt() : "NULL") + "," + String.valueOf(inner.getProperties().getFilterGrpID() != null ? inner.getProperties().getFilterGrpID() : "NULL") + "," + String.valueOf(inner.getStdID() != null ? inner.getStdID() : "NULL") + "," + String.valueOf(inner.getProperties().getSchID() != null ? inner.getProperties().getSchID() : "NULL") + "," + String.valueOf(inner.getProperties().getExclGrpID() != null ? inner.getProperties().getExclGrpID() : "NULL") + "," + (inner.isOverplot() ? SB.DBString((String)"LEFT") : "NULL") + ")";
                    stmt.executeUpdate(sbdb.modQuery(sqlPlus));
                    if (inner.getProperties().getSubTypes() != null) {
                        for (Integer specType : inner.getProperties().getSubTypes()) {
                            String sqlSpecTypePlus = sqlSpecType + i + "," + specType + ")";
                            stmt.executeUpdate(sqlSpecTypePlus);
                        }
                    }
                    ++i;
                }
                break block14;
            }
            if (this.type == PanelType.WLOG || this.type == PanelType.VS) {
                sql = "DELETE FROM " + sbdb.DBTableName("CHTLOG") + " WHERE panel_id=" + this.ID;
                stmt.executeUpdate(sbdb.modQuery(sql));
                HashMap<String, String> pLogDefs = prop.getLogDefs();
                if (pLogDefs != null) {
                    sql = "INSERT INTO " + sbdb.DBTableName("CHTLOG") + " (panel_id,abr,prop) VALUES (" + this.ID + ",";
                    for (String s : pLogDefs.keySet()) {
                        String sqli = sql + SB.DBString((String)s) + "," + (pLogDefs.get(s) != null ? SB.DBString((String)pLogDefs.get(s)) : "NULL") + ")";
                        stmt.executeUpdate(sbdb.modQuery(sqli));
                    }
                }
            }
        }
    }

    void delete(SBdb sbdb) throws SQLException, SBException, SBPermissionException {
        if (this.ID < 1) {
            throw new IllegalStateException("Attempt to delete panel template with ID: " + this.ID);
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            int count;
            if (!this.canWrite(sbdb, stmt)) {
                throw new SBPermissionException("Can't delete read-only panel template: " + this.getName());
            }
            String sql1 = "SELECT count(*) as count from " + sbdb.DBTableName("CHTBLOCKMBR") + " m," + sbdb.DBTableName("CHTBLOCK") + " b where m.block_id=b.block_id AND b.parent_id is NULL AND m.panel_id=" + this.ID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql1));
            if (rs.next() && (count = rs.getInt("count")) > 0) {
                throw new SBException("This panel (" + String.valueOf(this.getType()) + "/" + this.comments + "/ID=" + this.ID + ") occurs " + count + " times in blocks");
            }
            ArrayList<CallSite> updates = new ArrayList<CallSite>();
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTBLOCKMBR") + " where panel_id=" + this.ID)));
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTPANL_BLKMBR") + " where panel_id=" + this.ID)));
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTANALYST") + " where panel_id=" + this.ID)));
            if (PanelType.isTaxonPanel(this.type)) {
                updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTSPECTYPE") + " where panel_id=" + this.ID)));
                updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTPANLMBR") + " where panel_id=" + this.ID)));
            }
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTLOG") + " where panel_id=" + this.ID)));
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTPANL_ACL") + " where PANEL_ID=" + this.ID)));
            updates.add((CallSite)((Object)("DELETE from " + sbdb.DBTableName("CHTPANL") + " where PANEL_ID=" + this.ID)));
            for (String string : updates) {
                stmt.executeUpdate(sbdb.modQuery(string));
            }
        }
    }

    public boolean isTaxonPanelTemplate() {
        return PanelType.isTaxonPanel(this.type);
    }

    public PanelTaxonOcc addInnerPanel(PanelTaxonType ptType) {
        if (!this.isTaxonPanelTemplate()) {
            throw new IllegalArgumentException("Attempt to add taxon panel to type " + String.valueOf(this.type));
        }
        this.getTempProp(true);
        PanelTaxonGroupProperties ptgp = (PanelTaxonGroupProperties)this.tempProp;
        PanelTaxonOcc newOcc = ptgp.addInnerPanel(ptType);
        if (this.checkTempProp()) {
            this.listeners.notify(l -> l.onTemplatePropertyChanged(this.tempProp));
        }
        return newOcc;
    }

    public PanelTaxonOcc addTaxonPanelCopy(PanelTaxonOcc toCopy) {
        if (toCopy == null) {
            return null;
        }
        if (!this.isTaxonPanelTemplate()) {
            throw new IllegalArgumentException("Attempt to add taxon panel to type " + String.valueOf(this.type));
        }
        this.getTempProp(true);
        PanelTaxonGroupProperties ptgp = (PanelTaxonGroupProperties)this.tempProp;
        PanelTaxonOcc copied = new PanelTaxonOcc(toCopy);
        copied.setIsDefault(false);
        ptgp.addInnerPanel(copied);
        this.setChanged();
        if (this.checkTempProp()) {
            this.listeners.notify(l -> l.onTemplatePropertyChanged(this.tempProp));
        }
        return copied;
    }

    public void deleteInnerPanel(PanelTaxonOcc occ) throws InvalidFieldException {
        if (!this.isTaxonPanelTemplate()) {
            throw new IllegalArgumentException("Attempt to delete inner panel to from " + String.valueOf(this.type));
        }
        if (((PanelTaxonGroupProperties)this.getEditableProp()).getInnerPanels().size() == 1) {
            throw new InvalidFieldException("You can't remove the last inner panel!");
        }
        this.getTempProp(true);
        PanelTaxonOcc toEdit = null;
        for (PanelTaxonOcc pto : ((PanelTaxonGroupProperties)this.tempProp).getInnerPanels()) {
            if (!pto.wasCopiedFrom(occ)) continue;
            toEdit = pto;
            break;
        }
        assert (toEdit != null);
        ((PanelTaxonGroupProperties)this.tempProp).removeInnerPanel(toEdit);
        if (this.checkTempProp()) {
            this.listeners.notify(l -> l.onTemplatePropertyChanged(this.tempProp));
        }
    }

    public void moveInnerPanel(PanelTaxonOcc occ, boolean left) {
        if (!this.isTaxonPanelTemplate()) {
            throw new IllegalArgumentException("Attempt to move inner panel in " + String.valueOf(this.type));
        }
        PanelTaxonOcc toEdit = this.getInnerPanelToEdit(occ);
        ((PanelTaxonGroupProperties)this.tempProp).moveInnerPanel(toEdit, left);
        if (this.checkTempProp()) {
            this.listeners.notify(l -> l.onInnerPanelMoved(this.tempProp));
        }
    }

    private PanelTaxonOcc getInnerPanelToEdit(PanelTaxonOcc occ) {
        PanelTaxonOcc toEdit = null;
        if (this.getTempProp(false)) {
            for (PanelTaxonOcc pto : ((PanelTaxonGroupProperties)this.tempProp).getInnerPanels()) {
                if (!pto.wasCopiedFrom(occ)) continue;
                toEdit = pto;
                break;
            }
        } else {
            for (PanelTaxonOcc pto : ((PanelTaxonGroupProperties)this.tempProp).getInnerPanels()) {
                if (pto != occ) continue;
                toEdit = pto;
            }
        }
        assert (toEdit != null);
        return toEdit;
    }

    public void updateInnerPanelProperty(PanelTaxonOcc occ, boolean panelOcc, int nProp, Object prop) {
        boolean didEdit;
        boolean firstEdit;
        block31: {
            PanelTaxonOcc toEdit;
            block32: {
                if (!this.isTaxonPanelTemplate()) {
                    throw new IllegalArgumentException("Illegal attempt to edit inner panel: panel type is " + String.valueOf(this.type));
                }
                firstEdit = this.tempProp == null;
                toEdit = this.getInnerPanelToEdit(occ);
                if (firstEdit) assert (toEdit != occ);
                didEdit = false;
                if (!panelOcc) break block32;
                switch (nProp) {
                    case 0: {
                        didEdit = toEdit.setCaption((String)prop);
                        break block31;
                    }
                    case 1: {
                        boolean isOverplotBase = PanelTaxonGroupProperties.isOverplotBase(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit);
                        PanelTaxonOcc.Filter filter = (PanelTaxonOcc.Filter)prop;
                        if (isOverplotBase && filter != null && filter.isForEach() || !(didEdit = toEdit.setFilter(filter)) || !isOverplotBase) break block31;
                        for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) {
                            overplotted.setFilter(filter);
                        }
                        break block31;
                    }
                    case 2: {
                        didEdit = toEdit.setIncludeSubCats((Boolean)prop);
                        if (!didEdit || !PanelTaxonGroupProperties.isOverplotBase(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) break block31;
                        for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) {
                            overplotted.setIncludeSubCats((Boolean)prop);
                        }
                        break block31;
                    }
                    case 3: {
                        didEdit = toEdit.setIsDefault((Boolean)prop);
                        if (!didEdit) break block31;
                        boolean isNowDefault = (Boolean)prop;
                        if (!isNowDefault) {
                            toEdit.setPropertiesObj(toEdit.getProperties().createCopy());
                        } else {
                            for (PanelTaxonOcc pto : ((PanelTaxonGroupProperties)this.tempProp).getInnerPanels()) {
                                if (pto == toEdit || pto.getType() != toEdit.getType() || !pto.isDefault()) continue;
                                String invalidString = null;
                                for (int i = 0; i < pto.getProperties().getnProps(); ++i) {
                                    invalidString = ((PanelTaxonGroupProperties)this.tempProp).verifyInnerPanelProperty(toEdit, i, pto.getProperties().getProperty(i));
                                    if (invalidString == null) continue;
                                    System.out.println("New inner panel property was invalid: " + invalidString);
                                    break;
                                }
                                if (invalidString == null) {
                                    toEdit.setPropertiesObj(pto.getProperties());
                                } else {
                                    toEdit.setIsDefault(false);
                                    didEdit = false;
                                }
                                break block31;
                            }
                        }
                        break block31;
                    }
                    case 4: {
                        PanelTaxonOcc overplotBase;
                        boolean overplot = (Boolean)prop;
                        if (!overplot || PanelTaxonGroupProperties.canOverplot(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) {
                            didEdit = toEdit.setOverplot(overplot);
                        }
                        if (!didEdit || !overplot) break block31;
                        if (toEdit.isDefault()) {
                            this.updateInnerPanelProperty(toEdit, true, 3, false);
                        }
                        if ((overplotBase = PanelTaxonGroupProperties.getOverplotBase(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)).getFilterObj() != null) {
                            if (overplotBase.getFilterObj().isForEach()) {
                                overplotBase.setFilter(null);
                            } else {
                                toEdit.setFilter(new PanelTaxonOcc.Filter(overplotBase.getFilterObj().getFilter(), overplotBase.getFilterObj().includeSubCats()));
                            }
                        } else {
                            toEdit.setFilter(null);
                        }
                        PanelTaxonProperties overplotBaseProp = (PanelTaxonProperties)overplotBase.getProperties();
                        for (int iProp = 0; iProp < ((PanelTaxonProperties)toEdit.getProperties()).getnProps(); ++iProp) {
                            if (!PanelTaxonProperties.isOverplotRow(iProp)) continue;
                            toEdit.getProperties().setProperty(iProp, overplotBaseProp.getProperty(iProp));
                        }
                        if (!overplotBase.isDefault()) break block31;
                        this.updateInnerPanelProperty(overplotBase, true, 3, false);
                        break block31;
                    }
                    default: {
                        assert (false);
                        break block31;
                    }
                }
            }
            didEdit = toEdit.getProperties().setProperty(nProp, prop);
            if (didEdit && PanelTaxonGroupProperties.isOverplotBase(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit) && PanelTaxonProperties.isOverplotRow(nProp)) {
                for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) {
                    overplotted.getProperties().setProperty(nProp, prop);
                }
                if (((PanelTaxonProperties)toEdit.getProperties()).getProperty(12) != PanelTaxonProperties.Group.TOTAL) {
                    PanelTaxonOcc.Filter filter = toEdit.getFilterObj();
                    for (PanelTaxonOcc overplotted : PanelTaxonGroupProperties.getOverplotted(((PanelTaxonGroupProperties)this.tempProp).getInnerPanels(), toEdit)) {
                        overplotted.setFilter(filter);
                    }
                }
            }
        }
        if (!didEdit && firstEdit) {
            this.clearTempProp();
            this.listeners.notify(l -> l.onTemplateEditingFinished(true));
            return;
        }
        if (this.checkTempProp()) {
            this.listeners.notify(l -> l.onTemplatePropertyChanged(this.tempProp));
        }
    }

    private void clearTempProp() {
        assert (this.tempProp != null);
        this.tempProp = null;
        this.externallyReloaded = false;
    }

    private synchronized boolean getTempProp(boolean createCopy) {
        if (this.tempProp == null) {
            this.tempProp = this.properties.copy();
            this.listeners.notify(l -> l.onTemplateEditingStarted(this.tempProp));
            return true;
        }
        if (createCopy) {
            this.tempProp = this.tempProp.copy();
            this.listeners.notify(l -> l.onTemplateEditingStarted(this.tempProp));
        }
        return false;
    }

    private synchronized boolean checkTempProp() {
        if (this.tempProp.equals(this.properties)) {
            this.tempProp = null;
            this.listeners.notify(l -> l.onTemplateEditingFinished(true));
            return false;
        }
        return true;
    }

    @Override
    public Date getModified() {
        return this.audit.getModified();
    }

    @Override
    public Date getCreated() {
        return this.audit.getCreated();
    }

    @Override
    public int getModifier() {
        return this.audit.getModifier();
    }

    @Override
    public int getCreator() {
        return this.audit.getCreator();
    }

    public Date getUpdated() {
        return this.audit.getUpdated();
    }

    Audit getAuditCopy() {
        return new Audit(this.audit);
    }

    public boolean hasBeenRefreshed() {
        return this.externallyReloaded;
    }

    public int getNusages(ChartManager chartManager) throws SQLException {
        if (this.nUsages < 0) {
            List<BlockTemplate> blocks = chartManager.searchBlocks(this.getID());
            this.nUsages = blocks.size();
        }
        return this.nUsages;
    }

    public void resetNusages() {
        this.nUsages = -1;
    }

    synchronized void refresh(PanelTemplate updated) {
        if (updated.getID() != this.ID) {
            throw new IllegalArgumentException("Attempt to update panel template " + String.valueOf(this) + " from different template");
        }
        assert (updated.type == this.type);
        this.descr = updated.descr;
        this.comments = updated.comments;
        this.projID = updated.projID;
        this.defaultTemplate = updated.defaultTemplate;
        this.audit = updated.audit;
        if (!this.properties.equals(updated.properties)) {
            this.properties.copy(updated.properties);
            this.setChanged();
            TemplateNotifierService.submitNotify((Observable)((Object)this), this.properties);
            if (this.tempProp != null) {
                this.externallyReloaded = true;
            }
        }
    }

    public Optional<BlockProperties.ScaleType> getAltPropType() {
        switch (this.type) {
            case DEPTHAGE: 
            case SUBSIDENCE: {
                return Optional.of(BlockProperties.ScaleType.AGE);
            }
            case VS: {
                return Optional.of(BlockProperties.ScaleType.TVD);
            }
        }
        return Optional.empty();
    }

    public void mergeTaxa(Taxon donor, Taxon target) throws SQLException, SBException, SBPermissionException {
        if (!PanelType.isTaxonPanel(this.type)) {
            assert (false);
            return;
        }
        PanelTaxonGroupProperties ptp = (PanelTaxonGroupProperties)this.properties;
        while (ptp != null) {
            for (PanelTaxonOcc occ : ptp.getInnerPanels()) {
                if (occ.getFilter() != donor) continue;
                this.setChanged();
                occ.setFilter(new PanelTaxonOcc.Filter(target, this.isVisible));
            }
            if (ptp == this.properties && this.isEditing()) {
                ptp = (PanelTaxonGroupProperties)this.tempProp;
                continue;
            }
            ptp = null;
        }
        this.notifyObservers(this.properties);
    }

    void writeXML(BufferedWriter out, int indent, SBdb ws, int singleUserID) throws IOException {
        HashMap<String, String> logDefs;
        String ind = SB.getXMLIndent((int)indent);
        out.write(ind + "<Description>" + SB.getXMLstring((String)this.descr) + "</Description>\n");
        if (this.comments != null && !this.comments.trim().isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.comments.trim()) + "</Comments>\n");
        }
        if (!this.isVisible) {
            out.write(ind + "<PrivateToBlock>" + !this.isVisible + "</PrivateToBlock>\n");
        }
        out.write(ind + "<Properties>" + SB.getXMLstring((String)this.properties.getPropertiesString()) + "</Properties>\n");
        this.audit.writeXML(out, indent, singleUserID);
        if (this.properties.getAnalystList() != null) {
            for (Object o : this.properties.getAnalystList()) {
                int userID;
                if (o instanceof String) {
                    try {
                        userID = ws.getUserID((String)o);
                    }
                    catch (SQLException e) {
                        userID = 0;
                    }
                } else {
                    userID = o instanceof Userdef ? ((Userdef)o).getUsrID() : ((Integer)o).intValue();
                }
                out.write(ind + "<UserID>" + userID + "</UserID>\n");
            }
        }
        if (this.properties.getCmpStdID() > 0) {
            out.write(ind + "<CompositeStandardID>" + this.properties.getCmpStdID() + "</CompositeStandardID>\n");
        }
        if (this.properties.getEnvSchID() > 0) {
            out.write(ind + "<EnvironmentSchemeID>" + this.properties.getEnvSchID() + "</EnvironmentSchemeID>\n");
        }
        if (this.properties.getAgeCurveID() > 0) {
            out.write(ind + "<AgeCurveID>" + this.properties.getAgeCurveID() + "</AgeCurveID>\n");
        }
        if (this.properties.getIGDSchemeID() > 0) {
            out.write(ind + "<StratigraphicSchemeID>" + this.properties.getIGDSchemeID() + "</StratigraphicSchemeID>\n");
        }
        if (this.properties.getGrpSetID() > 0) {
            out.write(ind + "<GroupSetID>" + this.properties.getGrpSetID() + "</GroupSetID>\n");
        }
        if (this.properties.getSynSchID() > 0) {
            // empty if block
        }
        if (this.properties.getBlockMbrTemplateID() > 0) {
            out.write(ind + "<SchemeBlockHeader>" + this.properties.getBlockMbrTemplateID() + "</SchemeBlockHeader>\n");
        }
        if ((logDefs = this.properties.getLogDefs()) != null) {
            for (Map.Entry<String, String> e : logDefs.entrySet()) {
                if (e.getValue() != null) continue;
                out.write(ind + "<WirelineLogAbr>" + e.getKey() + "</WirelineLogAbr>\n");
            }
            for (Map.Entry<String, String> e : logDefs.entrySet()) {
                if (e.getValue() == null) continue;
                out.write(ind + "<WirelineLogProperties>" + e.getValue() + "</WirelineLogProperties>\n");
            }
        }
        if (this.properties.getShapeStoreID() > 0) {
            out.write(ind + "<ShapeStoreID>" + this.properties.getShapeStoreID() + "</ShapeStoreID>\n");
        }
        if (PanelType.isTaxonPanel(this.type)) {
            ((PanelTaxonGroupProperties)this.properties).writeInnerPanelsXML(out, indent, ws);
        }
    }

    static PanelTemplate parseXML(ChartManager wsCM, SBdb ws, Element xml, int projID) throws SQLException, ParseException, SBException {
        PanelType type = PanelType.valueOf(xml.getAttributeValue("Type"));
        String propString = xml.getChildTextNormalize("Properties");
        PanelPropertiesBuilder b = new PanelPropertiesBuilder(type, propString);
        String strg = xml.getChildTextNormalize("CompositeStandardID");
        if (strg != null) {
            b.cmpStdID(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("StratigraphicSchemeID")) != null) {
            b.schID(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("EnvironmentSchemeID")) != null) {
            b.envSchID(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("AgeCurveID")) != null) {
            b.ageCurveID(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("GroupSetID")) != null) {
            b.grpSetID(Integer.parseInt(strg));
        }
        for (Object child : xml.getChildren("UserID")) {
            b.analyst(ws.getUser(Integer.parseInt(((Element)child).getText())));
        }
        strg = xml.getChildTextNormalize("SchemeBlockHeader");
        if (strg != null) {
            int blockID = Integer.parseInt(strg);
            BlockTemplate blockTemplate = wsCM.getBlockTemplate(blockID);
            b.mbrBlock((ChartBlock)ChartFactory.createBlock(ws, blockTemplate, null));
        }
        for (Object child : xml.getChildren("WirelineLogAbr")) {
            b.logDef(child.getText(), null);
        }
        for (Object child : xml.getChildren("WirelineLogProperties")) {
            b.logDef(child.getText().substring(0, child.getText().indexOf(124)), child.getText());
        }
        strg = xml.getChildTextNormalize("ShapeStoreID");
        if (strg != null) {
            b.shapeStoreID(Integer.parseInt(strg));
        }
        for (Object o : xml.getChildren("InnerPanel")) {
            Element child = (Element)o;
            String occProps = null;
            String props = child.getChildText("Properties");
            String[] splits = props.split("\\^");
            String panelProps = splits[splits.length - 1];
            if (splits.length > 1) {
                occProps = splits[0];
            }
            CompositeStandard std = null;
            Integer cmpStdID = null;
            strg = child.getChildTextNormalize("FilterCompositeStandard");
            if (strg != null) {
                cmpStdID = Integer.parseInt(strg);
            } else {
                strg = child.getChildTextNormalize("HeaderCompositeStandard");
                if (strg != null) {
                    cmpStdID = Integer.parseInt(strg);
                }
            }
            if (cmpStdID != null) {
                std = ws.getCompositeStandard(cmpStdID.intValue());
            }
            boolean isOverplot = false;
            if (child.getChildTextNormalize("Overplot") != null) {
                isOverplot = true;
            }
            PanelTaxonOcc ptOcc = new PanelTaxonOcc(PanelTaxonType.valueOf(child.getAttributeValue("Type")), Boolean.valueOf(child.getChildText("IsDefault")), panelProps, std, isOverplot);
            strg = child.getChildTextNormalize("Caption");
            if (strg != null) {
                ptOcc.setCaption(strg);
            }
            if ((strg = child.getChildTextNormalize("FilterSpecies")) != null) {
                ptOcc.specID(Integer.parseInt(strg), ws);
            }
            if ((strg = child.getChildTextNormalize("FilterTaxonGroup")) != null) {
                ptOcc.groupID(Integer.parseInt(strg), ws);
            }
            if ((strg = child.getChildTextNormalize("FilterGroupSet")) != null) {
                ptOcc.setID(Integer.parseInt(strg), ws);
            }
            if ((strg = child.getChildTextNormalize("FilterCategory")) != null) {
                if (ws.getCategoryService().findCategory(strg).isEmpty()) {
                    ws.getCategoryService().addCategory(strg, type.getDiscipine(), strg, Color.BLACK);
                }
                ptOcc.catMnem(strg, ws);
            }
            if ((strg = child.getChildTextNormalize("ForEachFilter")) != null) {
                ptOcc.forEach(PanelTaxonOcc.Filter.parseForEachString(strg));
            }
            if ((strg = child.getChildTextNormalize("ExcludeTaxonGroup")) != null) {
                ptOcc.exclGrp(Integer.parseInt(strg), ws);
            }
            if ((strg = child.getChildTextNormalize("HighlightTaxonGroup")) != null) {
                ptOcc.highlightGroup(Integer.parseInt(strg), ws);
            }
            if ((strg = child.getChildTextNormalize("HeaderStratigraphicScheme")) != null) {
                ptOcc.hdrScheme(Integer.parseInt(strg), ws);
            }
            for (Element el : child.getChildren("SpeciesTypeFilter")) {
                ptOcc.getProperties().addSubType(ws.getSpeciesTypeService().getAddSpeciesType(el.getTextNormalize()).specTypeID());
            }
            ptOcc.setOccProps(occProps, std);
            b.innerPanel(ptOcc);
        }
        boolean isVisible = true;
        if (xml.getChildTextNormalize("PrivateToBlock") != null) {
            isVisible = false;
        }
        return new PanelTemplate(type, Integer.parseInt(xml.getAttributeValue("PanelID")), isVisible, xml.getChildText("Description"), xml.getChildText("Comments"), false, b.build(ws, wsCM.getShapeStoreService()), projID, new Audit(ws, xml.getChild("Audit")), 0);
    }

    PanelTemplate getLink() {
        return this.link;
    }

    void setLink(PanelTemplate link) {
        this.link = link;
    }

    public void addListener(Listener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(Listener listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public static interface Listener {
        public void onTemplateEditingStarted(PanelProperties var1);

        public void onTemplateEditingFinished(boolean var1);

        public void onTemplatePropertyChanged(PanelProperties var1);

        default public void onInnerPanelMoved(PanelProperties propertiesThatChanged) {
        }
    }
}

