/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationLine;
import jsbchart.graphics.SBGraphics;

public class CorrDrawUtils {
    private CorrDrawUtils() {
    }

    public static void drawCorrelationLine(SBGraphics g, CorrelationLine line, float x1, float x2, float y1, float y2, boolean symbol, ChartProperties cp, Boundary ... bnds) {
        CorrDrawUtils.drawCorrelationLine(g, line, x1, x2, y1, y2, null, symbol, cp, bnds);
    }

    public static void drawCorrelationLine(SBGraphics g, CorrelationLine line, float x1, float x2, float y1, float y2, Color backColour, boolean symbol, ChartProperties cp, Boundary ... bnds) {
        CorrLineStyle style = line.getStyle();
        float h = style.getWeight() * 4.0f;
        Boundary bnd = style.getBnd();
        Boundary bnd2 = null;
        if (bnd == null && bnds != null && bnds.length > 0) {
            bnd = bnds[0];
            if (bnds.length > 1 && (bnd2 = bnds[1]) == bnd) {
                bnd2 = null;
            }
        }
        if (!symbol) {
            assert (bnd2 == null);
            switch (bnd) {
                case FAULT: 
                case QFAULT: 
                case RFAULT: {
                    bnd = Boundary.CONF;
                }
            }
        }
        if (backColour != null) {
            Color c = line.getColour();
            g.setGradientPaint(c, x1, y1, new Color(c.getRed(), c.getGreen(), c.getBlue(), 0), x2, y2);
        } else {
            g.setColor(line.getColour());
        }
        Float x3 = null;
        Float y3 = null;
        if (bnd2 != null) {
            x3 = Float.valueOf(x1 + (x2 - x1) / 2.0f);
            y3 = Float.valueOf(y1 + (y2 - y1) / 2.0f);
        }
        Double angle = null;
        for (int i = 0; i < (bnd2 == null ? 1 : 2); ++i) {
            float py1;
            float px1;
            Boundary b;
            Boundary boundary = b = i == 0 ? bnd : bnd2;
            if (b == null) continue;
            float f = px1 = i == 0 ? x1 : x3.floatValue();
            float px2 = i == 0 ? (bnd2 == null ? x2 : x3.floatValue()) : x2;
            float f2 = py1 = i == 0 ? y1 : y3.floatValue();
            float py2 = i == 0 ? (bnd2 == null ? y2 : y3.floatValue()) : y2;
            switch (b) {
                case CONF: {
                    g.setStroke(style.getWeight());
                    g.drawLine(px1, py1, px2, py2);
                    break;
                }
                case PROB: {
                    g.setDashStroke(style.getWeight(), 2.5f);
                    g.drawLine(px1, py1, px2, py2);
                    break;
                }
                case POSS: {
                    g.setDashStroke(style.getWeight(), 1.0f);
                    g.drawLine(px1, py1, px2, py2);
                    break;
                }
                case UNCF: {
                    g.setStroke(style.getWeight());
                    GeneralPath p = SBGraphics.createGeneralPath(px1, py1);
                    g.appendUnconf(p, px1, px2, py1, py2, false, true, true, false);
                    g.drawShape(p);
                    break;
                }
                case QUNCF: {
                    g.setStroke(style.getWeight());
                    GeneralPath p = SBGraphics.createGeneralPath(px1, py1);
                    Shape s = g.appendUnconf(p, px1, px2, py1, py2, true, true, true, false);
                    g.drawShape(p);
                    g.fillShape(s, g.getColor());
                    break;
                }
                case FAULT: {
                    g.setStroke(style.getWeight());
                    g.drawLine(px1, py1, px2, py2);
                    float w1 = style.getWeight() * 2.5f;
                    float halfx = (px2 - px1) / 2.0f;
                    float halfy = (py2 - py1) / 2.0f;
                    g.drawLine(px1 + halfx, py1 + halfy, px1 + halfx, py1 + halfy - h);
                    g.fillEllipse(px1 + halfx - w1 / 2.0f, py1 + halfy - h, w1, w1, null);
                    break;
                }
                case QFAULT: {
                    g.setStroke(style.getWeight());
                    g.drawLine(px1, py1, px2, py2);
                    float w1 = style.getWeight() * 2.5f;
                    float halfx = (px2 - px1) / 2.0f;
                    float halfy = (py2 - py1) / 2.0f;
                    g.drawLine(px1 + halfx, py1 + halfy, px1 + halfx, py1 + halfy - h);
                    g.fillEllipse(px1 + halfx - w1 / 2.0f, py1 + halfy - h * 1.1f, w1, w1, null);
                    Font f3 = g.getFont();
                    g.setFontSize(h);
                    g.drawString("?", px1 + halfx - w1 * 1.4f, py1 + halfy - style.getWeight());
                    g.setFont(f3);
                    break;
                }
                case RFAULT: {
                    g.setStroke(style.getWeight());
                    g.drawLine(px1, py1, px2, py2);
                    float w = style.getWeight() * 5.0f;
                    float h1 = h * 0.4f;
                    float halfx = (px2 - px1) / 2.0f;
                    float halfy = (py2 - py1) / 2.0f;
                    float[] xpos = new float[]{px1 + halfx - w / 2.0f, px1 + halfx - w / 2.0f, px1 + halfx + w / 2.0f, px1 + halfx + w / 2.0f};
                    float ydiff = w / 2.0f * (halfy / halfx);
                    float[] ypos = new float[]{py2 - halfy - ydiff, py2 - halfy - ydiff - h1, py2 - halfy + ydiff - h1, py2 - halfy + ydiff};
                    g.fillPolygon(xpos, ypos, 4);
                    break;
                }
            }
            if (angle == null) continue;
            g.rotate(-angle.doubleValue(), px1, py1);
            angle = null;
        }
        if (symbol && line.getStyle().getLabel() && backColour == null) {
            g.setFont(cp.font, 0, cp.getFontSize(line.getStyle().getFontSize()));
            g.drawHorizontalLineLabel(line.toString(), line.getStyle().getAlignment(), line.getLabelPosition(), style.getWeight(), new Line2D.Float(x1, y1, x2, y2), cp.background);
        }
    }
}

