/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumSet;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.CorrelationType;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.SBdb;
import util.SB;

public class CorrStdOcc {
    final CorrelationType type;
    final CorrelationScope scope;
    final EnumSet dataTypes;
    final boolean visible;
    final boolean useBlockInterp;
    final int maxUnconfidence;
    final boolean correlateRangedIntervals;
    final String style;
    final int interpID;
    final int hier;
    final int schID;

    public CorrStdOcc(CorrelationType type, CorrelationScope scope, EnumSet dataTypes, boolean visible, String style, int interpID, int maxUnconfidence, boolean correlateRangedIntervals, boolean useBlockInterp) {
        this.type = type;
        this.scope = scope;
        this.visible = visible;
        this.useBlockInterp = useBlockInterp;
        this.style = style;
        this.dataTypes = dataTypes;
        this.interpID = interpID;
        this.maxUnconfidence = maxUnconfidence;
        this.correlateRangedIntervals = correlateRangedIntervals;
        this.hier = 0;
        this.schID = 0;
    }

    public CorrStdOcc(CorrelationType type, CorrelationScope scope, EnumSet dataTypes, boolean visible, String style, int interpID, int schID, int hier, int maxUnconfidence, boolean correlateRangedIntervals, boolean useBlockInterp) {
        this.type = type;
        this.scope = scope;
        this.visible = visible;
        this.useBlockInterp = useBlockInterp;
        this.style = style;
        this.dataTypes = dataTypes;
        this.interpID = interpID;
        this.schID = schID;
        this.hier = hier;
        this.maxUnconfidence = maxUnconfidence;
        this.correlateRangedIntervals = correlateRangedIntervals;
    }

    public CorrStdOcc copy() {
        return this.copy(null, null);
    }

    public CorrStdOcc copy(Integer interpID, Integer schID) {
        return new CorrStdOcc(this.type, this.scope, this.dataTypes != null ? EnumSet.copyOf(this.dataTypes) : null, this.visible, this.style, interpID != null ? interpID : this.interpID, schID != null ? schID : this.schID, this.hier, this.maxUnconfidence, this.correlateRangedIntervals, this.useBlockInterp);
    }

    String getDataTypeString() {
        if (this.dataTypes == null || this.dataTypes.isEmpty()) {
            return "";
        }
        Object s = "";
        for (Object o : this.dataTypes) {
            if (!((String)s).isEmpty()) {
                s = (String)s + ",";
            }
            s = (String)s + ((Enum)o).name();
        }
        return s;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 97 * hash + (this.scope != null ? this.scope.hashCode() : 0);
        hash = 97 * hash + (this.dataTypes != null ? this.dataTypes.hashCode() : 0);
        hash = 97 * hash + (this.visible ? 1 : 0);
        hash = 97 * hash + (this.style != null ? this.style.hashCode() : 0);
        hash = 97 * hash + this.interpID;
        hash = 97 * hash + this.hier;
        hash = 97 * hash + this.maxUnconfidence;
        hash = 97 * hash + (this.correlateRangedIntervals ? 1 : 0);
        hash = 97 * hash + (this.useBlockInterp ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrStdOcc other = (CorrStdOcc)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.scope != other.scope) {
            return false;
        }
        if (!(this.dataTypes == other.dataTypes || this.dataTypes != null && this.dataTypes.equals(other.dataTypes))) {
            return false;
        }
        if (this.visible != other.visible) {
            return false;
        }
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        if (this.interpID != other.interpID) {
            return false;
        }
        if (this.hier != other.hier) {
            return false;
        }
        if (this.maxUnconfidence != other.maxUnconfidence) {
            return false;
        }
        if (this.correlateRangedIntervals != other.correlateRangedIntervals) {
            return false;
        }
        if (this.useBlockInterp != other.useBlockInterp) {
            return false;
        }
        return this.schID == other.schID;
    }

    String getPropString() {
        return (this.visible ? (char)'Y' : 'N') + "|" + this.maxUnconfidence + "|" + (this.correlateRangedIntervals ? (char)'Y' : 'N') + "|" + (this.useBlockInterp ? (char)'Y' : 'N');
    }

    public int getSchID() {
        return this.schID;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public void writeXML(BufferedWriter out, SBdb ws, int indent) throws IOException, SQLException {
        String ind = SB.getXMLIndent((int)indent);
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<StandardCorrelation Name=\"" + Correlation.toDisplayString(this.type, this.scope, this.dataTypes, ws.getIGDScheme(this.schID), this.hier) + "\">\n");
        out.write(ind2 + "<CorrelationType>" + this.type.name() + "</CorrelationType>\n");
        out.write(ind2 + "<CorrelationScope>" + this.scope.name() + "</CorrelationScope>\n");
        for (Object e : this.dataTypes) {
            if (e instanceof EventType) {
                out.write(ind2 + "<EventType>" + ((EventType)e).name() + "</EventType>\n");
                continue;
            }
            if (!(e instanceof IGDIntervalZone.BoundaryType)) continue;
            out.write(ind2 + "<BoundaryType>" + ((IGDIntervalZone.BoundaryType)e).name() + "</BoundaryType>\n");
        }
        try {
            out.write(ind2 + "<WellInterpretationID ID=\"" + this.interpID + "\" Description=\"" + ws.getInterp(this.interpID).getDescription() + "\"/>\n");
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected SQL error", sql);
        }
        out.write(ind2 + "<Properties>" + this.style + "</Properties>\n");
        out.write(ind2 + "<VisibleOnly>" + this.visible + "</VisibleOnly>\n");
        switch (this.type) {
            case EVENT: {
                out.write(ind2 + "<MinimumConfidence>" + Confidence.getMaxUnconfidence((int)this.maxUnconfidence).name() + "</MinimumConfidence>\n");
                break;
            }
            case CHRONO: 
            case LITHO: 
            case BIOZONE: {
                int igdType = DataType.getIGDType((DataType)this.type.getDataType());
                out.write(ind2 + "<HierarchyLevel>" + IGDIntervalZone.getDefaultHierName((int)igdType, (int)this.hier, (boolean)true) + "</HierarchyLevel>\n");
                out.write(ind2 + "<StratigraphicSchemeID>" + this.schID + "</StratigraphicSchemeID>\n");
            }
        }
        out.write(ind + "</StandardCorrelation>\n");
    }

    public String getDbInsertString(SBdb sbdb, int chartID) {
        return "INSERT INTO " + sbdb.DBTableName(CorrelationType.isUnitType(this.type) ? "CHTCORROCC_STD_UNIT" : "CHTCORROCC_STD") + " (chart_id,type,scope,data_types,interp_id," + (CorrelationType.isUnitType(this.type) ? "sch_id,hier," : "") + "prop,style) VALUES (" + chartID + "," + SB.DBString((String)this.type.name()) + "," + SB.DBString((String)this.scope.name()) + "," + SB.DBString((String)this.getDataTypeString()) + "," + this.interpID + "," + (String)(CorrelationType.isUnitType(this.type) ? this.schID + "," + this.hier + "," : "") + SB.DBString((String)this.getPropString()) + "," + SB.DBString((String)this.style) + ")";
    }
}

