/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.Confidence;
import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import jsbchart.core.ChartProperties;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrStdOcc;
import jsbchart.correlation.CorrTemplateOcc;
import jsbchart.correlation.CorrelationLine;
import jsbchart.correlation.CorrelationScope;
import jsbchart.correlation.CorrelationTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNode;
import jsbchart.listener.ChartUpdate;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.WellEvent;
import util.SBException;

public class Correlation
extends ChartNode
implements CorrelationTemplate.Listener {
    private final CorrelationTemplate template;
    private final CorrelationScope scope;
    private final CorrelationType type;
    private int interpID;
    private CorrLineStyle defaultStyle;
    private boolean visibleOnly;
    private boolean useBlockInterp;
    private EnumSet dataTypes;
    private CorrelationLine datum1;
    private CorrelationLine datum2;
    private int hier;
    private IGDScheme scheme;
    private int maxUnconfidence = 100;
    private boolean correlateRangedIntervals = true;
    private Set<CorrelationLine> lines;
    private boolean isSelected = false;
    private static final float SELECT_WEIGHT = 0.3f;

    private Correlation(CorrelationTemplate template, CorrelationType type, CorrelationScope scope) {
        this.template = template;
        this.type = type;
        this.scope = scope;
        if (template != null) {
            assert (type == template.getType() && scope == CorrelationScope.SINGLE);
            template.addListener(this);
        } else assert (scope != CorrelationScope.SINGLE);
    }

    public void terminate() {
        if (this.template != null) {
            this.template.deleteListener(this);
        }
    }

    public static Correlation createCorrelation(CorrelationTemplate template, CorrTemplateOcc corrOcc) {
        Correlation correlation = new Correlation(template, template.getType(), CorrelationScope.SINGLE);
        correlation.interpID = corrOcc.interpID;
        correlation.defaultStyle = new CorrLineStyle(corrOcc.style);
        correlation.visibleOnly = corrOcc.visible;
        correlation.useBlockInterp = corrOcc.useBlockInterp;
        correlation.maxUnconfidence = corrOcc.maxUnconfidence;
        correlation.correlateRangedIntervals = corrOcc.correlateRangedIntervals;
        correlation.lines = template.getImplementedLines(correlation.defaultStyle, corrOcc.interpID);
        correlation.setDatum(corrOcc.datumString);
        return correlation;
    }

    public static Correlation createCorrelation(CorrStdOcc corrOcc, SBdb sbdb) throws SQLException {
        Correlation correlation = new Correlation(null, corrOcc.type, corrOcc.scope);
        correlation.interpID = corrOcc.interpID;
        correlation.defaultStyle = new CorrLineStyle(corrOcc.style);
        correlation.visibleOnly = corrOcc.visible;
        correlation.useBlockInterp = corrOcc.useBlockInterp;
        correlation.maxUnconfidence = corrOcc.maxUnconfidence;
        correlation.correlateRangedIntervals = corrOcc.correlateRangedIntervals;
        if (CorrelationType.isUnitType(corrOcc.type)) assert (corrOcc.hier > 0 && corrOcc.schID > 0);
        correlation.hier = corrOcc.hier;
        if (corrOcc.schID > 0) {
            correlation.scheme = sbdb.getIGDScheme(corrOcc.schID);
        }
        correlation.dataTypes = corrOcc.dataTypes;
        return correlation;
    }

    @Override
    public void onCorrelationTemplateUpdated() {
        String dString;
        this.lines = this.template.getImplementedLines(this.defaultStyle, this.interpID);
        if (this.datum1 != null) {
            dString = this.datum1.getDatumString();
            this.datum1 = null;
            for (CorrelationLine l : this.lines) {
                if (!l.getDatumString().equals(dString)) continue;
                this.datum1 = l;
                break;
            }
        }
        if (this.datum2 != null) {
            dString = this.datum2.getDatumString();
            this.datum2 = null;
            for (CorrelationLine l : this.lines) {
                if (!l.getDatumString().equals(dString)) continue;
                this.datum2 = l;
                break;
            }
        }
        this.setPropertyChanged();
        this.notifyListeners();
    }

    public int getTemplateID() {
        if (this.template != null) {
            return this.template.getID();
        }
        return 0;
    }

    public int getInterpID() {
        return this.interpID;
    }

    public int getSchID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return 0;
    }

    public int getHier() {
        return this.hier;
    }

    public String getDefaultStyle() {
        String s = this.defaultStyle.getProperties();
        return s;
    }

    public CorrLineStyle getDefaultLineStyle() {
        return this.defaultStyle;
    }

    public boolean getVisibleOnly() {
        return this.visibleOnly;
    }

    public boolean getUseBlockInterp() {
        return this.useBlockInterp;
    }

    public int getMaxUnconfidence() {
        return this.maxUnconfidence;
    }

    public boolean getCorrelateRangedIntervals() {
        return this.correlateRangedIntervals;
    }

    public CorrelationType getCorrType() {
        if (this.template != null) assert (this.type == this.template.getType());
        return this.type;
    }

    public CorrelationScope getScope() {
        if (this.template != null) assert (this.scope == CorrelationScope.SINGLE);
        return this.scope;
    }

    public boolean includesType(Object o) {
        if (this.dataTypes == null) {
            return false;
        }
        return this.dataTypes.contains(o);
    }

    public boolean hasDatum() {
        return this.datum1 != null;
    }

    public void clearDatum() {
        this.datum2 = null;
        this.datum1 = null;
    }

    public void setDatum(CorrelationLine[] datum) {
        this.datum1 = datum[0];
        this.datum2 = this.datum1 != null ? datum[1] : null;
    }

    public EnumSet getDataTypes() {
        if (this.dataTypes != null) {
            return EnumSet.copyOf(this.dataTypes);
        }
        return null;
    }

    public void setDataTypes(Collection c) {
        if (this.template != null) {
            throw new IllegalStateException("Attempt to set data types on templated correlation");
        }
        if (c.equals(this.dataTypes)) {
            return;
        }
        if (c.isEmpty()) {
            this.dataTypes.clear();
        } else {
            this.dataTypes = EnumSet.copyOf(c);
        }
        this.setPropertyChanged();
    }

    public void setHier(int hier) {
        if (this.template != null) {
            throw new IllegalStateException("Attempt to set hier on templated correlation");
        }
        if (!CorrelationType.isUnitType(this.type)) {
            assert (false);
            return;
        }
        if (this.hier != hier && hier > 0) {
            this.hier = hier;
            this.setPropertyChanged();
        }
    }

    public void setSchID(IGDScheme scheme) {
        if (this.template != null) {
            throw new IllegalStateException("Attempt to set hier on templated correlation");
        }
        if (!CorrelationType.isUnitType(this.type) || scheme == null) {
            assert (false);
            return;
        }
        if (scheme.getIGDType() != DataType.getIGDType((DataType)this.type.getDataType())) {
            throw new IllegalArgumentException("Wrong scheme type for correlation");
        }
        if (this.scheme != scheme) {
            this.scheme = scheme;
            this.setPropertyChanged();
        }
    }

    public Set<CorrelationLine> getLines() {
        return this.lines;
    }

    public CorrelationLine getDatumPrimary() {
        return this.datum1;
    }

    public CorrelationLine getDatumSecondary() {
        return this.datum2;
    }

    public String toString() {
        if (this.template != null) {
            return this.template.getName();
        }
        return Correlation.toDisplayString(this.type, this.scope, this.dataTypes, this.scheme, this.hier);
    }

    public static String toDisplayString(CorrelationType type, CorrelationScope scope, EnumSet dataTypes, IGDScheme scheme, int hier) {
        Object typeString = "";
        if (dataTypes != null) {
            for (Object o : dataTypes) {
                if (!((String)typeString).isEmpty()) {
                    typeString = (String)typeString + ", ";
                }
                if (o instanceof EventType) {
                    typeString = (String)typeString + WellEvent.getType((EventType)((EventType)o));
                    continue;
                }
                typeString = (String)typeString + o.toString();
            }
        }
        if (CorrelationType.isUnitType(type)) {
            typeString = (String)typeString + " (" + IGDIntervalZone.getHierName((int)DataType.getIGDType((DataType)type.getDataType()), (int)hier) + ")";
        }
        String schString = scheme != null ? " [" + scheme.getName() + "]" : "";
        switch (scope) {
            case ALL: {
                return scope.toShortString() + " " + (String)typeString + " " + type.toShortString() + schString;
            }
        }
        return (String)typeString + " " + type.toShortString() + " " + scope.toShortString() + schString;
    }

    public String toDatumString() {
        if (this.datum1 == null) {
            return "";
        }
        Object s = this.datum1.toString();
        if (this.datum2 != null) {
            s = (String)s + ", " + this.datum2.toString();
        }
        return s;
    }

    public void setInterpID(int interpID) {
        if (interpID != this.interpID) {
            this.interpID = interpID;
            for (CorrelationLine l : this.lines) {
                l.setInterpID(interpID);
            }
            this.lines = new HashSet<CorrelationLine>(this.lines);
            this.setPropertyChanged();
        }
    }

    public void setVisibleOnly(boolean visibleOnly) {
        if (this.visibleOnly != visibleOnly) {
            this.visibleOnly = visibleOnly;
            this.setPropertyChanged();
        }
    }

    public void setUseBlockInterp(boolean useBlockInterp) {
        if (this.useBlockInterp != useBlockInterp) {
            this.useBlockInterp = useBlockInterp;
            this.setPropertyChanged();
        }
    }

    public void setMaxUnconfidence(Confidence conf) {
        if (this.maxUnconfidence != conf.getDBint()) {
            this.maxUnconfidence = conf.getDBint();
            this.setPropertyChanged();
        }
    }

    public void setMaxUnconfidence(boolean conf) {
        int unconf;
        int n = unconf = conf ? 100 : 0;
        if (this.maxUnconfidence != unconf) {
            this.maxUnconfidence = unconf;
            this.setPropertyChanged();
        }
    }

    public void setCorrelateRangedIntervals(boolean b) {
        if (this.correlateRangedIntervals != b) {
            this.correlateRangedIntervals = b;
            this.setPropertyChanged();
        }
    }

    public void setDefaultLineColour(Color colour) {
        if (this.defaultStyle.setColour(colour)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineStyle(Boundary bnd) {
        if (this.defaultStyle.setBnd(bnd)) {
            this.setPropertyChanged();
        }
    }

    public void setDefaultLineWeight(float weight) {
        if (this.defaultStyle.setWeight(weight)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabel(boolean label) {
        if (this.defaultStyle.setLabel(label)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabelAbr(boolean labelAbr) {
        if (this.defaultStyle.setLabelAbr(labelAbr)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabelPosition(CorrLineStyle.LabelPosition labelPos) {
        if (this.defaultStyle.setPosition(labelPos)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabelFontSize(ChartProperties.FontSize fontSize) {
        if (this.defaultStyle.setFontSize(fontSize)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabelAlignment(HorizontalAlignment alignment) {
        if (this.defaultStyle.setAlignment(alignment)) {
            this.setSoftChanged();
        }
    }

    public void setDefaultLineLabelShowLabelType(boolean showLabelType) {
        if (this.defaultStyle.setShowLabelType(showLabelType)) {
            this.setSoftChanged();
        }
    }

    public void setLines(Set<CorrelationLine> lines) {
        this.lines = lines;
    }

    private void setDatum(String datumString) {
        if (datumString == null || datumString.isEmpty()) {
            return;
        }
        String[] s = datumString.split(",");
        block4: for (int i = 0; i < s.length && (i <= 0 || this.datum1 != null); ++i) {
            CorrelationLine datum = null;
            for (CorrelationLine l : this.lines) {
                if (!l.getDatumString().equals(s[i])) continue;
                datum = l;
                break;
            }
            if (datum == null) continue;
            switch (i) {
                case 0: {
                    this.datum1 = datum;
                    continue block4;
                }
                case 1: {
                    this.datum2 = datum;
                }
            }
        }
    }

    public String getDatumString() {
        if (this.datum1 == null) {
            return null;
        }
        assert (this.lines.contains(this.datum1));
        Object s = this.datum1.getDatumString();
        if (this.datum2 != null) {
            assert (this.lines.contains(this.datum2));
            s = (String)s + "," + this.datum2.getDatumString();
        }
        return s;
    }

    public void setSelected(boolean selected) {
        if (selected == this.isSelected) {
            return;
        }
        this.isSelected = selected;
    }

    public float getDefaultLineWeight() {
        return this.defaultStyle.getWeight();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void prepareData(ChartUpdate update) {
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
    }
}

