/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.correlation;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.CorrelationType;
import model3.SBdb;
import util.SB;
import util.SbugsLink;

public abstract class CorrelationLine
implements Comparable<CorrelationLine> {
    private final CorrelationType corrType;
    private CorrLineStyle style;
    private Integer interpID;
    public static final String DATUM_SEP_INNER = "-";
    public static final String DATUM_SEP_OUTER = ",";

    CorrelationLine(String props, CorrelationType corrType) {
        this.corrType = corrType;
        if (props != null && !props.isEmpty()) {
            this.style = new CorrLineStyle(props);
        }
    }

    CorrelationLine(CorrelationType corrType, CorrLineStyle style, Integer interpID) {
        this.corrType = corrType;
        this.style = style;
        this.interpID = interpID;
    }

    public Object getObject() {
        return null;
    }

    public Object getObjectType() {
        return null;
    }

    public CorrLineStyle getStyle() {
        return this.style;
    }

    void setStyle(CorrLineStyle style) {
        this.style = style;
    }

    public CorrelationType getCorrelationType() {
        return this.corrType;
    }

    public int getInterpID() {
        return this.interpID;
    }

    void setInterpID(int interpID) {
        this.interpID = interpID;
    }

    public Color getColour() {
        if (this.style.getColour() == null || this.style.getColour().equals(Color.WHITE)) {
            return Color.DARK_GRAY;
        }
        return this.style.getColour();
    }

    public CorrLineStyle.LabelPosition getLabelPosition() {
        if (this.style.getLabelPosition() == null) {
            return this.getDefaultLabelPosition();
        }
        return this.style.getLabelPosition();
    }

    abstract CorrLineStyle.LabelPosition getDefaultLabelPosition();

    public boolean equals(Object o) {
        if (!(o instanceof CorrelationLine)) {
            return false;
        }
        CorrelationLine rhs = (CorrelationLine)o;
        if (!this.canEqual(o)) {
            return false;
        }
        if (this.corrType != rhs.corrType) {
            return false;
        }
        return SB.equal((Object)this.interpID, (Object)rhs.interpID);
    }

    public boolean canEqual(Object o) {
        return o instanceof CorrelationLine;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.corrType != null ? this.corrType.hashCode() : 0);
        hash = 29 * hash + (this.interpID != null ? this.interpID.hashCode() : 0);
        return hash;
    }

    public boolean hasLink() {
        return ((SbugsLink)this.getObject()).getLink() != null;
    }

    abstract void store(int var1, SBdb var2, Statement var3) throws SQLException;

    abstract String getDatumString();

    abstract boolean updateObjectType(Object var1);

    abstract CorrelationLine copy();

    abstract CorrelationLine copyLink();

    abstract void writeXML(BufferedWriter var1, int var2) throws IOException;
}

