/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics;

import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.map.SBMapRenderer;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.SBTextMeasurer;
import jsbchart.graphics.text.TextArtist;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextRenderer;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;
import jsbchart.util.CompassDirection;
import model3.IGDIntervalZone;
import org.apache.fop.svg.PDFGraphics2D;
import org.geotools.map.MapContent;
import util.AttributedStringUtils;
import util.ColourUtils;
import util.SB;
import util.TextStroke;

public class SBGraphics {
    private static final Logger LOGGER = Logger.getLogger(SBGraphics.class.getName());
    private static boolean DEBUG = false;
    public static final float scale = 100.0f;
    public static final int IMG_SCALE = 10;
    private final Graphics2D g;
    private Shape clip = null;
    private final Rectangle visibleRect;
    private final SBMapRenderer mapRenderer;
    private AffineTransform originalTransform = null;
    private float zoom = 1.0f;
    public static final int ALIGN_CENTRE = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    private boolean greyscale = false;

    public SBGraphics(Graphics2D g, Rectangle visibleRect, boolean antialias, boolean onScreen) {
        this.g = g;
        this.visibleRect = visibleRect;
        if (antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.mapRenderer = new SBMapRenderer();
    }

    public void renderMap(MapContent mapContent) {
        Shape clip1 = this.g.getClip();
        try {
            this.mapRenderer.renderMap(this.g, mapContent);
        }
        finally {
            this.g.setClip(clip1);
        }
    }

    public void setOriginalTransform(AffineTransform transform) {
        this.originalTransform = transform;
    }

    public AffineTransform getOriginalTransform() {
        return this.originalTransform;
    }

    public void setZoomLevel(float zoom) {
        this.zoom = zoom;
    }

    public float getZoomLevel() {
        return this.zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMap(MapContent mapContent, Rectangle2D.Float mapArea) {
        Shape clip1 = this.g.getClip();
        AffineTransform originalTransform = this.g.getTransform();
        try {
            Rectangle area = new Rectangle((int)(mapArea.x * 100.0f), (int)(mapArea.y * 100.0f), (int)(mapArea.width * 100.0f), (int)(mapArea.height * 100.0f));
            this.g.clip(area);
            if (originalTransform != null) {
                this.g.setTransform(originalTransform);
            }
            this.mapRenderer.renderMap(this.g, mapContent);
        }
        finally {
            this.g.setTransform(originalTransform);
            this.g.setClip(clip1);
        }
    }

    private static int scale(double f) {
        return (int)(f * 100.0);
    }

    private static float getScale() {
        return 100.0f;
    }

    public void setColor(Color colour) {
        if (this.greyscale) {
            colour = ColourUtils.getGreyColour((Color)colour);
        }
        this.g.setColor(colour);
    }

    void setColorContrasting(Color baseColor) {
        this.setColor(ColourUtils.getContrastingColour((Color)baseColor));
    }

    public void setColorContrastingBW(Color baseColor) {
        if (baseColor.getRed() + baseColor.getGreen() + baseColor.getBlue() > 384) {
            this.setColor(Color.BLACK);
        } else {
            this.setColor(Color.WHITE);
        }
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public void setFont(String name, int style, float size) {
        this.g.setFont(new Font(name, style, (int)(size * SBGraphics.getScale())));
    }

    public float getFontSize() {
        return (float)this.getFont().getSize() / SBGraphics.getScale();
    }

    public void setFontSize(float size) {
        Font font = this.getFont();
        this.g.setFont(new Font(font.getName(), font.getStyle(), (int)(size * SBGraphics.getScale())));
    }

    public void setFontStyle(int style) {
        this.g.setFont(this.getFont().deriveFont(style));
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public boolean clipLine(Line2D.Float line, float left, float top, float right, float base) {
        boolean drawline = this.clipLine2(line, left, base, right, top);
        if (drawline) {
            float tempX1 = line.x1;
            float tempY1 = line.y1;
            line.x1 = line.x2;
            line.y1 = line.y2;
            line.x2 = tempX1;
            line.y2 = tempY1;
            drawline = this.clipLine2(line, left, base, right, top);
            if (drawline) {
                tempX1 = line.x1;
                tempY1 = line.y1;
                line.x1 = line.x2;
                line.y1 = line.y2;
                line.x2 = tempX1;
                line.y2 = tempY1;
            }
        }
        return drawline;
    }

    boolean clipLine2(Line2D.Float line, float tx1, float ty1, float tx2, float ty2) {
        float dy;
        float dx;
        float m;
        float left = Math.min(tx1, tx2);
        float right = Math.max(tx1, tx2);
        float top = Math.min(ty1, ty2);
        float base = Math.max(ty1, ty2);
        if (line.x1 < left) {
            if (line.x2 < left) {
                return false;
            }
            m = line.x2 != line.x1 ? (line.y2 - line.y1) / (line.x2 - line.x1) : 0.0f;
            line.y1 += m * (left - line.x1);
            line.x1 = left;
        }
        if (line.x1 > right) {
            if (line.x2 > right) {
                return false;
            }
            m = line.x2 != line.x1 ? (line.y2 - line.y1) / (line.x2 - line.x1) : 0.0f;
            line.y1 += m * (right - line.x1);
            line.x1 = right;
        }
        if (line.y1 < top) {
            if (line.y2 < top) {
                return false;
            }
            dx = line.x2 - line.x1;
            dy = line.y2 - line.y1;
            line.x1 += dx / dy * (top - line.y1);
            line.y1 = top;
        }
        if (line.y1 > base) {
            if (line.y2 > base) {
                return false;
            }
            dx = line.x2 - line.x1;
            dy = line.y2 - line.y1;
            line.x1 += dx / dy * (base - line.y1);
            line.y1 = base;
        }
        return true;
    }

    public static void appendLine(GeneralPath p, float x1, float y1, float x2, float y2) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        p.lineTo(ix1, iy1);
        p.lineTo(ix2, iy2);
    }

    public static void appendLine(GeneralPath p, float x, float y) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.lineTo(ix, iy);
    }

    public static void appendMove(GeneralPath p, float x, float y) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.moveTo(ix, iy);
    }

    public static void appendCurve(GeneralPath p, float x1, float y1, float x2, float y2, float x3, float y3) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        int ix3 = (int)(x3 * SBGraphics.getScale());
        int iy3 = (int)(y3 * SBGraphics.getScale());
        p.curveTo(ix1, iy1, ix2, iy2, ix3, iy3);
    }

    public static void appendQuad(GeneralPath p, float x1, float y1, float x2, float y2) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        p.quadTo(ix1, iy1, ix2, iy2);
    }

    public void appendEllipse(GeneralPath p, float x, float y, float w, float h, boolean connect) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iw = (int)(w * SBGraphics.getScale());
        int ih = (int)(h * SBGraphics.getScale());
        p.append(new Ellipse2D.Float(ix, iy, iw, ih), connect);
    }

    public void appendRect(GeneralPath p, float x, float y, float w, float h, boolean connect) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iw = (int)(w * SBGraphics.getScale());
        int ih = (int)(h * SBGraphics.getScale());
        p.append(new Rectangle2D.Float(ix, iy, iw, ih), connect);
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        if (ix2 - ix1 == 0 && iy2 - iy1 == 0) {
            return;
        }
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(Math.min(ix1, ix2), Math.min(iy1, iy2), Math.abs(ix2 - ix1) + 1, Math.abs(iy2 - iy1) + 1))) {
            this.g.drawLine(ix1, iy1, ix2, iy2);
        }
    }

    void drawRotatedLine(float x1, float x2, float y) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        GeneralPath p = SBGraphics.createGeneralPath(x1, y);
        p.lineTo(ix2, iy);
        this.g.draw(p);
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(90.0), ix1, iy);
        p.transform(transform);
        this.g.draw(p);
    }

    public GeneralPath getRotatedPath(GeneralPath p, double angle, float x, float y) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        AffineTransform transform = new AffineTransform();
        transform.rotate(angle, ix, iy);
        p.transform(transform);
        return p;
    }

    public GeneralPath getTranslatedPath(GeneralPath p, double x, double y) {
        int ix = (int)(x * (double)SBGraphics.getScale());
        int iy = (int)(y * (double)SBGraphics.getScale());
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        p.transform(transform);
        return p;
    }

    public void drawLine(Line2D.Float line) {
        float x1 = line.x1;
        float y1 = line.y1;
        float x2 = line.x2;
        float y2 = line.y2;
        this.drawLine(x1, y1, x2, y2);
    }

    public static GeneralPath createGeneralPath(float x, float y) {
        GeneralPath p = new GeneralPath();
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        p.moveTo(ix, iy);
        return p;
    }

    public Rectangle createRect(float x, float y, float width, float height) {
        int ix = (int)(x * SBGraphics.getScale());
        int iy = (int)(y * SBGraphics.getScale());
        int iwidth = (int)(width * SBGraphics.getScale());
        int iheight = (int)(height * SBGraphics.getScale());
        return new Rectangle(ix, iy, iwidth, iheight);
    }

    private Shape getTextShape(String str, int x, int y) {
        FontRenderContext frc = this.g.getFontRenderContext();
        TextLayout tl = new TextLayout(str, this.g.getFont(), frc);
        AffineTransform at = new AffineTransform();
        at.setToTranslation(x, y);
        return tl.getOutline(at);
    }

    public Shape appendBnd(GeneralPath p, int bnd, float x1, float x2, float y1, float y2) {
        Shape s = null;
        float midx = x2 > x1 ? x1 + Math.abs(x1 - x2) / 2.0f : x1 - Math.abs(x1 - x2) / 2.0f;
        switch (bnd) {
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                SBGraphics.appendLine(p, x2, y2);
                break;
            }
            case 1: 
            case 2: {
                Line2D.Float line = new Line2D.Float((int)(x1 * SBGraphics.getScale()), (int)(y1 * SBGraphics.getScale()), (int)(x2 * SBGraphics.getScale()), (int)(y2 * SBGraphics.getScale()));
                s = this.getStroke().createStrokedShape(line);
                SBGraphics.appendMove(p, x2, y2);
                break;
            }
            case 4: {
                this.appendUnconf(p, x1, x2, y2, false, false, false, false);
                break;
            }
            case 5: {
                s = this.appendUnconf(p, x1, x2, y2, true, false, false, false);
            }
        }
        if (IGDIntervalZone.isFaultBnd((int)bnd)) {
            float w1 = 0.8f;
            float w2 = 0.16f;
            float w3 = 3.5f;
            float h = 1.75f;
            GeneralPath gp = new GeneralPath();
            switch (bnd) {
                case 7: {
                    Font font = this.g.getFont();
                    this.setFont(font.getName(), font.getStyle(), 2.0f);
                    gp.append(this.getTextShape("?", (int)((midx - 2.0f) * SBGraphics.getScale()), (int)((y2 - 0.3f) * SBGraphics.getScale())), false);
                    this.setFont(font);
                }
                case 6: {
                    this.appendEllipse(gp, midx - 0.4f, y2 - 1.75f, 0.8f, 0.8f, false);
                    this.appendRect(gp, midx - 0.08f, y2 - 1.75f + 0.4f, 0.16f, 1.35f, false);
                    break;
                }
                case 8: {
                    this.appendRect(gp, midx - 1.75f, y2 - 0.7f, 3.5f, 0.7f, false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            s = gp;
        }
        return s;
    }

    public Shape appendUnconf(GeneralPath p, float x1, float x2, float y, boolean q, boolean flatStart, boolean flatEnd, boolean forceUp) {
        return this.appendUnconf(p, x1, x2, y, y, q, flatStart, flatEnd, forceUp);
    }

    public Shape appendUnconf(GeneralPath path, float x1, float x2, float y1, float y2, boolean q, boolean flatStart, boolean flatEnd, boolean forceUp) {
        int space;
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        AffineTransform transform = null;
        if ((double)Math.abs(y1 - y2) > 0.01) {
            double xDiff = ix2 - ix1;
            double yDiff = iy2 - iy1;
            double angle = Math.atan(yDiff / xDiff);
            space = (int)Math.sqrt(Math.pow(xDiff, 2.0) + Math.pow(yDiff, 2.0));
            transform = new AffineTransform();
            transform.rotate(angle, ix1, iy1);
        } else {
            space = Math.max(ix1, ix2) - Math.min(ix1, ix2);
        }
        int amp = (int)(1.3 * (double)SBGraphics.getScale());
        Font font = null;
        GeneralPath qs = null;
        if (q) {
            font = this.g.getFont();
            int fontSize = amp;
            this.g.setFont(new Font(font.getName(), font.getStyle(), fontSize));
            qs = new GeneralPath();
        }
        int wavelength = (int)(2.25 * (double)SBGraphics.getScale());
        int nWaves = (int)Math.floor(space / wavelength);
        GeneralPath p = SBGraphics.createGeneralPath(x1, y1);
        if (nWaves > 0) {
            wavelength = space / nWaves;
            if (ix2 < ix1) {
                wavelength *= -1;
            }
            if (flatStart) {
                --nWaves;
            }
            if (flatEnd) {
                --nWaves;
            }
            boolean above = false;
            if (nWaves % 2 == 0 && ix2 < ix1) {
                above = true;
            }
            if (forceUp && nWaves % 2 != 0) {
                above = !above;
            }
            int start = ix1;
            if (flatStart) {
                p.lineTo(start + wavelength, iy1);
                start += wavelength;
            }
            int end = start + wavelength;
            for (int wavesDrawn = 0; wavesDrawn < nWaves; ++wavesDrawn) {
                p.curveTo(start, iy1, start + (end - start) / 2, above ? iy1 - amp : iy1 + amp, end, iy1);
                if (!above && qs != null) {
                    qs.append(this.getTextShape("?", start + (int)((double)(end - start) / 2.75), iy1 + amp / 5), false);
                }
                start = end;
                end = start + wavelength;
                above = !above;
            }
            if (font != null) {
                this.g.setFont(font);
            }
        } else if (!flatEnd && Math.abs(ix1 - ix2) > 0) {
            flatEnd = true;
        }
        if (transform != null) {
            p.transform(transform);
            if (qs != null) {
                qs.transform(transform);
            }
        }
        if (flatEnd) {
            p.lineTo(ix2, iy2);
        }
        path.append(p, true);
        return qs;
    }

    public Rectangle getRectangle(float x, float y, float width, float height) {
        return new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
    }

    boolean contains(float[] xPoints, float[] yPoints, int x, int y) {
        int n = xPoints.length;
        int[] ixPoints = new int[n];
        int[] iyPoints = new int[n];
        for (int i = 0; i < n; ++i) {
            ixPoints[i] = (int)(xPoints[i] * SBGraphics.getScale());
            iyPoints[i] = (int)(yPoints[i] * SBGraphics.getScale());
        }
        Polygon polygon = new Polygon(ixPoints, iyPoints, n);
        return polygon.contains((int)((float)x * SBGraphics.getScale()), (int)((float)y * 100.0f));
    }

    public void setStroke(float size) {
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), 0, 0));
    }

    public void setStroke(float size, int butt, int join) {
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), butt, join));
    }

    public void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    public BasicStroke getStroke() {
        return (BasicStroke)this.g.getStroke();
    }

    public void setDashStroke(float width) {
        float[] dash = new float[]{width * 1.6f * SBGraphics.getScale(), width * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(width * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    public void setDashStroke(float width, float size) {
        float[] dash = new float[]{size * SBGraphics.getScale(), size * 0.75f * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(width * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    public void setDotStroke(float size) {
        float[] dash = new float[]{size * SBGraphics.getScale(), size * SBGraphics.getScale()};
        this.g.setStroke(new BasicStroke(size * SBGraphics.getScale(), 0, 0, 10.0f, dash, 0.0f));
    }

    public void drawString(String string, float x, float y) {
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)((y - this.stringHeightSB()) * SBGraphics.getScale()), (int)(this.stringWidth(string) * SBGraphics.getScale()), (int)(this.stringHeight() * SBGraphics.getScale()));
        String s = string;
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.drawStringInternal(s, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    public boolean drawString(String string, float x, float y, float width, int alignment, boolean truncate) {
        float xPos;
        String trunc = this.truncateString(string, width);
        if (!truncate && !SB.equal((Object)string, (Object)trunc)) {
            return false;
        }
        string = trunc;
        if (string == null || string.isEmpty()) {
            return true;
        }
        switch (alignment) {
            case 0: {
                xPos = (x + width / 2.0f - this.stringWidth(string) / 2.0f) * SBGraphics.getScale();
                break;
            }
            case 2: {
                xPos = x * SBGraphics.getScale() - this.stringWidth(string) * SBGraphics.getScale();
                break;
            }
            default: {
                this.drawString(string, x, y);
                return true;
            }
        }
        Rectangle rect = new Rectangle((int)xPos, (int)((y - this.stringHeightSB()) * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(this.stringHeight() * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.drawStringInternal(string, xPos, y * SBGraphics.getScale());
        }
        return true;
    }

    public float drawStringBox(String string, float x, float y, float width, float height, int alignment, boolean vertCentre) {
        float ypos;
        float f = ypos = vertCentre ? y + height / 2.0f - (float)this.getFont().getSize() / SBGraphics.getScale() / 2.0f : y + (float)this.getFont().getSize() / SBGraphics.getScale();
        if (this.stringWidth(string) < width) {
            this.drawString(string, x, ypos, width, alignment, true);
            return ypos + 0.5f;
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringTokenizer tokeniser = new StringTokenizer(string, " ");
        Object text = "";
        while (tokeniser.hasMoreTokens()) {
            String tok = tokeniser.nextToken();
            if (this.stringWidth((String)text + tok) < width) {
                text = (String)text + tok + " ";
                continue;
            }
            if (this.stringWidth(tok) < width) {
                lines.add(((String)text).trim());
                text = tok + " ";
                continue;
            }
            text = this.addStringLine(lines, (String)text + tok, width);
        }
        if (!((String)text).isEmpty()) {
            lines.add(((String)text).trim());
        }
        float lineHeight = (float)this.getFont().getSize() / SBGraphics.getScale() + 0.5f;
        if (vertCentre) {
            float totalTextHeight = (float)lines.size() * lineHeight;
            ypos = totalTextHeight > height ? y + (float)this.getFont().getSize() / SBGraphics.getScale() : y + height / 2.0f - totalTextHeight / 2.0f;
        }
        for (int i = 0; i < lines.size(); ++i) {
            Object line = (String)lines.get(i);
            if (i > 0) {
                ypos += lineHeight;
            }
            if (ypos + lineHeight > y + height && i < lines.size() - 1) {
                line = (String)line + "...";
            }
            this.drawString((String)line, x, ypos, width, alignment, true);
            if (ypos + lineHeight > y + height) break;
        }
        return ypos + 0.5f;
    }

    private String addStringLine(List<String> lines, String strg, float width) {
        if (this.stringWidth(strg) < width) {
            return strg + " ";
        }
        String trunc = strg.substring(0, strg.length() - 1) + "-";
        while (this.stringWidth(trunc) > width && trunc.length() > 1) {
            trunc = trunc.substring(0, trunc.length() - 2) + "-";
        }
        if (trunc.length() > 1) {
            lines.add(trunc);
            return this.addStringLine(lines, strg.substring(trunc.length() - 1), width);
        }
        lines.add("..");
        return "";
    }

    public boolean drawString(AttributedString string, float x, float y, float maxWidth, boolean truncate) {
        AttributedString s = string;
        if (this.g instanceof PdfBoxGraphics2D) {
            s = AttributedStringUtils.changeAttributeStringPOSTURE_OBLIQUEtoFONT((AttributedString)string, (Font)this.getFont());
        }
        Object strg = "";
        AttributedCharacterIterator it = s.getIterator();
        strg = (String)strg + it.first();
        for (int i = it.getBeginIndex(); i < it.getEndIndex() - 1; ++i) {
            strg = (String)strg + it.next();
        }
        it.setIndex(it.getBeginIndex());
        float height = this.stringWidth((String)strg) * SBGraphics.getScale();
        float width = this.stringHeight() * SBGraphics.getScale();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        AttributedCharacterIterator truncated = this.truncateString(s, (String)strg, maxWidth);
        if (!SB.equal((Object)truncated, (Object)it) && !truncate) {
            return false;
        }
        it = truncated;
        if ((this.visibleRect == null || this.visibleRect.intersects(rect)) && it != null) {
            this.g.drawString(it, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
        return true;
    }

    public boolean drawStringVertical(String string, float x, float y, float maxHeight, boolean centre, boolean vertCentre, boolean truncate) {
        float height = this.stringWidth(string) * SBGraphics.getScale();
        float width = this.stringHeight() * SBGraphics.getScale();
        String trunc = this.truncateString(string, maxHeight);
        if (!truncate && !SB.equal((Object)trunc, (Object)string)) {
            return false;
        }
        string = trunc;
        if (string == null) {
            return true;
        }
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - maxHeight * SBGraphics.getScale()), (int)width, (int)(maxHeight * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            if (centre) {
                x += this.stringHeightSB() / 2.0f;
            }
            if (vertCentre) {
                y = y - maxHeight / 2.0f + this.stringWidth(string) / 2.0f;
            }
            this.g.rotate(-1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.drawStringInternal(string, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.rotate(1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
        return true;
    }

    public boolean drawStringVertical(String string, float x, float y, float maxHeight, boolean vertCentre, boolean truncate, Float maxWidth) {
        String trunc = this.truncateString(string, maxHeight);
        if (string == null) {
            return false;
        }
        ArrayList<Object> lines = new ArrayList<String>();
        if (!Objects.equals(trunc, string)) {
            if (maxWidth != null) {
                lines = this.wrapText(string, maxHeight);
                if ((float)lines.size() * this.stringHeight() > maxWidth.floatValue()) {
                    if (!truncate) {
                        return false;
                    }
                    lines.clear();
                    lines.add(trunc);
                }
            } else {
                if (!truncate) {
                    return false;
                }
                if (string == null) {
                    return true;
                }
                lines.add(trunc);
            }
        } else {
            lines.add(string);
        }
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale() - maxHeight * SBGraphics.getScale()), (int)(this.stringHeight() * SBGraphics.getScale()), (int)(maxHeight * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            float xpos;
            if (maxWidth != null) {
                float totalWidth = (float)lines.size() * this.stringHeight();
                xpos = x + maxWidth.floatValue() / 2.0f - totalWidth / 2.0f;
                xpos += this.stringHeight();
            } else {
                xpos = x + this.stringHeightSB() / 2.0f;
            }
            for (String string2 : lines) {
                float ypos = y;
                if (vertCentre) {
                    ypos = y - maxHeight / 2.0f + this.stringWidth(string2) / 2.0f;
                }
                if (string2 == null) continue;
                this.g.rotate(-1.5707963267948966, xpos * SBGraphics.getScale(), ypos * SBGraphics.getScale());
                this.drawStringInternal(string2, xpos * SBGraphics.getScale(), ypos * SBGraphics.getScale());
                this.g.rotate(1.5707963267948966, xpos * SBGraphics.getScale(), ypos * SBGraphics.getScale());
                xpos += this.stringHeight();
            }
        }
        return true;
    }

    private String truncateString(String string, float maxWidth) {
        if (((String)string).isEmpty()) {
            return string;
        }
        float width = this.calcStringWidth((String)string);
        if (width > maxWidth) {
            while (this.calcStringWidth((String)string + "...") > maxWidth - 2.0f) {
                if (((String)string).length() < 2) {
                    return null;
                }
                if (!((String)(string = ((String)string).substring(0, ((String)string).length() - 1))).isEmpty()) continue;
                return "";
            }
            string = ((String)string).trim() + "...";
        }
        return string;
    }

    private float calcStringWidth(String string) {
        return this.stringWidth(string);
    }

    public void drawStringAngleCentre(String string, float x, float y, double angle, double transX, double transY) {
        float width = this.g.getFontMetrics().stringWidth(string);
        if (angle != 0.0) {
            this.g.rotate(angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
        if (transX != 0.0 || transY != 0.0) {
            this.g.translate(transX * (double)SBGraphics.getScale(), transY * (double)SBGraphics.getScale());
        }
        this.drawStringInternal(string, x * SBGraphics.getScale() - width / 2.0f, y * SBGraphics.getScale());
        if (transX != 0.0 || transY != 0.0) {
            this.g.translate(-transX * (double)SBGraphics.getScale(), -transY * (double)SBGraphics.getScale());
        }
        if (angle != 0.0) {
            this.g.rotate(-angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    public void drawRotatedStringLine(String string, float x1, float y1, float x2, float y2, Boolean below, float stroke, Color background) {
        int ix1 = (int)(x1 * SBGraphics.getScale());
        int iy1 = (int)(y1 * SBGraphics.getScale());
        int ix2 = (int)(x2 * SBGraphics.getScale());
        int iy2 = (int)(y2 * SBGraphics.getScale());
        stroke *= SBGraphics.getScale();
        int stringWidth = this.g.getFontMetrics(this.g.getFont()).stringWidth(string);
        int stringHeight = this.g.getFontMetrics().getAscent() - this.g.getFontMetrics().getDescent();
        if (below == null) {
            iy1 += stringHeight / 2;
            iy2 += stringHeight / 2;
        } else {
            double alpha = Math.atan2(ix2 - ix1, iy2 - iy1);
            double h = below != false ? (double)stringHeight * 1.3 + (double)stroke : (double)((float)(stringHeight / 3) + stroke);
            double yOffset = h / Math.sin(alpha);
            if (below.booleanValue()) {
                iy1 = (int)((double)iy1 + yOffset);
                iy2 = (int)((double)iy2 + yOffset);
            } else {
                iy1 = (int)((double)iy1 - yOffset);
                iy2 = (int)((double)iy2 - yOffset);
            }
        }
        double xDiff = ix2 - ix1;
        double yDiff = iy2 - iy1;
        double angle = Math.atan2(yDiff, xDiff);
        double h = stringWidth / 2;
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation((double)ix1 + xDiff / 2.0 - Math.cos(angle) * h, (double)iy1 + yDiff / 2.0 - Math.sin(angle) * h);
        transform.rotate(angle);
        FontRenderContext frc = this.g.getFontRenderContext();
        TextLayout tl = new TextLayout(string, this.g.getFont(), frc);
        Shape outline = tl.getOutline(transform);
        if (below == null) {
            Color c = this.g.getColor();
            this.setColor(background);
            this.g.setStroke(new BasicStroke(0.5f * SBGraphics.getScale(), 0, 2));
            this.g.draw(outline);
            this.setColor(c);
        }
        this.g.fill(outline);
    }

    public void rotate(double angle, float x, float y) {
        this.g.rotate(angle, x * SBGraphics.getScale(), y * SBGraphics.getScale());
    }

    public void drawStringVertical(String string, float x, float y) {
        float height = this.stringWidth(string);
        float width = this.stringHeight();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.g.rotate(-1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.drawStringInternal(string, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.rotate(1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
    }

    public boolean drawStringVertical(AttributedString string, float x, float y, float maxHeight, boolean truncate) {
        AttributedString s = string;
        if (this.g instanceof PdfBoxGraphics2D) {
            s = AttributedStringUtils.changeAttributeStringPOSTURE_OBLIQUEtoFONT((AttributedString)string, (Font)this.getFont());
        }
        Object strg = "";
        AttributedCharacterIterator it = s.getIterator();
        strg = (String)strg + it.first();
        for (int i = it.getBeginIndex(); i < it.getEndIndex() - 1; ++i) {
            strg = (String)strg + it.next();
        }
        it.setIndex(it.getBeginIndex());
        float height = this.stringWidth((String)strg) * SBGraphics.getScale();
        float width = this.stringHeight() * SBGraphics.getScale();
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale() - width), (int)(y * SBGraphics.getScale() - height), (int)width, (int)height);
        AttributedCharacterIterator truncated = this.truncateString(s, (String)strg, maxHeight);
        if (!SB.equal((Object)truncated, (Object)it) && !truncate) {
            return false;
        }
        it = truncated;
        if (this.visibleRect == null || this.visibleRect.intersects(rect)) {
            this.g.rotate(-1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.drawString(it, x * SBGraphics.getScale(), y * SBGraphics.getScale());
            this.g.rotate(1.5707963267948966, x * SBGraphics.getScale(), y * SBGraphics.getScale());
        }
        return true;
    }

    public void drawString(String string, Point2D point1, Point2D point2) {
        Point2D p2;
        Point2D p1;
        if (point1.getY() < point2.getY()) {
            p1 = point1;
            p2 = point2;
        } else {
            p1 = point2;
            p2 = point1;
        }
        double xpos = Math.min(p1.getX(), p2.getX()) + Math.abs(p1.getX() - p2.getX()) / 2.0 + 1.0;
        double ypos = p1.getY() + (p2.getY() - p1.getY()) / 2.0;
        if (Math.abs(p1.getY() - p2.getY()) < 1.0) {
            xpos -= (double)(this.stringWidth(string) / 2.0f);
            ypos += (double)(this.stringHeight() + 1.0f);
        } else if (Math.abs(p1.getX() - p2.getX()) < 1.0) {
            ypos += (double)(this.stringHeight() / 2.0f);
        } else if (p1.getX() > p2.getX()) {
            ypos += (double)this.stringHeight();
        }
        this.drawStringInternal(string, (float)xpos * SBGraphics.getScale(), (float)ypos * SBGraphics.getScale());
    }

    private AttributedCharacterIterator truncateString(AttributedString atString, String string, float maxWidth) {
        float width = this.stringWidth(string);
        if (width > maxWidth) {
            while (this.stringWidth(string) > maxWidth - 2.0f) {
                if (string.length() < 1) {
                    return null;
                }
                if (!(string = string.substring(0, string.length() - 1)).isEmpty()) continue;
                return null;
            }
        }
        return atString.getIterator(null, 0, string.length());
    }

    public boolean drawStringBox(String string, float left, float top, float width, float height, boolean vertical) {
        Rectangle2D stringRect = this.g.getFontMetrics().getStringBounds(string, this.g);
        Rectangle2D.Float bound = new Rectangle2D.Float(left * SBGraphics.getScale(), top * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        if (this.visibleRect == null || this.visibleRect.intersects(bound)) {
            if (vertical) {
                if (((RectangularShape)bound).getHeight() >= stringRect.getWidth() && ((RectangularShape)bound).getWidth() >= stringRect.getHeight()) {
                    this.g.rotate(-1.5707963267948966, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    this.drawStringInternal(string, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    this.g.rotate(1.5707963267948966, (float)(bound.getCenterX() + stringRect.getHeight() / 3.0), (float)(bound.getCenterY() + stringRect.getWidth() / 2.0));
                    return true;
                }
                return false;
            }
            if (((RectangularShape)bound).getWidth() >= stringRect.getWidth() && ((RectangularShape)bound).getHeight() >= stringRect.getHeight()) {
                this.drawStringInternal(string, (float)(bound.getCenterX() - stringRect.getWidth() / 2.0), (float)(bound.getCenterY() + stringRect.getHeight() / 3.0));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean drawStringBox(String string, float left, float top, float width, float height, boolean verticalPreferred, boolean verticalAllowed, int nIts) {
        return this.drawStringBox(string, null, left, top, width, height, verticalPreferred, verticalAllowed, nIts, null);
    }

    public boolean drawStringBox(String string, String vertString, float left, float top, float width, float height, boolean verticalPreferred, boolean verticalAllowed, int nIts, Color backgroundColor) {
        return this.drawStringBox(string, vertString, left, top, width, height, 0.0f, 0.0f, 0.0f, 0.0f, verticalPreferred, verticalAllowed, nIts, backgroundColor);
    }

    public boolean drawStringBox(String string, String vertString, float left, float top, float width, float height, float leftIndent, float rightIndent, float topIndent, float baseIndent, boolean verticalPreferred, boolean verticalAllowed, int nIts, Color backgroundColor) {
        Rectangle2D.Float bound = new Rectangle2D.Float(left * SBGraphics.getScale(), top * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        float leftIndentSz = leftIndent * SBGraphics.getScale();
        float rightIndentSz = rightIndent * SBGraphics.getScale();
        float topIndentSz = topIndent * SBGraphics.getScale();
        float baseIndentSz = baseIndent * SBGraphics.getScale();
        float fontSize = (float)this.getFont().getSize() / SBGraphics.getScale();
        boolean fitsVert = false;
        boolean fitsHorz = false;
        for (int i = 0; i < nIts; ++i) {
            String[] horzSplit;
            String[] vertSplit;
            Rectangle2D vertStringRect = null;
            if (vertString == null) {
                vertString = string;
            }
            for (String s : vertSplit = vertString.split("\\n")) {
                if (vertStringRect == null) {
                    vertStringRect = this.g.getFontMetrics().getStringBounds(s, this.g);
                    continue;
                }
                Rectangle2D vertStringRect2 = this.g.getFontMetrics().getStringBounds(s, this.g);
                vertStringRect = new Rectangle((int)Math.max(vertStringRect.getWidth(), vertStringRect2.getWidth()), (int)(vertStringRect.getHeight() + vertStringRect2.getHeight()));
            }
            Rectangle2D horzStringRect = null;
            for (String s : horzSplit = string.split("\\n")) {
                if (horzStringRect == null) {
                    horzStringRect = this.g.getFontMetrics().getStringBounds(s, this.g);
                    continue;
                }
                Rectangle2D horzStringRect2 = this.g.getFontMetrics().getStringBounds(s, this.g);
                horzStringRect = new Rectangle((int)Math.max(horzStringRect.getWidth(), horzStringRect2.getWidth()), (int)(horzStringRect.getHeight() + horzStringRect2.getHeight()));
            }
            if (vertStringRect != null && vertStringRect.getWidth() < ((RectangularShape)bound).getHeight() && vertStringRect.getHeight() < ((RectangularShape)bound).getWidth() - (double)(leftIndentSz + rightIndentSz) || vertStringRect.getWidth() < ((RectangularShape)bound).getHeight() - (double)(topIndentSz + baseIndentSz) && vertStringRect.getHeight() < ((RectangularShape)bound).getWidth()) {
                fitsVert = true;
            }
            if (horzStringRect != null && horzStringRect.getWidth() < ((RectangularShape)bound).getWidth() && horzStringRect.getHeight() < ((RectangularShape)bound).getHeight() - (double)(topIndentSz + baseIndentSz) || horzStringRect.getWidth() < ((RectangularShape)bound).getWidth() - (double)(leftIndentSz + rightIndentSz) && horzStringRect.getHeight() < ((RectangularShape)bound).getHeight()) {
                fitsHorz = true;
            }
            if (fitsVert && (verticalPreferred || !fitsHorz && verticalAllowed && string.length() > 1)) {
                float textWidth = this.stringHeight() * (float)vertSplit.length - (this.stringHeight() - this.stringHeightSB());
                float xpos = left + (width - textWidth) / 2.0f + this.stringHeightSB();
                for (String v : vertSplit) {
                    if (backgroundColor != null) {
                        Color c = this.getColor();
                        this.setColor(backgroundColor);
                        this.fillRect(xpos - this.stringHeightSB() - 1.0f, top + height / 2.0f - this.stringWidth(v) / 2.0f, this.stringHeightSB() + 2.0f, this.stringWidth(v));
                        this.setColor(c);
                    }
                    this.drawStringVertical(v, xpos, top + height, height, false, true, false);
                    xpos += this.stringHeight();
                }
                return true;
            }
            if (fitsHorz) {
                float textHeight = this.stringHeight() * (float)horzSplit.length - (this.stringHeight() - this.stringHeightSB());
                float textTop = top + (height - textHeight) / 2.0f + this.stringHeightSB();
                for (String h : horzSplit) {
                    if (backgroundColor != null) {
                        Color c = this.getColor();
                        this.setColor(backgroundColor);
                        this.fillRect(left + width / 2.0f - this.stringWidth(h) / 2.0f, textTop - this.stringHeightSB(), this.stringWidth(h), this.stringHeightSB());
                        this.setColor(c);
                    }
                    this.drawString(h, left, textTop, width, 0, true);
                    textTop += this.stringHeight();
                }
                return true;
            }
            this.setFontSize(fontSize -= 0.5f);
        }
        return false;
    }

    public String drawString(String string, float x, float y, float width, float height, StringStrategy strategy, int alignment) {
        x *= SBGraphics.getScale();
        y *= SBGraphics.getScale();
        width *= SBGraphics.getScale();
        height *= SBGraphics.getScale();
        boolean horizontal = strategy.preferHorz;
        boolean action = false;
        boolean nSizeChanges = false;
        int origFontSize = this.getFont().getSize();
        float fontSizeIncrement = 0.5f * SBGraphics.getScale();
        boolean keepTrying = true;
        do {
            Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds(string, this.g);
            double d = stringBounds.getWidth();
            float f = horizontal ? width : height;
            if (!(d < (double)f)) continue;
            this.drawStringBox(new String[]{string}, x, y, width, height, horizontal, alignment);
            return null;
        } while (keepTrying);
        return string;
    }

    private FloatDimension getTextBounds(String[] lines) {
        float maxWidth = 0.0f;
        for (String line : lines) {
            Rectangle2D stringBounds = this.g.getFontMetrics().getStringBounds(line, this.g);
            maxWidth = Math.max(maxWidth, (float)stringBounds.getWidth());
        }
        return new FloatDimension(this, maxWidth, lines.length * this.g.getFontMetrics().getHeight());
    }

    private void drawStringBox(String[] text, float x, float y, float width, float height, boolean horz, int alignment) {
    }

    private ArrayList<String> wrapText(String string, float width) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] s = string.split(" ");
        Object text = "";
        for (String tok : s) {
            if (this.stringWidth((String)text + tok) < width) {
                text = (String)text + tok + " ";
                continue;
            }
            if (this.stringWidth(tok) < width) {
                lines.add(((String)text).trim());
                text = tok + " ";
                continue;
            }
            text = this.addStringLine(lines, (String)text + tok, width);
        }
        if (!((String)text).isEmpty()) {
            lines.add(((String)text).trim());
        }
        return lines;
    }

    public void fillPolygon(float[] x, float[] y, int n, Color fillColor) {
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1))) {
            Color oldColor = this.g.getColor();
            this.setColor(fillColor);
            this.g.fillPolygon(ix, iy, n);
            this.g.setColor(oldColor);
            this.g.drawPolygon(ix, iy, n);
        }
    }

    public void fillPolygon(float[] x, float[] y, int n) {
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1))) {
            this.g.fillPolygon(ix, iy, n);
        }
    }

    public void fillShape(Shape s, Color colour) {
        if (this.visibleRect == null || this.visibleRect.intersects(s.getBounds())) {
            Color c = this.g.getColor();
            this.setColor(colour);
            this.g.fill(s);
            this.g.setColor(c);
        }
    }

    public void drawShape(Shape s) {
        if (this.visibleRect == null || s.intersects(this.visibleRect)) {
            if (this.g.getStroke() instanceof TextStroke && (this.g instanceof PDFGraphics2D || this.g instanceof PdfBoxGraphics2D)) {
                Shape strokeShape = this.g.getStroke().createStrokedShape(s);
                this.g.setStroke(new BasicStroke(1.0f));
                this.g.fill(strokeShape);
            } else {
                this.g.draw(s);
            }
        }
    }

    public void setGradientPaint(Color c1, float p1x, float p1y, Color c2, float p2x, float p2y) {
        GradientPaint gp = new GradientPaint((int)(p1x * SBGraphics.getScale()), (int)(p1y * SBGraphics.getScale()), c1, (int)(p2x * SBGraphics.getScale()), (int)(p2y * SBGraphics.getScale()), c2);
        this.g.setPaint(gp);
    }

    public boolean isVisible(float x, float y, float width, float height) {
        return this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())));
    }

    public boolean isVisible(Rectangle2D.Float rect) {
        return this.isVisible(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    void drawIntersectingPolygons(float[] x1, float[] y1, float[] x2, float[] y2, int n1, int n2) {
        int[] ix1 = new int[n1];
        int[] iy1 = new int[n1];
        for (int i = 0; i < n1; ++i) {
            ix1[i] = (int)(x1[i] * SBGraphics.getScale());
            iy1[i] = (int)(y1[i] * SBGraphics.getScale());
        }
        int[] ix2 = new int[n2];
        int[] iy2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            ix2[i] = (int)(x2[i] * SBGraphics.getScale());
            iy2[i] = (int)(y2[i] * SBGraphics.getScale());
        }
        Polygon p1 = new Polygon(ix1, iy1, n1);
        Area a1 = new Area(p1);
        Polygon p2 = new Polygon(ix2, iy2, n2);
        Area a2 = new Area(p2);
        a1.intersect(a2);
        this.g.setColor(Color.GREEN);
        this.g.fill(a1);
    }

    public void drawPolyline(float[] x, float[] y, int n, boolean visibilityTest) {
        if (n <= 0) {
            return;
        }
        int[] ix = new int[n];
        int[] iy = new int[n];
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < n; ++i) {
            ix[i] = (int)(x[i] * SBGraphics.getScale());
            iy[i] = (int)(y[i] * SBGraphics.getScale());
            if (i == 0) {
                minX = maxX = ix[i];
                minY = maxY = iy[i];
            }
            if (ix[i] < minX) {
                minX = ix[i];
            }
            if (ix[i] > maxX) {
                maxX = ix[i];
            }
            if (iy[i] < minY) {
                minY = iy[i];
            }
            if (iy[i] <= maxY) continue;
            maxY = iy[i];
        }
        if (minX == maxX) {
            --minX;
            ++maxX;
        }
        if (minY == maxY) {
            --minY;
            ++maxY;
        }
        Rectangle rectangle = new Rectangle(minX, minY, maxX - minX - 1, maxY - minY - 1);
        if (!visibilityTest || this.visibleRect == null || this.visibleRect.intersects(rectangle)) {
            this.g.drawPolyline(ix, iy, n);
        }
    }

    public void drawCross(float x, float y, int length) {
        Color color = this.g.getColor();
        this.g.setColor(Color.red);
        this.drawLine(x - (float)length, y, x + (float)length, y);
        this.drawLine(x, y - (float)length, x, y + (float)length);
        this.g.setColor(color);
    }

    public float stringWidth(String string) {
        return (float)this.g.getFontMetrics(this.g.getFont()).stringWidth(string) / SBGraphics.getScale();
    }

    public float stringWidth(AttributedString attString) {
        Object strg = "";
        AttributedCharacterIterator it = attString.getIterator();
        strg = (String)strg + it.first();
        for (int i = it.getBeginIndex(); i < it.getEndIndex() - 1; ++i) {
            strg = (String)strg + it.next();
        }
        it.setIndex(it.getBeginIndex());
        return this.stringWidth((String)strg);
    }

    public static float stringWidth(String string, float fontSize) {
        return (float)string.length() * fontSize * 0.545f;
    }

    public static float stringWidthWithFontMetrics(String string, String fontName, int fontStyle, float fontSize) {
        Font font = new Font(fontName, fontStyle, (int)(fontSize * SBGraphics.getScale()));
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        return (float)fm.stringWidth(string) / SBGraphics.getScale();
    }

    public static float fontHeightWithFontMetrics(String fontName, int fontStyle, float fontSize) {
        Font font = new Font(fontName, fontStyle, (int)(fontSize * SBGraphics.getScale()));
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(font);
        return (float)fm.getHeight() / SBGraphics.getScale();
    }

    public float stringHeight() {
        return (float)this.g.getFontMetrics().getHeight() / SBGraphics.getScale();
    }

    public float stringHeightSB() {
        return (float)this.g.getFontMetrics().getAscent() / SBGraphics.getScale() - (float)this.g.getFontMetrics().getDescent() / SBGraphics.getScale();
    }

    public void fillEllipse(float x, float y, float width, float height, Color fillColor) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            Color oldColor = null;
            if (fillColor != null) {
                oldColor = this.g.getColor();
                this.setColor(fillColor);
            }
            this.g.fillOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
            if (fillColor != null) {
                this.g.setColor(oldColor);
                this.g.drawOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
            }
        }
    }

    public void drawEllipse(float x, float y, float width, float height) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.drawOval((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    public void drawRect(float x, float y, float width, float height) {
        Rectangle r = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(r)) {
            this.g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    public void drawRect(Rectangle2D.Float rect) {
        this.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawArc(float x, float y, float width, float height, int startAngle, int arcAngle) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            this.g.drawArc((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()), startAngle, arcAngle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAndfillRect(Rectangle2D.Float rect, Color lineColour, Color fillColour) {
        if (fillColour == null && lineColour == null) {
            return;
        }
        Rectangle scaledRect = new Rectangle((int)(rect.x * SBGraphics.getScale()), (int)(rect.y * SBGraphics.getScale()), (int)(rect.width * SBGraphics.getScale()), (int)(rect.height * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(scaledRect)) {
            Color oldColor = this.g.getColor();
            try {
                if (fillColour != null) {
                    this.g.setColor(fillColour);
                    this.g.fill(scaledRect);
                }
                if (lineColour != null) {
                    this.g.setColor(lineColour);
                    this.g.draw(scaledRect);
                }
            }
            finally {
                this.g.setColor(oldColor);
            }
        }
    }

    public void fillRect(float x, float y, float width, float height, Color fillColor) {
        if (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale())))) {
            if (fillColor != null) {
                Color oldColor = this.g.getColor();
                this.setColor(fillColor);
                this.g.fillRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
                this.g.setColor(oldColor);
            }
            this.g.drawRect((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        }
    }

    public void fillRect(float x, float y, float width, float height) {
        Rectangle fillRect = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        if (this.visibleRect == null || this.visibleRect.intersects(fillRect)) {
            this.g.fillRect(fillRect.x, fillRect.y, fillRect.width, fillRect.height);
        }
    }

    public void fillRect(Rectangle2D.Float rect) {
        this.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRect(Rectangle2D.Float rect, Color fillColor) {
        this.fillRect(rect.x, rect.y, rect.width, rect.height, fillColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawDottedRect(Rectangle2D.Float rect, float lineWeight, Color c) {
        Stroke old = this.g.getStroke();
        Color oldColor = this.g.getColor();
        try {
            float[] dash2 = new float[]{lineWeight * 100.0f};
            BasicStroke dashed2 = new BasicStroke(lineWeight * 100.0f, 0, 0, lineWeight * 100.0f, dash2, 0.0f);
            this.g.setStroke(dashed2);
            this.g.setColor(c);
            this.g.drawRect((int)(rect.x * SBGraphics.getScale()), (int)(rect.y * SBGraphics.getScale()), (int)(rect.width * SBGraphics.getScale()), (int)(rect.height * SBGraphics.getScale()));
        }
        finally {
            this.g.setStroke(old);
            this.g.setColor(oldColor);
        }
    }

    public void paintRect(float x, float y, float width, float height, Color topColour, Color baseColour) {
        if ((double)height > 0.0 && (this.visibleRect == null || this.visibleRect.intersects(new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()))))) {
            float ix = x * SBGraphics.getScale();
            float iy = y * SBGraphics.getScale();
            float ih = height * SBGraphics.getScale();
            this.g.setPaint(new GradientPaint(ix, iy, topColour, ix, iy + ih, baseColour));
            this.g.fill(new Rectangle2D.Float(ix, iy, width * SBGraphics.getScale(), ih));
        }
    }

    public void setClip(float x, float y, float width, float height) {
        if (x == 0.0f && y == 0.0f && width == 0.0f && height == 0.0f) {
            this.setClip(null);
            return;
        }
        Rectangle rect = new Rectangle((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        this.setClip(rect);
    }

    public void setClip(Shape s) {
        if (s == null) {
            if (this.clip != null) {
                this.g.setClip(this.clip);
            } else {
                this.g.setClip(null);
            }
            this.clip = null;
            return;
        }
        this.clip = this.g.getClip();
        this.g.clip(s);
    }

    public void clearClip() {
        this.g.setClip(this.visibleRect);
        this.clip = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawHighQualityImage(Image img, float x, float y, float width, float height) {
        try {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.g.drawImage(img, (int)(x * 100.0f), (int)(y * 100.0f), (int)(width * 100.0f), (int)(height * 100.0f), null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error drawing image.", e);
        }
        finally {
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            this.g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        }
    }

    public void drawUnscaleImaged(Image img, float mmX, float mmY, float width, float height) {
        int scaledWidth = (int)(width * 100.0f);
        int scaledHeight = (int)(height * 100.0f);
        if (img.getWidth(null) == scaledWidth && img.getHeight(null) == scaledHeight) {
            System.out.println("Drawing image at cached scale");
        } else {
            System.out.println("Drawing image with scaling: " + img.getWidth(null) + "x" + img.getHeight(null) + " to " + scaledWidth + "x" + scaledHeight);
        }
        this.g.drawImage(img, (int)(mmX * 100.0f), (int)(mmY * 100.0f), (int)(width * 100.0f), (int)(height * 100.0f), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Image img, float mmX, float mmY, float mmWidth, float mmHeight) {
        if (this.visibleRect == null) {
            AffineTransform orig = this.g.getTransform();
            try {
                AffineTransform tnf = new AffineTransform();
                tnf.scale(10.0, 10.0);
                this.g.transform(tnf);
                if (img.getHeight(null) == -1 || img.getWidth(null) == -1) {
                    MediaTracker mt = new MediaTracker(new Canvas());
                    mt.addImage(img, 1);
                    try {
                        mt.waitForAll(3000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Exception occurred while waiting for image to load.", e);
                    }
                }
                int imgX = (int)(mmX * 10.0f);
                int imgY = (int)(mmY * 10.0f);
                int imgWidth = (int)(mmWidth * 10.0f);
                int imgHeight = (int)(mmHeight * 10.0f);
                this.g.drawImage(img, imgX, imgY, imgWidth, imgHeight, null);
            }
            finally {
                this.g.setTransform(orig);
            }
        }
        Rectangle scaledRect = new Rectangle((int)(mmX * SBGraphics.getScale()), (int)(mmY * SBGraphics.getScale()), (int)(mmWidth * SBGraphics.getScale()), (int)(mmHeight * SBGraphics.getScale()));
        if (this.visibleRect.intersects(scaledRect)) {
            this.g.drawImage(img, (int)(mmX * SBGraphics.getScale()), (int)(mmY * SBGraphics.getScale()), (int)(mmWidth * SBGraphics.getScale()), (int)(mmHeight * SBGraphics.getScale()), null);
        }
    }

    public void translate(float x, float y) {
        this.g.translate((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()));
    }

    void drawTextArea(String string, float x, float y, float width, float height) {
        Rectangle2D stringRect = this.g.getFontMetrics().getStringBounds(string, this.g);
        Rectangle2D.Float bound = new Rectangle2D.Float(x * SBGraphics.getScale(), y * SBGraphics.getScale(), width * SBGraphics.getScale(), height * SBGraphics.getScale());
        JTextArea ta = new JTextArea(string);
        ta.setBounds((int)(x * SBGraphics.getScale()), (int)(y * SBGraphics.getScale()), (int)(width * SBGraphics.getScale()), (int)(height * SBGraphics.getScale()));
        ta.setVisible(true);
        ta.paint(this.g);
    }

    public Area pointsToArea(float[] xPoints, float[] yPoints, int nPoints) {
        int[] ixPoints = new int[nPoints];
        for (int i = 0; i < ixPoints.length; ++i) {
            ixPoints[i] = (int)(xPoints[i] * SBGraphics.getScale());
        }
        int[] iyPoints = new int[nPoints];
        for (int i = 0; i < iyPoints.length; ++i) {
            iyPoints[i] = (int)(yPoints[i] * SBGraphics.getScale());
        }
        Polygon polygon = new Polygon(ixPoints, iyPoints, nPoints);
        return new Area(polygon);
    }

    public void setGreyscale(boolean greyscale) {
        this.greyscale = greyscale;
    }

    public Rectangle2D.Float drawStringWithinBox(String text, Rectangle2D.Float box, TextLayoutPreferences layout) {
        if (text == null) {
            return new Rectangle2D.Float(box.x, box.y, 0.0f, 0.0f);
        }
        TextArtist ta = new TextArtist(this.g, 100.0f);
        return ta.drawText(text, box, layout);
    }

    public boolean willStringFitWithinBox(String text, Rectangle2D.Float box, TextLayoutPreferences layout) {
        DimensionF dims;
        if (text == null || text.isEmpty()) {
            return true;
        }
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        TextSettings settings = this.getTextSettings(layout);
        DimensionF boxDimensions = new DimensionF(box.width, box.height);
        if (layout.getWrapText()) {
            TextWrapper wrapper = new TextWrapper(m);
            String[] lines = wrapper.wrapText(text, boxDimensions, settings);
            dims = m.calculateTextDimensions(lines, settings);
        } else {
            dims = m.calculateTextDimensions(text, settings);
        }
        return dims.fitsInside(boxDimensions);
    }

    public DimensionF measureText(String[] text, TextLayoutPreferences layout) {
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        return m.calculateTextDimensions(text, this.getTextSettings(layout));
    }

    public DimensionF measureText(String text, TextLayoutPreferences layout) {
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        return m.calculateTextDimensions(text, this.getTextSettings(layout));
    }

    public float calculateLineHeight(TextLayoutPreferences layout) {
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        return m.calculateHorizontalLineHeight(this.getTextSettings(layout).getFont());
    }

    public float calculateLineHeight(SBFont font) {
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        return m.calculateHorizontalLineHeight(font);
    }

    public String[] wrapHorizontalText(String text, float width, TextLayoutPreferences layout) {
        if (layout.getTextDirection() != TextDirection.Horizontal) {
            throw new IllegalArgumentException("Layout must have horizontal text direction.");
        }
        SBTextMeasurer m = new SBTextMeasurer(this.g, 100.0f);
        TextWrapper tw = new TextWrapper(m);
        return tw.wrapText(text, new DimensionF(width, 0.0f), this.getTextSettings(layout));
    }

    public void drawRect(Rectangle2D.Float rect, Color c) {
        Color original = this.g.getColor();
        this.g.setColor(c);
        this.g.drawRect((int)(rect.x * 100.0f), (int)(rect.y * 100.0f), (int)(rect.width * 100.0f), (int)(rect.height * 100.0f));
        this.g.setColor(original);
    }

    private TextSettings getTextSettings(TextLayoutPreferences layout) {
        TextSettings settings = layout.buildSettings();
        return settings;
    }

    public Rectangle2D.Float renderLinesWithinBox(String[] lines, Rectangle2D.Float box, TextSettings settings) {
        TextRenderer renderer = new TextRenderer(this.g, this.getTextMeasurer(), 100.0f);
        return renderer.drawString(lines, box, settings);
    }

    public Rectangle2D.Float renderLinesWithinBox(String line, Rectangle2D.Float box, TextSettings settings) {
        TextRenderer renderer = new TextRenderer(this.g, this.getTextMeasurer(), 100.0f);
        return renderer.drawString(line, box, settings);
    }

    public Rectangle2D.Float calculateRenderArea(String line, Rectangle2D.Float box, TextSettings settings) {
        TextRenderer renderer = new TextRenderer(this.g, this.getTextMeasurer(), 100.0f);
        return renderer.calculateDrawnArea(line, box, settings);
    }

    public Rectangle2D.Float calculateRenderArea(String[] line, Rectangle2D.Float box, TextSettings settings) {
        TextRenderer renderer = new TextRenderer(this.g, this.getTextMeasurer(), 100.0f);
        return renderer.calculateDrawnArea(line, box, settings);
    }

    public ITextMeasurer getTextMeasurer() {
        return new SBTextMeasurer(this.g, 100.0f);
    }

    public void drawHorizontalLineLabel(String labelText, HorizontalAlignment alignment, CorrLineStyle.LabelPosition position, double stroke, Line2D.Float line, Color background) {
        if (position == null) {
            position = CorrLineStyle.LabelPosition.ABOVE;
        }
        if (alignment == null) {
            alignment = HorizontalAlignment.Centre;
        }
        double lineAngle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        double lineLength = line.getP1().distance(line.getP2()) * 100.0;
        int stringWidth = this.g.getFontMetrics(this.g.getFont()).stringWidth(labelText);
        int stringHeight = this.g.getFontMetrics().getAscent() - this.g.getFontMetrics().getDescent();
        double strokeSize = stroke * 100.0;
        double distanceFromTheLine = switch (position) {
            case CorrLineStyle.LabelPosition.ABOVE -> ((double)(stringHeight / 3) + strokeSize) * -1.0;
            case CorrLineStyle.LabelPosition.BELOW -> (double)stringHeight * 1.3 + strokeSize;
            default -> stringHeight / 2;
        };
        double distanceAlongTheLine = 0.0;
        double fixedLeftRightPadding = (double)stringHeight * 0.5;
        double angleShift = Math.abs(Math.tan(lineAngle)) * ((double)stringHeight + ((double)(stringHeight / 3) + strokeSize));
        double centerShift = (lineLength - (double)stringWidth) * 0.5;
        switch (alignment) {
            case Left: {
                distanceAlongTheLine = lineAngle < 0.0 && position == CorrLineStyle.LabelPosition.ABOVE || lineAngle > 0.0 && position == CorrLineStyle.LabelPosition.BELOW ? angleShift + fixedLeftRightPadding : fixedLeftRightPadding;
                if (!(distanceAlongTheLine > centerShift)) break;
                distanceAlongTheLine = centerShift;
                break;
            }
            case Centre: {
                distanceAlongTheLine = centerShift;
                break;
            }
            case Right: {
                distanceAlongTheLine = lineAngle < 0.0 && position == CorrLineStyle.LabelPosition.BELOW || lineAngle > 0.0 && position == CorrLineStyle.LabelPosition.ABOVE ? lineLength - angleShift - (double)stringWidth - fixedLeftRightPadding : lineLength - (double)stringWidth - fixedLeftRightPadding;
                if (!(distanceAlongTheLine < centerShift)) break;
                distanceAlongTheLine = centerShift;
                break;
            }
        }
        AffineTransform transform = new AffineTransform();
        transform.setToTranslation(line.x1 * 100.0f, line.y1 * 100.0f);
        transform.rotate(lineAngle);
        transform.translate(distanceAlongTheLine, distanceFromTheLine);
        FontRenderContext frc = this.g.getFontRenderContext();
        TextLayout tl = new TextLayout(labelText, this.g.getFont(), frc);
        Shape outline = tl.getOutline(transform);
        if (position == CorrLineStyle.LabelPosition.THROUGH) {
            Color c = this.g.getColor();
            this.g.setColor(background);
            this.g.setStroke(new BasicStroke(50.0f, 0, 2));
            this.g.draw(outline);
            this.g.setColor(c);
        }
        this.g.fill(outline);
    }

    public void drawArrow(Line2D.Float line) {
        Color c = this.g.getColor();
        double angle = 0.6981317007977318;
        double arrowLength = 3.0;
        double pointFactor = 0.8;
        double halfAngle = angle * 0.5;
        double barbLength = arrowLength / Math.cos(halfAngle);
        double dx = Math.abs(line.x2 - line.x1);
        double dy = Math.abs(line.y2 - line.y1);
        double lineAngle = Math.atan2(dy, dx);
        boolean topToBottom = line.y1 < line.y2;
        boolean leftToRight = line.x1 < line.x2;
        double hozFactor = 1.0;
        double vertFactor = 1.0;
        if (!topToBottom) {
            vertFactor = -1.0;
        }
        if (!leftToRight) {
            hozFactor = -1.0;
        }
        double startX = (double)line.x2 - hozFactor * Math.cos(lineAngle) * arrowLength * pointFactor;
        double startY = (double)line.y2 - vertFactor * Math.sin(lineAngle) * arrowLength * pointFactor;
        double barbAngle1 = lineAngle + halfAngle;
        double b1x = (double)line.x2 - hozFactor * Math.cos(barbAngle1) * barbLength;
        double b1y = (double)line.y2 - vertFactor * Math.sin(barbAngle1) * barbLength;
        double barbAngle2 = lineAngle - halfAngle;
        double b2x = (double)line.x2 - hozFactor * Math.cos(barbAngle2) * barbLength;
        double b2y = (double)line.y2 - vertFactor * Math.sin(barbAngle2) * barbLength;
        Path2D.Float path = new Path2D.Float();
        path.moveTo(startX * 100.0, startY * 100.0);
        path.lineTo(b1x * 100.0, b1y * 100.0);
        path.lineTo(line.x2 * 100.0f, line.y2 * 100.0f);
        path.lineTo(b2x * 100.0, b2y * 100.0);
        path.lineTo(startX * 100.0, startY * 100.0);
        path.lineTo(line.x1 * 100.0f, line.y1 * 100.0f);
        this.g.draw(path);
        this.g.setColor(Color.WHITE);
        this.g.fill(path);
        this.g.setColor(c);
    }

    public void drawArrowFromBox(Rectangle2D.Float box, Point2D.Float target) {
        this.drawArrowBetweenBoxes(box, new Rectangle2D.Float(target.x, target.y, 0.0f, 0.0f));
    }

    public void drawArrowBetweenBoxes(Rectangle2D.Float annoBox, Rectangle2D.Float target) {
        boolean connectFromLeft = annoBox.x + annoBox.width > target.x;
        boolean connectFromTop = annoBox.y + annoBox.height > target.y;
        Point2D.Float from = new Point2D.Float(annoBox.x, annoBox.y);
        if (connectFromLeft && !connectFromTop) {
            from = new Point2D.Float(annoBox.x, annoBox.y + annoBox.height);
        } else if (!connectFromLeft && connectFromTop) {
            from = new Point2D.Float(annoBox.x + annoBox.width, annoBox.y);
        } else if (!connectFromLeft && !connectFromTop) {
            from = new Point2D.Float(annoBox.x + annoBox.width, annoBox.y + annoBox.height);
        }
        Point2D.Float to = new Point2D.Float(target.x, target.y);
        if (annoBox.x > target.x + target.width) {
            to.x = target.x + target.width;
        } else if (annoBox.x > target.x) {
            to.x = annoBox.x;
        }
        if (annoBox.y > target.y + target.height) {
            to.y = target.y + target.height;
        } else if (annoBox.y > target.y) {
            to.y = annoBox.y;
        }
        this.drawArrow(new Line2D.Float(from, to));
    }

    public void drawCircle(float x, float y, float diameter, Color color) {
        int d = (int)(diameter * 100.0f);
        Color old = this.g.getColor();
        this.g.setColor(color);
        this.g.drawArc((int)(x * 100.0f), (int)(y * 100.0f), d, d, 0, 360);
        this.g.setColor(old);
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public Rectangle scaleRectToInt(float x, float y, float width, float height) {
        return new Rectangle((int)(x * 100.0f), (int)(y * 100.0f), (int)(width * 100.0f), (int)(height * 100.0f));
    }

    public void drawTriangle(float x, float y, CompassDirection direction, float width, Color c) {
        float triangleHeight = (float)(Math.sqrt(3.0) * (double)width) / 2.0f;
        Path2D.Float path = new Path2D.Float();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(-0.5 * (double)width * 100.0, (double)(triangleHeight * 100.0f));
        path.lineTo(0.5 * (double)width * 100.0, (double)(triangleHeight * 100.0f));
        path.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(x * 100.0f, y * 100.0f);
        at.rotate(this.getRotationForDirection(direction));
        path.transform(at);
        this.g.setColor(c);
        this.g.fill(path);
    }

    private double getRotationForDirection(CompassDirection direction) {
        switch (direction) {
            case NORTH: {
                return 0.0;
            }
            case NORTHEAST: {
                return 0.7853981633974483;
            }
            case EAST: {
                return 1.5707963267948966;
            }
            case SOUTHEAST: {
                return 2.356194490192345;
            }
            case SOUTH: {
                return Math.PI;
            }
            case SOUTHWEST: {
                return 3.9269908169872414;
            }
            case WEST: {
                return 4.71238898038469;
            }
            case NORTHWEST: {
                return 5.497787143782138;
            }
        }
        return 0.0;
    }

    private void drawStringInternal(String string, float x, float y) {
        String s = string;
        if (this.g instanceof PdfBoxGraphics2D) {
            s = s.replace("\n", " ");
        }
        this.g.drawString(s, x, y);
    }

    static enum StringStrategy {
        HORIZONTAL_PREF(true, true, true, false, "Prefer horizontal", "Plot horizontally as much as possible by wrapping and changing font size before plotting vertically."),
        HORIZONTAL_ALL(true, true, false, false, "Horizontal", "Fit text horizontally by wrapping and changing font size. Never plot vertically."),
        VERTICAL_PREF(true, false, true, false, "Prefer vertical", "Plot vertically as much as possible by wrapping and changing font size before plotting horizonally."),
        SAME_SIZE_PREF(true, true, true, true, "Prefer Consistent size", "Keep font size as consistent as possible, by wrapping then plotting vertically before changing font size."),
        SAME_SIZE_ALL(false, true, true, true, "Consistent size", "Fit text by wrapping and plotting vertically. Never change font size.");

        boolean allowSizeChange;
        boolean preferHorz;
        boolean allowAltOrientation;
        boolean sizeFirst;
        String shortDesc;
        String longDesc;
        static int nIts;
        static final int SIZE = 1;
        static final int ORIENTATION = 2;

        private StringStrategy(boolean allowSizeChange, boolean preferHorz, boolean allowAltOrientation, boolean sizeFirst, String shortDesc, String longDesc) {
            this.allowSizeChange = allowSizeChange;
            this.preferHorz = preferHorz;
            this.allowAltOrientation = allowAltOrientation;
            this.sizeFirst = sizeFirst;
            this.shortDesc = shortDesc;
            this.longDesc = longDesc;
        }

        int getNextAction(int currentAction) {
            switch (currentAction) {
                case 0: {
                    if (this.sizeFirst) {
                        return 1;
                    }
                    return 2;
                }
                case 1: {
                    if (this.allowAltOrientation) {
                        return 2;
                    }
                    return 1;
                }
                case 2: {
                    if (this.allowSizeChange) {
                        return 1;
                    }
                    return 2;
                }
            }
            throw new IllegalArgumentException("Unrecognised option type in StringStrategy: " + currentAction);
        }

        static {
            nIts = 3;
        }
    }

    private class FloatDimension {
        final float width;
        final float height;

        FloatDimension(SBGraphics sBGraphics, float width, float height) {
            Objects.requireNonNull(sBGraphics);
            this.width = width;
            this.height = height;
        }
    }
}

