/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.parameter.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

public class ColourWellFunction
extends FunctionExpressionImpl {
    private final Map<Integer, Color> colourMap;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    public static FunctionName NAME = new FunctionNameImpl("ColourWellsFunction", Color.class, new Parameter[]{FunctionNameImpl.parameter((String)"well_id", Integer.class)});

    public ColourWellFunction(Map<Integer, Color> colourMap) {
        super(NAME);
        this.colourMap = colourMap;
    }

    public int getArgCount() {
        return 0;
    }

    public Object evaluate(Object feature) {
        SimpleFeature f = (SimpleFeature)feature;
        Integer well_id = (Integer)f.getAttribute("well_id");
        if (well_id == null || !this.colourMap.keySet().contains(well_id)) {
            return Color.BLACK;
        }
        return this.colourMap.get(well_id);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        if (visitor instanceof DuplicatingFilterVisitor) {
            return new ColourWellFunction(this.colourMap);
        }
        if (visitor instanceof FilterAttributeExtractor) {
            FilterAttributeExtractor ev = (FilterAttributeExtractor)visitor;
            PropertyName p = this.ff.property("well_id");
            return ev.visit(p, extraData);
        }
        return super.accept(visitor, extraData);
    }
}

