/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;

public enum CrsCode {
    WGS84,
    MERCATOR,
    UTM,
    UK_GRID;


    public String getCode(ReferencedEnvelope e) {
        return switch (this.ordinal()) {
            case 0 -> "EPSG:4326";
            default -> "EPSG:4326";
            case 1 -> "EPSG:3785";
            case 3 -> "EPSG:27700";
            case 2 -> this.getUTMCode(e);
        };
    }

    private String getUTMCode(ReferencedEnvelope e) {
        if (e != null) {
            try {
                ReferencedEnvelope transformed = e.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                Coordinate c = transformed.centre();
                StringBuilder sb = new StringBuilder("EPSG:32");
                if (c.y >= 0.0) {
                    sb.append("6");
                } else {
                    sb.append("7");
                }
                sb.append(String.format("%02d", this.getUTMZoneNum(c)));
                return sb.toString();
            }
            catch (FactoryException | TransformException ex) {
                Logger.getLogger(CrsCode.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return "EPSG:32631";
    }

    public ReferencedEnvelope getMaxBounds(ReferencedEnvelope e) {
        return switch (this.ordinal()) {
            case 0 -> new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            default -> new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            case 1 -> new ReferencedEnvelope(-179.9, 179.9, -85.0, 85.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            case 2 -> this.getUTMBounds(e);
            case 3 -> new ReferencedEnvelope(-20.0, 20.0, 30.0, 70.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        };
    }

    private ReferencedEnvelope getUTMBounds(ReferencedEnvelope e) {
        try {
            double latMax;
            double latMin;
            ReferencedEnvelope transformed = e.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            Coordinate c = transformed.centre();
            if (c.y >= 0.0) {
                latMin = 0.0;
                latMax = 84.0;
            } else {
                latMin = -80.0;
                latMax = 0.0;
            }
            int zone = this.getUTMZoneNum(c);
            double lonMin = (double)(zone - 1) * 6.0 - 180.0;
            double lonMax = (double)zone * 6.0 - 180.0;
            lonMin -= 6.0;
            lonMax += 6.0;
            if (lonMin < -180.0) {
                lonMin = -180.0;
            }
            if (lonMax > 180.0) {
                lonMax = 180.0;
            }
            return new ReferencedEnvelope(lonMin, lonMax, latMin, latMax, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        catch (MismatchedDimensionException | FactoryException | TransformException ex) {
            Logger.getLogger(CrsCode.class.getName()).log(Level.SEVERE, null, ex);
            return new ReferencedEnvelope(-6.0, 12.0, 0.0, 84.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
    }

    private int getUTMZoneNum(Coordinate c) {
        double x = c.x + 180.0;
        int zone = (int)(x / 6.0) + 1;
        if (zone > 60) {
            zone = 60;
        }
        return zone;
    }
}

