/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlock;
import jsbchart.core.PanelOcc;
import jsbchart.panel.spatial.LayerShape;
import jsbchart.panel.spatial.SBShapeStore;
import org.apache.commons.io.FilenameUtils;

public class DefaultMapLayerBuilder {
    private static final Logger LOGGER = Logger.getLogger(DefaultMapLayerBuilder.class.getName());

    public static LayerShape buildDefaultMapLayerShape(MapBlock block, Color fillColour) {
        PanelOcc p = new PanelOcc(-1);
        LayerShape ls = new LayerShape(null, p, block);
        DefaultMapLayerBuilder newBuilder = new DefaultMapLayerBuilder();
        try {
            newBuilder.copyDefaultMapShapefileToTempDirectory();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading WellSelectionMapJPanel background shapefile.", e);
        }
        SBShapeStore store = SBShapeStore.createShapeStore(SBShapeStore.StoreType.FILE, "map_low_res", "ne_110m_admin_0_countries", true);
        ls.getProperties().setProperty(0, store);
        ls.getProperties().setProperty(1, "ne_110m_admin_0_countries");
        ls.getProperties().setProperty(2, Color.black);
        ls.getProperties().setProperty(3, fillColour);
        return ls;
    }

    private void copyDefaultMapShapefileToTempDirectory() throws IOException {
        File shapeFileDir;
        String pathToShapefile = this.getClass().getResource("/ne_110m_admin_0_countries/ne_110m_admin_0_countries.shp").getPath();
        File shapeFile = new File(pathToShapefile);
        String name = shapeFile.getName();
        File sourceDir = shapeFile.getParentFile();
        String baseName = FilenameUtils.getBaseName((String)name);
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempShapeFileDir = new File(tempDir, "sbugs_shapefiles");
        if (!tempShapeFileDir.exists()) {
            tempShapeFileDir.mkdir();
        }
        if ((shapeFileDir = new File(tempShapeFileDir, baseName)).exists()) {
            File shpFile = new File(shapeFileDir, baseName + ".shp");
            if (shpFile.exists()) {
                LOGGER.log(Level.INFO, "Temporary directory already exists for shapefile: {0}", shapeFileDir.getPath());
                return;
            }
            shapeFileDir.delete();
        }
        shapeFileDir.mkdir();
        this.copyShapefileFromJarToTempDirectory("/ne_110m_admin_0_countries/", "ne_110m_admin_0_countries", shapeFileDir);
    }

    private void copyShapefileFromJarToTempDirectory(String resourceFolder, String shapefileName, File destinationDirectory) throws IOException {
        String[] extensions;
        for (String e : extensions = new String[]{".cpg", ".dbf", ".prj", ".qix", ".shp", ".shx"}) {
            String resourceString = resourceFolder + shapefileName + e;
            InputStream stream = this.getClass().getResourceAsStream(resourceString);
            if (stream == null) continue;
            File outputFile = new File(destinationDirectory, shapefileName + e);
            Files.copy(stream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

